use core::convert::From;
impl From<u32> for arm_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => arm_insn::ARM_INS_INVALID,
            1 => arm_insn::ARM_INS_ADC,
            2 => arm_insn::ARM_INS_ADD,
            3 => arm_insn::ARM_INS_ADDW,
            4 => arm_insn::ARM_INS_ADR,
            5 => arm_insn::ARM_INS_AESD,
            6 => arm_insn::ARM_INS_AESE,
            7 => arm_insn::ARM_INS_AESIMC,
            8 => arm_insn::ARM_INS_AESMC,
            9 => arm_insn::ARM_INS_AND,
            10 => arm_insn::ARM_INS_ASR,
            11 => arm_insn::ARM_INS_B,
            12 => arm_insn::ARM_INS_BFC,
            13 => arm_insn::ARM_INS_BFI,
            14 => arm_insn::ARM_INS_BIC,
            15 => arm_insn::ARM_INS_BKPT,
            16 => arm_insn::ARM_INS_BL,
            17 => arm_insn::ARM_INS_BLX,
            18 => arm_insn::ARM_INS_BLXNS,
            19 => arm_insn::ARM_INS_BX,
            20 => arm_insn::ARM_INS_BXJ,
            21 => arm_insn::ARM_INS_BXNS,
            22 => arm_insn::ARM_INS_CBNZ,
            23 => arm_insn::ARM_INS_CBZ,
            24 => arm_insn::ARM_INS_CDP,
            25 => arm_insn::ARM_INS_CDP2,
            26 => arm_insn::ARM_INS_CLREX,
            27 => arm_insn::ARM_INS_CLZ,
            28 => arm_insn::ARM_INS_CMN,
            29 => arm_insn::ARM_INS_CMP,
            30 => arm_insn::ARM_INS_CPS,
            31 => arm_insn::ARM_INS_CRC32B,
            32 => arm_insn::ARM_INS_CRC32CB,
            33 => arm_insn::ARM_INS_CRC32CH,
            34 => arm_insn::ARM_INS_CRC32CW,
            35 => arm_insn::ARM_INS_CRC32H,
            36 => arm_insn::ARM_INS_CRC32W,
            37 => arm_insn::ARM_INS_CSDB,
            38 => arm_insn::ARM_INS_DBG,
            39 => arm_insn::ARM_INS_DCPS1,
            40 => arm_insn::ARM_INS_DCPS2,
            41 => arm_insn::ARM_INS_DCPS3,
            42 => arm_insn::ARM_INS_DFB,
            43 => arm_insn::ARM_INS_DMB,
            44 => arm_insn::ARM_INS_DSB,
            45 => arm_insn::ARM_INS_EOR,
            46 => arm_insn::ARM_INS_ERET,
            47 => arm_insn::ARM_INS_ESB,
            48 => arm_insn::ARM_INS_FADDD,
            49 => arm_insn::ARM_INS_FADDS,
            50 => arm_insn::ARM_INS_FCMPZD,
            51 => arm_insn::ARM_INS_FCMPZS,
            52 => arm_insn::ARM_INS_FCONSTD,
            53 => arm_insn::ARM_INS_FCONSTS,
            54 => arm_insn::ARM_INS_FLDMDBX,
            55 => arm_insn::ARM_INS_FLDMIAX,
            56 => arm_insn::ARM_INS_FMDHR,
            57 => arm_insn::ARM_INS_FMDLR,
            58 => arm_insn::ARM_INS_FMSTAT,
            59 => arm_insn::ARM_INS_FSTMDBX,
            60 => arm_insn::ARM_INS_FSTMIAX,
            61 => arm_insn::ARM_INS_FSUBD,
            62 => arm_insn::ARM_INS_FSUBS,
            63 => arm_insn::ARM_INS_HINT,
            64 => arm_insn::ARM_INS_HLT,
            65 => arm_insn::ARM_INS_HVC,
            66 => arm_insn::ARM_INS_ISB,
            67 => arm_insn::ARM_INS_IT,
            68 => arm_insn::ARM_INS_LDA,
            69 => arm_insn::ARM_INS_LDAB,
            70 => arm_insn::ARM_INS_LDAEX,
            71 => arm_insn::ARM_INS_LDAEXB,
            72 => arm_insn::ARM_INS_LDAEXD,
            73 => arm_insn::ARM_INS_LDAEXH,
            74 => arm_insn::ARM_INS_LDAH,
            75 => arm_insn::ARM_INS_LDC,
            76 => arm_insn::ARM_INS_LDC2,
            77 => arm_insn::ARM_INS_LDC2L,
            78 => arm_insn::ARM_INS_LDCL,
            79 => arm_insn::ARM_INS_LDM,
            80 => arm_insn::ARM_INS_LDMDA,
            81 => arm_insn::ARM_INS_LDMDB,
            82 => arm_insn::ARM_INS_LDMIB,
            83 => arm_insn::ARM_INS_LDR,
            84 => arm_insn::ARM_INS_LDRB,
            85 => arm_insn::ARM_INS_LDRBT,
            86 => arm_insn::ARM_INS_LDRD,
            87 => arm_insn::ARM_INS_LDREX,
            88 => arm_insn::ARM_INS_LDREXB,
            89 => arm_insn::ARM_INS_LDREXD,
            90 => arm_insn::ARM_INS_LDREXH,
            91 => arm_insn::ARM_INS_LDRH,
            92 => arm_insn::ARM_INS_LDRHT,
            93 => arm_insn::ARM_INS_LDRSB,
            94 => arm_insn::ARM_INS_LDRSBT,
            95 => arm_insn::ARM_INS_LDRSH,
            96 => arm_insn::ARM_INS_LDRSHT,
            97 => arm_insn::ARM_INS_LDRT,
            98 => arm_insn::ARM_INS_LSL,
            99 => arm_insn::ARM_INS_LSR,
            100 => arm_insn::ARM_INS_MCR,
            101 => arm_insn::ARM_INS_MCR2,
            102 => arm_insn::ARM_INS_MCRR,
            103 => arm_insn::ARM_INS_MCRR2,
            104 => arm_insn::ARM_INS_MLA,
            105 => arm_insn::ARM_INS_MLS,
            106 => arm_insn::ARM_INS_MOV,
            107 => arm_insn::ARM_INS_MOVS,
            108 => arm_insn::ARM_INS_MOVT,
            109 => arm_insn::ARM_INS_MOVW,
            110 => arm_insn::ARM_INS_MRC,
            111 => arm_insn::ARM_INS_MRC2,
            112 => arm_insn::ARM_INS_MRRC,
            113 => arm_insn::ARM_INS_MRRC2,
            114 => arm_insn::ARM_INS_MRS,
            115 => arm_insn::ARM_INS_MSR,
            116 => arm_insn::ARM_INS_MUL,
            117 => arm_insn::ARM_INS_MVN,
            118 => arm_insn::ARM_INS_NEG,
            119 => arm_insn::ARM_INS_NOP,
            120 => arm_insn::ARM_INS_ORN,
            121 => arm_insn::ARM_INS_ORR,
            122 => arm_insn::ARM_INS_PKHBT,
            123 => arm_insn::ARM_INS_PKHTB,
            124 => arm_insn::ARM_INS_PLD,
            125 => arm_insn::ARM_INS_PLDW,
            126 => arm_insn::ARM_INS_PLI,
            127 => arm_insn::ARM_INS_POP,
            128 => arm_insn::ARM_INS_PUSH,
            129 => arm_insn::ARM_INS_QADD,
            130 => arm_insn::ARM_INS_QADD16,
            131 => arm_insn::ARM_INS_QADD8,
            132 => arm_insn::ARM_INS_QASX,
            133 => arm_insn::ARM_INS_QDADD,
            134 => arm_insn::ARM_INS_QDSUB,
            135 => arm_insn::ARM_INS_QSAX,
            136 => arm_insn::ARM_INS_QSUB,
            137 => arm_insn::ARM_INS_QSUB16,
            138 => arm_insn::ARM_INS_QSUB8,
            139 => arm_insn::ARM_INS_RBIT,
            140 => arm_insn::ARM_INS_REV,
            141 => arm_insn::ARM_INS_REV16,
            142 => arm_insn::ARM_INS_REVSH,
            143 => arm_insn::ARM_INS_RFEDA,
            144 => arm_insn::ARM_INS_RFEDB,
            145 => arm_insn::ARM_INS_RFEIA,
            146 => arm_insn::ARM_INS_RFEIB,
            147 => arm_insn::ARM_INS_ROR,
            148 => arm_insn::ARM_INS_RRX,
            149 => arm_insn::ARM_INS_RSB,
            150 => arm_insn::ARM_INS_RSC,
            151 => arm_insn::ARM_INS_SADD16,
            152 => arm_insn::ARM_INS_SADD8,
            153 => arm_insn::ARM_INS_SASX,
            154 => arm_insn::ARM_INS_SBC,
            155 => arm_insn::ARM_INS_SBFX,
            156 => arm_insn::ARM_INS_SDIV,
            157 => arm_insn::ARM_INS_SEL,
            158 => arm_insn::ARM_INS_SETEND,
            159 => arm_insn::ARM_INS_SETPAN,
            160 => arm_insn::ARM_INS_SEV,
            161 => arm_insn::ARM_INS_SEVL,
            162 => arm_insn::ARM_INS_SG,
            163 => arm_insn::ARM_INS_SHA1C,
            164 => arm_insn::ARM_INS_SHA1H,
            165 => arm_insn::ARM_INS_SHA1M,
            166 => arm_insn::ARM_INS_SHA1P,
            167 => arm_insn::ARM_INS_SHA1SU0,
            168 => arm_insn::ARM_INS_SHA1SU1,
            169 => arm_insn::ARM_INS_SHA256H,
            170 => arm_insn::ARM_INS_SHA256H2,
            171 => arm_insn::ARM_INS_SHA256SU0,
            172 => arm_insn::ARM_INS_SHA256SU1,
            173 => arm_insn::ARM_INS_SHADD16,
            174 => arm_insn::ARM_INS_SHADD8,
            175 => arm_insn::ARM_INS_SHASX,
            176 => arm_insn::ARM_INS_SHSAX,
            177 => arm_insn::ARM_INS_SHSUB16,
            178 => arm_insn::ARM_INS_SHSUB8,
            179 => arm_insn::ARM_INS_SMC,
            180 => arm_insn::ARM_INS_SMLABB,
            181 => arm_insn::ARM_INS_SMLABT,
            182 => arm_insn::ARM_INS_SMLAD,
            183 => arm_insn::ARM_INS_SMLADX,
            184 => arm_insn::ARM_INS_SMLAL,
            185 => arm_insn::ARM_INS_SMLALBB,
            186 => arm_insn::ARM_INS_SMLALBT,
            187 => arm_insn::ARM_INS_SMLALD,
            188 => arm_insn::ARM_INS_SMLALDX,
            189 => arm_insn::ARM_INS_SMLALTB,
            190 => arm_insn::ARM_INS_SMLALTT,
            191 => arm_insn::ARM_INS_SMLATB,
            192 => arm_insn::ARM_INS_SMLATT,
            193 => arm_insn::ARM_INS_SMLAWB,
            194 => arm_insn::ARM_INS_SMLAWT,
            195 => arm_insn::ARM_INS_SMLSD,
            196 => arm_insn::ARM_INS_SMLSDX,
            197 => arm_insn::ARM_INS_SMLSLD,
            198 => arm_insn::ARM_INS_SMLSLDX,
            199 => arm_insn::ARM_INS_SMMLA,
            200 => arm_insn::ARM_INS_SMMLAR,
            201 => arm_insn::ARM_INS_SMMLS,
            202 => arm_insn::ARM_INS_SMMLSR,
            203 => arm_insn::ARM_INS_SMMUL,
            204 => arm_insn::ARM_INS_SMMULR,
            205 => arm_insn::ARM_INS_SMUAD,
            206 => arm_insn::ARM_INS_SMUADX,
            207 => arm_insn::ARM_INS_SMULBB,
            208 => arm_insn::ARM_INS_SMULBT,
            209 => arm_insn::ARM_INS_SMULL,
            210 => arm_insn::ARM_INS_SMULTB,
            211 => arm_insn::ARM_INS_SMULTT,
            212 => arm_insn::ARM_INS_SMULWB,
            213 => arm_insn::ARM_INS_SMULWT,
            214 => arm_insn::ARM_INS_SMUSD,
            215 => arm_insn::ARM_INS_SMUSDX,
            216 => arm_insn::ARM_INS_SRSDA,
            217 => arm_insn::ARM_INS_SRSDB,
            218 => arm_insn::ARM_INS_SRSIA,
            219 => arm_insn::ARM_INS_SRSIB,
            220 => arm_insn::ARM_INS_SSAT,
            221 => arm_insn::ARM_INS_SSAT16,
            222 => arm_insn::ARM_INS_SSAX,
            223 => arm_insn::ARM_INS_SSUB16,
            224 => arm_insn::ARM_INS_SSUB8,
            225 => arm_insn::ARM_INS_STC,
            226 => arm_insn::ARM_INS_STC2,
            227 => arm_insn::ARM_INS_STC2L,
            228 => arm_insn::ARM_INS_STCL,
            229 => arm_insn::ARM_INS_STL,
            230 => arm_insn::ARM_INS_STLB,
            231 => arm_insn::ARM_INS_STLEX,
            232 => arm_insn::ARM_INS_STLEXB,
            233 => arm_insn::ARM_INS_STLEXD,
            234 => arm_insn::ARM_INS_STLEXH,
            235 => arm_insn::ARM_INS_STLH,
            236 => arm_insn::ARM_INS_STM,
            237 => arm_insn::ARM_INS_STMDA,
            238 => arm_insn::ARM_INS_STMDB,
            239 => arm_insn::ARM_INS_STMIB,
            240 => arm_insn::ARM_INS_STR,
            241 => arm_insn::ARM_INS_STRB,
            242 => arm_insn::ARM_INS_STRBT,
            243 => arm_insn::ARM_INS_STRD,
            244 => arm_insn::ARM_INS_STREX,
            245 => arm_insn::ARM_INS_STREXB,
            246 => arm_insn::ARM_INS_STREXD,
            247 => arm_insn::ARM_INS_STREXH,
            248 => arm_insn::ARM_INS_STRH,
            249 => arm_insn::ARM_INS_STRHT,
            250 => arm_insn::ARM_INS_STRT,
            251 => arm_insn::ARM_INS_SUB,
            252 => arm_insn::ARM_INS_SUBS,
            253 => arm_insn::ARM_INS_SUBW,
            254 => arm_insn::ARM_INS_SVC,
            255 => arm_insn::ARM_INS_SWP,
            256 => arm_insn::ARM_INS_SWPB,
            257 => arm_insn::ARM_INS_SXTAB,
            258 => arm_insn::ARM_INS_SXTAB16,
            259 => arm_insn::ARM_INS_SXTAH,
            260 => arm_insn::ARM_INS_SXTB,
            261 => arm_insn::ARM_INS_SXTB16,
            262 => arm_insn::ARM_INS_SXTH,
            263 => arm_insn::ARM_INS_TBB,
            264 => arm_insn::ARM_INS_TBH,
            265 => arm_insn::ARM_INS_TEQ,
            266 => arm_insn::ARM_INS_TRAP,
            267 => arm_insn::ARM_INS_TSB,
            268 => arm_insn::ARM_INS_TST,
            269 => arm_insn::ARM_INS_TT,
            270 => arm_insn::ARM_INS_TTA,
            271 => arm_insn::ARM_INS_TTAT,
            272 => arm_insn::ARM_INS_TTT,
            273 => arm_insn::ARM_INS_UADD16,
            274 => arm_insn::ARM_INS_UADD8,
            275 => arm_insn::ARM_INS_UASX,
            276 => arm_insn::ARM_INS_UBFX,
            277 => arm_insn::ARM_INS_UDF,
            278 => arm_insn::ARM_INS_UDIV,
            279 => arm_insn::ARM_INS_UHADD16,
            280 => arm_insn::ARM_INS_UHADD8,
            281 => arm_insn::ARM_INS_UHASX,
            282 => arm_insn::ARM_INS_UHSAX,
            283 => arm_insn::ARM_INS_UHSUB16,
            284 => arm_insn::ARM_INS_UHSUB8,
            285 => arm_insn::ARM_INS_UMAAL,
            286 => arm_insn::ARM_INS_UMLAL,
            287 => arm_insn::ARM_INS_UMULL,
            288 => arm_insn::ARM_INS_UQADD16,
            289 => arm_insn::ARM_INS_UQADD8,
            290 => arm_insn::ARM_INS_UQASX,
            291 => arm_insn::ARM_INS_UQSAX,
            292 => arm_insn::ARM_INS_UQSUB16,
            293 => arm_insn::ARM_INS_UQSUB8,
            294 => arm_insn::ARM_INS_USAD8,
            295 => arm_insn::ARM_INS_USADA8,
            296 => arm_insn::ARM_INS_USAT,
            297 => arm_insn::ARM_INS_USAT16,
            298 => arm_insn::ARM_INS_USAX,
            299 => arm_insn::ARM_INS_USUB16,
            300 => arm_insn::ARM_INS_USUB8,
            301 => arm_insn::ARM_INS_UXTAB,
            302 => arm_insn::ARM_INS_UXTAB16,
            303 => arm_insn::ARM_INS_UXTAH,
            304 => arm_insn::ARM_INS_UXTB,
            305 => arm_insn::ARM_INS_UXTB16,
            306 => arm_insn::ARM_INS_UXTH,
            307 => arm_insn::ARM_INS_VABA,
            308 => arm_insn::ARM_INS_VABAL,
            309 => arm_insn::ARM_INS_VABD,
            310 => arm_insn::ARM_INS_VABDL,
            311 => arm_insn::ARM_INS_VABS,
            312 => arm_insn::ARM_INS_VACGE,
            313 => arm_insn::ARM_INS_VACGT,
            314 => arm_insn::ARM_INS_VACLE,
            315 => arm_insn::ARM_INS_VACLT,
            316 => arm_insn::ARM_INS_VADD,
            317 => arm_insn::ARM_INS_VADDHN,
            318 => arm_insn::ARM_INS_VADDL,
            319 => arm_insn::ARM_INS_VADDW,
            320 => arm_insn::ARM_INS_VAND,
            321 => arm_insn::ARM_INS_VBIC,
            322 => arm_insn::ARM_INS_VBIF,
            323 => arm_insn::ARM_INS_VBIT,
            324 => arm_insn::ARM_INS_VBSL,
            325 => arm_insn::ARM_INS_VCADD,
            326 => arm_insn::ARM_INS_VCEQ,
            327 => arm_insn::ARM_INS_VCGE,
            328 => arm_insn::ARM_INS_VCGT,
            329 => arm_insn::ARM_INS_VCLE,
            330 => arm_insn::ARM_INS_VCLS,
            331 => arm_insn::ARM_INS_VCLT,
            332 => arm_insn::ARM_INS_VCLZ,
            333 => arm_insn::ARM_INS_VCMLA,
            334 => arm_insn::ARM_INS_VCMP,
            335 => arm_insn::ARM_INS_VCMPE,
            336 => arm_insn::ARM_INS_VCNT,
            337 => arm_insn::ARM_INS_VCVT,
            338 => arm_insn::ARM_INS_VCVTA,
            339 => arm_insn::ARM_INS_VCVTB,
            340 => arm_insn::ARM_INS_VCVTM,
            341 => arm_insn::ARM_INS_VCVTN,
            342 => arm_insn::ARM_INS_VCVTP,
            343 => arm_insn::ARM_INS_VCVTR,
            344 => arm_insn::ARM_INS_VCVTT,
            345 => arm_insn::ARM_INS_VDIV,
            346 => arm_insn::ARM_INS_VDUP,
            347 => arm_insn::ARM_INS_VEOR,
            348 => arm_insn::ARM_INS_VEXT,
            349 => arm_insn::ARM_INS_VFMA,
            350 => arm_insn::ARM_INS_VFMS,
            351 => arm_insn::ARM_INS_VFNMA,
            352 => arm_insn::ARM_INS_VFNMS,
            353 => arm_insn::ARM_INS_VHADD,
            354 => arm_insn::ARM_INS_VHSUB,
            355 => arm_insn::ARM_INS_VINS,
            356 => arm_insn::ARM_INS_VJCVT,
            357 => arm_insn::ARM_INS_VLD1,
            358 => arm_insn::ARM_INS_VLD2,
            359 => arm_insn::ARM_INS_VLD3,
            360 => arm_insn::ARM_INS_VLD4,
            361 => arm_insn::ARM_INS_VLDMDB,
            362 => arm_insn::ARM_INS_VLDMIA,
            363 => arm_insn::ARM_INS_VLDR,
            364 => arm_insn::ARM_INS_VLLDM,
            365 => arm_insn::ARM_INS_VLSTM,
            366 => arm_insn::ARM_INS_VMAX,
            367 => arm_insn::ARM_INS_VMAXNM,
            368 => arm_insn::ARM_INS_VMIN,
            369 => arm_insn::ARM_INS_VMINNM,
            370 => arm_insn::ARM_INS_VMLA,
            371 => arm_insn::ARM_INS_VMLAL,
            372 => arm_insn::ARM_INS_VMLS,
            373 => arm_insn::ARM_INS_VMLSL,
            374 => arm_insn::ARM_INS_VMOV,
            375 => arm_insn::ARM_INS_VMOVL,
            376 => arm_insn::ARM_INS_VMOVN,
            377 => arm_insn::ARM_INS_VMOVX,
            378 => arm_insn::ARM_INS_VMRS,
            379 => arm_insn::ARM_INS_VMSR,
            380 => arm_insn::ARM_INS_VMUL,
            381 => arm_insn::ARM_INS_VMULL,
            382 => arm_insn::ARM_INS_VMVN,
            383 => arm_insn::ARM_INS_VNEG,
            384 => arm_insn::ARM_INS_VNMLA,
            385 => arm_insn::ARM_INS_VNMLS,
            386 => arm_insn::ARM_INS_VNMUL,
            387 => arm_insn::ARM_INS_VORN,
            388 => arm_insn::ARM_INS_VORR,
            389 => arm_insn::ARM_INS_VPADAL,
            390 => arm_insn::ARM_INS_VPADD,
            391 => arm_insn::ARM_INS_VPADDL,
            392 => arm_insn::ARM_INS_VPMAX,
            393 => arm_insn::ARM_INS_VPMIN,
            394 => arm_insn::ARM_INS_VPOP,
            395 => arm_insn::ARM_INS_VPUSH,
            396 => arm_insn::ARM_INS_VQABS,
            397 => arm_insn::ARM_INS_VQADD,
            398 => arm_insn::ARM_INS_VQDMLAL,
            399 => arm_insn::ARM_INS_VQDMLSL,
            400 => arm_insn::ARM_INS_VQDMULH,
            401 => arm_insn::ARM_INS_VQDMULL,
            402 => arm_insn::ARM_INS_VQMOVN,
            403 => arm_insn::ARM_INS_VQMOVUN,
            404 => arm_insn::ARM_INS_VQNEG,
            405 => arm_insn::ARM_INS_VQRDMLAH,
            406 => arm_insn::ARM_INS_VQRDMLSH,
            407 => arm_insn::ARM_INS_VQRDMULH,
            408 => arm_insn::ARM_INS_VQRSHL,
            409 => arm_insn::ARM_INS_VQRSHRN,
            410 => arm_insn::ARM_INS_VQRSHRUN,
            411 => arm_insn::ARM_INS_VQSHL,
            412 => arm_insn::ARM_INS_VQSHLU,
            413 => arm_insn::ARM_INS_VQSHRN,
            414 => arm_insn::ARM_INS_VQSHRUN,
            415 => arm_insn::ARM_INS_VQSUB,
            416 => arm_insn::ARM_INS_VRADDHN,
            417 => arm_insn::ARM_INS_VRECPE,
            418 => arm_insn::ARM_INS_VRECPS,
            419 => arm_insn::ARM_INS_VREV16,
            420 => arm_insn::ARM_INS_VREV32,
            421 => arm_insn::ARM_INS_VREV64,
            422 => arm_insn::ARM_INS_VRHADD,
            423 => arm_insn::ARM_INS_VRINTA,
            424 => arm_insn::ARM_INS_VRINTM,
            425 => arm_insn::ARM_INS_VRINTN,
            426 => arm_insn::ARM_INS_VRINTP,
            427 => arm_insn::ARM_INS_VRINTR,
            428 => arm_insn::ARM_INS_VRINTX,
            429 => arm_insn::ARM_INS_VRINTZ,
            430 => arm_insn::ARM_INS_VRSHL,
            431 => arm_insn::ARM_INS_VRSHR,
            432 => arm_insn::ARM_INS_VRSHRN,
            433 => arm_insn::ARM_INS_VRSQRTE,
            434 => arm_insn::ARM_INS_VRSQRTS,
            435 => arm_insn::ARM_INS_VRSRA,
            436 => arm_insn::ARM_INS_VRSUBHN,
            437 => arm_insn::ARM_INS_VSDOT,
            438 => arm_insn::ARM_INS_VSELEQ,
            439 => arm_insn::ARM_INS_VSELGE,
            440 => arm_insn::ARM_INS_VSELGT,
            441 => arm_insn::ARM_INS_VSELVS,
            442 => arm_insn::ARM_INS_VSHL,
            443 => arm_insn::ARM_INS_VSHLL,
            444 => arm_insn::ARM_INS_VSHR,
            445 => arm_insn::ARM_INS_VSHRN,
            446 => arm_insn::ARM_INS_VSLI,
            447 => arm_insn::ARM_INS_VSQRT,
            448 => arm_insn::ARM_INS_VSRA,
            449 => arm_insn::ARM_INS_VSRI,
            450 => arm_insn::ARM_INS_VST1,
            451 => arm_insn::ARM_INS_VST2,
            452 => arm_insn::ARM_INS_VST3,
            453 => arm_insn::ARM_INS_VST4,
            454 => arm_insn::ARM_INS_VSTMDB,
            455 => arm_insn::ARM_INS_VSTMIA,
            456 => arm_insn::ARM_INS_VSTR,
            457 => arm_insn::ARM_INS_VSUB,
            458 => arm_insn::ARM_INS_VSUBHN,
            459 => arm_insn::ARM_INS_VSUBL,
            460 => arm_insn::ARM_INS_VSUBW,
            461 => arm_insn::ARM_INS_VSWP,
            462 => arm_insn::ARM_INS_VTBL,
            463 => arm_insn::ARM_INS_VTBX,
            464 => arm_insn::ARM_INS_VTRN,
            465 => arm_insn::ARM_INS_VTST,
            466 => arm_insn::ARM_INS_VUDOT,
            467 => arm_insn::ARM_INS_VUZP,
            468 => arm_insn::ARM_INS_VZIP,
            469 => arm_insn::ARM_INS_WFE,
            470 => arm_insn::ARM_INS_WFI,
            471 => arm_insn::ARM_INS_YIELD,
            472 => arm_insn::ARM_INS_ENDING,
            _ => arm_insn::ARM_INS_INVALID,
        }
    }
}
impl From<u32> for arm64_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => arm64_insn::ARM64_INS_INVALID,
            1 => arm64_insn::ARM64_INS_ABS,
            2 => arm64_insn::ARM64_INS_ADC,
            3 => arm64_insn::ARM64_INS_ADCS,
            4 => arm64_insn::ARM64_INS_ADD,
            5 => arm64_insn::ARM64_INS_ADDHN,
            6 => arm64_insn::ARM64_INS_ADDHN2,
            7 => arm64_insn::ARM64_INS_ADDP,
            8 => arm64_insn::ARM64_INS_ADDPL,
            9 => arm64_insn::ARM64_INS_ADDS,
            10 => arm64_insn::ARM64_INS_ADDV,
            11 => arm64_insn::ARM64_INS_ADDVL,
            12 => arm64_insn::ARM64_INS_ADR,
            13 => arm64_insn::ARM64_INS_ADRP,
            14 => arm64_insn::ARM64_INS_AESD,
            15 => arm64_insn::ARM64_INS_AESE,
            16 => arm64_insn::ARM64_INS_AESIMC,
            17 => arm64_insn::ARM64_INS_AESMC,
            18 => arm64_insn::ARM64_INS_AND,
            19 => arm64_insn::ARM64_INS_ANDS,
            20 => arm64_insn::ARM64_INS_ANDV,
            21 => arm64_insn::ARM64_INS_ASR,
            22 => arm64_insn::ARM64_INS_ASRD,
            23 => arm64_insn::ARM64_INS_ASRR,
            24 => arm64_insn::ARM64_INS_ASRV,
            25 => arm64_insn::ARM64_INS_AUTDA,
            26 => arm64_insn::ARM64_INS_AUTDB,
            27 => arm64_insn::ARM64_INS_AUTDZA,
            28 => arm64_insn::ARM64_INS_AUTDZB,
            29 => arm64_insn::ARM64_INS_AUTIA,
            30 => arm64_insn::ARM64_INS_AUTIA1716,
            31 => arm64_insn::ARM64_INS_AUTIASP,
            32 => arm64_insn::ARM64_INS_AUTIAZ,
            33 => arm64_insn::ARM64_INS_AUTIB,
            34 => arm64_insn::ARM64_INS_AUTIB1716,
            35 => arm64_insn::ARM64_INS_AUTIBSP,
            36 => arm64_insn::ARM64_INS_AUTIBZ,
            37 => arm64_insn::ARM64_INS_AUTIZA,
            38 => arm64_insn::ARM64_INS_AUTIZB,
            39 => arm64_insn::ARM64_INS_B,
            40 => arm64_insn::ARM64_INS_BCAX,
            41 => arm64_insn::ARM64_INS_BFM,
            42 => arm64_insn::ARM64_INS_BIC,
            43 => arm64_insn::ARM64_INS_BICS,
            44 => arm64_insn::ARM64_INS_BIF,
            45 => arm64_insn::ARM64_INS_BIT,
            46 => arm64_insn::ARM64_INS_BL,
            47 => arm64_insn::ARM64_INS_BLR,
            48 => arm64_insn::ARM64_INS_BLRAA,
            49 => arm64_insn::ARM64_INS_BLRAAZ,
            50 => arm64_insn::ARM64_INS_BLRAB,
            51 => arm64_insn::ARM64_INS_BLRABZ,
            52 => arm64_insn::ARM64_INS_BR,
            53 => arm64_insn::ARM64_INS_BRAA,
            54 => arm64_insn::ARM64_INS_BRAAZ,
            55 => arm64_insn::ARM64_INS_BRAB,
            56 => arm64_insn::ARM64_INS_BRABZ,
            57 => arm64_insn::ARM64_INS_BRK,
            58 => arm64_insn::ARM64_INS_BRKA,
            59 => arm64_insn::ARM64_INS_BRKAS,
            60 => arm64_insn::ARM64_INS_BRKB,
            61 => arm64_insn::ARM64_INS_BRKBS,
            62 => arm64_insn::ARM64_INS_BRKN,
            63 => arm64_insn::ARM64_INS_BRKNS,
            64 => arm64_insn::ARM64_INS_BRKPA,
            65 => arm64_insn::ARM64_INS_BRKPAS,
            66 => arm64_insn::ARM64_INS_BRKPB,
            67 => arm64_insn::ARM64_INS_BRKPBS,
            68 => arm64_insn::ARM64_INS_BSL,
            69 => arm64_insn::ARM64_INS_CAS,
            70 => arm64_insn::ARM64_INS_CASA,
            71 => arm64_insn::ARM64_INS_CASAB,
            72 => arm64_insn::ARM64_INS_CASAH,
            73 => arm64_insn::ARM64_INS_CASAL,
            74 => arm64_insn::ARM64_INS_CASALB,
            75 => arm64_insn::ARM64_INS_CASALH,
            76 => arm64_insn::ARM64_INS_CASB,
            77 => arm64_insn::ARM64_INS_CASH,
            78 => arm64_insn::ARM64_INS_CASL,
            79 => arm64_insn::ARM64_INS_CASLB,
            80 => arm64_insn::ARM64_INS_CASLH,
            81 => arm64_insn::ARM64_INS_CASP,
            82 => arm64_insn::ARM64_INS_CASPA,
            83 => arm64_insn::ARM64_INS_CASPAL,
            84 => arm64_insn::ARM64_INS_CASPL,
            85 => arm64_insn::ARM64_INS_CBNZ,
            86 => arm64_insn::ARM64_INS_CBZ,
            87 => arm64_insn::ARM64_INS_CCMN,
            88 => arm64_insn::ARM64_INS_CCMP,
            89 => arm64_insn::ARM64_INS_CFINV,
            90 => arm64_insn::ARM64_INS_CINC,
            91 => arm64_insn::ARM64_INS_CINV,
            92 => arm64_insn::ARM64_INS_CLASTA,
            93 => arm64_insn::ARM64_INS_CLASTB,
            94 => arm64_insn::ARM64_INS_CLREX,
            95 => arm64_insn::ARM64_INS_CLS,
            96 => arm64_insn::ARM64_INS_CLZ,
            97 => arm64_insn::ARM64_INS_CMEQ,
            98 => arm64_insn::ARM64_INS_CMGE,
            99 => arm64_insn::ARM64_INS_CMGT,
            100 => arm64_insn::ARM64_INS_CMHI,
            101 => arm64_insn::ARM64_INS_CMHS,
            102 => arm64_insn::ARM64_INS_CMLE,
            103 => arm64_insn::ARM64_INS_CMLO,
            104 => arm64_insn::ARM64_INS_CMLS,
            105 => arm64_insn::ARM64_INS_CMLT,
            106 => arm64_insn::ARM64_INS_CMN,
            107 => arm64_insn::ARM64_INS_CMP,
            108 => arm64_insn::ARM64_INS_CMPEQ,
            109 => arm64_insn::ARM64_INS_CMPGE,
            110 => arm64_insn::ARM64_INS_CMPGT,
            111 => arm64_insn::ARM64_INS_CMPHI,
            112 => arm64_insn::ARM64_INS_CMPHS,
            113 => arm64_insn::ARM64_INS_CMPLE,
            114 => arm64_insn::ARM64_INS_CMPLO,
            115 => arm64_insn::ARM64_INS_CMPLS,
            116 => arm64_insn::ARM64_INS_CMPLT,
            117 => arm64_insn::ARM64_INS_CMPNE,
            118 => arm64_insn::ARM64_INS_CMTST,
            119 => arm64_insn::ARM64_INS_CNEG,
            120 => arm64_insn::ARM64_INS_CNOT,
            121 => arm64_insn::ARM64_INS_CNT,
            122 => arm64_insn::ARM64_INS_CNTB,
            123 => arm64_insn::ARM64_INS_CNTD,
            124 => arm64_insn::ARM64_INS_CNTH,
            125 => arm64_insn::ARM64_INS_CNTP,
            126 => arm64_insn::ARM64_INS_CNTW,
            127 => arm64_insn::ARM64_INS_COMPACT,
            128 => arm64_insn::ARM64_INS_CPY,
            129 => arm64_insn::ARM64_INS_CRC32B,
            130 => arm64_insn::ARM64_INS_CRC32CB,
            131 => arm64_insn::ARM64_INS_CRC32CH,
            132 => arm64_insn::ARM64_INS_CRC32CW,
            133 => arm64_insn::ARM64_INS_CRC32CX,
            134 => arm64_insn::ARM64_INS_CRC32H,
            135 => arm64_insn::ARM64_INS_CRC32W,
            136 => arm64_insn::ARM64_INS_CRC32X,
            137 => arm64_insn::ARM64_INS_CSDB,
            138 => arm64_insn::ARM64_INS_CSEL,
            139 => arm64_insn::ARM64_INS_CSET,
            140 => arm64_insn::ARM64_INS_CSETM,
            141 => arm64_insn::ARM64_INS_CSINC,
            142 => arm64_insn::ARM64_INS_CSINV,
            143 => arm64_insn::ARM64_INS_CSNEG,
            144 => arm64_insn::ARM64_INS_CTERMEQ,
            145 => arm64_insn::ARM64_INS_CTERMNE,
            146 => arm64_insn::ARM64_INS_DCPS1,
            147 => arm64_insn::ARM64_INS_DCPS2,
            148 => arm64_insn::ARM64_INS_DCPS3,
            149 => arm64_insn::ARM64_INS_DECB,
            150 => arm64_insn::ARM64_INS_DECD,
            151 => arm64_insn::ARM64_INS_DECH,
            152 => arm64_insn::ARM64_INS_DECP,
            153 => arm64_insn::ARM64_INS_DECW,
            154 => arm64_insn::ARM64_INS_DMB,
            155 => arm64_insn::ARM64_INS_DRPS,
            156 => arm64_insn::ARM64_INS_DSB,
            157 => arm64_insn::ARM64_INS_DUP,
            158 => arm64_insn::ARM64_INS_DUPM,
            159 => arm64_insn::ARM64_INS_EON,
            160 => arm64_insn::ARM64_INS_EOR,
            161 => arm64_insn::ARM64_INS_EOR3,
            162 => arm64_insn::ARM64_INS_EORS,
            163 => arm64_insn::ARM64_INS_EORV,
            164 => arm64_insn::ARM64_INS_ERET,
            165 => arm64_insn::ARM64_INS_ERETAA,
            166 => arm64_insn::ARM64_INS_ERETAB,
            167 => arm64_insn::ARM64_INS_ESB,
            168 => arm64_insn::ARM64_INS_EXT,
            169 => arm64_insn::ARM64_INS_EXTR,
            170 => arm64_insn::ARM64_INS_FABD,
            171 => arm64_insn::ARM64_INS_FABS,
            172 => arm64_insn::ARM64_INS_FACGE,
            173 => arm64_insn::ARM64_INS_FACGT,
            174 => arm64_insn::ARM64_INS_FACLE,
            175 => arm64_insn::ARM64_INS_FACLT,
            176 => arm64_insn::ARM64_INS_FADD,
            177 => arm64_insn::ARM64_INS_FADDA,
            178 => arm64_insn::ARM64_INS_FADDP,
            179 => arm64_insn::ARM64_INS_FADDV,
            180 => arm64_insn::ARM64_INS_FCADD,
            181 => arm64_insn::ARM64_INS_FCCMP,
            182 => arm64_insn::ARM64_INS_FCCMPE,
            183 => arm64_insn::ARM64_INS_FCMEQ,
            184 => arm64_insn::ARM64_INS_FCMGE,
            185 => arm64_insn::ARM64_INS_FCMGT,
            186 => arm64_insn::ARM64_INS_FCMLA,
            187 => arm64_insn::ARM64_INS_FCMLE,
            188 => arm64_insn::ARM64_INS_FCMLT,
            189 => arm64_insn::ARM64_INS_FCMNE,
            190 => arm64_insn::ARM64_INS_FCMP,
            191 => arm64_insn::ARM64_INS_FCMPE,
            192 => arm64_insn::ARM64_INS_FCMUO,
            193 => arm64_insn::ARM64_INS_FCPY,
            194 => arm64_insn::ARM64_INS_FCSEL,
            195 => arm64_insn::ARM64_INS_FCVT,
            196 => arm64_insn::ARM64_INS_FCVTAS,
            197 => arm64_insn::ARM64_INS_FCVTAU,
            198 => arm64_insn::ARM64_INS_FCVTL,
            199 => arm64_insn::ARM64_INS_FCVTL2,
            200 => arm64_insn::ARM64_INS_FCVTMS,
            201 => arm64_insn::ARM64_INS_FCVTMU,
            202 => arm64_insn::ARM64_INS_FCVTN,
            203 => arm64_insn::ARM64_INS_FCVTN2,
            204 => arm64_insn::ARM64_INS_FCVTNS,
            205 => arm64_insn::ARM64_INS_FCVTNU,
            206 => arm64_insn::ARM64_INS_FCVTPS,
            207 => arm64_insn::ARM64_INS_FCVTPU,
            208 => arm64_insn::ARM64_INS_FCVTXN,
            209 => arm64_insn::ARM64_INS_FCVTXN2,
            210 => arm64_insn::ARM64_INS_FCVTZS,
            211 => arm64_insn::ARM64_INS_FCVTZU,
            212 => arm64_insn::ARM64_INS_FDIV,
            213 => arm64_insn::ARM64_INS_FDIVR,
            214 => arm64_insn::ARM64_INS_FDUP,
            215 => arm64_insn::ARM64_INS_FEXPA,
            216 => arm64_insn::ARM64_INS_FJCVTZS,
            217 => arm64_insn::ARM64_INS_FMAD,
            218 => arm64_insn::ARM64_INS_FMADD,
            219 => arm64_insn::ARM64_INS_FMAX,
            220 => arm64_insn::ARM64_INS_FMAXNM,
            221 => arm64_insn::ARM64_INS_FMAXNMP,
            222 => arm64_insn::ARM64_INS_FMAXNMV,
            223 => arm64_insn::ARM64_INS_FMAXP,
            224 => arm64_insn::ARM64_INS_FMAXV,
            225 => arm64_insn::ARM64_INS_FMIN,
            226 => arm64_insn::ARM64_INS_FMINNM,
            227 => arm64_insn::ARM64_INS_FMINNMP,
            228 => arm64_insn::ARM64_INS_FMINNMV,
            229 => arm64_insn::ARM64_INS_FMINP,
            230 => arm64_insn::ARM64_INS_FMINV,
            231 => arm64_insn::ARM64_INS_FMLA,
            232 => arm64_insn::ARM64_INS_FMLS,
            233 => arm64_insn::ARM64_INS_FMOV,
            234 => arm64_insn::ARM64_INS_FMSB,
            235 => arm64_insn::ARM64_INS_FMSUB,
            236 => arm64_insn::ARM64_INS_FMUL,
            237 => arm64_insn::ARM64_INS_FMULX,
            238 => arm64_insn::ARM64_INS_FNEG,
            239 => arm64_insn::ARM64_INS_FNMAD,
            240 => arm64_insn::ARM64_INS_FNMADD,
            241 => arm64_insn::ARM64_INS_FNMLA,
            242 => arm64_insn::ARM64_INS_FNMLS,
            243 => arm64_insn::ARM64_INS_FNMSB,
            244 => arm64_insn::ARM64_INS_FNMSUB,
            245 => arm64_insn::ARM64_INS_FNMUL,
            246 => arm64_insn::ARM64_INS_FRECPE,
            247 => arm64_insn::ARM64_INS_FRECPS,
            248 => arm64_insn::ARM64_INS_FRECPX,
            249 => arm64_insn::ARM64_INS_FRINTA,
            250 => arm64_insn::ARM64_INS_FRINTI,
            251 => arm64_insn::ARM64_INS_FRINTM,
            252 => arm64_insn::ARM64_INS_FRINTN,
            253 => arm64_insn::ARM64_INS_FRINTP,
            254 => arm64_insn::ARM64_INS_FRINTX,
            255 => arm64_insn::ARM64_INS_FRINTZ,
            256 => arm64_insn::ARM64_INS_FRSQRTE,
            257 => arm64_insn::ARM64_INS_FRSQRTS,
            258 => arm64_insn::ARM64_INS_FSCALE,
            259 => arm64_insn::ARM64_INS_FSQRT,
            260 => arm64_insn::ARM64_INS_FSUB,
            261 => arm64_insn::ARM64_INS_FSUBR,
            262 => arm64_insn::ARM64_INS_FTMAD,
            263 => arm64_insn::ARM64_INS_FTSMUL,
            264 => arm64_insn::ARM64_INS_FTSSEL,
            265 => arm64_insn::ARM64_INS_HINT,
            266 => arm64_insn::ARM64_INS_HLT,
            267 => arm64_insn::ARM64_INS_HVC,
            268 => arm64_insn::ARM64_INS_INCB,
            269 => arm64_insn::ARM64_INS_INCD,
            270 => arm64_insn::ARM64_INS_INCH,
            271 => arm64_insn::ARM64_INS_INCP,
            272 => arm64_insn::ARM64_INS_INCW,
            273 => arm64_insn::ARM64_INS_INDEX,
            274 => arm64_insn::ARM64_INS_INS,
            275 => arm64_insn::ARM64_INS_INSR,
            276 => arm64_insn::ARM64_INS_ISB,
            277 => arm64_insn::ARM64_INS_LASTA,
            278 => arm64_insn::ARM64_INS_LASTB,
            279 => arm64_insn::ARM64_INS_LD1,
            280 => arm64_insn::ARM64_INS_LD1B,
            281 => arm64_insn::ARM64_INS_LD1D,
            282 => arm64_insn::ARM64_INS_LD1H,
            283 => arm64_insn::ARM64_INS_LD1R,
            284 => arm64_insn::ARM64_INS_LD1RB,
            285 => arm64_insn::ARM64_INS_LD1RD,
            286 => arm64_insn::ARM64_INS_LD1RH,
            287 => arm64_insn::ARM64_INS_LD1RQB,
            288 => arm64_insn::ARM64_INS_LD1RQD,
            289 => arm64_insn::ARM64_INS_LD1RQH,
            290 => arm64_insn::ARM64_INS_LD1RQW,
            291 => arm64_insn::ARM64_INS_LD1RSB,
            292 => arm64_insn::ARM64_INS_LD1RSH,
            293 => arm64_insn::ARM64_INS_LD1RSW,
            294 => arm64_insn::ARM64_INS_LD1RW,
            295 => arm64_insn::ARM64_INS_LD1SB,
            296 => arm64_insn::ARM64_INS_LD1SH,
            297 => arm64_insn::ARM64_INS_LD1SW,
            298 => arm64_insn::ARM64_INS_LD1W,
            299 => arm64_insn::ARM64_INS_LD2,
            300 => arm64_insn::ARM64_INS_LD2B,
            301 => arm64_insn::ARM64_INS_LD2D,
            302 => arm64_insn::ARM64_INS_LD2H,
            303 => arm64_insn::ARM64_INS_LD2R,
            304 => arm64_insn::ARM64_INS_LD2W,
            305 => arm64_insn::ARM64_INS_LD3,
            306 => arm64_insn::ARM64_INS_LD3B,
            307 => arm64_insn::ARM64_INS_LD3D,
            308 => arm64_insn::ARM64_INS_LD3H,
            309 => arm64_insn::ARM64_INS_LD3R,
            310 => arm64_insn::ARM64_INS_LD3W,
            311 => arm64_insn::ARM64_INS_LD4,
            312 => arm64_insn::ARM64_INS_LD4B,
            313 => arm64_insn::ARM64_INS_LD4D,
            314 => arm64_insn::ARM64_INS_LD4H,
            315 => arm64_insn::ARM64_INS_LD4R,
            316 => arm64_insn::ARM64_INS_LD4W,
            317 => arm64_insn::ARM64_INS_LDADD,
            318 => arm64_insn::ARM64_INS_LDADDA,
            319 => arm64_insn::ARM64_INS_LDADDAB,
            320 => arm64_insn::ARM64_INS_LDADDAH,
            321 => arm64_insn::ARM64_INS_LDADDAL,
            322 => arm64_insn::ARM64_INS_LDADDALB,
            323 => arm64_insn::ARM64_INS_LDADDALH,
            324 => arm64_insn::ARM64_INS_LDADDB,
            325 => arm64_insn::ARM64_INS_LDADDH,
            326 => arm64_insn::ARM64_INS_LDADDL,
            327 => arm64_insn::ARM64_INS_LDADDLB,
            328 => arm64_insn::ARM64_INS_LDADDLH,
            329 => arm64_insn::ARM64_INS_LDAPR,
            330 => arm64_insn::ARM64_INS_LDAPRB,
            331 => arm64_insn::ARM64_INS_LDAPRH,
            332 => arm64_insn::ARM64_INS_LDAPUR,
            333 => arm64_insn::ARM64_INS_LDAPURB,
            334 => arm64_insn::ARM64_INS_LDAPURH,
            335 => arm64_insn::ARM64_INS_LDAPURSB,
            336 => arm64_insn::ARM64_INS_LDAPURSH,
            337 => arm64_insn::ARM64_INS_LDAPURSW,
            338 => arm64_insn::ARM64_INS_LDAR,
            339 => arm64_insn::ARM64_INS_LDARB,
            340 => arm64_insn::ARM64_INS_LDARH,
            341 => arm64_insn::ARM64_INS_LDAXP,
            342 => arm64_insn::ARM64_INS_LDAXR,
            343 => arm64_insn::ARM64_INS_LDAXRB,
            344 => arm64_insn::ARM64_INS_LDAXRH,
            345 => arm64_insn::ARM64_INS_LDCLR,
            346 => arm64_insn::ARM64_INS_LDCLRA,
            347 => arm64_insn::ARM64_INS_LDCLRAB,
            348 => arm64_insn::ARM64_INS_LDCLRAH,
            349 => arm64_insn::ARM64_INS_LDCLRAL,
            350 => arm64_insn::ARM64_INS_LDCLRALB,
            351 => arm64_insn::ARM64_INS_LDCLRALH,
            352 => arm64_insn::ARM64_INS_LDCLRB,
            353 => arm64_insn::ARM64_INS_LDCLRH,
            354 => arm64_insn::ARM64_INS_LDCLRL,
            355 => arm64_insn::ARM64_INS_LDCLRLB,
            356 => arm64_insn::ARM64_INS_LDCLRLH,
            357 => arm64_insn::ARM64_INS_LDEOR,
            358 => arm64_insn::ARM64_INS_LDEORA,
            359 => arm64_insn::ARM64_INS_LDEORAB,
            360 => arm64_insn::ARM64_INS_LDEORAH,
            361 => arm64_insn::ARM64_INS_LDEORAL,
            362 => arm64_insn::ARM64_INS_LDEORALB,
            363 => arm64_insn::ARM64_INS_LDEORALH,
            364 => arm64_insn::ARM64_INS_LDEORB,
            365 => arm64_insn::ARM64_INS_LDEORH,
            366 => arm64_insn::ARM64_INS_LDEORL,
            367 => arm64_insn::ARM64_INS_LDEORLB,
            368 => arm64_insn::ARM64_INS_LDEORLH,
            369 => arm64_insn::ARM64_INS_LDFF1B,
            370 => arm64_insn::ARM64_INS_LDFF1D,
            371 => arm64_insn::ARM64_INS_LDFF1H,
            372 => arm64_insn::ARM64_INS_LDFF1SB,
            373 => arm64_insn::ARM64_INS_LDFF1SH,
            374 => arm64_insn::ARM64_INS_LDFF1SW,
            375 => arm64_insn::ARM64_INS_LDFF1W,
            376 => arm64_insn::ARM64_INS_LDLAR,
            377 => arm64_insn::ARM64_INS_LDLARB,
            378 => arm64_insn::ARM64_INS_LDLARH,
            379 => arm64_insn::ARM64_INS_LDNF1B,
            380 => arm64_insn::ARM64_INS_LDNF1D,
            381 => arm64_insn::ARM64_INS_LDNF1H,
            382 => arm64_insn::ARM64_INS_LDNF1SB,
            383 => arm64_insn::ARM64_INS_LDNF1SH,
            384 => arm64_insn::ARM64_INS_LDNF1SW,
            385 => arm64_insn::ARM64_INS_LDNF1W,
            386 => arm64_insn::ARM64_INS_LDNP,
            387 => arm64_insn::ARM64_INS_LDNT1B,
            388 => arm64_insn::ARM64_INS_LDNT1D,
            389 => arm64_insn::ARM64_INS_LDNT1H,
            390 => arm64_insn::ARM64_INS_LDNT1W,
            391 => arm64_insn::ARM64_INS_LDP,
            392 => arm64_insn::ARM64_INS_LDPSW,
            393 => arm64_insn::ARM64_INS_LDR,
            394 => arm64_insn::ARM64_INS_LDRAA,
            395 => arm64_insn::ARM64_INS_LDRAB,
            396 => arm64_insn::ARM64_INS_LDRB,
            397 => arm64_insn::ARM64_INS_LDRH,
            398 => arm64_insn::ARM64_INS_LDRSB,
            399 => arm64_insn::ARM64_INS_LDRSH,
            400 => arm64_insn::ARM64_INS_LDRSW,
            401 => arm64_insn::ARM64_INS_LDSET,
            402 => arm64_insn::ARM64_INS_LDSETA,
            403 => arm64_insn::ARM64_INS_LDSETAB,
            404 => arm64_insn::ARM64_INS_LDSETAH,
            405 => arm64_insn::ARM64_INS_LDSETAL,
            406 => arm64_insn::ARM64_INS_LDSETALB,
            407 => arm64_insn::ARM64_INS_LDSETALH,
            408 => arm64_insn::ARM64_INS_LDSETB,
            409 => arm64_insn::ARM64_INS_LDSETH,
            410 => arm64_insn::ARM64_INS_LDSETL,
            411 => arm64_insn::ARM64_INS_LDSETLB,
            412 => arm64_insn::ARM64_INS_LDSETLH,
            413 => arm64_insn::ARM64_INS_LDSMAX,
            414 => arm64_insn::ARM64_INS_LDSMAXA,
            415 => arm64_insn::ARM64_INS_LDSMAXAB,
            416 => arm64_insn::ARM64_INS_LDSMAXAH,
            417 => arm64_insn::ARM64_INS_LDSMAXAL,
            418 => arm64_insn::ARM64_INS_LDSMAXALB,
            419 => arm64_insn::ARM64_INS_LDSMAXALH,
            420 => arm64_insn::ARM64_INS_LDSMAXB,
            421 => arm64_insn::ARM64_INS_LDSMAXH,
            422 => arm64_insn::ARM64_INS_LDSMAXL,
            423 => arm64_insn::ARM64_INS_LDSMAXLB,
            424 => arm64_insn::ARM64_INS_LDSMAXLH,
            425 => arm64_insn::ARM64_INS_LDSMIN,
            426 => arm64_insn::ARM64_INS_LDSMINA,
            427 => arm64_insn::ARM64_INS_LDSMINAB,
            428 => arm64_insn::ARM64_INS_LDSMINAH,
            429 => arm64_insn::ARM64_INS_LDSMINAL,
            430 => arm64_insn::ARM64_INS_LDSMINALB,
            431 => arm64_insn::ARM64_INS_LDSMINALH,
            432 => arm64_insn::ARM64_INS_LDSMINB,
            433 => arm64_insn::ARM64_INS_LDSMINH,
            434 => arm64_insn::ARM64_INS_LDSMINL,
            435 => arm64_insn::ARM64_INS_LDSMINLB,
            436 => arm64_insn::ARM64_INS_LDSMINLH,
            437 => arm64_insn::ARM64_INS_LDTR,
            438 => arm64_insn::ARM64_INS_LDTRB,
            439 => arm64_insn::ARM64_INS_LDTRH,
            440 => arm64_insn::ARM64_INS_LDTRSB,
            441 => arm64_insn::ARM64_INS_LDTRSH,
            442 => arm64_insn::ARM64_INS_LDTRSW,
            443 => arm64_insn::ARM64_INS_LDUMAX,
            444 => arm64_insn::ARM64_INS_LDUMAXA,
            445 => arm64_insn::ARM64_INS_LDUMAXAB,
            446 => arm64_insn::ARM64_INS_LDUMAXAH,
            447 => arm64_insn::ARM64_INS_LDUMAXAL,
            448 => arm64_insn::ARM64_INS_LDUMAXALB,
            449 => arm64_insn::ARM64_INS_LDUMAXALH,
            450 => arm64_insn::ARM64_INS_LDUMAXB,
            451 => arm64_insn::ARM64_INS_LDUMAXH,
            452 => arm64_insn::ARM64_INS_LDUMAXL,
            453 => arm64_insn::ARM64_INS_LDUMAXLB,
            454 => arm64_insn::ARM64_INS_LDUMAXLH,
            455 => arm64_insn::ARM64_INS_LDUMIN,
            456 => arm64_insn::ARM64_INS_LDUMINA,
            457 => arm64_insn::ARM64_INS_LDUMINAB,
            458 => arm64_insn::ARM64_INS_LDUMINAH,
            459 => arm64_insn::ARM64_INS_LDUMINAL,
            460 => arm64_insn::ARM64_INS_LDUMINALB,
            461 => arm64_insn::ARM64_INS_LDUMINALH,
            462 => arm64_insn::ARM64_INS_LDUMINB,
            463 => arm64_insn::ARM64_INS_LDUMINH,
            464 => arm64_insn::ARM64_INS_LDUMINL,
            465 => arm64_insn::ARM64_INS_LDUMINLB,
            466 => arm64_insn::ARM64_INS_LDUMINLH,
            467 => arm64_insn::ARM64_INS_LDUR,
            468 => arm64_insn::ARM64_INS_LDURB,
            469 => arm64_insn::ARM64_INS_LDURH,
            470 => arm64_insn::ARM64_INS_LDURSB,
            471 => arm64_insn::ARM64_INS_LDURSH,
            472 => arm64_insn::ARM64_INS_LDURSW,
            473 => arm64_insn::ARM64_INS_LDXP,
            474 => arm64_insn::ARM64_INS_LDXR,
            475 => arm64_insn::ARM64_INS_LDXRB,
            476 => arm64_insn::ARM64_INS_LDXRH,
            477 => arm64_insn::ARM64_INS_LSL,
            478 => arm64_insn::ARM64_INS_LSLR,
            479 => arm64_insn::ARM64_INS_LSLV,
            480 => arm64_insn::ARM64_INS_LSR,
            481 => arm64_insn::ARM64_INS_LSRR,
            482 => arm64_insn::ARM64_INS_LSRV,
            483 => arm64_insn::ARM64_INS_MAD,
            484 => arm64_insn::ARM64_INS_MADD,
            485 => arm64_insn::ARM64_INS_MLA,
            486 => arm64_insn::ARM64_INS_MLS,
            487 => arm64_insn::ARM64_INS_MNEG,
            488 => arm64_insn::ARM64_INS_MOV,
            489 => arm64_insn::ARM64_INS_MOVI,
            490 => arm64_insn::ARM64_INS_MOVK,
            491 => arm64_insn::ARM64_INS_MOVN,
            492 => arm64_insn::ARM64_INS_MOVPRFX,
            493 => arm64_insn::ARM64_INS_MOVS,
            494 => arm64_insn::ARM64_INS_MOVZ,
            495 => arm64_insn::ARM64_INS_MRS,
            496 => arm64_insn::ARM64_INS_MSB,
            497 => arm64_insn::ARM64_INS_MSR,
            498 => arm64_insn::ARM64_INS_MSUB,
            499 => arm64_insn::ARM64_INS_MUL,
            500 => arm64_insn::ARM64_INS_MVN,
            501 => arm64_insn::ARM64_INS_MVNI,
            502 => arm64_insn::ARM64_INS_NAND,
            503 => arm64_insn::ARM64_INS_NANDS,
            504 => arm64_insn::ARM64_INS_NEG,
            505 => arm64_insn::ARM64_INS_NEGS,
            506 => arm64_insn::ARM64_INS_NGC,
            507 => arm64_insn::ARM64_INS_NGCS,
            508 => arm64_insn::ARM64_INS_NOP,
            509 => arm64_insn::ARM64_INS_NOR,
            510 => arm64_insn::ARM64_INS_NORS,
            511 => arm64_insn::ARM64_INS_NOT,
            512 => arm64_insn::ARM64_INS_NOTS,
            513 => arm64_insn::ARM64_INS_ORN,
            514 => arm64_insn::ARM64_INS_ORNS,
            515 => arm64_insn::ARM64_INS_ORR,
            516 => arm64_insn::ARM64_INS_ORRS,
            517 => arm64_insn::ARM64_INS_ORV,
            518 => arm64_insn::ARM64_INS_PACDA,
            519 => arm64_insn::ARM64_INS_PACDB,
            520 => arm64_insn::ARM64_INS_PACDZA,
            521 => arm64_insn::ARM64_INS_PACDZB,
            522 => arm64_insn::ARM64_INS_PACGA,
            523 => arm64_insn::ARM64_INS_PACIA,
            524 => arm64_insn::ARM64_INS_PACIA1716,
            525 => arm64_insn::ARM64_INS_PACIASP,
            526 => arm64_insn::ARM64_INS_PACIAZ,
            527 => arm64_insn::ARM64_INS_PACIB,
            528 => arm64_insn::ARM64_INS_PACIB1716,
            529 => arm64_insn::ARM64_INS_PACIBSP,
            530 => arm64_insn::ARM64_INS_PACIBZ,
            531 => arm64_insn::ARM64_INS_PACIZA,
            532 => arm64_insn::ARM64_INS_PACIZB,
            533 => arm64_insn::ARM64_INS_PFALSE,
            534 => arm64_insn::ARM64_INS_PFIRST,
            535 => arm64_insn::ARM64_INS_PMUL,
            536 => arm64_insn::ARM64_INS_PMULL,
            537 => arm64_insn::ARM64_INS_PMULL2,
            538 => arm64_insn::ARM64_INS_PNEXT,
            539 => arm64_insn::ARM64_INS_PRFB,
            540 => arm64_insn::ARM64_INS_PRFD,
            541 => arm64_insn::ARM64_INS_PRFH,
            542 => arm64_insn::ARM64_INS_PRFM,
            543 => arm64_insn::ARM64_INS_PRFUM,
            544 => arm64_insn::ARM64_INS_PRFW,
            545 => arm64_insn::ARM64_INS_PSB,
            546 => arm64_insn::ARM64_INS_PTEST,
            547 => arm64_insn::ARM64_INS_PTRUE,
            548 => arm64_insn::ARM64_INS_PTRUES,
            549 => arm64_insn::ARM64_INS_PUNPKHI,
            550 => arm64_insn::ARM64_INS_PUNPKLO,
            551 => arm64_insn::ARM64_INS_RADDHN,
            552 => arm64_insn::ARM64_INS_RADDHN2,
            553 => arm64_insn::ARM64_INS_RAX1,
            554 => arm64_insn::ARM64_INS_RBIT,
            555 => arm64_insn::ARM64_INS_RDFFR,
            556 => arm64_insn::ARM64_INS_RDFFRS,
            557 => arm64_insn::ARM64_INS_RDVL,
            558 => arm64_insn::ARM64_INS_RET,
            559 => arm64_insn::ARM64_INS_RETAA,
            560 => arm64_insn::ARM64_INS_RETAB,
            561 => arm64_insn::ARM64_INS_REV,
            562 => arm64_insn::ARM64_INS_REV16,
            563 => arm64_insn::ARM64_INS_REV32,
            564 => arm64_insn::ARM64_INS_REV64,
            565 => arm64_insn::ARM64_INS_REVB,
            566 => arm64_insn::ARM64_INS_REVH,
            567 => arm64_insn::ARM64_INS_REVW,
            568 => arm64_insn::ARM64_INS_RMIF,
            569 => arm64_insn::ARM64_INS_ROR,
            570 => arm64_insn::ARM64_INS_RORV,
            571 => arm64_insn::ARM64_INS_RSHRN,
            572 => arm64_insn::ARM64_INS_RSHRN2,
            573 => arm64_insn::ARM64_INS_RSUBHN,
            574 => arm64_insn::ARM64_INS_RSUBHN2,
            575 => arm64_insn::ARM64_INS_SABA,
            576 => arm64_insn::ARM64_INS_SABAL,
            577 => arm64_insn::ARM64_INS_SABAL2,
            578 => arm64_insn::ARM64_INS_SABD,
            579 => arm64_insn::ARM64_INS_SABDL,
            580 => arm64_insn::ARM64_INS_SABDL2,
            581 => arm64_insn::ARM64_INS_SADALP,
            582 => arm64_insn::ARM64_INS_SADDL,
            583 => arm64_insn::ARM64_INS_SADDL2,
            584 => arm64_insn::ARM64_INS_SADDLP,
            585 => arm64_insn::ARM64_INS_SADDLV,
            586 => arm64_insn::ARM64_INS_SADDV,
            587 => arm64_insn::ARM64_INS_SADDW,
            588 => arm64_insn::ARM64_INS_SADDW2,
            589 => arm64_insn::ARM64_INS_SBC,
            590 => arm64_insn::ARM64_INS_SBCS,
            591 => arm64_insn::ARM64_INS_SBFM,
            592 => arm64_insn::ARM64_INS_SCVTF,
            593 => arm64_insn::ARM64_INS_SDIV,
            594 => arm64_insn::ARM64_INS_SDIVR,
            595 => arm64_insn::ARM64_INS_SDOT,
            596 => arm64_insn::ARM64_INS_SEL,
            597 => arm64_insn::ARM64_INS_SETF16,
            598 => arm64_insn::ARM64_INS_SETF8,
            599 => arm64_insn::ARM64_INS_SETFFR,
            600 => arm64_insn::ARM64_INS_SEV,
            601 => arm64_insn::ARM64_INS_SEVL,
            602 => arm64_insn::ARM64_INS_SHA1C,
            603 => arm64_insn::ARM64_INS_SHA1H,
            604 => arm64_insn::ARM64_INS_SHA1M,
            605 => arm64_insn::ARM64_INS_SHA1P,
            606 => arm64_insn::ARM64_INS_SHA1SU0,
            607 => arm64_insn::ARM64_INS_SHA1SU1,
            608 => arm64_insn::ARM64_INS_SHA256H,
            609 => arm64_insn::ARM64_INS_SHA256H2,
            610 => arm64_insn::ARM64_INS_SHA256SU0,
            611 => arm64_insn::ARM64_INS_SHA256SU1,
            612 => arm64_insn::ARM64_INS_SHA512H,
            613 => arm64_insn::ARM64_INS_SHA512H2,
            614 => arm64_insn::ARM64_INS_SHA512SU0,
            615 => arm64_insn::ARM64_INS_SHA512SU1,
            616 => arm64_insn::ARM64_INS_SHADD,
            617 => arm64_insn::ARM64_INS_SHL,
            618 => arm64_insn::ARM64_INS_SHLL,
            619 => arm64_insn::ARM64_INS_SHLL2,
            620 => arm64_insn::ARM64_INS_SHRN,
            621 => arm64_insn::ARM64_INS_SHRN2,
            622 => arm64_insn::ARM64_INS_SHSUB,
            623 => arm64_insn::ARM64_INS_SLI,
            624 => arm64_insn::ARM64_INS_SM3PARTW1,
            625 => arm64_insn::ARM64_INS_SM3PARTW2,
            626 => arm64_insn::ARM64_INS_SM3SS1,
            627 => arm64_insn::ARM64_INS_SM3TT1A,
            628 => arm64_insn::ARM64_INS_SM3TT1B,
            629 => arm64_insn::ARM64_INS_SM3TT2A,
            630 => arm64_insn::ARM64_INS_SM3TT2B,
            631 => arm64_insn::ARM64_INS_SM4E,
            632 => arm64_insn::ARM64_INS_SM4EKEY,
            633 => arm64_insn::ARM64_INS_SMADDL,
            634 => arm64_insn::ARM64_INS_SMAX,
            635 => arm64_insn::ARM64_INS_SMAXP,
            636 => arm64_insn::ARM64_INS_SMAXV,
            637 => arm64_insn::ARM64_INS_SMC,
            638 => arm64_insn::ARM64_INS_SMIN,
            639 => arm64_insn::ARM64_INS_SMINP,
            640 => arm64_insn::ARM64_INS_SMINV,
            641 => arm64_insn::ARM64_INS_SMLAL,
            642 => arm64_insn::ARM64_INS_SMLAL2,
            643 => arm64_insn::ARM64_INS_SMLSL,
            644 => arm64_insn::ARM64_INS_SMLSL2,
            645 => arm64_insn::ARM64_INS_SMNEGL,
            646 => arm64_insn::ARM64_INS_SMOV,
            647 => arm64_insn::ARM64_INS_SMSUBL,
            648 => arm64_insn::ARM64_INS_SMULH,
            649 => arm64_insn::ARM64_INS_SMULL,
            650 => arm64_insn::ARM64_INS_SMULL2,
            651 => arm64_insn::ARM64_INS_SPLICE,
            652 => arm64_insn::ARM64_INS_SQABS,
            653 => arm64_insn::ARM64_INS_SQADD,
            654 => arm64_insn::ARM64_INS_SQDECB,
            655 => arm64_insn::ARM64_INS_SQDECD,
            656 => arm64_insn::ARM64_INS_SQDECH,
            657 => arm64_insn::ARM64_INS_SQDECP,
            658 => arm64_insn::ARM64_INS_SQDECW,
            659 => arm64_insn::ARM64_INS_SQDMLAL,
            660 => arm64_insn::ARM64_INS_SQDMLAL2,
            661 => arm64_insn::ARM64_INS_SQDMLSL,
            662 => arm64_insn::ARM64_INS_SQDMLSL2,
            663 => arm64_insn::ARM64_INS_SQDMULH,
            664 => arm64_insn::ARM64_INS_SQDMULL,
            665 => arm64_insn::ARM64_INS_SQDMULL2,
            666 => arm64_insn::ARM64_INS_SQINCB,
            667 => arm64_insn::ARM64_INS_SQINCD,
            668 => arm64_insn::ARM64_INS_SQINCH,
            669 => arm64_insn::ARM64_INS_SQINCP,
            670 => arm64_insn::ARM64_INS_SQINCW,
            671 => arm64_insn::ARM64_INS_SQNEG,
            672 => arm64_insn::ARM64_INS_SQRDMLAH,
            673 => arm64_insn::ARM64_INS_SQRDMLSH,
            674 => arm64_insn::ARM64_INS_SQRDMULH,
            675 => arm64_insn::ARM64_INS_SQRSHL,
            676 => arm64_insn::ARM64_INS_SQRSHRN,
            677 => arm64_insn::ARM64_INS_SQRSHRN2,
            678 => arm64_insn::ARM64_INS_SQRSHRUN,
            679 => arm64_insn::ARM64_INS_SQRSHRUN2,
            680 => arm64_insn::ARM64_INS_SQSHL,
            681 => arm64_insn::ARM64_INS_SQSHLU,
            682 => arm64_insn::ARM64_INS_SQSHRN,
            683 => arm64_insn::ARM64_INS_SQSHRN2,
            684 => arm64_insn::ARM64_INS_SQSHRUN,
            685 => arm64_insn::ARM64_INS_SQSHRUN2,
            686 => arm64_insn::ARM64_INS_SQSUB,
            687 => arm64_insn::ARM64_INS_SQXTN,
            688 => arm64_insn::ARM64_INS_SQXTN2,
            689 => arm64_insn::ARM64_INS_SQXTUN,
            690 => arm64_insn::ARM64_INS_SQXTUN2,
            691 => arm64_insn::ARM64_INS_SRHADD,
            692 => arm64_insn::ARM64_INS_SRI,
            693 => arm64_insn::ARM64_INS_SRSHL,
            694 => arm64_insn::ARM64_INS_SRSHR,
            695 => arm64_insn::ARM64_INS_SRSRA,
            696 => arm64_insn::ARM64_INS_SSHL,
            697 => arm64_insn::ARM64_INS_SSHLL,
            698 => arm64_insn::ARM64_INS_SSHLL2,
            699 => arm64_insn::ARM64_INS_SSHR,
            700 => arm64_insn::ARM64_INS_SSRA,
            701 => arm64_insn::ARM64_INS_SSUBL,
            702 => arm64_insn::ARM64_INS_SSUBL2,
            703 => arm64_insn::ARM64_INS_SSUBW,
            704 => arm64_insn::ARM64_INS_SSUBW2,
            705 => arm64_insn::ARM64_INS_ST1,
            706 => arm64_insn::ARM64_INS_ST1B,
            707 => arm64_insn::ARM64_INS_ST1D,
            708 => arm64_insn::ARM64_INS_ST1H,
            709 => arm64_insn::ARM64_INS_ST1W,
            710 => arm64_insn::ARM64_INS_ST2,
            711 => arm64_insn::ARM64_INS_ST2B,
            712 => arm64_insn::ARM64_INS_ST2D,
            713 => arm64_insn::ARM64_INS_ST2H,
            714 => arm64_insn::ARM64_INS_ST2W,
            715 => arm64_insn::ARM64_INS_ST3,
            716 => arm64_insn::ARM64_INS_ST3B,
            717 => arm64_insn::ARM64_INS_ST3D,
            718 => arm64_insn::ARM64_INS_ST3H,
            719 => arm64_insn::ARM64_INS_ST3W,
            720 => arm64_insn::ARM64_INS_ST4,
            721 => arm64_insn::ARM64_INS_ST4B,
            722 => arm64_insn::ARM64_INS_ST4D,
            723 => arm64_insn::ARM64_INS_ST4H,
            724 => arm64_insn::ARM64_INS_ST4W,
            725 => arm64_insn::ARM64_INS_STADD,
            726 => arm64_insn::ARM64_INS_STADDB,
            727 => arm64_insn::ARM64_INS_STADDH,
            728 => arm64_insn::ARM64_INS_STADDL,
            729 => arm64_insn::ARM64_INS_STADDLB,
            730 => arm64_insn::ARM64_INS_STADDLH,
            731 => arm64_insn::ARM64_INS_STCLR,
            732 => arm64_insn::ARM64_INS_STCLRB,
            733 => arm64_insn::ARM64_INS_STCLRH,
            734 => arm64_insn::ARM64_INS_STCLRL,
            735 => arm64_insn::ARM64_INS_STCLRLB,
            736 => arm64_insn::ARM64_INS_STCLRLH,
            737 => arm64_insn::ARM64_INS_STEOR,
            738 => arm64_insn::ARM64_INS_STEORB,
            739 => arm64_insn::ARM64_INS_STEORH,
            740 => arm64_insn::ARM64_INS_STEORL,
            741 => arm64_insn::ARM64_INS_STEORLB,
            742 => arm64_insn::ARM64_INS_STEORLH,
            743 => arm64_insn::ARM64_INS_STLLR,
            744 => arm64_insn::ARM64_INS_STLLRB,
            745 => arm64_insn::ARM64_INS_STLLRH,
            746 => arm64_insn::ARM64_INS_STLR,
            747 => arm64_insn::ARM64_INS_STLRB,
            748 => arm64_insn::ARM64_INS_STLRH,
            749 => arm64_insn::ARM64_INS_STLUR,
            750 => arm64_insn::ARM64_INS_STLURB,
            751 => arm64_insn::ARM64_INS_STLURH,
            752 => arm64_insn::ARM64_INS_STLXP,
            753 => arm64_insn::ARM64_INS_STLXR,
            754 => arm64_insn::ARM64_INS_STLXRB,
            755 => arm64_insn::ARM64_INS_STLXRH,
            756 => arm64_insn::ARM64_INS_STNP,
            757 => arm64_insn::ARM64_INS_STNT1B,
            758 => arm64_insn::ARM64_INS_STNT1D,
            759 => arm64_insn::ARM64_INS_STNT1H,
            760 => arm64_insn::ARM64_INS_STNT1W,
            761 => arm64_insn::ARM64_INS_STP,
            762 => arm64_insn::ARM64_INS_STR,
            763 => arm64_insn::ARM64_INS_STRB,
            764 => arm64_insn::ARM64_INS_STRH,
            765 => arm64_insn::ARM64_INS_STSET,
            766 => arm64_insn::ARM64_INS_STSETB,
            767 => arm64_insn::ARM64_INS_STSETH,
            768 => arm64_insn::ARM64_INS_STSETL,
            769 => arm64_insn::ARM64_INS_STSETLB,
            770 => arm64_insn::ARM64_INS_STSETLH,
            771 => arm64_insn::ARM64_INS_STSMAX,
            772 => arm64_insn::ARM64_INS_STSMAXB,
            773 => arm64_insn::ARM64_INS_STSMAXH,
            774 => arm64_insn::ARM64_INS_STSMAXL,
            775 => arm64_insn::ARM64_INS_STSMAXLB,
            776 => arm64_insn::ARM64_INS_STSMAXLH,
            777 => arm64_insn::ARM64_INS_STSMIN,
            778 => arm64_insn::ARM64_INS_STSMINB,
            779 => arm64_insn::ARM64_INS_STSMINH,
            780 => arm64_insn::ARM64_INS_STSMINL,
            781 => arm64_insn::ARM64_INS_STSMINLB,
            782 => arm64_insn::ARM64_INS_STSMINLH,
            783 => arm64_insn::ARM64_INS_STTR,
            784 => arm64_insn::ARM64_INS_STTRB,
            785 => arm64_insn::ARM64_INS_STTRH,
            786 => arm64_insn::ARM64_INS_STUMAX,
            787 => arm64_insn::ARM64_INS_STUMAXB,
            788 => arm64_insn::ARM64_INS_STUMAXH,
            789 => arm64_insn::ARM64_INS_STUMAXL,
            790 => arm64_insn::ARM64_INS_STUMAXLB,
            791 => arm64_insn::ARM64_INS_STUMAXLH,
            792 => arm64_insn::ARM64_INS_STUMIN,
            793 => arm64_insn::ARM64_INS_STUMINB,
            794 => arm64_insn::ARM64_INS_STUMINH,
            795 => arm64_insn::ARM64_INS_STUMINL,
            796 => arm64_insn::ARM64_INS_STUMINLB,
            797 => arm64_insn::ARM64_INS_STUMINLH,
            798 => arm64_insn::ARM64_INS_STUR,
            799 => arm64_insn::ARM64_INS_STURB,
            800 => arm64_insn::ARM64_INS_STURH,
            801 => arm64_insn::ARM64_INS_STXP,
            802 => arm64_insn::ARM64_INS_STXR,
            803 => arm64_insn::ARM64_INS_STXRB,
            804 => arm64_insn::ARM64_INS_STXRH,
            805 => arm64_insn::ARM64_INS_SUB,
            806 => arm64_insn::ARM64_INS_SUBHN,
            807 => arm64_insn::ARM64_INS_SUBHN2,
            808 => arm64_insn::ARM64_INS_SUBR,
            809 => arm64_insn::ARM64_INS_SUBS,
            810 => arm64_insn::ARM64_INS_SUNPKHI,
            811 => arm64_insn::ARM64_INS_SUNPKLO,
            812 => arm64_insn::ARM64_INS_SUQADD,
            813 => arm64_insn::ARM64_INS_SVC,
            814 => arm64_insn::ARM64_INS_SWP,
            815 => arm64_insn::ARM64_INS_SWPA,
            816 => arm64_insn::ARM64_INS_SWPAB,
            817 => arm64_insn::ARM64_INS_SWPAH,
            818 => arm64_insn::ARM64_INS_SWPAL,
            819 => arm64_insn::ARM64_INS_SWPALB,
            820 => arm64_insn::ARM64_INS_SWPALH,
            821 => arm64_insn::ARM64_INS_SWPB,
            822 => arm64_insn::ARM64_INS_SWPH,
            823 => arm64_insn::ARM64_INS_SWPL,
            824 => arm64_insn::ARM64_INS_SWPLB,
            825 => arm64_insn::ARM64_INS_SWPLH,
            826 => arm64_insn::ARM64_INS_SXTB,
            827 => arm64_insn::ARM64_INS_SXTH,
            828 => arm64_insn::ARM64_INS_SXTL,
            829 => arm64_insn::ARM64_INS_SXTL2,
            830 => arm64_insn::ARM64_INS_SXTW,
            831 => arm64_insn::ARM64_INS_SYS,
            832 => arm64_insn::ARM64_INS_SYSL,
            833 => arm64_insn::ARM64_INS_TBL,
            834 => arm64_insn::ARM64_INS_TBNZ,
            835 => arm64_insn::ARM64_INS_TBX,
            836 => arm64_insn::ARM64_INS_TBZ,
            837 => arm64_insn::ARM64_INS_TRN1,
            838 => arm64_insn::ARM64_INS_TRN2,
            839 => arm64_insn::ARM64_INS_TSB,
            840 => arm64_insn::ARM64_INS_TST,
            841 => arm64_insn::ARM64_INS_UABA,
            842 => arm64_insn::ARM64_INS_UABAL,
            843 => arm64_insn::ARM64_INS_UABAL2,
            844 => arm64_insn::ARM64_INS_UABD,
            845 => arm64_insn::ARM64_INS_UABDL,
            846 => arm64_insn::ARM64_INS_UABDL2,
            847 => arm64_insn::ARM64_INS_UADALP,
            848 => arm64_insn::ARM64_INS_UADDL,
            849 => arm64_insn::ARM64_INS_UADDL2,
            850 => arm64_insn::ARM64_INS_UADDLP,
            851 => arm64_insn::ARM64_INS_UADDLV,
            852 => arm64_insn::ARM64_INS_UADDV,
            853 => arm64_insn::ARM64_INS_UADDW,
            854 => arm64_insn::ARM64_INS_UADDW2,
            855 => arm64_insn::ARM64_INS_UBFM,
            856 => arm64_insn::ARM64_INS_UCVTF,
            857 => arm64_insn::ARM64_INS_UDIV,
            858 => arm64_insn::ARM64_INS_UDIVR,
            859 => arm64_insn::ARM64_INS_UDOT,
            860 => arm64_insn::ARM64_INS_UHADD,
            861 => arm64_insn::ARM64_INS_UHSUB,
            862 => arm64_insn::ARM64_INS_UMADDL,
            863 => arm64_insn::ARM64_INS_UMAX,
            864 => arm64_insn::ARM64_INS_UMAXP,
            865 => arm64_insn::ARM64_INS_UMAXV,
            866 => arm64_insn::ARM64_INS_UMIN,
            867 => arm64_insn::ARM64_INS_UMINP,
            868 => arm64_insn::ARM64_INS_UMINV,
            869 => arm64_insn::ARM64_INS_UMLAL,
            870 => arm64_insn::ARM64_INS_UMLAL2,
            871 => arm64_insn::ARM64_INS_UMLSL,
            872 => arm64_insn::ARM64_INS_UMLSL2,
            873 => arm64_insn::ARM64_INS_UMNEGL,
            874 => arm64_insn::ARM64_INS_UMOV,
            875 => arm64_insn::ARM64_INS_UMSUBL,
            876 => arm64_insn::ARM64_INS_UMULH,
            877 => arm64_insn::ARM64_INS_UMULL,
            878 => arm64_insn::ARM64_INS_UMULL2,
            879 => arm64_insn::ARM64_INS_UQADD,
            880 => arm64_insn::ARM64_INS_UQDECB,
            881 => arm64_insn::ARM64_INS_UQDECD,
            882 => arm64_insn::ARM64_INS_UQDECH,
            883 => arm64_insn::ARM64_INS_UQDECP,
            884 => arm64_insn::ARM64_INS_UQDECW,
            885 => arm64_insn::ARM64_INS_UQINCB,
            886 => arm64_insn::ARM64_INS_UQINCD,
            887 => arm64_insn::ARM64_INS_UQINCH,
            888 => arm64_insn::ARM64_INS_UQINCP,
            889 => arm64_insn::ARM64_INS_UQINCW,
            890 => arm64_insn::ARM64_INS_UQRSHL,
            891 => arm64_insn::ARM64_INS_UQRSHRN,
            892 => arm64_insn::ARM64_INS_UQRSHRN2,
            893 => arm64_insn::ARM64_INS_UQSHL,
            894 => arm64_insn::ARM64_INS_UQSHRN,
            895 => arm64_insn::ARM64_INS_UQSHRN2,
            896 => arm64_insn::ARM64_INS_UQSUB,
            897 => arm64_insn::ARM64_INS_UQXTN,
            898 => arm64_insn::ARM64_INS_UQXTN2,
            899 => arm64_insn::ARM64_INS_URECPE,
            900 => arm64_insn::ARM64_INS_URHADD,
            901 => arm64_insn::ARM64_INS_URSHL,
            902 => arm64_insn::ARM64_INS_URSHR,
            903 => arm64_insn::ARM64_INS_URSQRTE,
            904 => arm64_insn::ARM64_INS_URSRA,
            905 => arm64_insn::ARM64_INS_USHL,
            906 => arm64_insn::ARM64_INS_USHLL,
            907 => arm64_insn::ARM64_INS_USHLL2,
            908 => arm64_insn::ARM64_INS_USHR,
            909 => arm64_insn::ARM64_INS_USQADD,
            910 => arm64_insn::ARM64_INS_USRA,
            911 => arm64_insn::ARM64_INS_USUBL,
            912 => arm64_insn::ARM64_INS_USUBL2,
            913 => arm64_insn::ARM64_INS_USUBW,
            914 => arm64_insn::ARM64_INS_USUBW2,
            915 => arm64_insn::ARM64_INS_UUNPKHI,
            916 => arm64_insn::ARM64_INS_UUNPKLO,
            917 => arm64_insn::ARM64_INS_UXTB,
            918 => arm64_insn::ARM64_INS_UXTH,
            919 => arm64_insn::ARM64_INS_UXTL,
            920 => arm64_insn::ARM64_INS_UXTL2,
            921 => arm64_insn::ARM64_INS_UXTW,
            922 => arm64_insn::ARM64_INS_UZP1,
            923 => arm64_insn::ARM64_INS_UZP2,
            924 => arm64_insn::ARM64_INS_WFE,
            925 => arm64_insn::ARM64_INS_WFI,
            926 => arm64_insn::ARM64_INS_WHILELE,
            927 => arm64_insn::ARM64_INS_WHILELO,
            928 => arm64_insn::ARM64_INS_WHILELS,
            929 => arm64_insn::ARM64_INS_WHILELT,
            930 => arm64_insn::ARM64_INS_WRFFR,
            931 => arm64_insn::ARM64_INS_XAR,
            932 => arm64_insn::ARM64_INS_XPACD,
            933 => arm64_insn::ARM64_INS_XPACI,
            934 => arm64_insn::ARM64_INS_XPACLRI,
            935 => arm64_insn::ARM64_INS_XTN,
            936 => arm64_insn::ARM64_INS_XTN2,
            937 => arm64_insn::ARM64_INS_YIELD,
            938 => arm64_insn::ARM64_INS_ZIP1,
            939 => arm64_insn::ARM64_INS_ZIP2,
            940 => arm64_insn::ARM64_INS_SBFIZ,
            941 => arm64_insn::ARM64_INS_UBFIZ,
            942 => arm64_insn::ARM64_INS_SBFX,
            943 => arm64_insn::ARM64_INS_UBFX,
            944 => arm64_insn::ARM64_INS_BFI,
            945 => arm64_insn::ARM64_INS_BFXIL,
            946 => arm64_insn::ARM64_INS_IC,
            947 => arm64_insn::ARM64_INS_DC,
            948 => arm64_insn::ARM64_INS_AT,
            949 => arm64_insn::ARM64_INS_TLBI,
            950 => arm64_insn::ARM64_INS_ENDING,
            _ => arm64_insn::ARM64_INS_INVALID,
        }
    }
}
impl From<u32> for evm_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => evm_insn::EVM_INS_STOP,
            1 => evm_insn::EVM_INS_ADD,
            2 => evm_insn::EVM_INS_MUL,
            3 => evm_insn::EVM_INS_SUB,
            4 => evm_insn::EVM_INS_DIV,
            5 => evm_insn::EVM_INS_SDIV,
            6 => evm_insn::EVM_INS_MOD,
            7 => evm_insn::EVM_INS_SMOD,
            8 => evm_insn::EVM_INS_ADDMOD,
            9 => evm_insn::EVM_INS_MULMOD,
            10 => evm_insn::EVM_INS_EXP,
            11 => evm_insn::EVM_INS_SIGNEXTEND,
            16 => evm_insn::EVM_INS_LT,
            17 => evm_insn::EVM_INS_GT,
            18 => evm_insn::EVM_INS_SLT,
            19 => evm_insn::EVM_INS_SGT,
            20 => evm_insn::EVM_INS_EQ,
            21 => evm_insn::EVM_INS_ISZERO,
            22 => evm_insn::EVM_INS_AND,
            23 => evm_insn::EVM_INS_OR,
            24 => evm_insn::EVM_INS_XOR,
            25 => evm_insn::EVM_INS_NOT,
            26 => evm_insn::EVM_INS_BYTE,
            32 => evm_insn::EVM_INS_SHA3,
            48 => evm_insn::EVM_INS_ADDRESS,
            49 => evm_insn::EVM_INS_BALANCE,
            50 => evm_insn::EVM_INS_ORIGIN,
            51 => evm_insn::EVM_INS_CALLER,
            52 => evm_insn::EVM_INS_CALLVALUE,
            53 => evm_insn::EVM_INS_CALLDATALOAD,
            54 => evm_insn::EVM_INS_CALLDATASIZE,
            55 => evm_insn::EVM_INS_CALLDATACOPY,
            56 => evm_insn::EVM_INS_CODESIZE,
            57 => evm_insn::EVM_INS_CODECOPY,
            58 => evm_insn::EVM_INS_GASPRICE,
            59 => evm_insn::EVM_INS_EXTCODESIZE,
            60 => evm_insn::EVM_INS_EXTCODECOPY,
            61 => evm_insn::EVM_INS_RETURNDATASIZE,
            62 => evm_insn::EVM_INS_RETURNDATACOPY,
            64 => evm_insn::EVM_INS_BLOCKHASH,
            65 => evm_insn::EVM_INS_COINBASE,
            66 => evm_insn::EVM_INS_TIMESTAMP,
            67 => evm_insn::EVM_INS_NUMBER,
            68 => evm_insn::EVM_INS_DIFFICULTY,
            69 => evm_insn::EVM_INS_GASLIMIT,
            80 => evm_insn::EVM_INS_POP,
            81 => evm_insn::EVM_INS_MLOAD,
            82 => evm_insn::EVM_INS_MSTORE,
            83 => evm_insn::EVM_INS_MSTORE8,
            84 => evm_insn::EVM_INS_SLOAD,
            85 => evm_insn::EVM_INS_SSTORE,
            86 => evm_insn::EVM_INS_JUMP,
            87 => evm_insn::EVM_INS_JUMPI,
            88 => evm_insn::EVM_INS_PC,
            89 => evm_insn::EVM_INS_MSIZE,
            90 => evm_insn::EVM_INS_GAS,
            91 => evm_insn::EVM_INS_JUMPDEST,
            96 => evm_insn::EVM_INS_PUSH1,
            97 => evm_insn::EVM_INS_PUSH2,
            98 => evm_insn::EVM_INS_PUSH3,
            99 => evm_insn::EVM_INS_PUSH4,
            100 => evm_insn::EVM_INS_PUSH5,
            101 => evm_insn::EVM_INS_PUSH6,
            102 => evm_insn::EVM_INS_PUSH7,
            103 => evm_insn::EVM_INS_PUSH8,
            104 => evm_insn::EVM_INS_PUSH9,
            105 => evm_insn::EVM_INS_PUSH10,
            106 => evm_insn::EVM_INS_PUSH11,
            107 => evm_insn::EVM_INS_PUSH12,
            108 => evm_insn::EVM_INS_PUSH13,
            109 => evm_insn::EVM_INS_PUSH14,
            110 => evm_insn::EVM_INS_PUSH15,
            111 => evm_insn::EVM_INS_PUSH16,
            112 => evm_insn::EVM_INS_PUSH17,
            113 => evm_insn::EVM_INS_PUSH18,
            114 => evm_insn::EVM_INS_PUSH19,
            115 => evm_insn::EVM_INS_PUSH20,
            116 => evm_insn::EVM_INS_PUSH21,
            117 => evm_insn::EVM_INS_PUSH22,
            118 => evm_insn::EVM_INS_PUSH23,
            119 => evm_insn::EVM_INS_PUSH24,
            120 => evm_insn::EVM_INS_PUSH25,
            121 => evm_insn::EVM_INS_PUSH26,
            122 => evm_insn::EVM_INS_PUSH27,
            123 => evm_insn::EVM_INS_PUSH28,
            124 => evm_insn::EVM_INS_PUSH29,
            125 => evm_insn::EVM_INS_PUSH30,
            126 => evm_insn::EVM_INS_PUSH31,
            127 => evm_insn::EVM_INS_PUSH32,
            128 => evm_insn::EVM_INS_DUP1,
            129 => evm_insn::EVM_INS_DUP2,
            130 => evm_insn::EVM_INS_DUP3,
            131 => evm_insn::EVM_INS_DUP4,
            132 => evm_insn::EVM_INS_DUP5,
            133 => evm_insn::EVM_INS_DUP6,
            134 => evm_insn::EVM_INS_DUP7,
            135 => evm_insn::EVM_INS_DUP8,
            136 => evm_insn::EVM_INS_DUP9,
            137 => evm_insn::EVM_INS_DUP10,
            138 => evm_insn::EVM_INS_DUP11,
            139 => evm_insn::EVM_INS_DUP12,
            140 => evm_insn::EVM_INS_DUP13,
            141 => evm_insn::EVM_INS_DUP14,
            142 => evm_insn::EVM_INS_DUP15,
            143 => evm_insn::EVM_INS_DUP16,
            144 => evm_insn::EVM_INS_SWAP1,
            145 => evm_insn::EVM_INS_SWAP2,
            146 => evm_insn::EVM_INS_SWAP3,
            147 => evm_insn::EVM_INS_SWAP4,
            148 => evm_insn::EVM_INS_SWAP5,
            149 => evm_insn::EVM_INS_SWAP6,
            150 => evm_insn::EVM_INS_SWAP7,
            151 => evm_insn::EVM_INS_SWAP8,
            152 => evm_insn::EVM_INS_SWAP9,
            153 => evm_insn::EVM_INS_SWAP10,
            154 => evm_insn::EVM_INS_SWAP11,
            155 => evm_insn::EVM_INS_SWAP12,
            156 => evm_insn::EVM_INS_SWAP13,
            157 => evm_insn::EVM_INS_SWAP14,
            158 => evm_insn::EVM_INS_SWAP15,
            159 => evm_insn::EVM_INS_SWAP16,
            160 => evm_insn::EVM_INS_LOG0,
            161 => evm_insn::EVM_INS_LOG1,
            162 => evm_insn::EVM_INS_LOG2,
            163 => evm_insn::EVM_INS_LOG3,
            164 => evm_insn::EVM_INS_LOG4,
            240 => evm_insn::EVM_INS_CREATE,
            241 => evm_insn::EVM_INS_CALL,
            242 => evm_insn::EVM_INS_CALLCODE,
            243 => evm_insn::EVM_INS_RETURN,
            244 => evm_insn::EVM_INS_DELEGATECALL,
            245 => evm_insn::EVM_INS_CALLBLACKBOX,
            250 => evm_insn::EVM_INS_STATICCALL,
            253 => evm_insn::EVM_INS_REVERT,
            255 => evm_insn::EVM_INS_SUICIDE,
            512 => evm_insn::EVM_INS_INVALID,
            513 => evm_insn::EVM_INS_ENDING,
            _ => evm_insn::EVM_INS_INVALID,
        }
    }
}
impl From<u32> for m680x_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => m680x_insn::M680X_INS_INVLD,
            1 => m680x_insn::M680X_INS_ABA,
            2 => m680x_insn::M680X_INS_ABX,
            3 => m680x_insn::M680X_INS_ABY,
            4 => m680x_insn::M680X_INS_ADC,
            5 => m680x_insn::M680X_INS_ADCA,
            6 => m680x_insn::M680X_INS_ADCB,
            7 => m680x_insn::M680X_INS_ADCD,
            8 => m680x_insn::M680X_INS_ADCR,
            9 => m680x_insn::M680X_INS_ADD,
            10 => m680x_insn::M680X_INS_ADDA,
            11 => m680x_insn::M680X_INS_ADDB,
            12 => m680x_insn::M680X_INS_ADDD,
            13 => m680x_insn::M680X_INS_ADDE,
            14 => m680x_insn::M680X_INS_ADDF,
            15 => m680x_insn::M680X_INS_ADDR,
            16 => m680x_insn::M680X_INS_ADDW,
            17 => m680x_insn::M680X_INS_AIM,
            18 => m680x_insn::M680X_INS_AIS,
            19 => m680x_insn::M680X_INS_AIX,
            20 => m680x_insn::M680X_INS_AND,
            21 => m680x_insn::M680X_INS_ANDA,
            22 => m680x_insn::M680X_INS_ANDB,
            23 => m680x_insn::M680X_INS_ANDCC,
            24 => m680x_insn::M680X_INS_ANDD,
            25 => m680x_insn::M680X_INS_ANDR,
            26 => m680x_insn::M680X_INS_ASL,
            27 => m680x_insn::M680X_INS_ASLA,
            28 => m680x_insn::M680X_INS_ASLB,
            29 => m680x_insn::M680X_INS_ASLD,
            30 => m680x_insn::M680X_INS_ASR,
            31 => m680x_insn::M680X_INS_ASRA,
            32 => m680x_insn::M680X_INS_ASRB,
            33 => m680x_insn::M680X_INS_ASRD,
            34 => m680x_insn::M680X_INS_ASRX,
            35 => m680x_insn::M680X_INS_BAND,
            36 => m680x_insn::M680X_INS_BCC,
            37 => m680x_insn::M680X_INS_BCLR,
            38 => m680x_insn::M680X_INS_BCS,
            39 => m680x_insn::M680X_INS_BEOR,
            40 => m680x_insn::M680X_INS_BEQ,
            41 => m680x_insn::M680X_INS_BGE,
            42 => m680x_insn::M680X_INS_BGND,
            43 => m680x_insn::M680X_INS_BGT,
            44 => m680x_insn::M680X_INS_BHCC,
            45 => m680x_insn::M680X_INS_BHCS,
            46 => m680x_insn::M680X_INS_BHI,
            47 => m680x_insn::M680X_INS_BIAND,
            48 => m680x_insn::M680X_INS_BIEOR,
            49 => m680x_insn::M680X_INS_BIH,
            50 => m680x_insn::M680X_INS_BIL,
            51 => m680x_insn::M680X_INS_BIOR,
            52 => m680x_insn::M680X_INS_BIT,
            53 => m680x_insn::M680X_INS_BITA,
            54 => m680x_insn::M680X_INS_BITB,
            55 => m680x_insn::M680X_INS_BITD,
            56 => m680x_insn::M680X_INS_BITMD,
            57 => m680x_insn::M680X_INS_BLE,
            58 => m680x_insn::M680X_INS_BLS,
            59 => m680x_insn::M680X_INS_BLT,
            60 => m680x_insn::M680X_INS_BMC,
            61 => m680x_insn::M680X_INS_BMI,
            62 => m680x_insn::M680X_INS_BMS,
            63 => m680x_insn::M680X_INS_BNE,
            64 => m680x_insn::M680X_INS_BOR,
            65 => m680x_insn::M680X_INS_BPL,
            66 => m680x_insn::M680X_INS_BRCLR,
            67 => m680x_insn::M680X_INS_BRSET,
            68 => m680x_insn::M680X_INS_BRA,
            69 => m680x_insn::M680X_INS_BRN,
            70 => m680x_insn::M680X_INS_BSET,
            71 => m680x_insn::M680X_INS_BSR,
            72 => m680x_insn::M680X_INS_BVC,
            73 => m680x_insn::M680X_INS_BVS,
            74 => m680x_insn::M680X_INS_CALL,
            75 => m680x_insn::M680X_INS_CBA,
            76 => m680x_insn::M680X_INS_CBEQ,
            77 => m680x_insn::M680X_INS_CBEQA,
            78 => m680x_insn::M680X_INS_CBEQX,
            79 => m680x_insn::M680X_INS_CLC,
            80 => m680x_insn::M680X_INS_CLI,
            81 => m680x_insn::M680X_INS_CLR,
            82 => m680x_insn::M680X_INS_CLRA,
            83 => m680x_insn::M680X_INS_CLRB,
            84 => m680x_insn::M680X_INS_CLRD,
            85 => m680x_insn::M680X_INS_CLRE,
            86 => m680x_insn::M680X_INS_CLRF,
            87 => m680x_insn::M680X_INS_CLRH,
            88 => m680x_insn::M680X_INS_CLRW,
            89 => m680x_insn::M680X_INS_CLRX,
            90 => m680x_insn::M680X_INS_CLV,
            91 => m680x_insn::M680X_INS_CMP,
            92 => m680x_insn::M680X_INS_CMPA,
            93 => m680x_insn::M680X_INS_CMPB,
            94 => m680x_insn::M680X_INS_CMPD,
            95 => m680x_insn::M680X_INS_CMPE,
            96 => m680x_insn::M680X_INS_CMPF,
            97 => m680x_insn::M680X_INS_CMPR,
            98 => m680x_insn::M680X_INS_CMPS,
            99 => m680x_insn::M680X_INS_CMPU,
            100 => m680x_insn::M680X_INS_CMPW,
            101 => m680x_insn::M680X_INS_CMPX,
            102 => m680x_insn::M680X_INS_CMPY,
            103 => m680x_insn::M680X_INS_COM,
            104 => m680x_insn::M680X_INS_COMA,
            105 => m680x_insn::M680X_INS_COMB,
            106 => m680x_insn::M680X_INS_COMD,
            107 => m680x_insn::M680X_INS_COME,
            108 => m680x_insn::M680X_INS_COMF,
            109 => m680x_insn::M680X_INS_COMW,
            110 => m680x_insn::M680X_INS_COMX,
            111 => m680x_insn::M680X_INS_CPD,
            112 => m680x_insn::M680X_INS_CPHX,
            113 => m680x_insn::M680X_INS_CPS,
            114 => m680x_insn::M680X_INS_CPX,
            115 => m680x_insn::M680X_INS_CPY,
            116 => m680x_insn::M680X_INS_CWAI,
            117 => m680x_insn::M680X_INS_DAA,
            118 => m680x_insn::M680X_INS_DBEQ,
            119 => m680x_insn::M680X_INS_DBNE,
            120 => m680x_insn::M680X_INS_DBNZ,
            121 => m680x_insn::M680X_INS_DBNZA,
            122 => m680x_insn::M680X_INS_DBNZX,
            123 => m680x_insn::M680X_INS_DEC,
            124 => m680x_insn::M680X_INS_DECA,
            125 => m680x_insn::M680X_INS_DECB,
            126 => m680x_insn::M680X_INS_DECD,
            127 => m680x_insn::M680X_INS_DECE,
            128 => m680x_insn::M680X_INS_DECF,
            129 => m680x_insn::M680X_INS_DECW,
            130 => m680x_insn::M680X_INS_DECX,
            131 => m680x_insn::M680X_INS_DES,
            132 => m680x_insn::M680X_INS_DEX,
            133 => m680x_insn::M680X_INS_DEY,
            134 => m680x_insn::M680X_INS_DIV,
            135 => m680x_insn::M680X_INS_DIVD,
            136 => m680x_insn::M680X_INS_DIVQ,
            137 => m680x_insn::M680X_INS_EDIV,
            138 => m680x_insn::M680X_INS_EDIVS,
            139 => m680x_insn::M680X_INS_EIM,
            140 => m680x_insn::M680X_INS_EMACS,
            141 => m680x_insn::M680X_INS_EMAXD,
            142 => m680x_insn::M680X_INS_EMAXM,
            143 => m680x_insn::M680X_INS_EMIND,
            144 => m680x_insn::M680X_INS_EMINM,
            145 => m680x_insn::M680X_INS_EMUL,
            146 => m680x_insn::M680X_INS_EMULS,
            147 => m680x_insn::M680X_INS_EOR,
            148 => m680x_insn::M680X_INS_EORA,
            149 => m680x_insn::M680X_INS_EORB,
            150 => m680x_insn::M680X_INS_EORD,
            151 => m680x_insn::M680X_INS_EORR,
            152 => m680x_insn::M680X_INS_ETBL,
            153 => m680x_insn::M680X_INS_EXG,
            154 => m680x_insn::M680X_INS_FDIV,
            155 => m680x_insn::M680X_INS_IBEQ,
            156 => m680x_insn::M680X_INS_IBNE,
            157 => m680x_insn::M680X_INS_IDIV,
            158 => m680x_insn::M680X_INS_IDIVS,
            159 => m680x_insn::M680X_INS_ILLGL,
            160 => m680x_insn::M680X_INS_INC,
            161 => m680x_insn::M680X_INS_INCA,
            162 => m680x_insn::M680X_INS_INCB,
            163 => m680x_insn::M680X_INS_INCD,
            164 => m680x_insn::M680X_INS_INCE,
            165 => m680x_insn::M680X_INS_INCF,
            166 => m680x_insn::M680X_INS_INCW,
            167 => m680x_insn::M680X_INS_INCX,
            168 => m680x_insn::M680X_INS_INS,
            169 => m680x_insn::M680X_INS_INX,
            170 => m680x_insn::M680X_INS_INY,
            171 => m680x_insn::M680X_INS_JMP,
            172 => m680x_insn::M680X_INS_JSR,
            173 => m680x_insn::M680X_INS_LBCC,
            174 => m680x_insn::M680X_INS_LBCS,
            175 => m680x_insn::M680X_INS_LBEQ,
            176 => m680x_insn::M680X_INS_LBGE,
            177 => m680x_insn::M680X_INS_LBGT,
            178 => m680x_insn::M680X_INS_LBHI,
            179 => m680x_insn::M680X_INS_LBLE,
            180 => m680x_insn::M680X_INS_LBLS,
            181 => m680x_insn::M680X_INS_LBLT,
            182 => m680x_insn::M680X_INS_LBMI,
            183 => m680x_insn::M680X_INS_LBNE,
            184 => m680x_insn::M680X_INS_LBPL,
            185 => m680x_insn::M680X_INS_LBRA,
            186 => m680x_insn::M680X_INS_LBRN,
            187 => m680x_insn::M680X_INS_LBSR,
            188 => m680x_insn::M680X_INS_LBVC,
            189 => m680x_insn::M680X_INS_LBVS,
            190 => m680x_insn::M680X_INS_LDA,
            191 => m680x_insn::M680X_INS_LDAA,
            192 => m680x_insn::M680X_INS_LDAB,
            193 => m680x_insn::M680X_INS_LDB,
            194 => m680x_insn::M680X_INS_LDBT,
            195 => m680x_insn::M680X_INS_LDD,
            196 => m680x_insn::M680X_INS_LDE,
            197 => m680x_insn::M680X_INS_LDF,
            198 => m680x_insn::M680X_INS_LDHX,
            199 => m680x_insn::M680X_INS_LDMD,
            200 => m680x_insn::M680X_INS_LDQ,
            201 => m680x_insn::M680X_INS_LDS,
            202 => m680x_insn::M680X_INS_LDU,
            203 => m680x_insn::M680X_INS_LDW,
            204 => m680x_insn::M680X_INS_LDX,
            205 => m680x_insn::M680X_INS_LDY,
            206 => m680x_insn::M680X_INS_LEAS,
            207 => m680x_insn::M680X_INS_LEAU,
            208 => m680x_insn::M680X_INS_LEAX,
            209 => m680x_insn::M680X_INS_LEAY,
            210 => m680x_insn::M680X_INS_LSL,
            211 => m680x_insn::M680X_INS_LSLA,
            212 => m680x_insn::M680X_INS_LSLB,
            213 => m680x_insn::M680X_INS_LSLD,
            214 => m680x_insn::M680X_INS_LSLX,
            215 => m680x_insn::M680X_INS_LSR,
            216 => m680x_insn::M680X_INS_LSRA,
            217 => m680x_insn::M680X_INS_LSRB,
            218 => m680x_insn::M680X_INS_LSRD,
            219 => m680x_insn::M680X_INS_LSRW,
            220 => m680x_insn::M680X_INS_LSRX,
            221 => m680x_insn::M680X_INS_MAXA,
            222 => m680x_insn::M680X_INS_MAXM,
            223 => m680x_insn::M680X_INS_MEM,
            224 => m680x_insn::M680X_INS_MINA,
            225 => m680x_insn::M680X_INS_MINM,
            226 => m680x_insn::M680X_INS_MOV,
            227 => m680x_insn::M680X_INS_MOVB,
            228 => m680x_insn::M680X_INS_MOVW,
            229 => m680x_insn::M680X_INS_MUL,
            230 => m680x_insn::M680X_INS_MULD,
            231 => m680x_insn::M680X_INS_NEG,
            232 => m680x_insn::M680X_INS_NEGA,
            233 => m680x_insn::M680X_INS_NEGB,
            234 => m680x_insn::M680X_INS_NEGD,
            235 => m680x_insn::M680X_INS_NEGX,
            236 => m680x_insn::M680X_INS_NOP,
            237 => m680x_insn::M680X_INS_NSA,
            238 => m680x_insn::M680X_INS_OIM,
            239 => m680x_insn::M680X_INS_ORA,
            240 => m680x_insn::M680X_INS_ORAA,
            241 => m680x_insn::M680X_INS_ORAB,
            242 => m680x_insn::M680X_INS_ORB,
            243 => m680x_insn::M680X_INS_ORCC,
            244 => m680x_insn::M680X_INS_ORD,
            245 => m680x_insn::M680X_INS_ORR,
            246 => m680x_insn::M680X_INS_PSHA,
            247 => m680x_insn::M680X_INS_PSHB,
            248 => m680x_insn::M680X_INS_PSHC,
            249 => m680x_insn::M680X_INS_PSHD,
            250 => m680x_insn::M680X_INS_PSHH,
            251 => m680x_insn::M680X_INS_PSHS,
            252 => m680x_insn::M680X_INS_PSHSW,
            253 => m680x_insn::M680X_INS_PSHU,
            254 => m680x_insn::M680X_INS_PSHUW,
            255 => m680x_insn::M680X_INS_PSHX,
            256 => m680x_insn::M680X_INS_PSHY,
            257 => m680x_insn::M680X_INS_PULA,
            258 => m680x_insn::M680X_INS_PULB,
            259 => m680x_insn::M680X_INS_PULC,
            260 => m680x_insn::M680X_INS_PULD,
            261 => m680x_insn::M680X_INS_PULH,
            262 => m680x_insn::M680X_INS_PULS,
            263 => m680x_insn::M680X_INS_PULSW,
            264 => m680x_insn::M680X_INS_PULU,
            265 => m680x_insn::M680X_INS_PULUW,
            266 => m680x_insn::M680X_INS_PULX,
            267 => m680x_insn::M680X_INS_PULY,
            268 => m680x_insn::M680X_INS_REV,
            269 => m680x_insn::M680X_INS_REVW,
            270 => m680x_insn::M680X_INS_ROL,
            271 => m680x_insn::M680X_INS_ROLA,
            272 => m680x_insn::M680X_INS_ROLB,
            273 => m680x_insn::M680X_INS_ROLD,
            274 => m680x_insn::M680X_INS_ROLW,
            275 => m680x_insn::M680X_INS_ROLX,
            276 => m680x_insn::M680X_INS_ROR,
            277 => m680x_insn::M680X_INS_RORA,
            278 => m680x_insn::M680X_INS_RORB,
            279 => m680x_insn::M680X_INS_RORD,
            280 => m680x_insn::M680X_INS_RORW,
            281 => m680x_insn::M680X_INS_RORX,
            282 => m680x_insn::M680X_INS_RSP,
            283 => m680x_insn::M680X_INS_RTC,
            284 => m680x_insn::M680X_INS_RTI,
            285 => m680x_insn::M680X_INS_RTS,
            286 => m680x_insn::M680X_INS_SBA,
            287 => m680x_insn::M680X_INS_SBC,
            288 => m680x_insn::M680X_INS_SBCA,
            289 => m680x_insn::M680X_INS_SBCB,
            290 => m680x_insn::M680X_INS_SBCD,
            291 => m680x_insn::M680X_INS_SBCR,
            292 => m680x_insn::M680X_INS_SEC,
            293 => m680x_insn::M680X_INS_SEI,
            294 => m680x_insn::M680X_INS_SEV,
            295 => m680x_insn::M680X_INS_SEX,
            296 => m680x_insn::M680X_INS_SEXW,
            297 => m680x_insn::M680X_INS_SLP,
            298 => m680x_insn::M680X_INS_STA,
            299 => m680x_insn::M680X_INS_STAA,
            300 => m680x_insn::M680X_INS_STAB,
            301 => m680x_insn::M680X_INS_STB,
            302 => m680x_insn::M680X_INS_STBT,
            303 => m680x_insn::M680X_INS_STD,
            304 => m680x_insn::M680X_INS_STE,
            305 => m680x_insn::M680X_INS_STF,
            306 => m680x_insn::M680X_INS_STOP,
            307 => m680x_insn::M680X_INS_STHX,
            308 => m680x_insn::M680X_INS_STQ,
            309 => m680x_insn::M680X_INS_STS,
            310 => m680x_insn::M680X_INS_STU,
            311 => m680x_insn::M680X_INS_STW,
            312 => m680x_insn::M680X_INS_STX,
            313 => m680x_insn::M680X_INS_STY,
            314 => m680x_insn::M680X_INS_SUB,
            315 => m680x_insn::M680X_INS_SUBA,
            316 => m680x_insn::M680X_INS_SUBB,
            317 => m680x_insn::M680X_INS_SUBD,
            318 => m680x_insn::M680X_INS_SUBE,
            319 => m680x_insn::M680X_INS_SUBF,
            320 => m680x_insn::M680X_INS_SUBR,
            321 => m680x_insn::M680X_INS_SUBW,
            322 => m680x_insn::M680X_INS_SWI,
            323 => m680x_insn::M680X_INS_SWI2,
            324 => m680x_insn::M680X_INS_SWI3,
            325 => m680x_insn::M680X_INS_SYNC,
            326 => m680x_insn::M680X_INS_TAB,
            327 => m680x_insn::M680X_INS_TAP,
            328 => m680x_insn::M680X_INS_TAX,
            329 => m680x_insn::M680X_INS_TBA,
            330 => m680x_insn::M680X_INS_TBEQ,
            331 => m680x_insn::M680X_INS_TBL,
            332 => m680x_insn::M680X_INS_TBNE,
            333 => m680x_insn::M680X_INS_TEST,
            334 => m680x_insn::M680X_INS_TFM,
            335 => m680x_insn::M680X_INS_TFR,
            336 => m680x_insn::M680X_INS_TIM,
            337 => m680x_insn::M680X_INS_TPA,
            338 => m680x_insn::M680X_INS_TST,
            339 => m680x_insn::M680X_INS_TSTA,
            340 => m680x_insn::M680X_INS_TSTB,
            341 => m680x_insn::M680X_INS_TSTD,
            342 => m680x_insn::M680X_INS_TSTE,
            343 => m680x_insn::M680X_INS_TSTF,
            344 => m680x_insn::M680X_INS_TSTW,
            345 => m680x_insn::M680X_INS_TSTX,
            346 => m680x_insn::M680X_INS_TSX,
            347 => m680x_insn::M680X_INS_TSY,
            348 => m680x_insn::M680X_INS_TXA,
            349 => m680x_insn::M680X_INS_TXS,
            350 => m680x_insn::M680X_INS_TYS,
            351 => m680x_insn::M680X_INS_WAI,
            352 => m680x_insn::M680X_INS_WAIT,
            353 => m680x_insn::M680X_INS_WAV,
            354 => m680x_insn::M680X_INS_WAVR,
            355 => m680x_insn::M680X_INS_XGDX,
            356 => m680x_insn::M680X_INS_XGDY,
            357 => m680x_insn::M680X_INS_ENDING,
            _ => m680x_insn::M680X_INS_INVLD,
        }
    }
}
impl From<u32> for m68k_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => m68k_insn::M68K_INS_INVALID,
            1 => m68k_insn::M68K_INS_ABCD,
            2 => m68k_insn::M68K_INS_ADD,
            3 => m68k_insn::M68K_INS_ADDA,
            4 => m68k_insn::M68K_INS_ADDI,
            5 => m68k_insn::M68K_INS_ADDQ,
            6 => m68k_insn::M68K_INS_ADDX,
            7 => m68k_insn::M68K_INS_AND,
            8 => m68k_insn::M68K_INS_ANDI,
            9 => m68k_insn::M68K_INS_ASL,
            10 => m68k_insn::M68K_INS_ASR,
            11 => m68k_insn::M68K_INS_BHS,
            12 => m68k_insn::M68K_INS_BLO,
            13 => m68k_insn::M68K_INS_BHI,
            14 => m68k_insn::M68K_INS_BLS,
            15 => m68k_insn::M68K_INS_BCC,
            16 => m68k_insn::M68K_INS_BCS,
            17 => m68k_insn::M68K_INS_BNE,
            18 => m68k_insn::M68K_INS_BEQ,
            19 => m68k_insn::M68K_INS_BVC,
            20 => m68k_insn::M68K_INS_BVS,
            21 => m68k_insn::M68K_INS_BPL,
            22 => m68k_insn::M68K_INS_BMI,
            23 => m68k_insn::M68K_INS_BGE,
            24 => m68k_insn::M68K_INS_BLT,
            25 => m68k_insn::M68K_INS_BGT,
            26 => m68k_insn::M68K_INS_BLE,
            27 => m68k_insn::M68K_INS_BRA,
            28 => m68k_insn::M68K_INS_BSR,
            29 => m68k_insn::M68K_INS_BCHG,
            30 => m68k_insn::M68K_INS_BCLR,
            31 => m68k_insn::M68K_INS_BSET,
            32 => m68k_insn::M68K_INS_BTST,
            33 => m68k_insn::M68K_INS_BFCHG,
            34 => m68k_insn::M68K_INS_BFCLR,
            35 => m68k_insn::M68K_INS_BFEXTS,
            36 => m68k_insn::M68K_INS_BFEXTU,
            37 => m68k_insn::M68K_INS_BFFFO,
            38 => m68k_insn::M68K_INS_BFINS,
            39 => m68k_insn::M68K_INS_BFSET,
            40 => m68k_insn::M68K_INS_BFTST,
            41 => m68k_insn::M68K_INS_BKPT,
            42 => m68k_insn::M68K_INS_CALLM,
            43 => m68k_insn::M68K_INS_CAS,
            44 => m68k_insn::M68K_INS_CAS2,
            45 => m68k_insn::M68K_INS_CHK,
            46 => m68k_insn::M68K_INS_CHK2,
            47 => m68k_insn::M68K_INS_CLR,
            48 => m68k_insn::M68K_INS_CMP,
            49 => m68k_insn::M68K_INS_CMPA,
            50 => m68k_insn::M68K_INS_CMPI,
            51 => m68k_insn::M68K_INS_CMPM,
            52 => m68k_insn::M68K_INS_CMP2,
            53 => m68k_insn::M68K_INS_CINVL,
            54 => m68k_insn::M68K_INS_CINVP,
            55 => m68k_insn::M68K_INS_CINVA,
            56 => m68k_insn::M68K_INS_CPUSHL,
            57 => m68k_insn::M68K_INS_CPUSHP,
            58 => m68k_insn::M68K_INS_CPUSHA,
            59 => m68k_insn::M68K_INS_DBT,
            60 => m68k_insn::M68K_INS_DBF,
            61 => m68k_insn::M68K_INS_DBHI,
            62 => m68k_insn::M68K_INS_DBLS,
            63 => m68k_insn::M68K_INS_DBCC,
            64 => m68k_insn::M68K_INS_DBCS,
            65 => m68k_insn::M68K_INS_DBNE,
            66 => m68k_insn::M68K_INS_DBEQ,
            67 => m68k_insn::M68K_INS_DBVC,
            68 => m68k_insn::M68K_INS_DBVS,
            69 => m68k_insn::M68K_INS_DBPL,
            70 => m68k_insn::M68K_INS_DBMI,
            71 => m68k_insn::M68K_INS_DBGE,
            72 => m68k_insn::M68K_INS_DBLT,
            73 => m68k_insn::M68K_INS_DBGT,
            74 => m68k_insn::M68K_INS_DBLE,
            75 => m68k_insn::M68K_INS_DBRA,
            76 => m68k_insn::M68K_INS_DIVS,
            77 => m68k_insn::M68K_INS_DIVSL,
            78 => m68k_insn::M68K_INS_DIVU,
            79 => m68k_insn::M68K_INS_DIVUL,
            80 => m68k_insn::M68K_INS_EOR,
            81 => m68k_insn::M68K_INS_EORI,
            82 => m68k_insn::M68K_INS_EXG,
            83 => m68k_insn::M68K_INS_EXT,
            84 => m68k_insn::M68K_INS_EXTB,
            85 => m68k_insn::M68K_INS_FABS,
            86 => m68k_insn::M68K_INS_FSABS,
            87 => m68k_insn::M68K_INS_FDABS,
            88 => m68k_insn::M68K_INS_FACOS,
            89 => m68k_insn::M68K_INS_FADD,
            90 => m68k_insn::M68K_INS_FSADD,
            91 => m68k_insn::M68K_INS_FDADD,
            92 => m68k_insn::M68K_INS_FASIN,
            93 => m68k_insn::M68K_INS_FATAN,
            94 => m68k_insn::M68K_INS_FATANH,
            95 => m68k_insn::M68K_INS_FBF,
            96 => m68k_insn::M68K_INS_FBEQ,
            97 => m68k_insn::M68K_INS_FBOGT,
            98 => m68k_insn::M68K_INS_FBOGE,
            99 => m68k_insn::M68K_INS_FBOLT,
            100 => m68k_insn::M68K_INS_FBOLE,
            101 => m68k_insn::M68K_INS_FBOGL,
            102 => m68k_insn::M68K_INS_FBOR,
            103 => m68k_insn::M68K_INS_FBUN,
            104 => m68k_insn::M68K_INS_FBUEQ,
            105 => m68k_insn::M68K_INS_FBUGT,
            106 => m68k_insn::M68K_INS_FBUGE,
            107 => m68k_insn::M68K_INS_FBULT,
            108 => m68k_insn::M68K_INS_FBULE,
            109 => m68k_insn::M68K_INS_FBNE,
            110 => m68k_insn::M68K_INS_FBT,
            111 => m68k_insn::M68K_INS_FBSF,
            112 => m68k_insn::M68K_INS_FBSEQ,
            113 => m68k_insn::M68K_INS_FBGT,
            114 => m68k_insn::M68K_INS_FBGE,
            115 => m68k_insn::M68K_INS_FBLT,
            116 => m68k_insn::M68K_INS_FBLE,
            117 => m68k_insn::M68K_INS_FBGL,
            118 => m68k_insn::M68K_INS_FBGLE,
            119 => m68k_insn::M68K_INS_FBNGLE,
            120 => m68k_insn::M68K_INS_FBNGL,
            121 => m68k_insn::M68K_INS_FBNLE,
            122 => m68k_insn::M68K_INS_FBNLT,
            123 => m68k_insn::M68K_INS_FBNGE,
            124 => m68k_insn::M68K_INS_FBNGT,
            125 => m68k_insn::M68K_INS_FBSNE,
            126 => m68k_insn::M68K_INS_FBST,
            127 => m68k_insn::M68K_INS_FCMP,
            128 => m68k_insn::M68K_INS_FCOS,
            129 => m68k_insn::M68K_INS_FCOSH,
            130 => m68k_insn::M68K_INS_FDBF,
            131 => m68k_insn::M68K_INS_FDBEQ,
            132 => m68k_insn::M68K_INS_FDBOGT,
            133 => m68k_insn::M68K_INS_FDBOGE,
            134 => m68k_insn::M68K_INS_FDBOLT,
            135 => m68k_insn::M68K_INS_FDBOLE,
            136 => m68k_insn::M68K_INS_FDBOGL,
            137 => m68k_insn::M68K_INS_FDBOR,
            138 => m68k_insn::M68K_INS_FDBUN,
            139 => m68k_insn::M68K_INS_FDBUEQ,
            140 => m68k_insn::M68K_INS_FDBUGT,
            141 => m68k_insn::M68K_INS_FDBUGE,
            142 => m68k_insn::M68K_INS_FDBULT,
            143 => m68k_insn::M68K_INS_FDBULE,
            144 => m68k_insn::M68K_INS_FDBNE,
            145 => m68k_insn::M68K_INS_FDBT,
            146 => m68k_insn::M68K_INS_FDBSF,
            147 => m68k_insn::M68K_INS_FDBSEQ,
            148 => m68k_insn::M68K_INS_FDBGT,
            149 => m68k_insn::M68K_INS_FDBGE,
            150 => m68k_insn::M68K_INS_FDBLT,
            151 => m68k_insn::M68K_INS_FDBLE,
            152 => m68k_insn::M68K_INS_FDBGL,
            153 => m68k_insn::M68K_INS_FDBGLE,
            154 => m68k_insn::M68K_INS_FDBNGLE,
            155 => m68k_insn::M68K_INS_FDBNGL,
            156 => m68k_insn::M68K_INS_FDBNLE,
            157 => m68k_insn::M68K_INS_FDBNLT,
            158 => m68k_insn::M68K_INS_FDBNGE,
            159 => m68k_insn::M68K_INS_FDBNGT,
            160 => m68k_insn::M68K_INS_FDBSNE,
            161 => m68k_insn::M68K_INS_FDBST,
            162 => m68k_insn::M68K_INS_FDIV,
            163 => m68k_insn::M68K_INS_FSDIV,
            164 => m68k_insn::M68K_INS_FDDIV,
            165 => m68k_insn::M68K_INS_FETOX,
            166 => m68k_insn::M68K_INS_FETOXM1,
            167 => m68k_insn::M68K_INS_FGETEXP,
            168 => m68k_insn::M68K_INS_FGETMAN,
            169 => m68k_insn::M68K_INS_FINT,
            170 => m68k_insn::M68K_INS_FINTRZ,
            171 => m68k_insn::M68K_INS_FLOG10,
            172 => m68k_insn::M68K_INS_FLOG2,
            173 => m68k_insn::M68K_INS_FLOGN,
            174 => m68k_insn::M68K_INS_FLOGNP1,
            175 => m68k_insn::M68K_INS_FMOD,
            176 => m68k_insn::M68K_INS_FMOVE,
            177 => m68k_insn::M68K_INS_FSMOVE,
            178 => m68k_insn::M68K_INS_FDMOVE,
            179 => m68k_insn::M68K_INS_FMOVECR,
            180 => m68k_insn::M68K_INS_FMOVEM,
            181 => m68k_insn::M68K_INS_FMUL,
            182 => m68k_insn::M68K_INS_FSMUL,
            183 => m68k_insn::M68K_INS_FDMUL,
            184 => m68k_insn::M68K_INS_FNEG,
            185 => m68k_insn::M68K_INS_FSNEG,
            186 => m68k_insn::M68K_INS_FDNEG,
            187 => m68k_insn::M68K_INS_FNOP,
            188 => m68k_insn::M68K_INS_FREM,
            189 => m68k_insn::M68K_INS_FRESTORE,
            190 => m68k_insn::M68K_INS_FSAVE,
            191 => m68k_insn::M68K_INS_FSCALE,
            192 => m68k_insn::M68K_INS_FSGLDIV,
            193 => m68k_insn::M68K_INS_FSGLMUL,
            194 => m68k_insn::M68K_INS_FSIN,
            195 => m68k_insn::M68K_INS_FSINCOS,
            196 => m68k_insn::M68K_INS_FSINH,
            197 => m68k_insn::M68K_INS_FSQRT,
            198 => m68k_insn::M68K_INS_FSSQRT,
            199 => m68k_insn::M68K_INS_FDSQRT,
            200 => m68k_insn::M68K_INS_FSF,
            201 => m68k_insn::M68K_INS_FSBEQ,
            202 => m68k_insn::M68K_INS_FSOGT,
            203 => m68k_insn::M68K_INS_FSOGE,
            204 => m68k_insn::M68K_INS_FSOLT,
            205 => m68k_insn::M68K_INS_FSOLE,
            206 => m68k_insn::M68K_INS_FSOGL,
            207 => m68k_insn::M68K_INS_FSOR,
            208 => m68k_insn::M68K_INS_FSUN,
            209 => m68k_insn::M68K_INS_FSUEQ,
            210 => m68k_insn::M68K_INS_FSUGT,
            211 => m68k_insn::M68K_INS_FSUGE,
            212 => m68k_insn::M68K_INS_FSULT,
            213 => m68k_insn::M68K_INS_FSULE,
            214 => m68k_insn::M68K_INS_FSNE,
            215 => m68k_insn::M68K_INS_FST,
            216 => m68k_insn::M68K_INS_FSSF,
            217 => m68k_insn::M68K_INS_FSSEQ,
            218 => m68k_insn::M68K_INS_FSGT,
            219 => m68k_insn::M68K_INS_FSGE,
            220 => m68k_insn::M68K_INS_FSLT,
            221 => m68k_insn::M68K_INS_FSLE,
            222 => m68k_insn::M68K_INS_FSGL,
            223 => m68k_insn::M68K_INS_FSGLE,
            224 => m68k_insn::M68K_INS_FSNGLE,
            225 => m68k_insn::M68K_INS_FSNGL,
            226 => m68k_insn::M68K_INS_FSNLE,
            227 => m68k_insn::M68K_INS_FSNLT,
            228 => m68k_insn::M68K_INS_FSNGE,
            229 => m68k_insn::M68K_INS_FSNGT,
            230 => m68k_insn::M68K_INS_FSSNE,
            231 => m68k_insn::M68K_INS_FSST,
            232 => m68k_insn::M68K_INS_FSUB,
            233 => m68k_insn::M68K_INS_FSSUB,
            234 => m68k_insn::M68K_INS_FDSUB,
            235 => m68k_insn::M68K_INS_FTAN,
            236 => m68k_insn::M68K_INS_FTANH,
            237 => m68k_insn::M68K_INS_FTENTOX,
            238 => m68k_insn::M68K_INS_FTRAPF,
            239 => m68k_insn::M68K_INS_FTRAPEQ,
            240 => m68k_insn::M68K_INS_FTRAPOGT,
            241 => m68k_insn::M68K_INS_FTRAPOGE,
            242 => m68k_insn::M68K_INS_FTRAPOLT,
            243 => m68k_insn::M68K_INS_FTRAPOLE,
            244 => m68k_insn::M68K_INS_FTRAPOGL,
            245 => m68k_insn::M68K_INS_FTRAPOR,
            246 => m68k_insn::M68K_INS_FTRAPUN,
            247 => m68k_insn::M68K_INS_FTRAPUEQ,
            248 => m68k_insn::M68K_INS_FTRAPUGT,
            249 => m68k_insn::M68K_INS_FTRAPUGE,
            250 => m68k_insn::M68K_INS_FTRAPULT,
            251 => m68k_insn::M68K_INS_FTRAPULE,
            252 => m68k_insn::M68K_INS_FTRAPNE,
            253 => m68k_insn::M68K_INS_FTRAPT,
            254 => m68k_insn::M68K_INS_FTRAPSF,
            255 => m68k_insn::M68K_INS_FTRAPSEQ,
            256 => m68k_insn::M68K_INS_FTRAPGT,
            257 => m68k_insn::M68K_INS_FTRAPGE,
            258 => m68k_insn::M68K_INS_FTRAPLT,
            259 => m68k_insn::M68K_INS_FTRAPLE,
            260 => m68k_insn::M68K_INS_FTRAPGL,
            261 => m68k_insn::M68K_INS_FTRAPGLE,
            262 => m68k_insn::M68K_INS_FTRAPNGLE,
            263 => m68k_insn::M68K_INS_FTRAPNGL,
            264 => m68k_insn::M68K_INS_FTRAPNLE,
            265 => m68k_insn::M68K_INS_FTRAPNLT,
            266 => m68k_insn::M68K_INS_FTRAPNGE,
            267 => m68k_insn::M68K_INS_FTRAPNGT,
            268 => m68k_insn::M68K_INS_FTRAPSNE,
            269 => m68k_insn::M68K_INS_FTRAPST,
            270 => m68k_insn::M68K_INS_FTST,
            271 => m68k_insn::M68K_INS_FTWOTOX,
            272 => m68k_insn::M68K_INS_HALT,
            273 => m68k_insn::M68K_INS_ILLEGAL,
            274 => m68k_insn::M68K_INS_JMP,
            275 => m68k_insn::M68K_INS_JSR,
            276 => m68k_insn::M68K_INS_LEA,
            277 => m68k_insn::M68K_INS_LINK,
            278 => m68k_insn::M68K_INS_LPSTOP,
            279 => m68k_insn::M68K_INS_LSL,
            280 => m68k_insn::M68K_INS_LSR,
            281 => m68k_insn::M68K_INS_MOVE,
            282 => m68k_insn::M68K_INS_MOVEA,
            283 => m68k_insn::M68K_INS_MOVEC,
            284 => m68k_insn::M68K_INS_MOVEM,
            285 => m68k_insn::M68K_INS_MOVEP,
            286 => m68k_insn::M68K_INS_MOVEQ,
            287 => m68k_insn::M68K_INS_MOVES,
            288 => m68k_insn::M68K_INS_MOVE16,
            289 => m68k_insn::M68K_INS_MULS,
            290 => m68k_insn::M68K_INS_MULU,
            291 => m68k_insn::M68K_INS_NBCD,
            292 => m68k_insn::M68K_INS_NEG,
            293 => m68k_insn::M68K_INS_NEGX,
            294 => m68k_insn::M68K_INS_NOP,
            295 => m68k_insn::M68K_INS_NOT,
            296 => m68k_insn::M68K_INS_OR,
            297 => m68k_insn::M68K_INS_ORI,
            298 => m68k_insn::M68K_INS_PACK,
            299 => m68k_insn::M68K_INS_PEA,
            300 => m68k_insn::M68K_INS_PFLUSH,
            301 => m68k_insn::M68K_INS_PFLUSHA,
            302 => m68k_insn::M68K_INS_PFLUSHAN,
            303 => m68k_insn::M68K_INS_PFLUSHN,
            304 => m68k_insn::M68K_INS_PLOADR,
            305 => m68k_insn::M68K_INS_PLOADW,
            306 => m68k_insn::M68K_INS_PLPAR,
            307 => m68k_insn::M68K_INS_PLPAW,
            308 => m68k_insn::M68K_INS_PMOVE,
            309 => m68k_insn::M68K_INS_PMOVEFD,
            310 => m68k_insn::M68K_INS_PTESTR,
            311 => m68k_insn::M68K_INS_PTESTW,
            312 => m68k_insn::M68K_INS_PULSE,
            313 => m68k_insn::M68K_INS_REMS,
            314 => m68k_insn::M68K_INS_REMU,
            315 => m68k_insn::M68K_INS_RESET,
            316 => m68k_insn::M68K_INS_ROL,
            317 => m68k_insn::M68K_INS_ROR,
            318 => m68k_insn::M68K_INS_ROXL,
            319 => m68k_insn::M68K_INS_ROXR,
            320 => m68k_insn::M68K_INS_RTD,
            321 => m68k_insn::M68K_INS_RTE,
            322 => m68k_insn::M68K_INS_RTM,
            323 => m68k_insn::M68K_INS_RTR,
            324 => m68k_insn::M68K_INS_RTS,
            325 => m68k_insn::M68K_INS_SBCD,
            326 => m68k_insn::M68K_INS_ST,
            327 => m68k_insn::M68K_INS_SF,
            328 => m68k_insn::M68K_INS_SHI,
            329 => m68k_insn::M68K_INS_SLS,
            330 => m68k_insn::M68K_INS_SCC,
            331 => m68k_insn::M68K_INS_SHS,
            332 => m68k_insn::M68K_INS_SCS,
            333 => m68k_insn::M68K_INS_SLO,
            334 => m68k_insn::M68K_INS_SNE,
            335 => m68k_insn::M68K_INS_SEQ,
            336 => m68k_insn::M68K_INS_SVC,
            337 => m68k_insn::M68K_INS_SVS,
            338 => m68k_insn::M68K_INS_SPL,
            339 => m68k_insn::M68K_INS_SMI,
            340 => m68k_insn::M68K_INS_SGE,
            341 => m68k_insn::M68K_INS_SLT,
            342 => m68k_insn::M68K_INS_SGT,
            343 => m68k_insn::M68K_INS_SLE,
            344 => m68k_insn::M68K_INS_STOP,
            345 => m68k_insn::M68K_INS_SUB,
            346 => m68k_insn::M68K_INS_SUBA,
            347 => m68k_insn::M68K_INS_SUBI,
            348 => m68k_insn::M68K_INS_SUBQ,
            349 => m68k_insn::M68K_INS_SUBX,
            350 => m68k_insn::M68K_INS_SWAP,
            351 => m68k_insn::M68K_INS_TAS,
            352 => m68k_insn::M68K_INS_TRAP,
            353 => m68k_insn::M68K_INS_TRAPV,
            354 => m68k_insn::M68K_INS_TRAPT,
            355 => m68k_insn::M68K_INS_TRAPF,
            356 => m68k_insn::M68K_INS_TRAPHI,
            357 => m68k_insn::M68K_INS_TRAPLS,
            358 => m68k_insn::M68K_INS_TRAPCC,
            359 => m68k_insn::M68K_INS_TRAPHS,
            360 => m68k_insn::M68K_INS_TRAPCS,
            361 => m68k_insn::M68K_INS_TRAPLO,
            362 => m68k_insn::M68K_INS_TRAPNE,
            363 => m68k_insn::M68K_INS_TRAPEQ,
            364 => m68k_insn::M68K_INS_TRAPVC,
            365 => m68k_insn::M68K_INS_TRAPVS,
            366 => m68k_insn::M68K_INS_TRAPPL,
            367 => m68k_insn::M68K_INS_TRAPMI,
            368 => m68k_insn::M68K_INS_TRAPGE,
            369 => m68k_insn::M68K_INS_TRAPLT,
            370 => m68k_insn::M68K_INS_TRAPGT,
            371 => m68k_insn::M68K_INS_TRAPLE,
            372 => m68k_insn::M68K_INS_TST,
            373 => m68k_insn::M68K_INS_UNLK,
            374 => m68k_insn::M68K_INS_UNPK,
            375 => m68k_insn::M68K_INS_ENDING,
            _ => m68k_insn::M68K_INS_INVALID,
        }
    }
}
impl From<u32> for mips_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => mips_insn::MIPS_INS_INVALID,
            1 => mips_insn::MIPS_INS_ABSQ_S,
            2 => mips_insn::MIPS_INS_ADD,
            3 => mips_insn::MIPS_INS_ADDIUPC,
            4 => mips_insn::MIPS_INS_ADDIUR1SP,
            5 => mips_insn::MIPS_INS_ADDIUR2,
            6 => mips_insn::MIPS_INS_ADDIUS5,
            7 => mips_insn::MIPS_INS_ADDIUSP,
            8 => mips_insn::MIPS_INS_ADDQH,
            9 => mips_insn::MIPS_INS_ADDQH_R,
            10 => mips_insn::MIPS_INS_ADDQ,
            11 => mips_insn::MIPS_INS_ADDQ_S,
            12 => mips_insn::MIPS_INS_ADDSC,
            13 => mips_insn::MIPS_INS_ADDS_A,
            14 => mips_insn::MIPS_INS_ADDS_S,
            15 => mips_insn::MIPS_INS_ADDS_U,
            16 => mips_insn::MIPS_INS_ADDU16,
            17 => mips_insn::MIPS_INS_ADDUH,
            18 => mips_insn::MIPS_INS_ADDUH_R,
            19 => mips_insn::MIPS_INS_ADDU,
            20 => mips_insn::MIPS_INS_ADDU_S,
            21 => mips_insn::MIPS_INS_ADDVI,
            22 => mips_insn::MIPS_INS_ADDV,
            23 => mips_insn::MIPS_INS_ADDWC,
            24 => mips_insn::MIPS_INS_ADD_A,
            25 => mips_insn::MIPS_INS_ADDI,
            26 => mips_insn::MIPS_INS_ADDIU,
            27 => mips_insn::MIPS_INS_ALIGN,
            28 => mips_insn::MIPS_INS_ALUIPC,
            29 => mips_insn::MIPS_INS_AND,
            30 => mips_insn::MIPS_INS_AND16,
            31 => mips_insn::MIPS_INS_ANDI16,
            32 => mips_insn::MIPS_INS_ANDI,
            33 => mips_insn::MIPS_INS_APPEND,
            34 => mips_insn::MIPS_INS_ASUB_S,
            35 => mips_insn::MIPS_INS_ASUB_U,
            36 => mips_insn::MIPS_INS_AUI,
            37 => mips_insn::MIPS_INS_AUIPC,
            38 => mips_insn::MIPS_INS_AVER_S,
            39 => mips_insn::MIPS_INS_AVER_U,
            40 => mips_insn::MIPS_INS_AVE_S,
            41 => mips_insn::MIPS_INS_AVE_U,
            42 => mips_insn::MIPS_INS_B16,
            43 => mips_insn::MIPS_INS_BADDU,
            44 => mips_insn::MIPS_INS_BAL,
            45 => mips_insn::MIPS_INS_BALC,
            46 => mips_insn::MIPS_INS_BALIGN,
            47 => mips_insn::MIPS_INS_BBIT0,
            48 => mips_insn::MIPS_INS_BBIT032,
            49 => mips_insn::MIPS_INS_BBIT1,
            50 => mips_insn::MIPS_INS_BBIT132,
            51 => mips_insn::MIPS_INS_BC,
            52 => mips_insn::MIPS_INS_BC0F,
            53 => mips_insn::MIPS_INS_BC0FL,
            54 => mips_insn::MIPS_INS_BC0T,
            55 => mips_insn::MIPS_INS_BC0TL,
            56 => mips_insn::MIPS_INS_BC1EQZ,
            57 => mips_insn::MIPS_INS_BC1F,
            58 => mips_insn::MIPS_INS_BC1FL,
            59 => mips_insn::MIPS_INS_BC1NEZ,
            60 => mips_insn::MIPS_INS_BC1T,
            61 => mips_insn::MIPS_INS_BC1TL,
            62 => mips_insn::MIPS_INS_BC2EQZ,
            63 => mips_insn::MIPS_INS_BC2F,
            64 => mips_insn::MIPS_INS_BC2FL,
            65 => mips_insn::MIPS_INS_BC2NEZ,
            66 => mips_insn::MIPS_INS_BC2T,
            67 => mips_insn::MIPS_INS_BC2TL,
            68 => mips_insn::MIPS_INS_BC3F,
            69 => mips_insn::MIPS_INS_BC3FL,
            70 => mips_insn::MIPS_INS_BC3T,
            71 => mips_insn::MIPS_INS_BC3TL,
            72 => mips_insn::MIPS_INS_BCLRI,
            73 => mips_insn::MIPS_INS_BCLR,
            74 => mips_insn::MIPS_INS_BEQ,
            75 => mips_insn::MIPS_INS_BEQC,
            76 => mips_insn::MIPS_INS_BEQL,
            77 => mips_insn::MIPS_INS_BEQZ16,
            78 => mips_insn::MIPS_INS_BEQZALC,
            79 => mips_insn::MIPS_INS_BEQZC,
            80 => mips_insn::MIPS_INS_BGEC,
            81 => mips_insn::MIPS_INS_BGEUC,
            82 => mips_insn::MIPS_INS_BGEZ,
            83 => mips_insn::MIPS_INS_BGEZAL,
            84 => mips_insn::MIPS_INS_BGEZALC,
            85 => mips_insn::MIPS_INS_BGEZALL,
            86 => mips_insn::MIPS_INS_BGEZALS,
            87 => mips_insn::MIPS_INS_BGEZC,
            88 => mips_insn::MIPS_INS_BGEZL,
            89 => mips_insn::MIPS_INS_BGTZ,
            90 => mips_insn::MIPS_INS_BGTZALC,
            91 => mips_insn::MIPS_INS_BGTZC,
            92 => mips_insn::MIPS_INS_BGTZL,
            93 => mips_insn::MIPS_INS_BINSLI,
            94 => mips_insn::MIPS_INS_BINSL,
            95 => mips_insn::MIPS_INS_BINSRI,
            96 => mips_insn::MIPS_INS_BINSR,
            97 => mips_insn::MIPS_INS_BITREV,
            98 => mips_insn::MIPS_INS_BITSWAP,
            99 => mips_insn::MIPS_INS_BLEZ,
            100 => mips_insn::MIPS_INS_BLEZALC,
            101 => mips_insn::MIPS_INS_BLEZC,
            102 => mips_insn::MIPS_INS_BLEZL,
            103 => mips_insn::MIPS_INS_BLTC,
            104 => mips_insn::MIPS_INS_BLTUC,
            105 => mips_insn::MIPS_INS_BLTZ,
            106 => mips_insn::MIPS_INS_BLTZAL,
            107 => mips_insn::MIPS_INS_BLTZALC,
            108 => mips_insn::MIPS_INS_BLTZALL,
            109 => mips_insn::MIPS_INS_BLTZALS,
            110 => mips_insn::MIPS_INS_BLTZC,
            111 => mips_insn::MIPS_INS_BLTZL,
            112 => mips_insn::MIPS_INS_BMNZI,
            113 => mips_insn::MIPS_INS_BMNZ,
            114 => mips_insn::MIPS_INS_BMZI,
            115 => mips_insn::MIPS_INS_BMZ,
            116 => mips_insn::MIPS_INS_BNE,
            117 => mips_insn::MIPS_INS_BNEC,
            118 => mips_insn::MIPS_INS_BNEGI,
            119 => mips_insn::MIPS_INS_BNEG,
            120 => mips_insn::MIPS_INS_BNEL,
            121 => mips_insn::MIPS_INS_BNEZ16,
            122 => mips_insn::MIPS_INS_BNEZALC,
            123 => mips_insn::MIPS_INS_BNEZC,
            124 => mips_insn::MIPS_INS_BNVC,
            125 => mips_insn::MIPS_INS_BNZ,
            126 => mips_insn::MIPS_INS_BOVC,
            127 => mips_insn::MIPS_INS_BPOSGE32,
            128 => mips_insn::MIPS_INS_BREAK,
            129 => mips_insn::MIPS_INS_BREAK16,
            130 => mips_insn::MIPS_INS_BSELI,
            131 => mips_insn::MIPS_INS_BSEL,
            132 => mips_insn::MIPS_INS_BSETI,
            133 => mips_insn::MIPS_INS_BSET,
            134 => mips_insn::MIPS_INS_BZ,
            135 => mips_insn::MIPS_INS_BEQZ,
            136 => mips_insn::MIPS_INS_B,
            137 => mips_insn::MIPS_INS_BNEZ,
            138 => mips_insn::MIPS_INS_BTEQZ,
            139 => mips_insn::MIPS_INS_BTNEZ,
            140 => mips_insn::MIPS_INS_CACHE,
            141 => mips_insn::MIPS_INS_CEIL,
            142 => mips_insn::MIPS_INS_CEQI,
            143 => mips_insn::MIPS_INS_CEQ,
            144 => mips_insn::MIPS_INS_CFC1,
            145 => mips_insn::MIPS_INS_CFCMSA,
            146 => mips_insn::MIPS_INS_CINS,
            147 => mips_insn::MIPS_INS_CINS32,
            148 => mips_insn::MIPS_INS_CLASS,
            149 => mips_insn::MIPS_INS_CLEI_S,
            150 => mips_insn::MIPS_INS_CLEI_U,
            151 => mips_insn::MIPS_INS_CLE_S,
            152 => mips_insn::MIPS_INS_CLE_U,
            153 => mips_insn::MIPS_INS_CLO,
            154 => mips_insn::MIPS_INS_CLTI_S,
            155 => mips_insn::MIPS_INS_CLTI_U,
            156 => mips_insn::MIPS_INS_CLT_S,
            157 => mips_insn::MIPS_INS_CLT_U,
            158 => mips_insn::MIPS_INS_CLZ,
            159 => mips_insn::MIPS_INS_CMPGDU,
            160 => mips_insn::MIPS_INS_CMPGU,
            161 => mips_insn::MIPS_INS_CMPU,
            162 => mips_insn::MIPS_INS_CMP,
            163 => mips_insn::MIPS_INS_COPY_S,
            164 => mips_insn::MIPS_INS_COPY_U,
            165 => mips_insn::MIPS_INS_CTC1,
            166 => mips_insn::MIPS_INS_CTCMSA,
            167 => mips_insn::MIPS_INS_CVT,
            168 => mips_insn::MIPS_INS_C,
            169 => mips_insn::MIPS_INS_CMPI,
            170 => mips_insn::MIPS_INS_DADD,
            171 => mips_insn::MIPS_INS_DADDI,
            172 => mips_insn::MIPS_INS_DADDIU,
            173 => mips_insn::MIPS_INS_DADDU,
            174 => mips_insn::MIPS_INS_DAHI,
            175 => mips_insn::MIPS_INS_DALIGN,
            176 => mips_insn::MIPS_INS_DATI,
            177 => mips_insn::MIPS_INS_DAUI,
            178 => mips_insn::MIPS_INS_DBITSWAP,
            179 => mips_insn::MIPS_INS_DCLO,
            180 => mips_insn::MIPS_INS_DCLZ,
            181 => mips_insn::MIPS_INS_DDIV,
            182 => mips_insn::MIPS_INS_DDIVU,
            183 => mips_insn::MIPS_INS_DERET,
            184 => mips_insn::MIPS_INS_DEXT,
            185 => mips_insn::MIPS_INS_DEXTM,
            186 => mips_insn::MIPS_INS_DEXTU,
            187 => mips_insn::MIPS_INS_DI,
            188 => mips_insn::MIPS_INS_DINS,
            189 => mips_insn::MIPS_INS_DINSM,
            190 => mips_insn::MIPS_INS_DINSU,
            191 => mips_insn::MIPS_INS_DIV,
            192 => mips_insn::MIPS_INS_DIVU,
            193 => mips_insn::MIPS_INS_DIV_S,
            194 => mips_insn::MIPS_INS_DIV_U,
            195 => mips_insn::MIPS_INS_DLSA,
            196 => mips_insn::MIPS_INS_DMFC0,
            197 => mips_insn::MIPS_INS_DMFC1,
            198 => mips_insn::MIPS_INS_DMFC2,
            199 => mips_insn::MIPS_INS_DMOD,
            200 => mips_insn::MIPS_INS_DMODU,
            201 => mips_insn::MIPS_INS_DMTC0,
            202 => mips_insn::MIPS_INS_DMTC1,
            203 => mips_insn::MIPS_INS_DMTC2,
            204 => mips_insn::MIPS_INS_DMUH,
            205 => mips_insn::MIPS_INS_DMUHU,
            206 => mips_insn::MIPS_INS_DMUL,
            207 => mips_insn::MIPS_INS_DMULT,
            208 => mips_insn::MIPS_INS_DMULTU,
            209 => mips_insn::MIPS_INS_DMULU,
            210 => mips_insn::MIPS_INS_DOTP_S,
            211 => mips_insn::MIPS_INS_DOTP_U,
            212 => mips_insn::MIPS_INS_DPADD_S,
            213 => mips_insn::MIPS_INS_DPADD_U,
            214 => mips_insn::MIPS_INS_DPAQX_SA,
            215 => mips_insn::MIPS_INS_DPAQX_S,
            216 => mips_insn::MIPS_INS_DPAQ_SA,
            217 => mips_insn::MIPS_INS_DPAQ_S,
            218 => mips_insn::MIPS_INS_DPAU,
            219 => mips_insn::MIPS_INS_DPAX,
            220 => mips_insn::MIPS_INS_DPA,
            221 => mips_insn::MIPS_INS_DPOP,
            222 => mips_insn::MIPS_INS_DPSQX_SA,
            223 => mips_insn::MIPS_INS_DPSQX_S,
            224 => mips_insn::MIPS_INS_DPSQ_SA,
            225 => mips_insn::MIPS_INS_DPSQ_S,
            226 => mips_insn::MIPS_INS_DPSUB_S,
            227 => mips_insn::MIPS_INS_DPSUB_U,
            228 => mips_insn::MIPS_INS_DPSU,
            229 => mips_insn::MIPS_INS_DPSX,
            230 => mips_insn::MIPS_INS_DPS,
            231 => mips_insn::MIPS_INS_DROTR,
            232 => mips_insn::MIPS_INS_DROTR32,
            233 => mips_insn::MIPS_INS_DROTRV,
            234 => mips_insn::MIPS_INS_DSBH,
            235 => mips_insn::MIPS_INS_DSHD,
            236 => mips_insn::MIPS_INS_DSLL,
            237 => mips_insn::MIPS_INS_DSLL32,
            238 => mips_insn::MIPS_INS_DSLLV,
            239 => mips_insn::MIPS_INS_DSRA,
            240 => mips_insn::MIPS_INS_DSRA32,
            241 => mips_insn::MIPS_INS_DSRAV,
            242 => mips_insn::MIPS_INS_DSRL,
            243 => mips_insn::MIPS_INS_DSRL32,
            244 => mips_insn::MIPS_INS_DSRLV,
            245 => mips_insn::MIPS_INS_DSUB,
            246 => mips_insn::MIPS_INS_DSUBU,
            247 => mips_insn::MIPS_INS_EHB,
            248 => mips_insn::MIPS_INS_EI,
            249 => mips_insn::MIPS_INS_ERET,
            250 => mips_insn::MIPS_INS_EXT,
            251 => mips_insn::MIPS_INS_EXTP,
            252 => mips_insn::MIPS_INS_EXTPDP,
            253 => mips_insn::MIPS_INS_EXTPDPV,
            254 => mips_insn::MIPS_INS_EXTPV,
            255 => mips_insn::MIPS_INS_EXTRV_RS,
            256 => mips_insn::MIPS_INS_EXTRV_R,
            257 => mips_insn::MIPS_INS_EXTRV_S,
            258 => mips_insn::MIPS_INS_EXTRV,
            259 => mips_insn::MIPS_INS_EXTR_RS,
            260 => mips_insn::MIPS_INS_EXTR_R,
            261 => mips_insn::MIPS_INS_EXTR_S,
            262 => mips_insn::MIPS_INS_EXTR,
            263 => mips_insn::MIPS_INS_EXTS,
            264 => mips_insn::MIPS_INS_EXTS32,
            265 => mips_insn::MIPS_INS_ABS,
            266 => mips_insn::MIPS_INS_FADD,
            267 => mips_insn::MIPS_INS_FCAF,
            268 => mips_insn::MIPS_INS_FCEQ,
            269 => mips_insn::MIPS_INS_FCLASS,
            270 => mips_insn::MIPS_INS_FCLE,
            271 => mips_insn::MIPS_INS_FCLT,
            272 => mips_insn::MIPS_INS_FCNE,
            273 => mips_insn::MIPS_INS_FCOR,
            274 => mips_insn::MIPS_INS_FCUEQ,
            275 => mips_insn::MIPS_INS_FCULE,
            276 => mips_insn::MIPS_INS_FCULT,
            277 => mips_insn::MIPS_INS_FCUNE,
            278 => mips_insn::MIPS_INS_FCUN,
            279 => mips_insn::MIPS_INS_FDIV,
            280 => mips_insn::MIPS_INS_FEXDO,
            281 => mips_insn::MIPS_INS_FEXP2,
            282 => mips_insn::MIPS_INS_FEXUPL,
            283 => mips_insn::MIPS_INS_FEXUPR,
            284 => mips_insn::MIPS_INS_FFINT_S,
            285 => mips_insn::MIPS_INS_FFINT_U,
            286 => mips_insn::MIPS_INS_FFQL,
            287 => mips_insn::MIPS_INS_FFQR,
            288 => mips_insn::MIPS_INS_FILL,
            289 => mips_insn::MIPS_INS_FLOG2,
            290 => mips_insn::MIPS_INS_FLOOR,
            291 => mips_insn::MIPS_INS_FMADD,
            292 => mips_insn::MIPS_INS_FMAX_A,
            293 => mips_insn::MIPS_INS_FMAX,
            294 => mips_insn::MIPS_INS_FMIN_A,
            295 => mips_insn::MIPS_INS_FMIN,
            296 => mips_insn::MIPS_INS_MOV,
            297 => mips_insn::MIPS_INS_FMSUB,
            298 => mips_insn::MIPS_INS_FMUL,
            299 => mips_insn::MIPS_INS_MUL,
            300 => mips_insn::MIPS_INS_NEG,
            301 => mips_insn::MIPS_INS_FRCP,
            302 => mips_insn::MIPS_INS_FRINT,
            303 => mips_insn::MIPS_INS_FRSQRT,
            304 => mips_insn::MIPS_INS_FSAF,
            305 => mips_insn::MIPS_INS_FSEQ,
            306 => mips_insn::MIPS_INS_FSLE,
            307 => mips_insn::MIPS_INS_FSLT,
            308 => mips_insn::MIPS_INS_FSNE,
            309 => mips_insn::MIPS_INS_FSOR,
            310 => mips_insn::MIPS_INS_FSQRT,
            311 => mips_insn::MIPS_INS_SQRT,
            312 => mips_insn::MIPS_INS_FSUB,
            313 => mips_insn::MIPS_INS_SUB,
            314 => mips_insn::MIPS_INS_FSUEQ,
            315 => mips_insn::MIPS_INS_FSULE,
            316 => mips_insn::MIPS_INS_FSULT,
            317 => mips_insn::MIPS_INS_FSUNE,
            318 => mips_insn::MIPS_INS_FSUN,
            319 => mips_insn::MIPS_INS_FTINT_S,
            320 => mips_insn::MIPS_INS_FTINT_U,
            321 => mips_insn::MIPS_INS_FTQ,
            322 => mips_insn::MIPS_INS_FTRUNC_S,
            323 => mips_insn::MIPS_INS_FTRUNC_U,
            324 => mips_insn::MIPS_INS_HADD_S,
            325 => mips_insn::MIPS_INS_HADD_U,
            326 => mips_insn::MIPS_INS_HSUB_S,
            327 => mips_insn::MIPS_INS_HSUB_U,
            328 => mips_insn::MIPS_INS_ILVEV,
            329 => mips_insn::MIPS_INS_ILVL,
            330 => mips_insn::MIPS_INS_ILVOD,
            331 => mips_insn::MIPS_INS_ILVR,
            332 => mips_insn::MIPS_INS_INS,
            333 => mips_insn::MIPS_INS_INSERT,
            334 => mips_insn::MIPS_INS_INSV,
            335 => mips_insn::MIPS_INS_INSVE,
            336 => mips_insn::MIPS_INS_J,
            337 => mips_insn::MIPS_INS_JAL,
            338 => mips_insn::MIPS_INS_JALR,
            339 => mips_insn::MIPS_INS_JALRS16,
            340 => mips_insn::MIPS_INS_JALRS,
            341 => mips_insn::MIPS_INS_JALS,
            342 => mips_insn::MIPS_INS_JALX,
            343 => mips_insn::MIPS_INS_JIALC,
            344 => mips_insn::MIPS_INS_JIC,
            345 => mips_insn::MIPS_INS_JR,
            346 => mips_insn::MIPS_INS_JR16,
            347 => mips_insn::MIPS_INS_JRADDIUSP,
            348 => mips_insn::MIPS_INS_JRC,
            349 => mips_insn::MIPS_INS_JALRC,
            350 => mips_insn::MIPS_INS_LB,
            351 => mips_insn::MIPS_INS_LBU16,
            352 => mips_insn::MIPS_INS_LBUX,
            353 => mips_insn::MIPS_INS_LBU,
            354 => mips_insn::MIPS_INS_LD,
            355 => mips_insn::MIPS_INS_LDC1,
            356 => mips_insn::MIPS_INS_LDC2,
            357 => mips_insn::MIPS_INS_LDC3,
            358 => mips_insn::MIPS_INS_LDI,
            359 => mips_insn::MIPS_INS_LDL,
            360 => mips_insn::MIPS_INS_LDPC,
            361 => mips_insn::MIPS_INS_LDR,
            362 => mips_insn::MIPS_INS_LDXC1,
            363 => mips_insn::MIPS_INS_LH,
            364 => mips_insn::MIPS_INS_LHU16,
            365 => mips_insn::MIPS_INS_LHX,
            366 => mips_insn::MIPS_INS_LHU,
            367 => mips_insn::MIPS_INS_LI16,
            368 => mips_insn::MIPS_INS_LL,
            369 => mips_insn::MIPS_INS_LLD,
            370 => mips_insn::MIPS_INS_LSA,
            371 => mips_insn::MIPS_INS_LUXC1,
            372 => mips_insn::MIPS_INS_LUI,
            373 => mips_insn::MIPS_INS_LW,
            374 => mips_insn::MIPS_INS_LW16,
            375 => mips_insn::MIPS_INS_LWC1,
            376 => mips_insn::MIPS_INS_LWC2,
            377 => mips_insn::MIPS_INS_LWC3,
            378 => mips_insn::MIPS_INS_LWL,
            379 => mips_insn::MIPS_INS_LWM16,
            380 => mips_insn::MIPS_INS_LWM32,
            381 => mips_insn::MIPS_INS_LWPC,
            382 => mips_insn::MIPS_INS_LWP,
            383 => mips_insn::MIPS_INS_LWR,
            384 => mips_insn::MIPS_INS_LWUPC,
            385 => mips_insn::MIPS_INS_LWU,
            386 => mips_insn::MIPS_INS_LWX,
            387 => mips_insn::MIPS_INS_LWXC1,
            388 => mips_insn::MIPS_INS_LWXS,
            389 => mips_insn::MIPS_INS_LI,
            390 => mips_insn::MIPS_INS_MADD,
            391 => mips_insn::MIPS_INS_MADDF,
            392 => mips_insn::MIPS_INS_MADDR_Q,
            393 => mips_insn::MIPS_INS_MADDU,
            394 => mips_insn::MIPS_INS_MADDV,
            395 => mips_insn::MIPS_INS_MADD_Q,
            396 => mips_insn::MIPS_INS_MAQ_SA,
            397 => mips_insn::MIPS_INS_MAQ_S,
            398 => mips_insn::MIPS_INS_MAXA,
            399 => mips_insn::MIPS_INS_MAXI_S,
            400 => mips_insn::MIPS_INS_MAXI_U,
            401 => mips_insn::MIPS_INS_MAX_A,
            402 => mips_insn::MIPS_INS_MAX,
            403 => mips_insn::MIPS_INS_MAX_S,
            404 => mips_insn::MIPS_INS_MAX_U,
            405 => mips_insn::MIPS_INS_MFC0,
            406 => mips_insn::MIPS_INS_MFC1,
            407 => mips_insn::MIPS_INS_MFC2,
            408 => mips_insn::MIPS_INS_MFHC1,
            409 => mips_insn::MIPS_INS_MFHI,
            410 => mips_insn::MIPS_INS_MFLO,
            411 => mips_insn::MIPS_INS_MINA,
            412 => mips_insn::MIPS_INS_MINI_S,
            413 => mips_insn::MIPS_INS_MINI_U,
            414 => mips_insn::MIPS_INS_MIN_A,
            415 => mips_insn::MIPS_INS_MIN,
            416 => mips_insn::MIPS_INS_MIN_S,
            417 => mips_insn::MIPS_INS_MIN_U,
            418 => mips_insn::MIPS_INS_MOD,
            419 => mips_insn::MIPS_INS_MODSUB,
            420 => mips_insn::MIPS_INS_MODU,
            421 => mips_insn::MIPS_INS_MOD_S,
            422 => mips_insn::MIPS_INS_MOD_U,
            423 => mips_insn::MIPS_INS_MOVE,
            424 => mips_insn::MIPS_INS_MOVEP,
            425 => mips_insn::MIPS_INS_MOVF,
            426 => mips_insn::MIPS_INS_MOVN,
            427 => mips_insn::MIPS_INS_MOVT,
            428 => mips_insn::MIPS_INS_MOVZ,
            429 => mips_insn::MIPS_INS_MSUB,
            430 => mips_insn::MIPS_INS_MSUBF,
            431 => mips_insn::MIPS_INS_MSUBR_Q,
            432 => mips_insn::MIPS_INS_MSUBU,
            433 => mips_insn::MIPS_INS_MSUBV,
            434 => mips_insn::MIPS_INS_MSUB_Q,
            435 => mips_insn::MIPS_INS_MTC0,
            436 => mips_insn::MIPS_INS_MTC1,
            437 => mips_insn::MIPS_INS_MTC2,
            438 => mips_insn::MIPS_INS_MTHC1,
            439 => mips_insn::MIPS_INS_MTHI,
            440 => mips_insn::MIPS_INS_MTHLIP,
            441 => mips_insn::MIPS_INS_MTLO,
            442 => mips_insn::MIPS_INS_MTM0,
            443 => mips_insn::MIPS_INS_MTM1,
            444 => mips_insn::MIPS_INS_MTM2,
            445 => mips_insn::MIPS_INS_MTP0,
            446 => mips_insn::MIPS_INS_MTP1,
            447 => mips_insn::MIPS_INS_MTP2,
            448 => mips_insn::MIPS_INS_MUH,
            449 => mips_insn::MIPS_INS_MUHU,
            450 => mips_insn::MIPS_INS_MULEQ_S,
            451 => mips_insn::MIPS_INS_MULEU_S,
            452 => mips_insn::MIPS_INS_MULQ_RS,
            453 => mips_insn::MIPS_INS_MULQ_S,
            454 => mips_insn::MIPS_INS_MULR_Q,
            455 => mips_insn::MIPS_INS_MULSAQ_S,
            456 => mips_insn::MIPS_INS_MULSA,
            457 => mips_insn::MIPS_INS_MULT,
            458 => mips_insn::MIPS_INS_MULTU,
            459 => mips_insn::MIPS_INS_MULU,
            460 => mips_insn::MIPS_INS_MULV,
            461 => mips_insn::MIPS_INS_MUL_Q,
            462 => mips_insn::MIPS_INS_MUL_S,
            463 => mips_insn::MIPS_INS_NLOC,
            464 => mips_insn::MIPS_INS_NLZC,
            465 => mips_insn::MIPS_INS_NMADD,
            466 => mips_insn::MIPS_INS_NMSUB,
            467 => mips_insn::MIPS_INS_NOR,
            468 => mips_insn::MIPS_INS_NORI,
            469 => mips_insn::MIPS_INS_NOT16,
            470 => mips_insn::MIPS_INS_NOT,
            471 => mips_insn::MIPS_INS_OR,
            472 => mips_insn::MIPS_INS_OR16,
            473 => mips_insn::MIPS_INS_ORI,
            474 => mips_insn::MIPS_INS_PACKRL,
            475 => mips_insn::MIPS_INS_PAUSE,
            476 => mips_insn::MIPS_INS_PCKEV,
            477 => mips_insn::MIPS_INS_PCKOD,
            478 => mips_insn::MIPS_INS_PCNT,
            479 => mips_insn::MIPS_INS_PICK,
            480 => mips_insn::MIPS_INS_POP,
            481 => mips_insn::MIPS_INS_PRECEQU,
            482 => mips_insn::MIPS_INS_PRECEQ,
            483 => mips_insn::MIPS_INS_PRECEU,
            484 => mips_insn::MIPS_INS_PRECRQU_S,
            485 => mips_insn::MIPS_INS_PRECRQ,
            486 => mips_insn::MIPS_INS_PRECRQ_RS,
            487 => mips_insn::MIPS_INS_PRECR,
            488 => mips_insn::MIPS_INS_PRECR_SRA,
            489 => mips_insn::MIPS_INS_PRECR_SRA_R,
            490 => mips_insn::MIPS_INS_PREF,
            491 => mips_insn::MIPS_INS_PREPEND,
            492 => mips_insn::MIPS_INS_RADDU,
            493 => mips_insn::MIPS_INS_RDDSP,
            494 => mips_insn::MIPS_INS_RDHWR,
            495 => mips_insn::MIPS_INS_REPLV,
            496 => mips_insn::MIPS_INS_REPL,
            497 => mips_insn::MIPS_INS_RINT,
            498 => mips_insn::MIPS_INS_ROTR,
            499 => mips_insn::MIPS_INS_ROTRV,
            500 => mips_insn::MIPS_INS_ROUND,
            501 => mips_insn::MIPS_INS_SAT_S,
            502 => mips_insn::MIPS_INS_SAT_U,
            503 => mips_insn::MIPS_INS_SB,
            504 => mips_insn::MIPS_INS_SB16,
            505 => mips_insn::MIPS_INS_SC,
            506 => mips_insn::MIPS_INS_SCD,
            507 => mips_insn::MIPS_INS_SD,
            508 => mips_insn::MIPS_INS_SDBBP,
            509 => mips_insn::MIPS_INS_SDBBP16,
            510 => mips_insn::MIPS_INS_SDC1,
            511 => mips_insn::MIPS_INS_SDC2,
            512 => mips_insn::MIPS_INS_SDC3,
            513 => mips_insn::MIPS_INS_SDL,
            514 => mips_insn::MIPS_INS_SDR,
            515 => mips_insn::MIPS_INS_SDXC1,
            516 => mips_insn::MIPS_INS_SEB,
            517 => mips_insn::MIPS_INS_SEH,
            518 => mips_insn::MIPS_INS_SELEQZ,
            519 => mips_insn::MIPS_INS_SELNEZ,
            520 => mips_insn::MIPS_INS_SEL,
            521 => mips_insn::MIPS_INS_SEQ,
            522 => mips_insn::MIPS_INS_SEQI,
            523 => mips_insn::MIPS_INS_SH,
            524 => mips_insn::MIPS_INS_SH16,
            525 => mips_insn::MIPS_INS_SHF,
            526 => mips_insn::MIPS_INS_SHILO,
            527 => mips_insn::MIPS_INS_SHILOV,
            528 => mips_insn::MIPS_INS_SHLLV,
            529 => mips_insn::MIPS_INS_SHLLV_S,
            530 => mips_insn::MIPS_INS_SHLL,
            531 => mips_insn::MIPS_INS_SHLL_S,
            532 => mips_insn::MIPS_INS_SHRAV,
            533 => mips_insn::MIPS_INS_SHRAV_R,
            534 => mips_insn::MIPS_INS_SHRA,
            535 => mips_insn::MIPS_INS_SHRA_R,
            536 => mips_insn::MIPS_INS_SHRLV,
            537 => mips_insn::MIPS_INS_SHRL,
            538 => mips_insn::MIPS_INS_SLDI,
            539 => mips_insn::MIPS_INS_SLD,
            540 => mips_insn::MIPS_INS_SLL,
            541 => mips_insn::MIPS_INS_SLL16,
            542 => mips_insn::MIPS_INS_SLLI,
            543 => mips_insn::MIPS_INS_SLLV,
            544 => mips_insn::MIPS_INS_SLT,
            545 => mips_insn::MIPS_INS_SLTI,
            546 => mips_insn::MIPS_INS_SLTIU,
            547 => mips_insn::MIPS_INS_SLTU,
            548 => mips_insn::MIPS_INS_SNE,
            549 => mips_insn::MIPS_INS_SNEI,
            550 => mips_insn::MIPS_INS_SPLATI,
            551 => mips_insn::MIPS_INS_SPLAT,
            552 => mips_insn::MIPS_INS_SRA,
            553 => mips_insn::MIPS_INS_SRAI,
            554 => mips_insn::MIPS_INS_SRARI,
            555 => mips_insn::MIPS_INS_SRAR,
            556 => mips_insn::MIPS_INS_SRAV,
            557 => mips_insn::MIPS_INS_SRL,
            558 => mips_insn::MIPS_INS_SRL16,
            559 => mips_insn::MIPS_INS_SRLI,
            560 => mips_insn::MIPS_INS_SRLRI,
            561 => mips_insn::MIPS_INS_SRLR,
            562 => mips_insn::MIPS_INS_SRLV,
            563 => mips_insn::MIPS_INS_SSNOP,
            564 => mips_insn::MIPS_INS_ST,
            565 => mips_insn::MIPS_INS_SUBQH,
            566 => mips_insn::MIPS_INS_SUBQH_R,
            567 => mips_insn::MIPS_INS_SUBQ,
            568 => mips_insn::MIPS_INS_SUBQ_S,
            569 => mips_insn::MIPS_INS_SUBSUS_U,
            570 => mips_insn::MIPS_INS_SUBSUU_S,
            571 => mips_insn::MIPS_INS_SUBS_S,
            572 => mips_insn::MIPS_INS_SUBS_U,
            573 => mips_insn::MIPS_INS_SUBU16,
            574 => mips_insn::MIPS_INS_SUBUH,
            575 => mips_insn::MIPS_INS_SUBUH_R,
            576 => mips_insn::MIPS_INS_SUBU,
            577 => mips_insn::MIPS_INS_SUBU_S,
            578 => mips_insn::MIPS_INS_SUBVI,
            579 => mips_insn::MIPS_INS_SUBV,
            580 => mips_insn::MIPS_INS_SUXC1,
            581 => mips_insn::MIPS_INS_SW,
            582 => mips_insn::MIPS_INS_SW16,
            583 => mips_insn::MIPS_INS_SWC1,
            584 => mips_insn::MIPS_INS_SWC2,
            585 => mips_insn::MIPS_INS_SWC3,
            586 => mips_insn::MIPS_INS_SWL,
            587 => mips_insn::MIPS_INS_SWM16,
            588 => mips_insn::MIPS_INS_SWM32,
            589 => mips_insn::MIPS_INS_SWP,
            590 => mips_insn::MIPS_INS_SWR,
            591 => mips_insn::MIPS_INS_SWXC1,
            592 => mips_insn::MIPS_INS_SYNC,
            593 => mips_insn::MIPS_INS_SYNCI,
            594 => mips_insn::MIPS_INS_SYSCALL,
            595 => mips_insn::MIPS_INS_TEQ,
            596 => mips_insn::MIPS_INS_TEQI,
            597 => mips_insn::MIPS_INS_TGE,
            598 => mips_insn::MIPS_INS_TGEI,
            599 => mips_insn::MIPS_INS_TGEIU,
            600 => mips_insn::MIPS_INS_TGEU,
            601 => mips_insn::MIPS_INS_TLBP,
            602 => mips_insn::MIPS_INS_TLBR,
            603 => mips_insn::MIPS_INS_TLBWI,
            604 => mips_insn::MIPS_INS_TLBWR,
            605 => mips_insn::MIPS_INS_TLT,
            606 => mips_insn::MIPS_INS_TLTI,
            607 => mips_insn::MIPS_INS_TLTIU,
            608 => mips_insn::MIPS_INS_TLTU,
            609 => mips_insn::MIPS_INS_TNE,
            610 => mips_insn::MIPS_INS_TNEI,
            611 => mips_insn::MIPS_INS_TRUNC,
            612 => mips_insn::MIPS_INS_V3MULU,
            613 => mips_insn::MIPS_INS_VMM0,
            614 => mips_insn::MIPS_INS_VMULU,
            615 => mips_insn::MIPS_INS_VSHF,
            616 => mips_insn::MIPS_INS_WAIT,
            617 => mips_insn::MIPS_INS_WRDSP,
            618 => mips_insn::MIPS_INS_WSBH,
            619 => mips_insn::MIPS_INS_XOR,
            620 => mips_insn::MIPS_INS_XOR16,
            621 => mips_insn::MIPS_INS_XORI,
            622 => mips_insn::MIPS_INS_NOP,
            623 => mips_insn::MIPS_INS_NEGU,
            624 => mips_insn::MIPS_INS_JALR_HB,
            625 => mips_insn::MIPS_INS_JR_HB,
            626 => mips_insn::MIPS_INS_ENDING,
            _ => mips_insn::MIPS_INS_INVALID,
        }
    }
}
impl From<u32> for ppc_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => ppc_insn::PPC_INS_INVALID,
            1 => ppc_insn::PPC_INS_ADD,
            2 => ppc_insn::PPC_INS_ADDC,
            3 => ppc_insn::PPC_INS_ADDE,
            4 => ppc_insn::PPC_INS_ADDI,
            5 => ppc_insn::PPC_INS_ADDIC,
            6 => ppc_insn::PPC_INS_ADDIS,
            7 => ppc_insn::PPC_INS_ADDME,
            8 => ppc_insn::PPC_INS_ADDPCIS,
            9 => ppc_insn::PPC_INS_ADDZE,
            10 => ppc_insn::PPC_INS_AND,
            11 => ppc_insn::PPC_INS_ANDC,
            12 => ppc_insn::PPC_INS_ANDI,
            13 => ppc_insn::PPC_INS_ANDIS,
            14 => ppc_insn::PPC_INS_ATTN,
            15 => ppc_insn::PPC_INS_B,
            16 => ppc_insn::PPC_INS_BA,
            17 => ppc_insn::PPC_INS_BC,
            18 => ppc_insn::PPC_INS_BCA,
            19 => ppc_insn::PPC_INS_BCCTR,
            20 => ppc_insn::PPC_INS_BCCTRL,
            21 => ppc_insn::PPC_INS_BCDCFN,
            22 => ppc_insn::PPC_INS_BCDCFSQ,
            23 => ppc_insn::PPC_INS_BCDCFZ,
            24 => ppc_insn::PPC_INS_BCDCPSGN,
            25 => ppc_insn::PPC_INS_BCDCTN,
            26 => ppc_insn::PPC_INS_BCDCTSQ,
            27 => ppc_insn::PPC_INS_BCDCTZ,
            28 => ppc_insn::PPC_INS_BCDS,
            29 => ppc_insn::PPC_INS_BCDSETSGN,
            30 => ppc_insn::PPC_INS_BCDSR,
            31 => ppc_insn::PPC_INS_BCDTRUNC,
            32 => ppc_insn::PPC_INS_BCDUS,
            33 => ppc_insn::PPC_INS_BCDUTRUNC,
            34 => ppc_insn::PPC_INS_BCL,
            35 => ppc_insn::PPC_INS_BCLA,
            36 => ppc_insn::PPC_INS_BCLR,
            37 => ppc_insn::PPC_INS_BCLRL,
            38 => ppc_insn::PPC_INS_BCTR,
            39 => ppc_insn::PPC_INS_BCTRL,
            40 => ppc_insn::PPC_INS_BDNZ,
            41 => ppc_insn::PPC_INS_BDNZA,
            42 => ppc_insn::PPC_INS_BDNZF,
            43 => ppc_insn::PPC_INS_BDNZFA,
            44 => ppc_insn::PPC_INS_BDNZFL,
            45 => ppc_insn::PPC_INS_BDNZFLA,
            46 => ppc_insn::PPC_INS_BDNZFLR,
            47 => ppc_insn::PPC_INS_BDNZFLRL,
            48 => ppc_insn::PPC_INS_BDNZL,
            49 => ppc_insn::PPC_INS_BDNZLA,
            50 => ppc_insn::PPC_INS_BDNZLR,
            51 => ppc_insn::PPC_INS_BDNZLRL,
            52 => ppc_insn::PPC_INS_BDNZT,
            53 => ppc_insn::PPC_INS_BDNZTA,
            54 => ppc_insn::PPC_INS_BDNZTL,
            55 => ppc_insn::PPC_INS_BDNZTLA,
            56 => ppc_insn::PPC_INS_BDNZTLR,
            57 => ppc_insn::PPC_INS_BDNZTLRL,
            58 => ppc_insn::PPC_INS_BDZ,
            59 => ppc_insn::PPC_INS_BDZA,
            60 => ppc_insn::PPC_INS_BDZF,
            61 => ppc_insn::PPC_INS_BDZFA,
            62 => ppc_insn::PPC_INS_BDZFL,
            63 => ppc_insn::PPC_INS_BDZFLA,
            64 => ppc_insn::PPC_INS_BDZFLR,
            65 => ppc_insn::PPC_INS_BDZFLRL,
            66 => ppc_insn::PPC_INS_BDZL,
            67 => ppc_insn::PPC_INS_BDZLA,
            68 => ppc_insn::PPC_INS_BDZLR,
            69 => ppc_insn::PPC_INS_BDZLRL,
            70 => ppc_insn::PPC_INS_BDZT,
            71 => ppc_insn::PPC_INS_BDZTA,
            72 => ppc_insn::PPC_INS_BDZTL,
            73 => ppc_insn::PPC_INS_BDZTLA,
            74 => ppc_insn::PPC_INS_BDZTLR,
            75 => ppc_insn::PPC_INS_BDZTLRL,
            76 => ppc_insn::PPC_INS_BEQ,
            77 => ppc_insn::PPC_INS_BEQA,
            78 => ppc_insn::PPC_INS_BEQCTR,
            79 => ppc_insn::PPC_INS_BEQCTRL,
            80 => ppc_insn::PPC_INS_BEQL,
            81 => ppc_insn::PPC_INS_BEQLA,
            82 => ppc_insn::PPC_INS_BEQLR,
            83 => ppc_insn::PPC_INS_BEQLRL,
            84 => ppc_insn::PPC_INS_BF,
            85 => ppc_insn::PPC_INS_BFA,
            86 => ppc_insn::PPC_INS_BFCTR,
            87 => ppc_insn::PPC_INS_BFCTRL,
            88 => ppc_insn::PPC_INS_BFL,
            89 => ppc_insn::PPC_INS_BFLA,
            90 => ppc_insn::PPC_INS_BFLR,
            91 => ppc_insn::PPC_INS_BFLRL,
            92 => ppc_insn::PPC_INS_BGE,
            93 => ppc_insn::PPC_INS_BGEA,
            94 => ppc_insn::PPC_INS_BGECTR,
            95 => ppc_insn::PPC_INS_BGECTRL,
            96 => ppc_insn::PPC_INS_BGEL,
            97 => ppc_insn::PPC_INS_BGELA,
            98 => ppc_insn::PPC_INS_BGELR,
            99 => ppc_insn::PPC_INS_BGELRL,
            100 => ppc_insn::PPC_INS_BGT,
            101 => ppc_insn::PPC_INS_BGTA,
            102 => ppc_insn::PPC_INS_BGTCTR,
            103 => ppc_insn::PPC_INS_BGTCTRL,
            104 => ppc_insn::PPC_INS_BGTL,
            105 => ppc_insn::PPC_INS_BGTLA,
            106 => ppc_insn::PPC_INS_BGTLR,
            107 => ppc_insn::PPC_INS_BGTLRL,
            108 => ppc_insn::PPC_INS_BL,
            109 => ppc_insn::PPC_INS_BLA,
            110 => ppc_insn::PPC_INS_BLE,
            111 => ppc_insn::PPC_INS_BLEA,
            112 => ppc_insn::PPC_INS_BLECTR,
            113 => ppc_insn::PPC_INS_BLECTRL,
            114 => ppc_insn::PPC_INS_BLEL,
            115 => ppc_insn::PPC_INS_BLELA,
            116 => ppc_insn::PPC_INS_BLELR,
            117 => ppc_insn::PPC_INS_BLELRL,
            118 => ppc_insn::PPC_INS_BLR,
            119 => ppc_insn::PPC_INS_BLRL,
            120 => ppc_insn::PPC_INS_BLT,
            121 => ppc_insn::PPC_INS_BLTA,
            122 => ppc_insn::PPC_INS_BLTCTR,
            123 => ppc_insn::PPC_INS_BLTCTRL,
            124 => ppc_insn::PPC_INS_BLTL,
            125 => ppc_insn::PPC_INS_BLTLA,
            126 => ppc_insn::PPC_INS_BLTLR,
            127 => ppc_insn::PPC_INS_BLTLRL,
            128 => ppc_insn::PPC_INS_BNE,
            129 => ppc_insn::PPC_INS_BNEA,
            130 => ppc_insn::PPC_INS_BNECTR,
            131 => ppc_insn::PPC_INS_BNECTRL,
            132 => ppc_insn::PPC_INS_BNEL,
            133 => ppc_insn::PPC_INS_BNELA,
            134 => ppc_insn::PPC_INS_BNELR,
            135 => ppc_insn::PPC_INS_BNELRL,
            136 => ppc_insn::PPC_INS_BNG,
            137 => ppc_insn::PPC_INS_BNGA,
            138 => ppc_insn::PPC_INS_BNGCTR,
            139 => ppc_insn::PPC_INS_BNGCTRL,
            140 => ppc_insn::PPC_INS_BNGL,
            141 => ppc_insn::PPC_INS_BNGLA,
            142 => ppc_insn::PPC_INS_BNGLR,
            143 => ppc_insn::PPC_INS_BNGLRL,
            144 => ppc_insn::PPC_INS_BNL,
            145 => ppc_insn::PPC_INS_BNLA,
            146 => ppc_insn::PPC_INS_BNLCTR,
            147 => ppc_insn::PPC_INS_BNLCTRL,
            148 => ppc_insn::PPC_INS_BNLL,
            149 => ppc_insn::PPC_INS_BNLLA,
            150 => ppc_insn::PPC_INS_BNLLR,
            151 => ppc_insn::PPC_INS_BNLLRL,
            152 => ppc_insn::PPC_INS_BNS,
            153 => ppc_insn::PPC_INS_BNSA,
            154 => ppc_insn::PPC_INS_BNSCTR,
            155 => ppc_insn::PPC_INS_BNSCTRL,
            156 => ppc_insn::PPC_INS_BNSL,
            157 => ppc_insn::PPC_INS_BNSLA,
            158 => ppc_insn::PPC_INS_BNSLR,
            159 => ppc_insn::PPC_INS_BNSLRL,
            160 => ppc_insn::PPC_INS_BNU,
            161 => ppc_insn::PPC_INS_BNUA,
            162 => ppc_insn::PPC_INS_BNUCTR,
            163 => ppc_insn::PPC_INS_BNUCTRL,
            164 => ppc_insn::PPC_INS_BNUL,
            165 => ppc_insn::PPC_INS_BNULA,
            166 => ppc_insn::PPC_INS_BNULR,
            167 => ppc_insn::PPC_INS_BNULRL,
            168 => ppc_insn::PPC_INS_BPERMD,
            169 => ppc_insn::PPC_INS_BRINC,
            170 => ppc_insn::PPC_INS_BSO,
            171 => ppc_insn::PPC_INS_BSOA,
            172 => ppc_insn::PPC_INS_BSOCTR,
            173 => ppc_insn::PPC_INS_BSOCTRL,
            174 => ppc_insn::PPC_INS_BSOL,
            175 => ppc_insn::PPC_INS_BSOLA,
            176 => ppc_insn::PPC_INS_BSOLR,
            177 => ppc_insn::PPC_INS_BSOLRL,
            178 => ppc_insn::PPC_INS_BT,
            179 => ppc_insn::PPC_INS_BTA,
            180 => ppc_insn::PPC_INS_BTCTR,
            181 => ppc_insn::PPC_INS_BTCTRL,
            182 => ppc_insn::PPC_INS_BTL,
            183 => ppc_insn::PPC_INS_BTLA,
            184 => ppc_insn::PPC_INS_BTLR,
            185 => ppc_insn::PPC_INS_BTLRL,
            186 => ppc_insn::PPC_INS_BUN,
            187 => ppc_insn::PPC_INS_BUNA,
            188 => ppc_insn::PPC_INS_BUNCTR,
            189 => ppc_insn::PPC_INS_BUNCTRL,
            190 => ppc_insn::PPC_INS_BUNL,
            191 => ppc_insn::PPC_INS_BUNLA,
            192 => ppc_insn::PPC_INS_BUNLR,
            193 => ppc_insn::PPC_INS_BUNLRL,
            194 => ppc_insn::PPC_INS_CLRBHRB,
            195 => ppc_insn::PPC_INS_CLRLDI,
            196 => ppc_insn::PPC_INS_CLRLSLDI,
            197 => ppc_insn::PPC_INS_CLRLSLWI,
            198 => ppc_insn::PPC_INS_CLRLWI,
            199 => ppc_insn::PPC_INS_CLRRDI,
            200 => ppc_insn::PPC_INS_CLRRWI,
            201 => ppc_insn::PPC_INS_CMP,
            202 => ppc_insn::PPC_INS_CMPB,
            203 => ppc_insn::PPC_INS_CMPD,
            204 => ppc_insn::PPC_INS_CMPDI,
            205 => ppc_insn::PPC_INS_CMPEQB,
            206 => ppc_insn::PPC_INS_CMPI,
            207 => ppc_insn::PPC_INS_CMPL,
            208 => ppc_insn::PPC_INS_CMPLD,
            209 => ppc_insn::PPC_INS_CMPLDI,
            210 => ppc_insn::PPC_INS_CMPLI,
            211 => ppc_insn::PPC_INS_CMPLW,
            212 => ppc_insn::PPC_INS_CMPLWI,
            213 => ppc_insn::PPC_INS_CMPRB,
            214 => ppc_insn::PPC_INS_CMPW,
            215 => ppc_insn::PPC_INS_CMPWI,
            216 => ppc_insn::PPC_INS_CNTLZD,
            217 => ppc_insn::PPC_INS_CNTLZW,
            218 => ppc_insn::PPC_INS_CNTTZD,
            219 => ppc_insn::PPC_INS_CNTTZW,
            220 => ppc_insn::PPC_INS_COPY,
            221 => ppc_insn::PPC_INS_COPY_FIRST,
            222 => ppc_insn::PPC_INS_CP_ABORT,
            223 => ppc_insn::PPC_INS_CRAND,
            224 => ppc_insn::PPC_INS_CRANDC,
            225 => ppc_insn::PPC_INS_CRCLR,
            226 => ppc_insn::PPC_INS_CREQV,
            227 => ppc_insn::PPC_INS_CRMOVE,
            228 => ppc_insn::PPC_INS_CRNAND,
            229 => ppc_insn::PPC_INS_CRNOR,
            230 => ppc_insn::PPC_INS_CRNOT,
            231 => ppc_insn::PPC_INS_CROR,
            232 => ppc_insn::PPC_INS_CRORC,
            233 => ppc_insn::PPC_INS_CRSET,
            234 => ppc_insn::PPC_INS_CRXOR,
            235 => ppc_insn::PPC_INS_DARN,
            236 => ppc_insn::PPC_INS_DCBA,
            237 => ppc_insn::PPC_INS_DCBF,
            238 => ppc_insn::PPC_INS_DCBFEP,
            239 => ppc_insn::PPC_INS_DCBFL,
            240 => ppc_insn::PPC_INS_DCBFLP,
            241 => ppc_insn::PPC_INS_DCBI,
            242 => ppc_insn::PPC_INS_DCBST,
            243 => ppc_insn::PPC_INS_DCBSTEP,
            244 => ppc_insn::PPC_INS_DCBT,
            245 => ppc_insn::PPC_INS_DCBTCT,
            246 => ppc_insn::PPC_INS_DCBTDS,
            247 => ppc_insn::PPC_INS_DCBTEP,
            248 => ppc_insn::PPC_INS_DCBTST,
            249 => ppc_insn::PPC_INS_DCBTSTCT,
            250 => ppc_insn::PPC_INS_DCBTSTDS,
            251 => ppc_insn::PPC_INS_DCBTSTEP,
            252 => ppc_insn::PPC_INS_DCBTSTT,
            253 => ppc_insn::PPC_INS_DCBTT,
            254 => ppc_insn::PPC_INS_DCBZ,
            255 => ppc_insn::PPC_INS_DCBZEP,
            256 => ppc_insn::PPC_INS_DCBZL,
            257 => ppc_insn::PPC_INS_DCBZLEP,
            258 => ppc_insn::PPC_INS_DCCCI,
            259 => ppc_insn::PPC_INS_DCI,
            260 => ppc_insn::PPC_INS_DIVD,
            261 => ppc_insn::PPC_INS_DIVDE,
            262 => ppc_insn::PPC_INS_DIVDEU,
            263 => ppc_insn::PPC_INS_DIVDU,
            264 => ppc_insn::PPC_INS_DIVW,
            265 => ppc_insn::PPC_INS_DIVWE,
            266 => ppc_insn::PPC_INS_DIVWEU,
            267 => ppc_insn::PPC_INS_DIVWU,
            268 => ppc_insn::PPC_INS_DSS,
            269 => ppc_insn::PPC_INS_DSSALL,
            270 => ppc_insn::PPC_INS_DST,
            271 => ppc_insn::PPC_INS_DSTST,
            272 => ppc_insn::PPC_INS_DSTSTT,
            273 => ppc_insn::PPC_INS_DSTT,
            274 => ppc_insn::PPC_INS_EFDABS,
            275 => ppc_insn::PPC_INS_EFDADD,
            276 => ppc_insn::PPC_INS_EFDCFS,
            277 => ppc_insn::PPC_INS_EFDCFSF,
            278 => ppc_insn::PPC_INS_EFDCFSI,
            279 => ppc_insn::PPC_INS_EFDCFSID,
            280 => ppc_insn::PPC_INS_EFDCFUF,
            281 => ppc_insn::PPC_INS_EFDCFUI,
            282 => ppc_insn::PPC_INS_EFDCFUID,
            283 => ppc_insn::PPC_INS_EFDCMPEQ,
            284 => ppc_insn::PPC_INS_EFDCMPGT,
            285 => ppc_insn::PPC_INS_EFDCMPLT,
            286 => ppc_insn::PPC_INS_EFDCTSF,
            287 => ppc_insn::PPC_INS_EFDCTSI,
            288 => ppc_insn::PPC_INS_EFDCTSIDZ,
            289 => ppc_insn::PPC_INS_EFDCTSIZ,
            290 => ppc_insn::PPC_INS_EFDCTUF,
            291 => ppc_insn::PPC_INS_EFDCTUI,
            292 => ppc_insn::PPC_INS_EFDCTUIDZ,
            293 => ppc_insn::PPC_INS_EFDCTUIZ,
            294 => ppc_insn::PPC_INS_EFDDIV,
            295 => ppc_insn::PPC_INS_EFDMUL,
            296 => ppc_insn::PPC_INS_EFDNABS,
            297 => ppc_insn::PPC_INS_EFDNEG,
            298 => ppc_insn::PPC_INS_EFDSUB,
            299 => ppc_insn::PPC_INS_EFDTSTEQ,
            300 => ppc_insn::PPC_INS_EFDTSTGT,
            301 => ppc_insn::PPC_INS_EFDTSTLT,
            302 => ppc_insn::PPC_INS_EFSABS,
            303 => ppc_insn::PPC_INS_EFSADD,
            304 => ppc_insn::PPC_INS_EFSCFD,
            305 => ppc_insn::PPC_INS_EFSCFSF,
            306 => ppc_insn::PPC_INS_EFSCFSI,
            307 => ppc_insn::PPC_INS_EFSCFUF,
            308 => ppc_insn::PPC_INS_EFSCFUI,
            309 => ppc_insn::PPC_INS_EFSCMPEQ,
            310 => ppc_insn::PPC_INS_EFSCMPGT,
            311 => ppc_insn::PPC_INS_EFSCMPLT,
            312 => ppc_insn::PPC_INS_EFSCTSF,
            313 => ppc_insn::PPC_INS_EFSCTSI,
            314 => ppc_insn::PPC_INS_EFSCTSIZ,
            315 => ppc_insn::PPC_INS_EFSCTUF,
            316 => ppc_insn::PPC_INS_EFSCTUI,
            317 => ppc_insn::PPC_INS_EFSCTUIZ,
            318 => ppc_insn::PPC_INS_EFSDIV,
            319 => ppc_insn::PPC_INS_EFSMUL,
            320 => ppc_insn::PPC_INS_EFSNABS,
            321 => ppc_insn::PPC_INS_EFSNEG,
            322 => ppc_insn::PPC_INS_EFSSUB,
            323 => ppc_insn::PPC_INS_EFSTSTEQ,
            324 => ppc_insn::PPC_INS_EFSTSTGT,
            325 => ppc_insn::PPC_INS_EFSTSTLT,
            326 => ppc_insn::PPC_INS_EIEIO,
            327 => ppc_insn::PPC_INS_EQV,
            328 => ppc_insn::PPC_INS_EVABS,
            329 => ppc_insn::PPC_INS_EVADDIW,
            330 => ppc_insn::PPC_INS_EVADDSMIAAW,
            331 => ppc_insn::PPC_INS_EVADDSSIAAW,
            332 => ppc_insn::PPC_INS_EVADDUMIAAW,
            333 => ppc_insn::PPC_INS_EVADDUSIAAW,
            334 => ppc_insn::PPC_INS_EVADDW,
            335 => ppc_insn::PPC_INS_EVAND,
            336 => ppc_insn::PPC_INS_EVANDC,
            337 => ppc_insn::PPC_INS_EVCMPEQ,
            338 => ppc_insn::PPC_INS_EVCMPGTS,
            339 => ppc_insn::PPC_INS_EVCMPGTU,
            340 => ppc_insn::PPC_INS_EVCMPLTS,
            341 => ppc_insn::PPC_INS_EVCMPLTU,
            342 => ppc_insn::PPC_INS_EVCNTLSW,
            343 => ppc_insn::PPC_INS_EVCNTLZW,
            344 => ppc_insn::PPC_INS_EVDIVWS,
            345 => ppc_insn::PPC_INS_EVDIVWU,
            346 => ppc_insn::PPC_INS_EVEQV,
            347 => ppc_insn::PPC_INS_EVEXTSB,
            348 => ppc_insn::PPC_INS_EVEXTSH,
            349 => ppc_insn::PPC_INS_EVFSABS,
            350 => ppc_insn::PPC_INS_EVFSADD,
            351 => ppc_insn::PPC_INS_EVFSCFSF,
            352 => ppc_insn::PPC_INS_EVFSCFSI,
            353 => ppc_insn::PPC_INS_EVFSCFUF,
            354 => ppc_insn::PPC_INS_EVFSCFUI,
            355 => ppc_insn::PPC_INS_EVFSCMPEQ,
            356 => ppc_insn::PPC_INS_EVFSCMPGT,
            357 => ppc_insn::PPC_INS_EVFSCMPLT,
            358 => ppc_insn::PPC_INS_EVFSCTSF,
            359 => ppc_insn::PPC_INS_EVFSCTSI,
            360 => ppc_insn::PPC_INS_EVFSCTSIZ,
            361 => ppc_insn::PPC_INS_EVFSCTUI,
            362 => ppc_insn::PPC_INS_EVFSDIV,
            363 => ppc_insn::PPC_INS_EVFSMUL,
            364 => ppc_insn::PPC_INS_EVFSNABS,
            365 => ppc_insn::PPC_INS_EVFSNEG,
            366 => ppc_insn::PPC_INS_EVFSSUB,
            367 => ppc_insn::PPC_INS_EVFSTSTEQ,
            368 => ppc_insn::PPC_INS_EVFSTSTGT,
            369 => ppc_insn::PPC_INS_EVFSTSTLT,
            370 => ppc_insn::PPC_INS_EVLDD,
            371 => ppc_insn::PPC_INS_EVLDDX,
            372 => ppc_insn::PPC_INS_EVLDH,
            373 => ppc_insn::PPC_INS_EVLDHX,
            374 => ppc_insn::PPC_INS_EVLDW,
            375 => ppc_insn::PPC_INS_EVLDWX,
            376 => ppc_insn::PPC_INS_EVLHHESPLAT,
            377 => ppc_insn::PPC_INS_EVLHHESPLATX,
            378 => ppc_insn::PPC_INS_EVLHHOSSPLAT,
            379 => ppc_insn::PPC_INS_EVLHHOSSPLATX,
            380 => ppc_insn::PPC_INS_EVLHHOUSPLAT,
            381 => ppc_insn::PPC_INS_EVLHHOUSPLATX,
            382 => ppc_insn::PPC_INS_EVLWHE,
            383 => ppc_insn::PPC_INS_EVLWHEX,
            384 => ppc_insn::PPC_INS_EVLWHOS,
            385 => ppc_insn::PPC_INS_EVLWHOSX,
            386 => ppc_insn::PPC_INS_EVLWHOU,
            387 => ppc_insn::PPC_INS_EVLWHOUX,
            388 => ppc_insn::PPC_INS_EVLWHSPLAT,
            389 => ppc_insn::PPC_INS_EVLWHSPLATX,
            390 => ppc_insn::PPC_INS_EVLWWSPLAT,
            391 => ppc_insn::PPC_INS_EVLWWSPLATX,
            392 => ppc_insn::PPC_INS_EVMERGEHI,
            393 => ppc_insn::PPC_INS_EVMERGEHILO,
            394 => ppc_insn::PPC_INS_EVMERGELO,
            395 => ppc_insn::PPC_INS_EVMERGELOHI,
            396 => ppc_insn::PPC_INS_EVMHEGSMFAA,
            397 => ppc_insn::PPC_INS_EVMHEGSMFAN,
            398 => ppc_insn::PPC_INS_EVMHEGSMIAA,
            399 => ppc_insn::PPC_INS_EVMHEGSMIAN,
            400 => ppc_insn::PPC_INS_EVMHEGUMIAA,
            401 => ppc_insn::PPC_INS_EVMHEGUMIAN,
            402 => ppc_insn::PPC_INS_EVMHESMF,
            403 => ppc_insn::PPC_INS_EVMHESMFA,
            404 => ppc_insn::PPC_INS_EVMHESMFAAW,
            405 => ppc_insn::PPC_INS_EVMHESMFANW,
            406 => ppc_insn::PPC_INS_EVMHESMI,
            407 => ppc_insn::PPC_INS_EVMHESMIA,
            408 => ppc_insn::PPC_INS_EVMHESMIAAW,
            409 => ppc_insn::PPC_INS_EVMHESMIANW,
            410 => ppc_insn::PPC_INS_EVMHESSF,
            411 => ppc_insn::PPC_INS_EVMHESSFA,
            412 => ppc_insn::PPC_INS_EVMHESSFAAW,
            413 => ppc_insn::PPC_INS_EVMHESSFANW,
            414 => ppc_insn::PPC_INS_EVMHESSIAAW,
            415 => ppc_insn::PPC_INS_EVMHESSIANW,
            416 => ppc_insn::PPC_INS_EVMHEUMI,
            417 => ppc_insn::PPC_INS_EVMHEUMIA,
            418 => ppc_insn::PPC_INS_EVMHEUMIAAW,
            419 => ppc_insn::PPC_INS_EVMHEUMIANW,
            420 => ppc_insn::PPC_INS_EVMHEUSIAAW,
            421 => ppc_insn::PPC_INS_EVMHEUSIANW,
            422 => ppc_insn::PPC_INS_EVMHOGSMFAA,
            423 => ppc_insn::PPC_INS_EVMHOGSMFAN,
            424 => ppc_insn::PPC_INS_EVMHOGSMIAA,
            425 => ppc_insn::PPC_INS_EVMHOGSMIAN,
            426 => ppc_insn::PPC_INS_EVMHOGUMIAA,
            427 => ppc_insn::PPC_INS_EVMHOGUMIAN,
            428 => ppc_insn::PPC_INS_EVMHOSMF,
            429 => ppc_insn::PPC_INS_EVMHOSMFA,
            430 => ppc_insn::PPC_INS_EVMHOSMFAAW,
            431 => ppc_insn::PPC_INS_EVMHOSMFANW,
            432 => ppc_insn::PPC_INS_EVMHOSMI,
            433 => ppc_insn::PPC_INS_EVMHOSMIA,
            434 => ppc_insn::PPC_INS_EVMHOSMIAAW,
            435 => ppc_insn::PPC_INS_EVMHOSMIANW,
            436 => ppc_insn::PPC_INS_EVMHOSSF,
            437 => ppc_insn::PPC_INS_EVMHOSSFA,
            438 => ppc_insn::PPC_INS_EVMHOSSFAAW,
            439 => ppc_insn::PPC_INS_EVMHOSSFANW,
            440 => ppc_insn::PPC_INS_EVMHOSSIAAW,
            441 => ppc_insn::PPC_INS_EVMHOSSIANW,
            442 => ppc_insn::PPC_INS_EVMHOUMI,
            443 => ppc_insn::PPC_INS_EVMHOUMIA,
            444 => ppc_insn::PPC_INS_EVMHOUMIAAW,
            445 => ppc_insn::PPC_INS_EVMHOUMIANW,
            446 => ppc_insn::PPC_INS_EVMHOUSIAAW,
            447 => ppc_insn::PPC_INS_EVMHOUSIANW,
            448 => ppc_insn::PPC_INS_EVMRA,
            449 => ppc_insn::PPC_INS_EVMWHSMF,
            450 => ppc_insn::PPC_INS_EVMWHSMFA,
            451 => ppc_insn::PPC_INS_EVMWHSMI,
            452 => ppc_insn::PPC_INS_EVMWHSMIA,
            453 => ppc_insn::PPC_INS_EVMWHSSF,
            454 => ppc_insn::PPC_INS_EVMWHSSFA,
            455 => ppc_insn::PPC_INS_EVMWHUMI,
            456 => ppc_insn::PPC_INS_EVMWHUMIA,
            457 => ppc_insn::PPC_INS_EVMWLSMIAAW,
            458 => ppc_insn::PPC_INS_EVMWLSMIANW,
            459 => ppc_insn::PPC_INS_EVMWLSSIAAW,
            460 => ppc_insn::PPC_INS_EVMWLSSIANW,
            461 => ppc_insn::PPC_INS_EVMWLUMI,
            462 => ppc_insn::PPC_INS_EVMWLUMIA,
            463 => ppc_insn::PPC_INS_EVMWLUMIAAW,
            464 => ppc_insn::PPC_INS_EVMWLUMIANW,
            465 => ppc_insn::PPC_INS_EVMWLUSIAAW,
            466 => ppc_insn::PPC_INS_EVMWLUSIANW,
            467 => ppc_insn::PPC_INS_EVMWSMF,
            468 => ppc_insn::PPC_INS_EVMWSMFA,
            469 => ppc_insn::PPC_INS_EVMWSMFAA,
            470 => ppc_insn::PPC_INS_EVMWSMFAN,
            471 => ppc_insn::PPC_INS_EVMWSMI,
            472 => ppc_insn::PPC_INS_EVMWSMIA,
            473 => ppc_insn::PPC_INS_EVMWSMIAA,
            474 => ppc_insn::PPC_INS_EVMWSMIAN,
            475 => ppc_insn::PPC_INS_EVMWSSF,
            476 => ppc_insn::PPC_INS_EVMWSSFA,
            477 => ppc_insn::PPC_INS_EVMWSSFAA,
            478 => ppc_insn::PPC_INS_EVMWSSFAN,
            479 => ppc_insn::PPC_INS_EVMWUMI,
            480 => ppc_insn::PPC_INS_EVMWUMIA,
            481 => ppc_insn::PPC_INS_EVMWUMIAA,
            482 => ppc_insn::PPC_INS_EVMWUMIAN,
            483 => ppc_insn::PPC_INS_EVNAND,
            484 => ppc_insn::PPC_INS_EVNEG,
            485 => ppc_insn::PPC_INS_EVNOR,
            486 => ppc_insn::PPC_INS_EVOR,
            487 => ppc_insn::PPC_INS_EVORC,
            488 => ppc_insn::PPC_INS_EVRLW,
            489 => ppc_insn::PPC_INS_EVRLWI,
            490 => ppc_insn::PPC_INS_EVRNDW,
            491 => ppc_insn::PPC_INS_EVSEL,
            492 => ppc_insn::PPC_INS_EVSLW,
            493 => ppc_insn::PPC_INS_EVSLWI,
            494 => ppc_insn::PPC_INS_EVSPLATFI,
            495 => ppc_insn::PPC_INS_EVSPLATI,
            496 => ppc_insn::PPC_INS_EVSRWIS,
            497 => ppc_insn::PPC_INS_EVSRWIU,
            498 => ppc_insn::PPC_INS_EVSRWS,
            499 => ppc_insn::PPC_INS_EVSRWU,
            500 => ppc_insn::PPC_INS_EVSTDD,
            501 => ppc_insn::PPC_INS_EVSTDDX,
            502 => ppc_insn::PPC_INS_EVSTDH,
            503 => ppc_insn::PPC_INS_EVSTDHX,
            504 => ppc_insn::PPC_INS_EVSTDW,
            505 => ppc_insn::PPC_INS_EVSTDWX,
            506 => ppc_insn::PPC_INS_EVSTWHE,
            507 => ppc_insn::PPC_INS_EVSTWHEX,
            508 => ppc_insn::PPC_INS_EVSTWHO,
            509 => ppc_insn::PPC_INS_EVSTWHOX,
            510 => ppc_insn::PPC_INS_EVSTWWE,
            511 => ppc_insn::PPC_INS_EVSTWWEX,
            512 => ppc_insn::PPC_INS_EVSTWWO,
            513 => ppc_insn::PPC_INS_EVSTWWOX,
            514 => ppc_insn::PPC_INS_EVSUBFSMIAAW,
            515 => ppc_insn::PPC_INS_EVSUBFSSIAAW,
            516 => ppc_insn::PPC_INS_EVSUBFUMIAAW,
            517 => ppc_insn::PPC_INS_EVSUBFUSIAAW,
            518 => ppc_insn::PPC_INS_EVSUBFW,
            519 => ppc_insn::PPC_INS_EVSUBIFW,
            520 => ppc_insn::PPC_INS_EVXOR,
            521 => ppc_insn::PPC_INS_EXTLDI,
            522 => ppc_insn::PPC_INS_EXTLWI,
            523 => ppc_insn::PPC_INS_EXTRDI,
            524 => ppc_insn::PPC_INS_EXTRWI,
            525 => ppc_insn::PPC_INS_EXTSB,
            526 => ppc_insn::PPC_INS_EXTSH,
            527 => ppc_insn::PPC_INS_EXTSW,
            528 => ppc_insn::PPC_INS_EXTSWSLI,
            529 => ppc_insn::PPC_INS_FABS,
            530 => ppc_insn::PPC_INS_FADD,
            531 => ppc_insn::PPC_INS_FADDS,
            532 => ppc_insn::PPC_INS_FCFID,
            533 => ppc_insn::PPC_INS_FCFIDS,
            534 => ppc_insn::PPC_INS_FCFIDU,
            535 => ppc_insn::PPC_INS_FCFIDUS,
            536 => ppc_insn::PPC_INS_FCMPU,
            537 => ppc_insn::PPC_INS_FCPSGN,
            538 => ppc_insn::PPC_INS_FCTID,
            539 => ppc_insn::PPC_INS_FCTIDU,
            540 => ppc_insn::PPC_INS_FCTIDUZ,
            541 => ppc_insn::PPC_INS_FCTIDZ,
            542 => ppc_insn::PPC_INS_FCTIW,
            543 => ppc_insn::PPC_INS_FCTIWU,
            544 => ppc_insn::PPC_INS_FCTIWUZ,
            545 => ppc_insn::PPC_INS_FCTIWZ,
            546 => ppc_insn::PPC_INS_FDIV,
            547 => ppc_insn::PPC_INS_FDIVS,
            548 => ppc_insn::PPC_INS_FMADD,
            549 => ppc_insn::PPC_INS_FMADDS,
            550 => ppc_insn::PPC_INS_FMR,
            551 => ppc_insn::PPC_INS_FMSUB,
            552 => ppc_insn::PPC_INS_FMSUBS,
            553 => ppc_insn::PPC_INS_FMUL,
            554 => ppc_insn::PPC_INS_FMULS,
            555 => ppc_insn::PPC_INS_FNABS,
            556 => ppc_insn::PPC_INS_FNEG,
            557 => ppc_insn::PPC_INS_FNMADD,
            558 => ppc_insn::PPC_INS_FNMADDS,
            559 => ppc_insn::PPC_INS_FNMSUB,
            560 => ppc_insn::PPC_INS_FNMSUBS,
            561 => ppc_insn::PPC_INS_FRE,
            562 => ppc_insn::PPC_INS_FRES,
            563 => ppc_insn::PPC_INS_FRIM,
            564 => ppc_insn::PPC_INS_FRIN,
            565 => ppc_insn::PPC_INS_FRIP,
            566 => ppc_insn::PPC_INS_FRIZ,
            567 => ppc_insn::PPC_INS_FRSP,
            568 => ppc_insn::PPC_INS_FRSQRTE,
            569 => ppc_insn::PPC_INS_FRSQRTES,
            570 => ppc_insn::PPC_INS_FSEL,
            571 => ppc_insn::PPC_INS_FSQRT,
            572 => ppc_insn::PPC_INS_FSQRTS,
            573 => ppc_insn::PPC_INS_FSUB,
            574 => ppc_insn::PPC_INS_FSUBS,
            575 => ppc_insn::PPC_INS_FTDIV,
            576 => ppc_insn::PPC_INS_FTSQRT,
            577 => ppc_insn::PPC_INS_HRFID,
            578 => ppc_insn::PPC_INS_ICBI,
            579 => ppc_insn::PPC_INS_ICBIEP,
            580 => ppc_insn::PPC_INS_ICBLC,
            581 => ppc_insn::PPC_INS_ICBLQ,
            582 => ppc_insn::PPC_INS_ICBT,
            583 => ppc_insn::PPC_INS_ICBTLS,
            584 => ppc_insn::PPC_INS_ICCCI,
            585 => ppc_insn::PPC_INS_ICI,
            586 => ppc_insn::PPC_INS_INSLWI,
            587 => ppc_insn::PPC_INS_INSRDI,
            588 => ppc_insn::PPC_INS_INSRWI,
            589 => ppc_insn::PPC_INS_ISEL,
            590 => ppc_insn::PPC_INS_ISYNC,
            591 => ppc_insn::PPC_INS_LA,
            592 => ppc_insn::PPC_INS_LBARX,
            593 => ppc_insn::PPC_INS_LBEPX,
            594 => ppc_insn::PPC_INS_LBZ,
            595 => ppc_insn::PPC_INS_LBZCIX,
            596 => ppc_insn::PPC_INS_LBZU,
            597 => ppc_insn::PPC_INS_LBZUX,
            598 => ppc_insn::PPC_INS_LBZX,
            599 => ppc_insn::PPC_INS_LD,
            600 => ppc_insn::PPC_INS_LDARX,
            601 => ppc_insn::PPC_INS_LDAT,
            602 => ppc_insn::PPC_INS_LDBRX,
            603 => ppc_insn::PPC_INS_LDCIX,
            604 => ppc_insn::PPC_INS_LDMX,
            605 => ppc_insn::PPC_INS_LDU,
            606 => ppc_insn::PPC_INS_LDUX,
            607 => ppc_insn::PPC_INS_LDX,
            608 => ppc_insn::PPC_INS_LFD,
            609 => ppc_insn::PPC_INS_LFDEPX,
            610 => ppc_insn::PPC_INS_LFDU,
            611 => ppc_insn::PPC_INS_LFDUX,
            612 => ppc_insn::PPC_INS_LFDX,
            613 => ppc_insn::PPC_INS_LFIWAX,
            614 => ppc_insn::PPC_INS_LFIWZX,
            615 => ppc_insn::PPC_INS_LFS,
            616 => ppc_insn::PPC_INS_LFSU,
            617 => ppc_insn::PPC_INS_LFSUX,
            618 => ppc_insn::PPC_INS_LFSX,
            619 => ppc_insn::PPC_INS_LHA,
            620 => ppc_insn::PPC_INS_LHARX,
            621 => ppc_insn::PPC_INS_LHAU,
            622 => ppc_insn::PPC_INS_LHAUX,
            623 => ppc_insn::PPC_INS_LHAX,
            624 => ppc_insn::PPC_INS_LHBRX,
            625 => ppc_insn::PPC_INS_LHEPX,
            626 => ppc_insn::PPC_INS_LHZ,
            627 => ppc_insn::PPC_INS_LHZCIX,
            628 => ppc_insn::PPC_INS_LHZU,
            629 => ppc_insn::PPC_INS_LHZUX,
            630 => ppc_insn::PPC_INS_LHZX,
            631 => ppc_insn::PPC_INS_LI,
            632 => ppc_insn::PPC_INS_LIS,
            633 => ppc_insn::PPC_INS_LMW,
            634 => ppc_insn::PPC_INS_LNIA,
            635 => ppc_insn::PPC_INS_LSWI,
            636 => ppc_insn::PPC_INS_LVEBX,
            637 => ppc_insn::PPC_INS_LVEHX,
            638 => ppc_insn::PPC_INS_LVEWX,
            639 => ppc_insn::PPC_INS_LVSL,
            640 => ppc_insn::PPC_INS_LVSR,
            641 => ppc_insn::PPC_INS_LVX,
            642 => ppc_insn::PPC_INS_LVXL,
            643 => ppc_insn::PPC_INS_LWA,
            644 => ppc_insn::PPC_INS_LWARX,
            645 => ppc_insn::PPC_INS_LWAT,
            646 => ppc_insn::PPC_INS_LWAUX,
            647 => ppc_insn::PPC_INS_LWAX,
            648 => ppc_insn::PPC_INS_LWBRX,
            649 => ppc_insn::PPC_INS_LWEPX,
            650 => ppc_insn::PPC_INS_LWSYNC,
            651 => ppc_insn::PPC_INS_LWZ,
            652 => ppc_insn::PPC_INS_LWZCIX,
            653 => ppc_insn::PPC_INS_LWZU,
            654 => ppc_insn::PPC_INS_LWZUX,
            655 => ppc_insn::PPC_INS_LWZX,
            656 => ppc_insn::PPC_INS_LXSD,
            657 => ppc_insn::PPC_INS_LXSDX,
            658 => ppc_insn::PPC_INS_LXSIBZX,
            659 => ppc_insn::PPC_INS_LXSIHZX,
            660 => ppc_insn::PPC_INS_LXSIWAX,
            661 => ppc_insn::PPC_INS_LXSIWZX,
            662 => ppc_insn::PPC_INS_LXSSP,
            663 => ppc_insn::PPC_INS_LXSSPX,
            664 => ppc_insn::PPC_INS_LXV,
            665 => ppc_insn::PPC_INS_LXVB16X,
            666 => ppc_insn::PPC_INS_LXVD2X,
            667 => ppc_insn::PPC_INS_LXVDSX,
            668 => ppc_insn::PPC_INS_LXVH8X,
            669 => ppc_insn::PPC_INS_LXVL,
            670 => ppc_insn::PPC_INS_LXVLL,
            671 => ppc_insn::PPC_INS_LXVW4X,
            672 => ppc_insn::PPC_INS_LXVWSX,
            673 => ppc_insn::PPC_INS_LXVX,
            674 => ppc_insn::PPC_INS_MADDHD,
            675 => ppc_insn::PPC_INS_MADDHDU,
            676 => ppc_insn::PPC_INS_MADDLD,
            677 => ppc_insn::PPC_INS_MBAR,
            678 => ppc_insn::PPC_INS_MCRF,
            679 => ppc_insn::PPC_INS_MCRFS,
            680 => ppc_insn::PPC_INS_MCRXRX,
            681 => ppc_insn::PPC_INS_MFAMR,
            682 => ppc_insn::PPC_INS_MFASR,
            683 => ppc_insn::PPC_INS_MFBHRBE,
            684 => ppc_insn::PPC_INS_MFBR0,
            685 => ppc_insn::PPC_INS_MFBR1,
            686 => ppc_insn::PPC_INS_MFBR2,
            687 => ppc_insn::PPC_INS_MFBR3,
            688 => ppc_insn::PPC_INS_MFBR4,
            689 => ppc_insn::PPC_INS_MFBR5,
            690 => ppc_insn::PPC_INS_MFBR6,
            691 => ppc_insn::PPC_INS_MFBR7,
            692 => ppc_insn::PPC_INS_MFCFAR,
            693 => ppc_insn::PPC_INS_MFCR,
            694 => ppc_insn::PPC_INS_MFCTR,
            695 => ppc_insn::PPC_INS_MFDAR,
            696 => ppc_insn::PPC_INS_MFDBATL,
            697 => ppc_insn::PPC_INS_MFDBATU,
            698 => ppc_insn::PPC_INS_MFDCCR,
            699 => ppc_insn::PPC_INS_MFDCR,
            700 => ppc_insn::PPC_INS_MFDEAR,
            701 => ppc_insn::PPC_INS_MFDEC,
            702 => ppc_insn::PPC_INS_MFDSCR,
            703 => ppc_insn::PPC_INS_MFDSISR,
            704 => ppc_insn::PPC_INS_MFESR,
            705 => ppc_insn::PPC_INS_MFFPRD,
            706 => ppc_insn::PPC_INS_MFFS,
            707 => ppc_insn::PPC_INS_MFFSCDRN,
            708 => ppc_insn::PPC_INS_MFFSCDRNI,
            709 => ppc_insn::PPC_INS_MFFSCE,
            710 => ppc_insn::PPC_INS_MFFSCRN,
            711 => ppc_insn::PPC_INS_MFFSCRNI,
            712 => ppc_insn::PPC_INS_MFFSL,
            713 => ppc_insn::PPC_INS_MFIBATL,
            714 => ppc_insn::PPC_INS_MFIBATU,
            715 => ppc_insn::PPC_INS_MFICCR,
            716 => ppc_insn::PPC_INS_MFLR,
            717 => ppc_insn::PPC_INS_MFMSR,
            718 => ppc_insn::PPC_INS_MFOCRF,
            719 => ppc_insn::PPC_INS_MFPID,
            720 => ppc_insn::PPC_INS_MFPMR,
            721 => ppc_insn::PPC_INS_MFPVR,
            722 => ppc_insn::PPC_INS_MFRTCL,
            723 => ppc_insn::PPC_INS_MFRTCU,
            724 => ppc_insn::PPC_INS_MFSDR1,
            725 => ppc_insn::PPC_INS_MFSPEFSCR,
            726 => ppc_insn::PPC_INS_MFSPR,
            727 => ppc_insn::PPC_INS_MFSPRG,
            728 => ppc_insn::PPC_INS_MFSPRG0,
            729 => ppc_insn::PPC_INS_MFSPRG1,
            730 => ppc_insn::PPC_INS_MFSPRG2,
            731 => ppc_insn::PPC_INS_MFSPRG3,
            732 => ppc_insn::PPC_INS_MFSPRG4,
            733 => ppc_insn::PPC_INS_MFSPRG5,
            734 => ppc_insn::PPC_INS_MFSPRG6,
            735 => ppc_insn::PPC_INS_MFSPRG7,
            736 => ppc_insn::PPC_INS_MFSR,
            737 => ppc_insn::PPC_INS_MFSRIN,
            738 => ppc_insn::PPC_INS_MFSRR0,
            739 => ppc_insn::PPC_INS_MFSRR1,
            740 => ppc_insn::PPC_INS_MFSRR2,
            741 => ppc_insn::PPC_INS_MFSRR3,
            742 => ppc_insn::PPC_INS_MFTB,
            743 => ppc_insn::PPC_INS_MFTBHI,
            744 => ppc_insn::PPC_INS_MFTBL,
            745 => ppc_insn::PPC_INS_MFTBLO,
            746 => ppc_insn::PPC_INS_MFTBU,
            747 => ppc_insn::PPC_INS_MFTCR,
            748 => ppc_insn::PPC_INS_MFVRD,
            749 => ppc_insn::PPC_INS_MFVRSAVE,
            750 => ppc_insn::PPC_INS_MFVSCR,
            751 => ppc_insn::PPC_INS_MFVSRD,
            752 => ppc_insn::PPC_INS_MFVSRLD,
            753 => ppc_insn::PPC_INS_MFVSRWZ,
            754 => ppc_insn::PPC_INS_MFXER,
            755 => ppc_insn::PPC_INS_MODSD,
            756 => ppc_insn::PPC_INS_MODSW,
            757 => ppc_insn::PPC_INS_MODUD,
            758 => ppc_insn::PPC_INS_MODUW,
            759 => ppc_insn::PPC_INS_MR,
            760 => ppc_insn::PPC_INS_MSGSYNC,
            761 => ppc_insn::PPC_INS_MSYNC,
            762 => ppc_insn::PPC_INS_MTAMR,
            763 => ppc_insn::PPC_INS_MTASR,
            764 => ppc_insn::PPC_INS_MTBR0,
            765 => ppc_insn::PPC_INS_MTBR1,
            766 => ppc_insn::PPC_INS_MTBR2,
            767 => ppc_insn::PPC_INS_MTBR3,
            768 => ppc_insn::PPC_INS_MTBR4,
            769 => ppc_insn::PPC_INS_MTBR5,
            770 => ppc_insn::PPC_INS_MTBR6,
            771 => ppc_insn::PPC_INS_MTBR7,
            772 => ppc_insn::PPC_INS_MTCFAR,
            773 => ppc_insn::PPC_INS_MTCR,
            774 => ppc_insn::PPC_INS_MTCRF,
            775 => ppc_insn::PPC_INS_MTCTR,
            776 => ppc_insn::PPC_INS_MTDAR,
            777 => ppc_insn::PPC_INS_MTDBATL,
            778 => ppc_insn::PPC_INS_MTDBATU,
            779 => ppc_insn::PPC_INS_MTDCCR,
            780 => ppc_insn::PPC_INS_MTDCR,
            781 => ppc_insn::PPC_INS_MTDEAR,
            782 => ppc_insn::PPC_INS_MTDEC,
            783 => ppc_insn::PPC_INS_MTDSCR,
            784 => ppc_insn::PPC_INS_MTDSISR,
            785 => ppc_insn::PPC_INS_MTESR,
            786 => ppc_insn::PPC_INS_MTFSB0,
            787 => ppc_insn::PPC_INS_MTFSB1,
            788 => ppc_insn::PPC_INS_MTFSF,
            789 => ppc_insn::PPC_INS_MTFSFI,
            790 => ppc_insn::PPC_INS_MTIBATL,
            791 => ppc_insn::PPC_INS_MTIBATU,
            792 => ppc_insn::PPC_INS_MTICCR,
            793 => ppc_insn::PPC_INS_MTLR,
            794 => ppc_insn::PPC_INS_MTMSR,
            795 => ppc_insn::PPC_INS_MTMSRD,
            796 => ppc_insn::PPC_INS_MTOCRF,
            797 => ppc_insn::PPC_INS_MTPID,
            798 => ppc_insn::PPC_INS_MTPMR,
            799 => ppc_insn::PPC_INS_MTSDR1,
            800 => ppc_insn::PPC_INS_MTSPEFSCR,
            801 => ppc_insn::PPC_INS_MTSPR,
            802 => ppc_insn::PPC_INS_MTSPRG,
            803 => ppc_insn::PPC_INS_MTSPRG0,
            804 => ppc_insn::PPC_INS_MTSPRG1,
            805 => ppc_insn::PPC_INS_MTSPRG2,
            806 => ppc_insn::PPC_INS_MTSPRG3,
            807 => ppc_insn::PPC_INS_MTSPRG4,
            808 => ppc_insn::PPC_INS_MTSPRG5,
            809 => ppc_insn::PPC_INS_MTSPRG6,
            810 => ppc_insn::PPC_INS_MTSPRG7,
            811 => ppc_insn::PPC_INS_MTSR,
            812 => ppc_insn::PPC_INS_MTSRIN,
            813 => ppc_insn::PPC_INS_MTSRR0,
            814 => ppc_insn::PPC_INS_MTSRR1,
            815 => ppc_insn::PPC_INS_MTSRR2,
            816 => ppc_insn::PPC_INS_MTSRR3,
            817 => ppc_insn::PPC_INS_MTTBHI,
            818 => ppc_insn::PPC_INS_MTTBL,
            819 => ppc_insn::PPC_INS_MTTBLO,
            820 => ppc_insn::PPC_INS_MTTBU,
            821 => ppc_insn::PPC_INS_MTTCR,
            822 => ppc_insn::PPC_INS_MTVRSAVE,
            823 => ppc_insn::PPC_INS_MTVSCR,
            824 => ppc_insn::PPC_INS_MTVSRD,
            825 => ppc_insn::PPC_INS_MTVSRDD,
            826 => ppc_insn::PPC_INS_MTVSRWA,
            827 => ppc_insn::PPC_INS_MTVSRWS,
            828 => ppc_insn::PPC_INS_MTVSRWZ,
            829 => ppc_insn::PPC_INS_MTXER,
            830 => ppc_insn::PPC_INS_MULHD,
            831 => ppc_insn::PPC_INS_MULHDU,
            832 => ppc_insn::PPC_INS_MULHW,
            833 => ppc_insn::PPC_INS_MULHWU,
            834 => ppc_insn::PPC_INS_MULLD,
            835 => ppc_insn::PPC_INS_MULLI,
            836 => ppc_insn::PPC_INS_MULLW,
            837 => ppc_insn::PPC_INS_NAND,
            838 => ppc_insn::PPC_INS_NAP,
            839 => ppc_insn::PPC_INS_NEG,
            840 => ppc_insn::PPC_INS_NOP,
            841 => ppc_insn::PPC_INS_NOR,
            842 => ppc_insn::PPC_INS_NOT,
            843 => ppc_insn::PPC_INS_OR,
            844 => ppc_insn::PPC_INS_ORC,
            845 => ppc_insn::PPC_INS_ORI,
            846 => ppc_insn::PPC_INS_ORIS,
            847 => ppc_insn::PPC_INS_PASTE,
            848 => ppc_insn::PPC_INS_PASTE_LAST,
            849 => ppc_insn::PPC_INS_POPCNTB,
            850 => ppc_insn::PPC_INS_POPCNTD,
            851 => ppc_insn::PPC_INS_POPCNTW,
            852 => ppc_insn::PPC_INS_PTESYNC,
            853 => ppc_insn::PPC_INS_QVALIGNI,
            854 => ppc_insn::PPC_INS_QVESPLATI,
            855 => ppc_insn::PPC_INS_QVFABS,
            856 => ppc_insn::PPC_INS_QVFADD,
            857 => ppc_insn::PPC_INS_QVFADDS,
            858 => ppc_insn::PPC_INS_QVFAND,
            859 => ppc_insn::PPC_INS_QVFANDC,
            860 => ppc_insn::PPC_INS_QVFCFID,
            861 => ppc_insn::PPC_INS_QVFCFIDS,
            862 => ppc_insn::PPC_INS_QVFCFIDU,
            863 => ppc_insn::PPC_INS_QVFCFIDUS,
            864 => ppc_insn::PPC_INS_QVFCLR,
            865 => ppc_insn::PPC_INS_QVFCMPEQ,
            866 => ppc_insn::PPC_INS_QVFCMPGT,
            867 => ppc_insn::PPC_INS_QVFCMPLT,
            868 => ppc_insn::PPC_INS_QVFCPSGN,
            869 => ppc_insn::PPC_INS_QVFCTFB,
            870 => ppc_insn::PPC_INS_QVFCTID,
            871 => ppc_insn::PPC_INS_QVFCTIDU,
            872 => ppc_insn::PPC_INS_QVFCTIDUZ,
            873 => ppc_insn::PPC_INS_QVFCTIDZ,
            874 => ppc_insn::PPC_INS_QVFCTIW,
            875 => ppc_insn::PPC_INS_QVFCTIWU,
            876 => ppc_insn::PPC_INS_QVFCTIWUZ,
            877 => ppc_insn::PPC_INS_QVFCTIWZ,
            878 => ppc_insn::PPC_INS_QVFEQU,
            879 => ppc_insn::PPC_INS_QVFLOGICAL,
            880 => ppc_insn::PPC_INS_QVFMADD,
            881 => ppc_insn::PPC_INS_QVFMADDS,
            882 => ppc_insn::PPC_INS_QVFMR,
            883 => ppc_insn::PPC_INS_QVFMSUB,
            884 => ppc_insn::PPC_INS_QVFMSUBS,
            885 => ppc_insn::PPC_INS_QVFMUL,
            886 => ppc_insn::PPC_INS_QVFMULS,
            887 => ppc_insn::PPC_INS_QVFNABS,
            888 => ppc_insn::PPC_INS_QVFNAND,
            889 => ppc_insn::PPC_INS_QVFNEG,
            890 => ppc_insn::PPC_INS_QVFNMADD,
            891 => ppc_insn::PPC_INS_QVFNMADDS,
            892 => ppc_insn::PPC_INS_QVFNMSUB,
            893 => ppc_insn::PPC_INS_QVFNMSUBS,
            894 => ppc_insn::PPC_INS_QVFNOR,
            895 => ppc_insn::PPC_INS_QVFNOT,
            896 => ppc_insn::PPC_INS_QVFOR,
            897 => ppc_insn::PPC_INS_QVFORC,
            898 => ppc_insn::PPC_INS_QVFPERM,
            899 => ppc_insn::PPC_INS_QVFRE,
            900 => ppc_insn::PPC_INS_QVFRES,
            901 => ppc_insn::PPC_INS_QVFRIM,
            902 => ppc_insn::PPC_INS_QVFRIN,
            903 => ppc_insn::PPC_INS_QVFRIP,
            904 => ppc_insn::PPC_INS_QVFRIZ,
            905 => ppc_insn::PPC_INS_QVFRSP,
            906 => ppc_insn::PPC_INS_QVFRSQRTE,
            907 => ppc_insn::PPC_INS_QVFRSQRTES,
            908 => ppc_insn::PPC_INS_QVFSEL,
            909 => ppc_insn::PPC_INS_QVFSET,
            910 => ppc_insn::PPC_INS_QVFSUB,
            911 => ppc_insn::PPC_INS_QVFSUBS,
            912 => ppc_insn::PPC_INS_QVFTSTNAN,
            913 => ppc_insn::PPC_INS_QVFXMADD,
            914 => ppc_insn::PPC_INS_QVFXMADDS,
            915 => ppc_insn::PPC_INS_QVFXMUL,
            916 => ppc_insn::PPC_INS_QVFXMULS,
            917 => ppc_insn::PPC_INS_QVFXOR,
            918 => ppc_insn::PPC_INS_QVFXXCPNMADD,
            919 => ppc_insn::PPC_INS_QVFXXCPNMADDS,
            920 => ppc_insn::PPC_INS_QVFXXMADD,
            921 => ppc_insn::PPC_INS_QVFXXMADDS,
            922 => ppc_insn::PPC_INS_QVFXXNPMADD,
            923 => ppc_insn::PPC_INS_QVFXXNPMADDS,
            924 => ppc_insn::PPC_INS_QVGPCI,
            925 => ppc_insn::PPC_INS_QVLFCDUX,
            926 => ppc_insn::PPC_INS_QVLFCDUXA,
            927 => ppc_insn::PPC_INS_QVLFCDX,
            928 => ppc_insn::PPC_INS_QVLFCDXA,
            929 => ppc_insn::PPC_INS_QVLFCSUX,
            930 => ppc_insn::PPC_INS_QVLFCSUXA,
            931 => ppc_insn::PPC_INS_QVLFCSX,
            932 => ppc_insn::PPC_INS_QVLFCSXA,
            933 => ppc_insn::PPC_INS_QVLFDUX,
            934 => ppc_insn::PPC_INS_QVLFDUXA,
            935 => ppc_insn::PPC_INS_QVLFDX,
            936 => ppc_insn::PPC_INS_QVLFDXA,
            937 => ppc_insn::PPC_INS_QVLFIWAX,
            938 => ppc_insn::PPC_INS_QVLFIWAXA,
            939 => ppc_insn::PPC_INS_QVLFIWZX,
            940 => ppc_insn::PPC_INS_QVLFIWZXA,
            941 => ppc_insn::PPC_INS_QVLFSUX,
            942 => ppc_insn::PPC_INS_QVLFSUXA,
            943 => ppc_insn::PPC_INS_QVLFSX,
            944 => ppc_insn::PPC_INS_QVLFSXA,
            945 => ppc_insn::PPC_INS_QVLPCLDX,
            946 => ppc_insn::PPC_INS_QVLPCLSX,
            947 => ppc_insn::PPC_INS_QVLPCRDX,
            948 => ppc_insn::PPC_INS_QVLPCRSX,
            949 => ppc_insn::PPC_INS_QVSTFCDUX,
            950 => ppc_insn::PPC_INS_QVSTFCDUXA,
            951 => ppc_insn::PPC_INS_QVSTFCDUXI,
            952 => ppc_insn::PPC_INS_QVSTFCDUXIA,
            953 => ppc_insn::PPC_INS_QVSTFCDX,
            954 => ppc_insn::PPC_INS_QVSTFCDXA,
            955 => ppc_insn::PPC_INS_QVSTFCDXI,
            956 => ppc_insn::PPC_INS_QVSTFCDXIA,
            957 => ppc_insn::PPC_INS_QVSTFCSUX,
            958 => ppc_insn::PPC_INS_QVSTFCSUXA,
            959 => ppc_insn::PPC_INS_QVSTFCSUXI,
            960 => ppc_insn::PPC_INS_QVSTFCSUXIA,
            961 => ppc_insn::PPC_INS_QVSTFCSX,
            962 => ppc_insn::PPC_INS_QVSTFCSXA,
            963 => ppc_insn::PPC_INS_QVSTFCSXI,
            964 => ppc_insn::PPC_INS_QVSTFCSXIA,
            965 => ppc_insn::PPC_INS_QVSTFDUX,
            966 => ppc_insn::PPC_INS_QVSTFDUXA,
            967 => ppc_insn::PPC_INS_QVSTFDUXI,
            968 => ppc_insn::PPC_INS_QVSTFDUXIA,
            969 => ppc_insn::PPC_INS_QVSTFDX,
            970 => ppc_insn::PPC_INS_QVSTFDXA,
            971 => ppc_insn::PPC_INS_QVSTFDXI,
            972 => ppc_insn::PPC_INS_QVSTFDXIA,
            973 => ppc_insn::PPC_INS_QVSTFIWX,
            974 => ppc_insn::PPC_INS_QVSTFIWXA,
            975 => ppc_insn::PPC_INS_QVSTFSUX,
            976 => ppc_insn::PPC_INS_QVSTFSUXA,
            977 => ppc_insn::PPC_INS_QVSTFSUXI,
            978 => ppc_insn::PPC_INS_QVSTFSUXIA,
            979 => ppc_insn::PPC_INS_QVSTFSX,
            980 => ppc_insn::PPC_INS_QVSTFSXA,
            981 => ppc_insn::PPC_INS_QVSTFSXI,
            982 => ppc_insn::PPC_INS_QVSTFSXIA,
            983 => ppc_insn::PPC_INS_RFCI,
            984 => ppc_insn::PPC_INS_RFDI,
            985 => ppc_insn::PPC_INS_RFEBB,
            986 => ppc_insn::PPC_INS_RFI,
            987 => ppc_insn::PPC_INS_RFID,
            988 => ppc_insn::PPC_INS_RFMCI,
            989 => ppc_insn::PPC_INS_RLDCL,
            990 => ppc_insn::PPC_INS_RLDCR,
            991 => ppc_insn::PPC_INS_RLDIC,
            992 => ppc_insn::PPC_INS_RLDICL,
            993 => ppc_insn::PPC_INS_RLDICR,
            994 => ppc_insn::PPC_INS_RLDIMI,
            995 => ppc_insn::PPC_INS_RLWIMI,
            996 => ppc_insn::PPC_INS_RLWINM,
            997 => ppc_insn::PPC_INS_RLWNM,
            998 => ppc_insn::PPC_INS_ROTLD,
            999 => ppc_insn::PPC_INS_ROTLDI,
            1000 => ppc_insn::PPC_INS_ROTLW,
            1001 => ppc_insn::PPC_INS_ROTLWI,
            1002 => ppc_insn::PPC_INS_ROTRDI,
            1003 => ppc_insn::PPC_INS_ROTRWI,
            1004 => ppc_insn::PPC_INS_SC,
            1005 => ppc_insn::PPC_INS_SETB,
            1006 => ppc_insn::PPC_INS_SLBIA,
            1007 => ppc_insn::PPC_INS_SLBIE,
            1008 => ppc_insn::PPC_INS_SLBIEG,
            1009 => ppc_insn::PPC_INS_SLBMFEE,
            1010 => ppc_insn::PPC_INS_SLBMFEV,
            1011 => ppc_insn::PPC_INS_SLBMTE,
            1012 => ppc_insn::PPC_INS_SLBSYNC,
            1013 => ppc_insn::PPC_INS_SLD,
            1014 => ppc_insn::PPC_INS_SLDI,
            1015 => ppc_insn::PPC_INS_SLW,
            1016 => ppc_insn::PPC_INS_SLWI,
            1017 => ppc_insn::PPC_INS_SRAD,
            1018 => ppc_insn::PPC_INS_SRADI,
            1019 => ppc_insn::PPC_INS_SRAW,
            1020 => ppc_insn::PPC_INS_SRAWI,
            1021 => ppc_insn::PPC_INS_SRD,
            1022 => ppc_insn::PPC_INS_SRDI,
            1023 => ppc_insn::PPC_INS_SRW,
            1024 => ppc_insn::PPC_INS_SRWI,
            1025 => ppc_insn::PPC_INS_STB,
            1026 => ppc_insn::PPC_INS_STBCIX,
            1027 => ppc_insn::PPC_INS_STBCX,
            1028 => ppc_insn::PPC_INS_STBEPX,
            1029 => ppc_insn::PPC_INS_STBU,
            1030 => ppc_insn::PPC_INS_STBUX,
            1031 => ppc_insn::PPC_INS_STBX,
            1032 => ppc_insn::PPC_INS_STD,
            1033 => ppc_insn::PPC_INS_STDAT,
            1034 => ppc_insn::PPC_INS_STDBRX,
            1035 => ppc_insn::PPC_INS_STDCIX,
            1036 => ppc_insn::PPC_INS_STDCX,
            1037 => ppc_insn::PPC_INS_STDU,
            1038 => ppc_insn::PPC_INS_STDUX,
            1039 => ppc_insn::PPC_INS_STDX,
            1040 => ppc_insn::PPC_INS_STFD,
            1041 => ppc_insn::PPC_INS_STFDEPX,
            1042 => ppc_insn::PPC_INS_STFDU,
            1043 => ppc_insn::PPC_INS_STFDUX,
            1044 => ppc_insn::PPC_INS_STFDX,
            1045 => ppc_insn::PPC_INS_STFIWX,
            1046 => ppc_insn::PPC_INS_STFS,
            1047 => ppc_insn::PPC_INS_STFSU,
            1048 => ppc_insn::PPC_INS_STFSUX,
            1049 => ppc_insn::PPC_INS_STFSX,
            1050 => ppc_insn::PPC_INS_STH,
            1051 => ppc_insn::PPC_INS_STHBRX,
            1052 => ppc_insn::PPC_INS_STHCIX,
            1053 => ppc_insn::PPC_INS_STHCX,
            1054 => ppc_insn::PPC_INS_STHEPX,
            1055 => ppc_insn::PPC_INS_STHU,
            1056 => ppc_insn::PPC_INS_STHUX,
            1057 => ppc_insn::PPC_INS_STHX,
            1058 => ppc_insn::PPC_INS_STMW,
            1059 => ppc_insn::PPC_INS_STOP,
            1060 => ppc_insn::PPC_INS_STSWI,
            1061 => ppc_insn::PPC_INS_STVEBX,
            1062 => ppc_insn::PPC_INS_STVEHX,
            1063 => ppc_insn::PPC_INS_STVEWX,
            1064 => ppc_insn::PPC_INS_STVX,
            1065 => ppc_insn::PPC_INS_STVXL,
            1066 => ppc_insn::PPC_INS_STW,
            1067 => ppc_insn::PPC_INS_STWAT,
            1068 => ppc_insn::PPC_INS_STWBRX,
            1069 => ppc_insn::PPC_INS_STWCIX,
            1070 => ppc_insn::PPC_INS_STWCX,
            1071 => ppc_insn::PPC_INS_STWEPX,
            1072 => ppc_insn::PPC_INS_STWU,
            1073 => ppc_insn::PPC_INS_STWUX,
            1074 => ppc_insn::PPC_INS_STWX,
            1075 => ppc_insn::PPC_INS_STXSD,
            1076 => ppc_insn::PPC_INS_STXSDX,
            1077 => ppc_insn::PPC_INS_STXSIBX,
            1078 => ppc_insn::PPC_INS_STXSIHX,
            1079 => ppc_insn::PPC_INS_STXSIWX,
            1080 => ppc_insn::PPC_INS_STXSSP,
            1081 => ppc_insn::PPC_INS_STXSSPX,
            1082 => ppc_insn::PPC_INS_STXV,
            1083 => ppc_insn::PPC_INS_STXVB16X,
            1084 => ppc_insn::PPC_INS_STXVD2X,
            1085 => ppc_insn::PPC_INS_STXVH8X,
            1086 => ppc_insn::PPC_INS_STXVL,
            1087 => ppc_insn::PPC_INS_STXVLL,
            1088 => ppc_insn::PPC_INS_STXVW4X,
            1089 => ppc_insn::PPC_INS_STXVX,
            1090 => ppc_insn::PPC_INS_SUB,
            1091 => ppc_insn::PPC_INS_SUBC,
            1092 => ppc_insn::PPC_INS_SUBF,
            1093 => ppc_insn::PPC_INS_SUBFC,
            1094 => ppc_insn::PPC_INS_SUBFE,
            1095 => ppc_insn::PPC_INS_SUBFIC,
            1096 => ppc_insn::PPC_INS_SUBFME,
            1097 => ppc_insn::PPC_INS_SUBFZE,
            1098 => ppc_insn::PPC_INS_SUBI,
            1099 => ppc_insn::PPC_INS_SUBIC,
            1100 => ppc_insn::PPC_INS_SUBIS,
            1101 => ppc_insn::PPC_INS_SUBPCIS,
            1102 => ppc_insn::PPC_INS_SYNC,
            1103 => ppc_insn::PPC_INS_TABORT,
            1104 => ppc_insn::PPC_INS_TABORTDC,
            1105 => ppc_insn::PPC_INS_TABORTDCI,
            1106 => ppc_insn::PPC_INS_TABORTWC,
            1107 => ppc_insn::PPC_INS_TABORTWCI,
            1108 => ppc_insn::PPC_INS_TBEGIN,
            1109 => ppc_insn::PPC_INS_TCHECK,
            1110 => ppc_insn::PPC_INS_TD,
            1111 => ppc_insn::PPC_INS_TDEQ,
            1112 => ppc_insn::PPC_INS_TDEQI,
            1113 => ppc_insn::PPC_INS_TDGE,
            1114 => ppc_insn::PPC_INS_TDGEI,
            1115 => ppc_insn::PPC_INS_TDGT,
            1116 => ppc_insn::PPC_INS_TDGTI,
            1117 => ppc_insn::PPC_INS_TDI,
            1118 => ppc_insn::PPC_INS_TDLE,
            1119 => ppc_insn::PPC_INS_TDLEI,
            1120 => ppc_insn::PPC_INS_TDLGE,
            1121 => ppc_insn::PPC_INS_TDLGEI,
            1122 => ppc_insn::PPC_INS_TDLGT,
            1123 => ppc_insn::PPC_INS_TDLGTI,
            1124 => ppc_insn::PPC_INS_TDLLE,
            1125 => ppc_insn::PPC_INS_TDLLEI,
            1126 => ppc_insn::PPC_INS_TDLLT,
            1127 => ppc_insn::PPC_INS_TDLLTI,
            1128 => ppc_insn::PPC_INS_TDLNG,
            1129 => ppc_insn::PPC_INS_TDLNGI,
            1130 => ppc_insn::PPC_INS_TDLNL,
            1131 => ppc_insn::PPC_INS_TDLNLI,
            1132 => ppc_insn::PPC_INS_TDLT,
            1133 => ppc_insn::PPC_INS_TDLTI,
            1134 => ppc_insn::PPC_INS_TDNE,
            1135 => ppc_insn::PPC_INS_TDNEI,
            1136 => ppc_insn::PPC_INS_TDNG,
            1137 => ppc_insn::PPC_INS_TDNGI,
            1138 => ppc_insn::PPC_INS_TDNL,
            1139 => ppc_insn::PPC_INS_TDNLI,
            1140 => ppc_insn::PPC_INS_TDU,
            1141 => ppc_insn::PPC_INS_TDUI,
            1142 => ppc_insn::PPC_INS_TEND,
            1143 => ppc_insn::PPC_INS_TLBIA,
            1144 => ppc_insn::PPC_INS_TLBIE,
            1145 => ppc_insn::PPC_INS_TLBIEL,
            1146 => ppc_insn::PPC_INS_TLBIVAX,
            1147 => ppc_insn::PPC_INS_TLBLD,
            1148 => ppc_insn::PPC_INS_TLBLI,
            1149 => ppc_insn::PPC_INS_TLBRE,
            1150 => ppc_insn::PPC_INS_TLBREHI,
            1151 => ppc_insn::PPC_INS_TLBRELO,
            1152 => ppc_insn::PPC_INS_TLBSX,
            1153 => ppc_insn::PPC_INS_TLBSYNC,
            1154 => ppc_insn::PPC_INS_TLBWE,
            1155 => ppc_insn::PPC_INS_TLBWEHI,
            1156 => ppc_insn::PPC_INS_TLBWELO,
            1157 => ppc_insn::PPC_INS_TRAP,
            1158 => ppc_insn::PPC_INS_TRECHKPT,
            1159 => ppc_insn::PPC_INS_TRECLAIM,
            1160 => ppc_insn::PPC_INS_TSR,
            1161 => ppc_insn::PPC_INS_TW,
            1162 => ppc_insn::PPC_INS_TWEQ,
            1163 => ppc_insn::PPC_INS_TWEQI,
            1164 => ppc_insn::PPC_INS_TWGE,
            1165 => ppc_insn::PPC_INS_TWGEI,
            1166 => ppc_insn::PPC_INS_TWGT,
            1167 => ppc_insn::PPC_INS_TWGTI,
            1168 => ppc_insn::PPC_INS_TWI,
            1169 => ppc_insn::PPC_INS_TWLE,
            1170 => ppc_insn::PPC_INS_TWLEI,
            1171 => ppc_insn::PPC_INS_TWLGE,
            1172 => ppc_insn::PPC_INS_TWLGEI,
            1173 => ppc_insn::PPC_INS_TWLGT,
            1174 => ppc_insn::PPC_INS_TWLGTI,
            1175 => ppc_insn::PPC_INS_TWLLE,
            1176 => ppc_insn::PPC_INS_TWLLEI,
            1177 => ppc_insn::PPC_INS_TWLLT,
            1178 => ppc_insn::PPC_INS_TWLLTI,
            1179 => ppc_insn::PPC_INS_TWLNG,
            1180 => ppc_insn::PPC_INS_TWLNGI,
            1181 => ppc_insn::PPC_INS_TWLNL,
            1182 => ppc_insn::PPC_INS_TWLNLI,
            1183 => ppc_insn::PPC_INS_TWLT,
            1184 => ppc_insn::PPC_INS_TWLTI,
            1185 => ppc_insn::PPC_INS_TWNE,
            1186 => ppc_insn::PPC_INS_TWNEI,
            1187 => ppc_insn::PPC_INS_TWNG,
            1188 => ppc_insn::PPC_INS_TWNGI,
            1189 => ppc_insn::PPC_INS_TWNL,
            1190 => ppc_insn::PPC_INS_TWNLI,
            1191 => ppc_insn::PPC_INS_TWU,
            1192 => ppc_insn::PPC_INS_TWUI,
            1193 => ppc_insn::PPC_INS_VABSDUB,
            1194 => ppc_insn::PPC_INS_VABSDUH,
            1195 => ppc_insn::PPC_INS_VABSDUW,
            1196 => ppc_insn::PPC_INS_VADDCUQ,
            1197 => ppc_insn::PPC_INS_VADDCUW,
            1198 => ppc_insn::PPC_INS_VADDECUQ,
            1199 => ppc_insn::PPC_INS_VADDEUQM,
            1200 => ppc_insn::PPC_INS_VADDFP,
            1201 => ppc_insn::PPC_INS_VADDSBS,
            1202 => ppc_insn::PPC_INS_VADDSHS,
            1203 => ppc_insn::PPC_INS_VADDSWS,
            1204 => ppc_insn::PPC_INS_VADDUBM,
            1205 => ppc_insn::PPC_INS_VADDUBS,
            1206 => ppc_insn::PPC_INS_VADDUDM,
            1207 => ppc_insn::PPC_INS_VADDUHM,
            1208 => ppc_insn::PPC_INS_VADDUHS,
            1209 => ppc_insn::PPC_INS_VADDUQM,
            1210 => ppc_insn::PPC_INS_VADDUWM,
            1211 => ppc_insn::PPC_INS_VADDUWS,
            1212 => ppc_insn::PPC_INS_VAND,
            1213 => ppc_insn::PPC_INS_VANDC,
            1214 => ppc_insn::PPC_INS_VAVGSB,
            1215 => ppc_insn::PPC_INS_VAVGSH,
            1216 => ppc_insn::PPC_INS_VAVGSW,
            1217 => ppc_insn::PPC_INS_VAVGUB,
            1218 => ppc_insn::PPC_INS_VAVGUH,
            1219 => ppc_insn::PPC_INS_VAVGUW,
            1220 => ppc_insn::PPC_INS_VBPERMD,
            1221 => ppc_insn::PPC_INS_VBPERMQ,
            1222 => ppc_insn::PPC_INS_VCFSX,
            1223 => ppc_insn::PPC_INS_VCFUX,
            1224 => ppc_insn::PPC_INS_VCIPHER,
            1225 => ppc_insn::PPC_INS_VCIPHERLAST,
            1226 => ppc_insn::PPC_INS_VCLZB,
            1227 => ppc_insn::PPC_INS_VCLZD,
            1228 => ppc_insn::PPC_INS_VCLZH,
            1229 => ppc_insn::PPC_INS_VCLZLSBB,
            1230 => ppc_insn::PPC_INS_VCLZW,
            1231 => ppc_insn::PPC_INS_VCMPBFP,
            1232 => ppc_insn::PPC_INS_VCMPEQFP,
            1233 => ppc_insn::PPC_INS_VCMPEQUB,
            1234 => ppc_insn::PPC_INS_VCMPEQUD,
            1235 => ppc_insn::PPC_INS_VCMPEQUH,
            1236 => ppc_insn::PPC_INS_VCMPEQUW,
            1237 => ppc_insn::PPC_INS_VCMPGEFP,
            1238 => ppc_insn::PPC_INS_VCMPGTFP,
            1239 => ppc_insn::PPC_INS_VCMPGTSB,
            1240 => ppc_insn::PPC_INS_VCMPGTSD,
            1241 => ppc_insn::PPC_INS_VCMPGTSH,
            1242 => ppc_insn::PPC_INS_VCMPGTSW,
            1243 => ppc_insn::PPC_INS_VCMPGTUB,
            1244 => ppc_insn::PPC_INS_VCMPGTUD,
            1245 => ppc_insn::PPC_INS_VCMPGTUH,
            1246 => ppc_insn::PPC_INS_VCMPGTUW,
            1247 => ppc_insn::PPC_INS_VCMPNEB,
            1248 => ppc_insn::PPC_INS_VCMPNEH,
            1249 => ppc_insn::PPC_INS_VCMPNEW,
            1250 => ppc_insn::PPC_INS_VCMPNEZB,
            1251 => ppc_insn::PPC_INS_VCMPNEZH,
            1252 => ppc_insn::PPC_INS_VCMPNEZW,
            1253 => ppc_insn::PPC_INS_VCTSXS,
            1254 => ppc_insn::PPC_INS_VCTUXS,
            1255 => ppc_insn::PPC_INS_VCTZB,
            1256 => ppc_insn::PPC_INS_VCTZD,
            1257 => ppc_insn::PPC_INS_VCTZH,
            1258 => ppc_insn::PPC_INS_VCTZLSBB,
            1259 => ppc_insn::PPC_INS_VCTZW,
            1260 => ppc_insn::PPC_INS_VEQV,
            1261 => ppc_insn::PPC_INS_VEXPTEFP,
            1262 => ppc_insn::PPC_INS_VEXTRACTD,
            1263 => ppc_insn::PPC_INS_VEXTRACTUB,
            1264 => ppc_insn::PPC_INS_VEXTRACTUH,
            1265 => ppc_insn::PPC_INS_VEXTRACTUW,
            1266 => ppc_insn::PPC_INS_VEXTSB2D,
            1267 => ppc_insn::PPC_INS_VEXTSB2W,
            1268 => ppc_insn::PPC_INS_VEXTSH2D,
            1269 => ppc_insn::PPC_INS_VEXTSH2W,
            1270 => ppc_insn::PPC_INS_VEXTSW2D,
            1271 => ppc_insn::PPC_INS_VEXTUBLX,
            1272 => ppc_insn::PPC_INS_VEXTUBRX,
            1273 => ppc_insn::PPC_INS_VEXTUHLX,
            1274 => ppc_insn::PPC_INS_VEXTUHRX,
            1275 => ppc_insn::PPC_INS_VEXTUWLX,
            1276 => ppc_insn::PPC_INS_VEXTUWRX,
            1277 => ppc_insn::PPC_INS_VGBBD,
            1278 => ppc_insn::PPC_INS_VINSERTB,
            1279 => ppc_insn::PPC_INS_VINSERTD,
            1280 => ppc_insn::PPC_INS_VINSERTH,
            1281 => ppc_insn::PPC_INS_VINSERTW,
            1282 => ppc_insn::PPC_INS_VLOGEFP,
            1283 => ppc_insn::PPC_INS_VMADDFP,
            1284 => ppc_insn::PPC_INS_VMAXFP,
            1285 => ppc_insn::PPC_INS_VMAXSB,
            1286 => ppc_insn::PPC_INS_VMAXSD,
            1287 => ppc_insn::PPC_INS_VMAXSH,
            1288 => ppc_insn::PPC_INS_VMAXSW,
            1289 => ppc_insn::PPC_INS_VMAXUB,
            1290 => ppc_insn::PPC_INS_VMAXUD,
            1291 => ppc_insn::PPC_INS_VMAXUH,
            1292 => ppc_insn::PPC_INS_VMAXUW,
            1293 => ppc_insn::PPC_INS_VMHADDSHS,
            1294 => ppc_insn::PPC_INS_VMHRADDSHS,
            1295 => ppc_insn::PPC_INS_VMINFP,
            1296 => ppc_insn::PPC_INS_VMINSB,
            1297 => ppc_insn::PPC_INS_VMINSD,
            1298 => ppc_insn::PPC_INS_VMINSH,
            1299 => ppc_insn::PPC_INS_VMINSW,
            1300 => ppc_insn::PPC_INS_VMINUB,
            1301 => ppc_insn::PPC_INS_VMINUD,
            1302 => ppc_insn::PPC_INS_VMINUH,
            1303 => ppc_insn::PPC_INS_VMINUW,
            1304 => ppc_insn::PPC_INS_VMLADDUHM,
            1305 => ppc_insn::PPC_INS_VMR,
            1306 => ppc_insn::PPC_INS_VMRGEW,
            1307 => ppc_insn::PPC_INS_VMRGHB,
            1308 => ppc_insn::PPC_INS_VMRGHH,
            1309 => ppc_insn::PPC_INS_VMRGHW,
            1310 => ppc_insn::PPC_INS_VMRGLB,
            1311 => ppc_insn::PPC_INS_VMRGLH,
            1312 => ppc_insn::PPC_INS_VMRGLW,
            1313 => ppc_insn::PPC_INS_VMRGOW,
            1314 => ppc_insn::PPC_INS_VMSUMMBM,
            1315 => ppc_insn::PPC_INS_VMSUMSHM,
            1316 => ppc_insn::PPC_INS_VMSUMSHS,
            1317 => ppc_insn::PPC_INS_VMSUMUBM,
            1318 => ppc_insn::PPC_INS_VMSUMUHM,
            1319 => ppc_insn::PPC_INS_VMSUMUHS,
            1320 => ppc_insn::PPC_INS_VMUL10CUQ,
            1321 => ppc_insn::PPC_INS_VMUL10ECUQ,
            1322 => ppc_insn::PPC_INS_VMUL10EUQ,
            1323 => ppc_insn::PPC_INS_VMUL10UQ,
            1324 => ppc_insn::PPC_INS_VMULESB,
            1325 => ppc_insn::PPC_INS_VMULESH,
            1326 => ppc_insn::PPC_INS_VMULESW,
            1327 => ppc_insn::PPC_INS_VMULEUB,
            1328 => ppc_insn::PPC_INS_VMULEUH,
            1329 => ppc_insn::PPC_INS_VMULEUW,
            1330 => ppc_insn::PPC_INS_VMULOSB,
            1331 => ppc_insn::PPC_INS_VMULOSH,
            1332 => ppc_insn::PPC_INS_VMULOSW,
            1333 => ppc_insn::PPC_INS_VMULOUB,
            1334 => ppc_insn::PPC_INS_VMULOUH,
            1335 => ppc_insn::PPC_INS_VMULOUW,
            1336 => ppc_insn::PPC_INS_VMULUWM,
            1337 => ppc_insn::PPC_INS_VNAND,
            1338 => ppc_insn::PPC_INS_VNCIPHER,
            1339 => ppc_insn::PPC_INS_VNCIPHERLAST,
            1340 => ppc_insn::PPC_INS_VNEGD,
            1341 => ppc_insn::PPC_INS_VNEGW,
            1342 => ppc_insn::PPC_INS_VNMSUBFP,
            1343 => ppc_insn::PPC_INS_VNOR,
            1344 => ppc_insn::PPC_INS_VNOT,
            1345 => ppc_insn::PPC_INS_VOR,
            1346 => ppc_insn::PPC_INS_VORC,
            1347 => ppc_insn::PPC_INS_VPERM,
            1348 => ppc_insn::PPC_INS_VPERMR,
            1349 => ppc_insn::PPC_INS_VPERMXOR,
            1350 => ppc_insn::PPC_INS_VPKPX,
            1351 => ppc_insn::PPC_INS_VPKSDSS,
            1352 => ppc_insn::PPC_INS_VPKSDUS,
            1353 => ppc_insn::PPC_INS_VPKSHSS,
            1354 => ppc_insn::PPC_INS_VPKSHUS,
            1355 => ppc_insn::PPC_INS_VPKSWSS,
            1356 => ppc_insn::PPC_INS_VPKSWUS,
            1357 => ppc_insn::PPC_INS_VPKUDUM,
            1358 => ppc_insn::PPC_INS_VPKUDUS,
            1359 => ppc_insn::PPC_INS_VPKUHUM,
            1360 => ppc_insn::PPC_INS_VPKUHUS,
            1361 => ppc_insn::PPC_INS_VPKUWUM,
            1362 => ppc_insn::PPC_INS_VPKUWUS,
            1363 => ppc_insn::PPC_INS_VPMSUMB,
            1364 => ppc_insn::PPC_INS_VPMSUMD,
            1365 => ppc_insn::PPC_INS_VPMSUMH,
            1366 => ppc_insn::PPC_INS_VPMSUMW,
            1367 => ppc_insn::PPC_INS_VPOPCNTB,
            1368 => ppc_insn::PPC_INS_VPOPCNTD,
            1369 => ppc_insn::PPC_INS_VPOPCNTH,
            1370 => ppc_insn::PPC_INS_VPOPCNTW,
            1371 => ppc_insn::PPC_INS_VPRTYBD,
            1372 => ppc_insn::PPC_INS_VPRTYBQ,
            1373 => ppc_insn::PPC_INS_VPRTYBW,
            1374 => ppc_insn::PPC_INS_VREFP,
            1375 => ppc_insn::PPC_INS_VRFIM,
            1376 => ppc_insn::PPC_INS_VRFIN,
            1377 => ppc_insn::PPC_INS_VRFIP,
            1378 => ppc_insn::PPC_INS_VRFIZ,
            1379 => ppc_insn::PPC_INS_VRLB,
            1380 => ppc_insn::PPC_INS_VRLD,
            1381 => ppc_insn::PPC_INS_VRLDMI,
            1382 => ppc_insn::PPC_INS_VRLDNM,
            1383 => ppc_insn::PPC_INS_VRLH,
            1384 => ppc_insn::PPC_INS_VRLW,
            1385 => ppc_insn::PPC_INS_VRLWMI,
            1386 => ppc_insn::PPC_INS_VRLWNM,
            1387 => ppc_insn::PPC_INS_VRSQRTEFP,
            1388 => ppc_insn::PPC_INS_VSBOX,
            1389 => ppc_insn::PPC_INS_VSEL,
            1390 => ppc_insn::PPC_INS_VSHASIGMAD,
            1391 => ppc_insn::PPC_INS_VSHASIGMAW,
            1392 => ppc_insn::PPC_INS_VSL,
            1393 => ppc_insn::PPC_INS_VSLB,
            1394 => ppc_insn::PPC_INS_VSLD,
            1395 => ppc_insn::PPC_INS_VSLDOI,
            1396 => ppc_insn::PPC_INS_VSLH,
            1397 => ppc_insn::PPC_INS_VSLO,
            1398 => ppc_insn::PPC_INS_VSLV,
            1399 => ppc_insn::PPC_INS_VSLW,
            1400 => ppc_insn::PPC_INS_VSPLTB,
            1401 => ppc_insn::PPC_INS_VSPLTH,
            1402 => ppc_insn::PPC_INS_VSPLTISB,
            1403 => ppc_insn::PPC_INS_VSPLTISH,
            1404 => ppc_insn::PPC_INS_VSPLTISW,
            1405 => ppc_insn::PPC_INS_VSPLTW,
            1406 => ppc_insn::PPC_INS_VSR,
            1407 => ppc_insn::PPC_INS_VSRAB,
            1408 => ppc_insn::PPC_INS_VSRAD,
            1409 => ppc_insn::PPC_INS_VSRAH,
            1410 => ppc_insn::PPC_INS_VSRAW,
            1411 => ppc_insn::PPC_INS_VSRB,
            1412 => ppc_insn::PPC_INS_VSRD,
            1413 => ppc_insn::PPC_INS_VSRH,
            1414 => ppc_insn::PPC_INS_VSRO,
            1415 => ppc_insn::PPC_INS_VSRV,
            1416 => ppc_insn::PPC_INS_VSRW,
            1417 => ppc_insn::PPC_INS_VSUBCUQ,
            1418 => ppc_insn::PPC_INS_VSUBCUW,
            1419 => ppc_insn::PPC_INS_VSUBECUQ,
            1420 => ppc_insn::PPC_INS_VSUBEUQM,
            1421 => ppc_insn::PPC_INS_VSUBFP,
            1422 => ppc_insn::PPC_INS_VSUBSBS,
            1423 => ppc_insn::PPC_INS_VSUBSHS,
            1424 => ppc_insn::PPC_INS_VSUBSWS,
            1425 => ppc_insn::PPC_INS_VSUBUBM,
            1426 => ppc_insn::PPC_INS_VSUBUBS,
            1427 => ppc_insn::PPC_INS_VSUBUDM,
            1428 => ppc_insn::PPC_INS_VSUBUHM,
            1429 => ppc_insn::PPC_INS_VSUBUHS,
            1430 => ppc_insn::PPC_INS_VSUBUQM,
            1431 => ppc_insn::PPC_INS_VSUBUWM,
            1432 => ppc_insn::PPC_INS_VSUBUWS,
            1433 => ppc_insn::PPC_INS_VSUM2SWS,
            1434 => ppc_insn::PPC_INS_VSUM4SBS,
            1435 => ppc_insn::PPC_INS_VSUM4SHS,
            1436 => ppc_insn::PPC_INS_VSUM4UBS,
            1437 => ppc_insn::PPC_INS_VSUMSWS,
            1438 => ppc_insn::PPC_INS_VUPKHPX,
            1439 => ppc_insn::PPC_INS_VUPKHSB,
            1440 => ppc_insn::PPC_INS_VUPKHSH,
            1441 => ppc_insn::PPC_INS_VUPKHSW,
            1442 => ppc_insn::PPC_INS_VUPKLPX,
            1443 => ppc_insn::PPC_INS_VUPKLSB,
            1444 => ppc_insn::PPC_INS_VUPKLSH,
            1445 => ppc_insn::PPC_INS_VUPKLSW,
            1446 => ppc_insn::PPC_INS_VXOR,
            1447 => ppc_insn::PPC_INS_WAIT,
            1448 => ppc_insn::PPC_INS_WAITIMPL,
            1449 => ppc_insn::PPC_INS_WAITRSV,
            1450 => ppc_insn::PPC_INS_WRTEE,
            1451 => ppc_insn::PPC_INS_WRTEEI,
            1452 => ppc_insn::PPC_INS_XNOP,
            1453 => ppc_insn::PPC_INS_XOR,
            1454 => ppc_insn::PPC_INS_XORI,
            1455 => ppc_insn::PPC_INS_XORIS,
            1456 => ppc_insn::PPC_INS_XSABSDP,
            1457 => ppc_insn::PPC_INS_XSABSQP,
            1458 => ppc_insn::PPC_INS_XSADDDP,
            1459 => ppc_insn::PPC_INS_XSADDQP,
            1460 => ppc_insn::PPC_INS_XSADDQPO,
            1461 => ppc_insn::PPC_INS_XSADDSP,
            1462 => ppc_insn::PPC_INS_XSCMPEQDP,
            1463 => ppc_insn::PPC_INS_XSCMPEXPDP,
            1464 => ppc_insn::PPC_INS_XSCMPEXPQP,
            1465 => ppc_insn::PPC_INS_XSCMPGEDP,
            1466 => ppc_insn::PPC_INS_XSCMPGTDP,
            1467 => ppc_insn::PPC_INS_XSCMPODP,
            1468 => ppc_insn::PPC_INS_XSCMPOQP,
            1469 => ppc_insn::PPC_INS_XSCMPUDP,
            1470 => ppc_insn::PPC_INS_XSCMPUQP,
            1471 => ppc_insn::PPC_INS_XSCPSGNDP,
            1472 => ppc_insn::PPC_INS_XSCPSGNQP,
            1473 => ppc_insn::PPC_INS_XSCVDPHP,
            1474 => ppc_insn::PPC_INS_XSCVDPQP,
            1475 => ppc_insn::PPC_INS_XSCVDPSP,
            1476 => ppc_insn::PPC_INS_XSCVDPSPN,
            1477 => ppc_insn::PPC_INS_XSCVDPSXDS,
            1478 => ppc_insn::PPC_INS_XSCVDPSXWS,
            1479 => ppc_insn::PPC_INS_XSCVDPUXDS,
            1480 => ppc_insn::PPC_INS_XSCVDPUXWS,
            1481 => ppc_insn::PPC_INS_XSCVHPDP,
            1482 => ppc_insn::PPC_INS_XSCVQPDP,
            1483 => ppc_insn::PPC_INS_XSCVQPDPO,
            1484 => ppc_insn::PPC_INS_XSCVQPSDZ,
            1485 => ppc_insn::PPC_INS_XSCVQPSWZ,
            1486 => ppc_insn::PPC_INS_XSCVQPUDZ,
            1487 => ppc_insn::PPC_INS_XSCVQPUWZ,
            1488 => ppc_insn::PPC_INS_XSCVSDQP,
            1489 => ppc_insn::PPC_INS_XSCVSPDP,
            1490 => ppc_insn::PPC_INS_XSCVSPDPN,
            1491 => ppc_insn::PPC_INS_XSCVSXDDP,
            1492 => ppc_insn::PPC_INS_XSCVSXDSP,
            1493 => ppc_insn::PPC_INS_XSCVUDQP,
            1494 => ppc_insn::PPC_INS_XSCVUXDDP,
            1495 => ppc_insn::PPC_INS_XSCVUXDSP,
            1496 => ppc_insn::PPC_INS_XSDIVDP,
            1497 => ppc_insn::PPC_INS_XSDIVQP,
            1498 => ppc_insn::PPC_INS_XSDIVQPO,
            1499 => ppc_insn::PPC_INS_XSDIVSP,
            1500 => ppc_insn::PPC_INS_XSIEXPDP,
            1501 => ppc_insn::PPC_INS_XSIEXPQP,
            1502 => ppc_insn::PPC_INS_XSMADDADP,
            1503 => ppc_insn::PPC_INS_XSMADDASP,
            1504 => ppc_insn::PPC_INS_XSMADDMDP,
            1505 => ppc_insn::PPC_INS_XSMADDMSP,
            1506 => ppc_insn::PPC_INS_XSMADDQP,
            1507 => ppc_insn::PPC_INS_XSMADDQPO,
            1508 => ppc_insn::PPC_INS_XSMAXCDP,
            1509 => ppc_insn::PPC_INS_XSMAXDP,
            1510 => ppc_insn::PPC_INS_XSMAXJDP,
            1511 => ppc_insn::PPC_INS_XSMINCDP,
            1512 => ppc_insn::PPC_INS_XSMINDP,
            1513 => ppc_insn::PPC_INS_XSMINJDP,
            1514 => ppc_insn::PPC_INS_XSMSUBADP,
            1515 => ppc_insn::PPC_INS_XSMSUBASP,
            1516 => ppc_insn::PPC_INS_XSMSUBMDP,
            1517 => ppc_insn::PPC_INS_XSMSUBMSP,
            1518 => ppc_insn::PPC_INS_XSMSUBQP,
            1519 => ppc_insn::PPC_INS_XSMSUBQPO,
            1520 => ppc_insn::PPC_INS_XSMULDP,
            1521 => ppc_insn::PPC_INS_XSMULQP,
            1522 => ppc_insn::PPC_INS_XSMULQPO,
            1523 => ppc_insn::PPC_INS_XSMULSP,
            1524 => ppc_insn::PPC_INS_XSNABSDP,
            1525 => ppc_insn::PPC_INS_XSNABSQP,
            1526 => ppc_insn::PPC_INS_XSNEGDP,
            1527 => ppc_insn::PPC_INS_XSNEGQP,
            1528 => ppc_insn::PPC_INS_XSNMADDADP,
            1529 => ppc_insn::PPC_INS_XSNMADDASP,
            1530 => ppc_insn::PPC_INS_XSNMADDMDP,
            1531 => ppc_insn::PPC_INS_XSNMADDMSP,
            1532 => ppc_insn::PPC_INS_XSNMADDQP,
            1533 => ppc_insn::PPC_INS_XSNMADDQPO,
            1534 => ppc_insn::PPC_INS_XSNMSUBADP,
            1535 => ppc_insn::PPC_INS_XSNMSUBASP,
            1536 => ppc_insn::PPC_INS_XSNMSUBMDP,
            1537 => ppc_insn::PPC_INS_XSNMSUBMSP,
            1538 => ppc_insn::PPC_INS_XSNMSUBQP,
            1539 => ppc_insn::PPC_INS_XSNMSUBQPO,
            1540 => ppc_insn::PPC_INS_XSRDPI,
            1541 => ppc_insn::PPC_INS_XSRDPIC,
            1542 => ppc_insn::PPC_INS_XSRDPIM,
            1543 => ppc_insn::PPC_INS_XSRDPIP,
            1544 => ppc_insn::PPC_INS_XSRDPIZ,
            1545 => ppc_insn::PPC_INS_XSREDP,
            1546 => ppc_insn::PPC_INS_XSRESP,
            1547 => ppc_insn::PPC_INS_XSRQPI,
            1548 => ppc_insn::PPC_INS_XSRQPIX,
            1549 => ppc_insn::PPC_INS_XSRQPXP,
            1550 => ppc_insn::PPC_INS_XSRSP,
            1551 => ppc_insn::PPC_INS_XSRSQRTEDP,
            1552 => ppc_insn::PPC_INS_XSRSQRTESP,
            1553 => ppc_insn::PPC_INS_XSSQRTDP,
            1554 => ppc_insn::PPC_INS_XSSQRTQP,
            1555 => ppc_insn::PPC_INS_XSSQRTQPO,
            1556 => ppc_insn::PPC_INS_XSSQRTSP,
            1557 => ppc_insn::PPC_INS_XSSUBDP,
            1558 => ppc_insn::PPC_INS_XSSUBQP,
            1559 => ppc_insn::PPC_INS_XSSUBQPO,
            1560 => ppc_insn::PPC_INS_XSSUBSP,
            1561 => ppc_insn::PPC_INS_XSTDIVDP,
            1562 => ppc_insn::PPC_INS_XSTSQRTDP,
            1563 => ppc_insn::PPC_INS_XSTSTDCDP,
            1564 => ppc_insn::PPC_INS_XSTSTDCQP,
            1565 => ppc_insn::PPC_INS_XSTSTDCSP,
            1566 => ppc_insn::PPC_INS_XSXEXPDP,
            1567 => ppc_insn::PPC_INS_XSXEXPQP,
            1568 => ppc_insn::PPC_INS_XSXSIGDP,
            1569 => ppc_insn::PPC_INS_XSXSIGQP,
            1570 => ppc_insn::PPC_INS_XVABSDP,
            1571 => ppc_insn::PPC_INS_XVABSSP,
            1572 => ppc_insn::PPC_INS_XVADDDP,
            1573 => ppc_insn::PPC_INS_XVADDSP,
            1574 => ppc_insn::PPC_INS_XVCMPEQDP,
            1575 => ppc_insn::PPC_INS_XVCMPEQSP,
            1576 => ppc_insn::PPC_INS_XVCMPGEDP,
            1577 => ppc_insn::PPC_INS_XVCMPGESP,
            1578 => ppc_insn::PPC_INS_XVCMPGTDP,
            1579 => ppc_insn::PPC_INS_XVCMPGTSP,
            1580 => ppc_insn::PPC_INS_XVCPSGNDP,
            1581 => ppc_insn::PPC_INS_XVCPSGNSP,
            1582 => ppc_insn::PPC_INS_XVCVDPSP,
            1583 => ppc_insn::PPC_INS_XVCVDPSXDS,
            1584 => ppc_insn::PPC_INS_XVCVDPSXWS,
            1585 => ppc_insn::PPC_INS_XVCVDPUXDS,
            1586 => ppc_insn::PPC_INS_XVCVDPUXWS,
            1587 => ppc_insn::PPC_INS_XVCVHPSP,
            1588 => ppc_insn::PPC_INS_XVCVSPDP,
            1589 => ppc_insn::PPC_INS_XVCVSPHP,
            1590 => ppc_insn::PPC_INS_XVCVSPSXDS,
            1591 => ppc_insn::PPC_INS_XVCVSPSXWS,
            1592 => ppc_insn::PPC_INS_XVCVSPUXDS,
            1593 => ppc_insn::PPC_INS_XVCVSPUXWS,
            1594 => ppc_insn::PPC_INS_XVCVSXDDP,
            1595 => ppc_insn::PPC_INS_XVCVSXDSP,
            1596 => ppc_insn::PPC_INS_XVCVSXWDP,
            1597 => ppc_insn::PPC_INS_XVCVSXWSP,
            1598 => ppc_insn::PPC_INS_XVCVUXDDP,
            1599 => ppc_insn::PPC_INS_XVCVUXDSP,
            1600 => ppc_insn::PPC_INS_XVCVUXWDP,
            1601 => ppc_insn::PPC_INS_XVCVUXWSP,
            1602 => ppc_insn::PPC_INS_XVDIVDP,
            1603 => ppc_insn::PPC_INS_XVDIVSP,
            1604 => ppc_insn::PPC_INS_XVIEXPDP,
            1605 => ppc_insn::PPC_INS_XVIEXPSP,
            1606 => ppc_insn::PPC_INS_XVMADDADP,
            1607 => ppc_insn::PPC_INS_XVMADDASP,
            1608 => ppc_insn::PPC_INS_XVMADDMDP,
            1609 => ppc_insn::PPC_INS_XVMADDMSP,
            1610 => ppc_insn::PPC_INS_XVMAXDP,
            1611 => ppc_insn::PPC_INS_XVMAXSP,
            1612 => ppc_insn::PPC_INS_XVMINDP,
            1613 => ppc_insn::PPC_INS_XVMINSP,
            1614 => ppc_insn::PPC_INS_XVMOVDP,
            1615 => ppc_insn::PPC_INS_XVMOVSP,
            1616 => ppc_insn::PPC_INS_XVMSUBADP,
            1617 => ppc_insn::PPC_INS_XVMSUBASP,
            1618 => ppc_insn::PPC_INS_XVMSUBMDP,
            1619 => ppc_insn::PPC_INS_XVMSUBMSP,
            1620 => ppc_insn::PPC_INS_XVMULDP,
            1621 => ppc_insn::PPC_INS_XVMULSP,
            1622 => ppc_insn::PPC_INS_XVNABSDP,
            1623 => ppc_insn::PPC_INS_XVNABSSP,
            1624 => ppc_insn::PPC_INS_XVNEGDP,
            1625 => ppc_insn::PPC_INS_XVNEGSP,
            1626 => ppc_insn::PPC_INS_XVNMADDADP,
            1627 => ppc_insn::PPC_INS_XVNMADDASP,
            1628 => ppc_insn::PPC_INS_XVNMADDMDP,
            1629 => ppc_insn::PPC_INS_XVNMADDMSP,
            1630 => ppc_insn::PPC_INS_XVNMSUBADP,
            1631 => ppc_insn::PPC_INS_XVNMSUBASP,
            1632 => ppc_insn::PPC_INS_XVNMSUBMDP,
            1633 => ppc_insn::PPC_INS_XVNMSUBMSP,
            1634 => ppc_insn::PPC_INS_XVRDPI,
            1635 => ppc_insn::PPC_INS_XVRDPIC,
            1636 => ppc_insn::PPC_INS_XVRDPIM,
            1637 => ppc_insn::PPC_INS_XVRDPIP,
            1638 => ppc_insn::PPC_INS_XVRDPIZ,
            1639 => ppc_insn::PPC_INS_XVREDP,
            1640 => ppc_insn::PPC_INS_XVRESP,
            1641 => ppc_insn::PPC_INS_XVRSPI,
            1642 => ppc_insn::PPC_INS_XVRSPIC,
            1643 => ppc_insn::PPC_INS_XVRSPIM,
            1644 => ppc_insn::PPC_INS_XVRSPIP,
            1645 => ppc_insn::PPC_INS_XVRSPIZ,
            1646 => ppc_insn::PPC_INS_XVRSQRTEDP,
            1647 => ppc_insn::PPC_INS_XVRSQRTESP,
            1648 => ppc_insn::PPC_INS_XVSQRTDP,
            1649 => ppc_insn::PPC_INS_XVSQRTSP,
            1650 => ppc_insn::PPC_INS_XVSUBDP,
            1651 => ppc_insn::PPC_INS_XVSUBSP,
            1652 => ppc_insn::PPC_INS_XVTDIVDP,
            1653 => ppc_insn::PPC_INS_XVTDIVSP,
            1654 => ppc_insn::PPC_INS_XVTSQRTDP,
            1655 => ppc_insn::PPC_INS_XVTSQRTSP,
            1656 => ppc_insn::PPC_INS_XVTSTDCDP,
            1657 => ppc_insn::PPC_INS_XVTSTDCSP,
            1658 => ppc_insn::PPC_INS_XVXEXPDP,
            1659 => ppc_insn::PPC_INS_XVXEXPSP,
            1660 => ppc_insn::PPC_INS_XVXSIGDP,
            1661 => ppc_insn::PPC_INS_XVXSIGSP,
            1662 => ppc_insn::PPC_INS_XXBRD,
            1663 => ppc_insn::PPC_INS_XXBRH,
            1664 => ppc_insn::PPC_INS_XXBRQ,
            1665 => ppc_insn::PPC_INS_XXBRW,
            1666 => ppc_insn::PPC_INS_XXEXTRACTUW,
            1667 => ppc_insn::PPC_INS_XXINSERTW,
            1668 => ppc_insn::PPC_INS_XXLAND,
            1669 => ppc_insn::PPC_INS_XXLANDC,
            1670 => ppc_insn::PPC_INS_XXLEQV,
            1671 => ppc_insn::PPC_INS_XXLNAND,
            1672 => ppc_insn::PPC_INS_XXLNOR,
            1673 => ppc_insn::PPC_INS_XXLOR,
            1674 => ppc_insn::PPC_INS_XXLORC,
            1675 => ppc_insn::PPC_INS_XXLXOR,
            1676 => ppc_insn::PPC_INS_XXMRGHD,
            1677 => ppc_insn::PPC_INS_XXMRGHW,
            1678 => ppc_insn::PPC_INS_XXMRGLD,
            1679 => ppc_insn::PPC_INS_XXMRGLW,
            1680 => ppc_insn::PPC_INS_XXPERM,
            1681 => ppc_insn::PPC_INS_XXPERMDI,
            1682 => ppc_insn::PPC_INS_XXPERMR,
            1683 => ppc_insn::PPC_INS_XXSEL,
            1684 => ppc_insn::PPC_INS_XXSLDWI,
            1685 => ppc_insn::PPC_INS_XXSPLTD,
            1686 => ppc_insn::PPC_INS_XXSPLTIB,
            1687 => ppc_insn::PPC_INS_XXSPLTW,
            1688 => ppc_insn::PPC_INS_XXSWAPD,
            1689 => ppc_insn::PPC_INS_ENDING,
            _ => ppc_insn::PPC_INS_INVALID,
        }
    }
}
impl From<u32> for riscv_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => riscv_insn::RISCV_INS_INVALID,
            1 => riscv_insn::RISCV_INS_ADD,
            2 => riscv_insn::RISCV_INS_ADDI,
            3 => riscv_insn::RISCV_INS_ADDIW,
            4 => riscv_insn::RISCV_INS_ADDW,
            5 => riscv_insn::RISCV_INS_AMOADD_D,
            6 => riscv_insn::RISCV_INS_AMOADD_D_AQ,
            7 => riscv_insn::RISCV_INS_AMOADD_D_AQ_RL,
            8 => riscv_insn::RISCV_INS_AMOADD_D_RL,
            9 => riscv_insn::RISCV_INS_AMOADD_W,
            10 => riscv_insn::RISCV_INS_AMOADD_W_AQ,
            11 => riscv_insn::RISCV_INS_AMOADD_W_AQ_RL,
            12 => riscv_insn::RISCV_INS_AMOADD_W_RL,
            13 => riscv_insn::RISCV_INS_AMOAND_D,
            14 => riscv_insn::RISCV_INS_AMOAND_D_AQ,
            15 => riscv_insn::RISCV_INS_AMOAND_D_AQ_RL,
            16 => riscv_insn::RISCV_INS_AMOAND_D_RL,
            17 => riscv_insn::RISCV_INS_AMOAND_W,
            18 => riscv_insn::RISCV_INS_AMOAND_W_AQ,
            19 => riscv_insn::RISCV_INS_AMOAND_W_AQ_RL,
            20 => riscv_insn::RISCV_INS_AMOAND_W_RL,
            21 => riscv_insn::RISCV_INS_AMOMAXU_D,
            22 => riscv_insn::RISCV_INS_AMOMAXU_D_AQ,
            23 => riscv_insn::RISCV_INS_AMOMAXU_D_AQ_RL,
            24 => riscv_insn::RISCV_INS_AMOMAXU_D_RL,
            25 => riscv_insn::RISCV_INS_AMOMAXU_W,
            26 => riscv_insn::RISCV_INS_AMOMAXU_W_AQ,
            27 => riscv_insn::RISCV_INS_AMOMAXU_W_AQ_RL,
            28 => riscv_insn::RISCV_INS_AMOMAXU_W_RL,
            29 => riscv_insn::RISCV_INS_AMOMAX_D,
            30 => riscv_insn::RISCV_INS_AMOMAX_D_AQ,
            31 => riscv_insn::RISCV_INS_AMOMAX_D_AQ_RL,
            32 => riscv_insn::RISCV_INS_AMOMAX_D_RL,
            33 => riscv_insn::RISCV_INS_AMOMAX_W,
            34 => riscv_insn::RISCV_INS_AMOMAX_W_AQ,
            35 => riscv_insn::RISCV_INS_AMOMAX_W_AQ_RL,
            36 => riscv_insn::RISCV_INS_AMOMAX_W_RL,
            37 => riscv_insn::RISCV_INS_AMOMINU_D,
            38 => riscv_insn::RISCV_INS_AMOMINU_D_AQ,
            39 => riscv_insn::RISCV_INS_AMOMINU_D_AQ_RL,
            40 => riscv_insn::RISCV_INS_AMOMINU_D_RL,
            41 => riscv_insn::RISCV_INS_AMOMINU_W,
            42 => riscv_insn::RISCV_INS_AMOMINU_W_AQ,
            43 => riscv_insn::RISCV_INS_AMOMINU_W_AQ_RL,
            44 => riscv_insn::RISCV_INS_AMOMINU_W_RL,
            45 => riscv_insn::RISCV_INS_AMOMIN_D,
            46 => riscv_insn::RISCV_INS_AMOMIN_D_AQ,
            47 => riscv_insn::RISCV_INS_AMOMIN_D_AQ_RL,
            48 => riscv_insn::RISCV_INS_AMOMIN_D_RL,
            49 => riscv_insn::RISCV_INS_AMOMIN_W,
            50 => riscv_insn::RISCV_INS_AMOMIN_W_AQ,
            51 => riscv_insn::RISCV_INS_AMOMIN_W_AQ_RL,
            52 => riscv_insn::RISCV_INS_AMOMIN_W_RL,
            53 => riscv_insn::RISCV_INS_AMOOR_D,
            54 => riscv_insn::RISCV_INS_AMOOR_D_AQ,
            55 => riscv_insn::RISCV_INS_AMOOR_D_AQ_RL,
            56 => riscv_insn::RISCV_INS_AMOOR_D_RL,
            57 => riscv_insn::RISCV_INS_AMOOR_W,
            58 => riscv_insn::RISCV_INS_AMOOR_W_AQ,
            59 => riscv_insn::RISCV_INS_AMOOR_W_AQ_RL,
            60 => riscv_insn::RISCV_INS_AMOOR_W_RL,
            61 => riscv_insn::RISCV_INS_AMOSWAP_D,
            62 => riscv_insn::RISCV_INS_AMOSWAP_D_AQ,
            63 => riscv_insn::RISCV_INS_AMOSWAP_D_AQ_RL,
            64 => riscv_insn::RISCV_INS_AMOSWAP_D_RL,
            65 => riscv_insn::RISCV_INS_AMOSWAP_W,
            66 => riscv_insn::RISCV_INS_AMOSWAP_W_AQ,
            67 => riscv_insn::RISCV_INS_AMOSWAP_W_AQ_RL,
            68 => riscv_insn::RISCV_INS_AMOSWAP_W_RL,
            69 => riscv_insn::RISCV_INS_AMOXOR_D,
            70 => riscv_insn::RISCV_INS_AMOXOR_D_AQ,
            71 => riscv_insn::RISCV_INS_AMOXOR_D_AQ_RL,
            72 => riscv_insn::RISCV_INS_AMOXOR_D_RL,
            73 => riscv_insn::RISCV_INS_AMOXOR_W,
            74 => riscv_insn::RISCV_INS_AMOXOR_W_AQ,
            75 => riscv_insn::RISCV_INS_AMOXOR_W_AQ_RL,
            76 => riscv_insn::RISCV_INS_AMOXOR_W_RL,
            77 => riscv_insn::RISCV_INS_AND,
            78 => riscv_insn::RISCV_INS_ANDI,
            79 => riscv_insn::RISCV_INS_AUIPC,
            80 => riscv_insn::RISCV_INS_BEQ,
            81 => riscv_insn::RISCV_INS_BGE,
            82 => riscv_insn::RISCV_INS_BGEU,
            83 => riscv_insn::RISCV_INS_BLT,
            84 => riscv_insn::RISCV_INS_BLTU,
            85 => riscv_insn::RISCV_INS_BNE,
            86 => riscv_insn::RISCV_INS_CSRRC,
            87 => riscv_insn::RISCV_INS_CSRRCI,
            88 => riscv_insn::RISCV_INS_CSRRS,
            89 => riscv_insn::RISCV_INS_CSRRSI,
            90 => riscv_insn::RISCV_INS_CSRRW,
            91 => riscv_insn::RISCV_INS_CSRRWI,
            92 => riscv_insn::RISCV_INS_C_ADD,
            93 => riscv_insn::RISCV_INS_C_ADDI,
            94 => riscv_insn::RISCV_INS_C_ADDI16SP,
            95 => riscv_insn::RISCV_INS_C_ADDI4SPN,
            96 => riscv_insn::RISCV_INS_C_ADDIW,
            97 => riscv_insn::RISCV_INS_C_ADDW,
            98 => riscv_insn::RISCV_INS_C_AND,
            99 => riscv_insn::RISCV_INS_C_ANDI,
            100 => riscv_insn::RISCV_INS_C_BEQZ,
            101 => riscv_insn::RISCV_INS_C_BNEZ,
            102 => riscv_insn::RISCV_INS_C_EBREAK,
            103 => riscv_insn::RISCV_INS_C_FLD,
            104 => riscv_insn::RISCV_INS_C_FLDSP,
            105 => riscv_insn::RISCV_INS_C_FLW,
            106 => riscv_insn::RISCV_INS_C_FLWSP,
            107 => riscv_insn::RISCV_INS_C_FSD,
            108 => riscv_insn::RISCV_INS_C_FSDSP,
            109 => riscv_insn::RISCV_INS_C_FSW,
            110 => riscv_insn::RISCV_INS_C_FSWSP,
            111 => riscv_insn::RISCV_INS_C_J,
            112 => riscv_insn::RISCV_INS_C_JAL,
            113 => riscv_insn::RISCV_INS_C_JALR,
            114 => riscv_insn::RISCV_INS_C_JR,
            115 => riscv_insn::RISCV_INS_C_LD,
            116 => riscv_insn::RISCV_INS_C_LDSP,
            117 => riscv_insn::RISCV_INS_C_LI,
            118 => riscv_insn::RISCV_INS_C_LUI,
            119 => riscv_insn::RISCV_INS_C_LW,
            120 => riscv_insn::RISCV_INS_C_LWSP,
            121 => riscv_insn::RISCV_INS_C_MV,
            122 => riscv_insn::RISCV_INS_C_NOP,
            123 => riscv_insn::RISCV_INS_C_OR,
            124 => riscv_insn::RISCV_INS_C_SD,
            125 => riscv_insn::RISCV_INS_C_SDSP,
            126 => riscv_insn::RISCV_INS_C_SLLI,
            127 => riscv_insn::RISCV_INS_C_SRAI,
            128 => riscv_insn::RISCV_INS_C_SRLI,
            129 => riscv_insn::RISCV_INS_C_SUB,
            130 => riscv_insn::RISCV_INS_C_SUBW,
            131 => riscv_insn::RISCV_INS_C_SW,
            132 => riscv_insn::RISCV_INS_C_SWSP,
            133 => riscv_insn::RISCV_INS_C_UNIMP,
            134 => riscv_insn::RISCV_INS_C_XOR,
            135 => riscv_insn::RISCV_INS_DIV,
            136 => riscv_insn::RISCV_INS_DIVU,
            137 => riscv_insn::RISCV_INS_DIVUW,
            138 => riscv_insn::RISCV_INS_DIVW,
            139 => riscv_insn::RISCV_INS_EBREAK,
            140 => riscv_insn::RISCV_INS_ECALL,
            141 => riscv_insn::RISCV_INS_FADD_D,
            142 => riscv_insn::RISCV_INS_FADD_S,
            143 => riscv_insn::RISCV_INS_FCLASS_D,
            144 => riscv_insn::RISCV_INS_FCLASS_S,
            145 => riscv_insn::RISCV_INS_FCVT_D_L,
            146 => riscv_insn::RISCV_INS_FCVT_D_LU,
            147 => riscv_insn::RISCV_INS_FCVT_D_S,
            148 => riscv_insn::RISCV_INS_FCVT_D_W,
            149 => riscv_insn::RISCV_INS_FCVT_D_WU,
            150 => riscv_insn::RISCV_INS_FCVT_LU_D,
            151 => riscv_insn::RISCV_INS_FCVT_LU_S,
            152 => riscv_insn::RISCV_INS_FCVT_L_D,
            153 => riscv_insn::RISCV_INS_FCVT_L_S,
            154 => riscv_insn::RISCV_INS_FCVT_S_D,
            155 => riscv_insn::RISCV_INS_FCVT_S_L,
            156 => riscv_insn::RISCV_INS_FCVT_S_LU,
            157 => riscv_insn::RISCV_INS_FCVT_S_W,
            158 => riscv_insn::RISCV_INS_FCVT_S_WU,
            159 => riscv_insn::RISCV_INS_FCVT_WU_D,
            160 => riscv_insn::RISCV_INS_FCVT_WU_S,
            161 => riscv_insn::RISCV_INS_FCVT_W_D,
            162 => riscv_insn::RISCV_INS_FCVT_W_S,
            163 => riscv_insn::RISCV_INS_FDIV_D,
            164 => riscv_insn::RISCV_INS_FDIV_S,
            165 => riscv_insn::RISCV_INS_FENCE,
            166 => riscv_insn::RISCV_INS_FENCE_I,
            167 => riscv_insn::RISCV_INS_FENCE_TSO,
            168 => riscv_insn::RISCV_INS_FEQ_D,
            169 => riscv_insn::RISCV_INS_FEQ_S,
            170 => riscv_insn::RISCV_INS_FLD,
            171 => riscv_insn::RISCV_INS_FLE_D,
            172 => riscv_insn::RISCV_INS_FLE_S,
            173 => riscv_insn::RISCV_INS_FLT_D,
            174 => riscv_insn::RISCV_INS_FLT_S,
            175 => riscv_insn::RISCV_INS_FLW,
            176 => riscv_insn::RISCV_INS_FMADD_D,
            177 => riscv_insn::RISCV_INS_FMADD_S,
            178 => riscv_insn::RISCV_INS_FMAX_D,
            179 => riscv_insn::RISCV_INS_FMAX_S,
            180 => riscv_insn::RISCV_INS_FMIN_D,
            181 => riscv_insn::RISCV_INS_FMIN_S,
            182 => riscv_insn::RISCV_INS_FMSUB_D,
            183 => riscv_insn::RISCV_INS_FMSUB_S,
            184 => riscv_insn::RISCV_INS_FMUL_D,
            185 => riscv_insn::RISCV_INS_FMUL_S,
            186 => riscv_insn::RISCV_INS_FMV_D_X,
            187 => riscv_insn::RISCV_INS_FMV_W_X,
            188 => riscv_insn::RISCV_INS_FMV_X_D,
            189 => riscv_insn::RISCV_INS_FMV_X_W,
            190 => riscv_insn::RISCV_INS_FNMADD_D,
            191 => riscv_insn::RISCV_INS_FNMADD_S,
            192 => riscv_insn::RISCV_INS_FNMSUB_D,
            193 => riscv_insn::RISCV_INS_FNMSUB_S,
            194 => riscv_insn::RISCV_INS_FSD,
            195 => riscv_insn::RISCV_INS_FSGNJN_D,
            196 => riscv_insn::RISCV_INS_FSGNJN_S,
            197 => riscv_insn::RISCV_INS_FSGNJX_D,
            198 => riscv_insn::RISCV_INS_FSGNJX_S,
            199 => riscv_insn::RISCV_INS_FSGNJ_D,
            200 => riscv_insn::RISCV_INS_FSGNJ_S,
            201 => riscv_insn::RISCV_INS_FSQRT_D,
            202 => riscv_insn::RISCV_INS_FSQRT_S,
            203 => riscv_insn::RISCV_INS_FSUB_D,
            204 => riscv_insn::RISCV_INS_FSUB_S,
            205 => riscv_insn::RISCV_INS_FSW,
            206 => riscv_insn::RISCV_INS_JAL,
            207 => riscv_insn::RISCV_INS_JALR,
            208 => riscv_insn::RISCV_INS_LB,
            209 => riscv_insn::RISCV_INS_LBU,
            210 => riscv_insn::RISCV_INS_LD,
            211 => riscv_insn::RISCV_INS_LH,
            212 => riscv_insn::RISCV_INS_LHU,
            213 => riscv_insn::RISCV_INS_LR_D,
            214 => riscv_insn::RISCV_INS_LR_D_AQ,
            215 => riscv_insn::RISCV_INS_LR_D_AQ_RL,
            216 => riscv_insn::RISCV_INS_LR_D_RL,
            217 => riscv_insn::RISCV_INS_LR_W,
            218 => riscv_insn::RISCV_INS_LR_W_AQ,
            219 => riscv_insn::RISCV_INS_LR_W_AQ_RL,
            220 => riscv_insn::RISCV_INS_LR_W_RL,
            221 => riscv_insn::RISCV_INS_LUI,
            222 => riscv_insn::RISCV_INS_LW,
            223 => riscv_insn::RISCV_INS_LWU,
            224 => riscv_insn::RISCV_INS_MRET,
            225 => riscv_insn::RISCV_INS_MUL,
            226 => riscv_insn::RISCV_INS_MULH,
            227 => riscv_insn::RISCV_INS_MULHSU,
            228 => riscv_insn::RISCV_INS_MULHU,
            229 => riscv_insn::RISCV_INS_MULW,
            230 => riscv_insn::RISCV_INS_OR,
            231 => riscv_insn::RISCV_INS_ORI,
            232 => riscv_insn::RISCV_INS_REM,
            233 => riscv_insn::RISCV_INS_REMU,
            234 => riscv_insn::RISCV_INS_REMUW,
            235 => riscv_insn::RISCV_INS_REMW,
            236 => riscv_insn::RISCV_INS_SB,
            237 => riscv_insn::RISCV_INS_SC_D,
            238 => riscv_insn::RISCV_INS_SC_D_AQ,
            239 => riscv_insn::RISCV_INS_SC_D_AQ_RL,
            240 => riscv_insn::RISCV_INS_SC_D_RL,
            241 => riscv_insn::RISCV_INS_SC_W,
            242 => riscv_insn::RISCV_INS_SC_W_AQ,
            243 => riscv_insn::RISCV_INS_SC_W_AQ_RL,
            244 => riscv_insn::RISCV_INS_SC_W_RL,
            245 => riscv_insn::RISCV_INS_SD,
            246 => riscv_insn::RISCV_INS_SFENCE_VMA,
            247 => riscv_insn::RISCV_INS_SH,
            248 => riscv_insn::RISCV_INS_SLL,
            249 => riscv_insn::RISCV_INS_SLLI,
            250 => riscv_insn::RISCV_INS_SLLIW,
            251 => riscv_insn::RISCV_INS_SLLW,
            252 => riscv_insn::RISCV_INS_SLT,
            253 => riscv_insn::RISCV_INS_SLTI,
            254 => riscv_insn::RISCV_INS_SLTIU,
            255 => riscv_insn::RISCV_INS_SLTU,
            256 => riscv_insn::RISCV_INS_SRA,
            257 => riscv_insn::RISCV_INS_SRAI,
            258 => riscv_insn::RISCV_INS_SRAIW,
            259 => riscv_insn::RISCV_INS_SRAW,
            260 => riscv_insn::RISCV_INS_SRET,
            261 => riscv_insn::RISCV_INS_SRL,
            262 => riscv_insn::RISCV_INS_SRLI,
            263 => riscv_insn::RISCV_INS_SRLIW,
            264 => riscv_insn::RISCV_INS_SRLW,
            265 => riscv_insn::RISCV_INS_SUB,
            266 => riscv_insn::RISCV_INS_SUBW,
            267 => riscv_insn::RISCV_INS_SW,
            268 => riscv_insn::RISCV_INS_UNIMP,
            269 => riscv_insn::RISCV_INS_URET,
            270 => riscv_insn::RISCV_INS_WFI,
            271 => riscv_insn::RISCV_INS_XOR,
            272 => riscv_insn::RISCV_INS_XORI,
            273 => riscv_insn::RISCV_INS_ENDING,
            _ => riscv_insn::RISCV_INS_INVALID,
        }
    }
}
impl From<u32> for sparc_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => sparc_insn::SPARC_INS_INVALID,
            1 => sparc_insn::SPARC_INS_ADDCC,
            2 => sparc_insn::SPARC_INS_ADDX,
            3 => sparc_insn::SPARC_INS_ADDXCC,
            4 => sparc_insn::SPARC_INS_ADDXC,
            5 => sparc_insn::SPARC_INS_ADDXCCC,
            6 => sparc_insn::SPARC_INS_ADD,
            7 => sparc_insn::SPARC_INS_ALIGNADDR,
            8 => sparc_insn::SPARC_INS_ALIGNADDRL,
            9 => sparc_insn::SPARC_INS_ANDCC,
            10 => sparc_insn::SPARC_INS_ANDNCC,
            11 => sparc_insn::SPARC_INS_ANDN,
            12 => sparc_insn::SPARC_INS_AND,
            13 => sparc_insn::SPARC_INS_ARRAY16,
            14 => sparc_insn::SPARC_INS_ARRAY32,
            15 => sparc_insn::SPARC_INS_ARRAY8,
            16 => sparc_insn::SPARC_INS_B,
            17 => sparc_insn::SPARC_INS_JMP,
            18 => sparc_insn::SPARC_INS_BMASK,
            19 => sparc_insn::SPARC_INS_FB,
            20 => sparc_insn::SPARC_INS_BRGEZ,
            21 => sparc_insn::SPARC_INS_BRGZ,
            22 => sparc_insn::SPARC_INS_BRLEZ,
            23 => sparc_insn::SPARC_INS_BRLZ,
            24 => sparc_insn::SPARC_INS_BRNZ,
            25 => sparc_insn::SPARC_INS_BRZ,
            26 => sparc_insn::SPARC_INS_BSHUFFLE,
            27 => sparc_insn::SPARC_INS_CALL,
            28 => sparc_insn::SPARC_INS_CASX,
            29 => sparc_insn::SPARC_INS_CAS,
            30 => sparc_insn::SPARC_INS_CMASK16,
            31 => sparc_insn::SPARC_INS_CMASK32,
            32 => sparc_insn::SPARC_INS_CMASK8,
            33 => sparc_insn::SPARC_INS_CMP,
            34 => sparc_insn::SPARC_INS_EDGE16,
            35 => sparc_insn::SPARC_INS_EDGE16L,
            36 => sparc_insn::SPARC_INS_EDGE16LN,
            37 => sparc_insn::SPARC_INS_EDGE16N,
            38 => sparc_insn::SPARC_INS_EDGE32,
            39 => sparc_insn::SPARC_INS_EDGE32L,
            40 => sparc_insn::SPARC_INS_EDGE32LN,
            41 => sparc_insn::SPARC_INS_EDGE32N,
            42 => sparc_insn::SPARC_INS_EDGE8,
            43 => sparc_insn::SPARC_INS_EDGE8L,
            44 => sparc_insn::SPARC_INS_EDGE8LN,
            45 => sparc_insn::SPARC_INS_EDGE8N,
            46 => sparc_insn::SPARC_INS_FABSD,
            47 => sparc_insn::SPARC_INS_FABSQ,
            48 => sparc_insn::SPARC_INS_FABSS,
            49 => sparc_insn::SPARC_INS_FADDD,
            50 => sparc_insn::SPARC_INS_FADDQ,
            51 => sparc_insn::SPARC_INS_FADDS,
            52 => sparc_insn::SPARC_INS_FALIGNDATA,
            53 => sparc_insn::SPARC_INS_FAND,
            54 => sparc_insn::SPARC_INS_FANDNOT1,
            55 => sparc_insn::SPARC_INS_FANDNOT1S,
            56 => sparc_insn::SPARC_INS_FANDNOT2,
            57 => sparc_insn::SPARC_INS_FANDNOT2S,
            58 => sparc_insn::SPARC_INS_FANDS,
            59 => sparc_insn::SPARC_INS_FCHKSM16,
            60 => sparc_insn::SPARC_INS_FCMPD,
            61 => sparc_insn::SPARC_INS_FCMPEQ16,
            62 => sparc_insn::SPARC_INS_FCMPEQ32,
            63 => sparc_insn::SPARC_INS_FCMPGT16,
            64 => sparc_insn::SPARC_INS_FCMPGT32,
            65 => sparc_insn::SPARC_INS_FCMPLE16,
            66 => sparc_insn::SPARC_INS_FCMPLE32,
            67 => sparc_insn::SPARC_INS_FCMPNE16,
            68 => sparc_insn::SPARC_INS_FCMPNE32,
            69 => sparc_insn::SPARC_INS_FCMPQ,
            70 => sparc_insn::SPARC_INS_FCMPS,
            71 => sparc_insn::SPARC_INS_FDIVD,
            72 => sparc_insn::SPARC_INS_FDIVQ,
            73 => sparc_insn::SPARC_INS_FDIVS,
            74 => sparc_insn::SPARC_INS_FDMULQ,
            75 => sparc_insn::SPARC_INS_FDTOI,
            76 => sparc_insn::SPARC_INS_FDTOQ,
            77 => sparc_insn::SPARC_INS_FDTOS,
            78 => sparc_insn::SPARC_INS_FDTOX,
            79 => sparc_insn::SPARC_INS_FEXPAND,
            80 => sparc_insn::SPARC_INS_FHADDD,
            81 => sparc_insn::SPARC_INS_FHADDS,
            82 => sparc_insn::SPARC_INS_FHSUBD,
            83 => sparc_insn::SPARC_INS_FHSUBS,
            84 => sparc_insn::SPARC_INS_FITOD,
            85 => sparc_insn::SPARC_INS_FITOQ,
            86 => sparc_insn::SPARC_INS_FITOS,
            87 => sparc_insn::SPARC_INS_FLCMPD,
            88 => sparc_insn::SPARC_INS_FLCMPS,
            89 => sparc_insn::SPARC_INS_FLUSHW,
            90 => sparc_insn::SPARC_INS_FMEAN16,
            91 => sparc_insn::SPARC_INS_FMOVD,
            92 => sparc_insn::SPARC_INS_FMOVQ,
            93 => sparc_insn::SPARC_INS_FMOVRDGEZ,
            94 => sparc_insn::SPARC_INS_FMOVRQGEZ,
            95 => sparc_insn::SPARC_INS_FMOVRSGEZ,
            96 => sparc_insn::SPARC_INS_FMOVRDGZ,
            97 => sparc_insn::SPARC_INS_FMOVRQGZ,
            98 => sparc_insn::SPARC_INS_FMOVRSGZ,
            99 => sparc_insn::SPARC_INS_FMOVRDLEZ,
            100 => sparc_insn::SPARC_INS_FMOVRQLEZ,
            101 => sparc_insn::SPARC_INS_FMOVRSLEZ,
            102 => sparc_insn::SPARC_INS_FMOVRDLZ,
            103 => sparc_insn::SPARC_INS_FMOVRQLZ,
            104 => sparc_insn::SPARC_INS_FMOVRSLZ,
            105 => sparc_insn::SPARC_INS_FMOVRDNZ,
            106 => sparc_insn::SPARC_INS_FMOVRQNZ,
            107 => sparc_insn::SPARC_INS_FMOVRSNZ,
            108 => sparc_insn::SPARC_INS_FMOVRDZ,
            109 => sparc_insn::SPARC_INS_FMOVRQZ,
            110 => sparc_insn::SPARC_INS_FMOVRSZ,
            111 => sparc_insn::SPARC_INS_FMOVS,
            112 => sparc_insn::SPARC_INS_FMUL8SUX16,
            113 => sparc_insn::SPARC_INS_FMUL8ULX16,
            114 => sparc_insn::SPARC_INS_FMUL8X16,
            115 => sparc_insn::SPARC_INS_FMUL8X16AL,
            116 => sparc_insn::SPARC_INS_FMUL8X16AU,
            117 => sparc_insn::SPARC_INS_FMULD,
            118 => sparc_insn::SPARC_INS_FMULD8SUX16,
            119 => sparc_insn::SPARC_INS_FMULD8ULX16,
            120 => sparc_insn::SPARC_INS_FMULQ,
            121 => sparc_insn::SPARC_INS_FMULS,
            122 => sparc_insn::SPARC_INS_FNADDD,
            123 => sparc_insn::SPARC_INS_FNADDS,
            124 => sparc_insn::SPARC_INS_FNAND,
            125 => sparc_insn::SPARC_INS_FNANDS,
            126 => sparc_insn::SPARC_INS_FNEGD,
            127 => sparc_insn::SPARC_INS_FNEGQ,
            128 => sparc_insn::SPARC_INS_FNEGS,
            129 => sparc_insn::SPARC_INS_FNHADDD,
            130 => sparc_insn::SPARC_INS_FNHADDS,
            131 => sparc_insn::SPARC_INS_FNOR,
            132 => sparc_insn::SPARC_INS_FNORS,
            133 => sparc_insn::SPARC_INS_FNOT1,
            134 => sparc_insn::SPARC_INS_FNOT1S,
            135 => sparc_insn::SPARC_INS_FNOT2,
            136 => sparc_insn::SPARC_INS_FNOT2S,
            137 => sparc_insn::SPARC_INS_FONE,
            138 => sparc_insn::SPARC_INS_FONES,
            139 => sparc_insn::SPARC_INS_FOR,
            140 => sparc_insn::SPARC_INS_FORNOT1,
            141 => sparc_insn::SPARC_INS_FORNOT1S,
            142 => sparc_insn::SPARC_INS_FORNOT2,
            143 => sparc_insn::SPARC_INS_FORNOT2S,
            144 => sparc_insn::SPARC_INS_FORS,
            145 => sparc_insn::SPARC_INS_FPACK16,
            146 => sparc_insn::SPARC_INS_FPACK32,
            147 => sparc_insn::SPARC_INS_FPACKFIX,
            148 => sparc_insn::SPARC_INS_FPADD16,
            149 => sparc_insn::SPARC_INS_FPADD16S,
            150 => sparc_insn::SPARC_INS_FPADD32,
            151 => sparc_insn::SPARC_INS_FPADD32S,
            152 => sparc_insn::SPARC_INS_FPADD64,
            153 => sparc_insn::SPARC_INS_FPMERGE,
            154 => sparc_insn::SPARC_INS_FPSUB16,
            155 => sparc_insn::SPARC_INS_FPSUB16S,
            156 => sparc_insn::SPARC_INS_FPSUB32,
            157 => sparc_insn::SPARC_INS_FPSUB32S,
            158 => sparc_insn::SPARC_INS_FQTOD,
            159 => sparc_insn::SPARC_INS_FQTOI,
            160 => sparc_insn::SPARC_INS_FQTOS,
            161 => sparc_insn::SPARC_INS_FQTOX,
            162 => sparc_insn::SPARC_INS_FSLAS16,
            163 => sparc_insn::SPARC_INS_FSLAS32,
            164 => sparc_insn::SPARC_INS_FSLL16,
            165 => sparc_insn::SPARC_INS_FSLL32,
            166 => sparc_insn::SPARC_INS_FSMULD,
            167 => sparc_insn::SPARC_INS_FSQRTD,
            168 => sparc_insn::SPARC_INS_FSQRTQ,
            169 => sparc_insn::SPARC_INS_FSQRTS,
            170 => sparc_insn::SPARC_INS_FSRA16,
            171 => sparc_insn::SPARC_INS_FSRA32,
            172 => sparc_insn::SPARC_INS_FSRC1,
            173 => sparc_insn::SPARC_INS_FSRC1S,
            174 => sparc_insn::SPARC_INS_FSRC2,
            175 => sparc_insn::SPARC_INS_FSRC2S,
            176 => sparc_insn::SPARC_INS_FSRL16,
            177 => sparc_insn::SPARC_INS_FSRL32,
            178 => sparc_insn::SPARC_INS_FSTOD,
            179 => sparc_insn::SPARC_INS_FSTOI,
            180 => sparc_insn::SPARC_INS_FSTOQ,
            181 => sparc_insn::SPARC_INS_FSTOX,
            182 => sparc_insn::SPARC_INS_FSUBD,
            183 => sparc_insn::SPARC_INS_FSUBQ,
            184 => sparc_insn::SPARC_INS_FSUBS,
            185 => sparc_insn::SPARC_INS_FXNOR,
            186 => sparc_insn::SPARC_INS_FXNORS,
            187 => sparc_insn::SPARC_INS_FXOR,
            188 => sparc_insn::SPARC_INS_FXORS,
            189 => sparc_insn::SPARC_INS_FXTOD,
            190 => sparc_insn::SPARC_INS_FXTOQ,
            191 => sparc_insn::SPARC_INS_FXTOS,
            192 => sparc_insn::SPARC_INS_FZERO,
            193 => sparc_insn::SPARC_INS_FZEROS,
            194 => sparc_insn::SPARC_INS_JMPL,
            195 => sparc_insn::SPARC_INS_LDD,
            196 => sparc_insn::SPARC_INS_LD,
            197 => sparc_insn::SPARC_INS_LDQ,
            198 => sparc_insn::SPARC_INS_LDSB,
            199 => sparc_insn::SPARC_INS_LDSH,
            200 => sparc_insn::SPARC_INS_LDSW,
            201 => sparc_insn::SPARC_INS_LDUB,
            202 => sparc_insn::SPARC_INS_LDUH,
            203 => sparc_insn::SPARC_INS_LDX,
            204 => sparc_insn::SPARC_INS_LZCNT,
            205 => sparc_insn::SPARC_INS_MEMBAR,
            206 => sparc_insn::SPARC_INS_MOVDTOX,
            207 => sparc_insn::SPARC_INS_MOV,
            208 => sparc_insn::SPARC_INS_MOVRGEZ,
            209 => sparc_insn::SPARC_INS_MOVRGZ,
            210 => sparc_insn::SPARC_INS_MOVRLEZ,
            211 => sparc_insn::SPARC_INS_MOVRLZ,
            212 => sparc_insn::SPARC_INS_MOVRNZ,
            213 => sparc_insn::SPARC_INS_MOVRZ,
            214 => sparc_insn::SPARC_INS_MOVSTOSW,
            215 => sparc_insn::SPARC_INS_MOVSTOUW,
            216 => sparc_insn::SPARC_INS_MULX,
            217 => sparc_insn::SPARC_INS_NOP,
            218 => sparc_insn::SPARC_INS_ORCC,
            219 => sparc_insn::SPARC_INS_ORNCC,
            220 => sparc_insn::SPARC_INS_ORN,
            221 => sparc_insn::SPARC_INS_OR,
            222 => sparc_insn::SPARC_INS_PDIST,
            223 => sparc_insn::SPARC_INS_PDISTN,
            224 => sparc_insn::SPARC_INS_POPC,
            225 => sparc_insn::SPARC_INS_RD,
            226 => sparc_insn::SPARC_INS_RESTORE,
            227 => sparc_insn::SPARC_INS_RETT,
            228 => sparc_insn::SPARC_INS_SAVE,
            229 => sparc_insn::SPARC_INS_SDIVCC,
            230 => sparc_insn::SPARC_INS_SDIVX,
            231 => sparc_insn::SPARC_INS_SDIV,
            232 => sparc_insn::SPARC_INS_SETHI,
            233 => sparc_insn::SPARC_INS_SHUTDOWN,
            234 => sparc_insn::SPARC_INS_SIAM,
            235 => sparc_insn::SPARC_INS_SLLX,
            236 => sparc_insn::SPARC_INS_SLL,
            237 => sparc_insn::SPARC_INS_SMULCC,
            238 => sparc_insn::SPARC_INS_SMUL,
            239 => sparc_insn::SPARC_INS_SRAX,
            240 => sparc_insn::SPARC_INS_SRA,
            241 => sparc_insn::SPARC_INS_SRLX,
            242 => sparc_insn::SPARC_INS_SRL,
            243 => sparc_insn::SPARC_INS_STBAR,
            244 => sparc_insn::SPARC_INS_STB,
            245 => sparc_insn::SPARC_INS_STD,
            246 => sparc_insn::SPARC_INS_ST,
            247 => sparc_insn::SPARC_INS_STH,
            248 => sparc_insn::SPARC_INS_STQ,
            249 => sparc_insn::SPARC_INS_STX,
            250 => sparc_insn::SPARC_INS_SUBCC,
            251 => sparc_insn::SPARC_INS_SUBX,
            252 => sparc_insn::SPARC_INS_SUBXCC,
            253 => sparc_insn::SPARC_INS_SUB,
            254 => sparc_insn::SPARC_INS_SWAP,
            255 => sparc_insn::SPARC_INS_TADDCCTV,
            256 => sparc_insn::SPARC_INS_TADDCC,
            257 => sparc_insn::SPARC_INS_T,
            258 => sparc_insn::SPARC_INS_TSUBCCTV,
            259 => sparc_insn::SPARC_INS_TSUBCC,
            260 => sparc_insn::SPARC_INS_UDIVCC,
            261 => sparc_insn::SPARC_INS_UDIVX,
            262 => sparc_insn::SPARC_INS_UDIV,
            263 => sparc_insn::SPARC_INS_UMULCC,
            264 => sparc_insn::SPARC_INS_UMULXHI,
            265 => sparc_insn::SPARC_INS_UMUL,
            266 => sparc_insn::SPARC_INS_UNIMP,
            267 => sparc_insn::SPARC_INS_FCMPED,
            268 => sparc_insn::SPARC_INS_FCMPEQ,
            269 => sparc_insn::SPARC_INS_FCMPES,
            270 => sparc_insn::SPARC_INS_WR,
            271 => sparc_insn::SPARC_INS_XMULX,
            272 => sparc_insn::SPARC_INS_XMULXHI,
            273 => sparc_insn::SPARC_INS_XNORCC,
            274 => sparc_insn::SPARC_INS_XNOR,
            275 => sparc_insn::SPARC_INS_XORCC,
            276 => sparc_insn::SPARC_INS_XOR,
            277 => sparc_insn::SPARC_INS_RET,
            278 => sparc_insn::SPARC_INS_RETL,
            279 => sparc_insn::SPARC_INS_ENDING,
            _ => sparc_insn::SPARC_INS_INVALID,
        }
    }
}
impl From<u32> for sysz_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => sysz_insn::SYSZ_INS_INVALID,
            1 => sysz_insn::SYSZ_INS_A,
            2 => sysz_insn::SYSZ_INS_ADB,
            3 => sysz_insn::SYSZ_INS_ADBR,
            4 => sysz_insn::SYSZ_INS_AEB,
            5 => sysz_insn::SYSZ_INS_AEBR,
            6 => sysz_insn::SYSZ_INS_AFI,
            7 => sysz_insn::SYSZ_INS_AG,
            8 => sysz_insn::SYSZ_INS_AGF,
            9 => sysz_insn::SYSZ_INS_AGFI,
            10 => sysz_insn::SYSZ_INS_AGFR,
            11 => sysz_insn::SYSZ_INS_AGHI,
            12 => sysz_insn::SYSZ_INS_AGHIK,
            13 => sysz_insn::SYSZ_INS_AGR,
            14 => sysz_insn::SYSZ_INS_AGRK,
            15 => sysz_insn::SYSZ_INS_AGSI,
            16 => sysz_insn::SYSZ_INS_AH,
            17 => sysz_insn::SYSZ_INS_AHI,
            18 => sysz_insn::SYSZ_INS_AHIK,
            19 => sysz_insn::SYSZ_INS_AHY,
            20 => sysz_insn::SYSZ_INS_AIH,
            21 => sysz_insn::SYSZ_INS_AL,
            22 => sysz_insn::SYSZ_INS_ALC,
            23 => sysz_insn::SYSZ_INS_ALCG,
            24 => sysz_insn::SYSZ_INS_ALCGR,
            25 => sysz_insn::SYSZ_INS_ALCR,
            26 => sysz_insn::SYSZ_INS_ALFI,
            27 => sysz_insn::SYSZ_INS_ALG,
            28 => sysz_insn::SYSZ_INS_ALGF,
            29 => sysz_insn::SYSZ_INS_ALGFI,
            30 => sysz_insn::SYSZ_INS_ALGFR,
            31 => sysz_insn::SYSZ_INS_ALGHSIK,
            32 => sysz_insn::SYSZ_INS_ALGR,
            33 => sysz_insn::SYSZ_INS_ALGRK,
            34 => sysz_insn::SYSZ_INS_ALHSIK,
            35 => sysz_insn::SYSZ_INS_ALR,
            36 => sysz_insn::SYSZ_INS_ALRK,
            37 => sysz_insn::SYSZ_INS_ALY,
            38 => sysz_insn::SYSZ_INS_AR,
            39 => sysz_insn::SYSZ_INS_ARK,
            40 => sysz_insn::SYSZ_INS_ASI,
            41 => sysz_insn::SYSZ_INS_AXBR,
            42 => sysz_insn::SYSZ_INS_AY,
            43 => sysz_insn::SYSZ_INS_BCR,
            44 => sysz_insn::SYSZ_INS_BRC,
            45 => sysz_insn::SYSZ_INS_BRCL,
            46 => sysz_insn::SYSZ_INS_CGIJ,
            47 => sysz_insn::SYSZ_INS_CGRJ,
            48 => sysz_insn::SYSZ_INS_CIJ,
            49 => sysz_insn::SYSZ_INS_CLGIJ,
            50 => sysz_insn::SYSZ_INS_CLGRJ,
            51 => sysz_insn::SYSZ_INS_CLIJ,
            52 => sysz_insn::SYSZ_INS_CLRJ,
            53 => sysz_insn::SYSZ_INS_CRJ,
            54 => sysz_insn::SYSZ_INS_BER,
            55 => sysz_insn::SYSZ_INS_JE,
            56 => sysz_insn::SYSZ_INS_JGE,
            57 => sysz_insn::SYSZ_INS_LOCE,
            58 => sysz_insn::SYSZ_INS_LOCGE,
            59 => sysz_insn::SYSZ_INS_LOCGRE,
            60 => sysz_insn::SYSZ_INS_LOCRE,
            61 => sysz_insn::SYSZ_INS_STOCE,
            62 => sysz_insn::SYSZ_INS_STOCGE,
            63 => sysz_insn::SYSZ_INS_BHR,
            64 => sysz_insn::SYSZ_INS_BHER,
            65 => sysz_insn::SYSZ_INS_JHE,
            66 => sysz_insn::SYSZ_INS_JGHE,
            67 => sysz_insn::SYSZ_INS_LOCHE,
            68 => sysz_insn::SYSZ_INS_LOCGHE,
            69 => sysz_insn::SYSZ_INS_LOCGRHE,
            70 => sysz_insn::SYSZ_INS_LOCRHE,
            71 => sysz_insn::SYSZ_INS_STOCHE,
            72 => sysz_insn::SYSZ_INS_STOCGHE,
            73 => sysz_insn::SYSZ_INS_JH,
            74 => sysz_insn::SYSZ_INS_JGH,
            75 => sysz_insn::SYSZ_INS_LOCH,
            76 => sysz_insn::SYSZ_INS_LOCGH,
            77 => sysz_insn::SYSZ_INS_LOCGRH,
            78 => sysz_insn::SYSZ_INS_LOCRH,
            79 => sysz_insn::SYSZ_INS_STOCH,
            80 => sysz_insn::SYSZ_INS_STOCGH,
            81 => sysz_insn::SYSZ_INS_CGIJNLH,
            82 => sysz_insn::SYSZ_INS_CGRJNLH,
            83 => sysz_insn::SYSZ_INS_CIJNLH,
            84 => sysz_insn::SYSZ_INS_CLGIJNLH,
            85 => sysz_insn::SYSZ_INS_CLGRJNLH,
            86 => sysz_insn::SYSZ_INS_CLIJNLH,
            87 => sysz_insn::SYSZ_INS_CLRJNLH,
            88 => sysz_insn::SYSZ_INS_CRJNLH,
            89 => sysz_insn::SYSZ_INS_CGIJE,
            90 => sysz_insn::SYSZ_INS_CGRJE,
            91 => sysz_insn::SYSZ_INS_CIJE,
            92 => sysz_insn::SYSZ_INS_CLGIJE,
            93 => sysz_insn::SYSZ_INS_CLGRJE,
            94 => sysz_insn::SYSZ_INS_CLIJE,
            95 => sysz_insn::SYSZ_INS_CLRJE,
            96 => sysz_insn::SYSZ_INS_CRJE,
            97 => sysz_insn::SYSZ_INS_CGIJNLE,
            98 => sysz_insn::SYSZ_INS_CGRJNLE,
            99 => sysz_insn::SYSZ_INS_CIJNLE,
            100 => sysz_insn::SYSZ_INS_CLGIJNLE,
            101 => sysz_insn::SYSZ_INS_CLGRJNLE,
            102 => sysz_insn::SYSZ_INS_CLIJNLE,
            103 => sysz_insn::SYSZ_INS_CLRJNLE,
            104 => sysz_insn::SYSZ_INS_CRJNLE,
            105 => sysz_insn::SYSZ_INS_CGIJH,
            106 => sysz_insn::SYSZ_INS_CGRJH,
            107 => sysz_insn::SYSZ_INS_CIJH,
            108 => sysz_insn::SYSZ_INS_CLGIJH,
            109 => sysz_insn::SYSZ_INS_CLGRJH,
            110 => sysz_insn::SYSZ_INS_CLIJH,
            111 => sysz_insn::SYSZ_INS_CLRJH,
            112 => sysz_insn::SYSZ_INS_CRJH,
            113 => sysz_insn::SYSZ_INS_CGIJNL,
            114 => sysz_insn::SYSZ_INS_CGRJNL,
            115 => sysz_insn::SYSZ_INS_CIJNL,
            116 => sysz_insn::SYSZ_INS_CLGIJNL,
            117 => sysz_insn::SYSZ_INS_CLGRJNL,
            118 => sysz_insn::SYSZ_INS_CLIJNL,
            119 => sysz_insn::SYSZ_INS_CLRJNL,
            120 => sysz_insn::SYSZ_INS_CRJNL,
            121 => sysz_insn::SYSZ_INS_CGIJHE,
            122 => sysz_insn::SYSZ_INS_CGRJHE,
            123 => sysz_insn::SYSZ_INS_CIJHE,
            124 => sysz_insn::SYSZ_INS_CLGIJHE,
            125 => sysz_insn::SYSZ_INS_CLGRJHE,
            126 => sysz_insn::SYSZ_INS_CLIJHE,
            127 => sysz_insn::SYSZ_INS_CLRJHE,
            128 => sysz_insn::SYSZ_INS_CRJHE,
            129 => sysz_insn::SYSZ_INS_CGIJNHE,
            130 => sysz_insn::SYSZ_INS_CGRJNHE,
            131 => sysz_insn::SYSZ_INS_CIJNHE,
            132 => sysz_insn::SYSZ_INS_CLGIJNHE,
            133 => sysz_insn::SYSZ_INS_CLGRJNHE,
            134 => sysz_insn::SYSZ_INS_CLIJNHE,
            135 => sysz_insn::SYSZ_INS_CLRJNHE,
            136 => sysz_insn::SYSZ_INS_CRJNHE,
            137 => sysz_insn::SYSZ_INS_CGIJL,
            138 => sysz_insn::SYSZ_INS_CGRJL,
            139 => sysz_insn::SYSZ_INS_CIJL,
            140 => sysz_insn::SYSZ_INS_CLGIJL,
            141 => sysz_insn::SYSZ_INS_CLGRJL,
            142 => sysz_insn::SYSZ_INS_CLIJL,
            143 => sysz_insn::SYSZ_INS_CLRJL,
            144 => sysz_insn::SYSZ_INS_CRJL,
            145 => sysz_insn::SYSZ_INS_CGIJNH,
            146 => sysz_insn::SYSZ_INS_CGRJNH,
            147 => sysz_insn::SYSZ_INS_CIJNH,
            148 => sysz_insn::SYSZ_INS_CLGIJNH,
            149 => sysz_insn::SYSZ_INS_CLGRJNH,
            150 => sysz_insn::SYSZ_INS_CLIJNH,
            151 => sysz_insn::SYSZ_INS_CLRJNH,
            152 => sysz_insn::SYSZ_INS_CRJNH,
            153 => sysz_insn::SYSZ_INS_CGIJLE,
            154 => sysz_insn::SYSZ_INS_CGRJLE,
            155 => sysz_insn::SYSZ_INS_CIJLE,
            156 => sysz_insn::SYSZ_INS_CLGIJLE,
            157 => sysz_insn::SYSZ_INS_CLGRJLE,
            158 => sysz_insn::SYSZ_INS_CLIJLE,
            159 => sysz_insn::SYSZ_INS_CLRJLE,
            160 => sysz_insn::SYSZ_INS_CRJLE,
            161 => sysz_insn::SYSZ_INS_CGIJNE,
            162 => sysz_insn::SYSZ_INS_CGRJNE,
            163 => sysz_insn::SYSZ_INS_CIJNE,
            164 => sysz_insn::SYSZ_INS_CLGIJNE,
            165 => sysz_insn::SYSZ_INS_CLGRJNE,
            166 => sysz_insn::SYSZ_INS_CLIJNE,
            167 => sysz_insn::SYSZ_INS_CLRJNE,
            168 => sysz_insn::SYSZ_INS_CRJNE,
            169 => sysz_insn::SYSZ_INS_CGIJLH,
            170 => sysz_insn::SYSZ_INS_CGRJLH,
            171 => sysz_insn::SYSZ_INS_CIJLH,
            172 => sysz_insn::SYSZ_INS_CLGIJLH,
            173 => sysz_insn::SYSZ_INS_CLGRJLH,
            174 => sysz_insn::SYSZ_INS_CLIJLH,
            175 => sysz_insn::SYSZ_INS_CLRJLH,
            176 => sysz_insn::SYSZ_INS_CRJLH,
            177 => sysz_insn::SYSZ_INS_BLR,
            178 => sysz_insn::SYSZ_INS_BLER,
            179 => sysz_insn::SYSZ_INS_JLE,
            180 => sysz_insn::SYSZ_INS_JGLE,
            181 => sysz_insn::SYSZ_INS_LOCLE,
            182 => sysz_insn::SYSZ_INS_LOCGLE,
            183 => sysz_insn::SYSZ_INS_LOCGRLE,
            184 => sysz_insn::SYSZ_INS_LOCRLE,
            185 => sysz_insn::SYSZ_INS_STOCLE,
            186 => sysz_insn::SYSZ_INS_STOCGLE,
            187 => sysz_insn::SYSZ_INS_BLHR,
            188 => sysz_insn::SYSZ_INS_JLH,
            189 => sysz_insn::SYSZ_INS_JGLH,
            190 => sysz_insn::SYSZ_INS_LOCLH,
            191 => sysz_insn::SYSZ_INS_LOCGLH,
            192 => sysz_insn::SYSZ_INS_LOCGRLH,
            193 => sysz_insn::SYSZ_INS_LOCRLH,
            194 => sysz_insn::SYSZ_INS_STOCLH,
            195 => sysz_insn::SYSZ_INS_STOCGLH,
            196 => sysz_insn::SYSZ_INS_JL,
            197 => sysz_insn::SYSZ_INS_JGL,
            198 => sysz_insn::SYSZ_INS_LOCL,
            199 => sysz_insn::SYSZ_INS_LOCGL,
            200 => sysz_insn::SYSZ_INS_LOCGRL,
            201 => sysz_insn::SYSZ_INS_LOCRL,
            202 => sysz_insn::SYSZ_INS_LOC,
            203 => sysz_insn::SYSZ_INS_LOCG,
            204 => sysz_insn::SYSZ_INS_LOCGR,
            205 => sysz_insn::SYSZ_INS_LOCR,
            206 => sysz_insn::SYSZ_INS_STOCL,
            207 => sysz_insn::SYSZ_INS_STOCGL,
            208 => sysz_insn::SYSZ_INS_BNER,
            209 => sysz_insn::SYSZ_INS_JNE,
            210 => sysz_insn::SYSZ_INS_JGNE,
            211 => sysz_insn::SYSZ_INS_LOCNE,
            212 => sysz_insn::SYSZ_INS_LOCGNE,
            213 => sysz_insn::SYSZ_INS_LOCGRNE,
            214 => sysz_insn::SYSZ_INS_LOCRNE,
            215 => sysz_insn::SYSZ_INS_STOCNE,
            216 => sysz_insn::SYSZ_INS_STOCGNE,
            217 => sysz_insn::SYSZ_INS_BNHR,
            218 => sysz_insn::SYSZ_INS_BNHER,
            219 => sysz_insn::SYSZ_INS_JNHE,
            220 => sysz_insn::SYSZ_INS_JGNHE,
            221 => sysz_insn::SYSZ_INS_LOCNHE,
            222 => sysz_insn::SYSZ_INS_LOCGNHE,
            223 => sysz_insn::SYSZ_INS_LOCGRNHE,
            224 => sysz_insn::SYSZ_INS_LOCRNHE,
            225 => sysz_insn::SYSZ_INS_STOCNHE,
            226 => sysz_insn::SYSZ_INS_STOCGNHE,
            227 => sysz_insn::SYSZ_INS_JNH,
            228 => sysz_insn::SYSZ_INS_JGNH,
            229 => sysz_insn::SYSZ_INS_LOCNH,
            230 => sysz_insn::SYSZ_INS_LOCGNH,
            231 => sysz_insn::SYSZ_INS_LOCGRNH,
            232 => sysz_insn::SYSZ_INS_LOCRNH,
            233 => sysz_insn::SYSZ_INS_STOCNH,
            234 => sysz_insn::SYSZ_INS_STOCGNH,
            235 => sysz_insn::SYSZ_INS_BNLR,
            236 => sysz_insn::SYSZ_INS_BNLER,
            237 => sysz_insn::SYSZ_INS_JNLE,
            238 => sysz_insn::SYSZ_INS_JGNLE,
            239 => sysz_insn::SYSZ_INS_LOCNLE,
            240 => sysz_insn::SYSZ_INS_LOCGNLE,
            241 => sysz_insn::SYSZ_INS_LOCGRNLE,
            242 => sysz_insn::SYSZ_INS_LOCRNLE,
            243 => sysz_insn::SYSZ_INS_STOCNLE,
            244 => sysz_insn::SYSZ_INS_STOCGNLE,
            245 => sysz_insn::SYSZ_INS_BNLHR,
            246 => sysz_insn::SYSZ_INS_JNLH,
            247 => sysz_insn::SYSZ_INS_JGNLH,
            248 => sysz_insn::SYSZ_INS_LOCNLH,
            249 => sysz_insn::SYSZ_INS_LOCGNLH,
            250 => sysz_insn::SYSZ_INS_LOCGRNLH,
            251 => sysz_insn::SYSZ_INS_LOCRNLH,
            252 => sysz_insn::SYSZ_INS_STOCNLH,
            253 => sysz_insn::SYSZ_INS_STOCGNLH,
            254 => sysz_insn::SYSZ_INS_JNL,
            255 => sysz_insn::SYSZ_INS_JGNL,
            256 => sysz_insn::SYSZ_INS_LOCNL,
            257 => sysz_insn::SYSZ_INS_LOCGNL,
            258 => sysz_insn::SYSZ_INS_LOCGRNL,
            259 => sysz_insn::SYSZ_INS_LOCRNL,
            260 => sysz_insn::SYSZ_INS_STOCNL,
            261 => sysz_insn::SYSZ_INS_STOCGNL,
            262 => sysz_insn::SYSZ_INS_BNOR,
            263 => sysz_insn::SYSZ_INS_JNO,
            264 => sysz_insn::SYSZ_INS_JGNO,
            265 => sysz_insn::SYSZ_INS_LOCNO,
            266 => sysz_insn::SYSZ_INS_LOCGNO,
            267 => sysz_insn::SYSZ_INS_LOCGRNO,
            268 => sysz_insn::SYSZ_INS_LOCRNO,
            269 => sysz_insn::SYSZ_INS_STOCNO,
            270 => sysz_insn::SYSZ_INS_STOCGNO,
            271 => sysz_insn::SYSZ_INS_BOR,
            272 => sysz_insn::SYSZ_INS_JO,
            273 => sysz_insn::SYSZ_INS_JGO,
            274 => sysz_insn::SYSZ_INS_LOCO,
            275 => sysz_insn::SYSZ_INS_LOCGO,
            276 => sysz_insn::SYSZ_INS_LOCGRO,
            277 => sysz_insn::SYSZ_INS_LOCRO,
            278 => sysz_insn::SYSZ_INS_STOCO,
            279 => sysz_insn::SYSZ_INS_STOCGO,
            280 => sysz_insn::SYSZ_INS_STOC,
            281 => sysz_insn::SYSZ_INS_STOCG,
            282 => sysz_insn::SYSZ_INS_BASR,
            283 => sysz_insn::SYSZ_INS_BR,
            284 => sysz_insn::SYSZ_INS_BRAS,
            285 => sysz_insn::SYSZ_INS_BRASL,
            286 => sysz_insn::SYSZ_INS_J,
            287 => sysz_insn::SYSZ_INS_JG,
            288 => sysz_insn::SYSZ_INS_BRCT,
            289 => sysz_insn::SYSZ_INS_BRCTG,
            290 => sysz_insn::SYSZ_INS_C,
            291 => sysz_insn::SYSZ_INS_CDB,
            292 => sysz_insn::SYSZ_INS_CDBR,
            293 => sysz_insn::SYSZ_INS_CDFBR,
            294 => sysz_insn::SYSZ_INS_CDGBR,
            295 => sysz_insn::SYSZ_INS_CDLFBR,
            296 => sysz_insn::SYSZ_INS_CDLGBR,
            297 => sysz_insn::SYSZ_INS_CEB,
            298 => sysz_insn::SYSZ_INS_CEBR,
            299 => sysz_insn::SYSZ_INS_CEFBR,
            300 => sysz_insn::SYSZ_INS_CEGBR,
            301 => sysz_insn::SYSZ_INS_CELFBR,
            302 => sysz_insn::SYSZ_INS_CELGBR,
            303 => sysz_insn::SYSZ_INS_CFDBR,
            304 => sysz_insn::SYSZ_INS_CFEBR,
            305 => sysz_insn::SYSZ_INS_CFI,
            306 => sysz_insn::SYSZ_INS_CFXBR,
            307 => sysz_insn::SYSZ_INS_CG,
            308 => sysz_insn::SYSZ_INS_CGDBR,
            309 => sysz_insn::SYSZ_INS_CGEBR,
            310 => sysz_insn::SYSZ_INS_CGF,
            311 => sysz_insn::SYSZ_INS_CGFI,
            312 => sysz_insn::SYSZ_INS_CGFR,
            313 => sysz_insn::SYSZ_INS_CGFRL,
            314 => sysz_insn::SYSZ_INS_CGH,
            315 => sysz_insn::SYSZ_INS_CGHI,
            316 => sysz_insn::SYSZ_INS_CGHRL,
            317 => sysz_insn::SYSZ_INS_CGHSI,
            318 => sysz_insn::SYSZ_INS_CGR,
            319 => sysz_insn::SYSZ_INS_CGRL,
            320 => sysz_insn::SYSZ_INS_CGXBR,
            321 => sysz_insn::SYSZ_INS_CH,
            322 => sysz_insn::SYSZ_INS_CHF,
            323 => sysz_insn::SYSZ_INS_CHHSI,
            324 => sysz_insn::SYSZ_INS_CHI,
            325 => sysz_insn::SYSZ_INS_CHRL,
            326 => sysz_insn::SYSZ_INS_CHSI,
            327 => sysz_insn::SYSZ_INS_CHY,
            328 => sysz_insn::SYSZ_INS_CIH,
            329 => sysz_insn::SYSZ_INS_CL,
            330 => sysz_insn::SYSZ_INS_CLC,
            331 => sysz_insn::SYSZ_INS_CLFDBR,
            332 => sysz_insn::SYSZ_INS_CLFEBR,
            333 => sysz_insn::SYSZ_INS_CLFHSI,
            334 => sysz_insn::SYSZ_INS_CLFI,
            335 => sysz_insn::SYSZ_INS_CLFXBR,
            336 => sysz_insn::SYSZ_INS_CLG,
            337 => sysz_insn::SYSZ_INS_CLGDBR,
            338 => sysz_insn::SYSZ_INS_CLGEBR,
            339 => sysz_insn::SYSZ_INS_CLGF,
            340 => sysz_insn::SYSZ_INS_CLGFI,
            341 => sysz_insn::SYSZ_INS_CLGFR,
            342 => sysz_insn::SYSZ_INS_CLGFRL,
            343 => sysz_insn::SYSZ_INS_CLGHRL,
            344 => sysz_insn::SYSZ_INS_CLGHSI,
            345 => sysz_insn::SYSZ_INS_CLGR,
            346 => sysz_insn::SYSZ_INS_CLGRL,
            347 => sysz_insn::SYSZ_INS_CLGXBR,
            348 => sysz_insn::SYSZ_INS_CLHF,
            349 => sysz_insn::SYSZ_INS_CLHHSI,
            350 => sysz_insn::SYSZ_INS_CLHRL,
            351 => sysz_insn::SYSZ_INS_CLI,
            352 => sysz_insn::SYSZ_INS_CLIH,
            353 => sysz_insn::SYSZ_INS_CLIY,
            354 => sysz_insn::SYSZ_INS_CLR,
            355 => sysz_insn::SYSZ_INS_CLRL,
            356 => sysz_insn::SYSZ_INS_CLST,
            357 => sysz_insn::SYSZ_INS_CLY,
            358 => sysz_insn::SYSZ_INS_CPSDR,
            359 => sysz_insn::SYSZ_INS_CR,
            360 => sysz_insn::SYSZ_INS_CRL,
            361 => sysz_insn::SYSZ_INS_CS,
            362 => sysz_insn::SYSZ_INS_CSG,
            363 => sysz_insn::SYSZ_INS_CSY,
            364 => sysz_insn::SYSZ_INS_CXBR,
            365 => sysz_insn::SYSZ_INS_CXFBR,
            366 => sysz_insn::SYSZ_INS_CXGBR,
            367 => sysz_insn::SYSZ_INS_CXLFBR,
            368 => sysz_insn::SYSZ_INS_CXLGBR,
            369 => sysz_insn::SYSZ_INS_CY,
            370 => sysz_insn::SYSZ_INS_DDB,
            371 => sysz_insn::SYSZ_INS_DDBR,
            372 => sysz_insn::SYSZ_INS_DEB,
            373 => sysz_insn::SYSZ_INS_DEBR,
            374 => sysz_insn::SYSZ_INS_DL,
            375 => sysz_insn::SYSZ_INS_DLG,
            376 => sysz_insn::SYSZ_INS_DLGR,
            377 => sysz_insn::SYSZ_INS_DLR,
            378 => sysz_insn::SYSZ_INS_DSG,
            379 => sysz_insn::SYSZ_INS_DSGF,
            380 => sysz_insn::SYSZ_INS_DSGFR,
            381 => sysz_insn::SYSZ_INS_DSGR,
            382 => sysz_insn::SYSZ_INS_DXBR,
            383 => sysz_insn::SYSZ_INS_EAR,
            384 => sysz_insn::SYSZ_INS_FIDBR,
            385 => sysz_insn::SYSZ_INS_FIDBRA,
            386 => sysz_insn::SYSZ_INS_FIEBR,
            387 => sysz_insn::SYSZ_INS_FIEBRA,
            388 => sysz_insn::SYSZ_INS_FIXBR,
            389 => sysz_insn::SYSZ_INS_FIXBRA,
            390 => sysz_insn::SYSZ_INS_FLOGR,
            391 => sysz_insn::SYSZ_INS_IC,
            392 => sysz_insn::SYSZ_INS_ICY,
            393 => sysz_insn::SYSZ_INS_IIHF,
            394 => sysz_insn::SYSZ_INS_IIHH,
            395 => sysz_insn::SYSZ_INS_IIHL,
            396 => sysz_insn::SYSZ_INS_IILF,
            397 => sysz_insn::SYSZ_INS_IILH,
            398 => sysz_insn::SYSZ_INS_IILL,
            399 => sysz_insn::SYSZ_INS_IPM,
            400 => sysz_insn::SYSZ_INS_L,
            401 => sysz_insn::SYSZ_INS_LA,
            402 => sysz_insn::SYSZ_INS_LAA,
            403 => sysz_insn::SYSZ_INS_LAAG,
            404 => sysz_insn::SYSZ_INS_LAAL,
            405 => sysz_insn::SYSZ_INS_LAALG,
            406 => sysz_insn::SYSZ_INS_LAN,
            407 => sysz_insn::SYSZ_INS_LANG,
            408 => sysz_insn::SYSZ_INS_LAO,
            409 => sysz_insn::SYSZ_INS_LAOG,
            410 => sysz_insn::SYSZ_INS_LARL,
            411 => sysz_insn::SYSZ_INS_LAX,
            412 => sysz_insn::SYSZ_INS_LAXG,
            413 => sysz_insn::SYSZ_INS_LAY,
            414 => sysz_insn::SYSZ_INS_LB,
            415 => sysz_insn::SYSZ_INS_LBH,
            416 => sysz_insn::SYSZ_INS_LBR,
            417 => sysz_insn::SYSZ_INS_LCDBR,
            418 => sysz_insn::SYSZ_INS_LCEBR,
            419 => sysz_insn::SYSZ_INS_LCGFR,
            420 => sysz_insn::SYSZ_INS_LCGR,
            421 => sysz_insn::SYSZ_INS_LCR,
            422 => sysz_insn::SYSZ_INS_LCXBR,
            423 => sysz_insn::SYSZ_INS_LD,
            424 => sysz_insn::SYSZ_INS_LDEB,
            425 => sysz_insn::SYSZ_INS_LDEBR,
            426 => sysz_insn::SYSZ_INS_LDGR,
            427 => sysz_insn::SYSZ_INS_LDR,
            428 => sysz_insn::SYSZ_INS_LDXBR,
            429 => sysz_insn::SYSZ_INS_LDXBRA,
            430 => sysz_insn::SYSZ_INS_LDY,
            431 => sysz_insn::SYSZ_INS_LE,
            432 => sysz_insn::SYSZ_INS_LEDBR,
            433 => sysz_insn::SYSZ_INS_LEDBRA,
            434 => sysz_insn::SYSZ_INS_LER,
            435 => sysz_insn::SYSZ_INS_LEXBR,
            436 => sysz_insn::SYSZ_INS_LEXBRA,
            437 => sysz_insn::SYSZ_INS_LEY,
            438 => sysz_insn::SYSZ_INS_LFH,
            439 => sysz_insn::SYSZ_INS_LG,
            440 => sysz_insn::SYSZ_INS_LGB,
            441 => sysz_insn::SYSZ_INS_LGBR,
            442 => sysz_insn::SYSZ_INS_LGDR,
            443 => sysz_insn::SYSZ_INS_LGF,
            444 => sysz_insn::SYSZ_INS_LGFI,
            445 => sysz_insn::SYSZ_INS_LGFR,
            446 => sysz_insn::SYSZ_INS_LGFRL,
            447 => sysz_insn::SYSZ_INS_LGH,
            448 => sysz_insn::SYSZ_INS_LGHI,
            449 => sysz_insn::SYSZ_INS_LGHR,
            450 => sysz_insn::SYSZ_INS_LGHRL,
            451 => sysz_insn::SYSZ_INS_LGR,
            452 => sysz_insn::SYSZ_INS_LGRL,
            453 => sysz_insn::SYSZ_INS_LH,
            454 => sysz_insn::SYSZ_INS_LHH,
            455 => sysz_insn::SYSZ_INS_LHI,
            456 => sysz_insn::SYSZ_INS_LHR,
            457 => sysz_insn::SYSZ_INS_LHRL,
            458 => sysz_insn::SYSZ_INS_LHY,
            459 => sysz_insn::SYSZ_INS_LLC,
            460 => sysz_insn::SYSZ_INS_LLCH,
            461 => sysz_insn::SYSZ_INS_LLCR,
            462 => sysz_insn::SYSZ_INS_LLGC,
            463 => sysz_insn::SYSZ_INS_LLGCR,
            464 => sysz_insn::SYSZ_INS_LLGF,
            465 => sysz_insn::SYSZ_INS_LLGFR,
            466 => sysz_insn::SYSZ_INS_LLGFRL,
            467 => sysz_insn::SYSZ_INS_LLGH,
            468 => sysz_insn::SYSZ_INS_LLGHR,
            469 => sysz_insn::SYSZ_INS_LLGHRL,
            470 => sysz_insn::SYSZ_INS_LLH,
            471 => sysz_insn::SYSZ_INS_LLHH,
            472 => sysz_insn::SYSZ_INS_LLHR,
            473 => sysz_insn::SYSZ_INS_LLHRL,
            474 => sysz_insn::SYSZ_INS_LLIHF,
            475 => sysz_insn::SYSZ_INS_LLIHH,
            476 => sysz_insn::SYSZ_INS_LLIHL,
            477 => sysz_insn::SYSZ_INS_LLILF,
            478 => sysz_insn::SYSZ_INS_LLILH,
            479 => sysz_insn::SYSZ_INS_LLILL,
            480 => sysz_insn::SYSZ_INS_LMG,
            481 => sysz_insn::SYSZ_INS_LNDBR,
            482 => sysz_insn::SYSZ_INS_LNEBR,
            483 => sysz_insn::SYSZ_INS_LNGFR,
            484 => sysz_insn::SYSZ_INS_LNGR,
            485 => sysz_insn::SYSZ_INS_LNR,
            486 => sysz_insn::SYSZ_INS_LNXBR,
            487 => sysz_insn::SYSZ_INS_LPDBR,
            488 => sysz_insn::SYSZ_INS_LPEBR,
            489 => sysz_insn::SYSZ_INS_LPGFR,
            490 => sysz_insn::SYSZ_INS_LPGR,
            491 => sysz_insn::SYSZ_INS_LPR,
            492 => sysz_insn::SYSZ_INS_LPXBR,
            493 => sysz_insn::SYSZ_INS_LR,
            494 => sysz_insn::SYSZ_INS_LRL,
            495 => sysz_insn::SYSZ_INS_LRV,
            496 => sysz_insn::SYSZ_INS_LRVG,
            497 => sysz_insn::SYSZ_INS_LRVGR,
            498 => sysz_insn::SYSZ_INS_LRVR,
            499 => sysz_insn::SYSZ_INS_LT,
            500 => sysz_insn::SYSZ_INS_LTDBR,
            501 => sysz_insn::SYSZ_INS_LTEBR,
            502 => sysz_insn::SYSZ_INS_LTG,
            503 => sysz_insn::SYSZ_INS_LTGF,
            504 => sysz_insn::SYSZ_INS_LTGFR,
            505 => sysz_insn::SYSZ_INS_LTGR,
            506 => sysz_insn::SYSZ_INS_LTR,
            507 => sysz_insn::SYSZ_INS_LTXBR,
            508 => sysz_insn::SYSZ_INS_LXDB,
            509 => sysz_insn::SYSZ_INS_LXDBR,
            510 => sysz_insn::SYSZ_INS_LXEB,
            511 => sysz_insn::SYSZ_INS_LXEBR,
            512 => sysz_insn::SYSZ_INS_LXR,
            513 => sysz_insn::SYSZ_INS_LY,
            514 => sysz_insn::SYSZ_INS_LZDR,
            515 => sysz_insn::SYSZ_INS_LZER,
            516 => sysz_insn::SYSZ_INS_LZXR,
            517 => sysz_insn::SYSZ_INS_MADB,
            518 => sysz_insn::SYSZ_INS_MADBR,
            519 => sysz_insn::SYSZ_INS_MAEB,
            520 => sysz_insn::SYSZ_INS_MAEBR,
            521 => sysz_insn::SYSZ_INS_MDB,
            522 => sysz_insn::SYSZ_INS_MDBR,
            523 => sysz_insn::SYSZ_INS_MDEB,
            524 => sysz_insn::SYSZ_INS_MDEBR,
            525 => sysz_insn::SYSZ_INS_MEEB,
            526 => sysz_insn::SYSZ_INS_MEEBR,
            527 => sysz_insn::SYSZ_INS_MGHI,
            528 => sysz_insn::SYSZ_INS_MH,
            529 => sysz_insn::SYSZ_INS_MHI,
            530 => sysz_insn::SYSZ_INS_MHY,
            531 => sysz_insn::SYSZ_INS_MLG,
            532 => sysz_insn::SYSZ_INS_MLGR,
            533 => sysz_insn::SYSZ_INS_MS,
            534 => sysz_insn::SYSZ_INS_MSDB,
            535 => sysz_insn::SYSZ_INS_MSDBR,
            536 => sysz_insn::SYSZ_INS_MSEB,
            537 => sysz_insn::SYSZ_INS_MSEBR,
            538 => sysz_insn::SYSZ_INS_MSFI,
            539 => sysz_insn::SYSZ_INS_MSG,
            540 => sysz_insn::SYSZ_INS_MSGF,
            541 => sysz_insn::SYSZ_INS_MSGFI,
            542 => sysz_insn::SYSZ_INS_MSGFR,
            543 => sysz_insn::SYSZ_INS_MSGR,
            544 => sysz_insn::SYSZ_INS_MSR,
            545 => sysz_insn::SYSZ_INS_MSY,
            546 => sysz_insn::SYSZ_INS_MVC,
            547 => sysz_insn::SYSZ_INS_MVGHI,
            548 => sysz_insn::SYSZ_INS_MVHHI,
            549 => sysz_insn::SYSZ_INS_MVHI,
            550 => sysz_insn::SYSZ_INS_MVI,
            551 => sysz_insn::SYSZ_INS_MVIY,
            552 => sysz_insn::SYSZ_INS_MVST,
            553 => sysz_insn::SYSZ_INS_MXBR,
            554 => sysz_insn::SYSZ_INS_MXDB,
            555 => sysz_insn::SYSZ_INS_MXDBR,
            556 => sysz_insn::SYSZ_INS_N,
            557 => sysz_insn::SYSZ_INS_NC,
            558 => sysz_insn::SYSZ_INS_NG,
            559 => sysz_insn::SYSZ_INS_NGR,
            560 => sysz_insn::SYSZ_INS_NGRK,
            561 => sysz_insn::SYSZ_INS_NI,
            562 => sysz_insn::SYSZ_INS_NIHF,
            563 => sysz_insn::SYSZ_INS_NIHH,
            564 => sysz_insn::SYSZ_INS_NIHL,
            565 => sysz_insn::SYSZ_INS_NILF,
            566 => sysz_insn::SYSZ_INS_NILH,
            567 => sysz_insn::SYSZ_INS_NILL,
            568 => sysz_insn::SYSZ_INS_NIY,
            569 => sysz_insn::SYSZ_INS_NR,
            570 => sysz_insn::SYSZ_INS_NRK,
            571 => sysz_insn::SYSZ_INS_NY,
            572 => sysz_insn::SYSZ_INS_O,
            573 => sysz_insn::SYSZ_INS_OC,
            574 => sysz_insn::SYSZ_INS_OG,
            575 => sysz_insn::SYSZ_INS_OGR,
            576 => sysz_insn::SYSZ_INS_OGRK,
            577 => sysz_insn::SYSZ_INS_OI,
            578 => sysz_insn::SYSZ_INS_OIHF,
            579 => sysz_insn::SYSZ_INS_OIHH,
            580 => sysz_insn::SYSZ_INS_OIHL,
            581 => sysz_insn::SYSZ_INS_OILF,
            582 => sysz_insn::SYSZ_INS_OILH,
            583 => sysz_insn::SYSZ_INS_OILL,
            584 => sysz_insn::SYSZ_INS_OIY,
            585 => sysz_insn::SYSZ_INS_OR,
            586 => sysz_insn::SYSZ_INS_ORK,
            587 => sysz_insn::SYSZ_INS_OY,
            588 => sysz_insn::SYSZ_INS_PFD,
            589 => sysz_insn::SYSZ_INS_PFDRL,
            590 => sysz_insn::SYSZ_INS_RISBG,
            591 => sysz_insn::SYSZ_INS_RISBHG,
            592 => sysz_insn::SYSZ_INS_RISBLG,
            593 => sysz_insn::SYSZ_INS_RLL,
            594 => sysz_insn::SYSZ_INS_RLLG,
            595 => sysz_insn::SYSZ_INS_RNSBG,
            596 => sysz_insn::SYSZ_INS_ROSBG,
            597 => sysz_insn::SYSZ_INS_RXSBG,
            598 => sysz_insn::SYSZ_INS_S,
            599 => sysz_insn::SYSZ_INS_SDB,
            600 => sysz_insn::SYSZ_INS_SDBR,
            601 => sysz_insn::SYSZ_INS_SEB,
            602 => sysz_insn::SYSZ_INS_SEBR,
            603 => sysz_insn::SYSZ_INS_SG,
            604 => sysz_insn::SYSZ_INS_SGF,
            605 => sysz_insn::SYSZ_INS_SGFR,
            606 => sysz_insn::SYSZ_INS_SGR,
            607 => sysz_insn::SYSZ_INS_SGRK,
            608 => sysz_insn::SYSZ_INS_SH,
            609 => sysz_insn::SYSZ_INS_SHY,
            610 => sysz_insn::SYSZ_INS_SL,
            611 => sysz_insn::SYSZ_INS_SLB,
            612 => sysz_insn::SYSZ_INS_SLBG,
            613 => sysz_insn::SYSZ_INS_SLBR,
            614 => sysz_insn::SYSZ_INS_SLFI,
            615 => sysz_insn::SYSZ_INS_SLG,
            616 => sysz_insn::SYSZ_INS_SLBGR,
            617 => sysz_insn::SYSZ_INS_SLGF,
            618 => sysz_insn::SYSZ_INS_SLGFI,
            619 => sysz_insn::SYSZ_INS_SLGFR,
            620 => sysz_insn::SYSZ_INS_SLGR,
            621 => sysz_insn::SYSZ_INS_SLGRK,
            622 => sysz_insn::SYSZ_INS_SLL,
            623 => sysz_insn::SYSZ_INS_SLLG,
            624 => sysz_insn::SYSZ_INS_SLLK,
            625 => sysz_insn::SYSZ_INS_SLR,
            626 => sysz_insn::SYSZ_INS_SLRK,
            627 => sysz_insn::SYSZ_INS_SLY,
            628 => sysz_insn::SYSZ_INS_SQDB,
            629 => sysz_insn::SYSZ_INS_SQDBR,
            630 => sysz_insn::SYSZ_INS_SQEB,
            631 => sysz_insn::SYSZ_INS_SQEBR,
            632 => sysz_insn::SYSZ_INS_SQXBR,
            633 => sysz_insn::SYSZ_INS_SR,
            634 => sysz_insn::SYSZ_INS_SRA,
            635 => sysz_insn::SYSZ_INS_SRAG,
            636 => sysz_insn::SYSZ_INS_SRAK,
            637 => sysz_insn::SYSZ_INS_SRK,
            638 => sysz_insn::SYSZ_INS_SRL,
            639 => sysz_insn::SYSZ_INS_SRLG,
            640 => sysz_insn::SYSZ_INS_SRLK,
            641 => sysz_insn::SYSZ_INS_SRST,
            642 => sysz_insn::SYSZ_INS_ST,
            643 => sysz_insn::SYSZ_INS_STC,
            644 => sysz_insn::SYSZ_INS_STCH,
            645 => sysz_insn::SYSZ_INS_STCY,
            646 => sysz_insn::SYSZ_INS_STD,
            647 => sysz_insn::SYSZ_INS_STDY,
            648 => sysz_insn::SYSZ_INS_STE,
            649 => sysz_insn::SYSZ_INS_STEY,
            650 => sysz_insn::SYSZ_INS_STFH,
            651 => sysz_insn::SYSZ_INS_STG,
            652 => sysz_insn::SYSZ_INS_STGRL,
            653 => sysz_insn::SYSZ_INS_STH,
            654 => sysz_insn::SYSZ_INS_STHH,
            655 => sysz_insn::SYSZ_INS_STHRL,
            656 => sysz_insn::SYSZ_INS_STHY,
            657 => sysz_insn::SYSZ_INS_STMG,
            658 => sysz_insn::SYSZ_INS_STRL,
            659 => sysz_insn::SYSZ_INS_STRV,
            660 => sysz_insn::SYSZ_INS_STRVG,
            661 => sysz_insn::SYSZ_INS_STY,
            662 => sysz_insn::SYSZ_INS_SXBR,
            663 => sysz_insn::SYSZ_INS_SY,
            664 => sysz_insn::SYSZ_INS_TM,
            665 => sysz_insn::SYSZ_INS_TMHH,
            666 => sysz_insn::SYSZ_INS_TMHL,
            667 => sysz_insn::SYSZ_INS_TMLH,
            668 => sysz_insn::SYSZ_INS_TMLL,
            669 => sysz_insn::SYSZ_INS_TMY,
            670 => sysz_insn::SYSZ_INS_X,
            671 => sysz_insn::SYSZ_INS_XC,
            672 => sysz_insn::SYSZ_INS_XG,
            673 => sysz_insn::SYSZ_INS_XGR,
            674 => sysz_insn::SYSZ_INS_XGRK,
            675 => sysz_insn::SYSZ_INS_XI,
            676 => sysz_insn::SYSZ_INS_XIHF,
            677 => sysz_insn::SYSZ_INS_XILF,
            678 => sysz_insn::SYSZ_INS_XIY,
            679 => sysz_insn::SYSZ_INS_XR,
            680 => sysz_insn::SYSZ_INS_XRK,
            681 => sysz_insn::SYSZ_INS_XY,
            682 => sysz_insn::SYSZ_INS_AD,
            683 => sysz_insn::SYSZ_INS_ADR,
            684 => sysz_insn::SYSZ_INS_ADTR,
            685 => sysz_insn::SYSZ_INS_ADTRA,
            686 => sysz_insn::SYSZ_INS_AE,
            687 => sysz_insn::SYSZ_INS_AER,
            688 => sysz_insn::SYSZ_INS_AGH,
            689 => sysz_insn::SYSZ_INS_AHHHR,
            690 => sysz_insn::SYSZ_INS_AHHLR,
            691 => sysz_insn::SYSZ_INS_ALGSI,
            692 => sysz_insn::SYSZ_INS_ALHHHR,
            693 => sysz_insn::SYSZ_INS_ALHHLR,
            694 => sysz_insn::SYSZ_INS_ALSI,
            695 => sysz_insn::SYSZ_INS_ALSIH,
            696 => sysz_insn::SYSZ_INS_ALSIHN,
            697 => sysz_insn::SYSZ_INS_AP,
            698 => sysz_insn::SYSZ_INS_AU,
            699 => sysz_insn::SYSZ_INS_AUR,
            700 => sysz_insn::SYSZ_INS_AW,
            701 => sysz_insn::SYSZ_INS_AWR,
            702 => sysz_insn::SYSZ_INS_AXR,
            703 => sysz_insn::SYSZ_INS_AXTR,
            704 => sysz_insn::SYSZ_INS_AXTRA,
            705 => sysz_insn::SYSZ_INS_B,
            706 => sysz_insn::SYSZ_INS_BAKR,
            707 => sysz_insn::SYSZ_INS_BAL,
            708 => sysz_insn::SYSZ_INS_BALR,
            709 => sysz_insn::SYSZ_INS_BAS,
            710 => sysz_insn::SYSZ_INS_BASSM,
            711 => sysz_insn::SYSZ_INS_BC,
            712 => sysz_insn::SYSZ_INS_BCT,
            713 => sysz_insn::SYSZ_INS_BCTG,
            714 => sysz_insn::SYSZ_INS_BCTGR,
            715 => sysz_insn::SYSZ_INS_BCTR,
            716 => sysz_insn::SYSZ_INS_BE,
            717 => sysz_insn::SYSZ_INS_BH,
            718 => sysz_insn::SYSZ_INS_BHE,
            719 => sysz_insn::SYSZ_INS_BI,
            720 => sysz_insn::SYSZ_INS_BIC,
            721 => sysz_insn::SYSZ_INS_BIE,
            722 => sysz_insn::SYSZ_INS_BIH,
            723 => sysz_insn::SYSZ_INS_BIHE,
            724 => sysz_insn::SYSZ_INS_BIL,
            725 => sysz_insn::SYSZ_INS_BILE,
            726 => sysz_insn::SYSZ_INS_BILH,
            727 => sysz_insn::SYSZ_INS_BIM,
            728 => sysz_insn::SYSZ_INS_BINE,
            729 => sysz_insn::SYSZ_INS_BINH,
            730 => sysz_insn::SYSZ_INS_BINHE,
            731 => sysz_insn::SYSZ_INS_BINL,
            732 => sysz_insn::SYSZ_INS_BINLE,
            733 => sysz_insn::SYSZ_INS_BINLH,
            734 => sysz_insn::SYSZ_INS_BINM,
            735 => sysz_insn::SYSZ_INS_BINO,
            736 => sysz_insn::SYSZ_INS_BINP,
            737 => sysz_insn::SYSZ_INS_BINZ,
            738 => sysz_insn::SYSZ_INS_BIO,
            739 => sysz_insn::SYSZ_INS_BIP,
            740 => sysz_insn::SYSZ_INS_BIZ,
            741 => sysz_insn::SYSZ_INS_BL,
            742 => sysz_insn::SYSZ_INS_BLE,
            743 => sysz_insn::SYSZ_INS_BLH,
            744 => sysz_insn::SYSZ_INS_BM,
            745 => sysz_insn::SYSZ_INS_BMR,
            746 => sysz_insn::SYSZ_INS_BNE,
            747 => sysz_insn::SYSZ_INS_BNH,
            748 => sysz_insn::SYSZ_INS_BNHE,
            749 => sysz_insn::SYSZ_INS_BNL,
            750 => sysz_insn::SYSZ_INS_BNLE,
            751 => sysz_insn::SYSZ_INS_BNLH,
            752 => sysz_insn::SYSZ_INS_BNM,
            753 => sysz_insn::SYSZ_INS_BNMR,
            754 => sysz_insn::SYSZ_INS_BNO,
            755 => sysz_insn::SYSZ_INS_BNP,
            756 => sysz_insn::SYSZ_INS_BNPR,
            757 => sysz_insn::SYSZ_INS_BNZ,
            758 => sysz_insn::SYSZ_INS_BNZR,
            759 => sysz_insn::SYSZ_INS_BO,
            760 => sysz_insn::SYSZ_INS_BP,
            761 => sysz_insn::SYSZ_INS_BPP,
            762 => sysz_insn::SYSZ_INS_BPR,
            763 => sysz_insn::SYSZ_INS_BPRP,
            764 => sysz_insn::SYSZ_INS_BRCTH,
            765 => sysz_insn::SYSZ_INS_BRXH,
            766 => sysz_insn::SYSZ_INS_BRXHG,
            767 => sysz_insn::SYSZ_INS_BRXLE,
            768 => sysz_insn::SYSZ_INS_BRXLG,
            769 => sysz_insn::SYSZ_INS_BSA,
            770 => sysz_insn::SYSZ_INS_BSG,
            771 => sysz_insn::SYSZ_INS_BSM,
            772 => sysz_insn::SYSZ_INS_BXH,
            773 => sysz_insn::SYSZ_INS_BXHG,
            774 => sysz_insn::SYSZ_INS_BXLE,
            775 => sysz_insn::SYSZ_INS_BXLEG,
            776 => sysz_insn::SYSZ_INS_BZ,
            777 => sysz_insn::SYSZ_INS_BZR,
            778 => sysz_insn::SYSZ_INS_CD,
            779 => sysz_insn::SYSZ_INS_CDFBRA,
            780 => sysz_insn::SYSZ_INS_CDFR,
            781 => sysz_insn::SYSZ_INS_CDFTR,
            782 => sysz_insn::SYSZ_INS_CDGBRA,
            783 => sysz_insn::SYSZ_INS_CDGR,
            784 => sysz_insn::SYSZ_INS_CDGTR,
            785 => sysz_insn::SYSZ_INS_CDGTRA,
            786 => sysz_insn::SYSZ_INS_CDLFTR,
            787 => sysz_insn::SYSZ_INS_CDLGTR,
            788 => sysz_insn::SYSZ_INS_CDPT,
            789 => sysz_insn::SYSZ_INS_CDR,
            790 => sysz_insn::SYSZ_INS_CDS,
            791 => sysz_insn::SYSZ_INS_CDSG,
            792 => sysz_insn::SYSZ_INS_CDSTR,
            793 => sysz_insn::SYSZ_INS_CDSY,
            794 => sysz_insn::SYSZ_INS_CDTR,
            795 => sysz_insn::SYSZ_INS_CDUTR,
            796 => sysz_insn::SYSZ_INS_CDZT,
            797 => sysz_insn::SYSZ_INS_CE,
            798 => sysz_insn::SYSZ_INS_CEDTR,
            799 => sysz_insn::SYSZ_INS_CEFBRA,
            800 => sysz_insn::SYSZ_INS_CEFR,
            801 => sysz_insn::SYSZ_INS_CEGBRA,
            802 => sysz_insn::SYSZ_INS_CEGR,
            803 => sysz_insn::SYSZ_INS_CER,
            804 => sysz_insn::SYSZ_INS_CEXTR,
            805 => sysz_insn::SYSZ_INS_CFC,
            806 => sysz_insn::SYSZ_INS_CFDBRA,
            807 => sysz_insn::SYSZ_INS_CFDR,
            808 => sysz_insn::SYSZ_INS_CFDTR,
            809 => sysz_insn::SYSZ_INS_CFEBRA,
            810 => sysz_insn::SYSZ_INS_CFER,
            811 => sysz_insn::SYSZ_INS_CFXBRA,
            812 => sysz_insn::SYSZ_INS_CFXR,
            813 => sysz_insn::SYSZ_INS_CFXTR,
            814 => sysz_insn::SYSZ_INS_CGDBRA,
            815 => sysz_insn::SYSZ_INS_CGDR,
            816 => sysz_insn::SYSZ_INS_CGDTR,
            817 => sysz_insn::SYSZ_INS_CGDTRA,
            818 => sysz_insn::SYSZ_INS_CGEBRA,
            819 => sysz_insn::SYSZ_INS_CGER,
            820 => sysz_insn::SYSZ_INS_CGIB,
            821 => sysz_insn::SYSZ_INS_CGIBE,
            822 => sysz_insn::SYSZ_INS_CGIBH,
            823 => sysz_insn::SYSZ_INS_CGIBHE,
            824 => sysz_insn::SYSZ_INS_CGIBL,
            825 => sysz_insn::SYSZ_INS_CGIBLE,
            826 => sysz_insn::SYSZ_INS_CGIBLH,
            827 => sysz_insn::SYSZ_INS_CGIBNE,
            828 => sysz_insn::SYSZ_INS_CGIBNH,
            829 => sysz_insn::SYSZ_INS_CGIBNHE,
            830 => sysz_insn::SYSZ_INS_CGIBNL,
            831 => sysz_insn::SYSZ_INS_CGIBNLE,
            832 => sysz_insn::SYSZ_INS_CGIBNLH,
            833 => sysz_insn::SYSZ_INS_CGIT,
            834 => sysz_insn::SYSZ_INS_CGITE,
            835 => sysz_insn::SYSZ_INS_CGITH,
            836 => sysz_insn::SYSZ_INS_CGITHE,
            837 => sysz_insn::SYSZ_INS_CGITL,
            838 => sysz_insn::SYSZ_INS_CGITLE,
            839 => sysz_insn::SYSZ_INS_CGITLH,
            840 => sysz_insn::SYSZ_INS_CGITNE,
            841 => sysz_insn::SYSZ_INS_CGITNH,
            842 => sysz_insn::SYSZ_INS_CGITNHE,
            843 => sysz_insn::SYSZ_INS_CGITNL,
            844 => sysz_insn::SYSZ_INS_CGITNLE,
            845 => sysz_insn::SYSZ_INS_CGITNLH,
            846 => sysz_insn::SYSZ_INS_CGRB,
            847 => sysz_insn::SYSZ_INS_CGRBE,
            848 => sysz_insn::SYSZ_INS_CGRBH,
            849 => sysz_insn::SYSZ_INS_CGRBHE,
            850 => sysz_insn::SYSZ_INS_CGRBL,
            851 => sysz_insn::SYSZ_INS_CGRBLE,
            852 => sysz_insn::SYSZ_INS_CGRBLH,
            853 => sysz_insn::SYSZ_INS_CGRBNE,
            854 => sysz_insn::SYSZ_INS_CGRBNH,
            855 => sysz_insn::SYSZ_INS_CGRBNHE,
            856 => sysz_insn::SYSZ_INS_CGRBNL,
            857 => sysz_insn::SYSZ_INS_CGRBNLE,
            858 => sysz_insn::SYSZ_INS_CGRBNLH,
            859 => sysz_insn::SYSZ_INS_CGRT,
            860 => sysz_insn::SYSZ_INS_CGRTE,
            861 => sysz_insn::SYSZ_INS_CGRTH,
            862 => sysz_insn::SYSZ_INS_CGRTHE,
            863 => sysz_insn::SYSZ_INS_CGRTL,
            864 => sysz_insn::SYSZ_INS_CGRTLE,
            865 => sysz_insn::SYSZ_INS_CGRTLH,
            866 => sysz_insn::SYSZ_INS_CGRTNE,
            867 => sysz_insn::SYSZ_INS_CGRTNH,
            868 => sysz_insn::SYSZ_INS_CGRTNHE,
            869 => sysz_insn::SYSZ_INS_CGRTNL,
            870 => sysz_insn::SYSZ_INS_CGRTNLE,
            871 => sysz_insn::SYSZ_INS_CGRTNLH,
            872 => sysz_insn::SYSZ_INS_CGXBRA,
            873 => sysz_insn::SYSZ_INS_CGXR,
            874 => sysz_insn::SYSZ_INS_CGXTR,
            875 => sysz_insn::SYSZ_INS_CGXTRA,
            876 => sysz_insn::SYSZ_INS_CHHR,
            877 => sysz_insn::SYSZ_INS_CHLR,
            878 => sysz_insn::SYSZ_INS_CIB,
            879 => sysz_insn::SYSZ_INS_CIBE,
            880 => sysz_insn::SYSZ_INS_CIBH,
            881 => sysz_insn::SYSZ_INS_CIBHE,
            882 => sysz_insn::SYSZ_INS_CIBL,
            883 => sysz_insn::SYSZ_INS_CIBLE,
            884 => sysz_insn::SYSZ_INS_CIBLH,
            885 => sysz_insn::SYSZ_INS_CIBNE,
            886 => sysz_insn::SYSZ_INS_CIBNH,
            887 => sysz_insn::SYSZ_INS_CIBNHE,
            888 => sysz_insn::SYSZ_INS_CIBNL,
            889 => sysz_insn::SYSZ_INS_CIBNLE,
            890 => sysz_insn::SYSZ_INS_CIBNLH,
            891 => sysz_insn::SYSZ_INS_CIT,
            892 => sysz_insn::SYSZ_INS_CITE,
            893 => sysz_insn::SYSZ_INS_CITH,
            894 => sysz_insn::SYSZ_INS_CITHE,
            895 => sysz_insn::SYSZ_INS_CITL,
            896 => sysz_insn::SYSZ_INS_CITLE,
            897 => sysz_insn::SYSZ_INS_CITLH,
            898 => sysz_insn::SYSZ_INS_CITNE,
            899 => sysz_insn::SYSZ_INS_CITNH,
            900 => sysz_insn::SYSZ_INS_CITNHE,
            901 => sysz_insn::SYSZ_INS_CITNL,
            902 => sysz_insn::SYSZ_INS_CITNLE,
            903 => sysz_insn::SYSZ_INS_CITNLH,
            904 => sysz_insn::SYSZ_INS_CKSM,
            905 => sysz_insn::SYSZ_INS_CLCL,
            906 => sysz_insn::SYSZ_INS_CLCLE,
            907 => sysz_insn::SYSZ_INS_CLCLU,
            908 => sysz_insn::SYSZ_INS_CLFDTR,
            909 => sysz_insn::SYSZ_INS_CLFIT,
            910 => sysz_insn::SYSZ_INS_CLFITE,
            911 => sysz_insn::SYSZ_INS_CLFITH,
            912 => sysz_insn::SYSZ_INS_CLFITHE,
            913 => sysz_insn::SYSZ_INS_CLFITL,
            914 => sysz_insn::SYSZ_INS_CLFITLE,
            915 => sysz_insn::SYSZ_INS_CLFITLH,
            916 => sysz_insn::SYSZ_INS_CLFITNE,
            917 => sysz_insn::SYSZ_INS_CLFITNH,
            918 => sysz_insn::SYSZ_INS_CLFITNHE,
            919 => sysz_insn::SYSZ_INS_CLFITNL,
            920 => sysz_insn::SYSZ_INS_CLFITNLE,
            921 => sysz_insn::SYSZ_INS_CLFITNLH,
            922 => sysz_insn::SYSZ_INS_CLFXTR,
            923 => sysz_insn::SYSZ_INS_CLGDTR,
            924 => sysz_insn::SYSZ_INS_CLGIB,
            925 => sysz_insn::SYSZ_INS_CLGIBE,
            926 => sysz_insn::SYSZ_INS_CLGIBH,
            927 => sysz_insn::SYSZ_INS_CLGIBHE,
            928 => sysz_insn::SYSZ_INS_CLGIBL,
            929 => sysz_insn::SYSZ_INS_CLGIBLE,
            930 => sysz_insn::SYSZ_INS_CLGIBLH,
            931 => sysz_insn::SYSZ_INS_CLGIBNE,
            932 => sysz_insn::SYSZ_INS_CLGIBNH,
            933 => sysz_insn::SYSZ_INS_CLGIBNHE,
            934 => sysz_insn::SYSZ_INS_CLGIBNL,
            935 => sysz_insn::SYSZ_INS_CLGIBNLE,
            936 => sysz_insn::SYSZ_INS_CLGIBNLH,
            937 => sysz_insn::SYSZ_INS_CLGIT,
            938 => sysz_insn::SYSZ_INS_CLGITE,
            939 => sysz_insn::SYSZ_INS_CLGITH,
            940 => sysz_insn::SYSZ_INS_CLGITHE,
            941 => sysz_insn::SYSZ_INS_CLGITL,
            942 => sysz_insn::SYSZ_INS_CLGITLE,
            943 => sysz_insn::SYSZ_INS_CLGITLH,
            944 => sysz_insn::SYSZ_INS_CLGITNE,
            945 => sysz_insn::SYSZ_INS_CLGITNH,
            946 => sysz_insn::SYSZ_INS_CLGITNHE,
            947 => sysz_insn::SYSZ_INS_CLGITNL,
            948 => sysz_insn::SYSZ_INS_CLGITNLE,
            949 => sysz_insn::SYSZ_INS_CLGITNLH,
            950 => sysz_insn::SYSZ_INS_CLGRB,
            951 => sysz_insn::SYSZ_INS_CLGRBE,
            952 => sysz_insn::SYSZ_INS_CLGRBH,
            953 => sysz_insn::SYSZ_INS_CLGRBHE,
            954 => sysz_insn::SYSZ_INS_CLGRBL,
            955 => sysz_insn::SYSZ_INS_CLGRBLE,
            956 => sysz_insn::SYSZ_INS_CLGRBLH,
            957 => sysz_insn::SYSZ_INS_CLGRBNE,
            958 => sysz_insn::SYSZ_INS_CLGRBNH,
            959 => sysz_insn::SYSZ_INS_CLGRBNHE,
            960 => sysz_insn::SYSZ_INS_CLGRBNL,
            961 => sysz_insn::SYSZ_INS_CLGRBNLE,
            962 => sysz_insn::SYSZ_INS_CLGRBNLH,
            963 => sysz_insn::SYSZ_INS_CLGRT,
            964 => sysz_insn::SYSZ_INS_CLGRTE,
            965 => sysz_insn::SYSZ_INS_CLGRTH,
            966 => sysz_insn::SYSZ_INS_CLGRTHE,
            967 => sysz_insn::SYSZ_INS_CLGRTL,
            968 => sysz_insn::SYSZ_INS_CLGRTLE,
            969 => sysz_insn::SYSZ_INS_CLGRTLH,
            970 => sysz_insn::SYSZ_INS_CLGRTNE,
            971 => sysz_insn::SYSZ_INS_CLGRTNH,
            972 => sysz_insn::SYSZ_INS_CLGRTNHE,
            973 => sysz_insn::SYSZ_INS_CLGRTNL,
            974 => sysz_insn::SYSZ_INS_CLGRTNLE,
            975 => sysz_insn::SYSZ_INS_CLGRTNLH,
            976 => sysz_insn::SYSZ_INS_CLGT,
            977 => sysz_insn::SYSZ_INS_CLGTE,
            978 => sysz_insn::SYSZ_INS_CLGTH,
            979 => sysz_insn::SYSZ_INS_CLGTHE,
            980 => sysz_insn::SYSZ_INS_CLGTL,
            981 => sysz_insn::SYSZ_INS_CLGTLE,
            982 => sysz_insn::SYSZ_INS_CLGTLH,
            983 => sysz_insn::SYSZ_INS_CLGTNE,
            984 => sysz_insn::SYSZ_INS_CLGTNH,
            985 => sysz_insn::SYSZ_INS_CLGTNHE,
            986 => sysz_insn::SYSZ_INS_CLGTNL,
            987 => sysz_insn::SYSZ_INS_CLGTNLE,
            988 => sysz_insn::SYSZ_INS_CLGTNLH,
            989 => sysz_insn::SYSZ_INS_CLGXTR,
            990 => sysz_insn::SYSZ_INS_CLHHR,
            991 => sysz_insn::SYSZ_INS_CLHLR,
            992 => sysz_insn::SYSZ_INS_CLIB,
            993 => sysz_insn::SYSZ_INS_CLIBE,
            994 => sysz_insn::SYSZ_INS_CLIBH,
            995 => sysz_insn::SYSZ_INS_CLIBHE,
            996 => sysz_insn::SYSZ_INS_CLIBL,
            997 => sysz_insn::SYSZ_INS_CLIBLE,
            998 => sysz_insn::SYSZ_INS_CLIBLH,
            999 => sysz_insn::SYSZ_INS_CLIBNE,
            1000 => sysz_insn::SYSZ_INS_CLIBNH,
            1001 => sysz_insn::SYSZ_INS_CLIBNHE,
            1002 => sysz_insn::SYSZ_INS_CLIBNL,
            1003 => sysz_insn::SYSZ_INS_CLIBNLE,
            1004 => sysz_insn::SYSZ_INS_CLIBNLH,
            1005 => sysz_insn::SYSZ_INS_CLM,
            1006 => sysz_insn::SYSZ_INS_CLMH,
            1007 => sysz_insn::SYSZ_INS_CLMY,
            1008 => sysz_insn::SYSZ_INS_CLRB,
            1009 => sysz_insn::SYSZ_INS_CLRBE,
            1010 => sysz_insn::SYSZ_INS_CLRBH,
            1011 => sysz_insn::SYSZ_INS_CLRBHE,
            1012 => sysz_insn::SYSZ_INS_CLRBL,
            1013 => sysz_insn::SYSZ_INS_CLRBLE,
            1014 => sysz_insn::SYSZ_INS_CLRBLH,
            1015 => sysz_insn::SYSZ_INS_CLRBNE,
            1016 => sysz_insn::SYSZ_INS_CLRBNH,
            1017 => sysz_insn::SYSZ_INS_CLRBNHE,
            1018 => sysz_insn::SYSZ_INS_CLRBNL,
            1019 => sysz_insn::SYSZ_INS_CLRBNLE,
            1020 => sysz_insn::SYSZ_INS_CLRBNLH,
            1021 => sysz_insn::SYSZ_INS_CLRT,
            1022 => sysz_insn::SYSZ_INS_CLRTE,
            1023 => sysz_insn::SYSZ_INS_CLRTH,
            1024 => sysz_insn::SYSZ_INS_CLRTHE,
            1025 => sysz_insn::SYSZ_INS_CLRTL,
            1026 => sysz_insn::SYSZ_INS_CLRTLE,
            1027 => sysz_insn::SYSZ_INS_CLRTLH,
            1028 => sysz_insn::SYSZ_INS_CLRTNE,
            1029 => sysz_insn::SYSZ_INS_CLRTNH,
            1030 => sysz_insn::SYSZ_INS_CLRTNHE,
            1031 => sysz_insn::SYSZ_INS_CLRTNL,
            1032 => sysz_insn::SYSZ_INS_CLRTNLE,
            1033 => sysz_insn::SYSZ_INS_CLRTNLH,
            1034 => sysz_insn::SYSZ_INS_CLT,
            1035 => sysz_insn::SYSZ_INS_CLTE,
            1036 => sysz_insn::SYSZ_INS_CLTH,
            1037 => sysz_insn::SYSZ_INS_CLTHE,
            1038 => sysz_insn::SYSZ_INS_CLTL,
            1039 => sysz_insn::SYSZ_INS_CLTLE,
            1040 => sysz_insn::SYSZ_INS_CLTLH,
            1041 => sysz_insn::SYSZ_INS_CLTNE,
            1042 => sysz_insn::SYSZ_INS_CLTNH,
            1043 => sysz_insn::SYSZ_INS_CLTNHE,
            1044 => sysz_insn::SYSZ_INS_CLTNL,
            1045 => sysz_insn::SYSZ_INS_CLTNLE,
            1046 => sysz_insn::SYSZ_INS_CLTNLH,
            1047 => sysz_insn::SYSZ_INS_CMPSC,
            1048 => sysz_insn::SYSZ_INS_CP,
            1049 => sysz_insn::SYSZ_INS_CPDT,
            1050 => sysz_insn::SYSZ_INS_CPXT,
            1051 => sysz_insn::SYSZ_INS_CPYA,
            1052 => sysz_insn::SYSZ_INS_CRB,
            1053 => sysz_insn::SYSZ_INS_CRBE,
            1054 => sysz_insn::SYSZ_INS_CRBH,
            1055 => sysz_insn::SYSZ_INS_CRBHE,
            1056 => sysz_insn::SYSZ_INS_CRBL,
            1057 => sysz_insn::SYSZ_INS_CRBLE,
            1058 => sysz_insn::SYSZ_INS_CRBLH,
            1059 => sysz_insn::SYSZ_INS_CRBNE,
            1060 => sysz_insn::SYSZ_INS_CRBNH,
            1061 => sysz_insn::SYSZ_INS_CRBNHE,
            1062 => sysz_insn::SYSZ_INS_CRBNL,
            1063 => sysz_insn::SYSZ_INS_CRBNLE,
            1064 => sysz_insn::SYSZ_INS_CRBNLH,
            1065 => sysz_insn::SYSZ_INS_CRDTE,
            1066 => sysz_insn::SYSZ_INS_CRT,
            1067 => sysz_insn::SYSZ_INS_CRTE,
            1068 => sysz_insn::SYSZ_INS_CRTH,
            1069 => sysz_insn::SYSZ_INS_CRTHE,
            1070 => sysz_insn::SYSZ_INS_CRTL,
            1071 => sysz_insn::SYSZ_INS_CRTLE,
            1072 => sysz_insn::SYSZ_INS_CRTLH,
            1073 => sysz_insn::SYSZ_INS_CRTNE,
            1074 => sysz_insn::SYSZ_INS_CRTNH,
            1075 => sysz_insn::SYSZ_INS_CRTNHE,
            1076 => sysz_insn::SYSZ_INS_CRTNL,
            1077 => sysz_insn::SYSZ_INS_CRTNLE,
            1078 => sysz_insn::SYSZ_INS_CRTNLH,
            1079 => sysz_insn::SYSZ_INS_CSCH,
            1080 => sysz_insn::SYSZ_INS_CSDTR,
            1081 => sysz_insn::SYSZ_INS_CSP,
            1082 => sysz_insn::SYSZ_INS_CSPG,
            1083 => sysz_insn::SYSZ_INS_CSST,
            1084 => sysz_insn::SYSZ_INS_CSXTR,
            1085 => sysz_insn::SYSZ_INS_CU12,
            1086 => sysz_insn::SYSZ_INS_CU14,
            1087 => sysz_insn::SYSZ_INS_CU21,
            1088 => sysz_insn::SYSZ_INS_CU24,
            1089 => sysz_insn::SYSZ_INS_CU41,
            1090 => sysz_insn::SYSZ_INS_CU42,
            1091 => sysz_insn::SYSZ_INS_CUDTR,
            1092 => sysz_insn::SYSZ_INS_CUSE,
            1093 => sysz_insn::SYSZ_INS_CUTFU,
            1094 => sysz_insn::SYSZ_INS_CUUTF,
            1095 => sysz_insn::SYSZ_INS_CUXTR,
            1096 => sysz_insn::SYSZ_INS_CVB,
            1097 => sysz_insn::SYSZ_INS_CVBG,
            1098 => sysz_insn::SYSZ_INS_CVBY,
            1099 => sysz_insn::SYSZ_INS_CVD,
            1100 => sysz_insn::SYSZ_INS_CVDG,
            1101 => sysz_insn::SYSZ_INS_CVDY,
            1102 => sysz_insn::SYSZ_INS_CXFBRA,
            1103 => sysz_insn::SYSZ_INS_CXFR,
            1104 => sysz_insn::SYSZ_INS_CXFTR,
            1105 => sysz_insn::SYSZ_INS_CXGBRA,
            1106 => sysz_insn::SYSZ_INS_CXGR,
            1107 => sysz_insn::SYSZ_INS_CXGTR,
            1108 => sysz_insn::SYSZ_INS_CXGTRA,
            1109 => sysz_insn::SYSZ_INS_CXLFTR,
            1110 => sysz_insn::SYSZ_INS_CXLGTR,
            1111 => sysz_insn::SYSZ_INS_CXPT,
            1112 => sysz_insn::SYSZ_INS_CXR,
            1113 => sysz_insn::SYSZ_INS_CXSTR,
            1114 => sysz_insn::SYSZ_INS_CXTR,
            1115 => sysz_insn::SYSZ_INS_CXUTR,
            1116 => sysz_insn::SYSZ_INS_CXZT,
            1117 => sysz_insn::SYSZ_INS_CZDT,
            1118 => sysz_insn::SYSZ_INS_CZXT,
            1119 => sysz_insn::SYSZ_INS_D,
            1120 => sysz_insn::SYSZ_INS_DD,
            1121 => sysz_insn::SYSZ_INS_DDR,
            1122 => sysz_insn::SYSZ_INS_DDTR,
            1123 => sysz_insn::SYSZ_INS_DDTRA,
            1124 => sysz_insn::SYSZ_INS_DE,
            1125 => sysz_insn::SYSZ_INS_DER,
            1126 => sysz_insn::SYSZ_INS_DIAG,
            1127 => sysz_insn::SYSZ_INS_DIDBR,
            1128 => sysz_insn::SYSZ_INS_DIEBR,
            1129 => sysz_insn::SYSZ_INS_DP,
            1130 => sysz_insn::SYSZ_INS_DR,
            1131 => sysz_insn::SYSZ_INS_DXR,
            1132 => sysz_insn::SYSZ_INS_DXTR,
            1133 => sysz_insn::SYSZ_INS_DXTRA,
            1134 => sysz_insn::SYSZ_INS_ECAG,
            1135 => sysz_insn::SYSZ_INS_ECCTR,
            1136 => sysz_insn::SYSZ_INS_ECPGA,
            1137 => sysz_insn::SYSZ_INS_ECTG,
            1138 => sysz_insn::SYSZ_INS_ED,
            1139 => sysz_insn::SYSZ_INS_EDMK,
            1140 => sysz_insn::SYSZ_INS_EEDTR,
            1141 => sysz_insn::SYSZ_INS_EEXTR,
            1142 => sysz_insn::SYSZ_INS_EFPC,
            1143 => sysz_insn::SYSZ_INS_EPAIR,
            1144 => sysz_insn::SYSZ_INS_EPAR,
            1145 => sysz_insn::SYSZ_INS_EPCTR,
            1146 => sysz_insn::SYSZ_INS_EPSW,
            1147 => sysz_insn::SYSZ_INS_EREG,
            1148 => sysz_insn::SYSZ_INS_EREGG,
            1149 => sysz_insn::SYSZ_INS_ESAIR,
            1150 => sysz_insn::SYSZ_INS_ESAR,
            1151 => sysz_insn::SYSZ_INS_ESDTR,
            1152 => sysz_insn::SYSZ_INS_ESEA,
            1153 => sysz_insn::SYSZ_INS_ESTA,
            1154 => sysz_insn::SYSZ_INS_ESXTR,
            1155 => sysz_insn::SYSZ_INS_ETND,
            1156 => sysz_insn::SYSZ_INS_EX,
            1157 => sysz_insn::SYSZ_INS_EXRL,
            1158 => sysz_insn::SYSZ_INS_FIDR,
            1159 => sysz_insn::SYSZ_INS_FIDTR,
            1160 => sysz_insn::SYSZ_INS_FIER,
            1161 => sysz_insn::SYSZ_INS_FIXR,
            1162 => sysz_insn::SYSZ_INS_FIXTR,
            1163 => sysz_insn::SYSZ_INS_HDR,
            1164 => sysz_insn::SYSZ_INS_HER,
            1165 => sysz_insn::SYSZ_INS_HSCH,
            1166 => sysz_insn::SYSZ_INS_IAC,
            1167 => sysz_insn::SYSZ_INS_ICM,
            1168 => sysz_insn::SYSZ_INS_ICMH,
            1169 => sysz_insn::SYSZ_INS_ICMY,
            1170 => sysz_insn::SYSZ_INS_IDTE,
            1171 => sysz_insn::SYSZ_INS_IEDTR,
            1172 => sysz_insn::SYSZ_INS_IEXTR,
            1173 => sysz_insn::SYSZ_INS_IPK,
            1174 => sysz_insn::SYSZ_INS_IPTE,
            1175 => sysz_insn::SYSZ_INS_IRBM,
            1176 => sysz_insn::SYSZ_INS_ISKE,
            1177 => sysz_insn::SYSZ_INS_IVSK,
            1178 => sysz_insn::SYSZ_INS_JGM,
            1179 => sysz_insn::SYSZ_INS_JGNM,
            1180 => sysz_insn::SYSZ_INS_JGNP,
            1181 => sysz_insn::SYSZ_INS_JGNZ,
            1182 => sysz_insn::SYSZ_INS_JGP,
            1183 => sysz_insn::SYSZ_INS_JGZ,
            1184 => sysz_insn::SYSZ_INS_JM,
            1185 => sysz_insn::SYSZ_INS_JNM,
            1186 => sysz_insn::SYSZ_INS_JNP,
            1187 => sysz_insn::SYSZ_INS_JNZ,
            1188 => sysz_insn::SYSZ_INS_JP,
            1189 => sysz_insn::SYSZ_INS_JZ,
            1190 => sysz_insn::SYSZ_INS_KDB,
            1191 => sysz_insn::SYSZ_INS_KDBR,
            1192 => sysz_insn::SYSZ_INS_KDTR,
            1193 => sysz_insn::SYSZ_INS_KEB,
            1194 => sysz_insn::SYSZ_INS_KEBR,
            1195 => sysz_insn::SYSZ_INS_KIMD,
            1196 => sysz_insn::SYSZ_INS_KLMD,
            1197 => sysz_insn::SYSZ_INS_KM,
            1198 => sysz_insn::SYSZ_INS_KMA,
            1199 => sysz_insn::SYSZ_INS_KMAC,
            1200 => sysz_insn::SYSZ_INS_KMC,
            1201 => sysz_insn::SYSZ_INS_KMCTR,
            1202 => sysz_insn::SYSZ_INS_KMF,
            1203 => sysz_insn::SYSZ_INS_KMO,
            1204 => sysz_insn::SYSZ_INS_KXBR,
            1205 => sysz_insn::SYSZ_INS_KXTR,
            1206 => sysz_insn::SYSZ_INS_LAE,
            1207 => sysz_insn::SYSZ_INS_LAEY,
            1208 => sysz_insn::SYSZ_INS_LAM,
            1209 => sysz_insn::SYSZ_INS_LAMY,
            1210 => sysz_insn::SYSZ_INS_LASP,
            1211 => sysz_insn::SYSZ_INS_LAT,
            1212 => sysz_insn::SYSZ_INS_LCBB,
            1213 => sysz_insn::SYSZ_INS_LCCTL,
            1214 => sysz_insn::SYSZ_INS_LCDFR,
            1215 => sysz_insn::SYSZ_INS_LCDR,
            1216 => sysz_insn::SYSZ_INS_LCER,
            1217 => sysz_insn::SYSZ_INS_LCTL,
            1218 => sysz_insn::SYSZ_INS_LCTLG,
            1219 => sysz_insn::SYSZ_INS_LCXR,
            1220 => sysz_insn::SYSZ_INS_LDE,
            1221 => sysz_insn::SYSZ_INS_LDER,
            1222 => sysz_insn::SYSZ_INS_LDETR,
            1223 => sysz_insn::SYSZ_INS_LDXR,
            1224 => sysz_insn::SYSZ_INS_LDXTR,
            1225 => sysz_insn::SYSZ_INS_LEDR,
            1226 => sysz_insn::SYSZ_INS_LEDTR,
            1227 => sysz_insn::SYSZ_INS_LEXR,
            1228 => sysz_insn::SYSZ_INS_LFAS,
            1229 => sysz_insn::SYSZ_INS_LFHAT,
            1230 => sysz_insn::SYSZ_INS_LFPC,
            1231 => sysz_insn::SYSZ_INS_LGAT,
            1232 => sysz_insn::SYSZ_INS_LGG,
            1233 => sysz_insn::SYSZ_INS_LGSC,
            1234 => sysz_insn::SYSZ_INS_LLGFAT,
            1235 => sysz_insn::SYSZ_INS_LLGFSG,
            1236 => sysz_insn::SYSZ_INS_LLGT,
            1237 => sysz_insn::SYSZ_INS_LLGTAT,
            1238 => sysz_insn::SYSZ_INS_LLGTR,
            1239 => sysz_insn::SYSZ_INS_LLZRGF,
            1240 => sysz_insn::SYSZ_INS_LM,
            1241 => sysz_insn::SYSZ_INS_LMD,
            1242 => sysz_insn::SYSZ_INS_LMH,
            1243 => sysz_insn::SYSZ_INS_LMY,
            1244 => sysz_insn::SYSZ_INS_LNDFR,
            1245 => sysz_insn::SYSZ_INS_LNDR,
            1246 => sysz_insn::SYSZ_INS_LNER,
            1247 => sysz_insn::SYSZ_INS_LNXR,
            1248 => sysz_insn::SYSZ_INS_LOCFH,
            1249 => sysz_insn::SYSZ_INS_LOCFHE,
            1250 => sysz_insn::SYSZ_INS_LOCFHH,
            1251 => sysz_insn::SYSZ_INS_LOCFHHE,
            1252 => sysz_insn::SYSZ_INS_LOCFHL,
            1253 => sysz_insn::SYSZ_INS_LOCFHLE,
            1254 => sysz_insn::SYSZ_INS_LOCFHLH,
            1255 => sysz_insn::SYSZ_INS_LOCFHM,
            1256 => sysz_insn::SYSZ_INS_LOCFHNE,
            1257 => sysz_insn::SYSZ_INS_LOCFHNH,
            1258 => sysz_insn::SYSZ_INS_LOCFHNHE,
            1259 => sysz_insn::SYSZ_INS_LOCFHNL,
            1260 => sysz_insn::SYSZ_INS_LOCFHNLE,
            1261 => sysz_insn::SYSZ_INS_LOCFHNLH,
            1262 => sysz_insn::SYSZ_INS_LOCFHNM,
            1263 => sysz_insn::SYSZ_INS_LOCFHNO,
            1264 => sysz_insn::SYSZ_INS_LOCFHNP,
            1265 => sysz_insn::SYSZ_INS_LOCFHNZ,
            1266 => sysz_insn::SYSZ_INS_LOCFHO,
            1267 => sysz_insn::SYSZ_INS_LOCFHP,
            1268 => sysz_insn::SYSZ_INS_LOCFHR,
            1269 => sysz_insn::SYSZ_INS_LOCFHRE,
            1270 => sysz_insn::SYSZ_INS_LOCFHRH,
            1271 => sysz_insn::SYSZ_INS_LOCFHRHE,
            1272 => sysz_insn::SYSZ_INS_LOCFHRL,
            1273 => sysz_insn::SYSZ_INS_LOCFHRLE,
            1274 => sysz_insn::SYSZ_INS_LOCFHRLH,
            1275 => sysz_insn::SYSZ_INS_LOCFHRM,
            1276 => sysz_insn::SYSZ_INS_LOCFHRNE,
            1277 => sysz_insn::SYSZ_INS_LOCFHRNH,
            1278 => sysz_insn::SYSZ_INS_LOCFHRNHE,
            1279 => sysz_insn::SYSZ_INS_LOCFHRNL,
            1280 => sysz_insn::SYSZ_INS_LOCFHRNLE,
            1281 => sysz_insn::SYSZ_INS_LOCFHRNLH,
            1282 => sysz_insn::SYSZ_INS_LOCFHRNM,
            1283 => sysz_insn::SYSZ_INS_LOCFHRNO,
            1284 => sysz_insn::SYSZ_INS_LOCFHRNP,
            1285 => sysz_insn::SYSZ_INS_LOCFHRNZ,
            1286 => sysz_insn::SYSZ_INS_LOCFHRO,
            1287 => sysz_insn::SYSZ_INS_LOCFHRP,
            1288 => sysz_insn::SYSZ_INS_LOCFHRZ,
            1289 => sysz_insn::SYSZ_INS_LOCFHZ,
            1290 => sysz_insn::SYSZ_INS_LOCGHI,
            1291 => sysz_insn::SYSZ_INS_LOCGHIE,
            1292 => sysz_insn::SYSZ_INS_LOCGHIH,
            1293 => sysz_insn::SYSZ_INS_LOCGHIHE,
            1294 => sysz_insn::SYSZ_INS_LOCGHIL,
            1295 => sysz_insn::SYSZ_INS_LOCGHILE,
            1296 => sysz_insn::SYSZ_INS_LOCGHILH,
            1297 => sysz_insn::SYSZ_INS_LOCGHIM,
            1298 => sysz_insn::SYSZ_INS_LOCGHINE,
            1299 => sysz_insn::SYSZ_INS_LOCGHINH,
            1300 => sysz_insn::SYSZ_INS_LOCGHINHE,
            1301 => sysz_insn::SYSZ_INS_LOCGHINL,
            1302 => sysz_insn::SYSZ_INS_LOCGHINLE,
            1303 => sysz_insn::SYSZ_INS_LOCGHINLH,
            1304 => sysz_insn::SYSZ_INS_LOCGHINM,
            1305 => sysz_insn::SYSZ_INS_LOCGHINO,
            1306 => sysz_insn::SYSZ_INS_LOCGHINP,
            1307 => sysz_insn::SYSZ_INS_LOCGHINZ,
            1308 => sysz_insn::SYSZ_INS_LOCGHIO,
            1309 => sysz_insn::SYSZ_INS_LOCGHIP,
            1310 => sysz_insn::SYSZ_INS_LOCGHIZ,
            1311 => sysz_insn::SYSZ_INS_LOCGM,
            1312 => sysz_insn::SYSZ_INS_LOCGNM,
            1313 => sysz_insn::SYSZ_INS_LOCGNP,
            1314 => sysz_insn::SYSZ_INS_LOCGNZ,
            1315 => sysz_insn::SYSZ_INS_LOCGP,
            1316 => sysz_insn::SYSZ_INS_LOCGRM,
            1317 => sysz_insn::SYSZ_INS_LOCGRNM,
            1318 => sysz_insn::SYSZ_INS_LOCGRNP,
            1319 => sysz_insn::SYSZ_INS_LOCGRNZ,
            1320 => sysz_insn::SYSZ_INS_LOCGRP,
            1321 => sysz_insn::SYSZ_INS_LOCGRZ,
            1322 => sysz_insn::SYSZ_INS_LOCGZ,
            1323 => sysz_insn::SYSZ_INS_LOCHHI,
            1324 => sysz_insn::SYSZ_INS_LOCHHIE,
            1325 => sysz_insn::SYSZ_INS_LOCHHIH,
            1326 => sysz_insn::SYSZ_INS_LOCHHIHE,
            1327 => sysz_insn::SYSZ_INS_LOCHHIL,
            1328 => sysz_insn::SYSZ_INS_LOCHHILE,
            1329 => sysz_insn::SYSZ_INS_LOCHHILH,
            1330 => sysz_insn::SYSZ_INS_LOCHHIM,
            1331 => sysz_insn::SYSZ_INS_LOCHHINE,
            1332 => sysz_insn::SYSZ_INS_LOCHHINH,
            1333 => sysz_insn::SYSZ_INS_LOCHHINHE,
            1334 => sysz_insn::SYSZ_INS_LOCHHINL,
            1335 => sysz_insn::SYSZ_INS_LOCHHINLE,
            1336 => sysz_insn::SYSZ_INS_LOCHHINLH,
            1337 => sysz_insn::SYSZ_INS_LOCHHINM,
            1338 => sysz_insn::SYSZ_INS_LOCHHINO,
            1339 => sysz_insn::SYSZ_INS_LOCHHINP,
            1340 => sysz_insn::SYSZ_INS_LOCHHINZ,
            1341 => sysz_insn::SYSZ_INS_LOCHHIO,
            1342 => sysz_insn::SYSZ_INS_LOCHHIP,
            1343 => sysz_insn::SYSZ_INS_LOCHHIZ,
            1344 => sysz_insn::SYSZ_INS_LOCHI,
            1345 => sysz_insn::SYSZ_INS_LOCHIE,
            1346 => sysz_insn::SYSZ_INS_LOCHIH,
            1347 => sysz_insn::SYSZ_INS_LOCHIHE,
            1348 => sysz_insn::SYSZ_INS_LOCHIL,
            1349 => sysz_insn::SYSZ_INS_LOCHILE,
            1350 => sysz_insn::SYSZ_INS_LOCHILH,
            1351 => sysz_insn::SYSZ_INS_LOCHIM,
            1352 => sysz_insn::SYSZ_INS_LOCHINE,
            1353 => sysz_insn::SYSZ_INS_LOCHINH,
            1354 => sysz_insn::SYSZ_INS_LOCHINHE,
            1355 => sysz_insn::SYSZ_INS_LOCHINL,
            1356 => sysz_insn::SYSZ_INS_LOCHINLE,
            1357 => sysz_insn::SYSZ_INS_LOCHINLH,
            1358 => sysz_insn::SYSZ_INS_LOCHINM,
            1359 => sysz_insn::SYSZ_INS_LOCHINO,
            1360 => sysz_insn::SYSZ_INS_LOCHINP,
            1361 => sysz_insn::SYSZ_INS_LOCHINZ,
            1362 => sysz_insn::SYSZ_INS_LOCHIO,
            1363 => sysz_insn::SYSZ_INS_LOCHIP,
            1364 => sysz_insn::SYSZ_INS_LOCHIZ,
            1365 => sysz_insn::SYSZ_INS_LOCM,
            1366 => sysz_insn::SYSZ_INS_LOCNM,
            1367 => sysz_insn::SYSZ_INS_LOCNP,
            1368 => sysz_insn::SYSZ_INS_LOCNZ,
            1369 => sysz_insn::SYSZ_INS_LOCP,
            1370 => sysz_insn::SYSZ_INS_LOCRM,
            1371 => sysz_insn::SYSZ_INS_LOCRNM,
            1372 => sysz_insn::SYSZ_INS_LOCRNP,
            1373 => sysz_insn::SYSZ_INS_LOCRNZ,
            1374 => sysz_insn::SYSZ_INS_LOCRP,
            1375 => sysz_insn::SYSZ_INS_LOCRZ,
            1376 => sysz_insn::SYSZ_INS_LOCZ,
            1377 => sysz_insn::SYSZ_INS_LPCTL,
            1378 => sysz_insn::SYSZ_INS_LPD,
            1379 => sysz_insn::SYSZ_INS_LPDFR,
            1380 => sysz_insn::SYSZ_INS_LPDG,
            1381 => sysz_insn::SYSZ_INS_LPDR,
            1382 => sysz_insn::SYSZ_INS_LPER,
            1383 => sysz_insn::SYSZ_INS_LPP,
            1384 => sysz_insn::SYSZ_INS_LPQ,
            1385 => sysz_insn::SYSZ_INS_LPSW,
            1386 => sysz_insn::SYSZ_INS_LPSWE,
            1387 => sysz_insn::SYSZ_INS_LPTEA,
            1388 => sysz_insn::SYSZ_INS_LPXR,
            1389 => sysz_insn::SYSZ_INS_LRA,
            1390 => sysz_insn::SYSZ_INS_LRAG,
            1391 => sysz_insn::SYSZ_INS_LRAY,
            1392 => sysz_insn::SYSZ_INS_LRDR,
            1393 => sysz_insn::SYSZ_INS_LRER,
            1394 => sysz_insn::SYSZ_INS_LRVH,
            1395 => sysz_insn::SYSZ_INS_LSCTL,
            1396 => sysz_insn::SYSZ_INS_LTDR,
            1397 => sysz_insn::SYSZ_INS_LTDTR,
            1398 => sysz_insn::SYSZ_INS_LTER,
            1399 => sysz_insn::SYSZ_INS_LTXR,
            1400 => sysz_insn::SYSZ_INS_LTXTR,
            1401 => sysz_insn::SYSZ_INS_LURA,
            1402 => sysz_insn::SYSZ_INS_LURAG,
            1403 => sysz_insn::SYSZ_INS_LXD,
            1404 => sysz_insn::SYSZ_INS_LXDR,
            1405 => sysz_insn::SYSZ_INS_LXDTR,
            1406 => sysz_insn::SYSZ_INS_LXE,
            1407 => sysz_insn::SYSZ_INS_LXER,
            1408 => sysz_insn::SYSZ_INS_LZRF,
            1409 => sysz_insn::SYSZ_INS_LZRG,
            1410 => sysz_insn::SYSZ_INS_M,
            1411 => sysz_insn::SYSZ_INS_MAD,
            1412 => sysz_insn::SYSZ_INS_MADR,
            1413 => sysz_insn::SYSZ_INS_MAE,
            1414 => sysz_insn::SYSZ_INS_MAER,
            1415 => sysz_insn::SYSZ_INS_MAY,
            1416 => sysz_insn::SYSZ_INS_MAYH,
            1417 => sysz_insn::SYSZ_INS_MAYHR,
            1418 => sysz_insn::SYSZ_INS_MAYL,
            1419 => sysz_insn::SYSZ_INS_MAYLR,
            1420 => sysz_insn::SYSZ_INS_MAYR,
            1421 => sysz_insn::SYSZ_INS_MC,
            1422 => sysz_insn::SYSZ_INS_MD,
            1423 => sysz_insn::SYSZ_INS_MDE,
            1424 => sysz_insn::SYSZ_INS_MDER,
            1425 => sysz_insn::SYSZ_INS_MDR,
            1426 => sysz_insn::SYSZ_INS_MDTR,
            1427 => sysz_insn::SYSZ_INS_MDTRA,
            1428 => sysz_insn::SYSZ_INS_ME,
            1429 => sysz_insn::SYSZ_INS_MEE,
            1430 => sysz_insn::SYSZ_INS_MEER,
            1431 => sysz_insn::SYSZ_INS_MER,
            1432 => sysz_insn::SYSZ_INS_MFY,
            1433 => sysz_insn::SYSZ_INS_MG,
            1434 => sysz_insn::SYSZ_INS_MGH,
            1435 => sysz_insn::SYSZ_INS_MGRK,
            1436 => sysz_insn::SYSZ_INS_ML,
            1437 => sysz_insn::SYSZ_INS_MLR,
            1438 => sysz_insn::SYSZ_INS_MP,
            1439 => sysz_insn::SYSZ_INS_MR,
            1440 => sysz_insn::SYSZ_INS_MSC,
            1441 => sysz_insn::SYSZ_INS_MSCH,
            1442 => sysz_insn::SYSZ_INS_MSD,
            1443 => sysz_insn::SYSZ_INS_MSDR,
            1444 => sysz_insn::SYSZ_INS_MSE,
            1445 => sysz_insn::SYSZ_INS_MSER,
            1446 => sysz_insn::SYSZ_INS_MSGC,
            1447 => sysz_insn::SYSZ_INS_MSGRKC,
            1448 => sysz_insn::SYSZ_INS_MSRKC,
            1449 => sysz_insn::SYSZ_INS_MSTA,
            1450 => sysz_insn::SYSZ_INS_MVCDK,
            1451 => sysz_insn::SYSZ_INS_MVCIN,
            1452 => sysz_insn::SYSZ_INS_MVCK,
            1453 => sysz_insn::SYSZ_INS_MVCL,
            1454 => sysz_insn::SYSZ_INS_MVCLE,
            1455 => sysz_insn::SYSZ_INS_MVCLU,
            1456 => sysz_insn::SYSZ_INS_MVCOS,
            1457 => sysz_insn::SYSZ_INS_MVCP,
            1458 => sysz_insn::SYSZ_INS_MVCS,
            1459 => sysz_insn::SYSZ_INS_MVCSK,
            1460 => sysz_insn::SYSZ_INS_MVN,
            1461 => sysz_insn::SYSZ_INS_MVO,
            1462 => sysz_insn::SYSZ_INS_MVPG,
            1463 => sysz_insn::SYSZ_INS_MVZ,
            1464 => sysz_insn::SYSZ_INS_MXD,
            1465 => sysz_insn::SYSZ_INS_MXDR,
            1466 => sysz_insn::SYSZ_INS_MXR,
            1467 => sysz_insn::SYSZ_INS_MXTR,
            1468 => sysz_insn::SYSZ_INS_MXTRA,
            1469 => sysz_insn::SYSZ_INS_MY,
            1470 => sysz_insn::SYSZ_INS_MYH,
            1471 => sysz_insn::SYSZ_INS_MYHR,
            1472 => sysz_insn::SYSZ_INS_MYL,
            1473 => sysz_insn::SYSZ_INS_MYLR,
            1474 => sysz_insn::SYSZ_INS_MYR,
            1475 => sysz_insn::SYSZ_INS_NIAI,
            1476 => sysz_insn::SYSZ_INS_NTSTG,
            1477 => sysz_insn::SYSZ_INS_PACK,
            1478 => sysz_insn::SYSZ_INS_PALB,
            1479 => sysz_insn::SYSZ_INS_PC,
            1480 => sysz_insn::SYSZ_INS_PCC,
            1481 => sysz_insn::SYSZ_INS_PCKMO,
            1482 => sysz_insn::SYSZ_INS_PFMF,
            1483 => sysz_insn::SYSZ_INS_PFPO,
            1484 => sysz_insn::SYSZ_INS_PGIN,
            1485 => sysz_insn::SYSZ_INS_PGOUT,
            1486 => sysz_insn::SYSZ_INS_PKA,
            1487 => sysz_insn::SYSZ_INS_PKU,
            1488 => sysz_insn::SYSZ_INS_PLO,
            1489 => sysz_insn::SYSZ_INS_POPCNT,
            1490 => sysz_insn::SYSZ_INS_PPA,
            1491 => sysz_insn::SYSZ_INS_PPNO,
            1492 => sysz_insn::SYSZ_INS_PR,
            1493 => sysz_insn::SYSZ_INS_PRNO,
            1494 => sysz_insn::SYSZ_INS_PT,
            1495 => sysz_insn::SYSZ_INS_PTF,
            1496 => sysz_insn::SYSZ_INS_PTFF,
            1497 => sysz_insn::SYSZ_INS_PTI,
            1498 => sysz_insn::SYSZ_INS_PTLB,
            1499 => sysz_insn::SYSZ_INS_QADTR,
            1500 => sysz_insn::SYSZ_INS_QAXTR,
            1501 => sysz_insn::SYSZ_INS_QCTRI,
            1502 => sysz_insn::SYSZ_INS_QSI,
            1503 => sysz_insn::SYSZ_INS_RCHP,
            1504 => sysz_insn::SYSZ_INS_RISBGN,
            1505 => sysz_insn::SYSZ_INS_RP,
            1506 => sysz_insn::SYSZ_INS_RRBE,
            1507 => sysz_insn::SYSZ_INS_RRBM,
            1508 => sysz_insn::SYSZ_INS_RRDTR,
            1509 => sysz_insn::SYSZ_INS_RRXTR,
            1510 => sysz_insn::SYSZ_INS_RSCH,
            1511 => sysz_insn::SYSZ_INS_SAC,
            1512 => sysz_insn::SYSZ_INS_SACF,
            1513 => sysz_insn::SYSZ_INS_SAL,
            1514 => sysz_insn::SYSZ_INS_SAM24,
            1515 => sysz_insn::SYSZ_INS_SAM31,
            1516 => sysz_insn::SYSZ_INS_SAM64,
            1517 => sysz_insn::SYSZ_INS_SAR,
            1518 => sysz_insn::SYSZ_INS_SCCTR,
            1519 => sysz_insn::SYSZ_INS_SCHM,
            1520 => sysz_insn::SYSZ_INS_SCK,
            1521 => sysz_insn::SYSZ_INS_SCKC,
            1522 => sysz_insn::SYSZ_INS_SCKPF,
            1523 => sysz_insn::SYSZ_INS_SD,
            1524 => sysz_insn::SYSZ_INS_SDR,
            1525 => sysz_insn::SYSZ_INS_SDTR,
            1526 => sysz_insn::SYSZ_INS_SDTRA,
            1527 => sysz_insn::SYSZ_INS_SE,
            1528 => sysz_insn::SYSZ_INS_SER,
            1529 => sysz_insn::SYSZ_INS_SFASR,
            1530 => sysz_insn::SYSZ_INS_SFPC,
            1531 => sysz_insn::SYSZ_INS_SGH,
            1532 => sysz_insn::SYSZ_INS_SHHHR,
            1533 => sysz_insn::SYSZ_INS_SHHLR,
            1534 => sysz_insn::SYSZ_INS_SIE,
            1535 => sysz_insn::SYSZ_INS_SIGA,
            1536 => sysz_insn::SYSZ_INS_SIGP,
            1537 => sysz_insn::SYSZ_INS_SLA,
            1538 => sysz_insn::SYSZ_INS_SLAG,
            1539 => sysz_insn::SYSZ_INS_SLAK,
            1540 => sysz_insn::SYSZ_INS_SLDA,
            1541 => sysz_insn::SYSZ_INS_SLDL,
            1542 => sysz_insn::SYSZ_INS_SLDT,
            1543 => sysz_insn::SYSZ_INS_SLHHHR,
            1544 => sysz_insn::SYSZ_INS_SLHHLR,
            1545 => sysz_insn::SYSZ_INS_SLXT,
            1546 => sysz_insn::SYSZ_INS_SP,
            1547 => sysz_insn::SYSZ_INS_SPCTR,
            1548 => sysz_insn::SYSZ_INS_SPKA,
            1549 => sysz_insn::SYSZ_INS_SPM,
            1550 => sysz_insn::SYSZ_INS_SPT,
            1551 => sysz_insn::SYSZ_INS_SPX,
            1552 => sysz_insn::SYSZ_INS_SQD,
            1553 => sysz_insn::SYSZ_INS_SQDR,
            1554 => sysz_insn::SYSZ_INS_SQE,
            1555 => sysz_insn::SYSZ_INS_SQER,
            1556 => sysz_insn::SYSZ_INS_SQXR,
            1557 => sysz_insn::SYSZ_INS_SRDA,
            1558 => sysz_insn::SYSZ_INS_SRDL,
            1559 => sysz_insn::SYSZ_INS_SRDT,
            1560 => sysz_insn::SYSZ_INS_SRNM,
            1561 => sysz_insn::SYSZ_INS_SRNMB,
            1562 => sysz_insn::SYSZ_INS_SRNMT,
            1563 => sysz_insn::SYSZ_INS_SRP,
            1564 => sysz_insn::SYSZ_INS_SRSTU,
            1565 => sysz_insn::SYSZ_INS_SRXT,
            1566 => sysz_insn::SYSZ_INS_SSAIR,
            1567 => sysz_insn::SYSZ_INS_SSAR,
            1568 => sysz_insn::SYSZ_INS_SSCH,
            1569 => sysz_insn::SYSZ_INS_SSKE,
            1570 => sysz_insn::SYSZ_INS_SSM,
            1571 => sysz_insn::SYSZ_INS_STAM,
            1572 => sysz_insn::SYSZ_INS_STAMY,
            1573 => sysz_insn::SYSZ_INS_STAP,
            1574 => sysz_insn::SYSZ_INS_STCK,
            1575 => sysz_insn::SYSZ_INS_STCKC,
            1576 => sysz_insn::SYSZ_INS_STCKE,
            1577 => sysz_insn::SYSZ_INS_STCKF,
            1578 => sysz_insn::SYSZ_INS_STCM,
            1579 => sysz_insn::SYSZ_INS_STCMH,
            1580 => sysz_insn::SYSZ_INS_STCMY,
            1581 => sysz_insn::SYSZ_INS_STCPS,
            1582 => sysz_insn::SYSZ_INS_STCRW,
            1583 => sysz_insn::SYSZ_INS_STCTG,
            1584 => sysz_insn::SYSZ_INS_STCTL,
            1585 => sysz_insn::SYSZ_INS_STFL,
            1586 => sysz_insn::SYSZ_INS_STFLE,
            1587 => sysz_insn::SYSZ_INS_STFPC,
            1588 => sysz_insn::SYSZ_INS_STGSC,
            1589 => sysz_insn::SYSZ_INS_STIDP,
            1590 => sysz_insn::SYSZ_INS_STM,
            1591 => sysz_insn::SYSZ_INS_STMH,
            1592 => sysz_insn::SYSZ_INS_STMY,
            1593 => sysz_insn::SYSZ_INS_STNSM,
            1594 => sysz_insn::SYSZ_INS_STOCFH,
            1595 => sysz_insn::SYSZ_INS_STOCFHE,
            1596 => sysz_insn::SYSZ_INS_STOCFHH,
            1597 => sysz_insn::SYSZ_INS_STOCFHHE,
            1598 => sysz_insn::SYSZ_INS_STOCFHL,
            1599 => sysz_insn::SYSZ_INS_STOCFHLE,
            1600 => sysz_insn::SYSZ_INS_STOCFHLH,
            1601 => sysz_insn::SYSZ_INS_STOCFHM,
            1602 => sysz_insn::SYSZ_INS_STOCFHNE,
            1603 => sysz_insn::SYSZ_INS_STOCFHNH,
            1604 => sysz_insn::SYSZ_INS_STOCFHNHE,
            1605 => sysz_insn::SYSZ_INS_STOCFHNL,
            1606 => sysz_insn::SYSZ_INS_STOCFHNLE,
            1607 => sysz_insn::SYSZ_INS_STOCFHNLH,
            1608 => sysz_insn::SYSZ_INS_STOCFHNM,
            1609 => sysz_insn::SYSZ_INS_STOCFHNO,
            1610 => sysz_insn::SYSZ_INS_STOCFHNP,
            1611 => sysz_insn::SYSZ_INS_STOCFHNZ,
            1612 => sysz_insn::SYSZ_INS_STOCFHO,
            1613 => sysz_insn::SYSZ_INS_STOCFHP,
            1614 => sysz_insn::SYSZ_INS_STOCFHZ,
            1615 => sysz_insn::SYSZ_INS_STOCGM,
            1616 => sysz_insn::SYSZ_INS_STOCGNM,
            1617 => sysz_insn::SYSZ_INS_STOCGNP,
            1618 => sysz_insn::SYSZ_INS_STOCGNZ,
            1619 => sysz_insn::SYSZ_INS_STOCGP,
            1620 => sysz_insn::SYSZ_INS_STOCGZ,
            1621 => sysz_insn::SYSZ_INS_STOCM,
            1622 => sysz_insn::SYSZ_INS_STOCNM,
            1623 => sysz_insn::SYSZ_INS_STOCNP,
            1624 => sysz_insn::SYSZ_INS_STOCNZ,
            1625 => sysz_insn::SYSZ_INS_STOCP,
            1626 => sysz_insn::SYSZ_INS_STOCZ,
            1627 => sysz_insn::SYSZ_INS_STOSM,
            1628 => sysz_insn::SYSZ_INS_STPQ,
            1629 => sysz_insn::SYSZ_INS_STPT,
            1630 => sysz_insn::SYSZ_INS_STPX,
            1631 => sysz_insn::SYSZ_INS_STRAG,
            1632 => sysz_insn::SYSZ_INS_STRVH,
            1633 => sysz_insn::SYSZ_INS_STSCH,
            1634 => sysz_insn::SYSZ_INS_STSI,
            1635 => sysz_insn::SYSZ_INS_STURA,
            1636 => sysz_insn::SYSZ_INS_STURG,
            1637 => sysz_insn::SYSZ_INS_SU,
            1638 => sysz_insn::SYSZ_INS_SUR,
            1639 => sysz_insn::SYSZ_INS_SVC,
            1640 => sysz_insn::SYSZ_INS_SW,
            1641 => sysz_insn::SYSZ_INS_SWR,
            1642 => sysz_insn::SYSZ_INS_SXR,
            1643 => sysz_insn::SYSZ_INS_SXTR,
            1644 => sysz_insn::SYSZ_INS_SXTRA,
            1645 => sysz_insn::SYSZ_INS_TABORT,
            1646 => sysz_insn::SYSZ_INS_TAM,
            1647 => sysz_insn::SYSZ_INS_TAR,
            1648 => sysz_insn::SYSZ_INS_TB,
            1649 => sysz_insn::SYSZ_INS_TBDR,
            1650 => sysz_insn::SYSZ_INS_TBEDR,
            1651 => sysz_insn::SYSZ_INS_TBEGIN,
            1652 => sysz_insn::SYSZ_INS_TBEGINC,
            1653 => sysz_insn::SYSZ_INS_TCDB,
            1654 => sysz_insn::SYSZ_INS_TCEB,
            1655 => sysz_insn::SYSZ_INS_TCXB,
            1656 => sysz_insn::SYSZ_INS_TDCDT,
            1657 => sysz_insn::SYSZ_INS_TDCET,
            1658 => sysz_insn::SYSZ_INS_TDCXT,
            1659 => sysz_insn::SYSZ_INS_TDGDT,
            1660 => sysz_insn::SYSZ_INS_TDGET,
            1661 => sysz_insn::SYSZ_INS_TDGXT,
            1662 => sysz_insn::SYSZ_INS_TEND,
            1663 => sysz_insn::SYSZ_INS_THDER,
            1664 => sysz_insn::SYSZ_INS_THDR,
            1665 => sysz_insn::SYSZ_INS_TP,
            1666 => sysz_insn::SYSZ_INS_TPI,
            1667 => sysz_insn::SYSZ_INS_TPROT,
            1668 => sysz_insn::SYSZ_INS_TR,
            1669 => sysz_insn::SYSZ_INS_TRACE,
            1670 => sysz_insn::SYSZ_INS_TRACG,
            1671 => sysz_insn::SYSZ_INS_TRAP2,
            1672 => sysz_insn::SYSZ_INS_TRAP4,
            1673 => sysz_insn::SYSZ_INS_TRE,
            1674 => sysz_insn::SYSZ_INS_TROO,
            1675 => sysz_insn::SYSZ_INS_TROT,
            1676 => sysz_insn::SYSZ_INS_TRT,
            1677 => sysz_insn::SYSZ_INS_TRTE,
            1678 => sysz_insn::SYSZ_INS_TRTO,
            1679 => sysz_insn::SYSZ_INS_TRTR,
            1680 => sysz_insn::SYSZ_INS_TRTRE,
            1681 => sysz_insn::SYSZ_INS_TRTT,
            1682 => sysz_insn::SYSZ_INS_TS,
            1683 => sysz_insn::SYSZ_INS_TSCH,
            1684 => sysz_insn::SYSZ_INS_UNPK,
            1685 => sysz_insn::SYSZ_INS_UNPKA,
            1686 => sysz_insn::SYSZ_INS_UNPKU,
            1687 => sysz_insn::SYSZ_INS_UPT,
            1688 => sysz_insn::SYSZ_INS_VA,
            1689 => sysz_insn::SYSZ_INS_VAB,
            1690 => sysz_insn::SYSZ_INS_VAC,
            1691 => sysz_insn::SYSZ_INS_VACC,
            1692 => sysz_insn::SYSZ_INS_VACCB,
            1693 => sysz_insn::SYSZ_INS_VACCC,
            1694 => sysz_insn::SYSZ_INS_VACCCQ,
            1695 => sysz_insn::SYSZ_INS_VACCF,
            1696 => sysz_insn::SYSZ_INS_VACCG,
            1697 => sysz_insn::SYSZ_INS_VACCH,
            1698 => sysz_insn::SYSZ_INS_VACCQ,
            1699 => sysz_insn::SYSZ_INS_VACQ,
            1700 => sysz_insn::SYSZ_INS_VAF,
            1701 => sysz_insn::SYSZ_INS_VAG,
            1702 => sysz_insn::SYSZ_INS_VAH,
            1703 => sysz_insn::SYSZ_INS_VAP,
            1704 => sysz_insn::SYSZ_INS_VAQ,
            1705 => sysz_insn::SYSZ_INS_VAVG,
            1706 => sysz_insn::SYSZ_INS_VAVGB,
            1707 => sysz_insn::SYSZ_INS_VAVGF,
            1708 => sysz_insn::SYSZ_INS_VAVGG,
            1709 => sysz_insn::SYSZ_INS_VAVGH,
            1710 => sysz_insn::SYSZ_INS_VAVGL,
            1711 => sysz_insn::SYSZ_INS_VAVGLB,
            1712 => sysz_insn::SYSZ_INS_VAVGLF,
            1713 => sysz_insn::SYSZ_INS_VAVGLG,
            1714 => sysz_insn::SYSZ_INS_VAVGLH,
            1715 => sysz_insn::SYSZ_INS_VBPERM,
            1716 => sysz_insn::SYSZ_INS_VCDG,
            1717 => sysz_insn::SYSZ_INS_VCDGB,
            1718 => sysz_insn::SYSZ_INS_VCDLG,
            1719 => sysz_insn::SYSZ_INS_VCDLGB,
            1720 => sysz_insn::SYSZ_INS_VCEQ,
            1721 => sysz_insn::SYSZ_INS_VCEQB,
            1722 => sysz_insn::SYSZ_INS_VCEQBS,
            1723 => sysz_insn::SYSZ_INS_VCEQF,
            1724 => sysz_insn::SYSZ_INS_VCEQFS,
            1725 => sysz_insn::SYSZ_INS_VCEQG,
            1726 => sysz_insn::SYSZ_INS_VCEQGS,
            1727 => sysz_insn::SYSZ_INS_VCEQH,
            1728 => sysz_insn::SYSZ_INS_VCEQHS,
            1729 => sysz_insn::SYSZ_INS_VCGD,
            1730 => sysz_insn::SYSZ_INS_VCGDB,
            1731 => sysz_insn::SYSZ_INS_VCH,
            1732 => sysz_insn::SYSZ_INS_VCHB,
            1733 => sysz_insn::SYSZ_INS_VCHBS,
            1734 => sysz_insn::SYSZ_INS_VCHF,
            1735 => sysz_insn::SYSZ_INS_VCHFS,
            1736 => sysz_insn::SYSZ_INS_VCHG,
            1737 => sysz_insn::SYSZ_INS_VCHGS,
            1738 => sysz_insn::SYSZ_INS_VCHH,
            1739 => sysz_insn::SYSZ_INS_VCHHS,
            1740 => sysz_insn::SYSZ_INS_VCHL,
            1741 => sysz_insn::SYSZ_INS_VCHLB,
            1742 => sysz_insn::SYSZ_INS_VCHLBS,
            1743 => sysz_insn::SYSZ_INS_VCHLF,
            1744 => sysz_insn::SYSZ_INS_VCHLFS,
            1745 => sysz_insn::SYSZ_INS_VCHLG,
            1746 => sysz_insn::SYSZ_INS_VCHLGS,
            1747 => sysz_insn::SYSZ_INS_VCHLH,
            1748 => sysz_insn::SYSZ_INS_VCHLHS,
            1749 => sysz_insn::SYSZ_INS_VCKSM,
            1750 => sysz_insn::SYSZ_INS_VCLGD,
            1751 => sysz_insn::SYSZ_INS_VCLGDB,
            1752 => sysz_insn::SYSZ_INS_VCLZ,
            1753 => sysz_insn::SYSZ_INS_VCLZB,
            1754 => sysz_insn::SYSZ_INS_VCLZF,
            1755 => sysz_insn::SYSZ_INS_VCLZG,
            1756 => sysz_insn::SYSZ_INS_VCLZH,
            1757 => sysz_insn::SYSZ_INS_VCP,
            1758 => sysz_insn::SYSZ_INS_VCTZ,
            1759 => sysz_insn::SYSZ_INS_VCTZB,
            1760 => sysz_insn::SYSZ_INS_VCTZF,
            1761 => sysz_insn::SYSZ_INS_VCTZG,
            1762 => sysz_insn::SYSZ_INS_VCTZH,
            1763 => sysz_insn::SYSZ_INS_VCVB,
            1764 => sysz_insn::SYSZ_INS_VCVBG,
            1765 => sysz_insn::SYSZ_INS_VCVD,
            1766 => sysz_insn::SYSZ_INS_VCVDG,
            1767 => sysz_insn::SYSZ_INS_VDP,
            1768 => sysz_insn::SYSZ_INS_VEC,
            1769 => sysz_insn::SYSZ_INS_VECB,
            1770 => sysz_insn::SYSZ_INS_VECF,
            1771 => sysz_insn::SYSZ_INS_VECG,
            1772 => sysz_insn::SYSZ_INS_VECH,
            1773 => sysz_insn::SYSZ_INS_VECL,
            1774 => sysz_insn::SYSZ_INS_VECLB,
            1775 => sysz_insn::SYSZ_INS_VECLF,
            1776 => sysz_insn::SYSZ_INS_VECLG,
            1777 => sysz_insn::SYSZ_INS_VECLH,
            1778 => sysz_insn::SYSZ_INS_VERIM,
            1779 => sysz_insn::SYSZ_INS_VERIMB,
            1780 => sysz_insn::SYSZ_INS_VERIMF,
            1781 => sysz_insn::SYSZ_INS_VERIMG,
            1782 => sysz_insn::SYSZ_INS_VERIMH,
            1783 => sysz_insn::SYSZ_INS_VERLL,
            1784 => sysz_insn::SYSZ_INS_VERLLB,
            1785 => sysz_insn::SYSZ_INS_VERLLF,
            1786 => sysz_insn::SYSZ_INS_VERLLG,
            1787 => sysz_insn::SYSZ_INS_VERLLH,
            1788 => sysz_insn::SYSZ_INS_VERLLV,
            1789 => sysz_insn::SYSZ_INS_VERLLVB,
            1790 => sysz_insn::SYSZ_INS_VERLLVF,
            1791 => sysz_insn::SYSZ_INS_VERLLVG,
            1792 => sysz_insn::SYSZ_INS_VERLLVH,
            1793 => sysz_insn::SYSZ_INS_VESL,
            1794 => sysz_insn::SYSZ_INS_VESLB,
            1795 => sysz_insn::SYSZ_INS_VESLF,
            1796 => sysz_insn::SYSZ_INS_VESLG,
            1797 => sysz_insn::SYSZ_INS_VESLH,
            1798 => sysz_insn::SYSZ_INS_VESLV,
            1799 => sysz_insn::SYSZ_INS_VESLVB,
            1800 => sysz_insn::SYSZ_INS_VESLVF,
            1801 => sysz_insn::SYSZ_INS_VESLVG,
            1802 => sysz_insn::SYSZ_INS_VESLVH,
            1803 => sysz_insn::SYSZ_INS_VESRA,
            1804 => sysz_insn::SYSZ_INS_VESRAB,
            1805 => sysz_insn::SYSZ_INS_VESRAF,
            1806 => sysz_insn::SYSZ_INS_VESRAG,
            1807 => sysz_insn::SYSZ_INS_VESRAH,
            1808 => sysz_insn::SYSZ_INS_VESRAV,
            1809 => sysz_insn::SYSZ_INS_VESRAVB,
            1810 => sysz_insn::SYSZ_INS_VESRAVF,
            1811 => sysz_insn::SYSZ_INS_VESRAVG,
            1812 => sysz_insn::SYSZ_INS_VESRAVH,
            1813 => sysz_insn::SYSZ_INS_VESRL,
            1814 => sysz_insn::SYSZ_INS_VESRLB,
            1815 => sysz_insn::SYSZ_INS_VESRLF,
            1816 => sysz_insn::SYSZ_INS_VESRLG,
            1817 => sysz_insn::SYSZ_INS_VESRLH,
            1818 => sysz_insn::SYSZ_INS_VESRLV,
            1819 => sysz_insn::SYSZ_INS_VESRLVB,
            1820 => sysz_insn::SYSZ_INS_VESRLVF,
            1821 => sysz_insn::SYSZ_INS_VESRLVG,
            1822 => sysz_insn::SYSZ_INS_VESRLVH,
            1823 => sysz_insn::SYSZ_INS_VFA,
            1824 => sysz_insn::SYSZ_INS_VFADB,
            1825 => sysz_insn::SYSZ_INS_VFAE,
            1826 => sysz_insn::SYSZ_INS_VFAEB,
            1827 => sysz_insn::SYSZ_INS_VFAEBS,
            1828 => sysz_insn::SYSZ_INS_VFAEF,
            1829 => sysz_insn::SYSZ_INS_VFAEFS,
            1830 => sysz_insn::SYSZ_INS_VFAEH,
            1831 => sysz_insn::SYSZ_INS_VFAEHS,
            1832 => sysz_insn::SYSZ_INS_VFAEZB,
            1833 => sysz_insn::SYSZ_INS_VFAEZBS,
            1834 => sysz_insn::SYSZ_INS_VFAEZF,
            1835 => sysz_insn::SYSZ_INS_VFAEZFS,
            1836 => sysz_insn::SYSZ_INS_VFAEZH,
            1837 => sysz_insn::SYSZ_INS_VFAEZHS,
            1838 => sysz_insn::SYSZ_INS_VFASB,
            1839 => sysz_insn::SYSZ_INS_VFCE,
            1840 => sysz_insn::SYSZ_INS_VFCEDB,
            1841 => sysz_insn::SYSZ_INS_VFCEDBS,
            1842 => sysz_insn::SYSZ_INS_VFCESB,
            1843 => sysz_insn::SYSZ_INS_VFCESBS,
            1844 => sysz_insn::SYSZ_INS_VFCH,
            1845 => sysz_insn::SYSZ_INS_VFCHDB,
            1846 => sysz_insn::SYSZ_INS_VFCHDBS,
            1847 => sysz_insn::SYSZ_INS_VFCHE,
            1848 => sysz_insn::SYSZ_INS_VFCHEDB,
            1849 => sysz_insn::SYSZ_INS_VFCHEDBS,
            1850 => sysz_insn::SYSZ_INS_VFCHESB,
            1851 => sysz_insn::SYSZ_INS_VFCHESBS,
            1852 => sysz_insn::SYSZ_INS_VFCHSB,
            1853 => sysz_insn::SYSZ_INS_VFCHSBS,
            1854 => sysz_insn::SYSZ_INS_VFD,
            1855 => sysz_insn::SYSZ_INS_VFDDB,
            1856 => sysz_insn::SYSZ_INS_VFDSB,
            1857 => sysz_insn::SYSZ_INS_VFEE,
            1858 => sysz_insn::SYSZ_INS_VFEEB,
            1859 => sysz_insn::SYSZ_INS_VFEEBS,
            1860 => sysz_insn::SYSZ_INS_VFEEF,
            1861 => sysz_insn::SYSZ_INS_VFEEFS,
            1862 => sysz_insn::SYSZ_INS_VFEEH,
            1863 => sysz_insn::SYSZ_INS_VFEEHS,
            1864 => sysz_insn::SYSZ_INS_VFEEZB,
            1865 => sysz_insn::SYSZ_INS_VFEEZBS,
            1866 => sysz_insn::SYSZ_INS_VFEEZF,
            1867 => sysz_insn::SYSZ_INS_VFEEZFS,
            1868 => sysz_insn::SYSZ_INS_VFEEZH,
            1869 => sysz_insn::SYSZ_INS_VFEEZHS,
            1870 => sysz_insn::SYSZ_INS_VFENE,
            1871 => sysz_insn::SYSZ_INS_VFENEB,
            1872 => sysz_insn::SYSZ_INS_VFENEBS,
            1873 => sysz_insn::SYSZ_INS_VFENEF,
            1874 => sysz_insn::SYSZ_INS_VFENEFS,
            1875 => sysz_insn::SYSZ_INS_VFENEH,
            1876 => sysz_insn::SYSZ_INS_VFENEHS,
            1877 => sysz_insn::SYSZ_INS_VFENEZB,
            1878 => sysz_insn::SYSZ_INS_VFENEZBS,
            1879 => sysz_insn::SYSZ_INS_VFENEZF,
            1880 => sysz_insn::SYSZ_INS_VFENEZFS,
            1881 => sysz_insn::SYSZ_INS_VFENEZH,
            1882 => sysz_insn::SYSZ_INS_VFENEZHS,
            1883 => sysz_insn::SYSZ_INS_VFI,
            1884 => sysz_insn::SYSZ_INS_VFIDB,
            1885 => sysz_insn::SYSZ_INS_VFISB,
            1886 => sysz_insn::SYSZ_INS_VFKEDB,
            1887 => sysz_insn::SYSZ_INS_VFKEDBS,
            1888 => sysz_insn::SYSZ_INS_VFKESB,
            1889 => sysz_insn::SYSZ_INS_VFKESBS,
            1890 => sysz_insn::SYSZ_INS_VFKHDB,
            1891 => sysz_insn::SYSZ_INS_VFKHDBS,
            1892 => sysz_insn::SYSZ_INS_VFKHEDB,
            1893 => sysz_insn::SYSZ_INS_VFKHEDBS,
            1894 => sysz_insn::SYSZ_INS_VFKHESB,
            1895 => sysz_insn::SYSZ_INS_VFKHESBS,
            1896 => sysz_insn::SYSZ_INS_VFKHSB,
            1897 => sysz_insn::SYSZ_INS_VFKHSBS,
            1898 => sysz_insn::SYSZ_INS_VFLCDB,
            1899 => sysz_insn::SYSZ_INS_VFLCSB,
            1900 => sysz_insn::SYSZ_INS_VFLL,
            1901 => sysz_insn::SYSZ_INS_VFLLS,
            1902 => sysz_insn::SYSZ_INS_VFLNDB,
            1903 => sysz_insn::SYSZ_INS_VFLNSB,
            1904 => sysz_insn::SYSZ_INS_VFLPDB,
            1905 => sysz_insn::SYSZ_INS_VFLPSB,
            1906 => sysz_insn::SYSZ_INS_VFLR,
            1907 => sysz_insn::SYSZ_INS_VFLRD,
            1908 => sysz_insn::SYSZ_INS_VFM,
            1909 => sysz_insn::SYSZ_INS_VFMA,
            1910 => sysz_insn::SYSZ_INS_VFMADB,
            1911 => sysz_insn::SYSZ_INS_VFMASB,
            1912 => sysz_insn::SYSZ_INS_VFMAX,
            1913 => sysz_insn::SYSZ_INS_VFMAXDB,
            1914 => sysz_insn::SYSZ_INS_VFMAXSB,
            1915 => sysz_insn::SYSZ_INS_VFMDB,
            1916 => sysz_insn::SYSZ_INS_VFMIN,
            1917 => sysz_insn::SYSZ_INS_VFMINDB,
            1918 => sysz_insn::SYSZ_INS_VFMINSB,
            1919 => sysz_insn::SYSZ_INS_VFMS,
            1920 => sysz_insn::SYSZ_INS_VFMSB,
            1921 => sysz_insn::SYSZ_INS_VFMSDB,
            1922 => sysz_insn::SYSZ_INS_VFMSSB,
            1923 => sysz_insn::SYSZ_INS_VFNMA,
            1924 => sysz_insn::SYSZ_INS_VFNMADB,
            1925 => sysz_insn::SYSZ_INS_VFNMASB,
            1926 => sysz_insn::SYSZ_INS_VFNMS,
            1927 => sysz_insn::SYSZ_INS_VFNMSDB,
            1928 => sysz_insn::SYSZ_INS_VFNMSSB,
            1929 => sysz_insn::SYSZ_INS_VFPSO,
            1930 => sysz_insn::SYSZ_INS_VFPSODB,
            1931 => sysz_insn::SYSZ_INS_VFPSOSB,
            1932 => sysz_insn::SYSZ_INS_VFS,
            1933 => sysz_insn::SYSZ_INS_VFSDB,
            1934 => sysz_insn::SYSZ_INS_VFSQ,
            1935 => sysz_insn::SYSZ_INS_VFSQDB,
            1936 => sysz_insn::SYSZ_INS_VFSQSB,
            1937 => sysz_insn::SYSZ_INS_VFSSB,
            1938 => sysz_insn::SYSZ_INS_VFTCI,
            1939 => sysz_insn::SYSZ_INS_VFTCIDB,
            1940 => sysz_insn::SYSZ_INS_VFTCISB,
            1941 => sysz_insn::SYSZ_INS_VGBM,
            1942 => sysz_insn::SYSZ_INS_VGEF,
            1943 => sysz_insn::SYSZ_INS_VGEG,
            1944 => sysz_insn::SYSZ_INS_VGFM,
            1945 => sysz_insn::SYSZ_INS_VGFMA,
            1946 => sysz_insn::SYSZ_INS_VGFMAB,
            1947 => sysz_insn::SYSZ_INS_VGFMAF,
            1948 => sysz_insn::SYSZ_INS_VGFMAG,
            1949 => sysz_insn::SYSZ_INS_VGFMAH,
            1950 => sysz_insn::SYSZ_INS_VGFMB,
            1951 => sysz_insn::SYSZ_INS_VGFMF,
            1952 => sysz_insn::SYSZ_INS_VGFMG,
            1953 => sysz_insn::SYSZ_INS_VGFMH,
            1954 => sysz_insn::SYSZ_INS_VGM,
            1955 => sysz_insn::SYSZ_INS_VGMB,
            1956 => sysz_insn::SYSZ_INS_VGMF,
            1957 => sysz_insn::SYSZ_INS_VGMG,
            1958 => sysz_insn::SYSZ_INS_VGMH,
            1959 => sysz_insn::SYSZ_INS_VISTR,
            1960 => sysz_insn::SYSZ_INS_VISTRB,
            1961 => sysz_insn::SYSZ_INS_VISTRBS,
            1962 => sysz_insn::SYSZ_INS_VISTRF,
            1963 => sysz_insn::SYSZ_INS_VISTRFS,
            1964 => sysz_insn::SYSZ_INS_VISTRH,
            1965 => sysz_insn::SYSZ_INS_VISTRHS,
            1966 => sysz_insn::SYSZ_INS_VL,
            1967 => sysz_insn::SYSZ_INS_VLBB,
            1968 => sysz_insn::SYSZ_INS_VLC,
            1969 => sysz_insn::SYSZ_INS_VLCB,
            1970 => sysz_insn::SYSZ_INS_VLCF,
            1971 => sysz_insn::SYSZ_INS_VLCG,
            1972 => sysz_insn::SYSZ_INS_VLCH,
            1973 => sysz_insn::SYSZ_INS_VLDE,
            1974 => sysz_insn::SYSZ_INS_VLDEB,
            1975 => sysz_insn::SYSZ_INS_VLEB,
            1976 => sysz_insn::SYSZ_INS_VLED,
            1977 => sysz_insn::SYSZ_INS_VLEDB,
            1978 => sysz_insn::SYSZ_INS_VLEF,
            1979 => sysz_insn::SYSZ_INS_VLEG,
            1980 => sysz_insn::SYSZ_INS_VLEH,
            1981 => sysz_insn::SYSZ_INS_VLEIB,
            1982 => sysz_insn::SYSZ_INS_VLEIF,
            1983 => sysz_insn::SYSZ_INS_VLEIG,
            1984 => sysz_insn::SYSZ_INS_VLEIH,
            1985 => sysz_insn::SYSZ_INS_VLGV,
            1986 => sysz_insn::SYSZ_INS_VLGVB,
            1987 => sysz_insn::SYSZ_INS_VLGVF,
            1988 => sysz_insn::SYSZ_INS_VLGVG,
            1989 => sysz_insn::SYSZ_INS_VLGVH,
            1990 => sysz_insn::SYSZ_INS_VLIP,
            1991 => sysz_insn::SYSZ_INS_VLL,
            1992 => sysz_insn::SYSZ_INS_VLLEZ,
            1993 => sysz_insn::SYSZ_INS_VLLEZB,
            1994 => sysz_insn::SYSZ_INS_VLLEZF,
            1995 => sysz_insn::SYSZ_INS_VLLEZG,
            1996 => sysz_insn::SYSZ_INS_VLLEZH,
            1997 => sysz_insn::SYSZ_INS_VLLEZLF,
            1998 => sysz_insn::SYSZ_INS_VLM,
            1999 => sysz_insn::SYSZ_INS_VLP,
            2000 => sysz_insn::SYSZ_INS_VLPB,
            2001 => sysz_insn::SYSZ_INS_VLPF,
            2002 => sysz_insn::SYSZ_INS_VLPG,
            2003 => sysz_insn::SYSZ_INS_VLPH,
            2004 => sysz_insn::SYSZ_INS_VLR,
            2005 => sysz_insn::SYSZ_INS_VLREP,
            2006 => sysz_insn::SYSZ_INS_VLREPB,
            2007 => sysz_insn::SYSZ_INS_VLREPF,
            2008 => sysz_insn::SYSZ_INS_VLREPG,
            2009 => sysz_insn::SYSZ_INS_VLREPH,
            2010 => sysz_insn::SYSZ_INS_VLRL,
            2011 => sysz_insn::SYSZ_INS_VLRLR,
            2012 => sysz_insn::SYSZ_INS_VLVG,
            2013 => sysz_insn::SYSZ_INS_VLVGB,
            2014 => sysz_insn::SYSZ_INS_VLVGF,
            2015 => sysz_insn::SYSZ_INS_VLVGG,
            2016 => sysz_insn::SYSZ_INS_VLVGH,
            2017 => sysz_insn::SYSZ_INS_VLVGP,
            2018 => sysz_insn::SYSZ_INS_VMAE,
            2019 => sysz_insn::SYSZ_INS_VMAEB,
            2020 => sysz_insn::SYSZ_INS_VMAEF,
            2021 => sysz_insn::SYSZ_INS_VMAEH,
            2022 => sysz_insn::SYSZ_INS_VMAH,
            2023 => sysz_insn::SYSZ_INS_VMAHB,
            2024 => sysz_insn::SYSZ_INS_VMAHF,
            2025 => sysz_insn::SYSZ_INS_VMAHH,
            2026 => sysz_insn::SYSZ_INS_VMAL,
            2027 => sysz_insn::SYSZ_INS_VMALB,
            2028 => sysz_insn::SYSZ_INS_VMALE,
            2029 => sysz_insn::SYSZ_INS_VMALEB,
            2030 => sysz_insn::SYSZ_INS_VMALEF,
            2031 => sysz_insn::SYSZ_INS_VMALEH,
            2032 => sysz_insn::SYSZ_INS_VMALF,
            2033 => sysz_insn::SYSZ_INS_VMALH,
            2034 => sysz_insn::SYSZ_INS_VMALHB,
            2035 => sysz_insn::SYSZ_INS_VMALHF,
            2036 => sysz_insn::SYSZ_INS_VMALHH,
            2037 => sysz_insn::SYSZ_INS_VMALHW,
            2038 => sysz_insn::SYSZ_INS_VMALO,
            2039 => sysz_insn::SYSZ_INS_VMALOB,
            2040 => sysz_insn::SYSZ_INS_VMALOF,
            2041 => sysz_insn::SYSZ_INS_VMALOH,
            2042 => sysz_insn::SYSZ_INS_VMAO,
            2043 => sysz_insn::SYSZ_INS_VMAOB,
            2044 => sysz_insn::SYSZ_INS_VMAOF,
            2045 => sysz_insn::SYSZ_INS_VMAOH,
            2046 => sysz_insn::SYSZ_INS_VME,
            2047 => sysz_insn::SYSZ_INS_VMEB,
            2048 => sysz_insn::SYSZ_INS_VMEF,
            2049 => sysz_insn::SYSZ_INS_VMEH,
            2050 => sysz_insn::SYSZ_INS_VMH,
            2051 => sysz_insn::SYSZ_INS_VMHB,
            2052 => sysz_insn::SYSZ_INS_VMHF,
            2053 => sysz_insn::SYSZ_INS_VMHH,
            2054 => sysz_insn::SYSZ_INS_VML,
            2055 => sysz_insn::SYSZ_INS_VMLB,
            2056 => sysz_insn::SYSZ_INS_VMLE,
            2057 => sysz_insn::SYSZ_INS_VMLEB,
            2058 => sysz_insn::SYSZ_INS_VMLEF,
            2059 => sysz_insn::SYSZ_INS_VMLEH,
            2060 => sysz_insn::SYSZ_INS_VMLF,
            2061 => sysz_insn::SYSZ_INS_VMLH,
            2062 => sysz_insn::SYSZ_INS_VMLHB,
            2063 => sysz_insn::SYSZ_INS_VMLHF,
            2064 => sysz_insn::SYSZ_INS_VMLHH,
            2065 => sysz_insn::SYSZ_INS_VMLHW,
            2066 => sysz_insn::SYSZ_INS_VMLO,
            2067 => sysz_insn::SYSZ_INS_VMLOB,
            2068 => sysz_insn::SYSZ_INS_VMLOF,
            2069 => sysz_insn::SYSZ_INS_VMLOH,
            2070 => sysz_insn::SYSZ_INS_VMN,
            2071 => sysz_insn::SYSZ_INS_VMNB,
            2072 => sysz_insn::SYSZ_INS_VMNF,
            2073 => sysz_insn::SYSZ_INS_VMNG,
            2074 => sysz_insn::SYSZ_INS_VMNH,
            2075 => sysz_insn::SYSZ_INS_VMNL,
            2076 => sysz_insn::SYSZ_INS_VMNLB,
            2077 => sysz_insn::SYSZ_INS_VMNLF,
            2078 => sysz_insn::SYSZ_INS_VMNLG,
            2079 => sysz_insn::SYSZ_INS_VMNLH,
            2080 => sysz_insn::SYSZ_INS_VMO,
            2081 => sysz_insn::SYSZ_INS_VMOB,
            2082 => sysz_insn::SYSZ_INS_VMOF,
            2083 => sysz_insn::SYSZ_INS_VMOH,
            2084 => sysz_insn::SYSZ_INS_VMP,
            2085 => sysz_insn::SYSZ_INS_VMRH,
            2086 => sysz_insn::SYSZ_INS_VMRHB,
            2087 => sysz_insn::SYSZ_INS_VMRHF,
            2088 => sysz_insn::SYSZ_INS_VMRHG,
            2089 => sysz_insn::SYSZ_INS_VMRHH,
            2090 => sysz_insn::SYSZ_INS_VMRL,
            2091 => sysz_insn::SYSZ_INS_VMRLB,
            2092 => sysz_insn::SYSZ_INS_VMRLF,
            2093 => sysz_insn::SYSZ_INS_VMRLG,
            2094 => sysz_insn::SYSZ_INS_VMRLH,
            2095 => sysz_insn::SYSZ_INS_VMSL,
            2096 => sysz_insn::SYSZ_INS_VMSLG,
            2097 => sysz_insn::SYSZ_INS_VMSP,
            2098 => sysz_insn::SYSZ_INS_VMX,
            2099 => sysz_insn::SYSZ_INS_VMXB,
            2100 => sysz_insn::SYSZ_INS_VMXF,
            2101 => sysz_insn::SYSZ_INS_VMXG,
            2102 => sysz_insn::SYSZ_INS_VMXH,
            2103 => sysz_insn::SYSZ_INS_VMXL,
            2104 => sysz_insn::SYSZ_INS_VMXLB,
            2105 => sysz_insn::SYSZ_INS_VMXLF,
            2106 => sysz_insn::SYSZ_INS_VMXLG,
            2107 => sysz_insn::SYSZ_INS_VMXLH,
            2108 => sysz_insn::SYSZ_INS_VN,
            2109 => sysz_insn::SYSZ_INS_VNC,
            2110 => sysz_insn::SYSZ_INS_VNN,
            2111 => sysz_insn::SYSZ_INS_VNO,
            2112 => sysz_insn::SYSZ_INS_VNX,
            2113 => sysz_insn::SYSZ_INS_VO,
            2114 => sysz_insn::SYSZ_INS_VOC,
            2115 => sysz_insn::SYSZ_INS_VONE,
            2116 => sysz_insn::SYSZ_INS_VPDI,
            2117 => sysz_insn::SYSZ_INS_VPERM,
            2118 => sysz_insn::SYSZ_INS_VPK,
            2119 => sysz_insn::SYSZ_INS_VPKF,
            2120 => sysz_insn::SYSZ_INS_VPKG,
            2121 => sysz_insn::SYSZ_INS_VPKH,
            2122 => sysz_insn::SYSZ_INS_VPKLS,
            2123 => sysz_insn::SYSZ_INS_VPKLSF,
            2124 => sysz_insn::SYSZ_INS_VPKLSFS,
            2125 => sysz_insn::SYSZ_INS_VPKLSG,
            2126 => sysz_insn::SYSZ_INS_VPKLSGS,
            2127 => sysz_insn::SYSZ_INS_VPKLSH,
            2128 => sysz_insn::SYSZ_INS_VPKLSHS,
            2129 => sysz_insn::SYSZ_INS_VPKS,
            2130 => sysz_insn::SYSZ_INS_VPKSF,
            2131 => sysz_insn::SYSZ_INS_VPKSFS,
            2132 => sysz_insn::SYSZ_INS_VPKSG,
            2133 => sysz_insn::SYSZ_INS_VPKSGS,
            2134 => sysz_insn::SYSZ_INS_VPKSH,
            2135 => sysz_insn::SYSZ_INS_VPKSHS,
            2136 => sysz_insn::SYSZ_INS_VPKZ,
            2137 => sysz_insn::SYSZ_INS_VPOPCT,
            2138 => sysz_insn::SYSZ_INS_VPOPCTB,
            2139 => sysz_insn::SYSZ_INS_VPOPCTF,
            2140 => sysz_insn::SYSZ_INS_VPOPCTG,
            2141 => sysz_insn::SYSZ_INS_VPOPCTH,
            2142 => sysz_insn::SYSZ_INS_VPSOP,
            2143 => sysz_insn::SYSZ_INS_VREP,
            2144 => sysz_insn::SYSZ_INS_VREPB,
            2145 => sysz_insn::SYSZ_INS_VREPF,
            2146 => sysz_insn::SYSZ_INS_VREPG,
            2147 => sysz_insn::SYSZ_INS_VREPH,
            2148 => sysz_insn::SYSZ_INS_VREPI,
            2149 => sysz_insn::SYSZ_INS_VREPIB,
            2150 => sysz_insn::SYSZ_INS_VREPIF,
            2151 => sysz_insn::SYSZ_INS_VREPIG,
            2152 => sysz_insn::SYSZ_INS_VREPIH,
            2153 => sysz_insn::SYSZ_INS_VRP,
            2154 => sysz_insn::SYSZ_INS_VS,
            2155 => sysz_insn::SYSZ_INS_VSB,
            2156 => sysz_insn::SYSZ_INS_VSBCBI,
            2157 => sysz_insn::SYSZ_INS_VSBCBIQ,
            2158 => sysz_insn::SYSZ_INS_VSBI,
            2159 => sysz_insn::SYSZ_INS_VSBIQ,
            2160 => sysz_insn::SYSZ_INS_VSCBI,
            2161 => sysz_insn::SYSZ_INS_VSCBIB,
            2162 => sysz_insn::SYSZ_INS_VSCBIF,
            2163 => sysz_insn::SYSZ_INS_VSCBIG,
            2164 => sysz_insn::SYSZ_INS_VSCBIH,
            2165 => sysz_insn::SYSZ_INS_VSCBIQ,
            2166 => sysz_insn::SYSZ_INS_VSCEF,
            2167 => sysz_insn::SYSZ_INS_VSCEG,
            2168 => sysz_insn::SYSZ_INS_VSDP,
            2169 => sysz_insn::SYSZ_INS_VSEG,
            2170 => sysz_insn::SYSZ_INS_VSEGB,
            2171 => sysz_insn::SYSZ_INS_VSEGF,
            2172 => sysz_insn::SYSZ_INS_VSEGH,
            2173 => sysz_insn::SYSZ_INS_VSEL,
            2174 => sysz_insn::SYSZ_INS_VSF,
            2175 => sysz_insn::SYSZ_INS_VSG,
            2176 => sysz_insn::SYSZ_INS_VSH,
            2177 => sysz_insn::SYSZ_INS_VSL,
            2178 => sysz_insn::SYSZ_INS_VSLB,
            2179 => sysz_insn::SYSZ_INS_VSLDB,
            2180 => sysz_insn::SYSZ_INS_VSP,
            2181 => sysz_insn::SYSZ_INS_VSQ,
            2182 => sysz_insn::SYSZ_INS_VSRA,
            2183 => sysz_insn::SYSZ_INS_VSRAB,
            2184 => sysz_insn::SYSZ_INS_VSRL,
            2185 => sysz_insn::SYSZ_INS_VSRLB,
            2186 => sysz_insn::SYSZ_INS_VSRP,
            2187 => sysz_insn::SYSZ_INS_VST,
            2188 => sysz_insn::SYSZ_INS_VSTEB,
            2189 => sysz_insn::SYSZ_INS_VSTEF,
            2190 => sysz_insn::SYSZ_INS_VSTEG,
            2191 => sysz_insn::SYSZ_INS_VSTEH,
            2192 => sysz_insn::SYSZ_INS_VSTL,
            2193 => sysz_insn::SYSZ_INS_VSTM,
            2194 => sysz_insn::SYSZ_INS_VSTRC,
            2195 => sysz_insn::SYSZ_INS_VSTRCB,
            2196 => sysz_insn::SYSZ_INS_VSTRCBS,
            2197 => sysz_insn::SYSZ_INS_VSTRCF,
            2198 => sysz_insn::SYSZ_INS_VSTRCFS,
            2199 => sysz_insn::SYSZ_INS_VSTRCH,
            2200 => sysz_insn::SYSZ_INS_VSTRCHS,
            2201 => sysz_insn::SYSZ_INS_VSTRCZB,
            2202 => sysz_insn::SYSZ_INS_VSTRCZBS,
            2203 => sysz_insn::SYSZ_INS_VSTRCZF,
            2204 => sysz_insn::SYSZ_INS_VSTRCZFS,
            2205 => sysz_insn::SYSZ_INS_VSTRCZH,
            2206 => sysz_insn::SYSZ_INS_VSTRCZHS,
            2207 => sysz_insn::SYSZ_INS_VSTRL,
            2208 => sysz_insn::SYSZ_INS_VSTRLR,
            2209 => sysz_insn::SYSZ_INS_VSUM,
            2210 => sysz_insn::SYSZ_INS_VSUMB,
            2211 => sysz_insn::SYSZ_INS_VSUMG,
            2212 => sysz_insn::SYSZ_INS_VSUMGF,
            2213 => sysz_insn::SYSZ_INS_VSUMGH,
            2214 => sysz_insn::SYSZ_INS_VSUMH,
            2215 => sysz_insn::SYSZ_INS_VSUMQ,
            2216 => sysz_insn::SYSZ_INS_VSUMQF,
            2217 => sysz_insn::SYSZ_INS_VSUMQG,
            2218 => sysz_insn::SYSZ_INS_VTM,
            2219 => sysz_insn::SYSZ_INS_VTP,
            2220 => sysz_insn::SYSZ_INS_VUPH,
            2221 => sysz_insn::SYSZ_INS_VUPHB,
            2222 => sysz_insn::SYSZ_INS_VUPHF,
            2223 => sysz_insn::SYSZ_INS_VUPHH,
            2224 => sysz_insn::SYSZ_INS_VUPKZ,
            2225 => sysz_insn::SYSZ_INS_VUPL,
            2226 => sysz_insn::SYSZ_INS_VUPLB,
            2227 => sysz_insn::SYSZ_INS_VUPLF,
            2228 => sysz_insn::SYSZ_INS_VUPLH,
            2229 => sysz_insn::SYSZ_INS_VUPLHB,
            2230 => sysz_insn::SYSZ_INS_VUPLHF,
            2231 => sysz_insn::SYSZ_INS_VUPLHH,
            2232 => sysz_insn::SYSZ_INS_VUPLHW,
            2233 => sysz_insn::SYSZ_INS_VUPLL,
            2234 => sysz_insn::SYSZ_INS_VUPLLB,
            2235 => sysz_insn::SYSZ_INS_VUPLLF,
            2236 => sysz_insn::SYSZ_INS_VUPLLH,
            2237 => sysz_insn::SYSZ_INS_VX,
            2238 => sysz_insn::SYSZ_INS_VZERO,
            2239 => sysz_insn::SYSZ_INS_WCDGB,
            2240 => sysz_insn::SYSZ_INS_WCDLGB,
            2241 => sysz_insn::SYSZ_INS_WCGDB,
            2242 => sysz_insn::SYSZ_INS_WCLGDB,
            2243 => sysz_insn::SYSZ_INS_WFADB,
            2244 => sysz_insn::SYSZ_INS_WFASB,
            2245 => sysz_insn::SYSZ_INS_WFAXB,
            2246 => sysz_insn::SYSZ_INS_WFC,
            2247 => sysz_insn::SYSZ_INS_WFCDB,
            2248 => sysz_insn::SYSZ_INS_WFCEDB,
            2249 => sysz_insn::SYSZ_INS_WFCEDBS,
            2250 => sysz_insn::SYSZ_INS_WFCESB,
            2251 => sysz_insn::SYSZ_INS_WFCESBS,
            2252 => sysz_insn::SYSZ_INS_WFCEXB,
            2253 => sysz_insn::SYSZ_INS_WFCEXBS,
            2254 => sysz_insn::SYSZ_INS_WFCHDB,
            2255 => sysz_insn::SYSZ_INS_WFCHDBS,
            2256 => sysz_insn::SYSZ_INS_WFCHEDB,
            2257 => sysz_insn::SYSZ_INS_WFCHEDBS,
            2258 => sysz_insn::SYSZ_INS_WFCHESB,
            2259 => sysz_insn::SYSZ_INS_WFCHESBS,
            2260 => sysz_insn::SYSZ_INS_WFCHEXB,
            2261 => sysz_insn::SYSZ_INS_WFCHEXBS,
            2262 => sysz_insn::SYSZ_INS_WFCHSB,
            2263 => sysz_insn::SYSZ_INS_WFCHSBS,
            2264 => sysz_insn::SYSZ_INS_WFCHXB,
            2265 => sysz_insn::SYSZ_INS_WFCHXBS,
            2266 => sysz_insn::SYSZ_INS_WFCSB,
            2267 => sysz_insn::SYSZ_INS_WFCXB,
            2268 => sysz_insn::SYSZ_INS_WFDDB,
            2269 => sysz_insn::SYSZ_INS_WFDSB,
            2270 => sysz_insn::SYSZ_INS_WFDXB,
            2271 => sysz_insn::SYSZ_INS_WFIDB,
            2272 => sysz_insn::SYSZ_INS_WFISB,
            2273 => sysz_insn::SYSZ_INS_WFIXB,
            2274 => sysz_insn::SYSZ_INS_WFK,
            2275 => sysz_insn::SYSZ_INS_WFKDB,
            2276 => sysz_insn::SYSZ_INS_WFKEDB,
            2277 => sysz_insn::SYSZ_INS_WFKEDBS,
            2278 => sysz_insn::SYSZ_INS_WFKESB,
            2279 => sysz_insn::SYSZ_INS_WFKESBS,
            2280 => sysz_insn::SYSZ_INS_WFKEXB,
            2281 => sysz_insn::SYSZ_INS_WFKEXBS,
            2282 => sysz_insn::SYSZ_INS_WFKHDB,
            2283 => sysz_insn::SYSZ_INS_WFKHDBS,
            2284 => sysz_insn::SYSZ_INS_WFKHEDB,
            2285 => sysz_insn::SYSZ_INS_WFKHEDBS,
            2286 => sysz_insn::SYSZ_INS_WFKHESB,
            2287 => sysz_insn::SYSZ_INS_WFKHESBS,
            2288 => sysz_insn::SYSZ_INS_WFKHEXB,
            2289 => sysz_insn::SYSZ_INS_WFKHEXBS,
            2290 => sysz_insn::SYSZ_INS_WFKHSB,
            2291 => sysz_insn::SYSZ_INS_WFKHSBS,
            2292 => sysz_insn::SYSZ_INS_WFKHXB,
            2293 => sysz_insn::SYSZ_INS_WFKHXBS,
            2294 => sysz_insn::SYSZ_INS_WFKSB,
            2295 => sysz_insn::SYSZ_INS_WFKXB,
            2296 => sysz_insn::SYSZ_INS_WFLCDB,
            2297 => sysz_insn::SYSZ_INS_WFLCSB,
            2298 => sysz_insn::SYSZ_INS_WFLCXB,
            2299 => sysz_insn::SYSZ_INS_WFLLD,
            2300 => sysz_insn::SYSZ_INS_WFLLS,
            2301 => sysz_insn::SYSZ_INS_WFLNDB,
            2302 => sysz_insn::SYSZ_INS_WFLNSB,
            2303 => sysz_insn::SYSZ_INS_WFLNXB,
            2304 => sysz_insn::SYSZ_INS_WFLPDB,
            2305 => sysz_insn::SYSZ_INS_WFLPSB,
            2306 => sysz_insn::SYSZ_INS_WFLPXB,
            2307 => sysz_insn::SYSZ_INS_WFLRD,
            2308 => sysz_insn::SYSZ_INS_WFLRX,
            2309 => sysz_insn::SYSZ_INS_WFMADB,
            2310 => sysz_insn::SYSZ_INS_WFMASB,
            2311 => sysz_insn::SYSZ_INS_WFMAXB,
            2312 => sysz_insn::SYSZ_INS_WFMAXDB,
            2313 => sysz_insn::SYSZ_INS_WFMAXSB,
            2314 => sysz_insn::SYSZ_INS_WFMAXXB,
            2315 => sysz_insn::SYSZ_INS_WFMDB,
            2316 => sysz_insn::SYSZ_INS_WFMINDB,
            2317 => sysz_insn::SYSZ_INS_WFMINSB,
            2318 => sysz_insn::SYSZ_INS_WFMINXB,
            2319 => sysz_insn::SYSZ_INS_WFMSB,
            2320 => sysz_insn::SYSZ_INS_WFMSDB,
            2321 => sysz_insn::SYSZ_INS_WFMSSB,
            2322 => sysz_insn::SYSZ_INS_WFMSXB,
            2323 => sysz_insn::SYSZ_INS_WFMXB,
            2324 => sysz_insn::SYSZ_INS_WFNMADB,
            2325 => sysz_insn::SYSZ_INS_WFNMASB,
            2326 => sysz_insn::SYSZ_INS_WFNMAXB,
            2327 => sysz_insn::SYSZ_INS_WFNMSDB,
            2328 => sysz_insn::SYSZ_INS_WFNMSSB,
            2329 => sysz_insn::SYSZ_INS_WFNMSXB,
            2330 => sysz_insn::SYSZ_INS_WFPSODB,
            2331 => sysz_insn::SYSZ_INS_WFPSOSB,
            2332 => sysz_insn::SYSZ_INS_WFPSOXB,
            2333 => sysz_insn::SYSZ_INS_WFSDB,
            2334 => sysz_insn::SYSZ_INS_WFSQDB,
            2335 => sysz_insn::SYSZ_INS_WFSQSB,
            2336 => sysz_insn::SYSZ_INS_WFSQXB,
            2337 => sysz_insn::SYSZ_INS_WFSSB,
            2338 => sysz_insn::SYSZ_INS_WFSXB,
            2339 => sysz_insn::SYSZ_INS_WFTCIDB,
            2340 => sysz_insn::SYSZ_INS_WFTCISB,
            2341 => sysz_insn::SYSZ_INS_WFTCIXB,
            2342 => sysz_insn::SYSZ_INS_WLDEB,
            2343 => sysz_insn::SYSZ_INS_WLEDB,
            2344 => sysz_insn::SYSZ_INS_XSCH,
            2345 => sysz_insn::SYSZ_INS_ZAP,
            2346 => sysz_insn::SYSZ_INS_ENDING,
            _ => sysz_insn::SYSZ_INS_INVALID,
        }
    }
}
impl From<u32> for tms320c64x_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => tms320c64x_insn::TMS320C64X_INS_INVALID,
            1 => tms320c64x_insn::TMS320C64X_INS_ABS,
            2 => tms320c64x_insn::TMS320C64X_INS_ABS2,
            3 => tms320c64x_insn::TMS320C64X_INS_ADD,
            4 => tms320c64x_insn::TMS320C64X_INS_ADD2,
            5 => tms320c64x_insn::TMS320C64X_INS_ADD4,
            6 => tms320c64x_insn::TMS320C64X_INS_ADDAB,
            7 => tms320c64x_insn::TMS320C64X_INS_ADDAD,
            8 => tms320c64x_insn::TMS320C64X_INS_ADDAH,
            9 => tms320c64x_insn::TMS320C64X_INS_ADDAW,
            10 => tms320c64x_insn::TMS320C64X_INS_ADDK,
            11 => tms320c64x_insn::TMS320C64X_INS_ADDKPC,
            12 => tms320c64x_insn::TMS320C64X_INS_ADDU,
            13 => tms320c64x_insn::TMS320C64X_INS_AND,
            14 => tms320c64x_insn::TMS320C64X_INS_ANDN,
            15 => tms320c64x_insn::TMS320C64X_INS_AVG2,
            16 => tms320c64x_insn::TMS320C64X_INS_AVGU4,
            17 => tms320c64x_insn::TMS320C64X_INS_B,
            18 => tms320c64x_insn::TMS320C64X_INS_BDEC,
            19 => tms320c64x_insn::TMS320C64X_INS_BITC4,
            20 => tms320c64x_insn::TMS320C64X_INS_BNOP,
            21 => tms320c64x_insn::TMS320C64X_INS_BPOS,
            22 => tms320c64x_insn::TMS320C64X_INS_CLR,
            23 => tms320c64x_insn::TMS320C64X_INS_CMPEQ,
            24 => tms320c64x_insn::TMS320C64X_INS_CMPEQ2,
            25 => tms320c64x_insn::TMS320C64X_INS_CMPEQ4,
            26 => tms320c64x_insn::TMS320C64X_INS_CMPGT,
            27 => tms320c64x_insn::TMS320C64X_INS_CMPGT2,
            28 => tms320c64x_insn::TMS320C64X_INS_CMPGTU4,
            29 => tms320c64x_insn::TMS320C64X_INS_CMPLT,
            30 => tms320c64x_insn::TMS320C64X_INS_CMPLTU,
            31 => tms320c64x_insn::TMS320C64X_INS_DEAL,
            32 => tms320c64x_insn::TMS320C64X_INS_DOTP2,
            33 => tms320c64x_insn::TMS320C64X_INS_DOTPN2,
            34 => tms320c64x_insn::TMS320C64X_INS_DOTPNRSU2,
            35 => tms320c64x_insn::TMS320C64X_INS_DOTPRSU2,
            36 => tms320c64x_insn::TMS320C64X_INS_DOTPSU4,
            37 => tms320c64x_insn::TMS320C64X_INS_DOTPU4,
            38 => tms320c64x_insn::TMS320C64X_INS_EXT,
            39 => tms320c64x_insn::TMS320C64X_INS_EXTU,
            40 => tms320c64x_insn::TMS320C64X_INS_GMPGTU,
            41 => tms320c64x_insn::TMS320C64X_INS_GMPY4,
            42 => tms320c64x_insn::TMS320C64X_INS_LDB,
            43 => tms320c64x_insn::TMS320C64X_INS_LDBU,
            44 => tms320c64x_insn::TMS320C64X_INS_LDDW,
            45 => tms320c64x_insn::TMS320C64X_INS_LDH,
            46 => tms320c64x_insn::TMS320C64X_INS_LDHU,
            47 => tms320c64x_insn::TMS320C64X_INS_LDNDW,
            48 => tms320c64x_insn::TMS320C64X_INS_LDNW,
            49 => tms320c64x_insn::TMS320C64X_INS_LDW,
            50 => tms320c64x_insn::TMS320C64X_INS_LMBD,
            51 => tms320c64x_insn::TMS320C64X_INS_MAX2,
            52 => tms320c64x_insn::TMS320C64X_INS_MAXU4,
            53 => tms320c64x_insn::TMS320C64X_INS_MIN2,
            54 => tms320c64x_insn::TMS320C64X_INS_MINU4,
            55 => tms320c64x_insn::TMS320C64X_INS_MPY,
            56 => tms320c64x_insn::TMS320C64X_INS_MPY2,
            57 => tms320c64x_insn::TMS320C64X_INS_MPYH,
            58 => tms320c64x_insn::TMS320C64X_INS_MPYHI,
            59 => tms320c64x_insn::TMS320C64X_INS_MPYHIR,
            60 => tms320c64x_insn::TMS320C64X_INS_MPYHL,
            61 => tms320c64x_insn::TMS320C64X_INS_MPYHLU,
            62 => tms320c64x_insn::TMS320C64X_INS_MPYHSLU,
            63 => tms320c64x_insn::TMS320C64X_INS_MPYHSU,
            64 => tms320c64x_insn::TMS320C64X_INS_MPYHU,
            65 => tms320c64x_insn::TMS320C64X_INS_MPYHULS,
            66 => tms320c64x_insn::TMS320C64X_INS_MPYHUS,
            67 => tms320c64x_insn::TMS320C64X_INS_MPYLH,
            68 => tms320c64x_insn::TMS320C64X_INS_MPYLHU,
            69 => tms320c64x_insn::TMS320C64X_INS_MPYLI,
            70 => tms320c64x_insn::TMS320C64X_INS_MPYLIR,
            71 => tms320c64x_insn::TMS320C64X_INS_MPYLSHU,
            72 => tms320c64x_insn::TMS320C64X_INS_MPYLUHS,
            73 => tms320c64x_insn::TMS320C64X_INS_MPYSU,
            74 => tms320c64x_insn::TMS320C64X_INS_MPYSU4,
            75 => tms320c64x_insn::TMS320C64X_INS_MPYU,
            76 => tms320c64x_insn::TMS320C64X_INS_MPYU4,
            77 => tms320c64x_insn::TMS320C64X_INS_MPYUS,
            78 => tms320c64x_insn::TMS320C64X_INS_MVC,
            79 => tms320c64x_insn::TMS320C64X_INS_MVD,
            80 => tms320c64x_insn::TMS320C64X_INS_MVK,
            81 => tms320c64x_insn::TMS320C64X_INS_MVKL,
            82 => tms320c64x_insn::TMS320C64X_INS_MVKLH,
            83 => tms320c64x_insn::TMS320C64X_INS_NOP,
            84 => tms320c64x_insn::TMS320C64X_INS_NORM,
            85 => tms320c64x_insn::TMS320C64X_INS_OR,
            86 => tms320c64x_insn::TMS320C64X_INS_PACK2,
            87 => tms320c64x_insn::TMS320C64X_INS_PACKH2,
            88 => tms320c64x_insn::TMS320C64X_INS_PACKH4,
            89 => tms320c64x_insn::TMS320C64X_INS_PACKHL2,
            90 => tms320c64x_insn::TMS320C64X_INS_PACKL4,
            91 => tms320c64x_insn::TMS320C64X_INS_PACKLH2,
            92 => tms320c64x_insn::TMS320C64X_INS_ROTL,
            93 => tms320c64x_insn::TMS320C64X_INS_SADD,
            94 => tms320c64x_insn::TMS320C64X_INS_SADD2,
            95 => tms320c64x_insn::TMS320C64X_INS_SADDU4,
            96 => tms320c64x_insn::TMS320C64X_INS_SADDUS2,
            97 => tms320c64x_insn::TMS320C64X_INS_SAT,
            98 => tms320c64x_insn::TMS320C64X_INS_SET,
            99 => tms320c64x_insn::TMS320C64X_INS_SHFL,
            100 => tms320c64x_insn::TMS320C64X_INS_SHL,
            101 => tms320c64x_insn::TMS320C64X_INS_SHLMB,
            102 => tms320c64x_insn::TMS320C64X_INS_SHR,
            103 => tms320c64x_insn::TMS320C64X_INS_SHR2,
            104 => tms320c64x_insn::TMS320C64X_INS_SHRMB,
            105 => tms320c64x_insn::TMS320C64X_INS_SHRU,
            106 => tms320c64x_insn::TMS320C64X_INS_SHRU2,
            107 => tms320c64x_insn::TMS320C64X_INS_SMPY,
            108 => tms320c64x_insn::TMS320C64X_INS_SMPY2,
            109 => tms320c64x_insn::TMS320C64X_INS_SMPYH,
            110 => tms320c64x_insn::TMS320C64X_INS_SMPYHL,
            111 => tms320c64x_insn::TMS320C64X_INS_SMPYLH,
            112 => tms320c64x_insn::TMS320C64X_INS_SPACK2,
            113 => tms320c64x_insn::TMS320C64X_INS_SPACKU4,
            114 => tms320c64x_insn::TMS320C64X_INS_SSHL,
            115 => tms320c64x_insn::TMS320C64X_INS_SSHVL,
            116 => tms320c64x_insn::TMS320C64X_INS_SSHVR,
            117 => tms320c64x_insn::TMS320C64X_INS_SSUB,
            118 => tms320c64x_insn::TMS320C64X_INS_STB,
            119 => tms320c64x_insn::TMS320C64X_INS_STDW,
            120 => tms320c64x_insn::TMS320C64X_INS_STH,
            121 => tms320c64x_insn::TMS320C64X_INS_STNDW,
            122 => tms320c64x_insn::TMS320C64X_INS_STNW,
            123 => tms320c64x_insn::TMS320C64X_INS_STW,
            124 => tms320c64x_insn::TMS320C64X_INS_SUB,
            125 => tms320c64x_insn::TMS320C64X_INS_SUB2,
            126 => tms320c64x_insn::TMS320C64X_INS_SUB4,
            127 => tms320c64x_insn::TMS320C64X_INS_SUBAB,
            128 => tms320c64x_insn::TMS320C64X_INS_SUBABS4,
            129 => tms320c64x_insn::TMS320C64X_INS_SUBAH,
            130 => tms320c64x_insn::TMS320C64X_INS_SUBAW,
            131 => tms320c64x_insn::TMS320C64X_INS_SUBC,
            132 => tms320c64x_insn::TMS320C64X_INS_SUBU,
            133 => tms320c64x_insn::TMS320C64X_INS_SWAP4,
            134 => tms320c64x_insn::TMS320C64X_INS_UNPKHU4,
            135 => tms320c64x_insn::TMS320C64X_INS_UNPKLU4,
            136 => tms320c64x_insn::TMS320C64X_INS_XOR,
            137 => tms320c64x_insn::TMS320C64X_INS_XPND2,
            138 => tms320c64x_insn::TMS320C64X_INS_XPND4,
            139 => tms320c64x_insn::TMS320C64X_INS_IDLE,
            140 => tms320c64x_insn::TMS320C64X_INS_MV,
            141 => tms320c64x_insn::TMS320C64X_INS_NEG,
            142 => tms320c64x_insn::TMS320C64X_INS_NOT,
            143 => tms320c64x_insn::TMS320C64X_INS_SWAP2,
            144 => tms320c64x_insn::TMS320C64X_INS_ZERO,
            145 => tms320c64x_insn::TMS320C64X_INS_ENDING,
            _ => tms320c64x_insn::TMS320C64X_INS_INVALID,
        }
    }
}
impl From<u32> for x86_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => x86_insn::X86_INS_INVALID,
            1 => x86_insn::X86_INS_AAA,
            2 => x86_insn::X86_INS_AAD,
            3 => x86_insn::X86_INS_AAM,
            4 => x86_insn::X86_INS_AAS,
            5 => x86_insn::X86_INS_FABS,
            6 => x86_insn::X86_INS_ADC,
            7 => x86_insn::X86_INS_ADCX,
            8 => x86_insn::X86_INS_ADD,
            9 => x86_insn::X86_INS_ADDPD,
            10 => x86_insn::X86_INS_ADDPS,
            11 => x86_insn::X86_INS_ADDSD,
            12 => x86_insn::X86_INS_ADDSS,
            13 => x86_insn::X86_INS_ADDSUBPD,
            14 => x86_insn::X86_INS_ADDSUBPS,
            15 => x86_insn::X86_INS_FADD,
            16 => x86_insn::X86_INS_FIADD,
            17 => x86_insn::X86_INS_ADOX,
            18 => x86_insn::X86_INS_AESDECLAST,
            19 => x86_insn::X86_INS_AESDEC,
            20 => x86_insn::X86_INS_AESENCLAST,
            21 => x86_insn::X86_INS_AESENC,
            22 => x86_insn::X86_INS_AESIMC,
            23 => x86_insn::X86_INS_AESKEYGENASSIST,
            24 => x86_insn::X86_INS_AND,
            25 => x86_insn::X86_INS_ANDN,
            26 => x86_insn::X86_INS_ANDNPD,
            27 => x86_insn::X86_INS_ANDNPS,
            28 => x86_insn::X86_INS_ANDPD,
            29 => x86_insn::X86_INS_ANDPS,
            30 => x86_insn::X86_INS_ARPL,
            31 => x86_insn::X86_INS_BEXTR,
            32 => x86_insn::X86_INS_BLCFILL,
            33 => x86_insn::X86_INS_BLCI,
            34 => x86_insn::X86_INS_BLCIC,
            35 => x86_insn::X86_INS_BLCMSK,
            36 => x86_insn::X86_INS_BLCS,
            37 => x86_insn::X86_INS_BLENDPD,
            38 => x86_insn::X86_INS_BLENDPS,
            39 => x86_insn::X86_INS_BLENDVPD,
            40 => x86_insn::X86_INS_BLENDVPS,
            41 => x86_insn::X86_INS_BLSFILL,
            42 => x86_insn::X86_INS_BLSI,
            43 => x86_insn::X86_INS_BLSIC,
            44 => x86_insn::X86_INS_BLSMSK,
            45 => x86_insn::X86_INS_BLSR,
            46 => x86_insn::X86_INS_BNDCL,
            47 => x86_insn::X86_INS_BNDCN,
            48 => x86_insn::X86_INS_BNDCU,
            49 => x86_insn::X86_INS_BNDLDX,
            50 => x86_insn::X86_INS_BNDMK,
            51 => x86_insn::X86_INS_BNDMOV,
            52 => x86_insn::X86_INS_BNDSTX,
            53 => x86_insn::X86_INS_BOUND,
            54 => x86_insn::X86_INS_BSF,
            55 => x86_insn::X86_INS_BSR,
            56 => x86_insn::X86_INS_BSWAP,
            57 => x86_insn::X86_INS_BT,
            58 => x86_insn::X86_INS_BTC,
            59 => x86_insn::X86_INS_BTR,
            60 => x86_insn::X86_INS_BTS,
            61 => x86_insn::X86_INS_BZHI,
            62 => x86_insn::X86_INS_CALL,
            63 => x86_insn::X86_INS_CBW,
            64 => x86_insn::X86_INS_CDQ,
            65 => x86_insn::X86_INS_CDQE,
            66 => x86_insn::X86_INS_FCHS,
            67 => x86_insn::X86_INS_CLAC,
            68 => x86_insn::X86_INS_CLC,
            69 => x86_insn::X86_INS_CLD,
            70 => x86_insn::X86_INS_CLDEMOTE,
            71 => x86_insn::X86_INS_CLFLUSH,
            72 => x86_insn::X86_INS_CLFLUSHOPT,
            73 => x86_insn::X86_INS_CLGI,
            74 => x86_insn::X86_INS_CLI,
            75 => x86_insn::X86_INS_CLRSSBSY,
            76 => x86_insn::X86_INS_CLTS,
            77 => x86_insn::X86_INS_CLWB,
            78 => x86_insn::X86_INS_CLZERO,
            79 => x86_insn::X86_INS_CMC,
            80 => x86_insn::X86_INS_CMOVA,
            81 => x86_insn::X86_INS_CMOVAE,
            82 => x86_insn::X86_INS_CMOVB,
            83 => x86_insn::X86_INS_CMOVBE,
            84 => x86_insn::X86_INS_FCMOVBE,
            85 => x86_insn::X86_INS_FCMOVB,
            86 => x86_insn::X86_INS_CMOVE,
            87 => x86_insn::X86_INS_FCMOVE,
            88 => x86_insn::X86_INS_CMOVG,
            89 => x86_insn::X86_INS_CMOVGE,
            90 => x86_insn::X86_INS_CMOVL,
            91 => x86_insn::X86_INS_CMOVLE,
            92 => x86_insn::X86_INS_FCMOVNBE,
            93 => x86_insn::X86_INS_FCMOVNB,
            94 => x86_insn::X86_INS_CMOVNE,
            95 => x86_insn::X86_INS_FCMOVNE,
            96 => x86_insn::X86_INS_CMOVNO,
            97 => x86_insn::X86_INS_CMOVNP,
            98 => x86_insn::X86_INS_FCMOVNU,
            99 => x86_insn::X86_INS_FCMOVNP,
            100 => x86_insn::X86_INS_CMOVNS,
            101 => x86_insn::X86_INS_CMOVO,
            102 => x86_insn::X86_INS_CMOVP,
            103 => x86_insn::X86_INS_FCMOVU,
            104 => x86_insn::X86_INS_CMOVS,
            105 => x86_insn::X86_INS_CMP,
            106 => x86_insn::X86_INS_CMPPD,
            107 => x86_insn::X86_INS_CMPPS,
            108 => x86_insn::X86_INS_CMPSB,
            109 => x86_insn::X86_INS_CMPSD,
            110 => x86_insn::X86_INS_CMPSQ,
            111 => x86_insn::X86_INS_CMPSS,
            112 => x86_insn::X86_INS_CMPSW,
            113 => x86_insn::X86_INS_CMPXCHG16B,
            114 => x86_insn::X86_INS_CMPXCHG,
            115 => x86_insn::X86_INS_CMPXCHG8B,
            116 => x86_insn::X86_INS_COMISD,
            117 => x86_insn::X86_INS_COMISS,
            118 => x86_insn::X86_INS_FCOMP,
            119 => x86_insn::X86_INS_FCOMPI,
            120 => x86_insn::X86_INS_FCOMI,
            121 => x86_insn::X86_INS_FCOM,
            122 => x86_insn::X86_INS_FCOS,
            123 => x86_insn::X86_INS_CPUID,
            124 => x86_insn::X86_INS_CQO,
            125 => x86_insn::X86_INS_CRC32,
            126 => x86_insn::X86_INS_CVTDQ2PD,
            127 => x86_insn::X86_INS_CVTDQ2PS,
            128 => x86_insn::X86_INS_CVTPD2DQ,
            129 => x86_insn::X86_INS_CVTPD2PS,
            130 => x86_insn::X86_INS_CVTPS2DQ,
            131 => x86_insn::X86_INS_CVTPS2PD,
            132 => x86_insn::X86_INS_CVTSD2SI,
            133 => x86_insn::X86_INS_CVTSD2SS,
            134 => x86_insn::X86_INS_CVTSI2SD,
            135 => x86_insn::X86_INS_CVTSI2SS,
            136 => x86_insn::X86_INS_CVTSS2SD,
            137 => x86_insn::X86_INS_CVTSS2SI,
            138 => x86_insn::X86_INS_CVTTPD2DQ,
            139 => x86_insn::X86_INS_CVTTPS2DQ,
            140 => x86_insn::X86_INS_CVTTSD2SI,
            141 => x86_insn::X86_INS_CVTTSS2SI,
            142 => x86_insn::X86_INS_CWD,
            143 => x86_insn::X86_INS_CWDE,
            144 => x86_insn::X86_INS_DAA,
            145 => x86_insn::X86_INS_DAS,
            146 => x86_insn::X86_INS_DATA16,
            147 => x86_insn::X86_INS_DEC,
            148 => x86_insn::X86_INS_DIV,
            149 => x86_insn::X86_INS_DIVPD,
            150 => x86_insn::X86_INS_DIVPS,
            151 => x86_insn::X86_INS_FDIVR,
            152 => x86_insn::X86_INS_FIDIVR,
            153 => x86_insn::X86_INS_FDIVRP,
            154 => x86_insn::X86_INS_DIVSD,
            155 => x86_insn::X86_INS_DIVSS,
            156 => x86_insn::X86_INS_FDIV,
            157 => x86_insn::X86_INS_FIDIV,
            158 => x86_insn::X86_INS_FDIVP,
            159 => x86_insn::X86_INS_DPPD,
            160 => x86_insn::X86_INS_DPPS,
            161 => x86_insn::X86_INS_ENCLS,
            162 => x86_insn::X86_INS_ENCLU,
            163 => x86_insn::X86_INS_ENCLV,
            164 => x86_insn::X86_INS_ENDBR32,
            165 => x86_insn::X86_INS_ENDBR64,
            166 => x86_insn::X86_INS_ENTER,
            167 => x86_insn::X86_INS_EXTRACTPS,
            168 => x86_insn::X86_INS_EXTRQ,
            169 => x86_insn::X86_INS_F2XM1,
            170 => x86_insn::X86_INS_LCALL,
            171 => x86_insn::X86_INS_LJMP,
            172 => x86_insn::X86_INS_JMP,
            173 => x86_insn::X86_INS_FBLD,
            174 => x86_insn::X86_INS_FBSTP,
            175 => x86_insn::X86_INS_FCOMPP,
            176 => x86_insn::X86_INS_FDECSTP,
            177 => x86_insn::X86_INS_FDISI8087_NOP,
            178 => x86_insn::X86_INS_FEMMS,
            179 => x86_insn::X86_INS_FENI8087_NOP,
            180 => x86_insn::X86_INS_FFREE,
            181 => x86_insn::X86_INS_FFREEP,
            182 => x86_insn::X86_INS_FICOM,
            183 => x86_insn::X86_INS_FICOMP,
            184 => x86_insn::X86_INS_FINCSTP,
            185 => x86_insn::X86_INS_FLDCW,
            186 => x86_insn::X86_INS_FLDENV,
            187 => x86_insn::X86_INS_FLDL2E,
            188 => x86_insn::X86_INS_FLDL2T,
            189 => x86_insn::X86_INS_FLDLG2,
            190 => x86_insn::X86_INS_FLDLN2,
            191 => x86_insn::X86_INS_FLDPI,
            192 => x86_insn::X86_INS_FNCLEX,
            193 => x86_insn::X86_INS_FNINIT,
            194 => x86_insn::X86_INS_FNOP,
            195 => x86_insn::X86_INS_FNSTCW,
            196 => x86_insn::X86_INS_FNSTSW,
            197 => x86_insn::X86_INS_FPATAN,
            198 => x86_insn::X86_INS_FSTPNCE,
            199 => x86_insn::X86_INS_FPREM,
            200 => x86_insn::X86_INS_FPREM1,
            201 => x86_insn::X86_INS_FPTAN,
            202 => x86_insn::X86_INS_FRNDINT,
            203 => x86_insn::X86_INS_FRSTOR,
            204 => x86_insn::X86_INS_FNSAVE,
            205 => x86_insn::X86_INS_FSCALE,
            206 => x86_insn::X86_INS_FSETPM,
            207 => x86_insn::X86_INS_FSINCOS,
            208 => x86_insn::X86_INS_FNSTENV,
            209 => x86_insn::X86_INS_FXAM,
            210 => x86_insn::X86_INS_FXRSTOR,
            211 => x86_insn::X86_INS_FXRSTOR64,
            212 => x86_insn::X86_INS_FXSAVE,
            213 => x86_insn::X86_INS_FXSAVE64,
            214 => x86_insn::X86_INS_FXTRACT,
            215 => x86_insn::X86_INS_FYL2X,
            216 => x86_insn::X86_INS_FYL2XP1,
            217 => x86_insn::X86_INS_GETSEC,
            218 => x86_insn::X86_INS_GF2P8AFFINEINVQB,
            219 => x86_insn::X86_INS_GF2P8AFFINEQB,
            220 => x86_insn::X86_INS_GF2P8MULB,
            221 => x86_insn::X86_INS_HADDPD,
            222 => x86_insn::X86_INS_HADDPS,
            223 => x86_insn::X86_INS_HLT,
            224 => x86_insn::X86_INS_HSUBPD,
            225 => x86_insn::X86_INS_HSUBPS,
            226 => x86_insn::X86_INS_IDIV,
            227 => x86_insn::X86_INS_FILD,
            228 => x86_insn::X86_INS_IMUL,
            229 => x86_insn::X86_INS_IN,
            230 => x86_insn::X86_INS_INC,
            231 => x86_insn::X86_INS_INCSSPD,
            232 => x86_insn::X86_INS_INCSSPQ,
            233 => x86_insn::X86_INS_INSB,
            234 => x86_insn::X86_INS_INSERTPS,
            235 => x86_insn::X86_INS_INSERTQ,
            236 => x86_insn::X86_INS_INSD,
            237 => x86_insn::X86_INS_INSW,
            238 => x86_insn::X86_INS_INT,
            239 => x86_insn::X86_INS_INT1,
            240 => x86_insn::X86_INS_INT3,
            241 => x86_insn::X86_INS_INTO,
            242 => x86_insn::X86_INS_INVD,
            243 => x86_insn::X86_INS_INVEPT,
            244 => x86_insn::X86_INS_INVLPG,
            245 => x86_insn::X86_INS_INVLPGA,
            246 => x86_insn::X86_INS_INVPCID,
            247 => x86_insn::X86_INS_INVVPID,
            248 => x86_insn::X86_INS_IRET,
            249 => x86_insn::X86_INS_IRETD,
            250 => x86_insn::X86_INS_IRETQ,
            251 => x86_insn::X86_INS_FISTTP,
            252 => x86_insn::X86_INS_FIST,
            253 => x86_insn::X86_INS_FISTP,
            254 => x86_insn::X86_INS_JAE,
            255 => x86_insn::X86_INS_JA,
            256 => x86_insn::X86_INS_JBE,
            257 => x86_insn::X86_INS_JB,
            258 => x86_insn::X86_INS_JCXZ,
            259 => x86_insn::X86_INS_JECXZ,
            260 => x86_insn::X86_INS_JE,
            261 => x86_insn::X86_INS_JGE,
            262 => x86_insn::X86_INS_JG,
            263 => x86_insn::X86_INS_JLE,
            264 => x86_insn::X86_INS_JL,
            265 => x86_insn::X86_INS_JNE,
            266 => x86_insn::X86_INS_JNO,
            267 => x86_insn::X86_INS_JNP,
            268 => x86_insn::X86_INS_JNS,
            269 => x86_insn::X86_INS_JO,
            270 => x86_insn::X86_INS_JP,
            271 => x86_insn::X86_INS_JRCXZ,
            272 => x86_insn::X86_INS_JS,
            273 => x86_insn::X86_INS_KADDB,
            274 => x86_insn::X86_INS_KADDD,
            275 => x86_insn::X86_INS_KADDQ,
            276 => x86_insn::X86_INS_KADDW,
            277 => x86_insn::X86_INS_KANDB,
            278 => x86_insn::X86_INS_KANDD,
            279 => x86_insn::X86_INS_KANDNB,
            280 => x86_insn::X86_INS_KANDND,
            281 => x86_insn::X86_INS_KANDNQ,
            282 => x86_insn::X86_INS_KANDNW,
            283 => x86_insn::X86_INS_KANDQ,
            284 => x86_insn::X86_INS_KANDW,
            285 => x86_insn::X86_INS_KMOVB,
            286 => x86_insn::X86_INS_KMOVD,
            287 => x86_insn::X86_INS_KMOVQ,
            288 => x86_insn::X86_INS_KMOVW,
            289 => x86_insn::X86_INS_KNOTB,
            290 => x86_insn::X86_INS_KNOTD,
            291 => x86_insn::X86_INS_KNOTQ,
            292 => x86_insn::X86_INS_KNOTW,
            293 => x86_insn::X86_INS_KORB,
            294 => x86_insn::X86_INS_KORD,
            295 => x86_insn::X86_INS_KORQ,
            296 => x86_insn::X86_INS_KORTESTB,
            297 => x86_insn::X86_INS_KORTESTD,
            298 => x86_insn::X86_INS_KORTESTQ,
            299 => x86_insn::X86_INS_KORTESTW,
            300 => x86_insn::X86_INS_KORW,
            301 => x86_insn::X86_INS_KSHIFTLB,
            302 => x86_insn::X86_INS_KSHIFTLD,
            303 => x86_insn::X86_INS_KSHIFTLQ,
            304 => x86_insn::X86_INS_KSHIFTLW,
            305 => x86_insn::X86_INS_KSHIFTRB,
            306 => x86_insn::X86_INS_KSHIFTRD,
            307 => x86_insn::X86_INS_KSHIFTRQ,
            308 => x86_insn::X86_INS_KSHIFTRW,
            309 => x86_insn::X86_INS_KTESTB,
            310 => x86_insn::X86_INS_KTESTD,
            311 => x86_insn::X86_INS_KTESTQ,
            312 => x86_insn::X86_INS_KTESTW,
            313 => x86_insn::X86_INS_KUNPCKBW,
            314 => x86_insn::X86_INS_KUNPCKDQ,
            315 => x86_insn::X86_INS_KUNPCKWD,
            316 => x86_insn::X86_INS_KXNORB,
            317 => x86_insn::X86_INS_KXNORD,
            318 => x86_insn::X86_INS_KXNORQ,
            319 => x86_insn::X86_INS_KXNORW,
            320 => x86_insn::X86_INS_KXORB,
            321 => x86_insn::X86_INS_KXORD,
            322 => x86_insn::X86_INS_KXORQ,
            323 => x86_insn::X86_INS_KXORW,
            324 => x86_insn::X86_INS_LAHF,
            325 => x86_insn::X86_INS_LAR,
            326 => x86_insn::X86_INS_LDDQU,
            327 => x86_insn::X86_INS_LDMXCSR,
            328 => x86_insn::X86_INS_LDS,
            329 => x86_insn::X86_INS_FLDZ,
            330 => x86_insn::X86_INS_FLD1,
            331 => x86_insn::X86_INS_FLD,
            332 => x86_insn::X86_INS_LEA,
            333 => x86_insn::X86_INS_LEAVE,
            334 => x86_insn::X86_INS_LES,
            335 => x86_insn::X86_INS_LFENCE,
            336 => x86_insn::X86_INS_LFS,
            337 => x86_insn::X86_INS_LGDT,
            338 => x86_insn::X86_INS_LGS,
            339 => x86_insn::X86_INS_LIDT,
            340 => x86_insn::X86_INS_LLDT,
            341 => x86_insn::X86_INS_LLWPCB,
            342 => x86_insn::X86_INS_LMSW,
            343 => x86_insn::X86_INS_LOCK,
            344 => x86_insn::X86_INS_LODSB,
            345 => x86_insn::X86_INS_LODSD,
            346 => x86_insn::X86_INS_LODSQ,
            347 => x86_insn::X86_INS_LODSW,
            348 => x86_insn::X86_INS_LOOP,
            349 => x86_insn::X86_INS_LOOPE,
            350 => x86_insn::X86_INS_LOOPNE,
            351 => x86_insn::X86_INS_RETF,
            352 => x86_insn::X86_INS_RETFQ,
            353 => x86_insn::X86_INS_LSL,
            354 => x86_insn::X86_INS_LSS,
            355 => x86_insn::X86_INS_LTR,
            356 => x86_insn::X86_INS_LWPINS,
            357 => x86_insn::X86_INS_LWPVAL,
            358 => x86_insn::X86_INS_LZCNT,
            359 => x86_insn::X86_INS_MASKMOVDQU,
            360 => x86_insn::X86_INS_MAXPD,
            361 => x86_insn::X86_INS_MAXPS,
            362 => x86_insn::X86_INS_MAXSD,
            363 => x86_insn::X86_INS_MAXSS,
            364 => x86_insn::X86_INS_MFENCE,
            365 => x86_insn::X86_INS_MINPD,
            366 => x86_insn::X86_INS_MINPS,
            367 => x86_insn::X86_INS_MINSD,
            368 => x86_insn::X86_INS_MINSS,
            369 => x86_insn::X86_INS_CVTPD2PI,
            370 => x86_insn::X86_INS_CVTPI2PD,
            371 => x86_insn::X86_INS_CVTPI2PS,
            372 => x86_insn::X86_INS_CVTPS2PI,
            373 => x86_insn::X86_INS_CVTTPD2PI,
            374 => x86_insn::X86_INS_CVTTPS2PI,
            375 => x86_insn::X86_INS_EMMS,
            376 => x86_insn::X86_INS_MASKMOVQ,
            377 => x86_insn::X86_INS_MOVD,
            378 => x86_insn::X86_INS_MOVQ,
            379 => x86_insn::X86_INS_MOVDQ2Q,
            380 => x86_insn::X86_INS_MOVNTQ,
            381 => x86_insn::X86_INS_MOVQ2DQ,
            382 => x86_insn::X86_INS_PABSB,
            383 => x86_insn::X86_INS_PABSD,
            384 => x86_insn::X86_INS_PABSW,
            385 => x86_insn::X86_INS_PACKSSDW,
            386 => x86_insn::X86_INS_PACKSSWB,
            387 => x86_insn::X86_INS_PACKUSWB,
            388 => x86_insn::X86_INS_PADDB,
            389 => x86_insn::X86_INS_PADDD,
            390 => x86_insn::X86_INS_PADDQ,
            391 => x86_insn::X86_INS_PADDSB,
            392 => x86_insn::X86_INS_PADDSW,
            393 => x86_insn::X86_INS_PADDUSB,
            394 => x86_insn::X86_INS_PADDUSW,
            395 => x86_insn::X86_INS_PADDW,
            396 => x86_insn::X86_INS_PALIGNR,
            397 => x86_insn::X86_INS_PANDN,
            398 => x86_insn::X86_INS_PAND,
            399 => x86_insn::X86_INS_PAVGB,
            400 => x86_insn::X86_INS_PAVGW,
            401 => x86_insn::X86_INS_PCMPEQB,
            402 => x86_insn::X86_INS_PCMPEQD,
            403 => x86_insn::X86_INS_PCMPEQW,
            404 => x86_insn::X86_INS_PCMPGTB,
            405 => x86_insn::X86_INS_PCMPGTD,
            406 => x86_insn::X86_INS_PCMPGTW,
            407 => x86_insn::X86_INS_PEXTRW,
            408 => x86_insn::X86_INS_PHADDD,
            409 => x86_insn::X86_INS_PHADDSW,
            410 => x86_insn::X86_INS_PHADDW,
            411 => x86_insn::X86_INS_PHSUBD,
            412 => x86_insn::X86_INS_PHSUBSW,
            413 => x86_insn::X86_INS_PHSUBW,
            414 => x86_insn::X86_INS_PINSRW,
            415 => x86_insn::X86_INS_PMADDUBSW,
            416 => x86_insn::X86_INS_PMADDWD,
            417 => x86_insn::X86_INS_PMAXSW,
            418 => x86_insn::X86_INS_PMAXUB,
            419 => x86_insn::X86_INS_PMINSW,
            420 => x86_insn::X86_INS_PMINUB,
            421 => x86_insn::X86_INS_PMOVMSKB,
            422 => x86_insn::X86_INS_PMULHRSW,
            423 => x86_insn::X86_INS_PMULHUW,
            424 => x86_insn::X86_INS_PMULHW,
            425 => x86_insn::X86_INS_PMULLW,
            426 => x86_insn::X86_INS_PMULUDQ,
            427 => x86_insn::X86_INS_POR,
            428 => x86_insn::X86_INS_PSADBW,
            429 => x86_insn::X86_INS_PSHUFB,
            430 => x86_insn::X86_INS_PSHUFW,
            431 => x86_insn::X86_INS_PSIGNB,
            432 => x86_insn::X86_INS_PSIGND,
            433 => x86_insn::X86_INS_PSIGNW,
            434 => x86_insn::X86_INS_PSLLD,
            435 => x86_insn::X86_INS_PSLLQ,
            436 => x86_insn::X86_INS_PSLLW,
            437 => x86_insn::X86_INS_PSRAD,
            438 => x86_insn::X86_INS_PSRAW,
            439 => x86_insn::X86_INS_PSRLD,
            440 => x86_insn::X86_INS_PSRLQ,
            441 => x86_insn::X86_INS_PSRLW,
            442 => x86_insn::X86_INS_PSUBB,
            443 => x86_insn::X86_INS_PSUBD,
            444 => x86_insn::X86_INS_PSUBQ,
            445 => x86_insn::X86_INS_PSUBSB,
            446 => x86_insn::X86_INS_PSUBSW,
            447 => x86_insn::X86_INS_PSUBUSB,
            448 => x86_insn::X86_INS_PSUBUSW,
            449 => x86_insn::X86_INS_PSUBW,
            450 => x86_insn::X86_INS_PUNPCKHBW,
            451 => x86_insn::X86_INS_PUNPCKHDQ,
            452 => x86_insn::X86_INS_PUNPCKHWD,
            453 => x86_insn::X86_INS_PUNPCKLBW,
            454 => x86_insn::X86_INS_PUNPCKLDQ,
            455 => x86_insn::X86_INS_PUNPCKLWD,
            456 => x86_insn::X86_INS_PXOR,
            457 => x86_insn::X86_INS_MONITORX,
            458 => x86_insn::X86_INS_MONITOR,
            459 => x86_insn::X86_INS_MONTMUL,
            460 => x86_insn::X86_INS_MOV,
            461 => x86_insn::X86_INS_MOVABS,
            462 => x86_insn::X86_INS_MOVAPD,
            463 => x86_insn::X86_INS_MOVAPS,
            464 => x86_insn::X86_INS_MOVBE,
            465 => x86_insn::X86_INS_MOVDDUP,
            466 => x86_insn::X86_INS_MOVDIR64B,
            467 => x86_insn::X86_INS_MOVDIRI,
            468 => x86_insn::X86_INS_MOVDQA,
            469 => x86_insn::X86_INS_MOVDQU,
            470 => x86_insn::X86_INS_MOVHLPS,
            471 => x86_insn::X86_INS_MOVHPD,
            472 => x86_insn::X86_INS_MOVHPS,
            473 => x86_insn::X86_INS_MOVLHPS,
            474 => x86_insn::X86_INS_MOVLPD,
            475 => x86_insn::X86_INS_MOVLPS,
            476 => x86_insn::X86_INS_MOVMSKPD,
            477 => x86_insn::X86_INS_MOVMSKPS,
            478 => x86_insn::X86_INS_MOVNTDQA,
            479 => x86_insn::X86_INS_MOVNTDQ,
            480 => x86_insn::X86_INS_MOVNTI,
            481 => x86_insn::X86_INS_MOVNTPD,
            482 => x86_insn::X86_INS_MOVNTPS,
            483 => x86_insn::X86_INS_MOVNTSD,
            484 => x86_insn::X86_INS_MOVNTSS,
            485 => x86_insn::X86_INS_MOVSB,
            486 => x86_insn::X86_INS_MOVSD,
            487 => x86_insn::X86_INS_MOVSHDUP,
            488 => x86_insn::X86_INS_MOVSLDUP,
            489 => x86_insn::X86_INS_MOVSQ,
            490 => x86_insn::X86_INS_MOVSS,
            491 => x86_insn::X86_INS_MOVSW,
            492 => x86_insn::X86_INS_MOVSX,
            493 => x86_insn::X86_INS_MOVSXD,
            494 => x86_insn::X86_INS_MOVUPD,
            495 => x86_insn::X86_INS_MOVUPS,
            496 => x86_insn::X86_INS_MOVZX,
            497 => x86_insn::X86_INS_MPSADBW,
            498 => x86_insn::X86_INS_MUL,
            499 => x86_insn::X86_INS_MULPD,
            500 => x86_insn::X86_INS_MULPS,
            501 => x86_insn::X86_INS_MULSD,
            502 => x86_insn::X86_INS_MULSS,
            503 => x86_insn::X86_INS_MULX,
            504 => x86_insn::X86_INS_FMUL,
            505 => x86_insn::X86_INS_FIMUL,
            506 => x86_insn::X86_INS_FMULP,
            507 => x86_insn::X86_INS_MWAITX,
            508 => x86_insn::X86_INS_MWAIT,
            509 => x86_insn::X86_INS_NEG,
            510 => x86_insn::X86_INS_NOP,
            511 => x86_insn::X86_INS_NOT,
            512 => x86_insn::X86_INS_OR,
            513 => x86_insn::X86_INS_ORPD,
            514 => x86_insn::X86_INS_ORPS,
            515 => x86_insn::X86_INS_OUT,
            516 => x86_insn::X86_INS_OUTSB,
            517 => x86_insn::X86_INS_OUTSD,
            518 => x86_insn::X86_INS_OUTSW,
            519 => x86_insn::X86_INS_PACKUSDW,
            520 => x86_insn::X86_INS_PAUSE,
            521 => x86_insn::X86_INS_PAVGUSB,
            522 => x86_insn::X86_INS_PBLENDVB,
            523 => x86_insn::X86_INS_PBLENDW,
            524 => x86_insn::X86_INS_PCLMULQDQ,
            525 => x86_insn::X86_INS_PCMPEQQ,
            526 => x86_insn::X86_INS_PCMPESTRI,
            527 => x86_insn::X86_INS_PCMPESTRM,
            528 => x86_insn::X86_INS_PCMPGTQ,
            529 => x86_insn::X86_INS_PCMPISTRI,
            530 => x86_insn::X86_INS_PCMPISTRM,
            531 => x86_insn::X86_INS_PCONFIG,
            532 => x86_insn::X86_INS_PDEP,
            533 => x86_insn::X86_INS_PEXT,
            534 => x86_insn::X86_INS_PEXTRB,
            535 => x86_insn::X86_INS_PEXTRD,
            536 => x86_insn::X86_INS_PEXTRQ,
            537 => x86_insn::X86_INS_PF2ID,
            538 => x86_insn::X86_INS_PF2IW,
            539 => x86_insn::X86_INS_PFACC,
            540 => x86_insn::X86_INS_PFADD,
            541 => x86_insn::X86_INS_PFCMPEQ,
            542 => x86_insn::X86_INS_PFCMPGE,
            543 => x86_insn::X86_INS_PFCMPGT,
            544 => x86_insn::X86_INS_PFMAX,
            545 => x86_insn::X86_INS_PFMIN,
            546 => x86_insn::X86_INS_PFMUL,
            547 => x86_insn::X86_INS_PFNACC,
            548 => x86_insn::X86_INS_PFPNACC,
            549 => x86_insn::X86_INS_PFRCPIT1,
            550 => x86_insn::X86_INS_PFRCPIT2,
            551 => x86_insn::X86_INS_PFRCP,
            552 => x86_insn::X86_INS_PFRSQIT1,
            553 => x86_insn::X86_INS_PFRSQRT,
            554 => x86_insn::X86_INS_PFSUBR,
            555 => x86_insn::X86_INS_PFSUB,
            556 => x86_insn::X86_INS_PHMINPOSUW,
            557 => x86_insn::X86_INS_PI2FD,
            558 => x86_insn::X86_INS_PI2FW,
            559 => x86_insn::X86_INS_PINSRB,
            560 => x86_insn::X86_INS_PINSRD,
            561 => x86_insn::X86_INS_PINSRQ,
            562 => x86_insn::X86_INS_PMAXSB,
            563 => x86_insn::X86_INS_PMAXSD,
            564 => x86_insn::X86_INS_PMAXUD,
            565 => x86_insn::X86_INS_PMAXUW,
            566 => x86_insn::X86_INS_PMINSB,
            567 => x86_insn::X86_INS_PMINSD,
            568 => x86_insn::X86_INS_PMINUD,
            569 => x86_insn::X86_INS_PMINUW,
            570 => x86_insn::X86_INS_PMOVSXBD,
            571 => x86_insn::X86_INS_PMOVSXBQ,
            572 => x86_insn::X86_INS_PMOVSXBW,
            573 => x86_insn::X86_INS_PMOVSXDQ,
            574 => x86_insn::X86_INS_PMOVSXWD,
            575 => x86_insn::X86_INS_PMOVSXWQ,
            576 => x86_insn::X86_INS_PMOVZXBD,
            577 => x86_insn::X86_INS_PMOVZXBQ,
            578 => x86_insn::X86_INS_PMOVZXBW,
            579 => x86_insn::X86_INS_PMOVZXDQ,
            580 => x86_insn::X86_INS_PMOVZXWD,
            581 => x86_insn::X86_INS_PMOVZXWQ,
            582 => x86_insn::X86_INS_PMULDQ,
            583 => x86_insn::X86_INS_PMULHRW,
            584 => x86_insn::X86_INS_PMULLD,
            585 => x86_insn::X86_INS_POP,
            586 => x86_insn::X86_INS_POPAW,
            587 => x86_insn::X86_INS_POPAL,
            588 => x86_insn::X86_INS_POPCNT,
            589 => x86_insn::X86_INS_POPF,
            590 => x86_insn::X86_INS_POPFD,
            591 => x86_insn::X86_INS_POPFQ,
            592 => x86_insn::X86_INS_PREFETCH,
            593 => x86_insn::X86_INS_PREFETCHNTA,
            594 => x86_insn::X86_INS_PREFETCHT0,
            595 => x86_insn::X86_INS_PREFETCHT1,
            596 => x86_insn::X86_INS_PREFETCHT2,
            597 => x86_insn::X86_INS_PREFETCHW,
            598 => x86_insn::X86_INS_PREFETCHWT1,
            599 => x86_insn::X86_INS_PSHUFD,
            600 => x86_insn::X86_INS_PSHUFHW,
            601 => x86_insn::X86_INS_PSHUFLW,
            602 => x86_insn::X86_INS_PSLLDQ,
            603 => x86_insn::X86_INS_PSRLDQ,
            604 => x86_insn::X86_INS_PSWAPD,
            605 => x86_insn::X86_INS_PTEST,
            606 => x86_insn::X86_INS_PTWRITE,
            607 => x86_insn::X86_INS_PUNPCKHQDQ,
            608 => x86_insn::X86_INS_PUNPCKLQDQ,
            609 => x86_insn::X86_INS_PUSH,
            610 => x86_insn::X86_INS_PUSHAW,
            611 => x86_insn::X86_INS_PUSHAL,
            612 => x86_insn::X86_INS_PUSHF,
            613 => x86_insn::X86_INS_PUSHFD,
            614 => x86_insn::X86_INS_PUSHFQ,
            615 => x86_insn::X86_INS_RCL,
            616 => x86_insn::X86_INS_RCPPS,
            617 => x86_insn::X86_INS_RCPSS,
            618 => x86_insn::X86_INS_RCR,
            619 => x86_insn::X86_INS_RDFSBASE,
            620 => x86_insn::X86_INS_RDGSBASE,
            621 => x86_insn::X86_INS_RDMSR,
            622 => x86_insn::X86_INS_RDPID,
            623 => x86_insn::X86_INS_RDPKRU,
            624 => x86_insn::X86_INS_RDPMC,
            625 => x86_insn::X86_INS_RDRAND,
            626 => x86_insn::X86_INS_RDSEED,
            627 => x86_insn::X86_INS_RDSSPD,
            628 => x86_insn::X86_INS_RDSSPQ,
            629 => x86_insn::X86_INS_RDTSC,
            630 => x86_insn::X86_INS_RDTSCP,
            631 => x86_insn::X86_INS_REPNE,
            632 => x86_insn::X86_INS_REP,
            633 => x86_insn::X86_INS_RET,
            634 => x86_insn::X86_INS_REX64,
            635 => x86_insn::X86_INS_ROL,
            636 => x86_insn::X86_INS_ROR,
            637 => x86_insn::X86_INS_RORX,
            638 => x86_insn::X86_INS_ROUNDPD,
            639 => x86_insn::X86_INS_ROUNDPS,
            640 => x86_insn::X86_INS_ROUNDSD,
            641 => x86_insn::X86_INS_ROUNDSS,
            642 => x86_insn::X86_INS_RSM,
            643 => x86_insn::X86_INS_RSQRTPS,
            644 => x86_insn::X86_INS_RSQRTSS,
            645 => x86_insn::X86_INS_RSTORSSP,
            646 => x86_insn::X86_INS_SAHF,
            647 => x86_insn::X86_INS_SAL,
            648 => x86_insn::X86_INS_SALC,
            649 => x86_insn::X86_INS_SAR,
            650 => x86_insn::X86_INS_SARX,
            651 => x86_insn::X86_INS_SAVEPREVSSP,
            652 => x86_insn::X86_INS_SBB,
            653 => x86_insn::X86_INS_SCASB,
            654 => x86_insn::X86_INS_SCASD,
            655 => x86_insn::X86_INS_SCASQ,
            656 => x86_insn::X86_INS_SCASW,
            657 => x86_insn::X86_INS_SETAE,
            658 => x86_insn::X86_INS_SETA,
            659 => x86_insn::X86_INS_SETBE,
            660 => x86_insn::X86_INS_SETB,
            661 => x86_insn::X86_INS_SETE,
            662 => x86_insn::X86_INS_SETGE,
            663 => x86_insn::X86_INS_SETG,
            664 => x86_insn::X86_INS_SETLE,
            665 => x86_insn::X86_INS_SETL,
            666 => x86_insn::X86_INS_SETNE,
            667 => x86_insn::X86_INS_SETNO,
            668 => x86_insn::X86_INS_SETNP,
            669 => x86_insn::X86_INS_SETNS,
            670 => x86_insn::X86_INS_SETO,
            671 => x86_insn::X86_INS_SETP,
            672 => x86_insn::X86_INS_SETSSBSY,
            673 => x86_insn::X86_INS_SETS,
            674 => x86_insn::X86_INS_SFENCE,
            675 => x86_insn::X86_INS_SGDT,
            676 => x86_insn::X86_INS_SHA1MSG1,
            677 => x86_insn::X86_INS_SHA1MSG2,
            678 => x86_insn::X86_INS_SHA1NEXTE,
            679 => x86_insn::X86_INS_SHA1RNDS4,
            680 => x86_insn::X86_INS_SHA256MSG1,
            681 => x86_insn::X86_INS_SHA256MSG2,
            682 => x86_insn::X86_INS_SHA256RNDS2,
            683 => x86_insn::X86_INS_SHL,
            684 => x86_insn::X86_INS_SHLD,
            685 => x86_insn::X86_INS_SHLX,
            686 => x86_insn::X86_INS_SHR,
            687 => x86_insn::X86_INS_SHRD,
            688 => x86_insn::X86_INS_SHRX,
            689 => x86_insn::X86_INS_SHUFPD,
            690 => x86_insn::X86_INS_SHUFPS,
            691 => x86_insn::X86_INS_SIDT,
            692 => x86_insn::X86_INS_FSIN,
            693 => x86_insn::X86_INS_SKINIT,
            694 => x86_insn::X86_INS_SLDT,
            695 => x86_insn::X86_INS_SLWPCB,
            696 => x86_insn::X86_INS_SMSW,
            697 => x86_insn::X86_INS_SQRTPD,
            698 => x86_insn::X86_INS_SQRTPS,
            699 => x86_insn::X86_INS_SQRTSD,
            700 => x86_insn::X86_INS_SQRTSS,
            701 => x86_insn::X86_INS_FSQRT,
            702 => x86_insn::X86_INS_STAC,
            703 => x86_insn::X86_INS_STC,
            704 => x86_insn::X86_INS_STD,
            705 => x86_insn::X86_INS_STGI,
            706 => x86_insn::X86_INS_STI,
            707 => x86_insn::X86_INS_STMXCSR,
            708 => x86_insn::X86_INS_STOSB,
            709 => x86_insn::X86_INS_STOSD,
            710 => x86_insn::X86_INS_STOSQ,
            711 => x86_insn::X86_INS_STOSW,
            712 => x86_insn::X86_INS_STR,
            713 => x86_insn::X86_INS_FST,
            714 => x86_insn::X86_INS_FSTP,
            715 => x86_insn::X86_INS_SUB,
            716 => x86_insn::X86_INS_SUBPD,
            717 => x86_insn::X86_INS_SUBPS,
            718 => x86_insn::X86_INS_FSUBR,
            719 => x86_insn::X86_INS_FISUBR,
            720 => x86_insn::X86_INS_FSUBRP,
            721 => x86_insn::X86_INS_SUBSD,
            722 => x86_insn::X86_INS_SUBSS,
            723 => x86_insn::X86_INS_FSUB,
            724 => x86_insn::X86_INS_FISUB,
            725 => x86_insn::X86_INS_FSUBP,
            726 => x86_insn::X86_INS_SWAPGS,
            727 => x86_insn::X86_INS_SYSCALL,
            728 => x86_insn::X86_INS_SYSENTER,
            729 => x86_insn::X86_INS_SYSEXIT,
            730 => x86_insn::X86_INS_SYSEXITQ,
            731 => x86_insn::X86_INS_SYSRET,
            732 => x86_insn::X86_INS_SYSRETQ,
            733 => x86_insn::X86_INS_T1MSKC,
            734 => x86_insn::X86_INS_TEST,
            735 => x86_insn::X86_INS_TPAUSE,
            736 => x86_insn::X86_INS_FTST,
            737 => x86_insn::X86_INS_TZCNT,
            738 => x86_insn::X86_INS_TZMSK,
            739 => x86_insn::X86_INS_UCOMISD,
            740 => x86_insn::X86_INS_UCOMISS,
            741 => x86_insn::X86_INS_FUCOMPI,
            742 => x86_insn::X86_INS_FUCOMI,
            743 => x86_insn::X86_INS_FUCOMPP,
            744 => x86_insn::X86_INS_FUCOMP,
            745 => x86_insn::X86_INS_FUCOM,
            746 => x86_insn::X86_INS_UD0,
            747 => x86_insn::X86_INS_UD1,
            748 => x86_insn::X86_INS_UD2,
            749 => x86_insn::X86_INS_UMONITOR,
            750 => x86_insn::X86_INS_UMWAIT,
            751 => x86_insn::X86_INS_UNPCKHPD,
            752 => x86_insn::X86_INS_UNPCKHPS,
            753 => x86_insn::X86_INS_UNPCKLPD,
            754 => x86_insn::X86_INS_UNPCKLPS,
            755 => x86_insn::X86_INS_V4FMADDPS,
            756 => x86_insn::X86_INS_V4FMADDSS,
            757 => x86_insn::X86_INS_V4FNMADDPS,
            758 => x86_insn::X86_INS_V4FNMADDSS,
            759 => x86_insn::X86_INS_VADDPD,
            760 => x86_insn::X86_INS_VADDPS,
            761 => x86_insn::X86_INS_VADDSD,
            762 => x86_insn::X86_INS_VADDSS,
            763 => x86_insn::X86_INS_VADDSUBPD,
            764 => x86_insn::X86_INS_VADDSUBPS,
            765 => x86_insn::X86_INS_VAESDECLAST,
            766 => x86_insn::X86_INS_VAESDEC,
            767 => x86_insn::X86_INS_VAESENCLAST,
            768 => x86_insn::X86_INS_VAESENC,
            769 => x86_insn::X86_INS_VAESIMC,
            770 => x86_insn::X86_INS_VAESKEYGENASSIST,
            771 => x86_insn::X86_INS_VALIGND,
            772 => x86_insn::X86_INS_VALIGNQ,
            773 => x86_insn::X86_INS_VANDNPD,
            774 => x86_insn::X86_INS_VANDNPS,
            775 => x86_insn::X86_INS_VANDPD,
            776 => x86_insn::X86_INS_VANDPS,
            777 => x86_insn::X86_INS_VBLENDMPD,
            778 => x86_insn::X86_INS_VBLENDMPS,
            779 => x86_insn::X86_INS_VBLENDPD,
            780 => x86_insn::X86_INS_VBLENDPS,
            781 => x86_insn::X86_INS_VBLENDVPD,
            782 => x86_insn::X86_INS_VBLENDVPS,
            783 => x86_insn::X86_INS_VBROADCASTF128,
            784 => x86_insn::X86_INS_VBROADCASTF32X2,
            785 => x86_insn::X86_INS_VBROADCASTF32X4,
            786 => x86_insn::X86_INS_VBROADCASTF32X8,
            787 => x86_insn::X86_INS_VBROADCASTF64X2,
            788 => x86_insn::X86_INS_VBROADCASTF64X4,
            789 => x86_insn::X86_INS_VBROADCASTI128,
            790 => x86_insn::X86_INS_VBROADCASTI32X2,
            791 => x86_insn::X86_INS_VBROADCASTI32X4,
            792 => x86_insn::X86_INS_VBROADCASTI32X8,
            793 => x86_insn::X86_INS_VBROADCASTI64X2,
            794 => x86_insn::X86_INS_VBROADCASTI64X4,
            795 => x86_insn::X86_INS_VBROADCASTSD,
            796 => x86_insn::X86_INS_VBROADCASTSS,
            797 => x86_insn::X86_INS_VCMP,
            798 => x86_insn::X86_INS_VCMPPD,
            799 => x86_insn::X86_INS_VCMPPS,
            800 => x86_insn::X86_INS_VCMPSD,
            801 => x86_insn::X86_INS_VCMPSS,
            802 => x86_insn::X86_INS_VCOMISD,
            803 => x86_insn::X86_INS_VCOMISS,
            804 => x86_insn::X86_INS_VCOMPRESSPD,
            805 => x86_insn::X86_INS_VCOMPRESSPS,
            806 => x86_insn::X86_INS_VCVTDQ2PD,
            807 => x86_insn::X86_INS_VCVTDQ2PS,
            808 => x86_insn::X86_INS_VCVTPD2DQ,
            809 => x86_insn::X86_INS_VCVTPD2PS,
            810 => x86_insn::X86_INS_VCVTPD2QQ,
            811 => x86_insn::X86_INS_VCVTPD2UDQ,
            812 => x86_insn::X86_INS_VCVTPD2UQQ,
            813 => x86_insn::X86_INS_VCVTPH2PS,
            814 => x86_insn::X86_INS_VCVTPS2DQ,
            815 => x86_insn::X86_INS_VCVTPS2PD,
            816 => x86_insn::X86_INS_VCVTPS2PH,
            817 => x86_insn::X86_INS_VCVTPS2QQ,
            818 => x86_insn::X86_INS_VCVTPS2UDQ,
            819 => x86_insn::X86_INS_VCVTPS2UQQ,
            820 => x86_insn::X86_INS_VCVTQQ2PD,
            821 => x86_insn::X86_INS_VCVTQQ2PS,
            822 => x86_insn::X86_INS_VCVTSD2SI,
            823 => x86_insn::X86_INS_VCVTSD2SS,
            824 => x86_insn::X86_INS_VCVTSD2USI,
            825 => x86_insn::X86_INS_VCVTSI2SD,
            826 => x86_insn::X86_INS_VCVTSI2SS,
            827 => x86_insn::X86_INS_VCVTSS2SD,
            828 => x86_insn::X86_INS_VCVTSS2SI,
            829 => x86_insn::X86_INS_VCVTSS2USI,
            830 => x86_insn::X86_INS_VCVTTPD2DQ,
            831 => x86_insn::X86_INS_VCVTTPD2QQ,
            832 => x86_insn::X86_INS_VCVTTPD2UDQ,
            833 => x86_insn::X86_INS_VCVTTPD2UQQ,
            834 => x86_insn::X86_INS_VCVTTPS2DQ,
            835 => x86_insn::X86_INS_VCVTTPS2QQ,
            836 => x86_insn::X86_INS_VCVTTPS2UDQ,
            837 => x86_insn::X86_INS_VCVTTPS2UQQ,
            838 => x86_insn::X86_INS_VCVTTSD2SI,
            839 => x86_insn::X86_INS_VCVTTSD2USI,
            840 => x86_insn::X86_INS_VCVTTSS2SI,
            841 => x86_insn::X86_INS_VCVTTSS2USI,
            842 => x86_insn::X86_INS_VCVTUDQ2PD,
            843 => x86_insn::X86_INS_VCVTUDQ2PS,
            844 => x86_insn::X86_INS_VCVTUQQ2PD,
            845 => x86_insn::X86_INS_VCVTUQQ2PS,
            846 => x86_insn::X86_INS_VCVTUSI2SD,
            847 => x86_insn::X86_INS_VCVTUSI2SS,
            848 => x86_insn::X86_INS_VDBPSADBW,
            849 => x86_insn::X86_INS_VDIVPD,
            850 => x86_insn::X86_INS_VDIVPS,
            851 => x86_insn::X86_INS_VDIVSD,
            852 => x86_insn::X86_INS_VDIVSS,
            853 => x86_insn::X86_INS_VDPPD,
            854 => x86_insn::X86_INS_VDPPS,
            855 => x86_insn::X86_INS_VERR,
            856 => x86_insn::X86_INS_VERW,
            857 => x86_insn::X86_INS_VEXP2PD,
            858 => x86_insn::X86_INS_VEXP2PS,
            859 => x86_insn::X86_INS_VEXPANDPD,
            860 => x86_insn::X86_INS_VEXPANDPS,
            861 => x86_insn::X86_INS_VEXTRACTF128,
            862 => x86_insn::X86_INS_VEXTRACTF32X4,
            863 => x86_insn::X86_INS_VEXTRACTF32X8,
            864 => x86_insn::X86_INS_VEXTRACTF64X2,
            865 => x86_insn::X86_INS_VEXTRACTF64X4,
            866 => x86_insn::X86_INS_VEXTRACTI128,
            867 => x86_insn::X86_INS_VEXTRACTI32X4,
            868 => x86_insn::X86_INS_VEXTRACTI32X8,
            869 => x86_insn::X86_INS_VEXTRACTI64X2,
            870 => x86_insn::X86_INS_VEXTRACTI64X4,
            871 => x86_insn::X86_INS_VEXTRACTPS,
            872 => x86_insn::X86_INS_VFIXUPIMMPD,
            873 => x86_insn::X86_INS_VFIXUPIMMPS,
            874 => x86_insn::X86_INS_VFIXUPIMMSD,
            875 => x86_insn::X86_INS_VFIXUPIMMSS,
            876 => x86_insn::X86_INS_VFMADD132PD,
            877 => x86_insn::X86_INS_VFMADD132PS,
            878 => x86_insn::X86_INS_VFMADD132SD,
            879 => x86_insn::X86_INS_VFMADD132SS,
            880 => x86_insn::X86_INS_VFMADD213PD,
            881 => x86_insn::X86_INS_VFMADD213PS,
            882 => x86_insn::X86_INS_VFMADD213SD,
            883 => x86_insn::X86_INS_VFMADD213SS,
            884 => x86_insn::X86_INS_VFMADD231PD,
            885 => x86_insn::X86_INS_VFMADD231PS,
            886 => x86_insn::X86_INS_VFMADD231SD,
            887 => x86_insn::X86_INS_VFMADD231SS,
            888 => x86_insn::X86_INS_VFMADDPD,
            889 => x86_insn::X86_INS_VFMADDPS,
            890 => x86_insn::X86_INS_VFMADDSD,
            891 => x86_insn::X86_INS_VFMADDSS,
            892 => x86_insn::X86_INS_VFMADDSUB132PD,
            893 => x86_insn::X86_INS_VFMADDSUB132PS,
            894 => x86_insn::X86_INS_VFMADDSUB213PD,
            895 => x86_insn::X86_INS_VFMADDSUB213PS,
            896 => x86_insn::X86_INS_VFMADDSUB231PD,
            897 => x86_insn::X86_INS_VFMADDSUB231PS,
            898 => x86_insn::X86_INS_VFMADDSUBPD,
            899 => x86_insn::X86_INS_VFMADDSUBPS,
            900 => x86_insn::X86_INS_VFMSUB132PD,
            901 => x86_insn::X86_INS_VFMSUB132PS,
            902 => x86_insn::X86_INS_VFMSUB132SD,
            903 => x86_insn::X86_INS_VFMSUB132SS,
            904 => x86_insn::X86_INS_VFMSUB213PD,
            905 => x86_insn::X86_INS_VFMSUB213PS,
            906 => x86_insn::X86_INS_VFMSUB213SD,
            907 => x86_insn::X86_INS_VFMSUB213SS,
            908 => x86_insn::X86_INS_VFMSUB231PD,
            909 => x86_insn::X86_INS_VFMSUB231PS,
            910 => x86_insn::X86_INS_VFMSUB231SD,
            911 => x86_insn::X86_INS_VFMSUB231SS,
            912 => x86_insn::X86_INS_VFMSUBADD132PD,
            913 => x86_insn::X86_INS_VFMSUBADD132PS,
            914 => x86_insn::X86_INS_VFMSUBADD213PD,
            915 => x86_insn::X86_INS_VFMSUBADD213PS,
            916 => x86_insn::X86_INS_VFMSUBADD231PD,
            917 => x86_insn::X86_INS_VFMSUBADD231PS,
            918 => x86_insn::X86_INS_VFMSUBADDPD,
            919 => x86_insn::X86_INS_VFMSUBADDPS,
            920 => x86_insn::X86_INS_VFMSUBPD,
            921 => x86_insn::X86_INS_VFMSUBPS,
            922 => x86_insn::X86_INS_VFMSUBSD,
            923 => x86_insn::X86_INS_VFMSUBSS,
            924 => x86_insn::X86_INS_VFNMADD132PD,
            925 => x86_insn::X86_INS_VFNMADD132PS,
            926 => x86_insn::X86_INS_VFNMADD132SD,
            927 => x86_insn::X86_INS_VFNMADD132SS,
            928 => x86_insn::X86_INS_VFNMADD213PD,
            929 => x86_insn::X86_INS_VFNMADD213PS,
            930 => x86_insn::X86_INS_VFNMADD213SD,
            931 => x86_insn::X86_INS_VFNMADD213SS,
            932 => x86_insn::X86_INS_VFNMADD231PD,
            933 => x86_insn::X86_INS_VFNMADD231PS,
            934 => x86_insn::X86_INS_VFNMADD231SD,
            935 => x86_insn::X86_INS_VFNMADD231SS,
            936 => x86_insn::X86_INS_VFNMADDPD,
            937 => x86_insn::X86_INS_VFNMADDPS,
            938 => x86_insn::X86_INS_VFNMADDSD,
            939 => x86_insn::X86_INS_VFNMADDSS,
            940 => x86_insn::X86_INS_VFNMSUB132PD,
            941 => x86_insn::X86_INS_VFNMSUB132PS,
            942 => x86_insn::X86_INS_VFNMSUB132SD,
            943 => x86_insn::X86_INS_VFNMSUB132SS,
            944 => x86_insn::X86_INS_VFNMSUB213PD,
            945 => x86_insn::X86_INS_VFNMSUB213PS,
            946 => x86_insn::X86_INS_VFNMSUB213SD,
            947 => x86_insn::X86_INS_VFNMSUB213SS,
            948 => x86_insn::X86_INS_VFNMSUB231PD,
            949 => x86_insn::X86_INS_VFNMSUB231PS,
            950 => x86_insn::X86_INS_VFNMSUB231SD,
            951 => x86_insn::X86_INS_VFNMSUB231SS,
            952 => x86_insn::X86_INS_VFNMSUBPD,
            953 => x86_insn::X86_INS_VFNMSUBPS,
            954 => x86_insn::X86_INS_VFNMSUBSD,
            955 => x86_insn::X86_INS_VFNMSUBSS,
            956 => x86_insn::X86_INS_VFPCLASSPD,
            957 => x86_insn::X86_INS_VFPCLASSPS,
            958 => x86_insn::X86_INS_VFPCLASSSD,
            959 => x86_insn::X86_INS_VFPCLASSSS,
            960 => x86_insn::X86_INS_VFRCZPD,
            961 => x86_insn::X86_INS_VFRCZPS,
            962 => x86_insn::X86_INS_VFRCZSD,
            963 => x86_insn::X86_INS_VFRCZSS,
            964 => x86_insn::X86_INS_VGATHERDPD,
            965 => x86_insn::X86_INS_VGATHERDPS,
            966 => x86_insn::X86_INS_VGATHERPF0DPD,
            967 => x86_insn::X86_INS_VGATHERPF0DPS,
            968 => x86_insn::X86_INS_VGATHERPF0QPD,
            969 => x86_insn::X86_INS_VGATHERPF0QPS,
            970 => x86_insn::X86_INS_VGATHERPF1DPD,
            971 => x86_insn::X86_INS_VGATHERPF1DPS,
            972 => x86_insn::X86_INS_VGATHERPF1QPD,
            973 => x86_insn::X86_INS_VGATHERPF1QPS,
            974 => x86_insn::X86_INS_VGATHERQPD,
            975 => x86_insn::X86_INS_VGATHERQPS,
            976 => x86_insn::X86_INS_VGETEXPPD,
            977 => x86_insn::X86_INS_VGETEXPPS,
            978 => x86_insn::X86_INS_VGETEXPSD,
            979 => x86_insn::X86_INS_VGETEXPSS,
            980 => x86_insn::X86_INS_VGETMANTPD,
            981 => x86_insn::X86_INS_VGETMANTPS,
            982 => x86_insn::X86_INS_VGETMANTSD,
            983 => x86_insn::X86_INS_VGETMANTSS,
            984 => x86_insn::X86_INS_VGF2P8AFFINEINVQB,
            985 => x86_insn::X86_INS_VGF2P8AFFINEQB,
            986 => x86_insn::X86_INS_VGF2P8MULB,
            987 => x86_insn::X86_INS_VHADDPD,
            988 => x86_insn::X86_INS_VHADDPS,
            989 => x86_insn::X86_INS_VHSUBPD,
            990 => x86_insn::X86_INS_VHSUBPS,
            991 => x86_insn::X86_INS_VINSERTF128,
            992 => x86_insn::X86_INS_VINSERTF32X4,
            993 => x86_insn::X86_INS_VINSERTF32X8,
            994 => x86_insn::X86_INS_VINSERTF64X2,
            995 => x86_insn::X86_INS_VINSERTF64X4,
            996 => x86_insn::X86_INS_VINSERTI128,
            997 => x86_insn::X86_INS_VINSERTI32X4,
            998 => x86_insn::X86_INS_VINSERTI32X8,
            999 => x86_insn::X86_INS_VINSERTI64X2,
            1000 => x86_insn::X86_INS_VINSERTI64X4,
            1001 => x86_insn::X86_INS_VINSERTPS,
            1002 => x86_insn::X86_INS_VLDDQU,
            1003 => x86_insn::X86_INS_VLDMXCSR,
            1004 => x86_insn::X86_INS_VMASKMOVDQU,
            1005 => x86_insn::X86_INS_VMASKMOVPD,
            1006 => x86_insn::X86_INS_VMASKMOVPS,
            1007 => x86_insn::X86_INS_VMAXPD,
            1008 => x86_insn::X86_INS_VMAXPS,
            1009 => x86_insn::X86_INS_VMAXSD,
            1010 => x86_insn::X86_INS_VMAXSS,
            1011 => x86_insn::X86_INS_VMCALL,
            1012 => x86_insn::X86_INS_VMCLEAR,
            1013 => x86_insn::X86_INS_VMFUNC,
            1014 => x86_insn::X86_INS_VMINPD,
            1015 => x86_insn::X86_INS_VMINPS,
            1016 => x86_insn::X86_INS_VMINSD,
            1017 => x86_insn::X86_INS_VMINSS,
            1018 => x86_insn::X86_INS_VMLAUNCH,
            1019 => x86_insn::X86_INS_VMLOAD,
            1020 => x86_insn::X86_INS_VMMCALL,
            1021 => x86_insn::X86_INS_VMOVQ,
            1022 => x86_insn::X86_INS_VMOVAPD,
            1023 => x86_insn::X86_INS_VMOVAPS,
            1024 => x86_insn::X86_INS_VMOVDDUP,
            1025 => x86_insn::X86_INS_VMOVD,
            1026 => x86_insn::X86_INS_VMOVDQA32,
            1027 => x86_insn::X86_INS_VMOVDQA64,
            1028 => x86_insn::X86_INS_VMOVDQA,
            1029 => x86_insn::X86_INS_VMOVDQU16,
            1030 => x86_insn::X86_INS_VMOVDQU32,
            1031 => x86_insn::X86_INS_VMOVDQU64,
            1032 => x86_insn::X86_INS_VMOVDQU8,
            1033 => x86_insn::X86_INS_VMOVDQU,
            1034 => x86_insn::X86_INS_VMOVHLPS,
            1035 => x86_insn::X86_INS_VMOVHPD,
            1036 => x86_insn::X86_INS_VMOVHPS,
            1037 => x86_insn::X86_INS_VMOVLHPS,
            1038 => x86_insn::X86_INS_VMOVLPD,
            1039 => x86_insn::X86_INS_VMOVLPS,
            1040 => x86_insn::X86_INS_VMOVMSKPD,
            1041 => x86_insn::X86_INS_VMOVMSKPS,
            1042 => x86_insn::X86_INS_VMOVNTDQA,
            1043 => x86_insn::X86_INS_VMOVNTDQ,
            1044 => x86_insn::X86_INS_VMOVNTPD,
            1045 => x86_insn::X86_INS_VMOVNTPS,
            1046 => x86_insn::X86_INS_VMOVSD,
            1047 => x86_insn::X86_INS_VMOVSHDUP,
            1048 => x86_insn::X86_INS_VMOVSLDUP,
            1049 => x86_insn::X86_INS_VMOVSS,
            1050 => x86_insn::X86_INS_VMOVUPD,
            1051 => x86_insn::X86_INS_VMOVUPS,
            1052 => x86_insn::X86_INS_VMPSADBW,
            1053 => x86_insn::X86_INS_VMPTRLD,
            1054 => x86_insn::X86_INS_VMPTRST,
            1055 => x86_insn::X86_INS_VMREAD,
            1056 => x86_insn::X86_INS_VMRESUME,
            1057 => x86_insn::X86_INS_VMRUN,
            1058 => x86_insn::X86_INS_VMSAVE,
            1059 => x86_insn::X86_INS_VMULPD,
            1060 => x86_insn::X86_INS_VMULPS,
            1061 => x86_insn::X86_INS_VMULSD,
            1062 => x86_insn::X86_INS_VMULSS,
            1063 => x86_insn::X86_INS_VMWRITE,
            1064 => x86_insn::X86_INS_VMXOFF,
            1065 => x86_insn::X86_INS_VMXON,
            1066 => x86_insn::X86_INS_VORPD,
            1067 => x86_insn::X86_INS_VORPS,
            1068 => x86_insn::X86_INS_VP4DPWSSDS,
            1069 => x86_insn::X86_INS_VP4DPWSSD,
            1070 => x86_insn::X86_INS_VPABSB,
            1071 => x86_insn::X86_INS_VPABSD,
            1072 => x86_insn::X86_INS_VPABSQ,
            1073 => x86_insn::X86_INS_VPABSW,
            1074 => x86_insn::X86_INS_VPACKSSDW,
            1075 => x86_insn::X86_INS_VPACKSSWB,
            1076 => x86_insn::X86_INS_VPACKUSDW,
            1077 => x86_insn::X86_INS_VPACKUSWB,
            1078 => x86_insn::X86_INS_VPADDB,
            1079 => x86_insn::X86_INS_VPADDD,
            1080 => x86_insn::X86_INS_VPADDQ,
            1081 => x86_insn::X86_INS_VPADDSB,
            1082 => x86_insn::X86_INS_VPADDSW,
            1083 => x86_insn::X86_INS_VPADDUSB,
            1084 => x86_insn::X86_INS_VPADDUSW,
            1085 => x86_insn::X86_INS_VPADDW,
            1086 => x86_insn::X86_INS_VPALIGNR,
            1087 => x86_insn::X86_INS_VPANDD,
            1088 => x86_insn::X86_INS_VPANDND,
            1089 => x86_insn::X86_INS_VPANDNQ,
            1090 => x86_insn::X86_INS_VPANDN,
            1091 => x86_insn::X86_INS_VPANDQ,
            1092 => x86_insn::X86_INS_VPAND,
            1093 => x86_insn::X86_INS_VPAVGB,
            1094 => x86_insn::X86_INS_VPAVGW,
            1095 => x86_insn::X86_INS_VPBLENDD,
            1096 => x86_insn::X86_INS_VPBLENDMB,
            1097 => x86_insn::X86_INS_VPBLENDMD,
            1098 => x86_insn::X86_INS_VPBLENDMQ,
            1099 => x86_insn::X86_INS_VPBLENDMW,
            1100 => x86_insn::X86_INS_VPBLENDVB,
            1101 => x86_insn::X86_INS_VPBLENDW,
            1102 => x86_insn::X86_INS_VPBROADCASTB,
            1103 => x86_insn::X86_INS_VPBROADCASTD,
            1104 => x86_insn::X86_INS_VPBROADCASTMB2Q,
            1105 => x86_insn::X86_INS_VPBROADCASTMW2D,
            1106 => x86_insn::X86_INS_VPBROADCASTQ,
            1107 => x86_insn::X86_INS_VPBROADCASTW,
            1108 => x86_insn::X86_INS_VPCLMULQDQ,
            1109 => x86_insn::X86_INS_VPCMOV,
            1110 => x86_insn::X86_INS_VPCMP,
            1111 => x86_insn::X86_INS_VPCMPB,
            1112 => x86_insn::X86_INS_VPCMPD,
            1113 => x86_insn::X86_INS_VPCMPEQB,
            1114 => x86_insn::X86_INS_VPCMPEQD,
            1115 => x86_insn::X86_INS_VPCMPEQQ,
            1116 => x86_insn::X86_INS_VPCMPEQW,
            1117 => x86_insn::X86_INS_VPCMPESTRI,
            1118 => x86_insn::X86_INS_VPCMPESTRM,
            1119 => x86_insn::X86_INS_VPCMPGTB,
            1120 => x86_insn::X86_INS_VPCMPGTD,
            1121 => x86_insn::X86_INS_VPCMPGTQ,
            1122 => x86_insn::X86_INS_VPCMPGTW,
            1123 => x86_insn::X86_INS_VPCMPISTRI,
            1124 => x86_insn::X86_INS_VPCMPISTRM,
            1125 => x86_insn::X86_INS_VPCMPQ,
            1126 => x86_insn::X86_INS_VPCMPUB,
            1127 => x86_insn::X86_INS_VPCMPUD,
            1128 => x86_insn::X86_INS_VPCMPUQ,
            1129 => x86_insn::X86_INS_VPCMPUW,
            1130 => x86_insn::X86_INS_VPCMPW,
            1131 => x86_insn::X86_INS_VPCOM,
            1132 => x86_insn::X86_INS_VPCOMB,
            1133 => x86_insn::X86_INS_VPCOMD,
            1134 => x86_insn::X86_INS_VPCOMPRESSB,
            1135 => x86_insn::X86_INS_VPCOMPRESSD,
            1136 => x86_insn::X86_INS_VPCOMPRESSQ,
            1137 => x86_insn::X86_INS_VPCOMPRESSW,
            1138 => x86_insn::X86_INS_VPCOMQ,
            1139 => x86_insn::X86_INS_VPCOMUB,
            1140 => x86_insn::X86_INS_VPCOMUD,
            1141 => x86_insn::X86_INS_VPCOMUQ,
            1142 => x86_insn::X86_INS_VPCOMUW,
            1143 => x86_insn::X86_INS_VPCOMW,
            1144 => x86_insn::X86_INS_VPCONFLICTD,
            1145 => x86_insn::X86_INS_VPCONFLICTQ,
            1146 => x86_insn::X86_INS_VPDPBUSDS,
            1147 => x86_insn::X86_INS_VPDPBUSD,
            1148 => x86_insn::X86_INS_VPDPWSSDS,
            1149 => x86_insn::X86_INS_VPDPWSSD,
            1150 => x86_insn::X86_INS_VPERM2F128,
            1151 => x86_insn::X86_INS_VPERM2I128,
            1152 => x86_insn::X86_INS_VPERMB,
            1153 => x86_insn::X86_INS_VPERMD,
            1154 => x86_insn::X86_INS_VPERMI2B,
            1155 => x86_insn::X86_INS_VPERMI2D,
            1156 => x86_insn::X86_INS_VPERMI2PD,
            1157 => x86_insn::X86_INS_VPERMI2PS,
            1158 => x86_insn::X86_INS_VPERMI2Q,
            1159 => x86_insn::X86_INS_VPERMI2W,
            1160 => x86_insn::X86_INS_VPERMIL2PD,
            1161 => x86_insn::X86_INS_VPERMILPD,
            1162 => x86_insn::X86_INS_VPERMIL2PS,
            1163 => x86_insn::X86_INS_VPERMILPS,
            1164 => x86_insn::X86_INS_VPERMPD,
            1165 => x86_insn::X86_INS_VPERMPS,
            1166 => x86_insn::X86_INS_VPERMQ,
            1167 => x86_insn::X86_INS_VPERMT2B,
            1168 => x86_insn::X86_INS_VPERMT2D,
            1169 => x86_insn::X86_INS_VPERMT2PD,
            1170 => x86_insn::X86_INS_VPERMT2PS,
            1171 => x86_insn::X86_INS_VPERMT2Q,
            1172 => x86_insn::X86_INS_VPERMT2W,
            1173 => x86_insn::X86_INS_VPERMW,
            1174 => x86_insn::X86_INS_VPEXPANDB,
            1175 => x86_insn::X86_INS_VPEXPANDD,
            1176 => x86_insn::X86_INS_VPEXPANDQ,
            1177 => x86_insn::X86_INS_VPEXPANDW,
            1178 => x86_insn::X86_INS_VPEXTRB,
            1179 => x86_insn::X86_INS_VPEXTRD,
            1180 => x86_insn::X86_INS_VPEXTRQ,
            1181 => x86_insn::X86_INS_VPEXTRW,
            1182 => x86_insn::X86_INS_VPGATHERDD,
            1183 => x86_insn::X86_INS_VPGATHERDQ,
            1184 => x86_insn::X86_INS_VPGATHERQD,
            1185 => x86_insn::X86_INS_VPGATHERQQ,
            1186 => x86_insn::X86_INS_VPHADDBD,
            1187 => x86_insn::X86_INS_VPHADDBQ,
            1188 => x86_insn::X86_INS_VPHADDBW,
            1189 => x86_insn::X86_INS_VPHADDDQ,
            1190 => x86_insn::X86_INS_VPHADDD,
            1191 => x86_insn::X86_INS_VPHADDSW,
            1192 => x86_insn::X86_INS_VPHADDUBD,
            1193 => x86_insn::X86_INS_VPHADDUBQ,
            1194 => x86_insn::X86_INS_VPHADDUBW,
            1195 => x86_insn::X86_INS_VPHADDUDQ,
            1196 => x86_insn::X86_INS_VPHADDUWD,
            1197 => x86_insn::X86_INS_VPHADDUWQ,
            1198 => x86_insn::X86_INS_VPHADDWD,
            1199 => x86_insn::X86_INS_VPHADDWQ,
            1200 => x86_insn::X86_INS_VPHADDW,
            1201 => x86_insn::X86_INS_VPHMINPOSUW,
            1202 => x86_insn::X86_INS_VPHSUBBW,
            1203 => x86_insn::X86_INS_VPHSUBDQ,
            1204 => x86_insn::X86_INS_VPHSUBD,
            1205 => x86_insn::X86_INS_VPHSUBSW,
            1206 => x86_insn::X86_INS_VPHSUBWD,
            1207 => x86_insn::X86_INS_VPHSUBW,
            1208 => x86_insn::X86_INS_VPINSRB,
            1209 => x86_insn::X86_INS_VPINSRD,
            1210 => x86_insn::X86_INS_VPINSRQ,
            1211 => x86_insn::X86_INS_VPINSRW,
            1212 => x86_insn::X86_INS_VPLZCNTD,
            1213 => x86_insn::X86_INS_VPLZCNTQ,
            1214 => x86_insn::X86_INS_VPMACSDD,
            1215 => x86_insn::X86_INS_VPMACSDQH,
            1216 => x86_insn::X86_INS_VPMACSDQL,
            1217 => x86_insn::X86_INS_VPMACSSDD,
            1218 => x86_insn::X86_INS_VPMACSSDQH,
            1219 => x86_insn::X86_INS_VPMACSSDQL,
            1220 => x86_insn::X86_INS_VPMACSSWD,
            1221 => x86_insn::X86_INS_VPMACSSWW,
            1222 => x86_insn::X86_INS_VPMACSWD,
            1223 => x86_insn::X86_INS_VPMACSWW,
            1224 => x86_insn::X86_INS_VPMADCSSWD,
            1225 => x86_insn::X86_INS_VPMADCSWD,
            1226 => x86_insn::X86_INS_VPMADD52HUQ,
            1227 => x86_insn::X86_INS_VPMADD52LUQ,
            1228 => x86_insn::X86_INS_VPMADDUBSW,
            1229 => x86_insn::X86_INS_VPMADDWD,
            1230 => x86_insn::X86_INS_VPMASKMOVD,
            1231 => x86_insn::X86_INS_VPMASKMOVQ,
            1232 => x86_insn::X86_INS_VPMAXSB,
            1233 => x86_insn::X86_INS_VPMAXSD,
            1234 => x86_insn::X86_INS_VPMAXSQ,
            1235 => x86_insn::X86_INS_VPMAXSW,
            1236 => x86_insn::X86_INS_VPMAXUB,
            1237 => x86_insn::X86_INS_VPMAXUD,
            1238 => x86_insn::X86_INS_VPMAXUQ,
            1239 => x86_insn::X86_INS_VPMAXUW,
            1240 => x86_insn::X86_INS_VPMINSB,
            1241 => x86_insn::X86_INS_VPMINSD,
            1242 => x86_insn::X86_INS_VPMINSQ,
            1243 => x86_insn::X86_INS_VPMINSW,
            1244 => x86_insn::X86_INS_VPMINUB,
            1245 => x86_insn::X86_INS_VPMINUD,
            1246 => x86_insn::X86_INS_VPMINUQ,
            1247 => x86_insn::X86_INS_VPMINUW,
            1248 => x86_insn::X86_INS_VPMOVB2M,
            1249 => x86_insn::X86_INS_VPMOVD2M,
            1250 => x86_insn::X86_INS_VPMOVDB,
            1251 => x86_insn::X86_INS_VPMOVDW,
            1252 => x86_insn::X86_INS_VPMOVM2B,
            1253 => x86_insn::X86_INS_VPMOVM2D,
            1254 => x86_insn::X86_INS_VPMOVM2Q,
            1255 => x86_insn::X86_INS_VPMOVM2W,
            1256 => x86_insn::X86_INS_VPMOVMSKB,
            1257 => x86_insn::X86_INS_VPMOVQ2M,
            1258 => x86_insn::X86_INS_VPMOVQB,
            1259 => x86_insn::X86_INS_VPMOVQD,
            1260 => x86_insn::X86_INS_VPMOVQW,
            1261 => x86_insn::X86_INS_VPMOVSDB,
            1262 => x86_insn::X86_INS_VPMOVSDW,
            1263 => x86_insn::X86_INS_VPMOVSQB,
            1264 => x86_insn::X86_INS_VPMOVSQD,
            1265 => x86_insn::X86_INS_VPMOVSQW,
            1266 => x86_insn::X86_INS_VPMOVSWB,
            1267 => x86_insn::X86_INS_VPMOVSXBD,
            1268 => x86_insn::X86_INS_VPMOVSXBQ,
            1269 => x86_insn::X86_INS_VPMOVSXBW,
            1270 => x86_insn::X86_INS_VPMOVSXDQ,
            1271 => x86_insn::X86_INS_VPMOVSXWD,
            1272 => x86_insn::X86_INS_VPMOVSXWQ,
            1273 => x86_insn::X86_INS_VPMOVUSDB,
            1274 => x86_insn::X86_INS_VPMOVUSDW,
            1275 => x86_insn::X86_INS_VPMOVUSQB,
            1276 => x86_insn::X86_INS_VPMOVUSQD,
            1277 => x86_insn::X86_INS_VPMOVUSQW,
            1278 => x86_insn::X86_INS_VPMOVUSWB,
            1279 => x86_insn::X86_INS_VPMOVW2M,
            1280 => x86_insn::X86_INS_VPMOVWB,
            1281 => x86_insn::X86_INS_VPMOVZXBD,
            1282 => x86_insn::X86_INS_VPMOVZXBQ,
            1283 => x86_insn::X86_INS_VPMOVZXBW,
            1284 => x86_insn::X86_INS_VPMOVZXDQ,
            1285 => x86_insn::X86_INS_VPMOVZXWD,
            1286 => x86_insn::X86_INS_VPMOVZXWQ,
            1287 => x86_insn::X86_INS_VPMULDQ,
            1288 => x86_insn::X86_INS_VPMULHRSW,
            1289 => x86_insn::X86_INS_VPMULHUW,
            1290 => x86_insn::X86_INS_VPMULHW,
            1291 => x86_insn::X86_INS_VPMULLD,
            1292 => x86_insn::X86_INS_VPMULLQ,
            1293 => x86_insn::X86_INS_VPMULLW,
            1294 => x86_insn::X86_INS_VPMULTISHIFTQB,
            1295 => x86_insn::X86_INS_VPMULUDQ,
            1296 => x86_insn::X86_INS_VPOPCNTB,
            1297 => x86_insn::X86_INS_VPOPCNTD,
            1298 => x86_insn::X86_INS_VPOPCNTQ,
            1299 => x86_insn::X86_INS_VPOPCNTW,
            1300 => x86_insn::X86_INS_VPORD,
            1301 => x86_insn::X86_INS_VPORQ,
            1302 => x86_insn::X86_INS_VPOR,
            1303 => x86_insn::X86_INS_VPPERM,
            1304 => x86_insn::X86_INS_VPROLD,
            1305 => x86_insn::X86_INS_VPROLQ,
            1306 => x86_insn::X86_INS_VPROLVD,
            1307 => x86_insn::X86_INS_VPROLVQ,
            1308 => x86_insn::X86_INS_VPRORD,
            1309 => x86_insn::X86_INS_VPRORQ,
            1310 => x86_insn::X86_INS_VPRORVD,
            1311 => x86_insn::X86_INS_VPRORVQ,
            1312 => x86_insn::X86_INS_VPROTB,
            1313 => x86_insn::X86_INS_VPROTD,
            1314 => x86_insn::X86_INS_VPROTQ,
            1315 => x86_insn::X86_INS_VPROTW,
            1316 => x86_insn::X86_INS_VPSADBW,
            1317 => x86_insn::X86_INS_VPSCATTERDD,
            1318 => x86_insn::X86_INS_VPSCATTERDQ,
            1319 => x86_insn::X86_INS_VPSCATTERQD,
            1320 => x86_insn::X86_INS_VPSCATTERQQ,
            1321 => x86_insn::X86_INS_VPSHAB,
            1322 => x86_insn::X86_INS_VPSHAD,
            1323 => x86_insn::X86_INS_VPSHAQ,
            1324 => x86_insn::X86_INS_VPSHAW,
            1325 => x86_insn::X86_INS_VPSHLB,
            1326 => x86_insn::X86_INS_VPSHLDD,
            1327 => x86_insn::X86_INS_VPSHLDQ,
            1328 => x86_insn::X86_INS_VPSHLDVD,
            1329 => x86_insn::X86_INS_VPSHLDVQ,
            1330 => x86_insn::X86_INS_VPSHLDVW,
            1331 => x86_insn::X86_INS_VPSHLDW,
            1332 => x86_insn::X86_INS_VPSHLD,
            1333 => x86_insn::X86_INS_VPSHLQ,
            1334 => x86_insn::X86_INS_VPSHLW,
            1335 => x86_insn::X86_INS_VPSHRDD,
            1336 => x86_insn::X86_INS_VPSHRDQ,
            1337 => x86_insn::X86_INS_VPSHRDVD,
            1338 => x86_insn::X86_INS_VPSHRDVQ,
            1339 => x86_insn::X86_INS_VPSHRDVW,
            1340 => x86_insn::X86_INS_VPSHRDW,
            1341 => x86_insn::X86_INS_VPSHUFBITQMB,
            1342 => x86_insn::X86_INS_VPSHUFB,
            1343 => x86_insn::X86_INS_VPSHUFD,
            1344 => x86_insn::X86_INS_VPSHUFHW,
            1345 => x86_insn::X86_INS_VPSHUFLW,
            1346 => x86_insn::X86_INS_VPSIGNB,
            1347 => x86_insn::X86_INS_VPSIGND,
            1348 => x86_insn::X86_INS_VPSIGNW,
            1349 => x86_insn::X86_INS_VPSLLDQ,
            1350 => x86_insn::X86_INS_VPSLLD,
            1351 => x86_insn::X86_INS_VPSLLQ,
            1352 => x86_insn::X86_INS_VPSLLVD,
            1353 => x86_insn::X86_INS_VPSLLVQ,
            1354 => x86_insn::X86_INS_VPSLLVW,
            1355 => x86_insn::X86_INS_VPSLLW,
            1356 => x86_insn::X86_INS_VPSRAD,
            1357 => x86_insn::X86_INS_VPSRAQ,
            1358 => x86_insn::X86_INS_VPSRAVD,
            1359 => x86_insn::X86_INS_VPSRAVQ,
            1360 => x86_insn::X86_INS_VPSRAVW,
            1361 => x86_insn::X86_INS_VPSRAW,
            1362 => x86_insn::X86_INS_VPSRLDQ,
            1363 => x86_insn::X86_INS_VPSRLD,
            1364 => x86_insn::X86_INS_VPSRLQ,
            1365 => x86_insn::X86_INS_VPSRLVD,
            1366 => x86_insn::X86_INS_VPSRLVQ,
            1367 => x86_insn::X86_INS_VPSRLVW,
            1368 => x86_insn::X86_INS_VPSRLW,
            1369 => x86_insn::X86_INS_VPSUBB,
            1370 => x86_insn::X86_INS_VPSUBD,
            1371 => x86_insn::X86_INS_VPSUBQ,
            1372 => x86_insn::X86_INS_VPSUBSB,
            1373 => x86_insn::X86_INS_VPSUBSW,
            1374 => x86_insn::X86_INS_VPSUBUSB,
            1375 => x86_insn::X86_INS_VPSUBUSW,
            1376 => x86_insn::X86_INS_VPSUBW,
            1377 => x86_insn::X86_INS_VPTERNLOGD,
            1378 => x86_insn::X86_INS_VPTERNLOGQ,
            1379 => x86_insn::X86_INS_VPTESTMB,
            1380 => x86_insn::X86_INS_VPTESTMD,
            1381 => x86_insn::X86_INS_VPTESTMQ,
            1382 => x86_insn::X86_INS_VPTESTMW,
            1383 => x86_insn::X86_INS_VPTESTNMB,
            1384 => x86_insn::X86_INS_VPTESTNMD,
            1385 => x86_insn::X86_INS_VPTESTNMQ,
            1386 => x86_insn::X86_INS_VPTESTNMW,
            1387 => x86_insn::X86_INS_VPTEST,
            1388 => x86_insn::X86_INS_VPUNPCKHBW,
            1389 => x86_insn::X86_INS_VPUNPCKHDQ,
            1390 => x86_insn::X86_INS_VPUNPCKHQDQ,
            1391 => x86_insn::X86_INS_VPUNPCKHWD,
            1392 => x86_insn::X86_INS_VPUNPCKLBW,
            1393 => x86_insn::X86_INS_VPUNPCKLDQ,
            1394 => x86_insn::X86_INS_VPUNPCKLQDQ,
            1395 => x86_insn::X86_INS_VPUNPCKLWD,
            1396 => x86_insn::X86_INS_VPXORD,
            1397 => x86_insn::X86_INS_VPXORQ,
            1398 => x86_insn::X86_INS_VPXOR,
            1399 => x86_insn::X86_INS_VRANGEPD,
            1400 => x86_insn::X86_INS_VRANGEPS,
            1401 => x86_insn::X86_INS_VRANGESD,
            1402 => x86_insn::X86_INS_VRANGESS,
            1403 => x86_insn::X86_INS_VRCP14PD,
            1404 => x86_insn::X86_INS_VRCP14PS,
            1405 => x86_insn::X86_INS_VRCP14SD,
            1406 => x86_insn::X86_INS_VRCP14SS,
            1407 => x86_insn::X86_INS_VRCP28PD,
            1408 => x86_insn::X86_INS_VRCP28PS,
            1409 => x86_insn::X86_INS_VRCP28SD,
            1410 => x86_insn::X86_INS_VRCP28SS,
            1411 => x86_insn::X86_INS_VRCPPS,
            1412 => x86_insn::X86_INS_VRCPSS,
            1413 => x86_insn::X86_INS_VREDUCEPD,
            1414 => x86_insn::X86_INS_VREDUCEPS,
            1415 => x86_insn::X86_INS_VREDUCESD,
            1416 => x86_insn::X86_INS_VREDUCESS,
            1417 => x86_insn::X86_INS_VRNDSCALEPD,
            1418 => x86_insn::X86_INS_VRNDSCALEPS,
            1419 => x86_insn::X86_INS_VRNDSCALESD,
            1420 => x86_insn::X86_INS_VRNDSCALESS,
            1421 => x86_insn::X86_INS_VROUNDPD,
            1422 => x86_insn::X86_INS_VROUNDPS,
            1423 => x86_insn::X86_INS_VROUNDSD,
            1424 => x86_insn::X86_INS_VROUNDSS,
            1425 => x86_insn::X86_INS_VRSQRT14PD,
            1426 => x86_insn::X86_INS_VRSQRT14PS,
            1427 => x86_insn::X86_INS_VRSQRT14SD,
            1428 => x86_insn::X86_INS_VRSQRT14SS,
            1429 => x86_insn::X86_INS_VRSQRT28PD,
            1430 => x86_insn::X86_INS_VRSQRT28PS,
            1431 => x86_insn::X86_INS_VRSQRT28SD,
            1432 => x86_insn::X86_INS_VRSQRT28SS,
            1433 => x86_insn::X86_INS_VRSQRTPS,
            1434 => x86_insn::X86_INS_VRSQRTSS,
            1435 => x86_insn::X86_INS_VSCALEFPD,
            1436 => x86_insn::X86_INS_VSCALEFPS,
            1437 => x86_insn::X86_INS_VSCALEFSD,
            1438 => x86_insn::X86_INS_VSCALEFSS,
            1439 => x86_insn::X86_INS_VSCATTERDPD,
            1440 => x86_insn::X86_INS_VSCATTERDPS,
            1441 => x86_insn::X86_INS_VSCATTERPF0DPD,
            1442 => x86_insn::X86_INS_VSCATTERPF0DPS,
            1443 => x86_insn::X86_INS_VSCATTERPF0QPD,
            1444 => x86_insn::X86_INS_VSCATTERPF0QPS,
            1445 => x86_insn::X86_INS_VSCATTERPF1DPD,
            1446 => x86_insn::X86_INS_VSCATTERPF1DPS,
            1447 => x86_insn::X86_INS_VSCATTERPF1QPD,
            1448 => x86_insn::X86_INS_VSCATTERPF1QPS,
            1449 => x86_insn::X86_INS_VSCATTERQPD,
            1450 => x86_insn::X86_INS_VSCATTERQPS,
            1451 => x86_insn::X86_INS_VSHUFF32X4,
            1452 => x86_insn::X86_INS_VSHUFF64X2,
            1453 => x86_insn::X86_INS_VSHUFI32X4,
            1454 => x86_insn::X86_INS_VSHUFI64X2,
            1455 => x86_insn::X86_INS_VSHUFPD,
            1456 => x86_insn::X86_INS_VSHUFPS,
            1457 => x86_insn::X86_INS_VSQRTPD,
            1458 => x86_insn::X86_INS_VSQRTPS,
            1459 => x86_insn::X86_INS_VSQRTSD,
            1460 => x86_insn::X86_INS_VSQRTSS,
            1461 => x86_insn::X86_INS_VSTMXCSR,
            1462 => x86_insn::X86_INS_VSUBPD,
            1463 => x86_insn::X86_INS_VSUBPS,
            1464 => x86_insn::X86_INS_VSUBSD,
            1465 => x86_insn::X86_INS_VSUBSS,
            1466 => x86_insn::X86_INS_VTESTPD,
            1467 => x86_insn::X86_INS_VTESTPS,
            1468 => x86_insn::X86_INS_VUCOMISD,
            1469 => x86_insn::X86_INS_VUCOMISS,
            1470 => x86_insn::X86_INS_VUNPCKHPD,
            1471 => x86_insn::X86_INS_VUNPCKHPS,
            1472 => x86_insn::X86_INS_VUNPCKLPD,
            1473 => x86_insn::X86_INS_VUNPCKLPS,
            1474 => x86_insn::X86_INS_VXORPD,
            1475 => x86_insn::X86_INS_VXORPS,
            1476 => x86_insn::X86_INS_VZEROALL,
            1477 => x86_insn::X86_INS_VZEROUPPER,
            1478 => x86_insn::X86_INS_WAIT,
            1479 => x86_insn::X86_INS_WBINVD,
            1480 => x86_insn::X86_INS_WBNOINVD,
            1481 => x86_insn::X86_INS_WRFSBASE,
            1482 => x86_insn::X86_INS_WRGSBASE,
            1483 => x86_insn::X86_INS_WRMSR,
            1484 => x86_insn::X86_INS_WRPKRU,
            1485 => x86_insn::X86_INS_WRSSD,
            1486 => x86_insn::X86_INS_WRSSQ,
            1487 => x86_insn::X86_INS_WRUSSD,
            1488 => x86_insn::X86_INS_WRUSSQ,
            1489 => x86_insn::X86_INS_XABORT,
            1490 => x86_insn::X86_INS_XACQUIRE,
            1491 => x86_insn::X86_INS_XADD,
            1492 => x86_insn::X86_INS_XBEGIN,
            1493 => x86_insn::X86_INS_XCHG,
            1494 => x86_insn::X86_INS_FXCH,
            1495 => x86_insn::X86_INS_XCRYPTCBC,
            1496 => x86_insn::X86_INS_XCRYPTCFB,
            1497 => x86_insn::X86_INS_XCRYPTCTR,
            1498 => x86_insn::X86_INS_XCRYPTECB,
            1499 => x86_insn::X86_INS_XCRYPTOFB,
            1500 => x86_insn::X86_INS_XEND,
            1501 => x86_insn::X86_INS_XGETBV,
            1502 => x86_insn::X86_INS_XLATB,
            1503 => x86_insn::X86_INS_XOR,
            1504 => x86_insn::X86_INS_XORPD,
            1505 => x86_insn::X86_INS_XORPS,
            1506 => x86_insn::X86_INS_XRELEASE,
            1507 => x86_insn::X86_INS_XRSTOR,
            1508 => x86_insn::X86_INS_XRSTOR64,
            1509 => x86_insn::X86_INS_XRSTORS,
            1510 => x86_insn::X86_INS_XRSTORS64,
            1511 => x86_insn::X86_INS_XSAVE,
            1512 => x86_insn::X86_INS_XSAVE64,
            1513 => x86_insn::X86_INS_XSAVEC,
            1514 => x86_insn::X86_INS_XSAVEC64,
            1515 => x86_insn::X86_INS_XSAVEOPT,
            1516 => x86_insn::X86_INS_XSAVEOPT64,
            1517 => x86_insn::X86_INS_XSAVES,
            1518 => x86_insn::X86_INS_XSAVES64,
            1519 => x86_insn::X86_INS_XSETBV,
            1520 => x86_insn::X86_INS_XSHA1,
            1521 => x86_insn::X86_INS_XSHA256,
            1522 => x86_insn::X86_INS_XSTORE,
            1523 => x86_insn::X86_INS_XTEST,
            1524 => x86_insn::X86_INS_ENDING,
            _ => x86_insn::X86_INS_INVALID,
        }
    }
}
impl From<u32> for xcore_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => xcore_insn::XCORE_INS_INVALID,
            1 => xcore_insn::XCORE_INS_ADD,
            2 => xcore_insn::XCORE_INS_ANDNOT,
            3 => xcore_insn::XCORE_INS_AND,
            4 => xcore_insn::XCORE_INS_ASHR,
            5 => xcore_insn::XCORE_INS_BAU,
            6 => xcore_insn::XCORE_INS_BITREV,
            7 => xcore_insn::XCORE_INS_BLA,
            8 => xcore_insn::XCORE_INS_BLAT,
            9 => xcore_insn::XCORE_INS_BL,
            10 => xcore_insn::XCORE_INS_BF,
            11 => xcore_insn::XCORE_INS_BT,
            12 => xcore_insn::XCORE_INS_BU,
            13 => xcore_insn::XCORE_INS_BRU,
            14 => xcore_insn::XCORE_INS_BYTEREV,
            15 => xcore_insn::XCORE_INS_CHKCT,
            16 => xcore_insn::XCORE_INS_CLRE,
            17 => xcore_insn::XCORE_INS_CLRPT,
            18 => xcore_insn::XCORE_INS_CLRSR,
            19 => xcore_insn::XCORE_INS_CLZ,
            20 => xcore_insn::XCORE_INS_CRC8,
            21 => xcore_insn::XCORE_INS_CRC32,
            22 => xcore_insn::XCORE_INS_DCALL,
            23 => xcore_insn::XCORE_INS_DENTSP,
            24 => xcore_insn::XCORE_INS_DGETREG,
            25 => xcore_insn::XCORE_INS_DIVS,
            26 => xcore_insn::XCORE_INS_DIVU,
            27 => xcore_insn::XCORE_INS_DRESTSP,
            28 => xcore_insn::XCORE_INS_DRET,
            29 => xcore_insn::XCORE_INS_ECALLF,
            30 => xcore_insn::XCORE_INS_ECALLT,
            31 => xcore_insn::XCORE_INS_EDU,
            32 => xcore_insn::XCORE_INS_EEF,
            33 => xcore_insn::XCORE_INS_EET,
            34 => xcore_insn::XCORE_INS_EEU,
            35 => xcore_insn::XCORE_INS_ENDIN,
            36 => xcore_insn::XCORE_INS_ENTSP,
            37 => xcore_insn::XCORE_INS_EQ,
            38 => xcore_insn::XCORE_INS_EXTDP,
            39 => xcore_insn::XCORE_INS_EXTSP,
            40 => xcore_insn::XCORE_INS_FREER,
            41 => xcore_insn::XCORE_INS_FREET,
            42 => xcore_insn::XCORE_INS_GETD,
            43 => xcore_insn::XCORE_INS_GET,
            44 => xcore_insn::XCORE_INS_GETN,
            45 => xcore_insn::XCORE_INS_GETR,
            46 => xcore_insn::XCORE_INS_GETSR,
            47 => xcore_insn::XCORE_INS_GETST,
            48 => xcore_insn::XCORE_INS_GETTS,
            49 => xcore_insn::XCORE_INS_INCT,
            50 => xcore_insn::XCORE_INS_INIT,
            51 => xcore_insn::XCORE_INS_INPW,
            52 => xcore_insn::XCORE_INS_INSHR,
            53 => xcore_insn::XCORE_INS_INT,
            54 => xcore_insn::XCORE_INS_IN,
            55 => xcore_insn::XCORE_INS_KCALL,
            56 => xcore_insn::XCORE_INS_KENTSP,
            57 => xcore_insn::XCORE_INS_KRESTSP,
            58 => xcore_insn::XCORE_INS_KRET,
            59 => xcore_insn::XCORE_INS_LADD,
            60 => xcore_insn::XCORE_INS_LD16S,
            61 => xcore_insn::XCORE_INS_LD8U,
            62 => xcore_insn::XCORE_INS_LDA16,
            63 => xcore_insn::XCORE_INS_LDAP,
            64 => xcore_insn::XCORE_INS_LDAW,
            65 => xcore_insn::XCORE_INS_LDC,
            66 => xcore_insn::XCORE_INS_LDW,
            67 => xcore_insn::XCORE_INS_LDIVU,
            68 => xcore_insn::XCORE_INS_LMUL,
            69 => xcore_insn::XCORE_INS_LSS,
            70 => xcore_insn::XCORE_INS_LSUB,
            71 => xcore_insn::XCORE_INS_LSU,
            72 => xcore_insn::XCORE_INS_MACCS,
            73 => xcore_insn::XCORE_INS_MACCU,
            74 => xcore_insn::XCORE_INS_MJOIN,
            75 => xcore_insn::XCORE_INS_MKMSK,
            76 => xcore_insn::XCORE_INS_MSYNC,
            77 => xcore_insn::XCORE_INS_MUL,
            78 => xcore_insn::XCORE_INS_NEG,
            79 => xcore_insn::XCORE_INS_NOT,
            80 => xcore_insn::XCORE_INS_OR,
            81 => xcore_insn::XCORE_INS_OUTCT,
            82 => xcore_insn::XCORE_INS_OUTPW,
            83 => xcore_insn::XCORE_INS_OUTSHR,
            84 => xcore_insn::XCORE_INS_OUTT,
            85 => xcore_insn::XCORE_INS_OUT,
            86 => xcore_insn::XCORE_INS_PEEK,
            87 => xcore_insn::XCORE_INS_REMS,
            88 => xcore_insn::XCORE_INS_REMU,
            89 => xcore_insn::XCORE_INS_RETSP,
            90 => xcore_insn::XCORE_INS_SETCLK,
            91 => xcore_insn::XCORE_INS_SET,
            92 => xcore_insn::XCORE_INS_SETC,
            93 => xcore_insn::XCORE_INS_SETD,
            94 => xcore_insn::XCORE_INS_SETEV,
            95 => xcore_insn::XCORE_INS_SETN,
            96 => xcore_insn::XCORE_INS_SETPSC,
            97 => xcore_insn::XCORE_INS_SETPT,
            98 => xcore_insn::XCORE_INS_SETRDY,
            99 => xcore_insn::XCORE_INS_SETSR,
            100 => xcore_insn::XCORE_INS_SETTW,
            101 => xcore_insn::XCORE_INS_SETV,
            102 => xcore_insn::XCORE_INS_SEXT,
            103 => xcore_insn::XCORE_INS_SHL,
            104 => xcore_insn::XCORE_INS_SHR,
            105 => xcore_insn::XCORE_INS_SSYNC,
            106 => xcore_insn::XCORE_INS_ST16,
            107 => xcore_insn::XCORE_INS_ST8,
            108 => xcore_insn::XCORE_INS_STW,
            109 => xcore_insn::XCORE_INS_SUB,
            110 => xcore_insn::XCORE_INS_SYNCR,
            111 => xcore_insn::XCORE_INS_TESTCT,
            112 => xcore_insn::XCORE_INS_TESTLCL,
            113 => xcore_insn::XCORE_INS_TESTWCT,
            114 => xcore_insn::XCORE_INS_TSETMR,
            115 => xcore_insn::XCORE_INS_START,
            116 => xcore_insn::XCORE_INS_WAITEF,
            117 => xcore_insn::XCORE_INS_WAITET,
            118 => xcore_insn::XCORE_INS_WAITEU,
            119 => xcore_insn::XCORE_INS_XOR,
            120 => xcore_insn::XCORE_INS_ZEXT,
            121 => xcore_insn::XCORE_INS_ENDING,
            _ => xcore_insn::XCORE_INS_INVALID,
        }
    }
}
impl From<u32> for bpf_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => bpf_insn::BPF_INS_INVALID,
            1 => bpf_insn::BPF_INS_ADD,
            2 => bpf_insn::BPF_INS_SUB,
            3 => bpf_insn::BPF_INS_MUL,
            4 => bpf_insn::BPF_INS_DIV,
            5 => bpf_insn::BPF_INS_OR,
            6 => bpf_insn::BPF_INS_AND,
            7 => bpf_insn::BPF_INS_LSH,
            8 => bpf_insn::BPF_INS_RSH,
            9 => bpf_insn::BPF_INS_NEG,
            10 => bpf_insn::BPF_INS_MOD,
            11 => bpf_insn::BPF_INS_XOR,
            12 => bpf_insn::BPF_INS_MOV,
            13 => bpf_insn::BPF_INS_ARSH,
            14 => bpf_insn::BPF_INS_ADD64,
            15 => bpf_insn::BPF_INS_SUB64,
            16 => bpf_insn::BPF_INS_MUL64,
            17 => bpf_insn::BPF_INS_DIV64,
            18 => bpf_insn::BPF_INS_OR64,
            19 => bpf_insn::BPF_INS_AND64,
            20 => bpf_insn::BPF_INS_LSH64,
            21 => bpf_insn::BPF_INS_RSH64,
            22 => bpf_insn::BPF_INS_NEG64,
            23 => bpf_insn::BPF_INS_MOD64,
            24 => bpf_insn::BPF_INS_XOR64,
            25 => bpf_insn::BPF_INS_MOV64,
            26 => bpf_insn::BPF_INS_ARSH64,
            27 => bpf_insn::BPF_INS_LE16,
            28 => bpf_insn::BPF_INS_LE32,
            29 => bpf_insn::BPF_INS_LE64,
            30 => bpf_insn::BPF_INS_BE16,
            31 => bpf_insn::BPF_INS_BE32,
            32 => bpf_insn::BPF_INS_BE64,
            33 => bpf_insn::BPF_INS_LDW,
            34 => bpf_insn::BPF_INS_LDH,
            35 => bpf_insn::BPF_INS_LDB,
            36 => bpf_insn::BPF_INS_LDDW,
            37 => bpf_insn::BPF_INS_LDXW,
            38 => bpf_insn::BPF_INS_LDXH,
            39 => bpf_insn::BPF_INS_LDXB,
            40 => bpf_insn::BPF_INS_LDXDW,
            41 => bpf_insn::BPF_INS_STW,
            42 => bpf_insn::BPF_INS_STH,
            43 => bpf_insn::BPF_INS_STB,
            44 => bpf_insn::BPF_INS_STDW,
            45 => bpf_insn::BPF_INS_STXW,
            46 => bpf_insn::BPF_INS_STXH,
            47 => bpf_insn::BPF_INS_STXB,
            48 => bpf_insn::BPF_INS_STXDW,
            49 => bpf_insn::BPF_INS_XADDW,
            50 => bpf_insn::BPF_INS_XADDDW,
            51 => bpf_insn::BPF_INS_JMP,
            52 => bpf_insn::BPF_INS_JEQ,
            53 => bpf_insn::BPF_INS_JGT,
            54 => bpf_insn::BPF_INS_JGE,
            55 => bpf_insn::BPF_INS_JSET,
            56 => bpf_insn::BPF_INS_JNE,
            57 => bpf_insn::BPF_INS_JSGT,
            58 => bpf_insn::BPF_INS_JSGE,
            59 => bpf_insn::BPF_INS_CALL,
            60 => bpf_insn::BPF_INS_EXIT,
            61 => bpf_insn::BPF_INS_JLT,
            62 => bpf_insn::BPF_INS_JLE,
            63 => bpf_insn::BPF_INS_JSLT,
            64 => bpf_insn::BPF_INS_JSLE,
            65 => bpf_insn::BPF_INS_RET,
            66 => bpf_insn::BPF_INS_TAX,
            67 => bpf_insn::BPF_INS_TXA,
            68 => bpf_insn::BPF_INS_ENDING,
            _ => bpf_insn::BPF_INS_INVALID,
        }
    }
}
