//! Low-level GraphQL queries used by this crate.
//!
//! If possible, users should prefer the high-level functions exposed under
//! [`crate`].
//!
//! This module is primarily used in combination with
//! [`crate::graphql::execute_query()`] as an "escape hatch" for accessing
//! information that may not be exposed via the high-level functions.
//!
//! # Backwards Compatibility
//!
//! Queries won't be deleted or have breaking changes to their inputs during
//! patch releases, however new fields may be added to the response types
//! generated by `graphql_client` at any time.
//!
//! Users should treat all response types as if they had the `#[non_exhaustive]`
//! attribute.

use graphql_client::GraphQLQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_package_version.graphql",
    response_derives = "Debug"
)]
pub(crate) struct GetPackageVersionQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_package_by_command.graphql",
    response_derives = "Debug"
)]
pub(crate) struct GetPackageByCommandQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/test_if_registry_present.graphql",
    response_derives = "Debug"
)]
pub(crate) struct TestIfRegistryPresent;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_bindings.graphql",
    response_derives = "Debug,Clone,PartialEq,Eq"
)]
pub(crate) struct GetBindingsQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_signed_url.graphql",
    response_derives = "Debug, Clone"
)]
pub(crate) struct GetSignedUrl;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/get_interface_version.graphql",
    response_derives = "Debug"
)]
pub(crate) struct GetInterfaceVersionQuery;

#[derive(GraphQLQuery)]
#[graphql(
    schema_path = "graphql/schema.graphql",
    query_path = "graphql/queries/whoami.graphql",
    response_derives = "Debug"
)]
pub struct WhoAmIQuery;
