#ifndef CHUNK_TAG_T_H_INCLUDED
#define CHUNK_TAG_T_H_INCLUDED
static chunk_tag_t keywords[] =
{
   // TODO: it might be useful if users could add their custom keywords to this list
   { "@autoreleasepool",                CT_AUTORELEASEPOOL,  e_LANG_OC                                                                                 },
   { "@available",                      CT_OC_AVAILABLE,     e_LANG_OC                                                                                 },
   { "@catch",                          CT_CATCH,            e_LANG_OC                                                                                 },
   { "@dynamic",                        CT_OC_DYNAMIC,       e_LANG_OC                                                                                 },
   { "@end",                            CT_OC_END,           e_LANG_OC                                                                                 },
   { "@finally",                        CT_FINALLY,          e_LANG_OC                                                                                 },
   { "@implementation",                 CT_OC_IMPL,          e_LANG_OC                                                                                 },
   { "@interface",                      CT_OC_INTF,          e_LANG_OC                                                                                 },
   { "@interface",                      CT_CLASS,            e_LANG_JAVA                                                                               },
   { "@private",                        CT_ACCESS,           e_LANG_OC                                                                                 },
   { "@property",                       CT_OC_PROPERTY,      e_LANG_OC                                                                                 },
   { "@protected",                      CT_ACCESS,           e_LANG_OC                                                                                 },
   { "@protocol",                       CT_OC_PROTOCOL,      e_LANG_OC                                                                                 },
   { "@public",                         CT_ACCESS,           e_LANG_OC                                                                                 },
   { "@selector",                       CT_OC_SEL,           e_LANG_OC                                                                                 },
   { "@synchronized",                   CT_SYNCHRONIZED,     e_LANG_OC                                                                                 },
   { "@synthesize",                     CT_OC_DYNAMIC,       e_LANG_OC                                                                                 },
   { "@throw",                          CT_THROW,            e_LANG_OC                                                                                 },
   { "@try",                            CT_TRY,              e_LANG_OC                                                                                 },
   { "API_AVAILABLE",                   CT_ATTRIBUTE,        e_LANG_OC                                                                                 },
   { "API_DEPRECATED",                  CT_ATTRIBUTE,        e_LANG_OC                                                                                 },
   { "API_DEPRECATED_WITH_REPLACEMENT", CT_ATTRIBUTE,        e_LANG_OC                                                                                 },
   { "API_UNAVAILABLE",                 CT_ATTRIBUTE,        e_LANG_OC                                                                                 },
   { "BOOL",                            CT_TYPE,             e_LANG_OC                                                                                 },
   { "INT16_C",                         CT_TYPE,             e_LANG_CPP                                                                                },
   { "INT32_C",                         CT_TYPE,             e_LANG_CPP                                                                                },
   { "INT64_C",                         CT_TYPE,             e_LANG_CPP                                                                                },
   { "INT8_C",                          CT_TYPE,             e_LANG_CPP                                                                                },
   { "INTMAX_C",                        CT_TYPE,             e_LANG_CPP                                                                                },
   { "NS_ENUM",                         CT_ENUM,             e_LANG_OC                                                                                 },
   { "NS_OPTIONS",                      CT_ENUM,             e_LANG_OC                                                                                 },
   { "Q_EMIT",                          CT_Q_EMIT,           e_LANG_CPP                                                                                },
   { "Q_FOREACH",                       CT_FOR,              e_LANG_CPP                                                                                },
   { "Q_FOREVER",                       CT_Q_FOREVER,        e_LANG_CPP                                                                                },
   { "Q_GADGET",                        CT_Q_GADGET,         e_LANG_CPP                                                                                },
   { "Q_OBJECT",                        CT_COMMENT_EMBED,    e_LANG_CPP                                                                                },
   { "Q_SIGNALS",                       CT_ACCESS,           e_LANG_CPP                                                                                },
   { "UINT16_C",                        CT_TYPE,             e_LANG_CPP                                                                                },
   { "UINT32_C",                        CT_TYPE,             e_LANG_CPP                                                                                },
   { "UINT64_C",                        CT_TYPE,             e_LANG_CPP                                                                                },
   { "UINT8_C",                         CT_TYPE,             e_LANG_CPP                                                                                },
   { "UINTMAX_C",                       CT_TYPE,             e_LANG_CPP                                                                                },
   { "_Bool",                           CT_TYPE,             e_LANG_C | e_LANG_CPP                                                                     },
   { "_Complex",                        CT_TYPE,             e_LANG_C | e_LANG_CPP                                                                     },
   { "_Imaginary",                      CT_TYPE,             e_LANG_C | e_LANG_CPP                                                                     },
   { "_Nonnull",                        CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "_Null_unspecified",               CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "_Nullable",                       CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "_Pragma",                         CT_PP_PRAGMA,        e_LANG_ALL | e_FLAG_PP                                                                    },
   { "__DI__",                          CT_DI,               e_LANG_C | e_LANG_CPP                                                                     },
   { "__HI__",                          CT_HI,               e_LANG_C | e_LANG_CPP                                                                     },
   { "__QI__",                          CT_QI,               e_LANG_C | e_LANG_CPP                                                                     },
   { "__SI__",                          CT_SI,               e_LANG_C | e_LANG_CPP                                                                     },
   { "__asm__",                         CT_ASM,              e_LANG_C | e_LANG_CPP                                                                     },
   { "__attribute__",                   CT_ATTRIBUTE,        e_LANG_C | e_LANG_CPP | e_LANG_OC                                                         },
   { "__autoreleasing",                 CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__block",                         CT_QUALIFIER,        e_LANG_C | e_LANG_CPP | e_LANG_OC                                                         },
   { "__bridge",                        CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__bridge_retained",               CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__bridge_transfer",               CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__const__",                       CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__declspec",                      CT_DECLSPEC,         e_LANG_C | e_LANG_CPP                                                                     },
   { "__except",                        CT_CATCH,            e_LANG_C | e_LANG_CPP                                                                     },
   { "__finally",                       CT_FINALLY,          e_LANG_C | e_LANG_CPP                                                                     },
   { "__has_include",                   CT_CNG_HASINC,       e_LANG_C | e_LANG_CPP | e_LANG_OC | e_FLAG_PP                                             },
   { "__has_include_next",              CT_CNG_HASINCN,      e_LANG_C | e_LANG_CPP | e_FLAG_PP                                                         },
   { "__inline__",                      CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__nonnull",                       CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "__nothrow__",                     CT_NOTHROW,          e_LANG_C | e_LANG_CPP                                                                     },
   { "__null_unspecified",              CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "__nullable",                      CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "__pragma",                        CT_PP_PRAGMA,        e_LANG_ALL | e_FLAG_PP                                                                    },
   { "__restrict",                      CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__signed__",                      CT_TYPE,             e_LANG_C | e_LANG_CPP                                                                     },
   { "__strong",                        CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__thread",                        CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__traits",                        CT_QUALIFIER,        e_LANG_D                                                                                  },
   { "__try",                           CT_TRY,              e_LANG_C | e_LANG_CPP                                                                     },
   { "__typeof",                        CT_DECLTYPE,         e_LANG_C | e_LANG_CPP | e_LANG_OC                                                         },
   { "__typeof__",                      CT_DECLTYPE,         e_LANG_C | e_LANG_CPP                                                                     },
   { "__unsafe_unretained",             CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "__unused",                        CT_ATTRIBUTE,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__volatile__",                    CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__weak",                          CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "__word__",                        CT_WORD_,            e_LANG_C | e_LANG_CPP                                                                     },
   { "abstract",                        CT_QUALIFIER,        e_LANG_CS | e_LANG_D | e_LANG_JAVA | e_LANG_VALA | e_LANG_ECMA                            },
   { "add",                             CT_GETSET,           e_LANG_CS                                                                                 },
   { "alias",                           CT_USING,            e_LANG_D                                                                                  },
   { "align",                           CT_ALIGN,            e_LANG_D                                                                                  },
   { "alignof",                         CT_SIZEOF,           e_LANG_CPP                                                                                },
   { "and",                             CT_SBOOL,            e_LANG_CPP                                                                                },
   { "and_eq",                          CT_SASSIGN,          e_LANG_CPP                                                                                },
   { "as",                              CT_AS,               e_LANG_CS | e_LANG_VALA                                                                   },
   { "asm",                             CT_ASM,              e_LANG_C | e_LANG_CPP | e_LANG_D                                                          },
   { "asm",                             CT_PP_ASM,           e_LANG_ALL | e_FLAG_PP                                                                    },
   { "assert",                          CT_ASSERT,           e_LANG_JAVA                                                                               },
   { "assert",                          CT_FUNCTION,         e_LANG_D | e_LANG_PAWN                                                                    },
   { "assert",                          CT_PP_ASSERT,        e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "async",                           CT_QUALIFIER,        e_LANG_VALA                                                                               },
   { "auto",                            CT_TYPE,             e_LANG_C | e_LANG_CPP | e_LANG_D                                                          },
   { "base",                            CT_BASE,             e_LANG_CS | e_LANG_VALA                                                                   },
   { "bit",                             CT_TYPE,             e_LANG_D                                                                                  },
   { "bitand",                          CT_ARITH,            e_LANG_C | e_LANG_CPP                                                                     },
   { "bitor",                           CT_ARITH,            e_LANG_C | e_LANG_CPP                                                                     },
   { "body",                            CT_BODY,             e_LANG_D                                                                                  },
   { "bool",                            CT_TYPE,             e_LANG_C | e_LANG_CPP | e_LANG_CS | e_LANG_VALA                                           },
   { "boolean",                         CT_TYPE,             e_LANG_JAVA | e_LANG_ECMA                                                                 },
   { "break",                           CT_BREAK,            e_LANG_ALL                                                                                },
   { "byte",                            CT_TYPE,             e_LANG_CS | e_LANG_D | e_LANG_JAVA | e_LANG_ECMA                                          },
   { "case",                            CT_CASE,             e_LANG_ALL                                                                                },
   { "cast",                            CT_D_CAST,           e_LANG_D                                                                                  },
   { "catch",                           CT_CATCH,            e_LANG_CPP | e_LANG_CS | e_LANG_VALA | e_LANG_D | e_LANG_JAVA | e_LANG_ECMA               },
   { "cdouble",                         CT_TYPE,             e_LANG_D                                                                                  },
   { "cent",                            CT_TYPE,             e_LANG_D                                                                                  },
   { "cfloat",                          CT_TYPE,             e_LANG_D                                                                                  },
   { "char",                            CT_CHAR,             e_LANG_PAWN                                                                               },
   { "char",                            CT_TYPE,             e_LANG_ALLC                                                                               },
   { "checked",                         CT_QUALIFIER,        e_LANG_CS                                                                                 },
   { "class",                           CT_CLASS,            e_LANG_CPP | e_LANG_CS | e_LANG_D | e_LANG_JAVA | e_LANG_VALA | e_LANG_ECMA               },
   { "compl",                           CT_ARITH,            e_LANG_CPP                                                                                },
   { "const",                           CT_QUALIFIER,        e_LANG_ALL                                                                                },
   { "const_cast",                      CT_TYPE_CAST,        e_LANG_CPP                                                                                },
   { "constexpr",                       CT_QUALIFIER,        e_LANG_CPP                                                                                },
   { "construct",                       CT_CONSTRUCT,        e_LANG_VALA                                                                               },
   { "continue",                        CT_CONTINUE,         e_LANG_ALL                                                                                },
   { "creal",                           CT_TYPE,             e_LANG_D                                                                                  },
   { "dchar",                           CT_TYPE,             e_LANG_D                                                                                  },
   { "debug",                           CT_DEBUG,            e_LANG_D                                                                                  },
   { "debugger",                        CT_DEBUGGER,         e_LANG_ECMA                                                                               },
   { "decltype",                        CT_DECLTYPE,         e_LANG_CPP                                                                                },
   { "default",                         CT_DEFAULT,          e_LANG_ALL                                                                                },
   { "define",                          CT_PP_DEFINE,        e_LANG_ALL | e_FLAG_PP                                                                    },
   { "defined",                         CT_DEFINED,          e_LANG_PAWN                                                                               },
   { "defined",                         CT_PP_DEFINED,       e_LANG_ALLC | e_FLAG_PP                                                                   },
   { "delegate",                        CT_DELEGATE,         e_LANG_CS | e_LANG_VALA | e_LANG_D                                                        },
   { "delete",                          CT_DELETE,           e_LANG_CPP | e_LANG_D | e_LANG_ECMA | e_LANG_VALA                                         },
   { "deprecated",                      CT_QUALIFIER,        e_LANG_D                                                                                  },
   { "do",                              CT_DO,               e_LANG_ALL                                                                                },
   { "double",                          CT_TYPE,             e_LANG_ALLC                                                                               },
   { "dynamic",                         CT_QUALIFIER,        e_LANG_VALA                                                                               },
   { "dynamic_cast",                    CT_TYPE_CAST,        e_LANG_CPP                                                                                },
   { "elif",                            CT_PP_ELSE,          e_LANG_ALLC | e_FLAG_PP                                                                   },
   { "else",                            CT_ELSE,             e_LANG_ALL                                                                                },
   { "else",                            CT_PP_ELSE,          e_LANG_ALL | e_FLAG_PP                                                                    },
   { "elseif",                          CT_PP_ELSE,          e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "emit",                            CT_PP_EMIT,          e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "endif",                           CT_PP_ENDIF,         e_LANG_ALL | e_FLAG_PP                                                                    },
   { "endinput",                        CT_PP_ENDINPUT,      e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "endregion",                       CT_PP_ENDREGION,     e_LANG_ALL | e_FLAG_PP                                                                    },
   { "endscript",                       CT_PP_ENDINPUT,      e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "enum",                            CT_ENUM,             e_LANG_ALL                                                                                },
   { "error",                           CT_PP_ERROR,         e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "errordomain",                     CT_ENUM,             e_LANG_VALA                                                                               },
   { "event",                           CT_TYPE,             e_LANG_CS                                                                                 },
   { "exit",                            CT_FUNCTION,         e_LANG_PAWN                                                                               },
   { "explicit",                        CT_QUALIFIER,        e_LANG_CPP | e_LANG_CS                                                                    },
   { "export",                          CT_EXPORT,           e_LANG_CPP | e_LANG_D | e_LANG_ECMA                                                       },
   { "extends",                         CT_QUALIFIER,        e_LANG_JAVA | e_LANG_ECMA                                                                 },
   { "extern",                          CT_EXTERN,           e_LANG_C | e_LANG_CPP | e_LANG_OC | e_LANG_CS | e_LANG_D | e_LANG_VALA                    },
   { "false",                           CT_WORD,             e_LANG_ALL                                                                                },
   { "file",                            CT_PP_FILE,          e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "final",                           CT_QUALIFIER,        e_LANG_CPP | e_LANG_D | e_LANG_ECMA                                                       },
   { "finally",                         CT_FINALLY,          e_LANG_D | e_LANG_CS | e_LANG_VALA | e_LANG_ECMA | e_LANG_JAVA                            },
   { "fixed",                           CT_FIXED,            e_LANG_CS                                                                                 },
   { "flags",                           CT_TYPE,             e_LANG_VALA                                                                               },
   { "float",                           CT_TYPE,             e_LANG_ALLC                                                                               },
   { "for",                             CT_FOR,              e_LANG_ALL                                                                                },
   { "foreach",                         CT_FOR,              e_LANG_CS | e_LANG_D | e_LANG_VALA                                                        },
   { "foreach_reverse",                 CT_FOR,              e_LANG_D                                                                                  },
   { "forward",                         CT_FORWARD,          e_LANG_PAWN                                                                               },
   { "friend",                          CT_FRIEND,           e_LANG_CPP                                                                                },
   { "function",                        CT_FUNCTION,         e_LANG_D | e_LANG_ECMA                                                                    },
   { "get",                             CT_GETSET,           e_LANG_CS | e_LANG_VALA                                                                   },
   { "goto",                            CT_GOTO,             e_LANG_ALL                                                                                },
   { "idouble",                         CT_TYPE,             e_LANG_D                                                                                  },
   { "if",                              CT_IF,               e_LANG_ALL                                                                                },
   { "if",                              CT_PP_IF,            e_LANG_ALL | e_FLAG_PP                                                                    },
   { "ifdef",                           CT_PP_IF,            e_LANG_ALLC | e_FLAG_PP                                                                   },
   { "ifloat",                          CT_TYPE,             e_LANG_D                                                                                  },
   { "ifndef",                          CT_PP_IF,            e_LANG_ALLC | e_FLAG_PP                                                                   },
   { "implements",                      CT_QUALIFIER,        e_LANG_JAVA | e_LANG_ECMA                                                                 },
   { "implicit",                        CT_QUALIFIER,        e_LANG_CS                                                                                 },
   { "import",                          CT_IMPORT,           e_LANG_D | e_LANG_JAVA | e_LANG_ECMA                                                      },
   { "import",                          CT_PP_INCLUDE,       e_LANG_OC | e_FLAG_PP                                                                     },
   { "in",                              CT_IN,               e_LANG_D | e_LANG_CS | e_LANG_VALA | e_LANG_ECMA | e_LANG_OC                              },
   { "include",                         CT_PP_INCLUDE,       e_LANG_C | e_LANG_CPP | e_LANG_OC | e_LANG_PAWN | e_FLAG_PP                               },
   { "inline",                          CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "inout",                           CT_QUALIFIER,        e_LANG_D                                                                                  },
   { "instanceof",                      CT_SIZEOF,           e_LANG_JAVA | e_LANG_ECMA                                                                 },
   { "int",                             CT_TYPE,             e_LANG_ALLC                                                                               },
   { "interface",                       CT_CLASS,            e_LANG_CPP | e_LANG_CS | e_LANG_D | e_LANG_JAVA | e_LANG_VALA | e_LANG_ECMA               },
   { "internal",                        CT_QUALIFIER,        e_LANG_CS | e_LANG_VALA                                                                   },
   { "invariant",                       CT_INVARIANT,        e_LANG_D                                                                                  },
   { "ireal",                           CT_TYPE,             e_LANG_D                                                                                  },
   { "is",                              CT_SCOMPARE,         e_LANG_D | e_LANG_CS | e_LANG_VALA                                                        },
   { "lazy",                            CT_LAZY,             e_LANG_D                                                                                  },
   { "line",                            CT_PP_LINE,          e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "lock",                            CT_LOCK,             e_LANG_CS | e_LANG_VALA                                                                   },
   { "long",                            CT_TYPE,             e_LANG_ALLC                                                                               },
   { "macro",                           CT_D_MACRO,          e_LANG_D                                                                                  },
   { "mixin",                           CT_CLASS,            e_LANG_D                                                                                  }, // may need special handling
   { "module",                          CT_D_MODULE,         e_LANG_D                                                                                  },
   { "mutable",                         CT_QUALIFIER,        e_LANG_CPP                                                                                },
   { "namespace",                       CT_NAMESPACE,        e_LANG_CPP | e_LANG_CS | e_LANG_VALA                                                      },
   { "native",                          CT_NATIVE,           e_LANG_PAWN                                                                               },
   { "native",                          CT_QUALIFIER,        e_LANG_JAVA | e_LANG_ECMA                                                                 },
   { "new",                             CT_NEW,              e_LANG_CPP | e_LANG_CS | e_LANG_D | e_LANG_JAVA | e_LANG_PAWN | e_LANG_VALA | e_LANG_ECMA },
   { "noexcept",                        CT_NOEXCEPT,         e_LANG_CPP                                                                                },
   { "nonnull",                         CT_TYPE,             e_LANG_OC                                                                                 },
   { "not",                             CT_SARITH,           e_LANG_CPP                                                                                },
   { "not_eq",                          CT_SCOMPARE,         e_LANG_CPP                                                                                },
   { "null_resettable",                 CT_OC_PROPERTY_ATTR, e_LANG_OC                                                                                 },
   { "null_unspecified",                CT_TYPE,             e_LANG_OC                                                                                 },
   { "nullable",                        CT_TYPE,             e_LANG_OC                                                                                 },
   { "object",                          CT_TYPE,             e_LANG_CS                                                                                 },
   { "operator",                        CT_OPERATOR,         e_LANG_CPP | e_LANG_CS | e_LANG_PAWN                                                      },
   { "or",                              CT_SBOOL,            e_LANG_CPP                                                                                },
   { "or_eq",                           CT_SASSIGN,          e_LANG_CPP                                                                                },
   { "out",                             CT_QUALIFIER,        e_LANG_CS | e_LANG_D | e_LANG_VALA                                                        },
   { "override",                        CT_QUALIFIER,        e_LANG_CPP | e_LANG_CS | e_LANG_D | e_LANG_VALA                                           },
   { "owned",                           CT_QUALIFIER,        e_LANG_VALA                                                                               },
   { "package",                         CT_ACCESS,           e_LANG_D                                                                                  },
   { "package",                         CT_PACKAGE,          e_LANG_ECMA | e_LANG_JAVA                                                                 },
   { "params",                          CT_TYPE,             e_LANG_CS | e_LANG_VALA                                                                   },
   { "pragma",                          CT_PP_PRAGMA,        e_LANG_ALL | e_FLAG_PP                                                                    },
   { "private",                         CT_ACCESS,           e_LANG_ALLC_NOT_C                                                                         }, // Issue # 4044
   { "property",                        CT_PP_PROPERTY,      e_LANG_CS | e_FLAG_PP                                                                     },
   { "protected",                       CT_ACCESS,           e_LANG_ALLC_NOT_C                                                                         }, // Issue # 4044
   { "public",                          CT_ACCESS,           e_LANG_ALLC_NOT_C                                                                         }, // Issue # 4044
   { "readonly",                        CT_QUALIFIER,        e_LANG_CS                                                                                 },
   { "real",                            CT_TYPE,             e_LANG_D                                                                                  },
   { "ref",                             CT_QUALIFIER,        e_LANG_CS | e_LANG_VALA                                                                   },
   { "region",                          CT_PP_REGION,        e_LANG_ALL | e_FLAG_PP                                                                    },
   { "register",                        CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "reinterpret_cast",                CT_TYPE_CAST,        e_LANG_CPP                                                                                },
   { "remove",                          CT_GETSET,           e_LANG_CS                                                                                 },
   { "restrict",                        CT_QUALIFIER,        e_LANG_C | e_LANG_CPP                                                                     },
   { "return",                          CT_RETURN,           e_LANG_ALL                                                                                },
   { "sbyte",                           CT_TYPE,             e_LANG_CS                                                                                 },
   { "scope",                           CT_D_SCOPE,          e_LANG_D                                                                                  },
   { "sealed",                          CT_QUALIFIER,        e_LANG_CS                                                                                 },
   { "section",                         CT_PP_SECTION,       e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "self",                            CT_THIS,             e_LANG_OC                                                                                 },
   { "set",                             CT_GETSET,           e_LANG_CS | e_LANG_VALA                                                                   },
   { "short",                           CT_TYPE,             e_LANG_ALLC                                                                               },
   { "signal",                          CT_ACCESS,           e_LANG_VALA                                                                               },
   { "signals",                         CT_ACCESS,           e_LANG_CPP                                                                                },
   { "signed",                          CT_TYPE,             e_LANG_C | e_LANG_CPP                                                                     },
   { "size_t",                          CT_TYPE,             e_LANG_ALLC                                                                               },
   { "sizeof",                          CT_SIZEOF,           e_LANG_C | e_LANG_CPP | e_LANG_CS | e_LANG_VALA | e_LANG_PAWN                             },
   { "sleep",                           CT_SIZEOF,           e_LANG_PAWN                                                                               },
   { "stackalloc",                      CT_NEW,              e_LANG_CS                                                                                 },
   { "state",                           CT_STATE,            e_LANG_PAWN                                                                               },
   { "static",                          CT_QUALIFIER,        e_LANG_ALL                                                                                },
   { "static_cast",                     CT_TYPE_CAST,        e_LANG_CPP                                                                                },
   { "stock",                           CT_STOCK,            e_LANG_PAWN                                                                               },
   { "strictfp",                        CT_QUALIFIER,        e_LANG_JAVA                                                                               },
   { "string",                          CT_TYPE,             e_LANG_CS | e_LANG_VALA                                                                   },
   { "struct",                          CT_STRUCT,           e_LANG_C | e_LANG_CPP | e_LANG_OC | e_LANG_CS | e_LANG_D | e_LANG_VALA                    },
   { "super",                           CT_SUPER,            e_LANG_D | e_LANG_JAVA | e_LANG_ECMA                                                      },
   { "switch",                          CT_SWITCH,           e_LANG_ALL                                                                                },
   { "synchronized",                    CT_QUALIFIER,        e_LANG_D | e_LANG_ECMA                                                                    },
   { "synchronized",                    CT_SYNCHRONIZED,     e_LANG_JAVA                                                                               },
   { "tagof",                           CT_TAGOF,            e_LANG_PAWN                                                                               },
   { "template",                        CT_TEMPLATE,         e_LANG_CPP | e_LANG_D                                                                     },
   { "this",                            CT_THIS,             e_LANG_CPP | e_LANG_CS | e_LANG_D | e_LANG_JAVA | e_LANG_VALA | e_LANG_ECMA               },
   { "throw",                           CT_THROW,            e_LANG_CPP | e_LANG_CS | e_LANG_VALA | e_LANG_D | e_LANG_JAVA | e_LANG_ECMA               },
   { "throws",                          CT_QUALIFIER,        e_LANG_JAVA | e_LANG_ECMA | e_LANG_VALA                                                   },
   { "transient",                       CT_QUALIFIER,        e_LANG_JAVA | e_LANG_ECMA                                                                 },
   { "true",                            CT_WORD,             e_LANG_ALL                                                                                },
   { "try",                             CT_TRY,              e_LANG_CPP | e_LANG_CS | e_LANG_D | e_LANG_JAVA | e_LANG_ECMA | e_LANG_VALA               },
   { "tryinclude",                      CT_PP_INCLUDE,       e_LANG_PAWN | e_FLAG_PP                                                                   },
   { "typedef",                         CT_TYPEDEF,          e_LANG_C | e_LANG_CPP | e_LANG_OC | e_LANG_D                                              },
   { "typeid",                          CT_SIZEOF,           e_LANG_CPP | e_LANG_D                                                                     },
   { "typename",                        CT_TYPENAME,         e_LANG_CPP                                                                                },
   { "typeof",                          CT_DECLTYPE,         e_LANG_C | e_LANG_CPP                                                                     },
   { "typeof",                          CT_SIZEOF,           e_LANG_CS | e_LANG_D | e_LANG_VALA | e_LANG_ECMA                                          },
   { "ubyte",                           CT_TYPE,             e_LANG_D                                                                                  },
   { "ucent",                           CT_TYPE,             e_LANG_D                                                                                  },
   { "uint",                            CT_TYPE,             e_LANG_CS | e_LANG_VALA | e_LANG_D                                                        },
   { "ulong",                           CT_TYPE,             e_LANG_CS | e_LANG_VALA | e_LANG_D                                                        },
   { "unchecked",                       CT_QUALIFIER,        e_LANG_CS                                                                                 },
   { "undef",                           CT_PP_UNDEF,         e_LANG_ALL | e_FLAG_PP                                                                    },
   { "union",                           CT_UNION,            e_LANG_C | e_LANG_CPP | e_LANG_D                                                          },
   { "unittest",                        CT_UNITTEST,         e_LANG_D                                                                                  },
   { "unowned",                         CT_QUALIFIER,        e_LANG_VALA                                                                               },
   { "unsafe",                          CT_UNSAFE,           e_LANG_CS                                                                                 },
   { "unsafe_unretained",               CT_QUALIFIER,        e_LANG_OC                                                                                 },
   { "unsigned",                        CT_TYPE,             e_LANG_C | e_LANG_CPP                                                                     },
   { "ushort",                          CT_TYPE,             e_LANG_CS | e_LANG_VALA | e_LANG_D                                                        },
   { "using",                           CT_USING,            e_LANG_CPP | e_LANG_CS | e_LANG_VALA                                                      },
   { "var",                             CT_TYPE,             e_LANG_CS | e_LANG_VALA | e_LANG_ECMA                                                     },
   { "version",                         CT_D_VERSION,        e_LANG_D                                                                                  },
   { "virtual",                         CT_QUALIFIER,        e_LANG_CPP | e_LANG_CS | e_LANG_VALA                                                      },
   { "void",                            CT_TYPE,             e_LANG_ALLC                                                                               },
   { "volatile",                        CT_QUALIFIER,        e_LANG_C | e_LANG_CPP | e_LANG_CS | e_LANG_JAVA | e_LANG_ECMA                             },
   { "volatile",                        CT_VOLATILE,         e_LANG_D                                                                                  },
   { "wchar",                           CT_TYPE,             e_LANG_D                                                                                  },
   { "wchar_t",                         CT_TYPE,             e_LANG_C | e_LANG_CPP                                                                     },
   { "weak",                            CT_QUALIFIER,        e_LANG_VALA                                                                               },
   { "when",                            CT_WHEN,             e_LANG_CS                                                                                 },
   { "where",                           CT_WHERE,            e_LANG_CS                                                                                 },
   { "while",                           CT_WHILE,            e_LANG_ALL                                                                                },
   { "with",                            CT_D_WITH,           e_LANG_D | e_LANG_ECMA                                                                    },
   { "xor",                             CT_SARITH,           e_LANG_CPP                                                                                },
   { "xor_eq",                          CT_SASSIGN,          e_LANG_CPP                                                                                },
};
#endif /* CHUNK_TAG_T_H_INCLUDED */
