/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class Symbol
extends ControlSequence
implements Expandable,
CaseChangeable {
    public static final Object[][] GENERIC_SYMBOLS = new Object[][]{{"{", new Integer(123)}, {"}", new Integer(125)}, {"%", new Integer(37)}, {"_", new Integer(95)}, {"&", new Integer(38)}, {"$", new Integer(36)}, {"#", new Integer(35)}, {"lbrack", new Integer(91)}, {"rbrack", new Integer(93)}};
    public static final Object[][] TEXT_SYMBOLS = new Object[][]{{"P", new Integer(182)}, {"S", new Integer(167)}, {"O", new Integer(216)}, {"o", new Integer(248)}, {"copyright", new Integer(169)}, {"ldots", new Integer(8230)}, {"pounds", new Integer(163)}, {"dag", new Integer(8224)}, {"ddag", new Integer(8225)}, {"slash", new Integer(47)}, {"textendash", new Integer(8211)}, {"textemdash", new Integer(8212)}, {"textasciicircum", new Integer(94)}, {"textasciitilde", new Integer(126)}, {"textbackslash", new Integer(92)}, {"textbar", new Integer(124)}, {"textbardbl", new Integer(8214)}, {"textbraceleft", new Integer(123)}, {"textbraceright", new Integer(125)}, {"textdollar", new Integer(36)}, {"textbullet", new Integer(8226)}, {"textexclamdown", new Integer(161)}, {"textgreater", new Integer(62)}, {"textless", new Integer(60)}, {"textperiodcentered", new Integer(183)}, {"textasteriskcentered", new Integer(65290)}, {"textquestiondown", new Integer(191)}, {"textquotedbl", new Integer(34)}, {"textquotedblleft", new Integer(8220)}, {"textquotedblright", new Integer(8221)}, {"textquoteleft", new Integer(8216)}, {"textquoteright", new Integer(8217)}, {"textsection", new Integer(167)}, {"textparagraph", new Integer(182)}, {"textsterling", new Integer(163)}, {"textregistered", new Integer(174)}, {"texttrademark", new Integer(8482)}, {"textunderscore", new Integer(95)}, {"textvisiblespace", new Integer(9251)}, {"textperthousand", new Integer(8240)}, {"textpertenthousand", new Integer(8241)}, {"textasteriskcentered", new Integer(8727)}, {"textdagger", new Integer(8224)}, {"textdaggerdbl", new Integer(8225)}, {"guilsinglleft", new Integer(8249)}, {"guilsinglright", new Integer(8250)}, {"guillemotleft", new Integer(171)}, {"guillemotright", new Integer(187)}, {"yen", new Integer(165)}, {"ss", new Integer(223)}, {"ae", new Integer(230)}, {"AE", new Integer(198)}, {"eth", new Integer(240)}, {"Thorn", new Integer(222)}, {"thorn", new Integer(254)}, {"micro", new Integer(181)}, {"degree", new Integer(176)}, {"textdegree", new Integer(176)}, {"L", new Integer(321)}, {"l", new Integer(322)}, {"OE", new Integer(338)}, {"oe", new Integer(339)}, {"AA", new Integer(197)}, {"aa", new Integer(229)}, {"i", new Integer(305)}, {"j", new Integer(567)}, {"IJ", new Integer(306)}, {"ij", new Integer(307)}, {"ng", new Integer(331)}, {"NG", new Integer(330)}, {"th", new Integer(254)}, {"TH", new Integer(222)}, {"dh", new Integer(240)}, {"DH", new Integer(208)}, {"dj", new Integer(273)}, {"DJ", new Integer(272)}, {"quotedblbase", new Integer(8222)}, {"quotesinglbase", new Integer(8218)}};
    public static final Object[][] BIG_MATH_SYMBOLS = new Object[][]{{"bigsqcap", new Integer(8851), new Integer(10757)}, {"bigsqcup", new Integer(8852), new Integer(10758)}, {"sum", new Integer(8721), new Integer(8721)}, {"bigcap", new Integer(8745), new Integer(8898)}, {"bigcup", new Integer(8746), new Integer(8899)}, {"bigodot", new Integer(8857), new Integer(10752)}, {"bigoplus", new Integer(8853), new Integer(10753)}, {"bigotimes", new Integer(8855), new Integer(10754)}, {"biguplus", new Integer(8846), new Integer(10756)}, {"bigvee", new Integer(8744), new Integer(8897)}, {"bigwedge", new Integer(8743), new Integer(8896)}, {"int", new Integer(8747), new Integer(8747)}, {"intop", new Integer(8747), new Integer(8747)}, {"smallint", new Integer(8747), new Integer(8747)}, {"varint", new Integer(8747), new Integer(8747)}, {"oint", new Integer(8750), new Integer(8750)}, {"ointop", new Integer(8750), new Integer(8750)}, {"varoint", new Integer(8750), new Integer(8750)}, {"coprod", new Integer(10815), new Integer(8720)}, {"bigcurlyvee", new Integer(8910), new Integer(8910)}, {"bigcurlywedge", new Integer(8911), new Integer(8911)}, {"iint", new Integer(8748), new Integer(8748)}, {"iiint", new Integer(8749), new Integer(8749)}, {"oiint", new Integer(8751), new Integer(8751)}, {"oiiint", new Integer(8752), new Integer(8752)}, {"ointclockwise", new Integer(8754), new Integer(8754)}, {"ointctrclockwise", new Integer(8755), new Integer(8755)}, {"sumint", new Integer(10763), new Integer(10763)}, {"sqint", new Integer(10774), new Integer(10774)}, {"fint", new Integer(10767), new Integer(10767)}, {"landdownint", new Integer(10778), new Integer(10778)}, {"landupint", new Integer(10777), new Integer(10777)}, {"bigtimes", new Integer(10761), new Integer(10761)}, {"prod", new Integer(8719), new Integer(8719)}, {"bigtriangleup", new Integer(9651), new Integer(9651)}, {"bigtriangledown", new Integer(9661), new Integer(9661)}, {"varbigtriangleup", new Integer(9651), new Integer(9651)}, {"varbigtriangledown", new Integer(9661), new Integer(9661)}};
    public static final Object[][] DELIMITER_SYMBOLS = new Object[][]{{"vert", new Integer(8739)}, {"Vert", new Integer(8741)}, {"langle", new Integer(10216)}, {"rangle", new Integer(10217)}, {"lvert", new Integer(8739)}, {"rvert", new Integer(8739)}, {"lVert", new Integer(8741)}, {"rVert", new Integer(8741)}};
    public static final Object[][] GREEK_SYMBOLS = new Object[][]{{"Alpha", new Integer(120546)}, {"Beta", new Integer(120547)}, {"Gamma", new Integer(120548)}, {"Delta", new Integer(120549)}, {"Epsilon", new Integer(120550)}, {"Zeta", new Integer(120551)}, {"Eta", new Integer(120552)}, {"Theta", new Integer(120553)}, {"Iota", new Integer(120554)}, {"Kappa", new Integer(120555)}, {"Lambda", new Integer(120556)}, {"Mu", new Integer(120557)}, {"Nu", new Integer(120558)}, {"Xi", new Integer(120559)}, {"Omicron", new Integer(120560)}, {"Pi", new Integer(120561)}, {"Rho", new Integer(120562)}, {"Theta", new Integer(120563)}, {"Sigma", new Integer(120564)}, {"Tau", new Integer(120565)}, {"Upsilon", new Integer(120566)}, {"Phi", new Integer(120567)}, {"Chi", new Integer(120568)}, {"Psi", new Integer(120569)}, {"Omega", new Integer(120570)}, {"nabla", new Integer(120571)}, {"alpha", new Integer(120572)}, {"beta", new Integer(120573)}, {"gamma", new Integer(120574)}, {"delta", new Integer(120575)}, {"varepsilon", new Integer(120576)}, {"zeta", new Integer(120577)}, {"eta", new Integer(120578)}, {"theta", new Integer(120579)}, {"iota", new Integer(120580)}, {"kappa", new Integer(120581)}, {"lambda", new Integer(120582)}, {"mu", new Integer(120583)}, {"nu", new Integer(120584)}, {"xi", new Integer(120585)}, {"omicron", new Integer(120586)}, {"pi", new Integer(120587)}, {"rho", new Integer(120588)}, {"varsigma", new Integer(120589)}, {"sigma", new Integer(120590)}, {"tau", new Integer(120591)}, {"upsilon", new Integer(120592)}, {"varphi", new Integer(120593)}, {"chi", new Integer(120594)}, {"psi", new Integer(120595)}, {"omega", new Integer(120596)}, {"epsilon", new Integer(120598)}, {"vartheta", new Integer(120599)}, {"varkappa", new Integer(120600)}, {"phi", new Integer(120601)}, {"varrho", new Integer(120602)}, {"varpi", new Integer(120603)}};
    public static final Object[][] MATH_SYMBOLS = new Object[][]{{"digamma", new Integer(989)}, {"Digamma", new Integer(988)}, {"forall", new Integer(8704)}, {"complement", new Integer(8705)}, {"partial", new Integer(8706)}, {"varpartialdiff", new Integer(120597)}, {"exists", new Integer(8707)}, {"nexists", new Integer(8708)}, {"varnothing", new Integer(8709)}, {"in", new Integer(8712)}, {"notin", new Integer(8713)}, {"ni", new Integer(8715)}, {"owns", new Integer(8715)}, {"notni", new Integer(8716)}, {"vdots", new Integer(8942)}, {"cdots", new Integer(8943)}, {"ddots", new Integer(8945)}, {"surd", new Integer(8730)}, {"infty", new Integer(8734)}, {"rightangle", new Integer(8735)}, {"angle", new Integer(8736)}, {"measuredangle", new Integer(8737)}, {"sphericalangle", new Integer(8738)}, {"mathdollar", new Integer(36)}, {"mathellipsis", new Integer(8230)}, {"mathparagraph", new Integer(182)}, {"mathsection", new Integer(167)}, {"mathsterling", new Integer(163)}, {"mathunderscore", new Integer(95)}, {"bot", new Integer(8869)}, {"top", new Integer(8868)}, {"Im", new Integer(8465)}, {"ell", new Integer(8467)}, {"Re", new Integer(8476)}, {"ohm", new Integer(8486)}, {"mho", new Integer(8487)}, {"mathring", new Integer(8491)}, {"aleph", new Integer(8501)}, {"beth", new Integer(8502)}, {"gimel", new Integer(8503)}, {"daleth", new Integer(8504)}, {"hbar", new Integer(8463)}, {"wp", new Integer(8472)}, {"Bbbk", new Integer(120156)}, {"game", new Integer(8513)}, {"Finv", new Integer(8498)}, {"imath", new Integer(120484)}, {"jmath", new Integer(120485)}, {"emptyset", new Integer(8709)}, {"prime", new Integer(8242)}, {"hbar", new Integer(8463)}, {"triangle", new Integer(9651)}, {"neg", new Integer(172)}, {"flat", new Integer(9837)}, {"natural", new Integer(9838)}, {"sharp", new Integer(9839)}, {"clubsuit", new Integer(9827)}, {"diamondsuit", new Integer(9826)}, {"heartsuit", new Integer(9825)}, {"spadesuit", new Integer(9824)}, {"ldotp", new Integer(46)}, {"colon", new Integer(8758)}, {"cdotp", new Integer(8901)}};
    public static final Object[][] BINARY_MATH_SYMBOLS = new Object[][]{{"le", new Integer(8804)}, {"leq", new Integer(8804)}, {"ge", new Integer(8805)}, {"geq", new Integer(8805)}, {"ll", new Integer(8810)}, {"gg", new Integer(8811)}, {"neq", new Integer(8800)}, {"ne", new Integer(8800)}, {"amalg", new Integer(10815)}, {"approx", new Integer(8776)}, {"approxeq", new Integer(8778)}, {"ast", new Integer(8727)}, {"asymp", new Integer(8781)}, {"backsim", new Integer(8765)}, {"because", new Integer(8757)}, {"between", new Integer(8812)}, {"bigcirc", new Integer(9675)}, {"bigtriangledown", new Integer(9663)}, {"bigtriangleup", new Integer(9653)}, {"bowtie", new Integer(8904)}, {"bullet", new Integer(8226)}, {"bumpeq", new Integer(8783)}, {"cap", new Integer(8745)}, {"cdot", new Integer(8729)}, {"cong", new Integer(8773)}, {"circ", new Integer(8728)}, {"cup", new Integer(8746)}, {"dagger", new Integer(8224)}, {"dashv", new Integer(8867)}, {"ddagger", new Integer(8225)}, {"diamond", new Integer(11046)}, {"div", new Integer(247)}, {"doteqdot", new Integer(8785)}, {"fallingdotseq", new Integer(8786)}, {"lhd", new Integer(8882)}, {"mp", new Integer(8723)}, {"ncong", new Integer(8775)}, {"notcong", new Integer(8775)}, {"nmid", new Integer(8740)}, {"notmid", new Integer(8740)}, {"nprec", new Integer(8832)}, {"notprec", new Integer(8832)}, {"npreceq", new Integer(8928)}, {"notpreceq", new Integer(8928)}, {"nsucc", new Integer(8833)}, {"notsucc", new Integer(8833)}, {"nsucceq", new Integer(8929)}, {"notsucceq", new Integer(8929)}, {"odot", new Integer(8857)}, {"ominus", new Integer(8854)}, {"oplus", new Integer(8853)}, {"oslash", new Integer(8856)}, {"otimes", new Integer(8855)}, {"pm", new Integer(177)}, {"rhd", new Integer(8883)}, {"setminus", new Integer(8726)}, {"sqcap", new Integer(8851)}, {"sqcup", new Integer(8852)}, {"star", new Integer(8902)}, {"times", new Integer(215)}, {"triangleleft", new Integer(9667)}, {"triangleright", new Integer(9655)}, {"unlhd", new Integer(8884)}, {"unrhd", new Integer(8885)}, {"uplus", new Integer(8846)}, {"vee", new Integer(8744)}, {"wedge", new Integer(8743)}, {"wr", new Integer(8768)}, {"wreath", new Integer(8768)}, {"boxdot", new Integer(8865)}, {"boxminus", new Integer(8863)}, {"boxplus", new Integer(8862)}, {"boxtimes", new Integer(8864)}, {"Cap", new Integer(8914)}, {"centerdot", new Integer(8901)}, {"circledast", new Integer(8859)}, {"circledcirc", new Integer(8858)}, {"circleddash", new Integer(8861)}, {"Cup", new Integer(8915)}, {"curlyvee", new Integer(8910)}, {"curlywedge", new Integer(8911)}, {"divideontimes", new Integer(8903)}, {"dotequal", new Integer(8784)}, {"dotplus", new Integer(8724)}, {"doublebarwedge", new Integer(10846)}, {"equiv", new Integer(8801)}, {"frown", new Integer(8276)}, {"intercal", new Integer(8890)}, {"Join", new Integer(10781)}, {"leftthreetimes", new Integer(8907)}, {"ltimes", new Integer(8905)}, {"mid", new Integer(8739)}, {"models", new Integer(8871)}, {"nparallel", new Integer(8742)}, {"notparallel", new Integer(8742)}, {"nvdash", new Integer(8876)}, {"notvdash", new Integer(8876)}, {"nvDash", new Integer(8877)}, {"notvDash", new Integer(8877)}, {"nVDash", new Integer(8879)}, {"notVDash", new Integer(8879)}, {"parallel", new Integer(8741)}, {"perp", new Integer(8869)}, {"prec", new Integer(8826)}, {"preceq", new Integer(8828)}, {"propto", new Integer(8733)}, {"sqsubseteq", new Integer(8849)}, {"sqsupseteq", new Integer(8850)}, {"rightthreetimes", new Integer(8908)}, {"rtimes", new Integer(8906)}, {"sim", new Integer(8764)}, {"simeq", new Integer(8771)}, {"smallsetminus", new Integer(10741)}, {"smile", new Integer(8255)}, {"succ", new Integer(8827)}, {"succeq", new Integer(8829)}, {"therefore", new Integer(8756)}, {"veebar", new Integer(10849)}, {"plus", new Integer(43)}, {"minus", new Integer(8722)}, {"udtimes", new Integer(10710)}, {"vdash", new Integer(8866)}, {"Vdash", new Integer(8873)}, {"vDash", new Integer(8872)}, {"Vvdash", new Integer(8874)}, {"vcentcolon", new Integer(8758)}, {"squaredots", new Integer(8759)}, {"dotminus", new Integer(8760)}, {"eqcolon", new Integer(8761)}, {"risingdotseq", new Integer(8787)}, {"eqqcolon", new Integer(8789)}, {"nearrow", new Integer(8599)}, {"searrow", new Integer(8600)}, {"nwarrow", new Integer(8598)}, {"swarrow", new Integer(8601)}, {"Leftrightarrow", new Integer(8660)}, {"Leftarrow", new Integer(8656)}, {"Rightarrow", new Integer(8658)}, {"supset", new Integer(8835)}, {"subset", new Integer(8834)}, {"supseteq", new Integer(8839)}, {"subseteq", new Integer(8838)}, {"not", new Integer(8725)}, {"leftrightarrow", new Integer(8596)}, {"leftarrow", new Integer(8592)}, {"gets", new Integer(8592)}, {"rightarrow", new Integer(8594)}, {"to", new Integer(8594)}, {"mapsto", new Integer(8614)}, {"leftharpoonup", new Integer(8636)}, {"leftharpoondown", new Integer(8637)}, {"rightharpoonup", new Integer(8640)}, {"rightharpoondown", new Integer(8641)}, {"rightleftharpoons", new Integer(8652)}, {"doteq", new Integer(8784)}, {"hookrightarrow", new Integer(8618)}, {"hookleftarrow", new Integer(8617)}, {"Longrightarrow", new Integer(10233)}, {"longrightarrow", new Integer(10230)}, {"longleftarrow", new Integer(10229)}, {"Longleftarrow", new Integer(10232)}, {"longmapsto", new Integer(10236)}, {"longleftrightarrow", new Integer(10231)}, {"Longleftrightarrow", new Integer(10234)}, {"iff", new Integer(10234)}};
    protected int codePoint;

    public Symbol(String string, int n) {
        super(string);
        this.codePoint = n;
    }

    @Override
    public Object clone() {
        return new Symbol(this.getName(), this.codePoint);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Symbol)) {
            return false;
        }
        return this.codePoint == ((Symbol)object).codePoint;
    }

    @Override
    public TeXObject toLowerCase(TeXParser teXParser) {
        if (!Character.isUpperCase(this.codePoint) && !Character.isTitleCase(this.codePoint)) {
            return this;
        }
        return teXParser.getListener().getOther(Character.toLowerCase(this.codePoint));
    }

    @Override
    public TeXObject toUpperCase(TeXParser teXParser) {
        if (!Character.isLowerCase(this.codePoint)) {
            return this;
        }
        return teXParser.getListener().getOther(Character.toUpperCase(this.codePoint));
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.codePoint));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    public void write(TeXParser teXParser) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXSettings teXSettings = teXParser.getSettings();
        int n = teXSettings.getCharCode(this.codePoint);
        teXParserListener.getWriteable().writeCodePoint(n == -1 ? this.codePoint : n);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.write(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    public int getCharCode() {
        return this.codePoint;
    }

    public void setCharCode(int n) {
        this.codePoint = n;
    }

    public static void addCommands(TeXParser teXParser, TeXParserListener teXParserListener) {
        int n;
        String string;
        int n2;
        for (n2 = 0; n2 < GENERIC_SYMBOLS.length; ++n2) {
            string = GENERIC_SYMBOLS[n2][0].toString();
            n = (Integer)GENERIC_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createSymbol(string, n));
        }
        for (n2 = 0; n2 < TEXT_SYMBOLS.length; ++n2) {
            string = TEXT_SYMBOLS[n2][0].toString();
            n = (Integer)TEXT_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createSymbol(string, n));
        }
        for (n2 = 0; n2 < GREEK_SYMBOLS.length; ++n2) {
            string = GREEK_SYMBOLS[n2][0].toString();
            n = (Integer)GREEK_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createGreekSymbol(string, n));
        }
        for (n2 = 0; n2 < MATH_SYMBOLS.length; ++n2) {
            string = MATH_SYMBOLS[n2][0].toString();
            n = (Integer)MATH_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createMathSymbol(string, n));
        }
        for (n2 = 0; n2 < BINARY_MATH_SYMBOLS.length; ++n2) {
            string = BINARY_MATH_SYMBOLS[n2][0].toString();
            n = (Integer)BINARY_MATH_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createBinarySymbol(string, n));
        }
        for (n2 = 0; n2 < DELIMITER_SYMBOLS.length; ++n2) {
            string = DELIMITER_SYMBOLS[n2][0].toString();
            n = (Integer)DELIMITER_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createDelimiterSymbol(string, n));
        }
        for (n2 = 0; n2 < BIG_MATH_SYMBOLS.length; ++n2) {
            string = BIG_MATH_SYMBOLS[n2][0].toString();
            n = (Integer)BIG_MATH_SYMBOLS[n2][1];
            int n3 = (Integer)BIG_MATH_SYMBOLS[n2][2];
            teXParser.putControlSequence(teXParserListener.createBigOperator(string, n, n3));
        }
    }
}

