/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.HasInitial;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;

public abstract class AbstractCachingDiffFunction
implements DiffFunction,
HasInitial {
    private static final Redwood.RedwoodChannels log = Redwood.channels(AbstractCachingDiffFunction.class);
    private double[] lastX;
    private int fEvaluations;
    protected double[] derivative;
    protected double value;
    private final Random generator = new Random(Integer.MAX_VALUE);

    public boolean gradientCheck() {
        return this.gradientCheck(100, 50, this.initial());
    }

    public boolean gradientCheck(int numOfChecks, int numOfRandomChecks, double[] x) {
        int i;
        double epsilon = 1.0E-5;
        double diffThreshold = 0.01;
        double diffPctThreshold = 0.1;
        double twoEpsilon = epsilon * 2.0;
        int xLen = x.length;
        this.derivativeAt(x);
        double[] savedDeriv = new double[xLen];
        System.arraycopy(this.derivative, 0, savedDeriv, 0, this.derivative.length);
        int interval = Math.max(1, x.length / numOfChecks);
        TreeSet<Integer> indicesToCheck = new TreeSet<Integer>();
        for (int paramIndex = 0; paramIndex < xLen; paramIndex += interval) {
            indicesToCheck.add(paramIndex);
        }
        for (i = xLen - 1; i >= 0 && i > xLen - numOfChecks; --i) {
            indicesToCheck.add(i);
        }
        for (i = 1; i < xLen && i < numOfChecks; ++i) {
            indicesToCheck.add(i);
        }
        for (i = 0; i < numOfRandomChecks; ++i) {
            indicesToCheck.add(this.generator.nextInt(xLen));
        }
        boolean returnVal = true;
        ArrayList<Integer> badIndices = new ArrayList<Integer>();
        Iterator iterator = indicesToCheck.iterator();
        while (iterator.hasNext()) {
            int paramIndex = (Integer)iterator.next();
            double oldX = x[paramIndex];
            x[paramIndex] = oldX + epsilon;
            double plusVal = this.valueAt(x);
            x[paramIndex] = oldX - epsilon;
            double minusVal = this.valueAt(x);
            double appDeriv = (plusVal - minusVal) / twoEpsilon;
            double calcDeriv = savedDeriv[paramIndex];
            double diff = Math.abs(appDeriv - calcDeriv);
            double pct = diff / Math.min(Math.abs(appDeriv), Math.abs(calcDeriv));
            if (diff > diffThreshold && pct > diffPctThreshold) {
                System.err.printf("Grad fail at %2d, appGrad=%9.7f, calcGrad=%9.7f, diff=%9.7f, pct=%9.7f\n", paramIndex, appDeriv, calcDeriv, diff, pct);
                badIndices.add(paramIndex);
                returnVal = false;
            } else {
                System.err.printf("Grad good at %2d, appGrad=%9.7f, calcGrad=%9.7f, diff=%9.7f, pct=%9.7f\n", paramIndex, appDeriv, calcDeriv, diff, pct);
            }
            x[paramIndex] = oldX;
        }
        if (returnVal) {
            System.err.printf("ALL gradients passed. Yay!\n", new Object[0]);
        } else {
            log.info("Bad indices: ");
            for (int i2 = 0; i2 < badIndices.size() && i2 < 10; ++i2) {
                log.info(" " + badIndices.get(i2));
            }
            if (badIndices.size() >= 10) {
                log.info(" (...)");
            }
            log.info(new Object[0]);
        }
        return returnVal;
    }

    protected abstract void calculate(double[] var1);

    protected void clearCache() {
        if (this.lastX != null) {
            this.lastX[0] = Double.NaN;
        }
    }

    @Override
    public double[] initial() {
        double[] initial = new double[this.domainDimension()];
        return initial;
    }

    public double[] randomInitial() {
        double[] initial = new double[this.domainDimension()];
        for (int i = 0; i < initial.length; ++i) {
            initial[i] = this.generator.nextDouble();
        }
        return initial;
    }

    protected static void copy(double[] copy, double[] orig) {
        System.arraycopy(orig, 0, copy, 0, orig.length);
    }

    public void ensure(double[] x) {
        if (Arrays.equals(x, this.lastX)) {
            return;
        }
        if (this.lastX == null) {
            this.lastX = new double[this.domainDimension()];
        }
        if (this.derivative == null) {
            this.derivative = new double[this.domainDimension()];
        }
        AbstractCachingDiffFunction.copy(this.lastX, x);
        ++this.fEvaluations;
        this.calculate(x);
    }

    @Override
    public double valueAt(double[] x) {
        this.ensure(x);
        return this.value;
    }

    @Override
    public double[] derivativeAt(double[] x) {
        this.ensure(x);
        return this.derivative;
    }

    public double lastValue() {
        return this.value;
    }

    public double[] getDerivative() {
        return this.derivative;
    }
}

