/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday;

import de.jollyday.CalendarHierarchy;
import de.jollyday.Holiday;
import de.jollyday.HolidayCalendar;
import de.jollyday.HolidayType;
import de.jollyday.ManagerParameter;
import de.jollyday.ManagerParameters;
import de.jollyday.caching.HolidayManagerValueHandler;
import de.jollyday.configuration.ConfigurationProviderManager;
import de.jollyday.datasource.ConfigurationDataSource;
import de.jollyday.util.Cache;
import de.jollyday.util.CalendarUtil;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HolidayManager {
    private static final Logger LOG = Logger.getLogger(HolidayManager.class.getName());
    private static boolean CACHING_ENABLED = true;
    private static final Cache<HolidayManager> MANAGER_CHACHE = new Cache();
    private static ConfigurationProviderManager configurationProviderManager = new ConfigurationProviderManager();
    private Cache<Set<Holiday>> holidayCache = new Cache();
    protected CalendarUtil calendarUtil = new CalendarUtil();
    private ConfigurationDataSource configurationDataSource;
    private ManagerParameter managerParameter;

    public static HolidayManager getInstance() {
        return HolidayManager.getInstance(ManagerParameters.create((String)null, null));
    }

    public static HolidayManager getInstance(Properties properties) {
        return HolidayManager.getInstance(ManagerParameters.create((String)null, properties));
    }

    @Deprecated
    public static HolidayManager getInstance(HolidayCalendar c) {
        return HolidayManager.getInstance(ManagerParameters.create(c, null));
    }

    @Deprecated
    public static HolidayManager getInstance(HolidayCalendar c, Properties properties) {
        return HolidayManager.getInstance(ManagerParameters.create(c, properties));
    }

    @Deprecated
    public static HolidayManager getInstance(String calendar) {
        return HolidayManager.getInstance(ManagerParameters.create(calendar, null));
    }

    @Deprecated
    public static HolidayManager getInstance(String calendar, Properties properties) {
        return HolidayManager.getInstance(ManagerParameters.create(calendar, properties));
    }

    public static HolidayManager getInstance(ManagerParameter parameter) {
        return HolidayManager.createManager(parameter);
    }

    private static HolidayManager createManager(ManagerParameter parameter) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Creating HolidayManager for calendar '" + parameter + "'. Caching enabled: " + HolidayManager.isManagerCachingEnabled());
        }
        configurationProviderManager.mergeConfigurationProperties(parameter);
        String managerImplClassName = HolidayManager.readManagerImplClassName(parameter);
        HolidayManagerValueHandler holidayManagerValueHandler = new HolidayManagerValueHandler(parameter, managerImplClassName);
        if (HolidayManager.isManagerCachingEnabled()) {
            return MANAGER_CHACHE.get(holidayManagerValueHandler);
        }
        return holidayManagerValueHandler.createValue();
    }

    private static String readManagerImplClassName(ManagerParameter parameter) {
        String className = parameter.getManangerImplClassName();
        if (className == null) {
            throw new IllegalStateException("Missing configuration 'manager.impl'. Cannot create manager.");
        }
        return className;
    }

    public static void setManagerCachingEnabled(boolean managerCachingEnabled) {
        CACHING_ENABLED = managerCachingEnabled;
    }

    public static boolean isManagerCachingEnabled() {
        return CACHING_ENABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearManagerCache() {
        Cache<HolidayManager> cache = MANAGER_CHACHE;
        synchronized (cache) {
            MANAGER_CHACHE.clear();
        }
    }

    public boolean isHoliday(Calendar c, HolidayType holidayType, String ... args) {
        return this.isHoliday(this.calendarUtil.create(c), holidayType, args);
    }

    public boolean isHoliday(Calendar c, String ... args) {
        return this.isHoliday(c, (HolidayType)null, args);
    }

    public boolean isHoliday(final LocalDate c, HolidayType holidayType, final String ... args) {
        final StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(c.getYear());
        for (String arg : args) {
            keyBuilder.append("_");
            keyBuilder.append(arg);
        }
        Set<Holiday> holidays = this.holidayCache.get(new Cache.ValueHandler<Set<Holiday>>(){

            @Override
            public String getKey() {
                return keyBuilder.toString();
            }

            @Override
            public Set<Holiday> createValue() {
                return HolidayManager.this.getHolidays(c.getYear(), args);
            }
        });
        return this.calendarUtil.contains(holidays, c, holidayType);
    }

    public boolean isHoliday(LocalDate c, String ... args) {
        return this.isHoliday(c, (HolidayType)null, args);
    }

    public static Set<String> getSupportedCalendarCodes() {
        HashSet<String> supportedCalendars = new HashSet<String>();
        for (HolidayCalendar c : HolidayCalendar.values()) {
            supportedCalendars.add(c.getId());
        }
        return supportedCalendars;
    }

    public void setConfigurationDataSource(ConfigurationDataSource configurationDataSource) {
        this.configurationDataSource = configurationDataSource;
    }

    public ConfigurationDataSource getConfigurationDataSource() {
        return this.configurationDataSource;
    }

    public ManagerParameter getManagerParameter() {
        return this.managerParameter;
    }

    public void init(ManagerParameter parameters) {
        this.managerParameter = parameters;
        this.doInit();
    }

    public abstract void doInit();

    public abstract Set<Holiday> getHolidays(int var1, String ... var2);

    public abstract Set<Holiday> getHolidays(ReadableInterval var1, String ... var2);

    public abstract CalendarHierarchy getCalendarHierarchy();
}

