/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.apache.ivy.util.url.URLHandler;

public class BasicURLHandler
extends AbstractURLHandler {
    private static final int BUFFER_SIZE = 65536;

    public BasicURLHandler() {
        Message.debug("installing " + IvyAuthenticator.INSTANCE.getClass());
    }

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        URLConnection con;
        block12: {
            con = null;
            try {
                url = this.normalizeToURL(url);
                con = url.openConnection();
                con.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
                if (con instanceof HttpURLConnection) {
                    HttpURLConnection httpCon = (HttpURLConnection)con;
                    if (this.getRequestMethod() == 2) {
                        httpCon.setRequestMethod("HEAD");
                    }
                    if (this.checkStatusCode(url, httpCon)) {
                        URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, httpCon.getContentLength(), con.getLastModified());
                        this.disconnect(con);
                        return uRLInfo;
                    }
                    break block12;
                }
                int contentLength = con.getContentLength();
                if (contentLength <= 0) {
                    URLHandler.URLInfo uRLInfo = UNAVAILABLE;
                    this.disconnect(con);
                    return uRLInfo;
                }
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, contentLength, con.getLastModified());
                this.disconnect(con);
                return uRLInfo;
            }
            catch (UnknownHostException e) {
                Message.warn("Host " + e.getMessage() + " not found. url=" + url);
                Message.info("You probably access the destination server through a proxy server that is not well configured.");
                this.disconnect(con);
                return UNAVAILABLE;
                {
                    catch (Throwable throwable) {
                        this.disconnect(con);
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    Message.error("Server access Error: " + e2.getMessage() + " url=" + url);
                    this.disconnect(con);
                    return UNAVAILABLE;
                }
            }
        }
        this.disconnect(con);
        return UNAVAILABLE;
    }

    private boolean checkStatusCode(URL url, HttpURLConnection con) throws IOException {
        int status = con.getResponseCode();
        if (status == 200) {
            return true;
        }
        Message.debug("HTTP response status: " + status + " url=" + url);
        if (status == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(status).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + con.getResponseMessage() + " url=" + url);
        } else if (String.valueOf(status).startsWith("5")) {
            Message.error("SERVER ERROR: " + con.getResponseMessage() + " url=" + url);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openStream(URL url) throws IOException {
        URLConnection conn = null;
        InputStream inStream = null;
        try {
            int len;
            HttpURLConnection httpCon;
            url = this.normalizeToURL(url);
            conn = url.openConnection();
            conn.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            if (conn instanceof HttpURLConnection && !this.checkStatusCode(url, httpCon = (HttpURLConnection)conn)) {
                throw new IOException("The HTTP response code for " + url + " did not indicate a success." + " See log for more detail.");
            }
            inStream = conn.getInputStream();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            while ((len = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, len);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            this.disconnect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        URLConnection srcConn = null;
        try {
            HttpURLConnection httpCon;
            src = this.normalizeToURL(src);
            srcConn = src.openConnection();
            srcConn.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            if (srcConn instanceof HttpURLConnection && !this.checkStatusCode(src, httpCon = (HttpURLConnection)srcConn)) {
                throw new IOException("The HTTP response code for " + src + " did not indicate a success." + " See log for more detail.");
            }
            int contentLength = srcConn.getContentLength();
            FileUtil.copy(srcConn.getInputStream(), dest, l);
            if (dest.length() != (long)contentLength && contentLength != -1) {
                dest.delete();
                throw new IOException("Downloaded file size doesn't match expected Content Length for " + src + ". Please retry.");
            }
            long lastModified = srcConn.getLastModified();
            if (lastModified > 0L) {
                dest.setLastModified(lastModified);
            }
            this.disconnect(srcConn);
        }
        catch (Throwable throwable) {
            this.disconnect(srcConn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(File source, URL dest, CopyProgressListener l) throws IOException {
        if (!"http".equals(dest.getProtocol()) && !"https".equals(dest.getProtocol())) {
            throw new UnsupportedOperationException("URL repository only support HTTP PUT at the moment");
        }
        HttpURLConnection conn = null;
        try {
            dest = this.normalizeToURL(dest);
            conn = (HttpURLConnection)dest.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("User-Agent", "Apache Ivy/" + Ivy.getIvyVersion());
            conn.setRequestProperty("Content-type", "application/octet-stream");
            conn.setRequestProperty("Content-length", Long.toString(source.length()));
            conn.setInstanceFollowRedirects(true);
            FileInputStream in = new FileInputStream(source);
            try {
                OutputStream os = conn.getOutputStream();
                FileUtil.copy((InputStream)in, os, l);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
            this.validatePutStatusCode(dest, conn.getResponseCode(), conn.getResponseMessage());
            this.disconnect(conn);
        }
        catch (Throwable throwable) {
            this.disconnect(conn);
            throw throwable;
        }
    }

    private void disconnect(URLConnection con) {
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).disconnect();
        } else if (con != null && "sun.net.www.protocol.file.FileURLConnection".equals(con.getClass().getName())) {
            try {
                con.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class HttpStatus {
        static final int SC_OK = 200;
        static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;

        private HttpStatus() {
        }
    }
}

