/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.cli.util.ResourceUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String ALL_CLASSPATH_URL_PREFIX = "classpath*:";
    public static final String FILE_URL_PREFIX = "file:";

    public static List<String> getUrls(String path, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        path = StringUtils.cleanPath((String)path);
        try {
            return ResourceUtils.getUrlsFromWildcardPath((String)path, (ClassLoader)classLoader);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot create URL from path [" + path + "]", ex);
        }
    }

    private static List<String> getUrlsFromWildcardPath(String path, ClassLoader classLoader) throws IOException {
        if (path.contains(":")) {
            return ResourceUtils.getUrlsFromPrefixedWildcardPath((String)path, (ClassLoader)classLoader);
        }
        LinkedHashSet result = new LinkedHashSet();
        try {
            result.addAll(ResourceUtils.getUrls((String)("file:" + path), (ClassLoader)classLoader));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        path = ResourceUtils.stripLeadingSlashes((String)path);
        result.addAll(ResourceUtils.getUrls((String)("classpath*:" + path), (ClassLoader)classLoader));
        return new ArrayList<String>(result);
    }

    private static List<String> getUrlsFromPrefixedWildcardPath(String path, ClassLoader classLoader) throws IOException {
        Resource[] resources = new PathMatchingResourcePatternResolver((ResourceLoader)new FileSearchResourceLoader(classLoader)).getResources(path);
        ArrayList<String> result = new ArrayList<String>();
        for (Resource resource : resources) {
            if (!resource.exists()) continue;
            if ("file".equals(resource.getURI().getScheme()) && resource.getFile().isDirectory()) {
                result.addAll(ResourceUtils.getChildFiles((Resource)resource));
                continue;
            }
            result.add(ResourceUtils.absolutePath((Resource)resource));
        }
        return result;
    }

    private static List<String> getChildFiles(Resource resource) throws IOException {
        Resource[] children = new PathMatchingResourcePatternResolver().getResources(resource.getURL() + "/**");
        ArrayList<String> childFiles = new ArrayList<String>();
        for (Resource child : children) {
            if (child.getFile().isDirectory()) continue;
            childFiles.add(ResourceUtils.absolutePath((Resource)child));
        }
        return childFiles;
    }

    private static String absolutePath(Resource resource) throws IOException {
        if (!"file".equals(resource.getURI().getScheme())) {
            return resource.getURL().toExternalForm();
        }
        return resource.getFile().getAbsoluteFile().toURI().toString();
    }

    private static String stripLeadingSlashes(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

