/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.options.OptionHelp;
import org.springframework.boot.cli.command.shell.RunProcessCommand;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.loader.tools.JavaExecutable;

class ForkProcessCommand
extends RunProcessCommand {
    private static final String MAIN_CLASS = "org.springframework.boot.loader.JarLauncher";
    private final Command command;

    ForkProcessCommand(Command command) {
        super(new String[]{new JavaExecutable().toString()});
        this.command = command;
    }

    public String getName() {
        return this.command.getName();
    }

    public String getDescription() {
        return this.command.getDescription();
    }

    public String getUsageHelp() {
        return this.command.getUsageHelp();
    }

    public String getHelp() {
        return this.command.getHelp();
    }

    public Collection<OptionHelp> getOptionsHelp() {
        return this.command.getOptionsHelp();
    }

    public ExitStatus run(String ... args) throws Exception {
        ArrayList<String> fullArgs = new ArrayList<String>();
        fullArgs.add("-cp");
        fullArgs.add(System.getProperty("java.class.path"));
        fullArgs.add(MAIN_CLASS);
        fullArgs.add(this.command.getName());
        fullArgs.addAll(Arrays.asList(args));
        this.run(fullArgs);
        return ExitStatus.OK;
    }
}

