/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;
import org.springframework.boot.groovy.GroovyTemplate;

public class SpringMvcCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"Controller", "RestController", "EnableWebMvc"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.web.servlet.mvc.Controller"}).add(new String[]{"spring-boot-starter-web"});
        dependencies.ifAnyMissingClasses(new String[]{"groovy.text.TemplateEngine"}).add(new String[]{"groovy-templates"});
    }

    public void applyImports(ImportCustomizer imports) {
        imports.addStarImports(new String[]{"org.springframework.web.bind.annotation", "org.springframework.web.servlet.config.annotation", "org.springframework.web.servlet", "org.springframework.http", "org.springframework.web.servlet.handler", "org.springframework.http", "org.springframework.ui", "groovy.text"});
        imports.addStaticImport(GroovyTemplate.class.getName(), "template");
    }
}

