/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.grape;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.springframework.boot.cli.compiler.dependencies.ArtifactCoordinatesResolver;
import org.springframework.boot.cli.compiler.dependencies.CompositeDependencyManagement;
import org.springframework.boot.cli.compiler.dependencies.Dependency;
import org.springframework.boot.cli.compiler.dependencies.DependencyManagement;
import org.springframework.boot.cli.compiler.dependencies.DependencyManagementArtifactCoordinatesResolver;
import org.springframework.boot.cli.compiler.dependencies.SpringBootDependenciesDependencyManagement;

public class DependencyResolutionContext {
    private final Map<String, Dependency> managedDependencyByGroupAndArtifact = new HashMap();
    private final List<Dependency> managedDependencies = new ArrayList();
    private DependencyManagement dependencyManagement = null;
    private ArtifactCoordinatesResolver artifactCoordinatesResolver;

    public DependencyResolutionContext() {
        this.addDependencyManagement((DependencyManagement)new SpringBootDependenciesDependencyManagement());
    }

    private String getIdentifier(Dependency dependency) {
        return this.getIdentifier(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId());
    }

    private String getIdentifier(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public ArtifactCoordinatesResolver getArtifactCoordinatesResolver() {
        return this.artifactCoordinatesResolver;
    }

    public String getManagedVersion(String groupId, String artifactId) {
        Dependency dependency = this.getManagedDependency(groupId, artifactId);
        if (dependency == null) {
            dependency = (Dependency)this.managedDependencyByGroupAndArtifact.get(this.getIdentifier(groupId, artifactId));
        }
        return dependency != null ? dependency.getArtifact().getVersion() : null;
    }

    public List<Dependency> getManagedDependencies() {
        return Collections.unmodifiableList(this.managedDependencies);
    }

    private Dependency getManagedDependency(String group, String artifact) {
        return (Dependency)this.managedDependencyByGroupAndArtifact.get(this.getIdentifier(group, artifact));
    }

    void addManagedDependencies(List<Dependency> dependencies) {
        this.managedDependencies.addAll(dependencies);
        for (Dependency dependency : dependencies) {
            this.managedDependencyByGroupAndArtifact.put(this.getIdentifier(dependency), dependency);
        }
    }

    public void addDependencyManagement(DependencyManagement dependencyManagement) {
        for (org.springframework.boot.cli.compiler.dependencies.Dependency dependency : dependencyManagement.getDependencies()) {
            ArrayList<Exclusion> aetherExclusions = new ArrayList<Exclusion>();
            for (Dependency.Exclusion exclusion : dependency.getExclusions()) {
                aetherExclusions.add(new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*"));
            }
            Dependency aetherDependency = new Dependency((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "jar", dependency.getVersion()), "compile", Boolean.valueOf(false), aetherExclusions);
            this.managedDependencies.add(0, aetherDependency);
            this.managedDependencyByGroupAndArtifact.put(this.getIdentifier(aetherDependency), aetherDependency);
        }
        this.dependencyManagement = this.dependencyManagement == null ? dependencyManagement : new CompositeDependencyManagement(new DependencyManagement[]{dependencyManagement, this.dependencyManagement});
        this.artifactCoordinatesResolver = new DependencyManagementArtifactCoordinatesResolver(this.dependencyManagement);
    }
}

