/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpringSecurityOAuth2CompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"EnableAuthorizationServer", "EnableResourceServer", "EnableOAuth2Client", "EnableOAuth2Sso"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) throws CompilationFailedException {
        dependencies.add(new String[]{"spring-security-oauth2", "spring-boot-starter-web", "spring-boot-starter-security"});
    }

    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addImports(new String[]{"org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2Sso"});
        imports.addStarImports(new String[]{"org.springframework.security.oauth2.config.annotation.web.configuration", "org.springframework.security.access.prepost"});
    }
}

