/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.control.CompilationFailedException;
import org.springframework.boot.cli.command.install.DependencyResolver;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;

class GroovyGrabDependencyResolver
implements DependencyResolver {
    private final GroovyCompilerConfiguration configuration;

    GroovyGrabDependencyResolver(GroovyCompilerConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<File> resolve(List<String> artifactIdentifiers) throws CompilationFailedException, IOException {
        GroovyCompiler groovyCompiler = new GroovyCompiler(this.configuration);
        ArrayList<File> artifactFiles = new ArrayList<File>();
        if (!artifactIdentifiers.isEmpty()) {
            List initialUrls = this.getClassPathUrls(groovyCompiler);
            groovyCompiler.compile(new String[]{this.createSources(artifactIdentifiers)});
            List artifactUrls = this.getClassPathUrls(groovyCompiler);
            artifactUrls.removeAll(initialUrls);
            for (URL artifactUrl : artifactUrls) {
                artifactFiles.add(this.toFile(artifactUrl));
            }
        }
        return artifactFiles;
    }

    private List<URL> getClassPathUrls(GroovyCompiler compiler) {
        return new ArrayList<URL>(Arrays.asList(compiler.getLoader().getURLs()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createSources(List<String> artifactIdentifiers) throws IOException {
        File file = File.createTempFile("SpringCLIDependency", ".groovy");
        file.deleteOnExit();
        OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            for (String artifactIdentifier : artifactIdentifiers) {
                stream.write("@Grab('" + artifactIdentifier + "')");
            }
            stream.write("class Installer {}");
        }
        finally {
            stream.close();
        }
        return file.getAbsoluteFile().toURI().toString();
    }

    private File toFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }
}

