# -*- mode: python; coding: utf-8 -*-
# Copyright (C) 2021, 2022 Laboratoire de Recherche et
# Développement de l'Epita
#
# This file is part of Spot, a model checking library.
#
# Spot is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Spot is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
# License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import spot, buddy
from unittest import TestCase
tc = TestCase()

strats = (("""HOA: v1
States: 4
Start: 0
AP: 3 "a" "b" "c"
acc-name: all
Acceptance: 0 t
properties: trans-labels explicit-labels state-acc deterministic
--BODY--
State: 0
[0&!1&2] 1
[!0&!1&2] 1
State: 1
[0&!1] 2
[!0&!1] 1
State: 2
[0&1] 3
[!0&1] 3
State: 3
[0&!2] 0
[!0&!2] 3
--END--
""", (("a"), ("b", "c"))),
("""HOA: v1
States: 4
Start: 0
AP: 7 "i0" "i1" "i2" "o0" "o1" "o2" "o3"
acc-name: all
Acceptance: 0 t
properties: trans-labels explicit-labels state-acc
--BODY--
State: 0
[!0] 1
[0&!1&!3&!4&5&!6] 2
[0&1&!3&4&5&!6] 2
State: 1
[t] 1
State: 2
[!1&!2&!3&!4&5&!6] 2
[!0&!1&!3&!4&5&!6] 2
[1&!2&!3&4&5&!6] 2
[!0&1&!3&4&5&!6] 2
[0&!1&2&3&!4&5&!6] 3
[0&1&2&3&4&5&!6] 3
State: 3
[!0&!2&!3&!4&!5&6] 3
[0&!2&3&!4&!5&6] 2
[!0&2&!3&4&!5&6] 3
[0&2&3&4&!5&6] 2
--END--""", ([f"i{i}" for i in range(3)],[f"o{i}" for i in range(4)])),
("""HOA: v1
States: 136
Start: 0
AP: 11 "i3" "i4" "o4" "o5" "i0" "i1" "i2" "o0" "o1" "o2" "o3"
acc-name: all
Acceptance: 0 t
properties: trans-labels explicit-labels state-acc
--BODY--
State: 0
[!4] 1
[!2&!3&4&!5&!7&!8&9&!10] 2
[!2&!3&4&5&!7&8&9&!10] 2
State: 1
[t] 1
State: 2
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!7&8&9&!10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 3
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 5
[0&1&!2&!3&4&!5&7&!8&9&!10] 6
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&1&!2&!3&4&!5&6&7&!8&9&!10] 9
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 10
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&1&!2&!3&4&5&!6&7&8&9&!10] 3
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 5
[0&1&!2&!3&4&5&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&1&!2&!3&4&5&6&7&8&9&!10] 9
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
State: 3
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&6&!7&!8&!9&!10] 14
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 19
[0&!1&!2&3&4&6&7&!8&!9&!10] 16
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 18
State: 4
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!2&!3&!4&!5&!7&!8&9&!10] 4
[0&!2&!3&4&!5&!6&7&!8&9&!10] 5
[!0&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&!5&6&7&!8&9&!10] 8
[0&!2&!3&4&!5&6&7&!8&9&!10] 10
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!2&!3&!4&5&!7&8&9&!10] 4
[0&!2&!3&4&5&!6&7&8&9&!10] 5
[!0&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!2&!3&4&5&6&7&8&9&!10] 8
[0&!2&!3&4&5&6&7&8&9&!10] 10
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
State: 5
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&!1&2&!3&!4&6&!7&!8&!9&!10] 23
[0&1&2&!3&!4&6&!7&8&!9&!10] 31
[0&1&2&!3&4&6&7&8&!9&!10] 32
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&5&!6&7&8&!9&!10] 34
[!0&1&!2&!3&4&5&!6&7&!8&!9&10] 26
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 27
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 35
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 33
State: 6
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&1&2&!3&4&!5&!6&7&8&!9&!10] 36
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&1&!2&!3&4&!5&6&7&8&!9&10] 37
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&2&!3&!4&!5&!6&!7&8&!9&!10] 30
State: 7
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 6
[!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&!5&6&7&!8&9&!10] 8
[1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!2&!3&4&5&6&7&8&9&!10] 8
[1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 42
[0&!1&!2&!3&4&5&6&7&8&9&!10] 42
State: 8
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&2&!3&4&5&!6&7&!8&!9&!10] 39
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&!6&7&!8&!9&10] 46
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&4&5&6&7&8&!9&10] 51
State: 9
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&1&!2&!3&4&!5&6&7&8&!9&10] 37
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&1&!2&3&!4&6&!7&8&!9&!10] 52
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&1&!2&3&4&5&6&7&8&!9&!10] 54
[0&1&!2&3&4&5&!6&7&8&!9&!10] 55
[0&1&!2&3&4&!5&6&7&8&!9&!10] 56
State: 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&2&!3&4&5&6&7&8&!9&!10] 27
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
State: 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&1&2&!3&4&!5&!6&7&8&!9&!10] 36
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&1&!2&!3&4&!5&6&7&8&!9&10] 37
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
State: 12
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 40
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 57
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 19
[0&!1&!2&3&4&6&7&!8&!9&!10] 16
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 57
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 18
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 58
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 58
State: 13
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 3
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 5
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&1&!2&!3&4&5&!6&7&8&9&!10] 3
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 5
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&1&!2&!3&4&!5&6&7&8&!9&10] 37
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 59
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 58
State: 14
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!1&!2&3&!4&6&!7&!8&!9&!10] 14
[1&!2&3&!4&6&!7&8&!9&!10] 14
[!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[1&!2&3&4&5&6&7&8&!9&!10] 19
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 40
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 60
[0&1&!2&3&4&5&!6&7&8&!9&!10] 60
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 57
[!1&!2&3&4&5&6&7&!8&!9&!10] 19
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 57
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 61
[0&1&!2&3&4&!5&6&7&8&!9&!10] 61
State: 15
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 3
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&1&!2&!3&4&5&!6&7&8&9&!10] 3
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&1&2&!3&4&!5&!6&7&8&!9&!10] 36
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 57
State: 16
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 17
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!5&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!1&!2&3&!4&5&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 40
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[0&!1&!2&3&4&5&7&!8&!9&!10] 60
[0&1&!2&3&4&5&7&8&!9&!10] 60
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 62
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 16
State: 18
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[0&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[0&1&2&!3&4&!5&6&7&8&!9&!10] 32
[0&1&2&!3&4&5&6&7&8&!9&!10] 65
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 19
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 20
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&1&!2&!3&!4&!5&!7&!8&9&!10] 4
[0&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 4
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&4&!5&6&7&8&!9&10] 59
[0&1&2&!3&4&5&6&7&8&!9&!10] 68
State: 21
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!2&!3&!4&!5&6&!7&!8&9&!10] 7
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!2&!3&!4&5&6&!7&8&9&!10] 7
[1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 22
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 6
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 39
[0&2&!3&!4&5&!7&8&!9&!10] 24
[0&1&2&!3&4&5&7&8&!9&!10] 39
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&2&!3&!4&5&!7&!8&!9&!10] 24
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 23
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[0&2&!3&4&5&6&7&8&!9&!10] 27
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&2&!3&!4&6&!7&!8&!9&!10] 23
[!0&2&!3&4&!5&6&7&!8&!9&!10] 38
[!0&2&!3&4&5&6&7&!8&!9&!10] 27
State: 24
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&2&!3&4&5&7&!8&!9&!10] 39
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[0&2&!3&!4&5&!7&8&!9&!10] 24
[0&1&2&!3&4&5&7&8&!9&!10] 39
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&1&2&!3&!4&!5&!7&8&!9&!10] 30
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&1&2&!3&!4&!5&!7&!8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&2&!3&!4&5&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 69
[0&1&2&!3&4&!5&6&7&8&!9&!10] 69
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 64
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
State: 25
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[1&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!5&!6&!7&!8&!9&10] 43
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 44
[!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&!6&7&!8&!9&10] 26
[1&!2&!3&4&5&!6&7&!8&!9&10] 26
[0&1&!2&!3&4&!5&!6&7&!8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 66
State: 26
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[0&1&!2&!3&4&5&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&5&6&7&8&9&!10] 9
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
State: 27
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
State: 28
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&!3&4&!5&6&7&8&!9&10] 37
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&6&!7&8&!9&10] 43
[0&1&!2&!3&4&6&7&8&!9&10] 45
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[1&!2&!3&!4&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&!1&!2&!3&!4&!6&!7&!8&!9&10] 43
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 71
[0&!1&!2&!3&4&5&6&7&8&!9&10] 71
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 59
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 59
[!0&!1&!2&!3&4&5&!6&7&!8&!9&10] 26
[0&1&!2&!3&4&!6&7&!8&!9&10] 45
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 37
[!0&1&!2&!3&4&5&!6&7&!8&!9&10] 72
[!0&1&!2&!3&4&5&6&7&8&!9&10] 72
State: 29
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!2&!3&!4&!5&6&!7&!8&9&!10] 7
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!2&!3&!4&5&6&!7&8&9&!10] 7
[1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&!2&3&4&5&!6&7&8&!9&!10] 60
State: 30
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&1&2&!3&4&!5&!6&7&8&!9&!10] 36
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&1&2&!3&!4&!7&8&!9&!10] 30
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&1&2&!3&!4&!7&!8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&!1&2&!3&!4&6&!7&!8&!9&!10] 23
[!0&1&2&!3&4&6&7&!8&!9&!10] 69
[0&1&2&!3&4&6&7&8&!9&!10] 69
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 38
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 27
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 36
[!0&1&2&!3&4&5&!6&7&!8&!9&!10] 73
[0&1&2&!3&4&5&!6&7&8&!9&!10] 73
State: 31
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&6&!7&!8&!9&!10] 23
[!0&1&2&!3&!4&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&6&!7&8&!9&!10] 31
[!0&1&2&!3&4&6&7&!8&!9&!10] 32
[0&1&2&!3&4&6&7&8&!9&!10] 32
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&5&!6&7&8&!9&!10] 34
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 27
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 35
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 33
[!0&1&2&!3&!4&5&!6&!7&!8&!9&!10] 35
[!0&1&2&!3&4&5&!6&7&!8&!9&!10] 34
State: 32
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&3&!4&6&!7&8&!9&!10] 52
[0&1&!2&3&4&!5&6&7&8&!9&!10] 74
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&1&!2&3&4&5&!6&7&8&!9&!10] 75
[0&!1&!2&3&!4&5&6&!7&!8&!9&!10] 52
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 54
[0&1&!2&3&4&5&6&7&8&!9&!10] 54
State: 33
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!1&!2&3&!4&5&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!7&8&!9&!10] 17
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 26
State: 34
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&!1&!2&3&!4&5&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!7&8&!9&!10] 53
[0&1&!2&3&4&5&7&8&!9&!10] 75
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[!0&1&!2&3&4&5&6&7&8&!9&!10] 77
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 75
State: 35
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&1&2&!3&!4&!5&!7&8&!9&!10] 30
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&1&2&!3&!4&!5&!7&!8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 69
[0&1&2&!3&4&!5&6&7&8&!9&!10] 69
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&5&!6&7&8&!9&!10] 34
[0&1&2&!3&!4&5&!7&8&!9&!10] 35
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 33
[!0&1&2&!3&!4&5&!7&!8&!9&!10] 35
[!0&1&2&!3&4&5&!6&7&!8&!9&!10] 34
[!0&!1&2&!3&!4&5&6&!7&!8&!9&!10] 78
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 79
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 80
[0&!1&2&!3&!4&5&6&!7&8&!9&!10] 78
[0&!1&2&!3&4&5&6&7&8&!9&!10] 79
[0&1&2&!3&4&5&6&7&8&!9&!10] 80
State: 36
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&6&!7&!8&!9&!10] 14
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 19
[0&!1&!2&3&4&6&7&!8&!9&!10] 16
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 18
State: 37
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 19
[0&!1&!2&3&4&6&7&!8&!9&!10] 16
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 18
State: 38
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&4&5&6&7&8&!9&10] 51
State: 39
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[0&1&!2&!3&4&5&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&5&6&7&8&9&!10] 9
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
State: 40
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 6
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[0&1&!2&!3&4&5&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&5&6&7&8&9&!10] 9
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 41
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[0&1&!2&!3&4&!5&6&7&8&!9&10] 59
[!0&1&!2&!3&4&5&!6&7&!8&!9&10] 26
[0&1&2&!3&4&5&6&7&8&!9&!10] 68
State: 42
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[!0&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&!6&7&!8&!9&10] 46
[!0&!2&!3&4&5&6&7&8&!9&10] 46
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 81
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
[0&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!2&!3&4&5&6&7&8&!9&10] 50
State: 43
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!2&!3&!4&6&!7&8&!9&10] 43
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!2&!3&!4&!6&!7&!8&!9&10] 43
[!0&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[0&!2&!3&4&5&!6&7&!8&!9&10] 71
[0&!2&!3&4&5&6&7&8&!9&10] 71
[0&!2&!3&4&!5&!6&7&!8&!9&10] 59
[0&!2&!3&4&!5&6&7&8&!9&10] 59
[!0&!2&!3&4&5&!6&7&!8&!9&10] 26
State: 44
[0&1&!2&!3&!4&!5&!7&!8&9&!10] 4
[0&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 4
[!0&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!2&!3&4&5&6&7&8&9&!10] 8
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[0&1&2&!3&4&5&6&7&8&!9&!10] 68
State: 45
[!0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&1&!2&!3&4&5&!6&7&8&9&!10] 3
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&1&2&!3&4&!5&!6&7&8&!9&!10] 36
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 38
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&!1&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 57
State: 46
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!1&!2&3&!4&5&!7&!8&!9&!10] 17
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 39
[1&!2&3&!4&5&!7&8&!9&!10] 17
[0&1&2&!3&4&5&7&8&!9&!10] 39
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 64
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
State: 47
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[1&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!5&!6&!7&!8&!9&10] 43
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 44
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&!6&7&!8&!9&10] 46
[1&!2&!3&!4&5&!6&!7&!8&!9&10] 47
[!0&1&!2&!3&4&5&!6&7&!8&!9&10] 48
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&4&5&6&7&8&!9&10] 51
[0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 49
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 50
[0&1&!2&!3&4&!5&!6&7&!8&!9&10] 45
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 51
State: 48
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&!1&!2&3&!4&5&6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!7&8&!9&!10] 53
[0&1&!2&3&4&5&7&8&!9&!10] 75
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[!0&1&!2&3&4&5&6&7&8&!9&!10] 77
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 75
State: 49
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!5&!6&!7&!8&!9&10] 43
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 44
[!0&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&!6&7&!8&!9&10] 46
[!0&!2&!3&4&5&6&7&8&!9&10] 46
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 81
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 81
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
[0&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&4&!5&!6&7&!8&!9&10] 82
[0&!2&!3&!4&5&!6&!7&!8&!9&10] 49
[0&!2&!3&4&5&!6&7&!8&!9&10] 50
State: 50
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[!0&1&2&!3&!4&5&6&!7&!8&!9&!10] 63
[0&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&1&2&!3&4&!5&6&7&8&!9&!10] 85
[0&2&!3&4&5&6&7&8&!9&!10] 86
State: 51
[0&1&!2&!3&!4&5&!7&8&9&!10] 2
[1&!2&!3&!4&5&6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&5&6&7&8&9&!10] 9
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
State: 52
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&1&!2&3&!4&6&!7&8&!9&!10] 52
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&!1&!2&3&!4&6&!7&!8&!9&!10] 52
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 54
[0&1&!2&3&4&5&6&7&8&!9&!10] 54
[0&1&!2&3&4&5&!6&7&8&!9&!10] 55
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 40
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 55
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 57
[0&1&!2&3&4&!5&6&7&8&!9&!10] 56
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 19
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 57
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 56
State: 53
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!5&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&!1&!2&3&!4&5&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!7&8&!9&!10] 53
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[0&1&!2&3&4&5&7&8&!9&!10] 55
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 40
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[!0&!1&!2&3&!4&5&6&!7&!8&!9&!10] 76
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 62
[0&!1&!2&3&4&5&7&!8&!9&!10] 55
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 16
State: 54
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&2&!3&!4&5&6&!7&8&!9&!10] 23
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 55
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&!4&5&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&1&!2&!3&4&5&6&7&8&9&!10] 91
[0&1&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 89
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 91
State: 56
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 81
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 81
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
[0&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!2&!3&4&5&6&7&8&!9&10] 50
State: 57
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&4&5&6&7&8&!9&10] 51
State: 58
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&!1&2&!3&!4&6&!7&!8&!9&!10] 23
[0&1&2&!3&!4&6&!7&8&!9&!10] 31
[0&1&2&!3&4&6&7&8&!9&!10] 32
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&5&!6&7&8&!9&!10] 34
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 27
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 35
State: 59
[!0&1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&!1&2&!3&!4&6&!7&!8&!9&!10] 23
[!0&1&2&!3&!4&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&6&!7&8&!9&!10] 31
[!0&1&2&!3&4&6&7&!8&!9&!10] 32
[0&1&2&!3&4&6&7&8&!9&!10] 32
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&5&!6&7&8&!9&!10] 34
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 27
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 35
State: 60
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&!4&5&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&1&!2&!3&4&5&6&7&8&9&!10] 91
[0&1&2&!3&!4&!5&!7&8&!9&!10] 30
[0&1&2&!3&4&!5&6&7&8&!9&!10] 69
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 61
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 81
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 81
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
[0&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!2&!3&4&5&6&7&8&!9&10] 50
State: 62
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[1&!2&!3&!4&5&6&!7&8&9&!10] 90
[1&!2&!3&4&5&6&7&8&9&!10] 84
[1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 84
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 92
[0&!1&!2&!3&4&5&6&7&8&9&!10] 93
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 63
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[!0&2&!3&!4&5&6&!7&!8&!9&!10] 63
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 64
[0&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[!0&1&2&!3&!4&!5&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 32
[0&1&2&!3&4&!5&6&7&8&!9&!10] 32
[0&1&2&!3&4&5&6&7&8&!9&!10] 65
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 65
State: 64
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[1&!2&!3&!4&5&6&!7&8&9&!10] 90
[1&!2&!3&4&5&6&7&8&9&!10] 84
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 92
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 84
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 92
[0&!1&!2&!3&4&5&6&7&8&9&!10] 93
State: 65
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!2&!3&!4&5&6&!7&8&!9&10] 25
[1&!2&!3&!4&5&6&!7&8&!9&10] 25
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
State: 66
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&1&!2&!3&!4&5&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&1&!2&!3&4&5&6&7&8&9&!10] 91
State: 67
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&1&2&!3&!4&!5&!7&8&!9&!10] 30
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[0&1&2&!3&!4&5&!7&8&!9&!10] 67
[!0&1&2&!3&!4&!5&!7&!8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 69
[0&1&2&!3&4&!5&6&7&8&!9&!10] 69
[!0&1&2&!3&!4&5&!7&!8&!9&!10] 67
[!0&!1&2&!3&!4&5&6&!7&!8&!9&!10] 63
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 64
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 94
[0&!1&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[0&1&2&!3&4&5&6&7&8&!9&!10] 94
State: 68
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 14
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 92
State: 69
[!0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 4
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&1&!2&!3&4&5&!6&7&8&9&!10] 3
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 4
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&1&!2&!3&4&!5&6&7&8&!9&10] 37
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&1&!2&3&!4&6&!7&8&!9&!10] 52
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&1&!2&3&4&5&6&7&8&!9&!10] 54
[0&1&!2&3&4&5&!6&7&8&!9&!10] 55
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 59
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 55
[0&1&!2&3&4&!5&6&7&8&!9&!10] 56
State: 70
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&!2&3&!4&6&!7&!8&!9&!10] 14
[!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[1&!2&3&!4&6&!7&8&!9&!10] 14
[0&1&2&!3&4&!5&6&7&8&!9&!10] 38
[!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
State: 71
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 64
[0&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[!0&1&2&!3&!4&!5&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 32
[0&1&2&!3&4&!5&6&7&8&!9&!10] 32
[0&1&2&!3&4&5&6&7&8&!9&!10] 65
State: 72
[!0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&1&!2&!3&4&5&!6&7&8&9&!10] 3
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!5&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[0&!1&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&1&!2&3&!4&5&!7&8&!9&!10] 53
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[0&1&!2&3&4&5&7&8&!9&!10] 55
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 62
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 55
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 16
State: 73
[!0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!1&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&1&!2&!3&4&5&!6&7&8&9&!10] 3
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!5&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!1&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&!1&!2&3&!4&5&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!7&8&!9&!10] 53
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[0&1&!2&3&4&5&7&8&!9&!10] 55
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[0&!1&!2&3&4&5&7&!8&!9&!10] 55
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 16
State: 74
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 87
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 75
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[0&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&1&2&!3&!4&!5&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&4&5&6&7&8&9&!10] 95
State: 76
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[1&!2&3&!4&5&6&!7&8&!9&!10] 76
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 40
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 60
[0&1&!2&3&4&5&!6&7&8&!9&!10] 60
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[!1&!2&3&!4&5&6&!7&!8&!9&!10] 76
[0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 96
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 97
[0&1&!2&3&!4&!5&6&!7&8&!9&!10] 96
[0&1&!2&3&4&!5&6&7&8&!9&!10] 97
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 62
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 98
[0&1&!2&3&4&5&6&7&8&!9&!10] 98
State: 77
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&!4&!5&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[0&1&2&!3&4&!5&6&7&8&!9&!10] 32
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 99
State: 78
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[0&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 100
[0&1&2&!3&4&!5&6&7&8&!9&!10] 85
[!0&1&2&!3&!4&!5&6&!7&!8&!9&!10] 100
[!0&2&!3&4&5&!6&7&!8&!9&!10] 33
[!0&2&!3&!4&5&6&!7&!8&!9&!10] 78
[!0&2&!3&4&5&6&7&!8&!9&!10] 79
[0&2&!3&!4&5&6&!7&8&!9&!10] 78
[0&2&!3&4&5&6&7&8&!9&!10] 79
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 85
State: 79
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 92
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&!1&!2&!3&4&5&6&7&8&9&!10] 93
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 46
[0&1&!2&!3&4&5&6&7&8&!9&10] 46
[0&1&!2&3&4&!5&6&7&8&!9&!10] 74
State: 80
[1&!2&!3&!4&5&6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&6&7&8&9&!10] 6
[!0&1&!2&!3&4&5&6&7&8&9&!10] 9
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&3&!4&!5&6&!7&8&!9&!10] 52
[0&1&!2&3&4&!5&6&7&8&!9&!10] 74
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&1&!2&3&4&5&!6&7&8&!9&!10] 75
State: 81
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&6&!7&8&!9&10] 43
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!6&!7&!8&!9&10] 43
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 71
[0&!1&!2&!3&4&5&6&7&8&!9&10] 71
[0&1&!2&!3&!4&!6&!7&!8&!9&10] 81
[0&!2&!3&4&!5&!6&7&!8&!9&10] 59
[0&!2&!3&4&!5&6&7&8&!9&10] 59
[!0&!2&!3&4&5&!6&7&!8&!9&10] 26
[!0&1&!2&!3&!4&5&!6&!7&!8&!9&10] 101
[!0&1&!2&!3&!4&5&6&!7&8&!9&10] 101
[0&1&!2&!3&!4&6&!7&8&!9&10] 81
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 102
[0&1&!2&!3&4&5&6&7&8&!9&10] 102
State: 82
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[0&1&2&!3&4&5&6&7&8&!9&!10] 68
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 57
State: 83
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[0&1&2&!3&4&5&6&7&8&!9&!10] 68
State: 84
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 26
[0&1&!2&!3&!4&5&6&!7&8&!9&10] 101
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 100
[0&1&!2&3&4&!5&6&7&8&!9&!10] 56
State: 85
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 92
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 92
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 26
[0&1&!2&3&4&!5&6&7&8&!9&!10] 56
State: 86
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 96
[0&1&!2&3&!4&!5&6&!7&8&!9&!10] 96
[0&1&!2&3&4&!5&6&7&8&!9&!10] 97
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 26
State: 87
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&!4&!6&!7&!8&!9&10] 87
[0&1&!2&!3&!4&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!6&!7&!8&!9&10] 43
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 44
[0&1&!2&!3&4&!5&!6&7&!8&!9&10] 88
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&!6&7&!8&!9&10] 46
[!0&1&!2&!3&!4&5&!6&!7&!8&!9&10] 47
[!0&1&!2&!3&4&5&!6&7&!8&!9&10] 48
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 71
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 103
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&!1&!2&!3&4&5&6&7&8&!9&10] 71
[0&1&!2&!3&4&5&6&7&8&!9&10] 103
State: 88
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
State: 89
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 5
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 8
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 10
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 5
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 8
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&1&!2&!3&!4&5&!7&8&9&!10] 89
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[0&1&!2&!3&4&5&6&7&8&9&!10] 91
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&1&!2&!3&!4&!5&!7&!8&9&!10] 89
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 91
[!0&1&!2&!3&4&!5&6&7&!8&9&!10] 104
[!0&1&!2&!3&4&5&6&7&8&9&!10] 104
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 105
[0&1&!2&!3&4&5&!6&7&8&9&!10] 105
State: 90
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 6
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[1&!2&!3&!4&5&6&!7&8&9&!10] 90
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 92
[1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 92
[1&!2&!3&4&!5&6&7&!8&9&!10] 104
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 106
[1&!2&!3&4&5&6&7&8&9&!10] 104
[0&!1&!2&!3&4&5&6&7&8&9&!10] 106
State: 91
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[0&1&!2&3&4&5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
State: 92
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[!0&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!2&!3&4&5&6&7&8&9&!10] 8
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!2&!3&!4&!5&6&!7&!8&9&!10] 92
[0&!2&!3&!4&5&6&!7&8&9&!10] 92
[0&1&!2&!3&!4&!5&!6&!7&!8&9&!10] 107
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 108
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 106
[0&1&!2&!3&!4&5&!6&!7&8&9&!10] 107
[0&1&!2&!3&4&5&!6&7&8&9&!10] 108
[0&!1&!2&!3&4&5&6&7&8&9&!10] 106
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 109
[0&1&!2&!3&4&5&6&7&8&9&!10] 109
State: 93
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[0&1&2&!3&4&5&6&7&8&!9&!10] 27
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 87
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
State: 94
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 6
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[0&1&!2&!3&4&5&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&5&6&7&8&9&!10] 9
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
State: 95
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&1&!2&!3&!4&!6&!7&!8&!9&10] 87
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&1&2&!3&!4&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&6&!7&8&!9&!10] 31
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 32
[0&1&2&!3&4&6&7&8&!9&!10] 32
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&5&!6&7&8&!9&!10] 34
State: 96
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[0&!1&!2&3&!4&6&!7&!8&!9&!10] 96
[0&!1&!2&3&4&6&7&!8&!9&!10] 97
[0&1&!2&3&!4&6&!7&8&!9&!10] 96
[0&1&!2&3&4&6&7&8&!9&!10] 97
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 19
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 110
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 111
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 110
[0&1&!2&3&4&5&!6&7&8&!9&!10] 111
State: 97
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 81
State: 98
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&!4&5&!6&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&1&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
State: 99
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[!0&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&!4&5&!6&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[0&!2&!3&!4&!5&6&!7&!8&9&!10] 99
[0&1&!2&!3&!4&!5&!6&!7&!8&9&!10] 89
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 83
[!0&!2&!3&4&!5&6&7&!8&9&!10] 70
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 112
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 113
[0&!2&!3&!4&5&6&!7&8&9&!10] 99
[0&!1&!2&!3&4&5&6&7&8&9&!10] 112
[0&1&!2&!3&4&5&6&7&8&9&!10] 113
State: 100
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&2&!3&4&!5&6&7&8&!9&!10] 38
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&6&!7&!8&!9&!10] 23
[!0&1&2&!3&!4&5&!6&!7&!8&!9&!10] 67
[0&1&2&!3&!4&6&!7&8&!9&!10] 100
[0&1&2&!3&4&5&6&7&8&!9&!10] 68
[!0&2&!3&4&!5&6&7&!8&!9&!10] 38
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 27
[!0&1&2&!3&!4&6&!7&!8&!9&!10] 100
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 68
State: 101
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[1&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!5&!6&!7&!8&!9&10] 43
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 44
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&!6&7&!8&!9&10] 26
[1&!2&!3&4&5&!6&7&!8&!9&10] 26
[1&!2&!3&!4&5&!6&!7&!8&!9&10] 101
[1&!2&!3&!4&5&6&!7&8&!9&10] 101
[0&1&!2&!3&4&!5&!6&7&!8&!9&10] 45
[0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 114
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 66
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 114
State: 102
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&5&6&7&8&!9&!10] 16
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 64
[0&!1&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[!0&1&2&!3&!4&!5&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 32
[0&1&2&!3&4&!5&6&7&8&!9&!10] 32
[0&1&2&!3&!4&5&6&!7&8&!9&!10] 115
State: 103
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
State: 104
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&!6&7&!8&!9&10] 46
[0&1&!2&!3&!4&5&!6&!7&!8&!9&10] 47
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&1&!2&3&4&5&!6&7&8&!9&!10] 55
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&4&5&6&7&8&!9&10] 51
State: 105
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&1&!2&!3&4&5&6&7&8&!9&10] 26
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&!1&2&!3&!4&6&!7&!8&!9&!10] 23
[!0&1&2&!3&!4&5&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&6&!7&8&!9&!10] 31
[0&1&2&!3&4&6&7&8&!9&!10] 32
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&5&!6&7&8&!9&!10] 34
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 27
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 35
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 33
State: 106
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[!0&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&!6&7&!8&!9&10] 46
[!0&!2&!3&4&5&6&7&8&!9&10] 46
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 81
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
[0&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!2&!3&4&5&6&7&8&!9&10] 50
State: 107
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 10
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 70
[0&1&!2&!3&!4&!5&!7&!8&9&!10] 107
[0&1&!2&!3&4&!5&7&!8&9&!10] 108
[0&1&!2&!3&!4&5&!7&8&9&!10] 107
[0&1&!2&!3&4&5&7&8&9&!10] 108
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 116
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 116
[!0&1&!2&!3&4&!5&6&7&!8&9&!10] 117
[!0&1&!2&!3&4&5&6&7&8&9&!10] 117
State: 108
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[0&1&!2&3&4&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&1&!2&3&4&5&!6&7&8&!9&!10] 18
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
State: 109
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&1&2&!3&4&5&6&7&8&!9&!10] 27
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&!6&7&!8&!9&10] 46
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&!4&5&6&!7&8&!9&10] 118
State: 110
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&!1&!2&3&!4&!5&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[0&!1&!2&3&!4&5&!7&!8&!9&!10] 110
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 111
[0&1&!2&3&!4&5&!7&8&!9&!10] 110
[0&1&!2&3&4&5&!6&7&8&!9&!10] 111
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 16
[!0&!1&!2&3&!4&5&6&!7&!8&!9&!10] 119
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 120
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 119
[!0&1&!2&3&4&5&6&7&8&!9&!10] 120
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 121
[0&1&!2&3&4&5&6&7&8&!9&!10] 121
State: 111
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[0&2&!3&!4&5&6&!7&8&!9&!10] 63
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 81
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 100
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
[0&2&!3&4&5&6&7&8&!9&!10] 86
State: 112
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&2&!3&!4&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&2&!3&4&5&6&7&8&!9&!10] 27
[0&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&2&!3&4&5&!6&7&8&!9&!10] 33
State: 113
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&2&!3&!4&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&2&!3&4&5&6&7&8&!9&!10] 27
[0&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&2&!3&4&5&!6&7&8&!9&!10] 33
[!0&1&!2&!3&4&5&6&7&8&!9&10] 122
State: 114
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 87
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!5&!6&!7&!8&!9&10] 43
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 44
[0&1&!2&!3&4&!5&!6&7&!8&!9&10] 88
[!0&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!2&!3&4&5&!6&7&!8&!9&10] 26
[0&!2&!3&!4&5&!6&!7&!8&!9&10] 114
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 66
[0&!2&!3&!4&5&6&!7&8&!9&10] 114
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 123
[0&1&!2&!3&4&5&6&7&8&!9&10] 123
State: 115
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&2&!3&4&5&!6&7&!8&!9&!10] 39
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[!0&2&!3&!4&!5&!6&!7&!8&!9&!10] 30
[!0&!1&2&!3&4&!5&!6&7&!8&!9&!10] 2
[!0&!1&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&2&!3&4&!5&!6&7&!8&!9&!10] 13
[!0&!1&2&!3&!4&!5&6&!7&!8&!9&!10] 23
[!0&1&2&!3&!4&5&!6&!7&!8&!9&!10] 67
[!0&!1&2&!3&!4&5&6&!7&!8&!9&!10] 63
[!0&!1&2&!3&4&5&6&7&!8&!9&!10] 64
[0&!1&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[!0&1&2&!3&!4&!5&6&!7&!8&!9&!10] 31
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[!0&1&2&!3&4&!5&6&7&!8&!9&!10] 32
[0&1&2&!3&4&!5&6&7&8&!9&!10] 32
[0&1&2&!3&!4&5&6&!7&8&!9&!10] 115
[!0&1&2&!3&!4&5&6&!7&!8&!9&!10] 115
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 124
[0&1&2&!3&4&5&6&7&8&!9&!10] 124
State: 116
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 6
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 99
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 70
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 112
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 99
[0&!1&!2&!3&4&5&6&7&8&9&!10] 112
[1&!2&!3&!4&!5&6&!7&!8&9&!10] 116
[1&!2&!3&!4&5&6&!7&8&9&!10] 116
[!0&1&!2&!3&4&!5&6&7&!8&9&!10] 117
[!0&1&!2&!3&4&5&6&7&8&9&!10] 117
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 125
[0&1&!2&!3&4&5&6&7&8&9&!10] 125
State: 117
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[0&1&!2&3&!4&6&!7&8&!9&!10] 52
[0&1&!2&3&4&!5&6&7&8&!9&!10] 74
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[0&1&!2&3&4&5&!6&7&8&!9&!10] 75
[0&1&!2&3&4&5&6&7&8&!9&!10] 54
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
State: 118
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 87
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&!2&!3&!4&!5&!6&!7&!8&!9&10] 28
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[!0&1&!2&!3&4&!5&!6&7&!8&!9&10] 15
[0&!1&!2&!3&!4&!5&!6&!7&!8&!9&10] 43
[0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 44
[0&1&!2&!3&4&!5&!6&7&!8&!9&10] 88
[!0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 25
[!0&!1&!2&!3&4&5&!6&7&!8&!9&10] 46
[!0&1&!2&!3&!4&5&!6&!7&!8&!9&10] 47
[!0&1&!2&!3&4&5&!6&7&!8&!9&10] 48
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&!1&!2&!3&!4&5&!6&!7&!8&!9&10] 49
[0&!1&!2&!3&4&5&!6&7&!8&!9&10] 50
[0&1&!2&!3&!4&5&!6&!7&!8&!9&10] 118
[0&1&!2&!3&!4&5&6&!7&8&!9&10] 118
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 126
[0&1&!2&!3&4&5&6&7&8&!9&10] 126
State: 119
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&1&!2&3&!4&!5&6&!7&8&!9&!10] 52
[0&1&!2&3&4&!5&6&7&8&!9&!10] 74
[0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 52
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[!1&!2&3&!4&5&6&!7&!8&!9&!10] 119
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 120
[1&!2&3&!4&5&6&!7&8&!9&!10] 119
[!0&1&!2&3&4&5&6&7&8&!9&!10] 120
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 74
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 127
[0&1&!2&3&4&5&!6&7&8&!9&!10] 127
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 128
[0&1&!2&3&4&5&6&7&8&!9&!10] 128
State: 120
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[1&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&!1&!2&!3&4&5&6&7&8&9&!10] 93
[0&1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&2&!3&4&!5&6&7&8&!9&!10] 85
State: 121
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 4
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&1&!2&!3&4&5&6&7&8&9&!10] 91
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 81
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 100
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
State: 122
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&1&2&!3&!4&5&6&!7&!8&!9&!10] 67
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[0&!1&!2&3&!4&5&6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!7&8&!9&!10] 53
[0&1&!2&3&4&5&7&8&!9&!10] 55
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
State: 123
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[!0&1&2&!3&!4&5&6&!7&!8&!9&!10] 63
[0&1&2&!3&!4&5&6&!7&8&!9&!10] 63
[0&1&!2&3&4&5&6&7&8&!9&!10] 55
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
State: 124
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[1&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[0&1&!2&!3&4&5&!6&7&8&9&!10] 6
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&!1&!2&!3&!4&!5&6&!7&8&!9&10] 43
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 99
[0&1&!2&3&!4&5&6&!7&8&!9&!10] 129
State: 125
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&3&4&5&6&7&8&!9&!10] 19
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 28
[0&1&!2&!3&4&!5&6&7&8&!9&10] 45
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[0&1&!2&3&!4&5&6&!7&8&!9&!10] 96
[0&1&!2&3&4&5&6&7&8&!9&!10] 97
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 110
[0&1&!2&3&4&5&!6&7&8&!9&!10] 111
State: 126
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&!1&!2&!3&4&5&6&7&8&9&!10] 10
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&2&!3&4&!5&6&7&!8&!9&!10] 29
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&1&!2&3&!4&5&!7&8&!9&!10] 110
[0&1&!2&3&4&5&!6&7&8&!9&!10] 111
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 119
[!0&1&!2&3&4&5&6&7&8&!9&!10] 120
[0&1&!2&3&4&5&6&7&8&!9&!10] 121
State: 127
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&2&!3&4&5&6&7&!8&!9&!10] 39
[0&2&!3&!4&5&!7&8&!9&!10] 24
[0&1&2&!3&4&5&7&8&!9&!10] 39
[0&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&2&!3&!4&5&!7&!8&!9&!10] 24
[0&!1&2&!3&4&5&6&7&8&!9&!10] 64
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&!2&!3&!4&!5&!7&!8&9&!10] 107
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 116
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 95
State: 128
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[0&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&1&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&2&!3&!4&5&!6&!7&!8&!9&!10] 24
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&!1&!2&!3&4&5&6&7&8&9&!10] 93
[0&1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&1&2&!3&4&!5&6&7&8&!9&!10] 85
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 130
State: 129
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[!0&1&!2&3&4&!5&6&7&8&!9&!10] 21
[0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!6&!7&8&!9&!10] 53
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[0&1&!2&3&4&5&!6&7&8&!9&!10] 55
[!0&1&!2&3&4&5&6&7&8&!9&!10] 62
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 40
[0&!1&!2&3&4&!5&!6&7&!8&!9&!10] 20
[!0&!1&!2&3&4&!5&6&7&!8&!9&!10] 21
[!0&!1&!2&3&!4&5&6&!7&!8&!9&!10] 76
[0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 96
[0&!1&!2&3&4&!5&6&7&!8&!9&!10] 97
[0&1&!2&3&!4&!5&6&!7&8&!9&!10] 96
[0&1&!2&3&4&!5&6&7&8&!9&!10] 97
[!0&!1&!2&3&4&5&6&7&!8&!9&!10] 62
[0&1&!2&3&!4&5&6&!7&8&!9&!10] 129
[0&!1&!2&3&4&5&!6&7&!8&!9&!10] 55
[0&!1&!2&3&!4&5&6&!7&!8&!9&!10] 129
[0&!1&!2&3&4&5&6&7&!8&!9&!10] 131
[0&1&!2&3&4&5&6&7&8&!9&!10] 131
State: 130
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 8
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 8
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 92
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 92
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 130
[0&1&!2&!3&!4&!5&!6&!7&!8&9&!10] 107
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 108
[!0&1&!2&!3&4&!5&6&7&!8&9&!10] 104
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 106
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 132
[0&1&!2&!3&!4&5&!6&!7&8&9&!10] 107
[0&1&!2&!3&4&5&!6&7&8&9&!10] 108
[!0&1&!2&!3&4&5&6&7&8&9&!10] 104
[0&!1&!2&!3&4&5&6&7&8&9&!10] 106
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 130
[0&1&!2&!3&4&5&6&7&8&9&!10] 132
State: 131
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&!4&5&!6&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[0&1&2&!3&!4&!5&!6&!7&8&!9&!10] 30
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[0&1&2&!3&!4&!5&6&!7&8&!9&!10] 31
[!0&!1&!2&!3&4&!5&!6&7&!8&!9&10] 2
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 99
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 133
[0&1&!2&!3&4&5&6&7&8&9&!10] 134
State: 132
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&!5&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&!1&2&!3&4&5&!6&7&!8&!9&!10] 39
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 40
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 39
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&1&!2&!3&!4&!5&!6&!7&!8&!9&10] 87
[0&1&!2&!3&!4&!5&6&!7&8&!9&10] 87
[0&1&!2&!3&4&!5&6&7&8&!9&10] 88
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&1&!2&!3&!4&5&6&!7&8&!9&10] 47
[!0&1&!2&!3&4&5&6&7&8&!9&10] 48
[0&1&!2&3&4&5&!6&7&8&!9&!10] 55
[0&!1&!2&!3&!4&5&6&!7&8&!9&10] 49
[0&!1&!2&!3&4&5&6&7&8&!9&10] 50
[0&1&!2&!3&!4&5&!6&!7&!8&!9&10] 118
[0&1&!2&!3&5&6&!7&8&!9&10] 118
State: 133
[!0&!1&!2&!3&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&!5&!6&!7&!8&9&!10] 2
[!0&!2&!3&!4&5&!6&!7&8&9&!10] 2
[0&!1&!2&!3&!4&!5&!6&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[0&!1&!2&!3&!4&5&!6&!7&8&9&!10] 4
[!0&!1&!2&!3&!4&5&6&!7&8&9&!10] 7
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[!0&!1&!2&!3&4&5&6&7&8&9&!10] 70
[0&1&!2&!3&!4&5&!6&!7&8&9&!10] 89
[0&1&!2&!3&4&5&!6&7&8&9&!10] 83
[!0&1&!2&!3&!4&5&6&!7&8&9&!10] 90
[!0&1&!2&!3&4&5&6&7&8&9&!10] 84
[!0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 90
[!0&1&!2&!3&4&!5&6&7&!8&9&!10] 84
[0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 99
[0&1&!2&!3&!4&!5&!6&!7&!8&9&!10] 89
[0&1&!2&!3&4&!5&!6&7&!8&9&!10] 83
[!0&!1&!2&!3&4&!5&6&7&!8&9&!10] 70
[0&!1&!2&!3&4&!5&6&7&!8&9&!10] 112
[0&!1&!2&!3&!4&5&6&!7&8&9&!10] 99
[0&!1&!2&!3&4&5&6&7&8&9&!10] 112
[0&1&!2&!3&!4&5&6&!7&8&9&!10] 133
[0&1&!2&!3&4&5&6&7&8&9&!10] 134
[0&1&!2&!3&!4&!5&6&!7&!8&9&!10] 133
[0&1&!2&!3&4&!5&6&7&!8&9&!10] 134
State: 134
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[!1&!2&3&!4&!5&!6&!7&!8&!9&!10] 12
[!0&1&!2&3&!5&!6&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[0&2&!3&4&!5&!6&7&8&!9&!10] 13
[!0&!1&!2&3&!4&!5&6&!7&!8&!9&!10] 14
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&6&!7&8&!9&!10] 14
[0&!1&2&!3&!4&6&!7&8&!9&!10] 23
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[0&!1&2&!3&!4&5&!6&!7&8&!9&!10] 24
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[0&!1&2&!3&4&5&6&7&8&!9&!10] 27
[0&!1&2&!3&4&!5&6&7&8&!9&!10] 29
[0&1&2&!3&!4&5&!6&!7&8&!9&!10] 67
[!0&!1&!2&!3&4&5&6&7&8&!9&10] 46
[!0&!1&!2&3&4&5&!6&7&!8&!9&!10] 22
[!0&1&!2&3&4&5&!6&7&8&!9&!10] 22
[0&!1&2&!3&4&5&!6&7&8&!9&!10] 33
[!0&1&!2&!3&4&5&6&7&8&!9&10] 122
[0&1&2&!3&!4&6&!7&8&!9&!10] 100
[0&1&!2&!3&4&!5&6&7&8&!9&10] 82
[0&1&2&!3&4&5&!6&7&8&!9&!10] 135
[0&1&2&!3&4&5&6&7&8&!9&!10] 68
State: 135
[0&!1&!2&!3&!4&!5&!7&!8&9&!10] 4
[!0&!1&!2&!3&!4&!5&6&!7&!8&9&!10] 7
[!0&!2&!3&4&5&!6&7&8&9&!10] 11
[!0&!1&!2&3&!5&!6&!7&!8&!9&!10] 12
[0&1&!2&3&!4&!5&!7&8&!9&!10] 12
[1&!2&3&!4&!5&!6&!7&8&!9&!10] 12
[!0&!2&!3&4&!5&6&7&8&!9&10] 15
[!0&1&!2&3&!4&!5&6&!7&8&!9&!10] 14
[0&1&!2&3&4&!5&6&7&8&!9&!10] 16
[!0&!1&!2&3&!4&5&!6&!7&!8&!9&!10] 17
[!0&1&!2&3&!4&5&!6&!7&8&!9&!10] 17
[!0&!1&!2&!3&!4&5&6&!7&8&!9&10] 25
[!0&!2&!3&4&5&6&7&8&!9&10] 26
[1&!2&!3&4&5&6&7&8&!9&10] 26
[!0&1&!2&!3&4&!5&!6&7&!8&9&!10] 11
[0&!1&!2&!3&4&!5&!6&7&!8&9&!10] 41
[0&1&!2&3&4&!5&!6&7&8&!9&!10] 20
[0&!1&!2&!3&4&!5&6&7&8&!9&10] 44
[0&!1&!2&!3&4&5&!6&7&8&9&!10] 41
[0&!1&!2&!3&4&5&6&7&8&!9&10] 66
[0&!1&!2&3&!4&5&!7&!8&!9&!10] 53
[0&1&!2&3&!4&5&!7&8&!9&!10] 53
[!0&1&!2&3&!4&5&6&!7&8&!9&!10] 76
[0&1&!2&!3&4&5&!6&7&!8&!9&10] 26
--END--""", ([f"i{i}" for i in range(5)],[f"o{i}" for i in range(6)])))

for strat_string, (ins_str, outs_str) in strats:
    strat = spot.automaton(strat_string)

    ins = buddy.bddtrue
    outs = buddy.bddtrue

    for ain in ins_str:
        ins &= buddy.bdd_ithvar(strat.register_ap(ain))
    for aout in outs_str:
        outs &= buddy.bdd_ithvar(strat.register_ap(aout))

    spot.set_synthesis_outputs(strat, outs)
    strat_s = spot.split_2step(strat, outs, False)

    for m in ["isop", "ite", "both"]:
        for ss in [""] + [f"+sub{ii}" for ii in range(3)]:
            for ddx  in ["", "+dc"]:# todo prob here
                for uud  in ["", "+ud"]:
                    aig = spot.mealy_machine_to_aig(strat, m+ss+ddx+uud)
                    strat2_s = aig.as_automaton(True)
                    if not spot.is_split_mealy_specialization(strat_s,
                                                              strat2_s):
                        print(f"Mode is {m+ss+ddx+uud}")
                        print(f"""Strat is \n{strat_s.to_str("hoa")}""")
                        print(f"""Aig as aut is \n{strat2_s.to_str("hoa")}""")
                        raise AssertionError("not a specialization")


# Check stepwise simulation
strat_string, (ins_str, outs_str) = strats[0]
strat = spot.automaton(strat_string)

ins = buddy.bddtrue
outs = buddy.bddtrue

for ain in ins_str:
    ins &= buddy.bdd_ithvar(strat.register_ap(ain))
for aout in outs_str:
    outs &= buddy.bdd_ithvar(strat.register_ap(aout))

spot.set_synthesis_outputs(strat, outs)
aig = spot.mealy_machine_to_aig(strat, "isop")

ins = [True, False, False, False, True, True, True, True, True, True]
exp_latches = [(False, False),
               (True, False),
               (True, False),
               (True, False),
               (True, False),
               (False, True),
               (True, True),
               (False, False),
               (True, False)]

aig.circ_init()

for (i, e_latch) in zip(ins, exp_latches):
    # print(f"{(aig.circ_state()[4], aig.circ_state()[6])},")
    if (aig.circ_state()[4], aig.circ_state()[6]) != e_latch:
        print("expected ", e_latch, " got ",
              (aig.circ_state()[4], aig.circ_state()[6]))
    aig.circ_step([i])

# Variable names

tc.assertEqual(spot.aiger_circuit("""aag 2 2 0 2 0
2
4
2
1
i0 a
i1 b c
c
""").to_str(), 'aag 2 2 0 2 0\n2\n4\n2\n1\ni0 a\ni1 b c\no0 o0\no1 o1')

tc.assertEqual(spot.aiger_circuit("""aag 2 2 0 2 0
2
4
2
1
o0 x
o1 y
c
""").to_str(), 'aag 2 2 0 2 0\n2\n4\n2\n1\ni0 i0\ni1 i1\no0 x\no1 y')


def report_missing_exception():
    raise RuntimeError("missing exception")

try:
    spot.aiger_circuit("""aag 2 2 0 2
0
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:1: invalid header line")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 2 2 3 2 0
""")
except SyntaxError as e:
    tc.assertEqual(str(e),
                   "\n<string>:1: more variables than indicated by max var")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 2 2 0 2 0\n""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:2: expecting input number 2")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 2 2 0 2 0
3
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:2: expecting input number 2")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 2 2 0 2 0
3 4 5
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:2: invalid format for an input")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 2 2 0 2 0
2
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:3: expecting input number 4")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 4 2 2 0 0
2
4
1
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:4: invalid format for a latch")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 4 2 2 0 0
2
4
1 1
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:4: expecting latch number 6")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 4 2 2 0 0
2
4
6 1
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:5: expecting latch number 8")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 5 2 2 1 0
2
4
6 1
8 7
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:6: expecting an output")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 5 2 2 1 0
2
4
6 1
8 7
9 9 9
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:6: invalid format for an output")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 5 2 2 1 0
2
4
6 1
8 7
9 9 9
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:6: invalid format for an output")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:7: expecting AND gate number 10")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3 8 9
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:7: invalid format for an AND gate")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:7: invalid format for an AND gate")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3 8
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:8: expecting AND gate number 12")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3 8
12 8 10
i0
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:9: could not parse as input name")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3 8
12 8 10
i0 foo
i3 bar
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:10: value 3 exceeds input count")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3 8
12 8 10
i1 bar
i0 foo
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:9: expecting name for input 0")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3 8
12 8 10
i0 name with spaces
i1 name with spaces
""")
except SyntaxError as e:
    tc.assertEqual(str(e), \
        "\n<string>:10: name 'name with spaces' already used")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 1 2
2
4
6 1
8 7
9
10 3 8
12 8 10
i0 name with spaces
i1 bar
o0
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:11: could not parse as output name")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 2 2
2
4
6 1
8 7
9
10
10 3 8
12 8 10
i0 name with spaces
i1 bar
o1 hmm
o0 foo bar baz
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:12: expecting name for output 0")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 2 2
2
4
6 1
8 7
9
10
10 3 8
12 8 10
i0 name with spaces
i1 bar
o0 hmm
o2 foo bar baz
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:13: value 2 exceeds output count")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 2 2
2
4
6 1
8 7
9
10
10 3 8
12 8 10
i0 name with spaces
i1 bar
o0 foo
o1 foo
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:13: name 'foo' already used")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 2 2
2
4
6 1
8 7
9
10
10 3 8
12 8 10
i0 name with spaces
i1 bar
o0 foo
o1 bar
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:13: name 'bar' already used")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 2 2
2
4
6 1
8 7
9
10
10 3 8
12 8 10
i0 name with spaces
i1 bar
o0 foo
o1 baz
this is a bug
""")
except SyntaxError as e:
    tc.assertEqual(str(e), "\n<string>:14: unsupported line type")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 2 2 2 2
2
4
6 1
8 7
9
10
10 3 8
12 8 10
i0 name with spaces
o0 foo
o1 baz
c
this is not a bug
""")
except SyntaxError as e:
    tc.assertEqual(str(e), \
        "\n<string>:10: either all or none of the inputs should be named")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 3 2 2 2
2
4
6
8 1
10 7
9
10
12 3 8
14 8 10
i0 name0
i1 name1
o0 foo
o1 baz
c
this is not a bug
""")
except SyntaxError as e:
    tc.assertEqual(str(e), \
        "\n<string>:11-12: either all or none of the inputs should be named")
else:
    report_missing_exception()

try:
    spot.aiger_circuit("""aag 7 3 2 3 2
2
4
6
8 1
10 7
9
10
8
12 3 8
14 8 10
i0 name0
i1 name1
o0 foo
i2 name2
o1 baz
c
this is not a bug
""")
except SyntaxError as e:
    tc.assertEqual(str(e), \
        "\n<string>:14-16: either all or none of the outputs should be named")
else:
    report_missing_exception()

x = spot.aiger_circuit("""aag 7 3 2 3 2
2
4
6
8 1
10 7
9
10
8
12 3 8
14 8 10
i0 name0 space
i1 name1
o0 foo space
i2 name2
o1 baz
o2 bar
c
this is not a bug
""").to_str()
tc.assertEqual(x, spot.aiger_circuit(x).to_str())
