// -*- coding: utf-8 -*-
// Copyright (C) 2009, 2010, 2011, 2012, 2013 Laboratoire de Recherche et
// Développement de l'Epita (LRDE).
// Copyright (C) 2004, 2005 Laboratoire d'Informatique de Paris 6 (LIP6),
// département Systèmes Répartis Coopératifs (SRC), Université Pierre
// et Marie Curie.
//
// This file is part of Spot, a model checking library.
//
// Spot is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// Spot is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
// License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.


#ifndef SPOT_TGBAALGOS_REDUCTGBA_SIM_HH
#define SPOT_TGBAALGOS_REDUCTGBA_SIM_HH

#if __GNUC__
#ifndef SKIP_DEPRECATED_WARNING
#warning This file is deprecated.  Use postproc.hh instead.
#endif
#endif

#include "misc/common.hh"

namespace spot
{
  class tgba;

  /// \addtogroup tgba_reduction
  /// @{

  /// Options for reduce.
  enum reduce_tgba_options
    {
      // Reduce_None and Reduce_All clash with the definitions in ltl::reduce
      // for Swig because Swig does not handle namespaces.
#ifndef SWIG
      /// No reduction.
      Reduce_None = 0,
#endif
      /// Reduction of state using direct simulation relation.
      Reduce_quotient_Dir_Sim = 1,
      /// Reduction of transitions using direct simulation relation.
      Reduce_transition_Dir_Sim = 2,
      /// Reduction of state using delayed simulation relation.
      Reduce_quotient_Del_Sim = 4,
      /// Reduction of transition using delayed simulation relation.
      Reduce_transition_Del_Sim = 8,
      /// Reduction using SCC.
      Reduce_Scc = 16,
#ifndef SWIG
      /// All reductions.
      Reduce_All = -1U
#endif
    };

  /// \brief Simplify the automaton using a simulation relation.
  ///
  /// Do not use this obsolete function.
  ///
  /// \param a the automata to reduce
  /// \param opt a conjonction of spot::reduce_tgba_options specifying
  ///             which optimizations to apply.  Actually any
  ///             simulation-related flag will cause direct simulation
  ///             to be applied.
  /// \return the reduced automaton
  /// \deprecated Use scc_filter(), minimize_wdba(), simulation(),
  /// or postprocessor.
  SPOT_API SPOT_DEPRECATED
  const tgba* reduc_tgba_sim(const tgba* a, int opt = Reduce_All);

  /// @}
}

#endif // SPOT_TGBAALGOS_REDUCTGBA_SIM_HH
