// Copyright (C) 2003, 2004, 2006  Laboratoire d'Informatique de Paris 6 (LIP6),
// dpartement Systmes Rpartis Coopratifs (SRC), Universit Pierre
// et Marie Curie.
//
// This file is part of Spot, a model checking library.
//
// Spot is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// Spot is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
// License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "ssp.hh"
#include "tgbaalgos/dotty.hh"
#include "tgba/tgbaexplicit.hh"
#include "tgbaparse/public.hh"

int
main(int argc, char **argv)
  try
    {
      spot::ltl::declarative_environment env;

      if (argc <= 3)
	{
	  std::cerr << "usage: " << argv[0] << " model automata props..."
		    << std::endl;
	  exit(1);
	}

      while (argc > 3)
	env.declare(argv[--argc]);

      spot::bdd_dict* dict = new spot::bdd_dict();
      spot::gspn_ssp_interface gspn(2, argv, dict, env);

      spot::tgba_parse_error_list pel1;
      spot::tgba_explicit* control = spot::tgba_parse(argv[--argc], pel1,
						      dict, env);
      if (spot::format_tgba_parse_errors(std::cerr, argv[argc], pel1))
	return 2;

      spot::tgba* a = gspn.automaton(control);
      spot::dotty_reachable(std::cout, a);

      delete a;
      delete control;
      delete dict;
    }
  catch (spot::gspn_exception e)
    {
      std::cerr << e << std::endl;
      throw;
    }
