/*
 * VRT RULES
 *
 * Copyright (C) 2014-2021 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule2404eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule2404flow0 =
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule2404option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule2404flow0 }
};
// content:"|00 00|", relative;
static ContentInfo rule2404content1 =
{
    (u_int8_t *)("|00 00|"), /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2404option1 =
{
    OPTION_TYPE_CONTENT,
    { &rule2404content1 }
};
// content:"|00 00|", relative;
static ContentInfo rule2404content2 =
{
    (u_int8_t *)("|00 00|"), /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2404option2 =
{
    OPTION_TYPE_CONTENT,
    { &rule2404content2 }
};
// content:"|00|", depth 1;
static ContentInfo rule2404content3 =
{
    (u_int8_t *)("|00|"), /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2404option3 =
{
    OPTION_TYPE_CONTENT,
    { &rule2404content3 }
};
/* byte_test:size 2, value 322, operator >, offset 2; */
static ByteData rule2404byte_test4 =
{
    2, /* size */
    CHECK_GT, /* operator */
    322, /* value */
    2, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2404option4 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2404byte_test4 }
};
// content:"|FF|SMBs", offset 4, depth 5, nocase;
static ContentInfo rule2404content5 =
{
    (u_int8_t *)("|FF|SMBs"), /* pattern (now in snort content format) */
    5, /* depth */
    4, /* offset */
    CONTENT_NOCASE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2404option5 =
{
    OPTION_TYPE_CONTENT,
    { &rule2404content5 }
};
/* byte_test:size 1, value 128, operator &, offset 6, relative; */
static ByteData rule2404byte_test6 =
{
    1, /* size */
    CHECK_AND, /* operator */
    128, /* value */
    6, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2404option6 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2404byte_test6 }
};
/* byte_test:size 2, value 255, operator >, offset 54, relative, endian little; */
static ByteData rule2404byte_test7 =
{
    2, /* size */
    CHECK_GT, /* operator */
    255, /* value */
    54, /* offset */
    0, /*multiplier */
    BYTE_LITTLE_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2404option7 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2404byte_test7 }
};
// content:"|00|", offset 56, relative;
static ContentInfo rule2404content8 =
{
    (u_int8_t *)("|00|"), /* pattern (now in snort content format) */
    0, /* depth */
    56, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2404option8 =
{
    OPTION_TYPE_CONTENT,
    { &rule2404content8 }
};
// content:"|00 00|", offset 255, relative;
static ContentInfo rule2404content9 =
{
    (u_int8_t *)("|00 00|"), /* pattern (now in snort content format) */
    0, /* depth */
    255, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2404option9 =
{
    OPTION_TYPE_CONTENT,
    { &rule2404content9 }
};
// content:"|00 00|", relative;
static ContentInfo rule2404content10 =
{
    (u_int8_t *)("|00 00|"), /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2404option10 =
{
    OPTION_TYPE_CONTENT,
    { &rule2404content10 }
};

/* references for sid 2404 */
/* reference: bugtraq "9752"; */
static RuleReference rule2404ref1 =
{
    "bugtraq", /* type */
    "9752" /* value */
};

/* reference: url "www.eeye.com/html/Research/Advisories/AD20040226.html"; */
static RuleReference rule2404ref2 =
{
    "url", /* type */
    "www.eeye.com/html/Research/Advisories/AD20040226.html" /* value */
};

static RuleReference *rule2404refs[] =
{
    &rule2404ref1,
    &rule2404ref2,
    NULL
};

static RuleMetaData rule2404meta1 =
{
    "service netbios-ssn"
};

static RuleMetaData *rule2404meta[] =
{
    &rule2404meta1,
    NULL
};

RuleOption *rule2404options[] =
{
    &rule2404option0,
    &rule2404option1,
    &rule2404option2,
    &rule2404option3,
    &rule2404option4,
    &rule2404option5,
    &rule2404option6,
    &rule2404option7,
    &rule2404option8,
    &rule2404option9,
    &rule2404option10,
    NULL
};

Rule rule2404 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       1, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "445", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       2404, /* sigid */
       5, /* revision */

       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "NETBIOS SMB-DS Session Setup AndX request unicode username overflow attempt",     /* message */
       rule2404refs, /* ptr to references */
       rule2404meta, /* Meta data */
    },
   rule2404options, /* ptr to rule options */
    &rule2404eval, /* use the built in detection function */
   0, /* am I initialized yet? */
   0,                                  /* Rule option count, used internally */
   0,                                  /* Flag with no alert, used internally */
   NULL /* ptr to internal data... setup during rule registration */
};


/* detection functions */
int rule2404eval(void *p) {
    //const u_int8_t *cursor_uri = 0;
    //const u_int8_t *cursor_raw = 0;
    const u_int8_t *cursor_normal = 0;


    // flow:established, to_server;
    if (checkFlow(p, rule2404options[0]->option_u.flowFlags) > 0 ) {
        // content:"|00 00|", relative;
        if (contentMatch(p, rule2404options[1]->option_u.content, &cursor_normal) > 0) {
            // content:"|00 00|", relative;
            if (contentMatch(p, rule2404options[2]->option_u.content, &cursor_normal) > 0) {
                // content:"|00|", depth 1;
                if (contentMatch(p, rule2404options[3]->option_u.content, &cursor_normal) > 0) {
                    // byte_test:size 2, value 322, operator >, offset 2;
                    if (byteTest(p, rule2404options[4]->option_u.byte, cursor_normal) > 0) {
                        // content:"|FF|SMBs", offset 4, depth 5, nocase;
                        if (contentMatch(p, rule2404options[5]->option_u.content, &cursor_normal) > 0) {
                            // byte_test:size 1, value 128, operator &, offset 6, relative;
                            if (byteTest(p, rule2404options[6]->option_u.byte, cursor_normal) > 0) {
                                // byte_test:size 2, value 255, operator >, offset 54, relative, endian little;
                                if (byteTest(p, rule2404options[7]->option_u.byte, cursor_normal) > 0) {
                                    // content:"|00|", offset 56, relative;
                                    if (contentMatch(p, rule2404options[8]->option_u.content, &cursor_normal) > 0) {
                                        // content:"|00 00|", offset 255, relative;
                                        if (contentMatch(p, rule2404options[9]->option_u.content, &cursor_normal) > 0) {
                                            // content:"|00 00|", relative;
                                            if (contentMatch(p, rule2404options[10]->option_u.content, &cursor_normal) > 0) {
                                                return RULE_MATCH;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return RULE_NOMATCH;
}

