/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jv.number.PuDouble;
import jv.number.PuDouble_Config;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;

public class PuDouble_IP
extends PsPanel
implements ActionListener,
AdjustmentListener {
    protected PuDouble m_number;
    protected int m_oldValue = 0;
    protected int m_newValue = 0;
    protected Button m_bConfig;
    protected TextField m_text;
    public Scrollbar m_scrollbar;
    private static /* synthetic */ Class class$jv$number$PuDouble_IP;

    public void adjustmentValueChanged(AdjustmentEvent event) {
        Object source = event.getSource();
        if (source == this.m_scrollbar) {
            this.m_newValue = event.getValue();
            if (this.m_oldValue == this.m_newValue) {
                return;
            }
            this.m_oldValue = this.m_newValue;
            switch (event.getAdjustmentType()) {
                case 5: {
                    this.m_number.setIntValue(this.m_newValue);
                    break;
                }
                case 2: {
                    this.m_number.setValueFromPanel(this.m_number.m_value - this.m_number.m_lineIncr, this);
                    break;
                }
                case 1: {
                    this.m_number.setValueFromPanel(this.m_number.m_value + this.m_number.m_lineIncr, this);
                    break;
                }
                case 3: {
                    this.m_number.setValueFromPanel(this.m_number.m_value - this.m_number.m_pageIncr, this);
                    break;
                }
                case 4: {
                    this.m_number.setValueFromPanel(this.m_number.m_value + this.m_number.m_pageIncr, this);
                    break;
                }
            }
            ((TextComponent)this.m_text).setText(String.valueOf(Math.rint(this.m_number.m_shownAccuracy * this.m_number.getValue()) / this.m_number.m_shownAccuracy));
            PsDebug.notify("setValue=" + this.m_number.getValue());
            this.m_number.update(this);
        }
    }

    public PuDouble_IP() {
        if (this.getClass() == (class$jv$number$PuDouble_IP != null ? class$jv$number$PuDouble_IP : (class$jv$number$PuDouble_IP = PuDouble_IP.class$("jv.number.PuDouble_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_number = (PuDouble)parent;
        this.setTitle(this.m_number.getName());
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_number == null) {
            PsDebug.warning("missing double");
            return true;
        }
        if (object == this.m_number) {
            ((TextComponent)this.m_text).setText(String.valueOf(Math.rint(this.m_number.m_shownAccuracy * this.m_number.getValue()) / this.m_number.m_shownAccuracy));
            this.m_scrollbar.setUnitIncrement(1);
            this.m_scrollbar.setBlockIncrement(this.m_number.m_iPageIncr);
            this.m_scrollbar.setValues(this.m_number.m_iValue, this.m_number.m_iPageIncr, 0, this.m_number.m_numOfIncrements);
            this.m_oldValue = this.m_number.m_iValue;
            this.setEnabled(this.m_number.m_enabled);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_text) {
            PsDebug.notify("text chosen");
            String text = this.m_text.getText();
            if (text == null || text.equals("")) {
                return;
            }
            try {
                text = this.m_text.getText();
                this.m_number.setValueFromPanel(new Double(text), this);
                this.m_scrollbar.setValue(this.m_number.m_iValue);
                this.m_oldValue = this.m_number.m_iValue;
                PsDebug.notify("setValue=" + this.m_number.getValue());
            }
            catch (NumberFormatException e) {
                PsDebug.warning("wrong format = " + text);
                return;
            }
            this.m_number.update(this);
        } else if (source == this.m_bConfig) {
            PuDouble_Config config = new PuDouble_Config(this.m_number);
            config.init(this.m_number.m_minimum, this.m_number.m_maximum, this.m_number.m_lineIncr, this.m_number.m_pageIncr, this.m_number.m_shownAccuracy);
            config.setParent(this);
            ((Component)config).setVisible(true);
            this.m_number.update(this.m_number);
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(1, 2));
        Panel textPanel = new Panel();
        textPanel.setLayout(new GuiStackLayout(0, 0));
        this.add(textPanel);
        this.setTitle("");
        textPanel.add("WIDE*2", this.getTitle());
        this.m_text = new TextField(7);
        this.m_text.addActionListener(this);
        textPanel.add("FILL*1", this.m_text);
        Panel scroll = new Panel();
        scroll.setLayout(new BorderLayout());
        this.add(scroll);
        this.m_scrollbar = new Scrollbar(0);
        this.m_scrollbar.addAdjustmentListener(this);
        scroll.add("Center", this.m_scrollbar);
        this.m_bConfig = new Button(PsConfig.getMessage("bConfig"));
        this.m_bConfig.addActionListener(this);
        scroll.add("East", this.m_bConfig);
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.m_bConfig.setEnabled(flag);
        this.m_lTitle.setEnabled(flag);
        this.m_text.setEnabled(flag);
        this.m_scrollbar.setEnabled(flag);
    }
}

