/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import jv.loader.PgFileDialog;
import jv.loader.PjImportModel;
import jv.loader.PjImportModel_Dialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

public class PjImportModel_InfoBox
extends PjProject_IP
implements ActionListener {
    protected PjImportModel m_importModel;
    protected String m_fileName;
    protected String m_dirName;
    protected TextField m_tSelectedModel;
    protected Button m_bLoad;
    protected Button m_bBrowse;
    protected PjImportModel_Dialog m_dialog;
    private static /* synthetic */ Class class$jv$loader$PjImportModel_InfoBox;

    public PjImportModel_InfoBox() {
        if (this.getClass() == (class$jv$loader$PjImportModel_InfoBox != null ? class$jv$loader$PjImportModel_InfoBox : (class$jv$loader$PjImportModel_InfoBox = PjImportModel_InfoBox.class$("jv.loader.PjImportModel_InfoBox")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_importModel = (PjImportModel)this.m_project;
        ((TextComponent)this.m_tSelectedModel).setText(this.m_importModel.m_fullFileName);
        this.m_fileName = new File(this.m_importModel.m_fullFileName).getName();
        String fileName = this.m_fileName.substring(this.m_fileName.lastIndexOf(47) + 1, this.m_fileName.length());
        this.setTitle(PsConfig.getMessage("LoadModel") + ": " + fileName);
    }

    public boolean update(Object anObject) {
        if (this.m_project == null) {
            PsDebug.warning("missing parent, setParent not called");
            return false;
        }
        if (anObject == this.m_project) {
            ((TextComponent)this.m_tSelectedModel).setText(this.m_importModel.m_fullFileName);
            this.m_fileName = new File(this.m_importModel.m_fullFileName).getName();
            String fileName = this.m_fileName.substring(this.m_fileName.lastIndexOf(47) + 1, this.m_fileName.length());
            this.setTitle(PsConfig.getMessage("LoadModel") + ": " + fileName);
        }
        return super.update(anObject);
    }

    public void actionPerformed(ActionEvent event) {
        PsDebug.notify("called");
        Object source = event.getSource();
        if (source == this.m_tSelectedModel) {
            if ("".compareTo(this.m_tSelectedModel.getText()) != 0) {
                PsDebug.notify("selected = " + this.m_tSelectedModel.getText());
                this.m_fileName = this.m_tSelectedModel.getText();
                this.m_fileName.trim();
                if (this.m_importModel.load(this.m_fileName)) {
                    this.m_fileName = new File(this.m_importModel.m_fullFileName).getName();
                    String fileName = this.m_fileName.substring(this.m_fileName.lastIndexOf(47) + 1, this.m_fileName.length());
                    this.setTitle(PsConfig.getMessage("LoadModel") + ": " + fileName);
                }
            }
            PsDebug.notify("no Model selected");
        } else if (source == this.m_bLoad) {
            if (this.m_dialog != null) {
                ((Component)this.m_dialog).setVisible(true);
                this.m_importModel.update(this.m_importModel);
                return;
            }
            this.m_dialog = new PjImportModel_Dialog(PsConfig.getFrame());
            this.m_dialog.setParent(this.m_importModel);
            ((Component)this.m_dialog).setBounds(50, 50, 400, 400);
            ((Component)this.m_dialog).setVisible(true);
        } else if (source == this.m_bBrowse) {
            boolean m_load = true;
            PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage("OpenGeometry"), m_load ? 0 : 1);
            if (this.m_dirName == null) {
                this.m_dirName = PsConfig.getCodeBase() + "models";
            }
            ((FileDialog)fd).setDirectory(this.m_dirName);
            ((Component)fd).setVisible(true);
            String fileName = fd.getFile();
            if (fileName == null) {
                PsDebug.notify("dialog cancelled");
                return;
            }
            PsDebug.notify("file = " + fileName);
            this.m_dirName = ((FileDialog)fd).getDirectory();
            PsDebug.notify("dir  = " + this.m_dirName);
            this.m_fileName = this.m_dirName + fileName;
            this.m_fileName.trim();
            if (this.m_importModel.load(this.m_fileName)) {
                ((TextComponent)this.m_tSelectedModel).setText(this.m_importModel.m_fullFileName);
                this.m_fileName = new File(this.m_importModel.m_fullFileName).getName();
                fileName = this.m_fileName.substring(this.m_fileName.lastIndexOf(47) + 1, this.m_fileName.length());
                this.setTitle(PsConfig.getMessage("LoadModel") + ": " + fileName);
            }
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public String getSelection() {
        return this.m_tSelectedModel.getText();
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.m_dirName = null;
        this.m_tSelectedModel = new TextField(25);
        this.m_tSelectedModel.addActionListener(this);
        this.add(this.m_tSelectedModel);
        Panel m_pBottomButtons = new Panel();
        m_pBottomButtons.setLayout(new FlowLayout(1));
        this.m_bLoad = new Button(PsConfig.getMessage("SelectModel"));
        this.m_bLoad.addActionListener(this);
        m_pBottomButtons.add(this.m_bLoad);
        if (PsConfig.isApplication()) {
            PsDebug.notify("application, try to setup file dialog");
            this.m_bBrowse = new Button(PsConfig.getMessage("BrowseComputer"));
            this.m_bBrowse.addActionListener(this);
            m_pBottomButtons.add(this.m_bBrowse);
        }
        this.add(m_pBottomButtons);
    }
}

