/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class AppearanceScheme {
    Color[] baseSurfaceColors = new Color[]{new Color(240, 160, 0), new Color(160, 240, 0), new Color(0, 160, 240), new Color(240, 0, 160), new Color(0, 240, 160), new Color(160, 0, 240)};
    double surfaceIntensityFactor = 0.8;
    Color[] baseCurveColors = new Color[]{Color.black, Color.white};
    double curveIntensityFactor = 0.7;

    AppearanceScheme() {
    }

    public Color brighter(Color color, double d, int n) {
        try {
            Color color2 = new Color((int)(255.0 * (1.0 - (1.0 - (double)color.getRed() / 255.0) * Math.pow(d, n - 1))), (int)(255.0 * (1.0 - (1.0 - (double)color.getGreen() / 255.0) * Math.pow(d, n - 1))), (int)(255.0 * (1.0 - (1.0 - (double)color.getBlue() / 255.0) * Math.pow(d, n - 1))));
            return color2;
        }
        catch (Exception exception) {
            return color;
        }
    }

    public Color darker(Color color, double d, int n) {
        try {
            Color color2 = new Color((int)((double)color.getRed() * Math.pow(d, n - 1)), (int)((double)color.getGreen() * Math.pow(d, n - 1)), (int)((double)color.getBlue() * Math.pow(d, n - 1)));
            return color2;
        }
        catch (Exception exception) {
            return color;
        }
    }

    public Color getEquationColorInside(int n) {
        return this.brighter(this.baseSurfaceColors[(n - 1) % this.baseSurfaceColors.length], this.surfaceIntensityFactor, n / this.baseSurfaceColors.length * 3 + 2);
    }

    public Color getEquationColorOutside(int n) {
        return this.brighter(this.baseSurfaceColors[(n - 1) % this.baseSurfaceColors.length], this.surfaceIntensityFactor, n / this.baseSurfaceColors.length * 3 + 1);
    }

    public Color getCurveColor(int n) {
        if (n % 2 == 1) {
            return this.brighter(this.baseCurveColors[(n - 1) % 2], this.curveIntensityFactor, n / 2 + 1);
        }
        return this.darker(this.baseCurveColors[(n - 1) % 2], this.curveIntensityFactor, (n - 1) / 2 + 1);
    }
}

