/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Graphics;
import jv.vecmath.PiVector;
import jv.viewer.PvGeometry;

final class PvThickGraphics {
    private static PiVector xCorners = new PiVector(4);
    private static PiVector yCorners = new PiVector(4);

    public static void drawRect(Graphics g, int lineWidth, int left, int top, int width, int height) {
        left -= (lineWidth *= PvGeometry.PS_ZOOM) / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        lineWidth /= PvGeometry.PS_ZOOM;
        int i = 0;
        while (i < lineWidth) {
            g.drawRect(left, top, width, height);
            left += PvGeometry.PS_ZOOM;
            top += PvGeometry.PS_ZOOM;
            width -= 2 * PvGeometry.PS_ZOOM;
            height -= 2 * PvGeometry.PS_ZOOM;
            ++i;
        }
    }

    public static void drawLine(Graphics g, int lineWidth, int x1, int y1, int x2, int y2) {
        if (lineWidth == 1) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            double halfWidth = (double)(lineWidth *= PvGeometry.PS_ZOOM) / 2.0;
            double deltaX = x2 - x1;
            double deltaY = y1 - y2;
            double angle = x1 == x2 ? 0.0 : Math.atan(deltaY / deltaX) - 1.5707963267948966;
            int xOffset = (int)(halfWidth * Math.cos(angle));
            int yOffset = (int)(halfWidth * Math.sin(angle));
            int[] xCorners = new int[]{x1 + xOffset, x2 + xOffset, x2 - xOffset, x1 - xOffset};
            int[] yCorners = new int[]{y1 - yOffset, y2 - yOffset, y2 + yOffset, y1 + yOffset};
            g.fillPolygon(xCorners, yCorners, 4);
            if (lineWidth > 3 * PvGeometry.PS_ZOOM) {
                int hw = (int)halfWidth;
                g.fillOval(x1 - hw, y1 - hw, lineWidth - PvGeometry.PS_ZOOM, lineWidth - PvGeometry.PS_ZOOM);
                g.fillOval(x2 - hw, y2 - hw, lineWidth - PvGeometry.PS_ZOOM, lineWidth - PvGeometry.PS_ZOOM);
            }
        }
    }

    public static void drawOval(Graphics g, int lineWidth, int left, int top, int width, int height) {
        left -= (lineWidth *= PvGeometry.PS_ZOOM) / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        lineWidth /= PvGeometry.PS_ZOOM;
        int i = 0;
        while (i < lineWidth) {
            g.drawOval(left, top, width, height);
            if (i + 1 < lineWidth) {
                g.drawOval(left, top, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM);
                g.drawOval(left + PvGeometry.PS_ZOOM, top, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM);
                g.drawOval(left, top + PvGeometry.PS_ZOOM, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM);
                g.drawOval(left + PvGeometry.PS_ZOOM, top + PvGeometry.PS_ZOOM, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM);
                left += PvGeometry.PS_ZOOM;
                top += PvGeometry.PS_ZOOM;
                width -= 2 * PvGeometry.PS_ZOOM;
                height -= 2 * PvGeometry.PS_ZOOM;
            }
            ++i;
        }
    }

    PvThickGraphics() {
    }

    public static void drawArc(Graphics g, int lineWidth, int left, int top, int width, int height, int startAngle, int deltaAngle) {
        left -= (lineWidth *= PvGeometry.PS_ZOOM) / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        lineWidth /= PvGeometry.PS_ZOOM;
        int i = 0;
        while (i < lineWidth) {
            g.drawArc(left, top, width, height, startAngle, deltaAngle);
            if (i + 1 < lineWidth) {
                g.drawArc(left, top, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, startAngle, deltaAngle);
                g.drawArc(left + 1, top, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, startAngle, deltaAngle);
                g.drawArc(left, top + 1, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, startAngle, deltaAngle);
                g.drawArc(left + 1, top + 1, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, startAngle, deltaAngle);
                left += PvGeometry.PS_ZOOM;
                top += PvGeometry.PS_ZOOM;
                width -= 2 * PvGeometry.PS_ZOOM;
                height -= 2 * PvGeometry.PS_ZOOM;
            }
            ++i;
        }
    }

    public static void draw3DRect(Graphics g, int lineWidth, int left, int top, int width, int height, boolean isRaised) {
        left -= (lineWidth *= PvGeometry.PS_ZOOM) / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        lineWidth /= PvGeometry.PS_ZOOM;
        int i = 0;
        while (i < lineWidth) {
            g.draw3DRect(left, top, width, height, isRaised);
            left += PvGeometry.PS_ZOOM;
            top += PvGeometry.PS_ZOOM;
            width -= 2 * PvGeometry.PS_ZOOM;
            height -= 2 * PvGeometry.PS_ZOOM;
            ++i;
        }
    }

    public static void drawLineAura(Graphics g, int lineWidth, int x1, int y1, int x2, int y2, int side) {
        if (lineWidth == 1) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            double angle;
            double halfWidth = (double)(lineWidth *= PvGeometry.PS_ZOOM) / 2.0;
            double deltaX = x2 - x1;
            double deltaY = y1 - y2;
            if (x1 == x2) {
                angle = deltaY > 0.0 ? 0.0 : -Math.PI;
            } else {
                angle = Math.atan(deltaY / deltaX) - 1.5707963267948966;
                if (x2 < x1) {
                    angle = deltaY > 0.0 ? (angle += Math.PI) : (angle -= Math.PI);
                }
            }
            int xOffset = (int)(halfWidth * Math.cos(angle));
            int yOffset = (int)(halfWidth * Math.sin(angle));
            if (side == 0) {
                xCorners.set(x1 - xOffset, x2 - xOffset, x2 + xOffset, x1 + xOffset);
                yCorners.set(y1 + yOffset, y2 + yOffset, y2 - yOffset, y1 - yOffset);
            } else if (side == 1) {
                xCorners.set(x1 - xOffset, x2 - xOffset, x2, x1);
                yCorners.set(y1 + yOffset, y2 + yOffset, y2, y1);
            } else {
                xCorners.set(x1 + xOffset, x2 + xOffset, x2, x1);
                yCorners.set(y1 - yOffset, y2 - yOffset, y2, y1);
            }
            g.fillPolygon(PvThickGraphics.xCorners.m_data, PvThickGraphics.yCorners.m_data, 4);
        }
    }

    public static void drawCircle(Graphics g, int x, int y, int r) {
        g.drawOval(x - r, y - r, 2 * r, 2 * r);
    }

    public static void drawCircle(Graphics g, int lineWidth, int x, int y, int r) {
        r += lineWidth / 2;
        r *= PvGeometry.PS_ZOOM;
        int i = 0;
        while (i < lineWidth) {
            PvThickGraphics.drawCircle(g, x, y, r);
            if (i + 1 < lineWidth) {
                PvThickGraphics.drawCircle(g, x + PvGeometry.PS_ZOOM, y, r - PvGeometry.PS_ZOOM);
                PvThickGraphics.drawCircle(g, x - PvGeometry.PS_ZOOM, y, r - PvGeometry.PS_ZOOM);
                PvThickGraphics.drawCircle(g, x, y + PvGeometry.PS_ZOOM, r - PvGeometry.PS_ZOOM);
                PvThickGraphics.drawCircle(g, x, y - PvGeometry.PS_ZOOM, r - PvGeometry.PS_ZOOM);
                r -= PvGeometry.PS_ZOOM;
            }
            ++i;
        }
    }

    public static void drawPolygon(Graphics g, int lineWidth, int[] x, int[] y, int len) {
        if (lineWidth == PvGeometry.PS_ZOOM) {
            g.drawPolygon(x, y, len);
        } else {
            int i = 0;
            while (i < len) {
                PvThickGraphics.drawLine(g, lineWidth, x[i], y[i], x[(i + 1) % len], y[(i + 1) % len]);
                ++i;
            }
        }
    }

    public static void drawPolygon(Graphics g, int lineWidth, int[] x, int[] y, int len, boolean side) {
        if (lineWidth == PvGeometry.PS_ZOOM) {
            g.drawPolygon(x, y, len);
        } else {
            int[] xp = new int[len];
            int[] yp = new int[y.length];
            boolean ok = PvThickGraphics.getParallelCurve(xp, yp, x, y, len, lineWidth *= PvGeometry.PS_ZOOM, true, side);
            if (!ok) {
                return;
            }
            --len;
            int i = 0;
            while (i < len) {
                xCorners.set(x[i], xp[i], xp[i + 1], x[i + 1]);
                yCorners.set(y[i], yp[i], yp[i + 1], y[i + 1]);
                g.fillPolygon(PvThickGraphics.xCorners.m_data, PvThickGraphics.yCorners.m_data, 4);
                ++i;
            }
            if (len > 0) {
                xCorners.set(x[len], xp[len], xp[0], x[0]);
                yCorners.set(y[len], yp[len], yp[0], y[0]);
                g.fillPolygon(PvThickGraphics.xCorners.m_data, PvThickGraphics.yCorners.m_data, 4);
            }
        }
    }

    public static void drawRoundRect(Graphics g, int lineWidth, int left, int top, int width, int height, int arcWidth, int arcHeight) {
        left -= (lineWidth *= PvGeometry.PS_ZOOM) / 2;
        top -= lineWidth / 2;
        width += lineWidth;
        height += lineWidth;
        lineWidth /= PvGeometry.PS_ZOOM;
        int i = 0;
        while (i < lineWidth) {
            g.drawRoundRect(left, top, width, height, arcWidth, arcHeight);
            if (i + 1 < lineWidth) {
                g.drawRoundRect(left, top, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, arcWidth, arcHeight);
                g.drawRoundRect(left + PvGeometry.PS_ZOOM, top, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, arcWidth, arcHeight);
                g.drawRoundRect(left, top + PvGeometry.PS_ZOOM, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, arcWidth, arcHeight);
                g.drawRoundRect(left + PvGeometry.PS_ZOOM, top + PvGeometry.PS_ZOOM, width - PvGeometry.PS_ZOOM, height - PvGeometry.PS_ZOOM, arcWidth, arcHeight);
                left += PvGeometry.PS_ZOOM;
                top += PvGeometry.PS_ZOOM;
                width -= 2 * PvGeometry.PS_ZOOM;
                height -= 2 * PvGeometry.PS_ZOOM;
            }
            ++i;
        }
    }

    public static void fillCircle(Graphics g, int x, int y, int r) {
        g.fillOval(x - (r *= PvGeometry.PS_ZOOM), y - r, 2 * r, 2 * r);
    }

    public static boolean getParallelCurve(int[] xp, int[] yp, int[] x, int[] y, int len, double dist, boolean bClosed, boolean bSide) {
        double diff;
        int numEdges = len - 1;
        if (bClosed) {
            ++numEdges;
        }
        double[] edgeAngle = new double[numEdges];
        double[] vertexAngle = new double[len];
        int i = 0;
        while (i < numEdges) {
            double angle;
            double deltaX = x[(i + 1) % len] - x[i];
            double deltaY = y[i] - y[(i + 1) % len];
            if (Math.abs(deltaX) + Math.abs(deltaY) < Math.abs(dist)) {
                return false;
            }
            if (x[(i + 1) % len] == x[i]) {
                angle = deltaY > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                angle = Math.atan(deltaY / deltaX);
                if (x[(i + 1) % len] < x[i]) {
                    angle = deltaY > 0.0 ? (angle += Math.PI) : (angle -= Math.PI);
                }
            }
            edgeAngle[i] = angle >= 0.0 ? angle : Math.PI * 2 + angle;
            ++i;
        }
        double tol = 0.2;
        if (bClosed && len > 2) {
            i = 0;
            while (i < len) {
                vertexAngle[i] = (edgeAngle[(i - 1 + len) % len] + edgeAngle[i] - Math.PI) / 2.0;
                diff = Math.abs(edgeAngle[(i - 1 + len) % len] - edgeAngle[i]);
                if (diff < tol || Math.abs(diff - Math.PI) < tol || Math.abs(diff - Math.PI * 2) < tol || Math.abs(diff - Math.PI * 3) < tol) {
                    return false;
                }
                if (Math.abs(diff) >= Math.PI) {
                    int n = i;
                    vertexAngle[n] = vertexAngle[n] + Math.PI;
                }
                ++i;
            }
        } else {
            i = 1;
            while (i < len - 1) {
                vertexAngle[i] = (edgeAngle[i - 1] + edgeAngle[i] - Math.PI) / 2.0;
                diff = Math.abs(edgeAngle[i - 1] - edgeAngle[i]);
                if (diff < tol || Math.abs(diff - Math.PI) < tol || Math.abs(diff - Math.PI * 2) < tol || Math.abs(diff - Math.PI * 3) < tol) {
                    return false;
                }
                if (diff >= Math.PI) {
                    int n = i;
                    vertexAngle[n] = vertexAngle[n] + Math.PI;
                }
                ++i;
            }
            vertexAngle[0] = edgeAngle[0] - 1.5707963267948966;
            vertexAngle[len - 1] = edgeAngle[len - 1] - 1.5707963267948966;
        }
        i = 0;
        while (i < len) {
            if (bSide) {
                xp[i] = (int)((double)x[i] - dist * Math.cos(vertexAngle[i]));
                yp[i] = (int)((double)y[i] + dist * Math.sin(vertexAngle[i]));
            } else {
                xp[i] = (int)((double)x[i] + dist * Math.cos(vertexAngle[i]));
                yp[i] = (int)((double)y[i] - dist * Math.sin(vertexAngle[i]));
            }
            ++i;
        }
        return true;
    }
}

