/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.object.PsDebug;

public abstract class P_Vector
implements Serializable {
    protected static final int NUM_BITS = 32;
    protected static final int BITS = 6;
    protected static final int MASK = 63;
    protected long[] m_bits;
    protected String m_name;
    protected int[] m_constraint;

    public String toString() {
        int i;
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append("\t" + super.toString());
        strBuf.append("\n");
        strBuf.append("\t ******* P_Vector ***********\n");
        strBuf.append("\t Name = ");
        if (this.m_name != null) {
            strBuf.append(this.getName());
        }
        if (this.m_bits != null && this.m_bits.length > 0) {
            strBuf.append("\t Attr = (" + this.m_bits[0]);
            i = 1;
            while (i < this.m_bits.length) {
                strBuf.append(", " + this.m_bits[i]);
                ++i;
            }
            strBuf.append(")\n");
        } else {
            strBuf.append("\t Attr = null\n");
        }
        if (this.m_constraint != null && this.m_constraint.length > 0) {
            strBuf.append("\t Constraint = (" + this.m_constraint[0]);
            i = 1;
            while (i < this.m_constraint.length) {
                strBuf.append(", " + this.m_constraint[i]);
                ++i;
            }
            strBuf.append(")\n");
        } else {
            strBuf.append("\t Constraint = null\n");
        }
        return strBuf.toString();
    }

    public void clearTag(int aBit) {
        if (this.m_bits == null) {
            return;
        }
        int n = aBit >> 6;
        if (n >= this.m_bits.length) {
            this.grow(aBit);
        }
        int n2 = n;
        this.m_bits[n2] = this.m_bits[n2] & (1L << (aBit & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void create(int nbits) {
        this.m_bits = new long[nbits + 63 >> 6];
    }

    public void setTag(int aBit) {
        int n;
        if (this.m_bits == null) {
            this.create(32);
        }
        if ((n = aBit >> 6) >= this.m_bits.length) {
            this.grow(aBit);
        }
        int n2 = n;
        this.m_bits[n2] = this.m_bits[n2] | 1L << (aBit & 0x3F);
    }

    public boolean hasTag(int aBit) {
        if (this.m_bits == null) {
            return false;
        }
        int n = aBit >> 6;
        if (n < this.m_bits.length) {
            return (this.m_bits[n] & 1L << (aBit & 0x3F)) != 0L;
        }
        return false;
    }

    public void copy(P_Vector vec) {
        if (vec == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (vec.m_bits == null) {
            this.m_bits = null;
        } else {
            if (this.m_bits == null || this.m_bits.length < vec.m_bits.length) {
                this.create(vec.m_bits.length);
            }
            int i = this.m_bits.length - 1;
            while (i >= 0) {
                this.m_bits[i] = vec.m_bits[i];
                --i;
            }
        }
        this.m_name = vec.m_name;
    }

    public long[] getBits() {
        return this.m_bits;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    private void grow(int nbits) {
        long[] newbits = new long[Math.max(this.m_bits.length << 1, nbits + 63 >> 6)];
        int i = this.m_bits.length - 1;
        while (i >= 0) {
            this.m_bits[i] = newbits[i];
            --i;
        }
        this.m_bits = newbits;
    }

    public static P_Vector[][] clone(P_Vector[][] src) {
        P_Vector[][] clone = (P_Vector[][])src.clone();
        if (clone == null) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            if (src[i] != null) {
                clone[i] = P_Vector.clone(src[i]);
            }
            ++i;
        }
        return clone;
    }

    public static P_Vector[] clone(P_Vector[] src) {
        P_Vector[] clone = (P_Vector[])src.clone();
        if (clone == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < src.length) {
                if (src[i] != null) {
                    clone[i] = (P_Vector)src[i].clone();
                }
                ++i;
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        return clone;
    }
}

