/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PuData;

public final class PsAuthorInfo
extends PsObject {
    public static final int FIRST_NAME = 0;
    public static final int LAST_NAME = 1;
    public static final int ORGANIZATION = 2;
    public static final int ADDRESS = 3;
    public static final int EMAIL = 4;
    public static final int URL = 5;
    private static final int m_numCodes = 6;
    protected int m_numAuthors;
    protected int m_currAuthor;
    protected String[][] m_info = new String[6][];

    protected static int getNumCodes() {
        return 6;
    }

    public PsAuthorInfo() {
        this.init();
    }

    public PsXmlNode getXmlNode() {
        PsXmlNode authors = new PsXmlNode("authors");
        int i = 0;
        while (i < this.m_numAuthors) {
            String[] lines;
            PsXmlNode author = authors.addChild("author");
            author.addChild("firstname", this.m_info[0][i]);
            author.addChild("lastname", this.m_info[1][i]);
            PsXmlNode affiliation = author.addChild("affiliation");
            affiliation.addChild("organization", this.m_info[2][i]);
            PsXmlNode address = affiliation.addChild("address");
            if (this.m_info[3][i] != null && !this.m_info[3][i].equals("") && (lines = PuString.splitString(this.m_info[3][i], '\n')) != null && lines.length > 0) {
                int j = 0;
                while (j < lines.length) {
                    address.addChild("line", lines[j]);
                    ++j;
                }
            }
            author.addChild("email", this.m_info[4][i]);
            author.addChild("url", this.m_info[5][i]);
            ++i;
        }
        return authors;
    }

    public void setXmlNode(PsXmlNode node) {
        if (node == null) {
            PsDebug.warning("missing method argument.");
            return;
        }
        String authors = node.getType();
        if (authors == null || !authors.equals("authors")) {
            PsDebug.error("source node has wrong type = " + authors);
            return;
        }
        PsXmlNode[] author = PsXmlSrc.getRsrcNodes(node, "author");
        if (author != null) {
            this.setNumAuthors(author.length);
            int i = 0;
            while (i < this.m_numAuthors) {
                this.m_info[0][i] = PsXmlSrc.getRsrc(author[i], "firstname");
                this.m_info[1][i] = PsXmlSrc.getRsrc(author[i], "lastname");
                this.m_info[2][i] = PsXmlSrc.getRsrc(author[i], "organization");
                PsXmlNode address = PsXmlSrc.getRsrcNode(author[i], "address");
                PsXmlNode[] line = PsXmlSrc.getRsrcNodes(address, "line");
                if (line == null) {
                    line = PsXmlSrc.getRsrcNodes(address, "l");
                    PsDebug.error("usage of old address <l> element tag found.\n\tPlease, replace all occurances of <l> with with new tag <line>.");
                }
                this.m_info[3][i] = "";
                if (line != null && line.length > 0) {
                    int j = 0;
                    while (j < line.length) {
                        if (line[j].getContent() != null) {
                            if (this.m_info[3][i] != null && !this.m_info[3][i].equals("")) {
                                String[] stringArray = this.m_info[3];
                                int n = i;
                                stringArray[n] = stringArray[n] + "\n";
                            }
                            String[] stringArray = this.m_info[3];
                            int n = i;
                            stringArray[n] = stringArray[n] + line[j].getContent();
                        }
                        ++j;
                    }
                }
                this.m_info[4][i] = PsXmlSrc.getRsrc(author[i], "email");
                this.m_info[5][i] = PsXmlSrc.getRsrc(author[i], "url");
                ++i;
            }
        } else {
            this.setNumAuthors(0);
            PsDebug.warning("missing authors.");
        }
    }

    public int getSelectedAuthor() {
        return this.m_currAuthor;
    }

    public void setSelectedAuthor(int ind) {
        this.m_currAuthor = ind;
    }

    public String getInfo(int ind, int code) {
        if (ind < 0 || this.m_numAuthors <= ind) {
            PsDebug.warning("index out of range, ind = " + ind);
            return null;
        }
        if (code < 0 || 6 <= code) {
            PsDebug.warning("index out of range, code = " + code);
            return null;
        }
        return this.m_info[code][ind];
    }

    public void setInfo(int ind, int code, String name) {
        if (ind < 0 || this.m_numAuthors <= ind) {
            PsDebug.warning("index out of range][ind = " + ind);
            return;
        }
        this.m_info[code][ind] = name;
    }

    public int getNumAuthors() {
        return this.m_numAuthors;
    }

    public void init() {
        super.init();
        this.m_numAuthors = 0;
        this.m_currAuthor = 0;
        int code = 0;
        while (code < 6) {
            this.m_info[code] = null;
            ++code;
        }
    }

    public Object clone() {
        PsAuthorInfo clone = (PsAuthorInfo)super.clone();
        if (clone == null) {
            return null;
        }
        if (this.m_info != null) {
            clone.m_info = PuString.clone(this.m_info);
        }
        return clone;
    }

    public void setNumAuthors(int num) {
        this.m_numAuthors = num;
        int code = 0;
        while (code < 6) {
            this.m_info[code] = PuData.realloc(this.m_info[code], num);
            ++code;
        }
    }
}

