/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class JarResources {
    public boolean debugOn = false;
    private Hashtable htSizes = new Hashtable();
    private Hashtable htJarContents = new Hashtable();
    private boolean isApplication = true;
    private String jarFileName;

    public byte[] getResource(String name) {
        return (byte[])this.htJarContents.get(name);
    }

    public JarResources(String jarFileName) {
        this.jarFileName = jarFileName;
        this.init();
    }

    public JarResources(String jarFileName, boolean isApplication) {
        this.jarFileName = jarFileName;
        this.isApplication = isApplication;
        this.init();
    }

    public static void main(String[] args) throws IOException {
        JarResources jr;
        byte[] buff;
        if (args.length != 2) {
            System.err.println("usage: java JarResources <jar file name> <resource name>");
            System.exit(1);
        }
        if ((buff = (jr = new JarResources(args[0])).getResource(args[1])) == null) {
            System.out.println("Could not find " + args[1] + ".");
        } else {
            System.out.println("Found " + args[1] + " (length=" + buff.length + ").");
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    private void init() {
        try {
            BufferedInputStream bis;
            if (this.isApplication) {
                FileInputStream fis = new FileInputStream(this.jarFileName);
                bis = new BufferedInputStream(fis);
            } else {
                URL url = new URL(this.jarFileName);
                bis = new BufferedInputStream(url.openStream());
            }
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            int avail = ((FilterInputStream)zis).available();
            if (this.debugOn) {
                System.out.println("available " + avail);
            }
            if (avail < 0) {
                return;
            }
            int increment = 10000;
            int tmpsize = Math.min(avail, increment);
            byte[] tmp = new byte[tmpsize];
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
                }
                int rb = 0;
                int chunk = 0;
                while (avail - rb > 0) {
                    chunk = zis.read(tmp, rb, tmpsize - rb);
                    if (chunk == -1) break;
                    if ((rb += chunk) != tmpsize) continue;
                    byte[] sec = tmp;
                    tmp = new byte[tmpsize + increment];
                    System.arraycopy(sec, 0, tmp, 0, tmpsize);
                    tmpsize += increment;
                }
                int size = rb;
                byte[] b = new byte[size];
                System.arraycopy(tmp, 0, b, 0, size);
                this.htJarContents.put(ze.getName(), b);
                if (!this.debugOn) continue;
                System.out.println(ze.getName() + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize());
            }
        }
        catch (NullPointerException e) {
            System.out.println("done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

