/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.util.Hashtable;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.rsrc.JarResources;

public class PsImage {
    protected transient Image m_image;
    protected URL m_imageUrl;
    protected String m_imageName;
    protected String m_alternateText;
    protected int m_width;
    protected int m_height;
    protected boolean m_explicitSize = false;
    protected int m_explicitWidth = 0;
    protected int m_explicitHeight = 0;
    protected MediaTracker m_tracker;
    protected Component m_parentComponent;
    protected static int m_lastTrackerID = 0;
    protected int m_currentTrackerID;
    protected boolean m_bDoneLoading = false;
    private static Hashtable m_hashImage;

    public PsImage(URL url) {
        this.m_imageUrl = url;
        this.m_imageName = url.toString();
        this.m_alternateText = this.m_imageUrl.getFile();
        this.m_image = PsImage.getImage(this.m_imageUrl);
        this.init();
    }

    public PsImage(String imageName) {
        this.m_imageName = imageName;
        this.m_alternateText = imageName;
        this.m_image = PsImage.getImage(imageName);
        this.init();
    }

    public PsImage(Image anImage, String alternateText) {
        this.m_image = anImage;
        this.m_imageName = alternateText;
        this.m_alternateText = alternateText;
        this.init();
    }

    public boolean loadImage() {
        if (this.m_bDoneLoading) {
            return true;
        }
        PsDebug.notify("waiting for " + this.m_imageName);
        try {
            this.m_tracker.waitForID(this.m_currentTrackerID);
        }
        catch (InterruptedException i) {
        }
        catch (Exception e) {
            PsDebug.warning("Error loading image " + this.m_imageName + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        if (this.m_tracker.isErrorID(this.m_currentTrackerID)) {
            PsDebug.warning("Error loading image " + this.m_imageName);
            return false;
        }
        this.m_bDoneLoading = true;
        this.m_width = this.m_image.getWidth(null);
        this.m_height = this.m_image.getHeight(null);
        PsDebug.notify(this.m_imageName + " loaded, size = (" + this.m_width + ", " + this.m_height + ")");
        return true;
    }

    public static boolean loadImage(Component comp, Image image) {
        if (image == null) {
            PsDebug.warning("missing argument image.");
            return false;
        }
        MediaTracker tracker = new MediaTracker(comp);
        int currentTrackerID = 0;
        tracker.addImage(image, currentTrackerID);
        try {
            tracker.waitForID(currentTrackerID);
        }
        catch (Exception e) {
            PsDebug.warning("error loading image " + image.toString() + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        if (tracker.isErrorID(currentTrackerID)) {
            new Throwable("Error loading image " + image.toString()).printStackTrace();
            return false;
        }
        return true;
    }

    public static int[] getPixels(Image image, int x, int y, int width, int height, int[] pixels, int off, int scan) {
        if (image == null) {
            PsDebug.warning("missing image");
            return null;
        }
        if (pixels == null) {
            if (width > 0 && height > 0) {
                pixels = new int[width * height];
            }
            if (pixels == null) {
                PsDebug.warning("missing image size to create missing pixels");
                return null;
            }
        }
        PixelGrabber grabber = new PixelGrabber(image, x, y, width, height, pixels, off, scan);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            PsDebug.warning("could not grab pixels");
            return null;
        }
        return pixels;
    }

    public static int[] getPixels(Image image) {
        int[] pixels = null;
        if (image != null) {
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            if (imageWidth != -1 && imageHeight != -1) {
                pixels = new int[imageWidth * imageHeight];
                PixelGrabber grabber = new PixelGrabber(image, 0, 0, imageWidth, imageHeight, pixels, 0, imageWidth);
                try {
                    grabber.grabPixels();
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e);
                    PsDebug.warning("could not grab pixels");
                    return null;
                }
            }
        }
        return pixels;
    }

    public static PsImage getImageFromArchive(String imageName, String jarArchive) {
        Image img = null;
        PsImage psImg = null;
        if (m_hashImage != null && (psImg = (PsImage)m_hashImage.get(imageName)) != null) {
            PsDebug.message("Image taken from hashtable, image = " + imageName, false);
            return psImg;
        }
        PsDebug.message("Second attempt: reading Jar file directly", false);
        try {
            JarResources jar = PsConfig.isApplication() ? new JarResources(jarArchive) : new JarResources(PsConfig.getCodeBase() + jarArchive, false);
            if (jar == null) {
                PsDebug.warning("failed to create resource for jar archive = " + jarArchive);
                return new PsImage(imageName);
            }
            byte[] byteBlob = jar.getResource(imageName);
            if (byteBlob == null) {
                PsDebug.warning("failed to create blob for image = " + imageName);
                return new PsImage(imageName);
            }
            img = Toolkit.getDefaultToolkit().createImage(byteBlob);
            psImg = new PsImage(img, "ColorPicker");
            if (!psImg.loadImage()) {
                PsDebug.warning("failed to load image = " + imageName);
                return null;
            }
        }
        catch (Exception ex) {
            PsDebug.warning("exception during loading of image = " + imageName);
            return null;
        }
        if (m_hashImage == null) {
            m_hashImage = new Hashtable();
        }
        m_hashImage.put(imageName, psImg);
        return psImg;
    }

    public int getHeight() {
        return this.m_height;
    }

    public Image getImage() {
        boolean check;
        if (!this.m_bDoneLoading && !(check = this.loadImage())) {
            PsDebug.warning("loading of image failed = " + this.m_imageName);
            return null;
        }
        return this.m_image;
    }

    public void setSize(int width, int height) {
        this.m_explicitSize = true;
        this.getImage();
        double aspect = (0.5 + (double)this.m_width) / (double)this.m_height;
        this.m_explicitWidth = width;
        this.m_explicitHeight = height;
        if (width < 0 && height > 0) {
            this.m_explicitWidth = (int)(aspect * (double)height);
        } else if (width > 0 && height < 0) {
            this.m_explicitHeight = (int)((double)width / aspect);
        }
        this.m_image = this.m_image.getScaledInstance(this.m_explicitWidth, this.m_explicitWidth, 4);
    }

    public static Image getImage(String imageName) {
        Image image;
        if (!PsConfig.isApplication()) {
            image = PsConfig.getApplet().getImage(PsConfig.getApplet().getCodeBase(), imageName);
        } else {
            image = Toolkit.getDefaultToolkit().getImage(imageName);
            if (image == null) {
                image = Toolkit.getDefaultToolkit().getImage(PsConfig.getCodeBase() + imageName);
            }
        }
        if (image == null) {
            PsDebug.warning("failed to load image = " + imageName);
        }
        return image;
    }

    public static Image getImage(URL url) {
        Image image = !PsConfig.isApplication() ? PsConfig.getApplet().getImage(url) : Toolkit.getDefaultToolkit().getImage(url);
        return image;
    }

    public void init() {
        this.m_tracker = this.m_parentComponent != null ? new MediaTracker(this.m_parentComponent) : new MediaTracker(PsConfig.getFrame());
        this.m_currentTrackerID = m_lastTrackerID++;
        this.m_tracker.addImage(this.m_image, this.m_currentTrackerID);
    }

    public void setParentComponent(Component comp) {
        this.m_parentComponent = comp;
    }

    public int getWidth() {
        return this.m_width;
    }

    public static Image createImageFromPixels(Component comp, int[] pixels, int width, int height, int offset, int scan) {
        Image image = comp.createImage(new MemoryImageSource(width, height, pixels, offset, scan));
        if (PsImage.loadImage(comp, image)) {
            return image;
        }
        return null;
    }
}

