/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgByuLoader
implements PgLoaderIf {
    protected boolean m_bIsAnimation = false;

    protected static boolean parse(BufferedReader bufReader, PgJvxSrc geom) throws IOException {
        boolean bTestNumber;
        int i;
        int numParts = 0;
        int numVertices = 0;
        int numElements = 0;
        int nConnEntries = 0;
        int nMagicNumber = 0;
        int intFormat = 0;
        int floatFormat = 0;
        StreamTokenizer st = new StreamTokenizer(bufReader);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.ordinaryChars(48, 48);
        st.ordinaryChars(49, 57);
        st.ordinaryChars(46, 46);
        st.ordinaryChars(32, 32);
        st.ordinaryChars(45, 45);
        st.ordinaryChars(43, 43);
        st.wordChars(48, 48);
        st.wordChars(49, 57);
        st.wordChars(46, 46);
        st.wordChars(32, 32);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.eolIsSignificant(true);
        st.nextToken();
        int ileng = st.sval.length();
        String line = st.sval;
        PsDebug.notify("(Debug): sval=*" + st.sval + "*" + "\n\t(Debug): line=*" + line + "*");
        int i2 = 0;
        intFormat = 9;
        while (intFormat > 4) {
            block43: {
                i2 = 5 * intFormat;
                PsDebug.notify("(Debug): ileng=" + ileng + ", intFormat=" + intFormat);
                if (i2 > ileng) break block43;
                PsDebug.notify("(Debug): ileng=" + ileng + ", intFormat=" + intFormat + ", char=" + line.charAt(i2 - 1));
                if (line.charAt(i2 - 1) == '0' || line.charAt(i2 - 1) == '8' || line.charAt(i2 - 1) == '5') {
                    i = i2 - intFormat;
                    while (i < i2) {
                        PsDebug.notify("(Debug): i=" + i + ", line.charAt(i)=" + line.charAt(i));
                        if (line.charAt(i) == ' ' || line.charAt(i) != '0') {
                            // empty if block
                        }
                        ++i;
                    }
                    i2 = -1;
                    PsDebug.notify("netscape format found = " + intFormat);
                    break;
                }
                if (i2 >= ileng) break block43;
                switch (line.charAt(i2)) {
                    case '0': {
                        break;
                    }
                    case '8': {
                        break;
                    }
                    case '5': {
                        break;
                    }
                    default: {
                        break block43;
                    }
                }
                i = i2 - intFormat + 1;
                while (i <= i2) {
                    if (line.charAt(i) == ' ' || line.charAt(i) != '0') {
                        // empty if block
                    }
                    ++i;
                }
                i2 = -1;
                PsDebug.notify("microsoft format found = " + intFormat);
                line = st.sval.substring(1, ileng);
                PsDebug.notify("(Debug): sval=*" + st.sval + "*" + "\n\t(Debug): line=*" + line + "*");
                --ileng;
                break;
            }
            --intFormat;
        }
        if (i2 != -1) {
            PsDebug.warning("Test Number != 0, trying format ...");
            bTestNumber = false;
            while ((line.charAt(--ileng) == ' ' || line.charAt(ileng) == '\n') && ileng >= 19) {
            }
            if (++ileng < 20 || ileng % 4 != 0) {
                PsDebug.warning("cannot determine number format from header\n\tdump of currently scanned string: " + line + "\n\tno meaningful format used in header, return");
                return false;
            }
            intFormat = ileng / 4;
            PsDebug.notify("format found = " + intFormat);
        } else {
            bTestNumber = true;
        }
        try {
            numParts = Integer.parseInt(line.substring(0, 1 * intFormat).trim());
            numVertices = Integer.parseInt(line.substring(1 * intFormat, 2 * intFormat).trim());
            numElements = Integer.parseInt(line.substring(2 * intFormat, 3 * intFormat).trim());
            nConnEntries = Integer.parseInt(line.substring(3 * intFormat, 4 * intFormat).trim());
            if (i2 == -1) {
                nMagicNumber = Integer.parseInt(line.substring(4 * intFormat, 5 * intFormat).trim());
                PsDebug.notify("Header = " + numParts + ' ' + numVertices + ' ' + numElements + ' ' + nConnEntries + ' ' + nMagicNumber);
            } else {
                PsDebug.notify("Header = " + numParts + ' ' + numVertices + ' ' + numElements + ' ' + nConnEntries);
            }
        }
        catch (NumberFormatException e) {
            PsDebug.warning("error in header\n\tdump of currently scanned string: " + line + "\n\tnumber format error in header");
            return false;
        }
        catch (StringIndexOutOfBoundsException se) {
            PsDebug.warning("error in part list\n\tdump of currently scanned string: " + line + "\n\tstring index out of bounds error in header");
            return false;
        }
        int[] part = new int[2 * numParts];
        int j = 0;
        i = 0;
        try {
            i = 0;
            while (i < 2 * numParts) {
                if (i % 8 == 0) {
                    j = 0;
                    st.nextToken();
                    st.nextToken();
                    line = st.sval;
                }
                part[i] = Integer.parseInt(line.substring(j * intFormat, (j + 1) * intFormat).trim());
                ++j;
                ++i;
            }
        }
        catch (NumberFormatException e) {
            PsDebug.warning("error in part list\n\tdump of currently scanned string: " + line.substring(j * intFormat, (j + 1) * intFormat) + "\n\tnumber format error in part list");
            return false;
        }
        catch (StringIndexOutOfBoundsException se) {
            PsDebug.warning("error in part list = " + i + "\n\tdump of currently scanned string: " + line + "\n\tstring index out of bounds error in part list");
            return false;
        }
        PsDebug.notify("parsing vertices ...");
        int dim = 3;
        geom.setDimOfVertices(dim);
        geom.setNumVertices(numVertices);
        PdVector[] vertex = geom.getVertices();
        int iBase = 0;
        floatFormat = 12;
        try {
            if (bTestNumber) {
                i = 0;
                while (i < numVertices) {
                    if (i % 2 == 0) {
                        iBase = 0;
                        st.nextToken();
                        st.nextToken();
                        line = st.sval;
                    }
                    j = 0;
                    while (j < dim) {
                        vertex[i].m_data[j] = Double.valueOf(line.substring(iBase, iBase + floatFormat).trim());
                        iBase += floatFormat;
                        ++j;
                    }
                    ++i;
                }
            } else {
                i = 0;
                j = 0;
                StreamTokenizer stStr = null;
                i = 0;
                while (i < numVertices) {
                    if (i % 2 == 0) {
                        iBase = 0;
                        st.nextToken();
                        st.nextToken();
                        line = st.sval;
                        stStr = new StreamTokenizer(new StringReader(line));
                        stStr.eolIsSignificant(true);
                        stStr.wordChars(65, 90);
                        stStr.wordChars(97, 122);
                        stStr.ordinaryChars(48, 48);
                        stStr.ordinaryChars(49, 57);
                        stStr.ordinaryChars(46, 46);
                        stStr.ordinaryChars(45, 45);
                        stStr.ordinaryChars(43, 43);
                        stStr.wordChars(48, 48);
                        stStr.wordChars(49, 57);
                        stStr.wordChars(46, 46);
                        stStr.wordChars(45, 45);
                        stStr.wordChars(43, 43);
                        stStr.ordinaryChars(47, 47);
                        stStr.commentChar(35);
                    }
                    j = 0;
                    while (j < dim) {
                        stStr.nextToken();
                        vertex[i].m_data[j] = Double.valueOf(stStr.sval.trim());
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (NumberFormatException e) {
            PsDebug.warning("error at vertex = " + i + "\n\tdump of currently scanned string: " + line.substring(iBase, iBase + floatFormat) + "\n\tnumber format error in vertex list");
            return false;
        }
        catch (StringIndexOutOfBoundsException se) {
            PsDebug.warning("error at vertex = " + i + "\n\tvertex-line = " + i / 2 + "\n\tdump of currently scanned string: " + line + "\n\tstring index out of bounds error in vertex list");
            return false;
        }
        PsDebug.notify("parsing connectivity ...");
        geom.setDimOfElements(-1);
        geom.setNumElements(numElements);
        PiVector[] element = geom.getElements();
        intFormat = 6;
        int elemCnt = 0;
        int vertCnt = 0;
        int maxVert = 100;
        int[] storeFace = new int[maxVert];
        try {
            i = 0;
            while (i < nConnEntries) {
                if (i % 16 == 0) {
                    iBase = 0;
                    st.nextToken();
                    st.nextToken();
                    line = st.sval;
                }
                int connEntry = Integer.parseInt(line.substring(iBase, iBase + intFormat).trim());
                iBase += intFormat;
                if (connEntry > 0) {
                    storeFace[vertCnt++] = connEntry - 1;
                } else {
                    storeFace[vertCnt++] = -connEntry - 1;
                    element[elemCnt].setSize(vertCnt);
                    element[elemCnt].copy(storeFace, vertCnt);
                    ++elemCnt;
                    vertCnt = 0;
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            PsDebug.warning("error at connectivity entry = " + i + "\n\tdump of currently scanned string: " + line.substring(iBase, iBase + intFormat) + "\n\tnumber format error in conncetivity list");
            return false;
        }
        catch (StringIndexOutOfBoundsException se) {
            PsDebug.warning("error at connectivity entry = " + i + "\n\tconn-line = " + i / 16 + "\n\tdump of currently scanned string: " + line + "\n\tstring index out of bounds error in conncetivity list");
            return false;
        }
        PsDebug.notify("... finished");
        return true;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        PgJvxSrc geom = new PgJvxSrc();
        geom.setType(33);
        try {
            boolean check = PgByuLoader.parse(in, geom);
            if (!check) {
                PsDebug.warning("error during parsing of reader");
                return null;
            }
        }
        catch (IOException e) {
            PsDebug.warning("error when during parsing of reader");
            e.printStackTrace();
            return null;
        }
        PgByuLoader.geomInitType(geom);
        return new PgJvxSrc[]{geom};
    }

    public static PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open(fileName);
        if (in == null) {
            PsDebug.warning("could not open = " + fileName);
            return null;
        }
        PgByuLoader loader = new PgByuLoader();
        PgJvxSrc[] geomArr = loader.read(in);
        if (geomArr != null && geomArr.length > 0 && geomArr[0] != null) {
            geomArr[0].setName(PsUtil.getFileBaseName(fileName));
        }
        try {
            in.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption option) {
    }

    public void setAnimation(boolean flag) {
        this.m_bIsAnimation = flag;
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        int numOfVertices = geom.getNumVertices();
        int numOfElements = geom.getNumElements();
        PiVector[] element = geom.getElements();
        int numElemEntries = 0;
        int i = 0;
        while (i < numOfElements) {
            numElemEntries += element[i].getSize();
            ++i;
        }
        writer.write(PuString.intToString(1, 6) + PuString.intToString(numOfVertices, 6) + PuString.intToString(numOfElements, 6) + PuString.intToString(numElemEntries, 6) + PuString.intToString(0, 6) + "\n" + PuString.intToString(1, 6) + PuString.intToString(numOfElements, 6) + "\n");
        int count = 0;
        PdVector[] vertex = geom.getVertices();
        int i2 = 0;
        while (i2 < numOfVertices) {
            if (vertex[i2] != null) {
                int j = 0;
                while (j < vertex[i2].m_data.length) {
                    writer.write(PuString.doubleToString(vertex[i2].m_data[j], 5));
                    if (count == 5) {
                        count = 0;
                        writer.write("\n");
                    } else {
                        ++count;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (count != 0) {
            writer.write("\n");
        }
        count = 0;
        int num = 0;
        int i3 = 0;
        while (i3 < numOfElements) {
            if (element[i3] != null) {
                int j = 0;
                while (j < element[i3].m_data.length) {
                    int vertexInd = element[i3].m_data[j] + 1;
                    if (j == element[i3].m_data.length - 1) {
                        writer.write(PuString.intToString(-vertexInd, 6));
                    } else {
                        writer.write(PuString.intToString(vertexInd, 6));
                    }
                    ++num;
                    if (count == 15) {
                        count = 0;
                        writer.write("\n");
                    } else {
                        ++count;
                    }
                    ++j;
                }
            }
            ++i3;
        }
        if (count != 0) {
            writer.write("\n");
        }
        return true;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static void geomInitType(PgJvxSrc geom) {
        switch (geom.getType()) {
            case 30: {
                geom.showVertices(true);
                break;
            }
            case 33: {
                geom.assureNeighbours();
                geom.showEdges(true);
                geom.showElements(true);
                break;
            }
            case 32: {
                geom.showVertices(true);
                geom.showPolygons(true);
                geom.showEdges(true);
                break;
            }
        }
    }
}

