/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SolitaryPoint
extends JPanel {
    Project project;
    public int solPtNo = 0;
    public JCheckBox cbox = new JCheckBox("", false);
    public JLabel nameLabel = null;
    double oldX = 0.0;
    double oldY = 0.0;
    double oldZ = 0.0;
    double newX = 0.0;
    double newY = 0.0;
    double newZ = 0.0;
    public JTextField x = new JTextField("0.00000");
    public JTextField y = new JTextField("0.00000");
    public JTextField z = new JTextField("0.00000");
    JLabel xLabel = new JLabel("x:");
    JLabel yLabel = new JLabel("y:");
    JLabel zLabel = new JLabel("z:");
    double oldFrom = 0.0;
    double oldTo = 5.0;
    double newFrom = this.oldFrom;
    double newTo = this.oldTo;
    public double radius;
    public double oldRadius = this.radius = 0.25;
    public JSlider radiusSlider = null;
    public JLabel radiusLabel = new JLabel("" + this.radius);
    public JComboBox surfaces;

    SolitaryPoint(Project project) {
        this.project = project;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        this.surfaces = new JComboBox(this.project.eqAdm.getEqNrs());
        this.nameLabel = new JLabel("s" + this.solPtNo);
        jPanel.add(this.nameLabel);
        jPanel.add(this.surfaces);
        this.radiusSlider = new JSlider(0, 1000);
        this.radiusSlider.setValue((int)Math.round(this.radius * 1000.0 / (this.newTo - this.newFrom)));
        this.radiusSlider.setMinorTickSpacing(1);
        this.radiusSlider.setMajorTickSpacing(10);
        this.radiusSlider.setPaintTicks(true);
        this.radiusSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SolitaryPoint.this.updateradiusSliderLabel();
            }
        });
        jPanel.add(new JLabel("   "));
        this.x.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(SolitaryPoint.this.x.getText());
                    SolitaryPoint.this.oldX = d = (double)Math.round(d * 1000.0) / 1000.0;
                    SolitaryPoint.this.newX = d;
                    SolitaryPoint.this.updateradiusSliderLabel();
                }
                catch (Exception exception) {
                    SolitaryPoint.this.x.setText("" + SolitaryPoint.this.oldX);
                }
            }
        });
        jPanel.add(this.xLabel);
        jPanel.add(this.x);
        this.y.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(SolitaryPoint.this.y.getText());
                    SolitaryPoint.this.oldY = d = (double)Math.round(d * 1000.0) / 1000.0;
                    SolitaryPoint.this.newY = d;
                    SolitaryPoint.this.updateradiusSliderLabel();
                }
                catch (Exception exception) {
                    SolitaryPoint.this.y.setText("" + SolitaryPoint.this.oldY);
                }
            }
        });
        jPanel.add(this.yLabel);
        jPanel.add(this.y);
        this.z.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(SolitaryPoint.this.z.getText());
                    SolitaryPoint.this.oldZ = d = (double)Math.round(d * 1000.0) / 1000.0;
                    SolitaryPoint.this.newZ = d;
                    SolitaryPoint.this.updateradiusSliderLabel();
                }
                catch (Exception exception) {
                    SolitaryPoint.this.z.setText("" + SolitaryPoint.this.oldZ);
                }
            }
        });
        jPanel.add(this.zLabel);
        jPanel.add(this.z);
        jPanel.add(this.radiusSlider);
        jPanel.add(this.radiusLabel);
        this.add((Component)jPanel, "West");
    }

    public void updateradiusSliderLabel() {
        int n = 6;
        String string = "" + (this.newFrom + (double)this.radiusSlider.getValue() / 1000.0 * (this.newTo - this.newFrom));
        if (string.length() <= 6) {
            n = string.length();
        }
        this.radiusLabel.setText(string.substring(0, n));
        this.project.solPtsAdm.copyRadiusToAll(this.newFrom, this.newTo, this.newFrom + (double)this.radiusSlider.getValue() / 1000.0 * (this.newTo - this.newFrom));
        this.repaint();
    }

    public boolean isSelected() {
        return this.cbox.isSelected();
    }

    public void setSurfNo(int n) {
        this.surfaces.setSelectedIndex(n);
    }

    public String getSurfNo() {
        return this.surfaces.getSelectedItem().toString();
    }

    public void setSolPtNo(int n) {
        this.solPtNo = n;
        this.nameLabel.setText("s" + this.solPtNo);
    }

    public void updateActionCommands(int n) {
    }

    public String getName() {
        return this.nameLabel.getText();
    }

    public String getSurfCode() {
        String string = "poly " + this.nameLabel.getText() + " = " + "(x-(" + this.x.getText() + "))^2" + "+(y-(" + this.y.getText() + "))^2" + "+(z-(" + this.z.getText() + "))^2" + "-(" + this.radiusLabel.getText() + ")^2;\n";
        return string;
    }

    public void saveYourself(PrintWriter printWriter) {
        String string = "";
        printWriter.println("////////////////// SolitaryPoint: /////////////////////////\n");
        printWriter.println("" + this.solPtNo + "\n");
        printWriter.println("" + this.getSurfNo() + "\n");
        printWriter.println("" + this.x.getText() + "\n");
        printWriter.println("" + this.y.getText() + "\n");
        printWriter.println("" + this.z.getText() + "\n");
        printWriter.println("" + this.newFrom + "\n");
        printWriter.println("" + this.newTo + "\n");
        printWriter.println("" + this.radiusSlider.getValue() + "\n");
    }

    public String saveYourself() {
        String string = "";
        string = string + "////////////////// SolitaryPoint: /////////////////////////\n";
        string = string + "" + this.solPtNo + "\n";
        string = string + "" + this.getSurfNo() + "\n";
        string = string + "" + this.x.getText() + "\n";
        string = string + "" + this.y.getText() + "\n";
        string = string + "" + this.z.getText() + "\n";
        string = string + "" + this.newFrom + "\n";
        string = string + "" + this.newTo + "\n";
        string = string + "" + this.radiusSlider.getValue() + "\n";
        return string;
    }
}

