;;
;; Set up the menu
;;

(add_menu "File")

(add_menu_entry "File" "New ^N" "(new_buffer)")
(add_menu_entry "File" "Open" "(load_buffer)")
(add_menu_entry "File" "Save" "(save_buffer)")
(add_menu_entry "File" "Save As" "(save_buffer_as)")
(add_menu_entry "File" "Preview" "(preview)")
(add_menu_entry "File" "Close" "(kill_buffer 1)")
(add_menu_entry "File" "-" "-")
(add_submenu "File" "Backup Copies")
(add_submenu_entry "File" "Backup Copies" "Yes" "(make_backups 1)")
(add_submenu_entry "File" "Backup Copies" "No" "(make_backups 0)")
(add_submenu "File" "Settings")
(add_submenu_entry "File" "Settings" "Margins" "(change_margins nil)")
(add_submenu_entry "File" "Settings" "Paper Size" "(change_paper_size nil)")
(add_submenu_entry "File" "Settings" "Header and Footer" "(change_headfoot nil)")
(add_menu_entry "File" "-" "-")
(add_menu_entry "File" "Print" "(print)")
(add_menu_entry "File" "Print Format" "(print_format)")
;(add_submenu "File" "Orientation")
;(add_submenu_entry "File" "Orientation" "Portrait"
;		   "(put_property nil \"ps_orientation\" \"portrait\")")
;(add_submenu_entry "File" "Orientation" "Landscape"
;		   "(put_property nil \"ps_orientation\" \"landscape\")")
;(add_submenu "File" "Cell Protection")
;(add_submenu_entry "File" "Cell Protection" "Respect"
;		   "(put_property nil \"ps_protection\" \"yes\")")
;(add_submenu_entry "File" "Cell Protection" "Ignore"
;		   "(put_property nil \"ps_protection\" \"no\")")
(add_menu_entry "File" "-" "-")
(add_menu_entry "File" "Load External" "(load_external)")
(add_menu_entry "File" "Save External" "(save_external)")
(add_menu_entry "File" "-" "-")
(add_menu_entry "File" "Exit" "(quit_program)")

(add_menu "Edit")
(add_menu_entry "Edit" "Undo" "(undo_restore)")
(add_menu_entry "Edit" "-" "-")
(add_menu_entry "Edit" "Cut" "(cut_to_clipboard)")
(add_menu_entry "Edit" "Copy" "(copy_to_clipboard)")
(add_menu_entry "Edit" "Paste" "(paste_from_clipboard)")
(add_menu_entry "Edit" "-" "-")
(add_menu_entry "Edit" "Delete" "(delete_cell)")
(add_menu_entry "Edit" "Insert Line" "(insert_line)")
(add_menu_entry "Edit" "Remove Line" "(remove_line)")
(add_menu_entry "Edit" "Insert Column" "(insert_col)")
(add_menu_entry "Edit" "Remove Column" "(remove_col)")
(add_menu_entry "Edit" "Select All" "(select_all)")
(add_menu_entry "Edit" "-" "-")
(add_menu_entry "Edit" "Find" "(search_forward)")
(add_menu_entry "Edit" "Find Backward" "(search_backward)")
(add_menu_entry "Edit" "-" "-")
(add_menu_entry "Edit" "Label" "(edit_label)")
;;(add_menu_entry "Edit" "Expression" "(edit_expression)")
(add_menu_entry "Edit" "-" "-")
(add_submenu "Edit" "Expression")
(add_submenu_entry "Edit" "Expression" "C" "(edit_c)")
(add_submenu_entry "Edit" "Expression" "SIOD" "(edit_siod)")
(add_submenu_entry "Edit" "Expression" "Guile" "(edit_guile)")
(add_submenu_entry "Edit" "Expression" "Python" "(edit_python)")
(add_submenu_entry "Edit" "Expression" "Ruby" "(edit_ruby)")
(add_submenu_entry "Edit" "Expression" "Tcl" "(edit_tcl)")
(add_submenu "Edit" "Change Default Interpreter")
(add_submenu_entry "Edit" "Change Default Interpreter" "C" "(define *standard-interpreter* 'C)")
(add_submenu_entry "Edit" "Change Default Interpreter" "SIOD" "(define *standard-interpreter* 'SIOD)")
(add_submenu_entry "Edit" "Change Default Interpreter" "Guile" "(define *standard-interpreter* 'Guile)")
(add_submenu_entry "Edit" "Change Default Interpreter" "Python" "(define *standard-interpreter* 'Python)")
(add_submenu_entry "Edit" "Change Default Interpreter" "Ruby" "(define *standard-interpreter* 'Ruby)")
(add_submenu_entry "Edit" "Change Default Interpreter" "Tcl" "(define *standard-interpreter* 'Tcl)")
(add_submenu_entry "Edit" "Change Default Interpreter" "Other" "(change_interpreter)")
;(add_menu_entry "Edit" "Change default interpreter" "(change_interpreter)")
;; Not yet operational
;(add_menu_entry "Edit" "Enter Date" "(enter_date)")
;(add_menu_entry "Edit" "Enter Time" "(enter_time)")


(add_menu_entry "Edit" "-" "-")
(add_menu_entry "Edit" "Add Property" "(add_property)")
; Deprecated
;(add_menu-entry "Edit" "-" "-")
;(add_menu_entry "Edit" "Embed Object" "(embed_object)")
;(add_menu_entry "Edit" "Remove Object" "(embed_remove)")
;(add_menu_entry "Edit" "Open Object" "(embed_open)")
;(add_menu_entry "Edit" "Save Object" "(embed_save)")

(add_menu "Block")
(add_menu_entry "Block" "Set Mark" "(set_mark_command)")
(add_menu_entry "Block" "Set Block" "(set_block)")
(add_menu_entry "Block" "Unset Block" "(unset_block)")
(add_menu_entry "Block" "Copy Block" "(copy_block)")
(add_menu_entry "Block" "Delete Block" "(delete_block)")
(add_menu_entry "Block" "Fill Block" "(fill_block)")
(add_menu_entry "Block" "Smart Fill Block" "(smart_fill_block)")
(add_submenu "Block" "Sort")
(add_submenu_entry "Block" "Sort" "Rows Ascending as Text" "(sort_block 0 nil nil nil)")
(add_submenu_entry "Block" "Sort" "Rows Ascending as Numbers" "(sort_block 0 nil nil t)")
(add_submenu_entry "Block" "Sort" "Rows Descending as Text" "(sort_block 0 nil t nil)")
(add_submenu_entry "Block" "Sort" "Rows Descending as Numbers" "(sort_block 0 nil t t)")
(add_submenu_entry "Block" "Sort" "-" "-")
(add_submenu_entry "Block" "Sort" "Columns Ascending as Text" "(sort_block 0 t nil nil)")
(add_submenu_entry "Block" "Sort" "Columns Ascending as Numbers" "(sort_block 0 t nil t)")
(add_submenu_entry "Block" "Sort" "Columns Descending as Text" "(sort_block 0 t t nil)")
(add_submenu_entry "Block" "Sort" "Columns Descending as Numbers" "(sort_block 0 t t t)")

(add_menu_entry "Block" "-" "-")
(add_menu_entry "Block" "Block Sum" "(block_sum)")
(add_menu_entry "Block" "Block Minimum" "(block_min)")
(add_menu_entry "Block" "Block Maximum" "(block_max)")
(add_menu_entry "Block" "Block Average" "(block_avg)")
(add_menu_entry "Block" "-" "-")
(add_submenu "Block" "Borders")
(add_submenu_entry "Block" "Borders" "Borders" "(block_borders 1)")
(add_submenu_entry "Block" "Borders" "Grid" "(block_borders 2)")
(add_submenu_entry "Block" "Borders" "Underline" "(block_borders 3)")
(add_submenu_entry "Block" "Borders" "Top" "(block_borders 4)")
(add_submenu_entry "Block" "Borders" "Left" "(block_borders 5)")
(add_submenu_entry "Block" "Borders" "Right" "(block_borders 6)")
(add_submenu_entry "Block" "Borders" "None" "(block_borders 0)")

(add_menu "Format")
(add_menu_entry "Format" "Margins" "(change_margins \"\")")
(add_menu_entry "Format" "Paper Size" "(change_paper_size \"\")")
(add_menu_entry "Format" "Header and Footer" "(change_headfoot \"\")")
(add_menu_entry "Format" "First Page Number" "(change_first_page \"\")")
(add_submenu "Format" "Column Width")
(add_submenu_entry "Format" "Column Width" "Set" "(set_cell_width)")
(add_submenu_entry "Format" "Column Width" "Fit Block" "(fit_block_width)")
(add_submenu_entry "Format" "Column Width" "Set Default" "(set_standard_width)")
(add_submenu "Format" "Row Height")
(add_submenu_entry "Format" "Row Height" "Set" "(set_cell_height)")
(add_submenu_entry "Format" "Row Height" "Fit Block" "(fit_block_height)")
(add_submenu_entry "Format" "Row Height" "Set Default" "(set_standard_height)")
;(add_menu_entry "Format" "Column Width" "(set_cell_width)")
;(add_menu_entry "Format" "Fit Block Width" "(fit_block_width)")
;(add_menu_entry "Format" "Set Default Width" "(set_standard_width)")
;(add_menu_entry "Format" "Row Height" "(set_cell_height)")
;(add_menu_entry "Format" "Fit Block Height" "(fit_block_height)")
;(add_menu_entry "Format" "Set Default Height" "(set_standard_height)")
(add_menu_entry "Format" "-" "-")
(add_menu_entry "Format" "Set Default Format" "(set_standard_format)")
; This no longer works, because the font selector box has been taken out.
; There should not be separate items for cell and block, but rather the
; block should be handled if point is inside it. So just a Format item.
;(add_menu_entry "Format" "Cell Format" "(set_cell_format)")
;(add_menu_entry "Format" "Block Format" "(set_block_format)")
(add_menu_entry "Format" "Font" "(new_attribute \"family\")")
(add_menu_entry "Format" "-" "-")
; Same here: don't use separate items for cell and block
;(add_menu_entry "Format" "Cell Style" "(set_cell_style)")
;(add_menu_entry "Format" "Block Style" "(set_block_style)")
(add_menu_entry "Format" "Style" "(new_attribute \"style\")")
(add_menu_entry "Format" "Define Style" "(define_style)")
(add_menu_entry "Format" "-" "-")
; Again the same. Also, these don't work.
; There should be one item to change the foreground and one to change
; the background.
(add_menu_entry "Format" "Foreground Color" "(new_attribute \"fg\")")
(add_menu_entry "Format" "Background Color" "(new_attribute \"bg\")")
;(add_menu_entry "Format" "Cell Color" "(cell_color)")
;(add_menu_entry "Format" "Block Color" "(block_color)")

(add_menu "Data")
(add_menu_entry "Data" "Edit Record" "(data_record_edit (position_row (get_point)))")
(add_menu_entry "Data" "Data Entry" "(data_entry)")
(define (siag_net p)
  (require (string-append datadir "/siag/siag-net.scm"))
  (siag_net p))
(add_menu_entry "Data" "Siag-net" "(siag_net 8080)")
(add_menu_entry "Data" "-" "-")
(add_menu_entry "Data" "Enter Date" "(enter_date)")
(add_menu_entry "Data" "Enter Time" "(enter_time)")
(add_menu_entry "Data" "-" "-")
(add_menu_entry "Data" "Identify Cell" "(what_cursor_position)")
(add_menu_entry "Data" "Recalculate" "(recalc_matrix)")

(add_menu "Window")
(add_menu_entry "Window" "Zoom" "(zoom_adjust)")
(add_menu_entry "Window" "Change Buffer" "(switch_to_buffer)")
(add_menu_entry "Window" "Delete Buffer" "(kill_buffer 1)")
(add_menu_entry "Window" "-" "-")
(add_menu_entry "Window" "Split Window" "(split_window_vertically)")
(add_menu_entry "Window" "Remove Window" "(delete_window)")
(add_menu_entry "Window" "One Window" "(delete_other_windows)")
(add_menu_entry "Window" "Change Window" "(other_window)")
(add_menu_entry "Window" "-" "-")
(add_menu_entry "Window" "Add Sheet" "(add_sheet)")
(add_menu_entry "Window" "Remove Sheet" "(remove_sheet)")
(add_menu_entry "Window" "Rename Sheet" "(rename_sheet)")
(add_submenu "Window" "Move Sheet")
(add_submenu_entry "Window" "Move Sheet" "Up" "(move_sheet_up)")
(add_submenu_entry "Window" "Move Sheet" "Down" "(move_sheet_down)")
(add_submenu_entry "Window" "Move Sheet" "Top" "(move_sheet_top)")
(add_submenu_entry "Window" "Move Sheet" "Bottom" "(move_sheet_bottom)")

(add_menu_entry "Window" "-" "-")
(add_menu_entry "Window" "Protect Cells" "(protect_cells)")
(add_menu_entry "Window" "Remove Protection" "(remove_protection)")
(add_submenu "Window" "Go To")
(add_submenu_entry "Window" "Go To" "Beginning of buffer" "(beginning_of_buffer)")
(add_submenu_entry "Window" "Go To" "End of buffer" "(end_of_buffer)")
(add_submenu_entry "Window" "Go To" "Top of buffer" "(top_of_buffer)")
(add_submenu_entry "Window" "Go To" "Bottom of buffer" "(bottom_of_buffer)")
(add_submenu_entry "Window" "Go To" "Cell" "(go_to)")

;(define *grid-lines* 1)
;(add_menu_entry "Window" "Grid Lines" "(grid_lines (set! *grid-lines* (- 1 *grid-lines*)))")
;(add_menu_entry "Window" "Disable Helptexts" "(tooltip-mode 0)")
(add_submenu "Window" "Grid Lines")
(add_submenu_entry "Window" "Grid Lines" "Show" "(grid_lines 1)")
(add_submenu_entry "Window" "Grid Lines" "Hide" "(grid_lines 0)")
(add_submenu "Window" "Reference Style")
(add_submenu_entry "Window" "Reference Style" "R1C1" "(a1_refs_set 0)")
(add_submenu_entry "Window" "Reference Style" "A1" "(a1_refs_set 1)")
(add_submenu "Window" "Theme")
(add_submenu_entry "Window" "Theme" "Select" "(select_theme)")
(add_submenu_entry "Window" "Theme" "Edit" "(edit_theme)")
(add_submenu_entry "Window" "Theme" "None" "(delete_theme)")

(define (tooltip_set m)
  (set! *tooltip-mode* m)
  (tooltip_mode m))
(add_submenu "Window" "Helptexts")
(add_submenu_entry "Window" "Helptexts" "Disable" "(tooltip_set 0)")
(add_submenu_entry "Window" "Helptexts" "Label" "(tooltip_set 1)")
(add_submenu_entry "Window" "Helptexts" "Popup" "(tooltip_set 2)")
(add_submenu_entry "Window" "Helptexts" "Both" "(tooltip_set 3)")
(add_menu_entry "Window" "Save Preferences" "(save_preferences)")

(add_menu "Plot")
;(add_menu_entry "Plot" "Lines" "(plot \"lines\")")
;(add_menu_entry "Plot" "Points" "(plot \"points\")")
;(add_menu_entry "Plot" "Linespoints" "(plot \"linespoints\")")
;(add_menu_entry "Plot" "Impulses" "(plot \"impulses\")")
;(add_menu_entry "Plot" "Dots" "(plot \"dots\")")
;(add_menu_entry "Plot" "Steps" "(plot \"steps\")")
;(add_menu_entry "Plot" "Boxes" "(plot \"boxes\")")
;(add_menu_entry "Plot" "-" "-")
;(add_submenu "Plot" "Orientation")
;(add_submenu_entry "Plot" "Orientation" "Horizontal" "(define plot hplot)")
;(add_submenu_entry "Plot" "Orientation" "Vertical" "(define plot vplot)")
;(add_menu_entry "Plot" "-" "-")
(add_menu_entry "Plot" "Plugin" "(plot_plugin \"lines\")")
(add_menu_entry "Plot" "Surface" "(splot \"lines\")")
(add_menu_entry "Plot" "Wizard" "(plot_wizard)")

(add_menu "Tools")

(require (string-append datadir "/common/tools.scm"))

(add_submenu "Tools" "Applets")

; Add the web server to the menu
(define (webserver)
  (require (string_append datadir "/siag/siag-http.scm"))
  (siag_http 8080))

(add_submenu_entry "Tools" "Applets" "Webserver" "(webserver)")

; Add the mailer
(define (mailto)
  (require (string-append datadir "/siag/mailto.scm"))
  (mailto))

(add_submenu_entry "Tools" "Applets" "Mail" "(mailto)")

; The file manager
(define (filemgr)
  (require (string-append datadir "/siag/filemgr.scm"))
  (read-directory))

(add_submenu_entry "Tools" "Applets" "File Manager" "(filemgr)")

(add_submenu "Tools" "Form Test")
(add_submenu_entry "Tools" "Form Test" "Test 1" "(form_test)")
(add_submenu_entry "Tools" "Form Test" "Test 2" "(form_test2)")
(add_submenu_entry "Tools" "Form Test" "Test 3" "(form_test3)")
;(add_submenu_entry "Tools" "Form Test" "Test 4" "(form_test4)")

(add_menu "Plugin")
(add_menu_entry "Plugin" "Import" "(plugin_import nil)")
(add_menu_entry "Plugin" "Export" "(plugin_export)")
(add_menu_entry "Plugin" "Link" "(plugin_link nil)")
(add_menu_entry "Plugin" "Delete" "(plugin_delete)")
(add_menu_entry "Plugin" "Move" "(plugin_move)")
(add_menu_entry "Plugin" "Resize" "(plugin_resize)")
(add_menu_entry "Plugin" "-" "-")
(add_submenu "Plugin" "App")
(add_submenu_entry "Plugin" "App" "Xclock" "(plugin_import \"xclock.run\")")
(add_submenu_entry "Plugin" "App" "Xterm" "(plugin_import \"xterm.run\")")
(add_submenu_entry "Plugin" "App" "Xload" "(plugin_import \"xload.run\")")
(add_submenu_entry "Plugin" "App" "Siag" "(plugin_import \"PLuGiN.siag\")")
(add_submenu_entry "Plugin" "App" "PW" "(plugin_import \"PLuGiN.pw\")")
(add_submenu_entry "Plugin" "App" "Hello World" "(plugin_import \"x.hello\")")

(add_menu "Help")
(add_menu_entry "Help" "Contents" "(help_contents)")
;(add_menu_entry "Help" "Search" "(help_search)")
(add_menu_entry "Help" "Copying" "(help_copyright)")
(add_menu_entry "Help" "Help for Help" "(help_for_help)")

(add_submenu "Help" "Links")

(define (help_link name url)
  (add_submenu_entry "Help"
		     "Links"
		     name
		     (string-append "(do_link \"" url "\")")))

(help_link "Siag Home" "http://siag.nu/")
(help_link "FTP Directory" "ftp://siag.nu/pub/siag/")

(add_menu_entry "Help" "-" "-")
;(add_menu_entry "Help" "About Siag" "(print_version)")
(add_menu_entry "Help" "About Siag..." "(aboutbox)")
(add_menu_entry "Help" "About Siag Office..." "(aboutsiag)")

(add_pseudo_menu "Shortcuts")

;(add_menu_entry "Shortcuts" "Unset Block" "(unset_block)")
(add_menu_entry "Shortcuts" "Open" "(load_buffer)")
(add_menu_entry "Shortcuts" "Save" "(save_buffer_as)")
(add_menu_entry "Shortcuts" "-" "-")
(add_menu_entry "Shortcuts" "Undo" "(undo_restore)")
(add_menu_entry "Shortcuts" "Delete" "(delete_cell)")
(add_menu_entry "Shortcuts" "Label" "(edit_label)")
(add_submenu "Shortcuts" "Expression")
(add_submenu_entry "Shortcuts" "Expression" "C" "(edit_c)")
(add_submenu_entry "Shortcuts" "Expression" "SIOD" "(edit_siod)")
(add_submenu_entry "Shortcuts" "Expression" "Guile" "(edit_guile)")
(add_submenu_entry "Shortcuts" "Expression" "Python" "(edit_python)")
(add_submenu_entry "Shortcuts" "Expression" "Ruby" "(edit_ruby)")
(add_submenu_entry "Shortcuts" "Expression" "Tcl" "(edit_tcl)")
;(add_menu_entry "Shortcuts" "Expression" "(edit_expression)")
(add_menu_entry "Shortcuts" "Command" "(exec_siod)")
(add_menu_entry "Shortcuts" "Sum" "(block_sum)")
(add_menu_entry "Shortcuts" "-" "-")
(add_submenu "Shortcuts" "Plugin")
(add_submenu_entry "Shortcuts" "Plugin" "Import" "(plugin_import)")
(add_submenu_entry "Shortcuts" "Plugin" "Export" "(plugin_export)")
(add_submenu_entry "Shortcuts" "Plugin" "Link" "(plugin_link)")
(add_submenu_entry "Shortcuts" "Plugin" "Delete" "(plugin_delete)")
(add_submenu_entry "Shortcuts" "Plugin" "Move" "(plugin_move)")
;(add_menu_entry "Shortcuts" "Import Plugin" "(plugin_import)")
;(add_menu_entry "Shortcuts" "Move Plugin" "(plugin_move)")
(add_menu_entry "Shortcuts" "Help" "(help_contents)")
(add_menu_entry "Shortcuts" "-" "-")
(add_menu_entry "Shortcuts" "Quit" "(quit_program)")

