/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCodeAttribute;
import ch.epfl.lamp.fjbg.JLineNumberTableAttribute;
import ch.epfl.lamp.fjbg.JOtherAttribute;
import ch.epfl.lamp.fjbg.JSourceFileAttribute;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class JAttributeFactory {
    protected FJBGContext context;
    protected HashMap constructors = new HashMap();
    protected static final Class[] CONSTRUCTOR_ARGS = new Class[]{FJBGContext.class, JClass.class, Object.class, String.class, Integer.TYPE, DataInputStream.class};
    protected static final Constructor defaultDefaultConstructor;
    protected final Constructor defaultConstructor;

    public JAttributeFactory(FJBGContext context, Constructor defaultConstructor) {
        this.context = context;
        this.defaultConstructor = defaultConstructor;
        this.registerClass("Code", JCodeAttribute.class);
        this.registerClass("LineNumberTable", JLineNumberTableAttribute.class);
        this.registerClass("SourceFile", JSourceFileAttribute.class);
    }

    public JAttributeFactory(FJBGContext context) {
        this(context, defaultDefaultConstructor);
    }

    public void registerClass(String attributeName, Class clazz) {
        if (!JAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a subclass of JAttribute: " + clazz);
        }
        try {
            Constructor constr = clazz.getConstructor(CONSTRUCTOR_ARGS);
            this.constructors.put(attributeName, constr);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No appropriate constructor for " + clazz);
        }
    }

    public JAttribute newInstance(JClass clazz, Object owner, DataInputStream stream) throws IOException {
        String name = clazz.getConstantPool().lookupUtf8(stream.readShort());
        Integer size2 = new Integer(stream.readInt());
        Constructor constr = (Constructor)this.constructors.get(name);
        if (constr == null) {
            constr = this.defaultConstructor;
        }
        Object[] args2 = new Object[]{this.context, clazz, owner, name, size2, stream};
        try {
            return (JAttribute)constr.newInstance(args2);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            defaultDefaultConstructor = JOtherAttribute.class.getConstructor(CONSTRUCTOR_ARGS);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

