/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.DependencyError;
import sbaz.Filename;
import sbaz.InstalledEntry;
import sbaz.InstalledList;
import sbaz.ManagedDirectory$;
import sbaz.Package;
import sbaz.ProposedChanges;
import sbaz.Universe;
import sbaz.Universe$;
import sbaz.download.Download;
import sbaz.download.Downloader;
import sbaz.download.Downloader$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Node;
import scala.xml.XML$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedDirectory
implements ScalaObject {
    private final File directory;
    private final File lib_dir;
    private final File meta_dir;
    private final File misc_dir;
    private final FileLock lock;
    private final Downloader downloader;
    private AvailableList available;
    private final InstalledList installed;
    private Universe universe;
    private final boolean sbaz$ManagedDirectory$$isWin;
    private final File scala_bazaars_jar;
    private final File sbaz_jar;
    private final File scala_lib_jar;

    public File directory() {
        return this.directory;
    }

    private File lib_dir() {
        return this.lib_dir;
    }

    private File meta_dir() {
        return this.meta_dir;
    }

    private File misc_dir() {
        return this.misc_dir;
    }

    public FileLock lock() {
        return this.lock;
    }

    private Downloader downloader() {
        return this.downloader;
    }

    private void renameFile(File from, File to) {
        to.delete();
        from.renameTo(to);
    }

    private <T> T loadXML(String filename, Function1<Node, T> decoder, T t) {
        File file = new File(this.meta_dir(), filename);
        return file.exists() ? decoder.apply((Node)XML$.MODULE$.load(file.getAbsolutePath())) : t;
    }

    private void saveXML(Node xml, String filename) {
        File tmpFile = new File(this.meta_dir(), new StringBuilder().append((Object)filename).append((Object)".tmp").toString());
        FileWriter str = new FileWriter(tmpFile);
        str.write(xml.toString());
        str.close();
        this.renameFile(tmpFile, new File(this.meta_dir(), filename));
    }

    public AvailableList available() {
        return this.available;
    }

    public void available_$eq(AvailableList availableList) {
        this.available = availableList;
    }

    private void saveAvailable() {
        this.saveXML(this.available().toXML(), "available");
    }

    public InstalledList installed() {
        return this.installed;
    }

    private void saveInstalled() {
        this.saveXML(this.installed().toXML(), "installed");
    }

    public Universe universe() {
        return this.universe;
    }

    public void universe_$eq(Universe universe) {
        this.universe = universe;
    }

    private void saveUniverse() {
        this.saveXML(this.universe().toXML(), "universe");
    }

    private boolean clearAvailable() {
        this.available_$eq(new AvailableList(Nil$.MODULE$));
        return new File(this.meta_dir(), "available").delete();
    }

    public void setUniverse(Universe newUniverse) {
        this.clearAvailable();
        this.universe_$eq(newUniverse);
        this.saveUniverse();
    }

    public final Filename sbaz$ManagedDirectory$$zipToOutputFilename(ZipEntry ent) {
        List pathParts = (List)Predef$.MODULE$.refArrayOps((Object[])ent.getName().split("/")).toList().filter(new $anonfun$3(this));
        return new Filename(!ent.isDirectory(), true, pathParts);
    }

    public final Filename sbaz$ManagedDirectory$$zipToFilename(ZipEntry zipEntry) {
        List list;
        if (this.sbaz$ManagedDirectory$$isPack200(zipEntry)) {
            String string = new StringBuilder().append((Object)zipEntry.getName().substring(0, zipEntry.getName().lastIndexOf(46))).append((Object)".jar").toString();
            list = (List)Predef$.MODULE$.refArrayOps((Object[])string.split("/")).toList().filter(new $anonfun$4(this));
        } else {
            list = (List)Predef$.MODULE$.refArrayOps((Object[])zipEntry.getName().split("/")).toList().filter(new $anonfun$5(this));
        }
        List list2 = list;
        return new Filename(!zipEntry.isDirectory(), true, list2);
    }

    public final Object sbaz$ManagedDirectory$$makeExecutable(File file) {
        Object object = null;
        try {
            object = Runtime.getRuntime().exec((String[])Array$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"chmod", "+x", file.getPath()}), ClassManifest$.MODULE$.classType(String.class)));
        }
        catch (IOException iOException) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public void makeChanges(Seq<ProposedChanges.ProposedChange> changes) {
        this.auditProposedChangeDependencies(this.installed(), changes).foreach(new $anonfun$makeChanges$1(this));
        Map<AvailablePackage, Download.FinalStatus> dnlResults$1 = this.downloader().download(this.extractAvailablePackages(changes));
        this.auditDownloadResults(dnlResults$1).foreach(new $anonfun$makeChanges$2(this));
        this.auditPackagesForFileCollisions(this.installed(), changes, dnlResults$1).foreach(new $anonfun$makeChanges$3(this));
        changes.iterator().foreach(new $anonfun$makeChanges$4(this));
        changes.iterator().foreach(new $anonfun$makeChanges$5(this, dnlResults$1));
    }

    public Option<String> auditProposedChangeDependencies(InstalledList installedList, Seq<ProposedChanges.ProposedChange> seq) {
        Option option;
        Set<Tuple2<Package, Set<String>>> set = installedList.identifyBreakingChanges(seq);
        if (set.isEmpty()) {
            option = None$.MODULE$;
        } else {
            String string = "Action aborted due to broken dependencies.\n";
            option = new Some<String>(set.foldLeft(string, new $anonfun$auditProposedChangeDependencies$1(this)));
        }
        return option;
    }

    public Option<String> auditDownloadResults(Map<AvailablePackage, Download.FinalStatus> map2) {
        Option option;
        Iterator iterator2 = map2.keysIterator().filter(new $anonfun$6(this, map2));
        if (iterator2.hasNext()) {
            String string = "Required dependencies could not be downloaded:\n";
            option = new Some<String>(iterator2.foldLeft(string, new $anonfun$auditDownloadResults$1(this, map2)));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<String> auditPackagesForFileCollisions(InstalledList installedList, Seq<ProposedChanges.ProposedChange> seq, Map<AvailablePackage, Download.FinalStatus> map2) {
        Option option;
        InstalledList installedList2 = new InstalledList();
        installedList2.addAll(installedList.installedEntries());
        seq.iterator().foreach(new $anonfun$auditPackagesForFileCollisions$1(this, installedList2));
        Map map3 = (Map)seq.foldLeft(Predef$.MODULE$.Map().empty(), new $anonfun$7(this, map2, installedList2));
        if (map3.isEmpty()) {
            option = None$.MODULE$;
        } else {
            String string = "Action aborted due to inter-package content collisions.\n";
            String string2 = map3.keysIterator().foldRight(string, new $anonfun$8(this, map3));
            option = new Some<String>(string2);
        }
        return option;
    }

    public List<InstalledEntry> findCollisions(InstalledList installed$2, Package pack, File file) {
        ZipFile zip2 = new ZipFile(file);
        List<? extends ZipEntry> zipEntsAll = this.mkList(zip2.entries());
        List zipEntsToInstall = (List)zipEntsAll.filter(new $anonfun$9(this));
        List collisions = zipEntsToInstall.foldLeft(Nil$.MODULE$, new $anonfun$10(this, installed$2));
        installed$2.add(new InstalledEntry(pack, zipEntsToInstall.map(new $anonfun$findCollisions$1(this), List$.MODULE$.canBuildFrom())));
        return (List)collisions.distinct();
    }

    private List<AvailablePackage> extractAvailablePackages(Seq<ProposedChanges.ProposedChange> changes) {
        return changes.iterator().foldLeft(Nil$.MODULE$, new $anonfun$extractAvailablePackages$1(this));
    }

    private <A> List<A> mkList(Enumeration<A> enumeration) {
        List l = Nil$.MODULE$;
        while (enumeration.hasMoreElements()) {
            A n;
            A a = n = enumeration.nextElement();
            l = l.$colon$colon(a);
        }
        return l.reverse();
    }

    public final boolean sbaz$ManagedDirectory$$isWin() {
        return this.sbaz$ManagedDirectory$$isWin;
    }

    private File scala_bazaars_jar() {
        return this.scala_bazaars_jar;
    }

    private File sbaz_jar() {
        return this.sbaz_jar;
    }

    private File scala_lib_jar() {
        return this.scala_lib_jar;
    }

    public final boolean sbaz$ManagedDirectory$$isSpecial(File f) {
        return this.sbaz$ManagedDirectory$$isWin() && (f.compareTo(this.scala_bazaars_jar()) == 0 || f.compareTo(this.sbaz_jar()) == 0 || f.compareTo(this.scala_lib_jar()) == 0);
    }

    public final boolean sbaz$ManagedDirectory$$isPack200(ZipEntry zipEntry) {
        return zipEntry.getName().endsWith(".pack");
    }

    public void extractFiles(ZipFile zip$1, List<ZipEntry> entries, File directory$1) {
        entries.foreach(new $anonfun$extractFiles$1(this, zip$1, directory$1));
    }

    public void installNoCheck(Package pack$1, File downloadedFile) {
        Option<InstalledEntry> temp32;
        block3: {
            InstalledEntry newEntry;
            List zipEntsToInstall;
            ZipFile zip2;
            block2: {
                zip2 = new ZipFile(downloadedFile);
                List<? extends ZipEntry> zipEntsAll = this.mkList(zip2.entries());
                zipEntsToInstall = (List)zipEntsAll.filter(new $anonfun$11(this));
                zipEntsToInstall.withFilter(new $anonfun$installNoCheck$1(this)).foreach(new $anonfun$installNoCheck$2(this, pack$1));
                List<Filename> installedFiles = zipEntsToInstall.map(new $anonfun$12(this), List$.MODULE$.canBuildFrom());
                newEntry = new InstalledEntry(pack$1, installedFiles);
                temp32 = this.installed().entryNamed(pack$1.name());
                None$ none$ = None$.MODULE$;
                Option<InstalledEntry> option = temp32;
                if (!(none$ == null ? option != null : !none$.equals(option))) break block2;
                if (!(temp32 instanceof Some)) break block3;
                this.removeEntryFiles((InstalledEntry)((Some)temp32).x());
            }
            this.extractFiles(zip2, zipEntsToInstall, this.directory());
            this.installed().add(newEntry);
            this.saveInstalled();
            zip2.close();
            return;
        }
        throw new MatchError(temp32);
    }

    public void install(AvailablePackage pack) {
        this.makeChanges((Seq<ProposedChanges.ProposedChange>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ProposedChanges.AdditionFromNet[]{new ProposedChanges.AdditionFromNet(pack)})));
    }

    public void install(File file) {
        if (file.exists()) {
            this.makeChanges((Seq<ProposedChanges.ProposedChange>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ProposedChanges.AdditionFromFile[]{new ProposedChanges.AdditionFromFile(file)})));
            return;
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    private void removeEntryFiles(InstalledEntry entry) {
        scala.collection.immutable.Set fullFiles = entry.files().map(new $anonfun$13(this), Set$.MODULE$.canBuildFrom());
        List sortedFiles = (List)fullFiles.toList().sortWith(new $anonfun$14(this));
        sortedFiles.withFilter(new $anonfun$removeEntryFiles$1(this)).foreach(new $anonfun$removeEntryFiles$2(this));
    }

    public void remove(InstalledEntry installedEntry) {
        if (this.installed().anyDependOn(installedEntry.name())) {
            throw new DependencyError(new StringBuilder().append((Object)"Package ").append((Object)installedEntry.name()).append((Object)" is still needed").toString());
        }
        this.sbaz$ManagedDirectory$$removeNoCheck(installedEntry);
    }

    public final void sbaz$ManagedDirectory$$removeNoCheck(InstalledEntry entry) {
        this.removeEntryFiles(entry);
        this.installed().remove(entry.packageSpec());
        this.saveInstalled();
    }

    public void updateAvailable() {
        this.available_$eq(this.universe().retrieveAvailable());
        this.saveAvailable();
    }

    public void compact() {
        this.downloader().flushCache();
    }

    public String toString() {
        return new StringBuilder().append((Object)"(").append((Object)this.directory().toString()).append((Object)": ").append(BoxesRunTime.boxToInteger(this.installed().size())).append((Object)"/").append(BoxesRunTime.boxToInteger(this.available().numPackages())).append((Object)" packages)").toString();
    }

    public final void rmForUpdate$1(String packName) {
        this.installed().entryNamed(packName).foreach(new $anonfun$rmForUpdate$1$1(this));
    }

    public final void rmForUpdate$2(String packName, InstalledList installedList) {
        installedList.entryNamed(packName).foreach(new $anonfun$rmForUpdate$2$1(this, installedList));
    }

    public final void cleanupEmptyDirs$1(File file) {
        while (true) {
            File file2 = this.directory();
            File file3 = file;
            if (!(file2 == null ? file3 != null : !((Object)file2).equals(file3)) || !file.delete()) break;
            file = file.getParentFile();
        }
    }

    public ManagedDirectory(File file) {
        this.directory = file;
        this.lib_dir = new File(file, "lib");
        this.meta_dir = new File(file, "meta");
        this.misc_dir = new File(file, "misc");
        if (this.lib_dir().isDirectory() || this.meta_dir().isDirectory() || this.misc_dir().isDirectory()) {
            File file2 = new File(this.meta_dir(), ".lock");
            file2.deleteOnExit();
            this.lock = new RandomAccessFile(file2, "rw").getChannel().tryLock();
            if (this.lock() != null && this.lock().isValid()) {
                this.downloader = Downloader$.MODULE$.apply(new File(this.meta_dir(), "cache"));
                this.available = this.loadXML("available", new $anonfun$1(this), new AvailableList(Nil$.MODULE$));
                this.installed = this.loadXML("installed", new $anonfun$2(this), new InstalledList());
                this.universe = Universe$.MODULE$.fromFile(new File(this.meta_dir(), "universe"));
                this.universe().keyringFilesAreIn(this.meta_dir());
                this.sbaz$ManagedDirectory$$isWin = System.getProperty("os.name").startsWith("Windows");
                this.scala_bazaars_jar = new File(this.misc_dir(), new StringBuilder().append((Object)"sbaz").append((Object)File.separator).append((Object)"scala-bazaars.jar").toString());
                this.sbaz_jar = new File(this.misc_dir(), new StringBuilder().append((Object)"sbaz").append((Object)File.separator).append((Object)"sbaz.jar").toString());
                this.scala_lib_jar = new File(this.misc_dir(), new StringBuilder().append((Object)"sbaz").append((Object)File.separator).append((Object)"scala-library.jar").toString());
                return;
            }
            throw new Error(new StringBuilder().append((Object)"Directory ").append(file).append((Object)" is locked by another process.").toString());
        }
        throw new Error(new StringBuilder().append((Object)"Directory ").append(file).append((Object)" does not appear to be a sbaz-managed directory").toString());
    }
}

