/*
 * Decompiled with CFR 0.152.
 */
package com.imageworks.migration;

import com.imageworks.migration.CharType$;
import com.imageworks.migration.CharacterSet;
import com.imageworks.migration.CheckOption;
import com.imageworks.migration.ColumnDefinition;
import com.imageworks.migration.ColumnOption;
import com.imageworks.migration.DatabaseAdapter$;
import com.imageworks.migration.GrantPrivilegeType;
import com.imageworks.migration.On;
import com.imageworks.migration.OnDelete;
import com.imageworks.migration.OnUpdate;
import com.imageworks.migration.SqlType;
import com.imageworks.migration.UnquotedNameConverter;
import com.imageworks.migration.VarcharType$;
import java.rmi.RemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseAdapter
implements ScalaObject {
    private final Logger logger;
    private final Option<String> schemaNameOpt;

    public DatabaseAdapter(Option<String> schemaNameOpt) {
        this.schemaNameOpt = schemaNameOpt;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public final String formatColumns$1(Seq columns) {
        return columns.isEmpty() ? "" : columns.mkString(" (", ", ", ")");
    }

    public String onUpdateSql(Option<OnUpdate> on_update_opt) {
        Option<OnUpdate> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = on_update_opt;
                    if (!(option instanceof Some)) break block2;
                    string = new scala.StringBuilder().append((Object)"ON UPDATE ").append((Object)((OnUpdate)((Some)option).x()).action().sql()).toString();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<OnUpdate> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                string = "";
            }
            return string;
        }
        throw new MatchError(option);
    }

    public String onDeleteSql(Option<OnDelete> on_delete_opt) {
        Option<OnDelete> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = on_delete_opt;
                    if (!(option instanceof Some)) break block2;
                    string = new scala.StringBuilder().append((Object)"ON DELETE ").append((Object)((OnDelete)((Some)option).x()).action().sql()).toString();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<OnDelete> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                string = "";
            }
            return string;
        }
        throw new MatchError(option);
    }

    public Tuple2<String, List<CheckOption>> generateCheckConstraintName(On on$1, Seq<CheckOption> options) {
        ObjectRef opts$2 = new ObjectRef((Object)options.toList());
        ObjectRef chk_name_opt$1 = new ObjectRef((Object)None$.MODULE$);
        ((List)opts$2.elem).filter((Function1)new $anonfun$generateCheckConstraintName$1(this)).foreach((Function1)new $anonfun$generateCheckConstraintName$2(this, opts$2, chk_name_opt$1));
        String name = (String)((Option)chk_name_opt$1.elem).getOrElse((Function0)new $anonfun$2(this, on$1));
        return new Tuple2((Object)name, (Object)((List)opts$2.elem));
    }

    public String revokeSql(String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        return this.revokeSql(this.schemaNameOpt(), table_name, grantees, privileges);
    }

    public String revokeSql(Option<String> schema_name_opt, String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        return this.grantRevokeCommon("REVOKE", "FROM", schema_name_opt, table_name, grantees, privileges);
    }

    public String grantSql(String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        return this.grantSql(this.schemaNameOpt(), table_name, grantees, privileges);
    }

    public String grantSql(Option<String> schema_name_opt, String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        StringBuilder sql = new StringBuilder(256).append("GRANT");
        return this.grantRevokeCommon("GRANT", "TO", schema_name_opt, table_name, grantees, privileges);
    }

    private String grantRevokeCommon(String action, String preposition, Option<String> schema_name_opt, String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        StringBuilder sql = new StringBuilder(256).append(action).append(' ');
        sql.append(privileges.map((Function1)new $anonfun$grantRevokeCommon$1(this)).mkString(", "));
        Object object = ScalaRunTime$.MODULE$.arrayValue(new BoxedObjectArray((Object[])grantees).map((Function1)new $anonfun$1(this)), String.class);
        String[] quoted_grantees = (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object);
        return sql.append(" ON ").append(this.quoteTableName(table_name)).append(' ').append(preposition).append(' ').append(new BoxedObjectArray((Object[])quoted_grantees).mkString(", ")).toString();
    }

    public String removeIndexSql(String table_name, String index_name) {
        return this.removeIndexSql(this.schemaNameOpt(), table_name, index_name);
    }

    public String removeIndexSql(Option<String> schema_name_opt, String table_name, String index_name) {
        return new scala.StringBuilder().append((Object)"DROP INDEX ").append((Object)this.quoteTableName(schema_name_opt, index_name)).toString();
    }

    public String removeColumnSql(String table_name, String column_name) {
        return this.removeColumnSql(this.schemaNameOpt(), table_name, column_name);
    }

    public String removeColumnSql(Option<String> schema_name_opt, String table_name, String column_name) {
        return new StringBuilder(512).append("ALTER TABLE ").append(this.quoteTableName(schema_name_opt, table_name)).append(" DROP ").append(this.quoteColumnName(column_name)).toString();
    }

    public String alterColumnSql(String table_name, String column_name, SqlType column_type, Seq<ColumnOption> options) {
        return this.alterColumnSql(this.schemaNameOpt(), table_name, column_name, column_type, options);
    }

    public String alterColumnSql(Option<String> schema_name_opt, String table_name, String column_name, SqlType column_type, Seq<ColumnOption> options) {
        return this.alterColumnSql(schema_name_opt, this.newColumnDefinition(table_name, column_name, column_type, options));
    }

    public abstract String alterColumnSql(Option<String> var1, ColumnDefinition var2);

    public String lockTableSql(String table_name) {
        return this.lockTableSql(this.schemaNameOpt(), table_name);
    }

    public String lockTableSql(Option<String> schema_name_opt, String table_name) {
        return new scala.StringBuilder().append((Object)"LOCK TABLE ").append((Object)this.quoteTableName(schema_name_opt, table_name)).append((Object)" IN EXCLUSIVE MODE").toString();
    }

    public String quoteTableName(String table_name) {
        return this.quoteTableName(this.schemaNameOpt(), table_name);
    }

    public String quoteTableName(Option<String> schema_name_opt, String table_name) {
        Option<String> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = schema_name_opt;
                    if (!(option instanceof Some)) break block2;
                    string = new scala.StringBuilder().append('\"').append((Object)this.unquotedNameConverter().apply((String)((Some)option).x())).append((Object)"\".\"").append((Object)this.unquotedNameConverter().apply(table_name)).append((Object)BoxesRunTime.boxToCharacter((char)'\"')).toString();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                string = new scala.StringBuilder().append('\"').append((Object)this.unquotedNameConverter().apply(table_name)).append((Object)BoxesRunTime.boxToCharacter((char)'\"')).toString();
            }
            return string;
        }
        throw new MatchError(option);
    }

    public String quoteColumnName(String column_name) {
        return new scala.StringBuilder().append('\"').append((Object)this.unquotedNameConverter().apply(column_name)).append((Object)BoxesRunTime.boxToCharacter((char)'\"')).toString();
    }

    public abstract ColumnDefinition columnDefinitionFactory(SqlType var1, Option<CharacterSet> var2);

    public ColumnDefinition newColumnDefinition(String table_name, String column_name, SqlType column_type, Seq<ColumnOption> options) {
        ObjectRef opts$1 = new ObjectRef((Object)options.toList());
        ObjectRef character_set_opt$1 = new ObjectRef((Object)None$.MODULE$);
        ((List)opts$1.elem).filter((Function1)new $anonfun$newColumnDefinition$1(this)).foreach((Function1)new $anonfun$newColumnDefinition$2(this, opts$1, character_set_opt$1));
        if (((Option)character_set_opt$1.elem).isDefined()) {
            SqlType sqlType = column_type;
            CharType$ charType$ = CharType$.MODULE$;
            SqlType sqlType2 = sqlType;
            if (charType$ == null ? sqlType2 != null : !charType$.equals(sqlType2)) {
                VarcharType$ varcharType$ = VarcharType$.MODULE$;
                SqlType sqlType3 = sqlType;
                if (varcharType$ == null ? sqlType3 != null : !varcharType$.equals(sqlType3)) {
                    this.logger().warn("The '{}' option cannot be used for a '{}' column type.", ((Option)character_set_opt$1.elem).get(), (Object)sqlType);
                }
            }
        }
        ColumnDefinition d = this.columnDefinitionFactory(column_type, (Option<CharacterSet>)((Option)character_set_opt$1.elem));
        d.adapterOpt_$eq((Option<DatabaseAdapter>)new Some((Object)this));
        d.tableNameOpt_$eq((Option<String>)new Some((Object)table_name));
        d.columnNameOpt_$eq((Option<String>)new Some((Object)column_name));
        d.options_$eq((List<ColumnOption>)((List)opts$1.elem));
        d.initialize();
        return d;
    }

    public abstract boolean addingForeignKeyConstraintCreatesIndex();

    public abstract UnquotedNameConverter unquotedNameConverter();

    public final Logger logger() {
        return this.logger;
    }

    public Option<String> schemaNameOpt() {
        return this.schemaNameOpt;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

