/*
 * Decompiled with CFR 0.152.
 */
package com.imageworks.migration;

import com.imageworks.migration.AutoCommit$;
import com.imageworks.migration.CommitBehavior;
import com.imageworks.migration.CommitUponReturnOrException$;
import com.imageworks.migration.CommitUponReturnOrRollbackUponException$;
import com.imageworks.migration.ConnectionBuilder$;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Right;
import scala.ScalaObject;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionBuilder
implements ScalaObject {
    private final Logger logger;
    private final Option<Tuple2<String, String>> login_opt;
    private final Either<DataSource, String> either;

    private ConnectionBuilder(Either<DataSource, String> either, Option<Tuple2<String, String>> login_opt) {
        this.either = either;
        this.login_opt = login_opt;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <R> R withConnection(CommitBehavior commit_behavior, Function1<Connection, R> f) {
        Connection connection;
        Either<DataSource, String> either = this.either;
        Option<Tuple2<String, String>> option = this.login_opt;
        if (either instanceof Left) {
            Left left = (Left)either;
            DataSource dataSource = (DataSource)left.a();
            if (option instanceof Some) {
                Some some = (Some)option;
                Tuple2 tuple2 = (Tuple2)some.x();
                if (tuple2 == null) {
                    throw new MatchError((Object)new Tuple2(either, option));
                }
                connection = dataSource.getConnection((String)tuple2._1(), (String)tuple2._2());
            } else {
                None$ none$ = None$.MODULE$;
                Option<Tuple2<String, String>> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError((Object)new Tuple2(either, option));
                connection = dataSource.getConnection();
            }
        } else {
            if (!(either instanceof Right)) throw new MatchError((Object)new Tuple2(either, option));
            Right right = (Right)either;
            String string = (String)right.b();
            if (option instanceof Some) {
                Some some = (Some)option;
                Tuple2 tuple2 = (Tuple2)some.x();
                if (tuple2 == null) {
                    throw new MatchError((Object)new Tuple2(either, option));
                }
                connection = DriverManager.getConnection(string, (String)tuple2._1(), (String)tuple2._2());
            } else {
                None$ none$ = None$.MODULE$;
                Option<Tuple2<String, String>> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)new Tuple2(either, option));
                connection = DriverManager.getConnection(string);
            }
        }
        Connection connection$1 = connection;
        Object exceptionResult1 = null;
        try {
            boolean bl;
            CommitBehavior commitBehavior = commit_behavior;
            AutoCommit$ autoCommit$ = AutoCommit$.MODULE$;
            CommitBehavior commitBehavior2 = commitBehavior;
            if (!(autoCommit$ != null ? !autoCommit$.equals(commitBehavior2) : commitBehavior2 != null)) {
                bl = true;
            } else {
                CommitUponReturnOrException$ commitUponReturnOrException$ = CommitUponReturnOrException$.MODULE$;
                CommitBehavior commitBehavior3 = commitBehavior;
                if (!(commitUponReturnOrException$ != null ? !commitUponReturnOrException$.equals(commitBehavior3) : commitBehavior3 != null)) {
                    bl = false;
                } else {
                    CommitUponReturnOrRollbackUponException$ commitUponReturnOrRollbackUponException$ = CommitUponReturnOrRollbackUponException$.MODULE$;
                    CommitBehavior commitBehavior4 = commitBehavior;
                    if (commitUponReturnOrRollbackUponException$ != null ? !commitUponReturnOrRollbackUponException$.equals(commitBehavior4) : commitBehavior4 != null) throw new MatchError((Object)commitBehavior);
                    bl = false;
                }
            }
            boolean auto_commit = bl;
            connection$1.setAutoCommit(auto_commit);
            Object result = f.apply((Object)connection$1);
            CommitBehavior commitBehavior5 = commit_behavior;
            AutoCommit$ autoCommit$2 = AutoCommit$.MODULE$;
            CommitBehavior commitBehavior6 = commitBehavior5;
            if (autoCommit$2 == null ? commitBehavior6 != null : !autoCommit$2.equals(commitBehavior6)) {
                CommitUponReturnOrException$ commitUponReturnOrException$ = CommitUponReturnOrException$.MODULE$;
                CommitBehavior commitBehavior7 = commitBehavior5;
                if (!(commitUponReturnOrException$ != null ? !commitUponReturnOrException$.equals(commitBehavior7) : commitBehavior7 != null)) {
                    connection$1.commit();
                } else {
                    CommitUponReturnOrRollbackUponException$ commitUponReturnOrRollbackUponException$ = CommitUponReturnOrRollbackUponException$.MODULE$;
                    CommitBehavior commitBehavior8 = commitBehavior5;
                    if (commitUponReturnOrRollbackUponException$ != null ? !commitUponReturnOrRollbackUponException$.equals(commitBehavior8) : commitBehavior8 != null) throw new MatchError((Object)commitBehavior5);
                    connection$1.commit();
                }
            }
            exceptionResult1 = result;
            return (R)exceptionResult1;
        }
        catch (Throwable throwable) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            CommitBehavior commitBehavior = commit_behavior;
            AutoCommit$ autoCommit$ = AutoCommit$.MODULE$;
            CommitBehavior commitBehavior9 = commitBehavior;
            if (!(autoCommit$ != null ? !autoCommit$.equals(commitBehavior9) : commitBehavior9 != null)) {
                tuple22 = new Tuple2((Object)"", (Object)new $anonfun$1(this));
            } else {
                CommitUponReturnOrException$ commitUponReturnOrException$ = CommitUponReturnOrException$.MODULE$;
                CommitBehavior commitBehavior10 = commitBehavior;
                if (!(commitUponReturnOrException$ != null ? !commitUponReturnOrException$.equals(commitBehavior10) : commitBehavior10 != null)) {
                    tuple22 = new Tuple2((Object)"commit", (Object)new $anonfun$2(this, connection$1));
                } else {
                    CommitUponReturnOrRollbackUponException$ commitUponReturnOrRollbackUponException$ = CommitUponReturnOrRollbackUponException$.MODULE$;
                    CommitBehavior commitBehavior11 = commitBehavior;
                    if (commitUponReturnOrRollbackUponException$ != null ? !commitUponReturnOrRollbackUponException$.equals(commitBehavior11) : commitBehavior11 != null) throw new MatchError((Object)commitBehavior);
                    tuple22 = tuple2 = new Tuple2((Object)"rollback", (Object)new $anonfun$3(this, connection$1));
                }
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple23 = new Tuple2(tuple2._1(), tuple2._2());
            String operation = (String)tuple23._1();
            Function0 thunk = (Function0)tuple23._2();
            Object exceptionResult2 = null;
            try {
                exceptionResult2 = thunk.apply();
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.logger().warn(new StringBuilder().append((Object)"Trying to ").append((Object)operation).append((Object)" the connection after catching ").append((Object)throwable).append((Object)" threw:").toString(), throwable2);
                exceptionResult2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        finally {
            try {
                connection$1.close();
            }
            catch (Throwable throwable) {
                this.logger().warn("Error in closing connection:", throwable);
            }
        }
    }

    public ConnectionBuilder(DataSource datasource, String username, String password) {
        this((Either<DataSource, String>)new Left((Object)datasource), (Option<Tuple2<String, String>>)new Some((Object)new Tuple2((Object)username, (Object)password)));
    }

    public ConnectionBuilder(DataSource datasource) {
        this((Either<DataSource, String>)new Left((Object)datasource), (Option<Tuple2<String, String>>)None$.MODULE$);
    }

    public ConnectionBuilder(String url, String username, String password) {
        this((Either<DataSource, String>)new Right((Object)url), (Option<Tuple2<String, String>>)new Some((Object)new Tuple2((Object)username, (Object)password)));
    }

    public ConnectionBuilder(String url) {
        this((Either<DataSource, String>)new Right((Object)url), (Option<Tuple2<String, String>>)None$.MODULE$);
    }

    private final Logger logger() {
        return this.logger;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

