<?php

/**
* VolunteerTest
*
* PHP version 5
*
* LICENSE: This source file is subject to LGPL license
* that is available through the world-wide-web at the following URI:
* http://www.gnu.org/copyleft/lesser.html
*
* @author       Antonio Alcorn
* @author       Giovanni Capalbo
* @author		Sylvia Hristakeva
* @author		Kumud Nepal
* @author		Ernel Wint
* @copyright    Lanka Software Foundation - http://www.opensource.lk
* @copyright    Trinity Humanitarian-FOSS Project - http://www.cs.trincoll.edu/hfoss
* @package      sahana
* @subpackage   vm
* @tutorial
* @license        http://www.gnu.org/copyleft/lesser.html GNU Lesser General
* Public License (LGPL)
*/

// Call VolunteerTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "VolunteerTest::main");
}

/**
 * Test class for Volunteer.
 * Generated by PHPUnit_Util_Skeleton on 2007-06-19 at 11:08:45.
 */
class VolunteerTest extends PHPUnit_Framework_TestCase {

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    	$this->fixture = new Volunteer();

    	global $global,$dao;
    	$global=array('approot'=>realpath(dirname(__FILE__)).'/../../../');
		require_once($global['approot'].'3rd/adodb/adodb.inc.php');

		//Make the connection to $global['db']
		$global['db'] = NewADOConnection('mysql');
		$global['db']->Connect(TEST_DB_HOST, TEST_DB_USER,TEST_DB_PASSWD,TEST_DB_NAME);
		error_reporting(E_ALL ^ E_NOTICE);
		$dao = new DAO($global['db']);
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {

    }

    public function testVolunteer() {
    	global $dao;
		$this->fixture->Volunteer('489sp-17');
		$this->fixture->info['proj_id'] = $this->fixture->proj_id;
		asort($this->fixture->info);
		$expected = $dao->getVol('489sp-17');
		asort($expected);
		$this->assertEquals($this->fixture->info, $expected);
    }

    // all other functions are one-line wrappers around DAO
}
?>