<?php

/**
* test to validate vm_validate.inc
*
* PHP version 5
*
* LICENSE: This source file is subject to LGPL license
* that is available through the world-wide-web at the following URI:
* http://www.gnu.org/copyleft/lesser.html
*
* @author       Antonio Alcorn
* @author       Giovanni Capalbo
* @author		Sylvia Hristakeva
* @author		Kumud Nepal
* @author		Ernel Wint
* @copyright    Lanka Software Foundation - http://www.opensource.lk
* @copyright    Trinity Humanitarian-FOSS Project - http://www.cs.trincoll.edu/hfoss
* @package      sahana
* @subpackage   vm
* @tutorial
* @license        http://www.gnu.org/copyleft/lesser.html GNU Lesser General
* Public License (LGPL)
*/

// Call VolunteerControllerTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "ValidationTest::main");
}

/**
 * Test class for VolunteerController.
 * Generated by PHPUnit_Util_Skeleton on 2007-06-19 at 11:08:45.
 */
class ValidationTest extends PHPUnit_Framework_TestCase {

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    	//Include the ADOdb Library
    	global $global,$dao;
    	$global=array('approot'=>realpath(dirname(__FILE__)).'/../../../');
    	$dao = new DAO($global['db']);
		require_once($global['approot'].'3rd/adodb/adodb.inc.php');

		//Make the connection to $global['db']
		$global['db'] = NewADOConnection('mysql');
		$global['db']->Connect(TEST_DB_HOST, TEST_DB_USER,TEST_DB_PASSWD,TEST_DB_NAME);

    	// test valid user
		$dao->execute("insert into users (user_name, p_uuid) values ('test1', 'any_p_uuid1')");
		$dao->execute("insert into users (user_name, p_uuid) values ('vtest2', 'any_p_uuid2')");
		$dao->execute("delete from users where user_name = 'test3'");
		$dao->execute("delete from users where user_name = 'test4'");
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    	global $dao;

    	// test valid user
    	$dao->execute("delete from users where user_name = 'test1'");
		$dao->execute("delete from users where user_name = 'vtest2'");
    }


    public function testValidDate() {
		$this->assertTrue(shn_vm_valid_date('1986-12-21'));
		$this->assertTrue(shn_vm_valid_date('1954-10-10'));
		$this->assertTrue(shn_vm_valid_date('2004-02-29'));
		$this->assertTrue(shn_vm_valid_date('1982-02-28'));

		$this->assertFalse(shn_vm_valid_date('1982-02-29')); // not a leap year
		$this->assertFalse(shn_vm_valid_date('1982-52-20')); // month out of range
		$this->assertFalse(shn_vm_valid_date('1982-10-40')); // day out of range
		$this->assertFalse(shn_vm_valid_date(''));
		$this->assertFalse(shn_vm_valid_date('garbage'));
    }

	/**
	 * Tests  shn_vm_not_empty()
	 */
    public function testNotEmpty()
    {
    	$this->assertTrue(shn_vm_not_empty('not null'));

    	$this->assertFalse(shn_vm_not_empty(''));
    	$this->assertFalse(shn_vm_not_empty('     '));
    }

    /**
     * Tests shn_vm_compatible_dates()
     */
    public function testValidateDates()
    {
    	$this->assertTrue(shn_vm_compatible_dates('1980-12-20', '1990-12-20'));
    	$this->assertTrue(shn_vm_compatible_dates('1980-12-20', '1980-12-20'));

    	$this->assertFalse(shn_vm_compatible_dates('2000-12-20', '1990-12-20'));
    	$this->assertFalse(shn_vm_compatible_dates('1980-12-20', '1980-01-20'));
    	$this->assertFalse(shn_vm_compatible_dates('1980-12-20', '1980-12-10'));

    }
    /**
     * Tests shn_vm_validate_field_equality()
     */
     public function testFeildEquality()
     {
     	$this->assertTrue(shn_vm_fields_equal('',''));
     	$this->assertTrue(shn_vm_fields_equal('Abv','Abv'));
     	$this->assertTrue(shn_vm_fields_equal('abv','abv'));
     	$this->assertTrue(shn_vm_fields_equal('   ','   '));

     	$this->assertFalse(shn_vm_fields_equal('abv','Abv'));
     	$this->assertFalse(shn_vm_fields_equal('dfsjk','dfkdsl'));
     	$this->assertFalse(shn_vm_fields_equal(' ',''));
     }

     /**
      * Tests shn_vm_validate_time()
      */

      public function testValidateTime()
      {
      	//Test if the time is in the right format
      	$this->assertTrue(shn_vm_valid_time('1:10'));
      	$this->assertTrue(shn_vm_valid_time('01:10'));
      	$this->assertTrue(shn_vm_valid_time('1:10:20'));
      	$this->assertTrue(shn_vm_valid_time('12:10:50'));

      	$this->assertFalse(shn_vm_valid_time('122:10:50'));
      	$this->assertFalse(shn_vm_valid_time('12:100:50'));
      	$this->assertFalse(shn_vm_valid_time('12:10:500'));
      	$this->assertFalse(shn_vm_valid_time('122:108:508'));
      	$this->assertFalse(shn_vm_valid_time('122:10'));
      	$this->assertFalse(shn_vm_valid_time('12:106'));
      	$this->assertFalse(shn_vm_valid_time(':10:50'));
      	$this->assertFalse(shn_vm_valid_time('12:1:50'));
      	$this->assertFalse(shn_vm_valid_time('12:10:5'));
      	$this->assertFalse(shn_vm_valid_time('12:1'));
      	$this->assertFalse(shn_vm_valid_time('12:'));
      	$this->assertFalse(shn_vm_valid_time('hf:hh'));
      	$this->assertFalse(shn_vm_valid_time('-5:10:50'));
      	$this->assertFalse(shn_vm_valid_time(': :'));
      	$this->assertFalse(shn_vm_valid_time(''));
      	$this->assertFalse(shn_vm_valid_time(':'));

      	//Test if the hours and minutes are in the correct range

      	$this->assertTrue(shn_vm_valid_time('23:10:50'));
      	$this->assertTrue(shn_vm_valid_time('00:10'));
      	$this->assertTrue(shn_vm_valid_time('12:10:50'));
      	$this->assertTrue(shn_vm_valid_time('12:00'));
      	$this->assertTrue(shn_vm_valid_time('12:59:50'));
      	$this->assertTrue(shn_vm_valid_time('12:10:59'));
      	$this->assertTrue(shn_vm_valid_time('12:10:00'));


      	$this->assertFalse(shn_vm_valid_time('24:10'));
      	$this->assertFalse(shn_vm_valid_time('40:10'));
      	$this->assertFalse(shn_vm_valid_time('12:70:50'));
      	$this->assertFalse(shn_vm_valid_time('12:60'));
      	$this->assertFalse(shn_vm_valid_time('12:10:60'));
      	$this->assertFalse(shn_vm_valid_time('12:10:70'));

      }

      /**
       * Tests shn_vm_username_not_taken()
       */
      public function testUsernameNotTaken()
      {
		global $global;
		include_once($global['approot'].'inc/lib_security/lib_auth.inc');

		// these users should be as asserted based on setUp()

		$this->assertTrue(shn_vm_username_not_taken('test3'));
		$this->assertTrue(shn_vm_username_not_taken('test4'));

		$this->assertFalse(shn_vm_username_not_taken('test1'));
		$this->assertFalse(shn_vm_username_not_taken('vtest2'));


      }

      /**
       * Tests shn_vm_skill_selected()
       */

       public function testSkillSelected()
       {
       	$skills_1 = array("full_name"=> "ed", "SKILL_MGR_APPLY"=>"on");
       	$skills_2 = array("full_name"=> "ed", "date_start" => "2007-05-30", "SKILL_MGR_APPLY"=>"on", "SKILL_ANI4"=>"on", "SKILL_ANI8"=>"on");
		$skills_6 = array("full_name"=> "ed", "date_start" => "2007-05-30", "SKILL_MGR_APPLY"=>"on", "SKILL_ANI4"=>"off", "SKILL_ANI8"=>"on");

       	$skills_3 = array();
		$skills_4 = array("full_name"=> "ed", "date_start" => "2007-05-30");
		$skills_5 = array("full_name"=> "ed", "date_start" => "2007-05-30", "SKILL_MGR_APPLY"=>"off");
		$skills_7 = array("full_name"=> "ed", "date_start" => "2007-05-30", "SKILL_MGR_APPLY"=>"", "SKILL_ANI4"=>"off", "SKILL_ANI8"=>"fdg");



		$this->assertTrue(shn_vm_skill_selected($skills_1));
		$this->assertTrue(shn_vm_skill_selected($skills_2));
		$this->assertTrue(shn_vm_skill_selected($skills_6));

		$this->assertFalse(shn_vm_skill_selected($skills_3));
		$this->assertFalse(shn_vm_skill_selected($skills_4));
		$this->assertFalse(shn_vm_skill_selected($skills_5));
		$this->assertFalse(shn_vm_skill_selected($skills_7));
       }


      public function testLocationSelected()
      {
      	//valid
      	$_POST["levels"] = 3;
    	$_POST["1"] = "country";
		$this->assertTrue(shn_vm_location_selected());

		$_POST = array();
    	$_POST["levels"] = 3;
    	$_POST["3"] = "";
		$this->assertTrue(shn_vm_location_selected());

		//invalid
		$_POST = array();
		$_POST["levels"] = 0;
    	$_POST["1"] = "country";
		$this->assertFalse(shn_vm_location_selected());

		$_POST = array();
    	$_POST["levels"] = 3;
    	$_POST["5"] = "country";
      	$this->assertFalse(shn_vm_location_selected());
      }

}


?>