/* rygel-media-export-extract.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-media-export-extract.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <unistd.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _RunData RunData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

typedef enum  {
	METADATA_EXTRACTOR_ERROR_GENERAL
} MetadataExtractorError;
#define METADATA_EXTRACTOR_ERROR metadata_extractor_error_quark ()
typedef enum  {
	DVD_PARSER_ERROR_GENERAL,
	DVD_PARSER_ERROR_NOT_AVAILABLE
} DVDParserError;
#define DVD_PARSER_ERROR dvd_parser_error_quark ()
struct _RunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gchar* line;
	GDataInputStream* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* data;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** parts;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GFile* file;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	RygelMediaExportExtractor* extractor;
	GFile* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	RygelMediaExportExtractor* _tmp21_;
	RygelMediaExportExtractor* _tmp22_;
	GFile* _tmp23_;
	RygelMediaExportExtractor* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GError* _error_;
	GError* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	const gchar* _tmp37_;
	GFile* _tmp38_;
	GFile* _tmp39_;
	GError* _tmp40_;
	const gchar* _tmp41_;
	gchar* command;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gboolean _tmp49_;
	const gchar* _tmp50_;
	GError* _vala1__error_;
	GError* _tmp51_;
	const gchar* _tmp52_;
	GMainLoop* _tmp53_;
	GError * _inner_error_;
};


extern gint in_fd;
gint in_fd = 0;
extern gint out_fd;
gint out_fd = 1;
extern gboolean metadata;
gboolean metadata = FALSE;
extern GMainLoop* loop;
GMainLoop* loop = NULL;
extern GDataInputStream* input_stream;
GDataInputStream* input_stream = NULL;
extern GOutputStream* output_stream;
GOutputStream* output_stream = NULL;

#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_PLAYLIST "object.item.playlistItem"
#define UPNP_CLASS_PLAYLIST_CONTAINER_DVD "object.container.playlistContainer.DVD"
#define UPNP_CLASS_DVD_TRACK UPNP_CLASS_VIDEO ".dvdTrack"
#define STATUS_LINE_TEMPLATE "RESULT|%s|%" G_GSIZE_FORMAT "|%s\n"
#define ERROR_LINE_TEMPLATE "ERROR|%s|%d|%s\n"
#define SKIPPED_LINE_TEMPLATE "SKIP|%s|-1|0\n"
GQuark metadata_extractor_error_quark (void);
static void run_data_free (gpointer _data);
static void run_async_ready_wrapper (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data);
void run (GAsyncReadyCallback _callback_,
          gpointer _user_data_);
void run_finish (GAsyncResult* _res_);
static gboolean run_co (RunData* _data_);
static void run_ready (GObject* source_object,
                GAsyncResult* _res_,
                gpointer _user_data_);
GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST;
RygelMediaExportExtractor* rygel_media_export_extractor_create_for_file (GFile* file,
                                                                         const gchar* content_type,
                                                                         gboolean extract_metadata);
void rygel_media_export_extractor_run (RygelMediaExportExtractor* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self,
                                              GAsyncResult* _res_,
                                              GError** error);
void send_extraction_done (GFile* file,
                           GVariant* v,
                           GError** error);
GVariant* rygel_media_export_extractor_get (RygelMediaExportExtractor* self);
GQuark dvd_parser_error_quark (void);
void send_skip (GFile* file);
void send_error (GFile* file,
                 GError* err);
gboolean vaapi_filter (GstPluginFeature* feature);
gint _vala_main (gchar** args,
                 int args_length1);
static gboolean _vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature,
                                                  gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[4] = {{"input-fd", 'i', 0, G_OPTION_ARG_INT, &in_fd, "File descriptor used for input", NULL}, {"output-fd", 'o', 0, G_OPTION_ARG_INT, &out_fd, "File descriptor used for output", NULL}, {"extract-metadata", 'm', 0, G_OPTION_ARG_NONE, &metadata, "Whether to extract all metadata from the files or just basic informati" \
"on", NULL}, {NULL}};

GQuark
metadata_extractor_error_quark (void)
{
	return g_quark_from_static_string ("metadata_extractor_error-quark");
}


static void
run_data_free (gpointer _data)
{
	RunData* _data_;
	_data_ = _data;
	g_slice_free (RunData, _data_);
}


static void
run_async_ready_wrapper (GObject *source_object,
                         GAsyncResult *res,
                         void *user_data)
{
	RunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
run (GAsyncReadyCallback _callback_,
     gpointer _user_data_)
{
	RunData* _data_;
	_data_ = g_slice_new0 (RunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, run_data_free);
	run_co (_data_);
}


void
run_finish (GAsyncResult* _res_)
{
	RunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
run_ready (GObject* source_object,
           GAsyncResult* _res_,
           gpointer _user_data_)
{
	RunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	run_co (_data_);
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean
bool_parse (const gchar* str)
{
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean
run_co (RunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		{
			_data_->_tmp0_ = input_stream;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, NULL, run_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = g_data_input_stream_read_line_finish (_data_->_tmp0_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->line = _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = _data_->line;
			if (_data_->_tmp2_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp3_ = _data_->line;
			if (g_str_has_prefix (_data_->_tmp3_, "EXTRACT ")) {
				_data_->_tmp4_ = _data_->line;
				g_debug ("rygel-media-export-extract.vala:69: Got command to extract file: %s", _data_->_tmp4_);
				_data_->_tmp5_ = _data_->line;
				_data_->_tmp6_ = string_replace (_data_->_tmp5_, "EXTRACT ", "");
				_data_->_tmp7_ = _data_->_tmp6_;
				_data_->_tmp8_ = string_strip (_data_->_tmp7_);
				_data_->_tmp9_ = _data_->_tmp8_;
				_g_free0 (_data_->_tmp7_);
				_data_->data = _data_->_tmp9_;
				_data_->_tmp10_ = _data_->data;
				_data_->_tmp12_ = _data_->_tmp11_ = g_strsplit (_data_->_tmp10_, "|", 0);
				_data_->parts = _data_->_tmp12_;
				_data_->parts_length1 = _vala_array_length (_data_->_tmp11_);
				_data_->_parts_size_ = _data_->parts_length1;
				_data_->_tmp13_ = _data_->parts;
				_data_->_tmp13__length1 = _data_->parts_length1;
				if (_data_->_tmp13__length1 != 2) {
					g_warning ("rygel-media-export-extract.vala:73: %s", _ ("Invalid command received, ignoring"));
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					continue;
				}
				{
					_data_->_tmp14_ = _data_->parts;
					_data_->_tmp14__length1 = _data_->parts_length1;
					_data_->_tmp15_ = _data_->_tmp14_[0];
					_data_->_tmp16_ = g_file_new_for_uri (_data_->_tmp15_);
					_data_->file = _data_->_tmp16_;
					_data_->_tmp17_ = _data_->file;
					_data_->_tmp18_ = _data_->parts;
					_data_->_tmp18__length1 = _data_->parts_length1;
					_data_->_tmp19_ = _data_->_tmp18_[1];
					_data_->_tmp20_ = metadata;
					_data_->_tmp21_ = rygel_media_export_extractor_create_for_file (_data_->_tmp17_, _data_->_tmp19_, _data_->_tmp20_);
					_data_->extractor = _data_->_tmp21_;
					_data_->_tmp22_ = _data_->extractor;
					_data_->_state_ = 2;
					rygel_media_export_extractor_run (_data_->_tmp22_, run_ready, _data_);
					return FALSE;
					_state_2:
					rygel_media_export_extractor_run_finish (_data_->_tmp22_, _data_->_res_, &_data_->_inner_error_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch2_g_error;
					}
					_data_->_tmp23_ = _data_->file;
					_data_->_tmp24_ = _data_->extractor;
					_data_->_tmp25_ = rygel_media_export_extractor_get (_data_->_tmp24_);
					_data_->_tmp26_ = _data_->_tmp25_;
					send_extraction_done (_data_->_tmp23_, _data_->_tmp26_, &_data_->_inner_error_);
					_g_variant_unref0 (_data_->_tmp26_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch2_g_error;
					}
					_g_object_unref0 (_data_->extractor);
					_g_object_unref0 (_data_->file);
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp27_ = _data_->_error_;
					if (g_error_matches (_data_->_tmp27_, DVD_PARSER_ERROR, DVD_PARSER_ERROR_NOT_AVAILABLE)) {
						_data_->_tmp28_ = _data_->parts;
						_data_->_tmp28__length1 = _data_->parts_length1;
						_data_->_tmp29_ = _data_->_tmp28_[0];
						_data_->_tmp30_ = g_file_new_for_uri (_data_->_tmp29_);
						_data_->_tmp31_ = _data_->_tmp30_;
						send_skip (_data_->_tmp31_);
						_g_object_unref0 (_data_->_tmp31_);
					} else {
						_data_->_tmp32_ = _data_->parts;
						_data_->_tmp32__length1 = _data_->parts_length1;
						_data_->_tmp33_ = _data_->_tmp32_[0];
						_data_->_tmp34_ = _data_->_error_;
						_data_->_tmp35_ = _data_->_tmp34_->message;
						g_warning (_ ("Failed to discover URI %s: %s"), _data_->_tmp33_, _data_->_tmp35_);
						_data_->_tmp36_ = _data_->parts;
						_data_->_tmp36__length1 = _data_->parts_length1;
						_data_->_tmp37_ = _data_->_tmp36_[0];
						_data_->_tmp38_ = g_file_new_for_uri (_data_->_tmp37_);
						_data_->_tmp39_ = _data_->_tmp38_;
						_data_->_tmp40_ = _data_->_error_;
						send_error (_data_->_tmp39_, _data_->_tmp40_);
						_g_object_unref0 (_data_->_tmp39_);
					}
					_g_error_free0 (_data_->_error_);
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					goto __catch0_g_error;
				}
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->data);
			} else {
				_data_->_tmp41_ = _data_->line;
				if (g_str_has_prefix (_data_->_tmp41_, "METADATA ")) {
					_data_->_tmp42_ = _data_->line;
					_data_->_tmp43_ = string_replace (_data_->_tmp42_, "METADATA ", "");
					_data_->_tmp44_ = _data_->_tmp43_;
					_data_->_tmp45_ = string_strip (_data_->_tmp44_);
					_data_->_tmp46_ = _data_->_tmp45_;
					_g_free0 (_data_->_tmp44_);
					_data_->command = _data_->_tmp46_;
					_data_->_tmp47_ = _data_->command;
					metadata = bool_parse (_data_->_tmp47_);
					_data_->_tmp49_ = metadata;
					if (_data_->_tmp49_) {
						_data_->_tmp48_ = "enabled";
					} else {
						_data_->_tmp48_ = "disabled";
					}
					g_debug ("rygel-media-export-extract.vala:99: Meta-data extraction was %s", _data_->_tmp48_);
					_g_free0 (_data_->command);
				} else {
					_data_->_tmp50_ = _data_->line;
					if (g_str_has_prefix (_data_->_tmp50_, "QUIT")) {
						_g_free0 (_data_->line);
						break;
					}
				}
			}
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp51_ = _data_->_vala1__error_;
			_data_->_tmp52_ = _data_->_tmp51_->message;
			g_warning (_ ("Failed to read from pipe: %s"), _data_->_tmp52_);
			_g_error_free0 (_data_->_vala1__error_);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp53_ = loop;
	g_main_loop_quit (_data_->_tmp53_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void
send_extraction_done (GFile* file,
                      GVariant* v,
                      GError** error)
{
	GBytes* data = NULL;
	GBytes* _tmp0_;
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GBytes* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GOutputStream* _tmp8_;
	const gchar* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gsize _tmp12_ = 0UL;
	GOutputStream* _tmp13_;
	GBytes* _tmp14_;
	gsize _tmp15_;
	guint8* _tmp16_;
	gsize _tmp17_ = 0UL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = g_variant_get_data_as_bytes (v);
	data = _tmp0_;
	bytes_written = (gsize) 0;
	_tmp1_ = g_file_get_uri (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = data;
	_tmp4_ = g_file_get_uri (file);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (STATUS_LINE_TEMPLATE, _tmp2_, g_bytes_get_size (_tmp3_), _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	status = _tmp7_;
	_tmp8_ = output_stream;
	_tmp9_ = status;
	_tmp10_ = string_get_data (_tmp9_, &_tmp10__length1);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	g_output_stream_write_all (_tmp8_, _tmp11_, (gsize) _tmp11__length1, &_tmp12_, NULL, &_inner_error_);
	bytes_written = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_tmp13_ = output_stream;
	_tmp14_ = data;
	_tmp16_ = g_bytes_get_data (_tmp14_, &_tmp15_);
	g_output_stream_write_all (_tmp13_, _tmp16_, (gsize) _tmp15_, &_tmp17_, NULL, &_inner_error_);
	bytes_written = _tmp17_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_g_free0 (status);
	_g_bytes_unref0 (data);
}


void
send_skip (GFile* file)
{
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (SKIPPED_LINE_TEMPLATE, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	status = _tmp3_;
	{
		GOutputStream* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		guint8* _tmp6_;
		gint _tmp6__length1;
		gsize _tmp7_ = 0UL;
		_tmp4_ = output_stream;
		_tmp5_ = string_get_data (status, &_tmp5__length1);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp5__length1;
		g_output_stream_write_all (_tmp4_, _tmp6_, (gsize) _tmp6__length1, &_tmp7_, NULL, &_inner_error_);
		bytes_written = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning (_ ("Failed to send error to parent: %s"), _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status);
}


void
send_error (GFile* file,
            GError* err)
{
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = err->code;
	_tmp3_ = err->message;
	_tmp4_ = g_strdup_printf (ERROR_LINE_TEMPLATE, _tmp1_, _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp1_);
	status = _tmp5_;
	{
		GOutputStream* _tmp6_;
		guint8* _tmp7_;
		gint _tmp7__length1;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gsize _tmp9_ = 0UL;
		_tmp6_ = output_stream;
		_tmp7_ = string_get_data (status, &_tmp7__length1);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _tmp7__length1;
		g_output_stream_write_all (_tmp6_, _tmp8_, (gsize) _tmp8__length1, &_tmp9_, NULL, &_inner_error_);
		bytes_written = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_ ("Failed to send error to parent: %s"), _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status);
}


gboolean
vaapi_filter (GstPluginFeature* feature)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (feature != NULL, FALSE);
	_tmp0_ = gst_object_get_name ((GstObject*) feature);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (_tmp1_, "vaapi");
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gboolean
_vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature,
                                         gpointer self)
{
	gboolean result;
	result = vaapi_filter (feature);
	return result;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	GOptionContext* ctx = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp8_;
	GstRegistry* _tmp9_;
	GList* features = NULL;
	GstRegistry* _tmp10_;
	GList* _tmp11_;
	GList* _tmp12_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GUnixInputStream* _tmp22_;
	GUnixInputStream* _tmp23_;
	GDataInputStream* _tmp24_;
	gint _tmp25_;
	GUnixOutputStream* _tmp26_;
	GMainLoop* _tmp27_;
	GMainLoop* _tmp28_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (_ ("— helper binary for Rygel to extract metadata"));
	ctx = _tmp0_;
	_tmp1_ = ctx;
	g_option_context_add_main_entries (_tmp1_, options, NULL);
	_tmp2_ = ctx;
	_tmp3_ = gst_init_get_option_group ();
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = ctx;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning (_ ("Failed to parse commandline args: %s"), _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (_error_);
		_g_option_context_free0 (ctx);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	if (nice (19) < 0) {
		g_debug ("rygel-media-export-extract.vala:170: Failed to reduce nice level of th" \
"umbnailer, continuing anyway");
	}
	_tmp8_ = gst_registry_get ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	registry = _tmp9_;
	_tmp10_ = registry;
	_tmp11_ = gst_registry_feature_filter (_tmp10_, _vaapi_filter_gst_plugin_feature_filter, FALSE, NULL);
	features = _tmp11_;
	_tmp12_ = features;
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp12_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp13_;
			GstPluginFeature* feature = NULL;
			_tmp13_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
			feature = _tmp13_;
			{
				GstPluginFeature* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GstRegistry* _tmp17_;
				GstPluginFeature* _tmp18_;
				_tmp14_ = feature;
				_tmp15_ = gst_object_get_name ((GstObject*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_debug ("rygel-media-export-extract.vala:176: Removing registry feature %s", _tmp16_);
				_g_free0 (_tmp16_);
				_tmp17_ = registry;
				_tmp18_ = feature;
				gst_registry_remove_feature (_tmp17_, _tmp18_);
				_g_object_unref0 (feature);
			}
		}
	}
	_tmp19_ = in_fd;
	_tmp20_ = out_fd;
	g_message ("rygel-media-export-extract.vala:180: Started with descriptors %d (in) " \
"%d (out)", _tmp19_, _tmp20_);
	_tmp21_ = in_fd;
	_tmp22_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp21_, TRUE);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_data_input_stream_new ((GInputStream*) _tmp23_);
	_g_object_unref0 (input_stream);
	input_stream = _tmp24_;
	_g_object_unref0 (_tmp23_);
	_tmp25_ = out_fd;
	_tmp26_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp25_, TRUE);
	_g_object_unref0 (output_stream);
	output_stream = (GOutputStream*) _tmp26_;
	_tmp27_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp27_;
	run (NULL, NULL);
	_tmp28_ = loop;
	g_main_loop_run (_tmp28_);
	result = 0;
	(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
	_g_object_unref0 (registry);
	_g_option_context_free0 (ctx);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



