/* rygel-media-item.c generated by valac 0.25.3.10-37e0, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_TRACKABLE_ITEM (rygel_trackable_item_get_type ())
#define RYGEL_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItem))
#define RYGEL_IS_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_ITEM))
#define RYGEL_TRACKABLE_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItemIface))

typedef struct _RygelTrackableItem RygelTrackableItem;
typedef struct _RygelTrackableItemIface RygelTrackableItemIface;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	RygelDataSource* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelMediaItemPrivate {
	gchar* _mime_type;
	gchar* _dlna_profile;
	gint64 _size;
	gboolean _place_holder;
	gchar* _description;
};

struct _RygelTrackableItemIface {
	GTypeInterface parent_iface;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_media_item_parent_class = NULL;
extern GRegex* rygel_media_item_address_regex;
GRegex* rygel_media_item_address_regex = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_ITEM_MIME_TYPE,
	RYGEL_MEDIA_ITEM_DLNA_PROFILE,
	RYGEL_MEDIA_ITEM_SIZE,
	RYGEL_MEDIA_ITEM_PLACE_HOLDER,
	RYGEL_MEDIA_ITEM_DESCRIPTION,
	RYGEL_MEDIA_ITEM_OCM_FLAGS
};
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelDataSource* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
static RygelDataSource* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source (RygelMediaEngine* self, const gchar* uri);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_trackable_item_get_type (void) G_GNUC_CONST;
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
static void rygel_media_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_set_creator (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value);
void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteItem* rygel_serializer_add_item (RygelSerializer* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
const gchar* rygel_media_object_get_date (RygelMediaObject* self);
const gchar* rygel_media_object_get_creator (RygelMediaObject* self);
const gchar* rygel_media_item_get_description (RygelMediaItem* self);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
const gchar* rygel_media_object_get_genre (RygelMediaObject* self);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
const gchar* rygel_media_item_get_dlna_profile (RygelMediaItem* self);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_media_item_set_mime_type (RygelMediaItem* self, const gchar* value);
void rygel_media_item_set_dlna_profile (RygelMediaItem* self, const gchar* value);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
static void rygel_media_item_finalize (GObject* obj);
static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMediaItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = upnp_class;
	self = (RygelMediaItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
	return self;
}


static RygelDataSource* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
	RygelDataSource* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar* translated_uri = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaEngine* _tmp15_ = NULL;
	RygelMediaEngine* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	RygelDataSource* _tmp18_ = NULL;
	RygelDataSource* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_object_get_uris ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		result = NULL;
		return result;
	}
	_tmp5_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) self);
	translated_uri = _tmp5_;
	_tmp6_ = host_ip;
	if (_tmp6_ != NULL) {
		{
			gchar* _tmp7_ = NULL;
			GRegex* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp8_ = rygel_media_item_address_regex;
			_tmp9_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = host_ip;
			_tmp12_ = g_regex_replace_literal (_tmp8_, _tmp10_, (gssize) (-1), 0, _tmp11_, 0, &_inner_error_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp10_);
			_tmp7_ = _tmp13_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
			_tmp14_ = _tmp7_;
			_tmp7_ = NULL;
			_g_free0 (translated_uri);
			translated_uri = _tmp14_;
			_g_free0 (_tmp7_);
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (_error_);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (translated_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp15_ = rygel_media_engine_get_default ();
	_tmp16_ = _tmp15_;
	_tmp17_ = translated_uri;
	_tmp18_ = rygel_media_engine_create_data_source (_tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp16_);
	result = _tmp19_;
	_g_free0 (translated_uri);
	return result;
}


RygelDataSource* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self, host_ip);
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = rygel_media_item_streamable (self);
	if (_tmp1_) {
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
		_tmp2_ = rygel_media_item_get_size (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ <= ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_media_item_real_streamable (RygelMediaItem* self) {
	g_critical ("Type `%s' does not implement abstract method `rygel_media_item_streamable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->streamable (self);
}


gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2) {
	gint result = 0;
	RygelTranscoder* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelTranscoder* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (transcoder1 != NULL, 0);
	g_return_val_if_fail (transcoder2 != NULL, 0);
	_tmp0_ = transcoder1;
	_tmp1_ = rygel_transcoder_get_distance (_tmp0_, self);
	_tmp2_ = transcoder2;
	_tmp3_ = rygel_transcoder_get_distance (_tmp2_, self);
	result = ((gint) _tmp1_) - ((gint) _tmp3_);
	return result;
}


static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gint64 _tmp13_ = 0LL;
	gint64 _tmp14_ = 0LL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GUPnPProtocolInfo* _tmp17_ = NULL;
	GUPnPProtocolInfo* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
	g_return_val_if_fail (didl_object != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = didl_object;
	_tmp1_ = uri;
	_tmp2_ = protocol;
	_tmp3_ = import_uri;
	_tmp4_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->add_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), _tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	res = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp6_ = uri;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = self->priv->_place_holder;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = uri;
		gupnp_didl_lite_resource_set_uri (res, _tmp8_);
	} else {
		gupnp_didl_lite_resource_set_uri (res, "");
	}
	_tmp10_ = import_uri;
	if (_tmp10_ != NULL) {
		gboolean _tmp11_ = FALSE;
		_tmp11_ = self->priv->_place_holder;
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = import_uri;
		gupnp_didl_lite_resource_set_import_uri (res, _tmp12_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_ITEM)) {
		gupnp_didl_lite_resource_set_update_count (res, (guint) 0);
	}
	_tmp13_ = rygel_media_item_get_size (self);
	_tmp14_ = _tmp13_;
	gupnp_didl_lite_resource_set_size64 (res, _tmp14_);
	_tmp15_ = uri;
	_tmp16_ = protocol;
	_tmp17_ = rygel_media_item_get_protocol_info (self, _tmp15_, _tmp16_);
	_tmp18_ = _tmp17_;
	gupnp_didl_lite_resource_set_protocol_info (res, _tmp18_);
	_g_object_unref0 (_tmp18_);
	result = res;
	return result;
}


static void rygel_media_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPDIDLLiteObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	self = (RygelMediaItem*) base;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = didl_object;
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->apply_didl_lite (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), _tmp0_);
	_tmp1_ = didl_object;
	_tmp2_ = gupnp_didl_lite_object_get_creator (_tmp1_);
	rygel_media_object_set_creator ((RygelMediaObject*) self, _tmp2_);
	_tmp3_ = didl_object;
	_tmp4_ = gupnp_didl_lite_object_get_date (_tmp3_);
	_tmp5_ = _tmp4_;
	rygel_media_object_set_date ((RygelMediaObject*) self, _tmp5_);
	_tmp6_ = didl_object;
	_tmp7_ = gupnp_didl_lite_object_get_description (_tmp6_);
	_tmp8_ = _tmp7_;
	rygel_media_item_set_description (self, _tmp8_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteItem* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaContainer* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GUPnPDIDLLiteItem* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GUPnPDIDLLiteItem* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp46_ = NULL;
	gboolean _tmp52_ = FALSE;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gboolean _tmp62_ = FALSE;
	const gchar* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	RygelHTTPServer* _tmp70_ = NULL;
	GUPnPDIDLLiteItem* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = serializer;
	_tmp1_ = rygel_serializer_add_item (_tmp0_);
	didl_item = _tmp1_;
	_tmp2_ = didl_item;
	_tmp3_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp4_ = _tmp3_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp2_, _tmp4_);
	_tmp5_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		GUPnPDIDLLiteItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp7_ = didl_item;
		_tmp8_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
		_tmp9_ = _tmp8_;
		gupnp_didl_lite_item_set_ref_id (_tmp7_, _tmp9_);
	}
	_tmp10_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		GUPnPDIDLLiteItem* _tmp12_ = NULL;
		RygelMediaContainer* _tmp13_ = NULL;
		RygelMediaContainer* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp12_ = didl_item;
		_tmp13_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp14_);
		_tmp16_ = _tmp15_;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp12_, _tmp16_);
	} else {
		GUPnPDIDLLiteItem* _tmp17_ = NULL;
		_tmp17_ = didl_item;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp17_, "0");
	}
	_tmp18_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		GUPnPDIDLLiteItem* _tmp20_ = NULL;
		_tmp20_ = didl_item;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp20_, TRUE);
	} else {
		GUPnPDIDLLiteItem* _tmp21_ = NULL;
		GUPnPDIDLLiteItem* _tmp22_ = NULL;
		GUPnPOCMFlags _tmp23_ = 0;
		GUPnPOCMFlags _tmp24_ = 0;
		_tmp21_ = didl_item;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp21_, FALSE);
		_tmp22_ = didl_item;
		_tmp23_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
		_tmp24_ = _tmp23_;
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp22_, _tmp24_);
	}
	_tmp25_ = didl_item;
	_tmp26_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	_tmp27_ = _tmp26_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp25_, _tmp27_);
	_tmp28_ = didl_item;
	_tmp29_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
	_tmp30_ = _tmp29_;
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp28_, _tmp30_);
	_tmp31_ = rygel_media_object_get_date ((RygelMediaObject*) self);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != NULL) {
		GUPnPDIDLLiteItem* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		_tmp33_ = didl_item;
		_tmp34_ = rygel_media_object_get_date ((RygelMediaObject*) self);
		_tmp35_ = _tmp34_;
		gupnp_didl_lite_object_set_date ((GUPnPDIDLLiteObject*) _tmp33_, _tmp35_);
	}
	_tmp37_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		_tmp39_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
		_tmp40_ = _tmp39_;
		_tmp36_ = g_strcmp0 (_tmp40_, "") != 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GUPnPDIDLLiteContributor* creator = NULL;
		GUPnPDIDLLiteItem* _tmp41_ = NULL;
		GUPnPDIDLLiteContributor* _tmp42_ = NULL;
		GUPnPDIDLLiteContributor* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		_tmp41_ = didl_item;
		_tmp42_ = gupnp_didl_lite_object_add_creator ((GUPnPDIDLLiteObject*) _tmp41_);
		creator = _tmp42_;
		_tmp43_ = creator;
		_tmp44_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
		_tmp45_ = _tmp44_;
		gupnp_didl_lite_contributor_set_name (_tmp43_, _tmp45_);
		_g_object_unref0 (creator);
	}
	_tmp46_ = self->priv->_description;
	if (_tmp46_ != NULL) {
		GUPnPDIDLLiteItem* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		_tmp47_ = didl_item;
		_tmp48_ = self->priv->_description;
		gupnp_didl_lite_object_set_description ((GUPnPDIDLLiteObject*) _tmp47_, _tmp48_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_ITEM)) {
		GUPnPDIDLLiteItem* _tmp49_ = NULL;
		guint _tmp50_ = 0U;
		guint _tmp51_ = 0U;
		_tmp49_ = didl_item;
		_tmp50_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
		_tmp51_ = _tmp50_;
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp49_, _tmp51_);
	}
	_tmp53_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
	_tmp54_ = _tmp53_;
	if (_tmp54_ != NULL) {
		const gchar* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		_tmp55_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
		_tmp56_ = _tmp55_;
		_tmp52_ = g_strcmp0 (_tmp56_, "") != 0;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteItem* _tmp57_ = NULL;
		GUPnPDIDLLiteContributor* _tmp58_ = NULL;
		GUPnPDIDLLiteContributor* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		_tmp57_ = didl_item;
		_tmp58_ = gupnp_didl_lite_object_add_artist ((GUPnPDIDLLiteObject*) _tmp57_);
		contributor = _tmp58_;
		_tmp59_ = contributor;
		_tmp60_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
		_tmp61_ = _tmp60_;
		gupnp_didl_lite_contributor_set_name (_tmp59_, _tmp61_);
		_g_object_unref0 (contributor);
	}
	_tmp63_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
	_tmp64_ = _tmp63_;
	if (_tmp64_ != NULL) {
		const gchar* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		_tmp65_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
		_tmp66_ = _tmp65_;
		_tmp62_ = g_strcmp0 (_tmp66_, "") != 0;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		GUPnPDIDLLiteItem* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		_tmp67_ = didl_item;
		_tmp68_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
		_tmp69_ = _tmp68_;
		gupnp_didl_lite_object_set_genre ((GUPnPDIDLLiteObject*) _tmp67_, _tmp69_);
	}
	_tmp70_ = http_server;
	_tmp71_ = didl_item;
	rygel_media_item_add_proxy_resources (self, _tmp70_, _tmp71_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (didl_item);
		return NULL;
	}
	_tmp72_ = self->priv->_place_holder;
	if (!_tmp72_) {
		gchar* host_ip = NULL;
		RygelHTTPServer* _tmp73_ = NULL;
		GUPnPContext* _tmp74_ = NULL;
		const gchar* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		gboolean internal_allowed = FALSE;
		gboolean _tmp78_ = FALSE;
		RygelHTTPServer* _tmp79_ = NULL;
		GUPnPContext* _tmp80_ = NULL;
		const gchar* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		GUPnPDIDLLiteItem* _tmp84_ = NULL;
		gboolean _tmp85_ = FALSE;
		GUPnPDIDLLiteItem* _tmp86_ = NULL;
		GList* _tmp87_ = NULL;
		_tmp73_ = http_server;
		_tmp74_ = _tmp73_->context;
		_tmp75_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strdup (_tmp76_);
		host_ip = _tmp77_;
		_tmp79_ = http_server;
		_tmp80_ = _tmp79_->context;
		_tmp81_ = gssdp_client_get_interface ((GSSDPClient*) _tmp80_);
		_tmp82_ = _tmp81_;
		if (g_strcmp0 (_tmp82_, "lo") == 0) {
			_tmp78_ = TRUE;
		} else {
			const gchar* _tmp83_ = NULL;
			_tmp83_ = host_ip;
			_tmp78_ = g_strcmp0 (_tmp83_, "127.0.0.1") == 0;
		}
		internal_allowed = _tmp78_;
		_tmp84_ = didl_item;
		_tmp85_ = internal_allowed;
		rygel_media_item_add_resources (self, _tmp84_, _tmp85_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (host_ip);
			_g_object_unref0 (didl_item);
			return NULL;
		}
		_tmp86_ = didl_item;
		_tmp87_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _tmp86_);
		{
			GList* res_collection = NULL;
			GList* res_it = NULL;
			res_collection = _tmp87_;
			for (res_it = res_collection; res_it != NULL; res_it = res_it->next) {
				GUPnPDIDLLiteResource* _tmp88_ = NULL;
				GUPnPDIDLLiteResource* res = NULL;
				_tmp88_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) res_it->data);
				res = _tmp88_;
				{
					gchar* _tmp89_ = NULL;
					GRegex* _tmp90_ = NULL;
					GUPnPDIDLLiteResource* _tmp91_ = NULL;
					const gchar* _tmp92_ = NULL;
					const gchar* _tmp93_ = NULL;
					const gchar* _tmp94_ = NULL;
					gchar* _tmp95_ = NULL;
					GUPnPDIDLLiteResource* _tmp96_ = NULL;
					gchar* _tmp97_ = NULL;
					_tmp90_ = rygel_media_item_address_regex;
					_tmp91_ = res;
					_tmp92_ = gupnp_didl_lite_resource_get_uri (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = host_ip;
					_tmp95_ = g_regex_replace_literal (_tmp90_, _tmp93_, (gssize) (-1), 0, _tmp94_, 0, &_inner_error_);
					_tmp89_ = _tmp95_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (res);
						__g_list_free__g_object_unref0_0 (res_collection);
						_g_free0 (host_ip);
						_g_object_unref0 (didl_item);
						return NULL;
					}
					_tmp96_ = res;
					_tmp97_ = _tmp89_;
					_tmp89_ = NULL;
					gupnp_didl_lite_resource_set_uri (_tmp96_, _tmp97_);
					_g_free0 (_tmp89_);
					_g_object_unref0 (res);
				}
			}
			__g_list_free__g_object_unref0_0 (res_collection);
		}
		_g_free0 (host_ip);
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	return result;
}


static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelHTTPServer* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (server != NULL);
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = server;
	_tmp1_ = didl_item;
	rygel_http_server_add_proxy_resource (_tmp0_, _tmp1_, self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = self->priv->_place_holder;
	if (!_tmp2_) {
		RygelHTTPServer* _tmp3_ = NULL;
		GUPnPDIDLLiteItem* _tmp4_ = NULL;
		_tmp3_ = server;
		_tmp4_ = didl_item;
		rygel_transcode_manager_add_resources ((RygelTranscodeManager*) _tmp3_, _tmp4_, self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_proxy_resources (self, server, didl_item, error);
}


static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp0_ = NULL;
	GUPnPProtocolInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPProtocolInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GUPnPProtocolInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GUPnPProtocolInfo* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = gupnp_protocol_info_new ();
	protocol_info = _tmp0_;
	_tmp1_ = protocol_info;
	_tmp2_ = self->priv->_mime_type;
	gupnp_protocol_info_set_mime_type (_tmp1_, _tmp2_);
	_tmp3_ = protocol_info;
	_tmp4_ = self->priv->_dlna_profile;
	gupnp_protocol_info_set_dlna_profile (_tmp3_, _tmp4_);
	_tmp5_ = protocol_info;
	_tmp6_ = protocol;
	gupnp_protocol_info_set_protocol (_tmp5_, _tmp6_);
	_tmp7_ = protocol_info;
	gupnp_protocol_info_set_dlna_flags (_tmp7_, (GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
	_tmp8_ = rygel_media_item_get_size (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > ((gint64) 0)) {
		GUPnPProtocolInfo* _tmp10_ = NULL;
		_tmp10_ = protocol_info;
		gupnp_protocol_info_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_RANGE);
	}
	_tmp11_ = rygel_media_item_streamable (self);
	if (_tmp11_) {
		GUPnPProtocolInfo* _tmp12_ = NULL;
		GUPnPProtocolInfo* _tmp13_ = NULL;
		GUPnPDLNAFlags _tmp14_ = 0;
		GUPnPDLNAFlags _tmp15_ = 0;
		_tmp12_ = protocol_info;
		_tmp13_ = protocol_info;
		_tmp14_ = gupnp_protocol_info_get_dlna_flags (_tmp13_);
		_tmp15_ = _tmp14_;
		gupnp_protocol_info_set_dlna_flags (_tmp13_, _tmp15_ | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	}
	result = protocol_info;
	return result;
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
}


gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	gchar* scheme = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
	scheme = _tmp1_;
	_tmp2_ = scheme;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		_tmp3_ = _ ("Bad URI: %s");
		_tmp4_ = uri;
		_tmp5_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _tmp3_, _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (scheme);
		return NULL;
	}
	_tmp6_ = scheme;
	if (g_strcmp0 (_tmp6_, "http") == 0) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_strdup ("http-get");
		result = _tmp7_;
		_g_free0 (scheme);
		return result;
	} else {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = scheme;
		if (g_strcmp0 (_tmp8_, "file") == 0) {
			gchar* _tmp9_ = NULL;
			_tmp9_ = g_strdup ("internal");
			result = _tmp9_;
			_g_free0 (scheme);
			return result;
		} else {
			const gchar* _tmp10_ = NULL;
			_tmp10_ = scheme;
			if (g_strcmp0 (_tmp10_, "rtsp") == 0) {
				gchar* _tmp11_ = NULL;
				_tmp11_ = g_strdup ("rtsp-rtp-udp");
				result = _tmp11_;
				_g_free0 (scheme);
				return result;
			} else {
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				_tmp12_ = _ ("Failed to probe protocol for URI %s. Assuming '%s'");
				_tmp13_ = uri;
				_tmp14_ = scheme;
				g_warning (_tmp12_, _tmp13_, _tmp14_);
				result = scheme;
				return result;
			}
		}
	}
	_g_free0 (scheme);
}


static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (didl_item != NULL);
	{
		GeeList* _uri_list = NULL;
		GeeList* _tmp0_ = NULL;
		gint _uri_size = 0;
		GeeList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _uri_index = 0;
		_tmp0_ = rygel_media_object_get_uris ((RygelMediaObject*) self);
		_uri_list = _tmp0_;
		_tmp1_ = _uri_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_uri_size = _tmp3_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gchar* uri = NULL;
			GeeList* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gpointer _tmp9_ = NULL;
			gchar* protocol = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			_tmp4_ = _uri_index;
			_uri_index = _tmp4_ + 1;
			_tmp5_ = _uri_index;
			_tmp6_ = _uri_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _uri_list;
			_tmp8_ = _uri_index;
			_tmp9_ = gee_list_get (_tmp7_, _tmp8_);
			uri = (gchar*) _tmp9_;
			_tmp10_ = uri;
			_tmp11_ = rygel_media_item_get_protocol_for_uri (self, _tmp10_, &_inner_error_);
			protocol = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				_g_object_unref0 (_uri_list);
				return;
			}
			_tmp13_ = allow_internal;
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp14_ = NULL;
				_tmp14_ = protocol;
				_tmp12_ = g_strcmp0 (_tmp14_, "internal") != 0;
			}
			if (_tmp12_) {
				GUPnPDIDLLiteItem* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				GUPnPDIDLLiteResource* _tmp18_ = NULL;
				GUPnPDIDLLiteResource* _tmp19_ = NULL;
				_tmp15_ = didl_item;
				_tmp16_ = uri;
				_tmp17_ = protocol;
				_tmp18_ = rygel_media_object_add_resource ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp15_, _tmp16_, _tmp17_, NULL, &_inner_error_);
				_tmp19_ = _tmp18_;
				_g_object_unref0 (_tmp19_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (protocol);
					_g_free0 (uri);
					_g_object_unref0 (_uri_list);
					return;
				}
			}
			_g_free0 (protocol);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
}


void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resources (self, didl_item, allow_internal, error);
}


const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_mime_type (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


const gchar* rygel_media_item_get_dlna_profile (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_dlna_profile (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dlna_profile);
	self->priv->_dlna_profile = _tmp1_;
	g_object_notify ((GObject *) self, "dlna-profile");
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_size (RygelMediaItem* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ == ((gint64) 0)) {
		rygel_media_item_set_place_holder (self, TRUE);
	}
	_tmp1_ = value;
	self->priv->_size = _tmp1_;
	g_object_notify ((GObject *) self, "size");
}


gboolean rygel_media_item_get_place_holder (RygelMediaItem* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_place_holder;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_place_holder = _tmp0_;
	g_object_notify ((GObject *) self, "place-holder");
}


const gchar* rygel_media_item_get_description (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static GUPnPOCMFlags rygel_media_item_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaItem* self;
	GUPnPOCMFlags flags = 0;
	gboolean _tmp0_ = FALSE;
	GUPnPOCMFlags _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
	flags = GUPNP_OCM_FLAGS_NONE;
	_tmp0_ = self->priv->_place_holder;
	if (_tmp0_) {
		GUPnPOCMFlags _tmp1_ = 0;
		_tmp1_ = flags;
		flags = _tmp1_ | GUPNP_OCM_FLAGS_DESTROYABLE;
	} else {
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_ = NULL;
		gboolean allow_deletion = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		allow_deletion = TRUE;
		{
			gboolean _tmp3_ = FALSE;
			RygelMetaConfig* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			_tmp4_ = config;
			_tmp5_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp4_, &_inner_error_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch8_g_error;
			}
			allow_deletion = _tmp3_;
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp6_ = allow_deletion;
		if (_tmp6_) {
			GUPnPOCMFlags _tmp7_ = 0;
			_tmp7_ = flags;
			flags = _tmp7_ | GUPNP_OCM_FLAGS_DESTROYABLE;
		}
		_g_object_unref0 (config);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
		GUPnPOCMFlags _tmp8_ = 0;
		_tmp8_ = flags;
		flags = _tmp8_ | GUPNP_OCM_FLAGS_CHANGE_METADATA;
	}
	_tmp9_ = flags;
	result = _tmp9_;
	return result;
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	GError * _inner_error_ = NULL;
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
	((RygelMediaItemClass *) klass)->create_stream_source = rygel_media_item_real_create_stream_source;
	((RygelMediaItemClass *) klass)->streamable = rygel_media_item_real_streamable;
	((RygelMediaObjectClass *) klass)->add_resource = rygel_media_item_real_add_resource;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_media_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->serialize = rygel_media_item_real_serialize;
	((RygelMediaItemClass *) klass)->add_proxy_resources = rygel_media_item_real_add_proxy_resources;
	((RygelMediaItemClass *) klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
	((RygelMediaItemClass *) klass)->add_resources = rygel_media_item_real_add_resources;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_item_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_PLACE_HOLDER, g_param_spec_boolean ("place-holder", "place-holder", "place-holder", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		_tmp1_ = g_regex_escape_string ("@ADDRESS@", -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_media_item_address_regex);
		rygel_media_item_address_regex = _tmp5_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
	self->priv->_size = (gint64) (-1);
	self->priv->_place_holder = FALSE;
	self->priv->_description = NULL;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


/**
 * Represents a media item (Music, Video or Image).
 *
 * These objects correspond to items in the UPnP ContentDirectory's DIDL-Lite XML.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_MIME_TYPE:
		g_value_set_string (value, rygel_media_item_get_mime_type (self));
		break;
		case RYGEL_MEDIA_ITEM_DLNA_PROFILE:
		g_value_set_string (value, rygel_media_item_get_dlna_profile (self));
		break;
		case RYGEL_MEDIA_ITEM_SIZE:
		g_value_set_int64 (value, rygel_media_item_get_size (self));
		break;
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
		g_value_set_boolean (value, rygel_media_item_get_place_holder (self));
		break;
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
		g_value_set_string (value, rygel_media_item_get_description (self));
		break;
		case RYGEL_MEDIA_ITEM_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_MIME_TYPE:
		rygel_media_item_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_ITEM_DLNA_PROFILE:
		rygel_media_item_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_ITEM_SIZE:
		rygel_media_item_set_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
		rygel_media_item_set_place_holder (self, g_value_get_boolean (value));
		break;
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
		rygel_media_item_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



