/* rygel-plugin.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>


#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
	void (*apply_hacks) (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
};

struct _RygelPluginPrivate {
	RygelPluginCapabilities _capabilities;
	gchar* _name;
	gchar* _title;
	gchar* _description;
	gchar* _desc_path;
	gboolean _active;
	GeeArrayList* _resource_infos;
	GeeArrayList* _icon_infos;
	GeeArrayList* _default_icons;
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_plugin_parent_class = NULL;

GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
#define RYGEL_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLUGIN, RygelPluginPrivate))
enum  {
	RYGEL_PLUGIN_DUMMY_PROPERTY,
	RYGEL_PLUGIN_CAPABILITIES,
	RYGEL_PLUGIN_NAME,
	RYGEL_PLUGIN_TITLE,
	RYGEL_PLUGIN_DESCRIPTION,
	RYGEL_PLUGIN_DESC_PATH,
	RYGEL_PLUGIN_ACTIVE,
	RYGEL_PLUGIN_RESOURCE_INFOS,
	RYGEL_PLUGIN_ICON_INFOS,
	RYGEL_PLUGIN_DEFAULT_ICONS
};
#define RYGEL_PLUGIN_PNG_EXT "png"
#define RYGEL_PLUGIN_JPG_EXT "jpg"
#define RYGEL_PLUGIN_ICON_BIG "file://" BIG_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_SMALL "file://" SMALL_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_PNG_MIME "image/png"
#define RYGEL_PLUGIN_ICON_JPG_MIME "image/jpeg"
#define RYGEL_PLUGIN_ICON_PNG_DEPTH 24
#define RYGEL_PLUGIN_ICON_JPG_DEPTH 24
#define RYGEL_PLUGIN_ICON_BIG_WIDTH 120
#define RYGEL_PLUGIN_ICON_BIG_HEIGHT 120
#define RYGEL_PLUGIN_ICON_SMALL_WIDTH 48
#define RYGEL_PLUGIN_ICON_SMALL_HEIGHT 48
RygelPlugin* rygel_plugin_new (const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
RygelPlugin* rygel_plugin_construct (GType object_type, const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
static void rygel_plugin_real_constructed (GObject* base);
void rygel_plugin_set_active (RygelPlugin* self, gboolean value);
const gchar* rygel_plugin_get_title (RygelPlugin* self);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
void rygel_plugin_set_title (RygelPlugin* self, const gchar* value);
static void rygel_plugin_set_resource_infos (RygelPlugin* self, GeeArrayList* value);
static void rygel_plugin_set_icon_infos (RygelPlugin* self, GeeArrayList* value);
static void rygel_plugin_set_default_icons (RygelPlugin* self, GeeArrayList* value);
static void rygel_plugin_add_default_icon (RygelPlugin* self, const gchar* mime_type, const gchar* file_extension, const gchar* uri, gint width, gint height, gint depth);
void rygel_plugin_add_resource (RygelPlugin* self, RygelResourceInfo* resource_info);
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
void rygel_plugin_add_icon (RygelPlugin* self, RygelIconInfo* icon_info);
GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
static void rygel_plugin_real_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
RygelIconInfo* rygel_icon_info_new (const gchar* mime_type, const gchar* file_extension);
RygelIconInfo* rygel_icon_info_construct (GType object_type, const gchar* mime_type, const gchar* file_extension);
GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self);
RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self);
void rygel_plugin_set_capabilities (RygelPlugin* self, RygelPluginCapabilities value);
static void rygel_plugin_set_name (RygelPlugin* self, const gchar* value);
const gchar* rygel_plugin_get_description (RygelPlugin* self);
static void rygel_plugin_set_description (RygelPlugin* self, const gchar* value);
const gchar* rygel_plugin_get_desc_path (RygelPlugin* self);
static void rygel_plugin_set_desc_path (RygelPlugin* self, const gchar* value);
gboolean rygel_plugin_get_active (RygelPlugin* self);
static void rygel_plugin_finalize (GObject* obj);
static void _vala_rygel_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * RygelPluginCapabilities is a set of flags that represent various
 * capabilities of plugins.
 */
GType rygel_plugin_capabilities_get_type (void) {
	static volatile gsize rygel_plugin_capabilities_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_capabilities_type_id__volatile)) {
		static const GFlagsValue values[] = {{RYGEL_PLUGIN_CAPABILITIES_NONE, "RYGEL_PLUGIN_CAPABILITIES_NONE", "none"}, {RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD", "image-upload"}, {RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD", "video-upload"}, {RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD", "audio-upload"}, {RYGEL_PLUGIN_CAPABILITIES_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_UPLOAD", "upload"}, {RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES, "RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES", "track-changes"}, {RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS, "RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS", "create-containers"}, {0, NULL, NULL}};
		GType rygel_plugin_capabilities_type_id;
		rygel_plugin_capabilities_type_id = g_flags_register_static ("RygelPluginCapabilities", values);
		g_once_init_leave (&rygel_plugin_capabilities_type_id__volatile, rygel_plugin_capabilities_type_id);
	}
	return rygel_plugin_capabilities_type_id__volatile;
}


/** 
     * Create an instance of the plugin.
     *
     * @param desc_path The path of a template file for an XML description of the UPnP service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP service provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
RygelPlugin* rygel_plugin_construct (GType object_type, const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelPlugin * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelPluginCapabilities _tmp4_ = 0;
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = desc_path;
	_tmp1_ = name;
	_tmp2_ = title;
	_tmp3_ = description;
	_tmp4_ = capabilities;
	self = (RygelPlugin*) g_object_new (object_type, "desc-path", _tmp0_, "name", _tmp1_, "title", _tmp2_, "description", _tmp3_, "capabilities", _tmp4_, NULL);
	return self;
}


RygelPlugin* rygel_plugin_new (const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	return rygel_plugin_construct (RYGEL_TYPE_PLUGIN, desc_path, name, title, description, capabilities);
}


static void rygel_plugin_real_constructed (GObject* base) {
	RygelPlugin * self;
	const gchar* _tmp0_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	self = (RygelPlugin*) base;
	G_OBJECT_CLASS (rygel_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_resource_factory_get_type (), GUPnPResourceFactory));
	rygel_plugin_set_active (self, TRUE);
	_tmp0_ = self->priv->_title;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = self->priv->_name;
		rygel_plugin_set_title (self, _tmp1_);
	}
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_RESOURCE_INFO, (GBoxedCopyFunc) rygel_resource_info_ref, rygel_resource_info_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_plugin_set_resource_infos (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	rygel_plugin_set_icon_infos (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp7_ = _tmp6_;
	rygel_plugin_set_default_icons (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
}


void rygel_plugin_add_resource (RygelPlugin* self, RygelResourceInfo* resource_info) {
	GeeArrayList* _tmp0_ = NULL;
	RygelResourceInfo* _tmp1_ = NULL;
	RygelResourceInfo* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelResourceInfo* _tmp4_ = NULL;
	GType _tmp5_ = 0UL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = self->priv->_resource_infos;
	_tmp1_ = resource_info;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = resource_info;
	_tmp3_ = _tmp2_->upnp_type;
	_tmp4_ = resource_info;
	_tmp5_ = _tmp4_->type;
	gupnp_resource_factory_register_resource_type ((GUPnPResourceFactory*) self, _tmp3_, _tmp5_);
}


void rygel_plugin_add_icon (RygelPlugin* self, RygelIconInfo* icon_info) {
	GeeArrayList* _tmp0_ = NULL;
	RygelIconInfo* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	_tmp0_ = self->priv->_icon_infos;
	_tmp1_ = icon_info;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
}


static void rygel_plugin_real_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error) {
	g_return_if_fail (device != NULL);
	g_return_if_fail (description_path != NULL);
}


void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_PLUGIN_GET_CLASS (self)->apply_hacks (self, device, description_path, error);
}


static void rygel_plugin_add_default_icon (RygelPlugin* self, const gchar* mime_type, const gchar* file_extension, const gchar* uri, gint width, gint height, gint depth) {
	RygelIconInfo* icon = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelIconInfo* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GeeArrayList* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_type != NULL);
	g_return_if_fail (file_extension != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = mime_type;
	_tmp1_ = file_extension;
	_tmp2_ = rygel_icon_info_new (_tmp0_, _tmp1_);
	icon = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (icon->uri);
	icon->uri = _tmp4_;
	_tmp5_ = width;
	icon->width = _tmp5_;
	_tmp6_ = height;
	icon->height = _tmp6_;
	_tmp7_ = depth;
	icon->depth = _tmp7_;
	_tmp8_ = self->priv->_default_icons;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, icon);
	_rygel_icon_info_unref0 (icon);
}


RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self) {
	RygelPluginCapabilities result;
	RygelPluginCapabilities _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_capabilities;
	result = _tmp0_;
	return result;
}


void rygel_plugin_set_capabilities (RygelPlugin* self, RygelPluginCapabilities value) {
	RygelPluginCapabilities _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_capabilities = _tmp0_;
	g_object_notify ((GObject *) self, "capabilities");
}


const gchar* rygel_plugin_get_name (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void rygel_plugin_set_name (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const gchar* rygel_plugin_get_title (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void rygel_plugin_set_title (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


const gchar* rygel_plugin_get_description (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void rygel_plugin_set_description (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


const gchar* rygel_plugin_get_desc_path (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desc_path;
	result = _tmp0_;
	return result;
}


static void rygel_plugin_set_desc_path (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_desc_path);
	self->priv->_desc_path = _tmp1_;
	g_object_notify ((GObject *) self, "desc-path");
}


gboolean rygel_plugin_get_active (RygelPlugin* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void rygel_plugin_set_active (RygelPlugin* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_active = _tmp0_;
	g_object_notify ((GObject *) self, "active");
}


GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_resource_infos;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_plugin_set_resource_infos (RygelPlugin* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_resource_infos);
	self->priv->_resource_infos = _tmp1_;
	g_object_notify ((GObject *) self, "resource-infos");
}


GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_infos;
	result = _tmp0_;
	return result;
}


static void rygel_plugin_set_icon_infos (RygelPlugin* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_icon_infos);
	self->priv->_icon_infos = _tmp1_;
	g_object_notify ((GObject *) self, "icon-infos");
}


GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_icons;
	result = _tmp0_;
	return result;
}


static void rygel_plugin_set_default_icons (RygelPlugin* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_default_icons);
	self->priv->_default_icons = _tmp1_;
	g_object_notify ((GObject *) self, "default-icons");
}


static void rygel_plugin_class_init (RygelPluginClass * klass) {
	rygel_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPluginPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_plugin_real_constructed;
	RYGEL_PLUGIN_CLASS (klass)->apply_hacks = rygel_plugin_real_apply_hacks;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_CAPABILITIES, g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESC_PATH, g_param_spec_string ("desc-path", "desc-path", "desc-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_RESOURCE_INFOS, g_param_spec_object ("resource-infos", "resource-infos", "resource-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ICON_INFOS, g_param_spec_object ("icon-infos", "icon-infos", "icon-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DEFAULT_ICONS, g_param_spec_object ("default-icons", "default-icons", "default-icons", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_plugin_instance_init (RygelPlugin * self) {
	self->priv = RYGEL_PLUGIN_GET_PRIVATE (self);
}


static void rygel_plugin_finalize (GObject* obj) {
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLUGIN, RygelPlugin);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_desc_path);
	_g_object_unref0 (self->priv->_resource_infos);
	_g_object_unref0 (self->priv->_icon_infos);
	_g_object_unref0 (self->priv->_default_icons);
	G_OBJECT_CLASS (rygel_plugin_parent_class)->finalize (obj);
}


/**
 * This represents a Rygel plugin.
 *
 * Plugin libraries should provide an object of this
 * class or a subclass in their module_init() function.
 *
 * It is generally convenient to derive from 
 * #RygelMediaRendererPlugin from librygel-renderer,
 * or from #RygelMediaServerPlugin from librygel-server.
 *
 * Plugins may change their behaviour based on their
 * configuration. See rygel_meta_config_get_default().
 */
GType rygel_plugin_get_type (void) {
	static volatile gsize rygel_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlugin), 0, (GInstanceInitFunc) rygel_plugin_instance_init, NULL };
		GType rygel_plugin_type_id;
		rygel_plugin_type_id = g_type_register_static (gupnp_resource_factory_get_type (), "RygelPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_plugin_type_id__volatile, rygel_plugin_type_id);
	}
	return rygel_plugin_type_id__volatile;
}


static void _vala_rygel_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
	switch (property_id) {
		case RYGEL_PLUGIN_CAPABILITIES:
		g_value_set_flags (value, rygel_plugin_get_capabilities (self));
		break;
		case RYGEL_PLUGIN_NAME:
		g_value_set_string (value, rygel_plugin_get_name (self));
		break;
		case RYGEL_PLUGIN_TITLE:
		g_value_set_string (value, rygel_plugin_get_title (self));
		break;
		case RYGEL_PLUGIN_DESCRIPTION:
		g_value_set_string (value, rygel_plugin_get_description (self));
		break;
		case RYGEL_PLUGIN_DESC_PATH:
		g_value_set_string (value, rygel_plugin_get_desc_path (self));
		break;
		case RYGEL_PLUGIN_ACTIVE:
		g_value_set_boolean (value, rygel_plugin_get_active (self));
		break;
		case RYGEL_PLUGIN_RESOURCE_INFOS:
		g_value_set_object (value, rygel_plugin_get_resource_infos (self));
		break;
		case RYGEL_PLUGIN_ICON_INFOS:
		g_value_set_object (value, rygel_plugin_get_icon_infos (self));
		break;
		case RYGEL_PLUGIN_DEFAULT_ICONS:
		g_value_set_object (value, rygel_plugin_get_default_icons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
	switch (property_id) {
		case RYGEL_PLUGIN_CAPABILITIES:
		rygel_plugin_set_capabilities (self, g_value_get_flags (value));
		break;
		case RYGEL_PLUGIN_NAME:
		rygel_plugin_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_TITLE:
		rygel_plugin_set_title (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_DESCRIPTION:
		rygel_plugin_set_description (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_DESC_PATH:
		rygel_plugin_set_desc_path (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_ACTIVE:
		rygel_plugin_set_active (self, g_value_get_boolean (value));
		break;
		case RYGEL_PLUGIN_RESOURCE_INFOS:
		rygel_plugin_set_resource_infos (self, g_value_get_object (value));
		break;
		case RYGEL_PLUGIN_ICON_INFOS:
		rygel_plugin_set_icon_infos (self, g_value_get_object (value));
		break;
		case RYGEL_PLUGIN_DEFAULT_ICONS:
		rygel_plugin_set_default_icons (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



