/*
 *   retail - a logfile monitoring utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Yee ole includes (I put this all in one file for my sanity) */
#include "include.h"
int write_stfile() {
	/* we need to truncate that file; easiest way, close and reopen "w" */
	fclose(in_stat);
	in_stat = fopen(st_filename, "w");
	if(in_stat == NULL) { 
		/* we should really never be here; as we succeded opening
		 * this file w+ earlier, but nevertheless, we'll check 
		 * just to be good little coders :) */
		retval = RV_OPEN;
		perror(st_filename);
		return retval;
	}
	/* write the current values to the file */
	fprintf(in_stat, "%li:%s\n", f.ipos, f.last_line);
	/* if we're in debug mode, tell the developer what we just wrote */
	if(debug) fprintf(stderr, "write_st_file(): >%li:%s\n", f.ipos, f.last_line);
	return retval;
}

