// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package support provides the client and types for making API
// requests to AWS Support.
//
// The AWS Support API reference is intended for programmers who need detailed
// information about the AWS Support operations and data types. This service
// enables you to manage your AWS Support cases programmatically. It uses HTTP
// methods that return results in JSON format.
//
// The AWS Support service also exposes a set of Trusted Advisor (http://aws.amazon.com/premiumsupport/trustedadvisor/)
// features. You can retrieve a list of checks and their descriptions, get check
// results, specify checks to refresh, and get the refresh status of checks.
//
// The following list describes the AWS Support case management operations:
//
//    * Service names, issue categories, and available severity levels. The
//    DescribeServices and DescribeSeverityLevels operations return AWS service
//    names, service codes, service categories, and problem severity levels.
//    You use these values when you call the CreateCase operation.
//
//    * Case creation, case details, and case resolution. The CreateCase, DescribeCases,
//    DescribeAttachment, and ResolveCase operations create AWS Support cases,
//    retrieve information about cases, and resolve cases.
//
//    * Case communication. The DescribeCommunications, AddCommunicationToCase,
//    and AddAttachmentsToSet operations retrieve and add communications and
//    attachments to AWS Support cases.
//
// The following list describes the operations available from the AWS Support
// service for Trusted Advisor:
//
//    * DescribeTrustedAdvisorChecks returns the list of checks that run against
//    your AWS resources.
//
//    * Using the checkId for a specific check returned by DescribeTrustedAdvisorChecks,
//    you can call DescribeTrustedAdvisorCheckResult to obtain the results for
//    the check you specified.
//
//    * DescribeTrustedAdvisorCheckSummaries returns summarized results for
//    one or more Trusted Advisor checks.
//
//    * RefreshTrustedAdvisorCheck requests that Trusted Advisor rerun a specified
//    check.
//
//    * DescribeTrustedAdvisorCheckRefreshStatuses reports the refresh status
//    of one or more checks.
//
// For authentication of requests, AWS Support uses Signature Version 4 Signing
// Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// See About the AWS Support API (http://docs.aws.amazon.com/awssupport/latest/user/Welcome.html)
// in the AWS Support User Guide for information about how to use this service
// to create and manage your support cases, and how to call Trusted Advisor
// for results of checks on your resources.
//
// See https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15 for more information on this service.
//
// See support package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/support/
//
// Using the Client
//
// To use the client for AWS Support you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := support.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the AWS Support client Support for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/support/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.AddAttachmentsToSet(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("AddAttachmentsToSet result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.AddAttachmentsToSetWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package support
