// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package datapipeline provides the client and types for making API
// requests to AWS Data Pipeline.
//
// AWS Data Pipeline configures and manages a data-driven workflow called a
// pipeline. AWS Data Pipeline handles the details of scheduling and ensuring
// that data dependencies are met so that your application can focus on processing
// the data.
//
// AWS Data Pipeline provides a JAR implementation of a task runner called AWS
// Data Pipeline Task Runner. AWS Data Pipeline Task Runner provides logic for
// common data management scenarios, such as performing database queries and
// running data analysis using Amazon Elastic MapReduce (Amazon EMR). You can
// use AWS Data Pipeline Task Runner as your task runner, or you can write your
// own task runner to provide custom data management.
//
// AWS Data Pipeline implements two main sets of functionality. Use the first
// set to create a pipeline and define data sources, schedules, dependencies,
// and the transforms to be performed on the data. Use the second set in your
// task runner application to receive the next task ready for processing. The
// logic for performing the task, such as querying the data, running data analysis,
// or converting the data from one format to another, is contained within the
// task runner. The task runner performs the task assigned to it by the web
// service, reporting progress to the web service as it does so. When the task
// is done, the task runner reports the final success or failure of the task
// to the web service.
//
// See https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29 for more information on this service.
//
// See datapipeline package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/datapipeline/
//
// Using the Client
//
// To use the client for AWS Data Pipeline you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := datapipeline.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the AWS Data Pipeline client DataPipeline for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/datapipeline/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.ActivatePipeline(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("ActivatePipeline result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.ActivatePipelineWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package datapipeline
