// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package apigatewayiface provides an interface to enable mocking the Amazon API Gateway service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package apigatewayiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/apigateway"
)

// APIGatewayAPI provides an interface to enable mocking the
// apigateway.APIGateway service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon API Gateway.
//    func myFunc(svc apigatewayiface.APIGatewayAPI) bool {
//        // Make svc.CreateApiKey request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := apigateway.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockAPIGatewayClient struct {
//        apigatewayiface.APIGatewayAPI
//    }
//    func (m *mockAPIGatewayClient) CreateApiKey(input *apigateway.CreateApiKeyInput) (*apigateway.ApiKey, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockAPIGatewayClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type APIGatewayAPI interface {
	CreateApiKey(*apigateway.CreateApiKeyInput) (*apigateway.ApiKey, error)
	CreateApiKeyWithContext(aws.Context, *apigateway.CreateApiKeyInput, ...request.Option) (*apigateway.ApiKey, error)
	CreateApiKeyRequest(*apigateway.CreateApiKeyInput) (*request.Request, *apigateway.ApiKey)

	CreateAuthorizer(*apigateway.CreateAuthorizerInput) (*apigateway.Authorizer, error)
	CreateAuthorizerWithContext(aws.Context, *apigateway.CreateAuthorizerInput, ...request.Option) (*apigateway.Authorizer, error)
	CreateAuthorizerRequest(*apigateway.CreateAuthorizerInput) (*request.Request, *apigateway.Authorizer)

	CreateBasePathMapping(*apigateway.CreateBasePathMappingInput) (*apigateway.BasePathMapping, error)
	CreateBasePathMappingWithContext(aws.Context, *apigateway.CreateBasePathMappingInput, ...request.Option) (*apigateway.BasePathMapping, error)
	CreateBasePathMappingRequest(*apigateway.CreateBasePathMappingInput) (*request.Request, *apigateway.BasePathMapping)

	CreateDeployment(*apigateway.CreateDeploymentInput) (*apigateway.Deployment, error)
	CreateDeploymentWithContext(aws.Context, *apigateway.CreateDeploymentInput, ...request.Option) (*apigateway.Deployment, error)
	CreateDeploymentRequest(*apigateway.CreateDeploymentInput) (*request.Request, *apigateway.Deployment)

	CreateDocumentationPart(*apigateway.CreateDocumentationPartInput) (*apigateway.DocumentationPart, error)
	CreateDocumentationPartWithContext(aws.Context, *apigateway.CreateDocumentationPartInput, ...request.Option) (*apigateway.DocumentationPart, error)
	CreateDocumentationPartRequest(*apigateway.CreateDocumentationPartInput) (*request.Request, *apigateway.DocumentationPart)

	CreateDocumentationVersion(*apigateway.CreateDocumentationVersionInput) (*apigateway.DocumentationVersion, error)
	CreateDocumentationVersionWithContext(aws.Context, *apigateway.CreateDocumentationVersionInput, ...request.Option) (*apigateway.DocumentationVersion, error)
	CreateDocumentationVersionRequest(*apigateway.CreateDocumentationVersionInput) (*request.Request, *apigateway.DocumentationVersion)

	CreateDomainName(*apigateway.CreateDomainNameInput) (*apigateway.DomainName, error)
	CreateDomainNameWithContext(aws.Context, *apigateway.CreateDomainNameInput, ...request.Option) (*apigateway.DomainName, error)
	CreateDomainNameRequest(*apigateway.CreateDomainNameInput) (*request.Request, *apigateway.DomainName)

	CreateModel(*apigateway.CreateModelInput) (*apigateway.Model, error)
	CreateModelWithContext(aws.Context, *apigateway.CreateModelInput, ...request.Option) (*apigateway.Model, error)
	CreateModelRequest(*apigateway.CreateModelInput) (*request.Request, *apigateway.Model)

	CreateRequestValidator(*apigateway.CreateRequestValidatorInput) (*apigateway.UpdateRequestValidatorOutput, error)
	CreateRequestValidatorWithContext(aws.Context, *apigateway.CreateRequestValidatorInput, ...request.Option) (*apigateway.UpdateRequestValidatorOutput, error)
	CreateRequestValidatorRequest(*apigateway.CreateRequestValidatorInput) (*request.Request, *apigateway.UpdateRequestValidatorOutput)

	CreateResource(*apigateway.CreateResourceInput) (*apigateway.Resource, error)
	CreateResourceWithContext(aws.Context, *apigateway.CreateResourceInput, ...request.Option) (*apigateway.Resource, error)
	CreateResourceRequest(*apigateway.CreateResourceInput) (*request.Request, *apigateway.Resource)

	CreateRestApi(*apigateway.CreateRestApiInput) (*apigateway.RestApi, error)
	CreateRestApiWithContext(aws.Context, *apigateway.CreateRestApiInput, ...request.Option) (*apigateway.RestApi, error)
	CreateRestApiRequest(*apigateway.CreateRestApiInput) (*request.Request, *apigateway.RestApi)

	CreateStage(*apigateway.CreateStageInput) (*apigateway.Stage, error)
	CreateStageWithContext(aws.Context, *apigateway.CreateStageInput, ...request.Option) (*apigateway.Stage, error)
	CreateStageRequest(*apigateway.CreateStageInput) (*request.Request, *apigateway.Stage)

	CreateUsagePlan(*apigateway.CreateUsagePlanInput) (*apigateway.UsagePlan, error)
	CreateUsagePlanWithContext(aws.Context, *apigateway.CreateUsagePlanInput, ...request.Option) (*apigateway.UsagePlan, error)
	CreateUsagePlanRequest(*apigateway.CreateUsagePlanInput) (*request.Request, *apigateway.UsagePlan)

	CreateUsagePlanKey(*apigateway.CreateUsagePlanKeyInput) (*apigateway.UsagePlanKey, error)
	CreateUsagePlanKeyWithContext(aws.Context, *apigateway.CreateUsagePlanKeyInput, ...request.Option) (*apigateway.UsagePlanKey, error)
	CreateUsagePlanKeyRequest(*apigateway.CreateUsagePlanKeyInput) (*request.Request, *apigateway.UsagePlanKey)

	DeleteApiKey(*apigateway.DeleteApiKeyInput) (*apigateway.DeleteApiKeyOutput, error)
	DeleteApiKeyWithContext(aws.Context, *apigateway.DeleteApiKeyInput, ...request.Option) (*apigateway.DeleteApiKeyOutput, error)
	DeleteApiKeyRequest(*apigateway.DeleteApiKeyInput) (*request.Request, *apigateway.DeleteApiKeyOutput)

	DeleteAuthorizer(*apigateway.DeleteAuthorizerInput) (*apigateway.DeleteAuthorizerOutput, error)
	DeleteAuthorizerWithContext(aws.Context, *apigateway.DeleteAuthorizerInput, ...request.Option) (*apigateway.DeleteAuthorizerOutput, error)
	DeleteAuthorizerRequest(*apigateway.DeleteAuthorizerInput) (*request.Request, *apigateway.DeleteAuthorizerOutput)

	DeleteBasePathMapping(*apigateway.DeleteBasePathMappingInput) (*apigateway.DeleteBasePathMappingOutput, error)
	DeleteBasePathMappingWithContext(aws.Context, *apigateway.DeleteBasePathMappingInput, ...request.Option) (*apigateway.DeleteBasePathMappingOutput, error)
	DeleteBasePathMappingRequest(*apigateway.DeleteBasePathMappingInput) (*request.Request, *apigateway.DeleteBasePathMappingOutput)

	DeleteClientCertificate(*apigateway.DeleteClientCertificateInput) (*apigateway.DeleteClientCertificateOutput, error)
	DeleteClientCertificateWithContext(aws.Context, *apigateway.DeleteClientCertificateInput, ...request.Option) (*apigateway.DeleteClientCertificateOutput, error)
	DeleteClientCertificateRequest(*apigateway.DeleteClientCertificateInput) (*request.Request, *apigateway.DeleteClientCertificateOutput)

	DeleteDeployment(*apigateway.DeleteDeploymentInput) (*apigateway.DeleteDeploymentOutput, error)
	DeleteDeploymentWithContext(aws.Context, *apigateway.DeleteDeploymentInput, ...request.Option) (*apigateway.DeleteDeploymentOutput, error)
	DeleteDeploymentRequest(*apigateway.DeleteDeploymentInput) (*request.Request, *apigateway.DeleteDeploymentOutput)

	DeleteDocumentationPart(*apigateway.DeleteDocumentationPartInput) (*apigateway.DeleteDocumentationPartOutput, error)
	DeleteDocumentationPartWithContext(aws.Context, *apigateway.DeleteDocumentationPartInput, ...request.Option) (*apigateway.DeleteDocumentationPartOutput, error)
	DeleteDocumentationPartRequest(*apigateway.DeleteDocumentationPartInput) (*request.Request, *apigateway.DeleteDocumentationPartOutput)

	DeleteDocumentationVersion(*apigateway.DeleteDocumentationVersionInput) (*apigateway.DeleteDocumentationVersionOutput, error)
	DeleteDocumentationVersionWithContext(aws.Context, *apigateway.DeleteDocumentationVersionInput, ...request.Option) (*apigateway.DeleteDocumentationVersionOutput, error)
	DeleteDocumentationVersionRequest(*apigateway.DeleteDocumentationVersionInput) (*request.Request, *apigateway.DeleteDocumentationVersionOutput)

	DeleteDomainName(*apigateway.DeleteDomainNameInput) (*apigateway.DeleteDomainNameOutput, error)
	DeleteDomainNameWithContext(aws.Context, *apigateway.DeleteDomainNameInput, ...request.Option) (*apigateway.DeleteDomainNameOutput, error)
	DeleteDomainNameRequest(*apigateway.DeleteDomainNameInput) (*request.Request, *apigateway.DeleteDomainNameOutput)

	DeleteGatewayResponse(*apigateway.DeleteGatewayResponseInput) (*apigateway.DeleteGatewayResponseOutput, error)
	DeleteGatewayResponseWithContext(aws.Context, *apigateway.DeleteGatewayResponseInput, ...request.Option) (*apigateway.DeleteGatewayResponseOutput, error)
	DeleteGatewayResponseRequest(*apigateway.DeleteGatewayResponseInput) (*request.Request, *apigateway.DeleteGatewayResponseOutput)

	DeleteIntegration(*apigateway.DeleteIntegrationInput) (*apigateway.DeleteIntegrationOutput, error)
	DeleteIntegrationWithContext(aws.Context, *apigateway.DeleteIntegrationInput, ...request.Option) (*apigateway.DeleteIntegrationOutput, error)
	DeleteIntegrationRequest(*apigateway.DeleteIntegrationInput) (*request.Request, *apigateway.DeleteIntegrationOutput)

	DeleteIntegrationResponse(*apigateway.DeleteIntegrationResponseInput) (*apigateway.DeleteIntegrationResponseOutput, error)
	DeleteIntegrationResponseWithContext(aws.Context, *apigateway.DeleteIntegrationResponseInput, ...request.Option) (*apigateway.DeleteIntegrationResponseOutput, error)
	DeleteIntegrationResponseRequest(*apigateway.DeleteIntegrationResponseInput) (*request.Request, *apigateway.DeleteIntegrationResponseOutput)

	DeleteMethod(*apigateway.DeleteMethodInput) (*apigateway.DeleteMethodOutput, error)
	DeleteMethodWithContext(aws.Context, *apigateway.DeleteMethodInput, ...request.Option) (*apigateway.DeleteMethodOutput, error)
	DeleteMethodRequest(*apigateway.DeleteMethodInput) (*request.Request, *apigateway.DeleteMethodOutput)

	DeleteMethodResponse(*apigateway.DeleteMethodResponseInput) (*apigateway.DeleteMethodResponseOutput, error)
	DeleteMethodResponseWithContext(aws.Context, *apigateway.DeleteMethodResponseInput, ...request.Option) (*apigateway.DeleteMethodResponseOutput, error)
	DeleteMethodResponseRequest(*apigateway.DeleteMethodResponseInput) (*request.Request, *apigateway.DeleteMethodResponseOutput)

	DeleteModel(*apigateway.DeleteModelInput) (*apigateway.DeleteModelOutput, error)
	DeleteModelWithContext(aws.Context, *apigateway.DeleteModelInput, ...request.Option) (*apigateway.DeleteModelOutput, error)
	DeleteModelRequest(*apigateway.DeleteModelInput) (*request.Request, *apigateway.DeleteModelOutput)

	DeleteRequestValidator(*apigateway.DeleteRequestValidatorInput) (*apigateway.DeleteRequestValidatorOutput, error)
	DeleteRequestValidatorWithContext(aws.Context, *apigateway.DeleteRequestValidatorInput, ...request.Option) (*apigateway.DeleteRequestValidatorOutput, error)
	DeleteRequestValidatorRequest(*apigateway.DeleteRequestValidatorInput) (*request.Request, *apigateway.DeleteRequestValidatorOutput)

	DeleteResource(*apigateway.DeleteResourceInput) (*apigateway.DeleteResourceOutput, error)
	DeleteResourceWithContext(aws.Context, *apigateway.DeleteResourceInput, ...request.Option) (*apigateway.DeleteResourceOutput, error)
	DeleteResourceRequest(*apigateway.DeleteResourceInput) (*request.Request, *apigateway.DeleteResourceOutput)

	DeleteRestApi(*apigateway.DeleteRestApiInput) (*apigateway.DeleteRestApiOutput, error)
	DeleteRestApiWithContext(aws.Context, *apigateway.DeleteRestApiInput, ...request.Option) (*apigateway.DeleteRestApiOutput, error)
	DeleteRestApiRequest(*apigateway.DeleteRestApiInput) (*request.Request, *apigateway.DeleteRestApiOutput)

	DeleteStage(*apigateway.DeleteStageInput) (*apigateway.DeleteStageOutput, error)
	DeleteStageWithContext(aws.Context, *apigateway.DeleteStageInput, ...request.Option) (*apigateway.DeleteStageOutput, error)
	DeleteStageRequest(*apigateway.DeleteStageInput) (*request.Request, *apigateway.DeleteStageOutput)

	DeleteUsagePlan(*apigateway.DeleteUsagePlanInput) (*apigateway.DeleteUsagePlanOutput, error)
	DeleteUsagePlanWithContext(aws.Context, *apigateway.DeleteUsagePlanInput, ...request.Option) (*apigateway.DeleteUsagePlanOutput, error)
	DeleteUsagePlanRequest(*apigateway.DeleteUsagePlanInput) (*request.Request, *apigateway.DeleteUsagePlanOutput)

	DeleteUsagePlanKey(*apigateway.DeleteUsagePlanKeyInput) (*apigateway.DeleteUsagePlanKeyOutput, error)
	DeleteUsagePlanKeyWithContext(aws.Context, *apigateway.DeleteUsagePlanKeyInput, ...request.Option) (*apigateway.DeleteUsagePlanKeyOutput, error)
	DeleteUsagePlanKeyRequest(*apigateway.DeleteUsagePlanKeyInput) (*request.Request, *apigateway.DeleteUsagePlanKeyOutput)

	FlushStageAuthorizersCache(*apigateway.FlushStageAuthorizersCacheInput) (*apigateway.FlushStageAuthorizersCacheOutput, error)
	FlushStageAuthorizersCacheWithContext(aws.Context, *apigateway.FlushStageAuthorizersCacheInput, ...request.Option) (*apigateway.FlushStageAuthorizersCacheOutput, error)
	FlushStageAuthorizersCacheRequest(*apigateway.FlushStageAuthorizersCacheInput) (*request.Request, *apigateway.FlushStageAuthorizersCacheOutput)

	FlushStageCache(*apigateway.FlushStageCacheInput) (*apigateway.FlushStageCacheOutput, error)
	FlushStageCacheWithContext(aws.Context, *apigateway.FlushStageCacheInput, ...request.Option) (*apigateway.FlushStageCacheOutput, error)
	FlushStageCacheRequest(*apigateway.FlushStageCacheInput) (*request.Request, *apigateway.FlushStageCacheOutput)

	GenerateClientCertificate(*apigateway.GenerateClientCertificateInput) (*apigateway.ClientCertificate, error)
	GenerateClientCertificateWithContext(aws.Context, *apigateway.GenerateClientCertificateInput, ...request.Option) (*apigateway.ClientCertificate, error)
	GenerateClientCertificateRequest(*apigateway.GenerateClientCertificateInput) (*request.Request, *apigateway.ClientCertificate)

	GetAccount(*apigateway.GetAccountInput) (*apigateway.Account, error)
	GetAccountWithContext(aws.Context, *apigateway.GetAccountInput, ...request.Option) (*apigateway.Account, error)
	GetAccountRequest(*apigateway.GetAccountInput) (*request.Request, *apigateway.Account)

	GetApiKey(*apigateway.GetApiKeyInput) (*apigateway.ApiKey, error)
	GetApiKeyWithContext(aws.Context, *apigateway.GetApiKeyInput, ...request.Option) (*apigateway.ApiKey, error)
	GetApiKeyRequest(*apigateway.GetApiKeyInput) (*request.Request, *apigateway.ApiKey)

	GetApiKeys(*apigateway.GetApiKeysInput) (*apigateway.GetApiKeysOutput, error)
	GetApiKeysWithContext(aws.Context, *apigateway.GetApiKeysInput, ...request.Option) (*apigateway.GetApiKeysOutput, error)
	GetApiKeysRequest(*apigateway.GetApiKeysInput) (*request.Request, *apigateway.GetApiKeysOutput)

	GetApiKeysPages(*apigateway.GetApiKeysInput, func(*apigateway.GetApiKeysOutput, bool) bool) error
	GetApiKeysPagesWithContext(aws.Context, *apigateway.GetApiKeysInput, func(*apigateway.GetApiKeysOutput, bool) bool, ...request.Option) error

	GetAuthorizer(*apigateway.GetAuthorizerInput) (*apigateway.Authorizer, error)
	GetAuthorizerWithContext(aws.Context, *apigateway.GetAuthorizerInput, ...request.Option) (*apigateway.Authorizer, error)
	GetAuthorizerRequest(*apigateway.GetAuthorizerInput) (*request.Request, *apigateway.Authorizer)

	GetAuthorizers(*apigateway.GetAuthorizersInput) (*apigateway.GetAuthorizersOutput, error)
	GetAuthorizersWithContext(aws.Context, *apigateway.GetAuthorizersInput, ...request.Option) (*apigateway.GetAuthorizersOutput, error)
	GetAuthorizersRequest(*apigateway.GetAuthorizersInput) (*request.Request, *apigateway.GetAuthorizersOutput)

	GetBasePathMapping(*apigateway.GetBasePathMappingInput) (*apigateway.BasePathMapping, error)
	GetBasePathMappingWithContext(aws.Context, *apigateway.GetBasePathMappingInput, ...request.Option) (*apigateway.BasePathMapping, error)
	GetBasePathMappingRequest(*apigateway.GetBasePathMappingInput) (*request.Request, *apigateway.BasePathMapping)

	GetBasePathMappings(*apigateway.GetBasePathMappingsInput) (*apigateway.GetBasePathMappingsOutput, error)
	GetBasePathMappingsWithContext(aws.Context, *apigateway.GetBasePathMappingsInput, ...request.Option) (*apigateway.GetBasePathMappingsOutput, error)
	GetBasePathMappingsRequest(*apigateway.GetBasePathMappingsInput) (*request.Request, *apigateway.GetBasePathMappingsOutput)

	GetBasePathMappingsPages(*apigateway.GetBasePathMappingsInput, func(*apigateway.GetBasePathMappingsOutput, bool) bool) error
	GetBasePathMappingsPagesWithContext(aws.Context, *apigateway.GetBasePathMappingsInput, func(*apigateway.GetBasePathMappingsOutput, bool) bool, ...request.Option) error

	GetClientCertificate(*apigateway.GetClientCertificateInput) (*apigateway.ClientCertificate, error)
	GetClientCertificateWithContext(aws.Context, *apigateway.GetClientCertificateInput, ...request.Option) (*apigateway.ClientCertificate, error)
	GetClientCertificateRequest(*apigateway.GetClientCertificateInput) (*request.Request, *apigateway.ClientCertificate)

	GetClientCertificates(*apigateway.GetClientCertificatesInput) (*apigateway.GetClientCertificatesOutput, error)
	GetClientCertificatesWithContext(aws.Context, *apigateway.GetClientCertificatesInput, ...request.Option) (*apigateway.GetClientCertificatesOutput, error)
	GetClientCertificatesRequest(*apigateway.GetClientCertificatesInput) (*request.Request, *apigateway.GetClientCertificatesOutput)

	GetClientCertificatesPages(*apigateway.GetClientCertificatesInput, func(*apigateway.GetClientCertificatesOutput, bool) bool) error
	GetClientCertificatesPagesWithContext(aws.Context, *apigateway.GetClientCertificatesInput, func(*apigateway.GetClientCertificatesOutput, bool) bool, ...request.Option) error

	GetDeployment(*apigateway.GetDeploymentInput) (*apigateway.Deployment, error)
	GetDeploymentWithContext(aws.Context, *apigateway.GetDeploymentInput, ...request.Option) (*apigateway.Deployment, error)
	GetDeploymentRequest(*apigateway.GetDeploymentInput) (*request.Request, *apigateway.Deployment)

	GetDeployments(*apigateway.GetDeploymentsInput) (*apigateway.GetDeploymentsOutput, error)
	GetDeploymentsWithContext(aws.Context, *apigateway.GetDeploymentsInput, ...request.Option) (*apigateway.GetDeploymentsOutput, error)
	GetDeploymentsRequest(*apigateway.GetDeploymentsInput) (*request.Request, *apigateway.GetDeploymentsOutput)

	GetDeploymentsPages(*apigateway.GetDeploymentsInput, func(*apigateway.GetDeploymentsOutput, bool) bool) error
	GetDeploymentsPagesWithContext(aws.Context, *apigateway.GetDeploymentsInput, func(*apigateway.GetDeploymentsOutput, bool) bool, ...request.Option) error

	GetDocumentationPart(*apigateway.GetDocumentationPartInput) (*apigateway.DocumentationPart, error)
	GetDocumentationPartWithContext(aws.Context, *apigateway.GetDocumentationPartInput, ...request.Option) (*apigateway.DocumentationPart, error)
	GetDocumentationPartRequest(*apigateway.GetDocumentationPartInput) (*request.Request, *apigateway.DocumentationPart)

	GetDocumentationParts(*apigateway.GetDocumentationPartsInput) (*apigateway.GetDocumentationPartsOutput, error)
	GetDocumentationPartsWithContext(aws.Context, *apigateway.GetDocumentationPartsInput, ...request.Option) (*apigateway.GetDocumentationPartsOutput, error)
	GetDocumentationPartsRequest(*apigateway.GetDocumentationPartsInput) (*request.Request, *apigateway.GetDocumentationPartsOutput)

	GetDocumentationVersion(*apigateway.GetDocumentationVersionInput) (*apigateway.DocumentationVersion, error)
	GetDocumentationVersionWithContext(aws.Context, *apigateway.GetDocumentationVersionInput, ...request.Option) (*apigateway.DocumentationVersion, error)
	GetDocumentationVersionRequest(*apigateway.GetDocumentationVersionInput) (*request.Request, *apigateway.DocumentationVersion)

	GetDocumentationVersions(*apigateway.GetDocumentationVersionsInput) (*apigateway.GetDocumentationVersionsOutput, error)
	GetDocumentationVersionsWithContext(aws.Context, *apigateway.GetDocumentationVersionsInput, ...request.Option) (*apigateway.GetDocumentationVersionsOutput, error)
	GetDocumentationVersionsRequest(*apigateway.GetDocumentationVersionsInput) (*request.Request, *apigateway.GetDocumentationVersionsOutput)

	GetDomainName(*apigateway.GetDomainNameInput) (*apigateway.DomainName, error)
	GetDomainNameWithContext(aws.Context, *apigateway.GetDomainNameInput, ...request.Option) (*apigateway.DomainName, error)
	GetDomainNameRequest(*apigateway.GetDomainNameInput) (*request.Request, *apigateway.DomainName)

	GetDomainNames(*apigateway.GetDomainNamesInput) (*apigateway.GetDomainNamesOutput, error)
	GetDomainNamesWithContext(aws.Context, *apigateway.GetDomainNamesInput, ...request.Option) (*apigateway.GetDomainNamesOutput, error)
	GetDomainNamesRequest(*apigateway.GetDomainNamesInput) (*request.Request, *apigateway.GetDomainNamesOutput)

	GetDomainNamesPages(*apigateway.GetDomainNamesInput, func(*apigateway.GetDomainNamesOutput, bool) bool) error
	GetDomainNamesPagesWithContext(aws.Context, *apigateway.GetDomainNamesInput, func(*apigateway.GetDomainNamesOutput, bool) bool, ...request.Option) error

	GetExport(*apigateway.GetExportInput) (*apigateway.GetExportOutput, error)
	GetExportWithContext(aws.Context, *apigateway.GetExportInput, ...request.Option) (*apigateway.GetExportOutput, error)
	GetExportRequest(*apigateway.GetExportInput) (*request.Request, *apigateway.GetExportOutput)

	GetGatewayResponse(*apigateway.GetGatewayResponseInput) (*apigateway.UpdateGatewayResponseOutput, error)
	GetGatewayResponseWithContext(aws.Context, *apigateway.GetGatewayResponseInput, ...request.Option) (*apigateway.UpdateGatewayResponseOutput, error)
	GetGatewayResponseRequest(*apigateway.GetGatewayResponseInput) (*request.Request, *apigateway.UpdateGatewayResponseOutput)

	GetGatewayResponses(*apigateway.GetGatewayResponsesInput) (*apigateway.GetGatewayResponsesOutput, error)
	GetGatewayResponsesWithContext(aws.Context, *apigateway.GetGatewayResponsesInput, ...request.Option) (*apigateway.GetGatewayResponsesOutput, error)
	GetGatewayResponsesRequest(*apigateway.GetGatewayResponsesInput) (*request.Request, *apigateway.GetGatewayResponsesOutput)

	GetIntegration(*apigateway.GetIntegrationInput) (*apigateway.Integration, error)
	GetIntegrationWithContext(aws.Context, *apigateway.GetIntegrationInput, ...request.Option) (*apigateway.Integration, error)
	GetIntegrationRequest(*apigateway.GetIntegrationInput) (*request.Request, *apigateway.Integration)

	GetIntegrationResponse(*apigateway.GetIntegrationResponseInput) (*apigateway.IntegrationResponse, error)
	GetIntegrationResponseWithContext(aws.Context, *apigateway.GetIntegrationResponseInput, ...request.Option) (*apigateway.IntegrationResponse, error)
	GetIntegrationResponseRequest(*apigateway.GetIntegrationResponseInput) (*request.Request, *apigateway.IntegrationResponse)

	GetMethod(*apigateway.GetMethodInput) (*apigateway.Method, error)
	GetMethodWithContext(aws.Context, *apigateway.GetMethodInput, ...request.Option) (*apigateway.Method, error)
	GetMethodRequest(*apigateway.GetMethodInput) (*request.Request, *apigateway.Method)

	GetMethodResponse(*apigateway.GetMethodResponseInput) (*apigateway.MethodResponse, error)
	GetMethodResponseWithContext(aws.Context, *apigateway.GetMethodResponseInput, ...request.Option) (*apigateway.MethodResponse, error)
	GetMethodResponseRequest(*apigateway.GetMethodResponseInput) (*request.Request, *apigateway.MethodResponse)

	GetModel(*apigateway.GetModelInput) (*apigateway.Model, error)
	GetModelWithContext(aws.Context, *apigateway.GetModelInput, ...request.Option) (*apigateway.Model, error)
	GetModelRequest(*apigateway.GetModelInput) (*request.Request, *apigateway.Model)

	GetModelTemplate(*apigateway.GetModelTemplateInput) (*apigateway.GetModelTemplateOutput, error)
	GetModelTemplateWithContext(aws.Context, *apigateway.GetModelTemplateInput, ...request.Option) (*apigateway.GetModelTemplateOutput, error)
	GetModelTemplateRequest(*apigateway.GetModelTemplateInput) (*request.Request, *apigateway.GetModelTemplateOutput)

	GetModels(*apigateway.GetModelsInput) (*apigateway.GetModelsOutput, error)
	GetModelsWithContext(aws.Context, *apigateway.GetModelsInput, ...request.Option) (*apigateway.GetModelsOutput, error)
	GetModelsRequest(*apigateway.GetModelsInput) (*request.Request, *apigateway.GetModelsOutput)

	GetModelsPages(*apigateway.GetModelsInput, func(*apigateway.GetModelsOutput, bool) bool) error
	GetModelsPagesWithContext(aws.Context, *apigateway.GetModelsInput, func(*apigateway.GetModelsOutput, bool) bool, ...request.Option) error

	GetRequestValidator(*apigateway.GetRequestValidatorInput) (*apigateway.UpdateRequestValidatorOutput, error)
	GetRequestValidatorWithContext(aws.Context, *apigateway.GetRequestValidatorInput, ...request.Option) (*apigateway.UpdateRequestValidatorOutput, error)
	GetRequestValidatorRequest(*apigateway.GetRequestValidatorInput) (*request.Request, *apigateway.UpdateRequestValidatorOutput)

	GetRequestValidators(*apigateway.GetRequestValidatorsInput) (*apigateway.GetRequestValidatorsOutput, error)
	GetRequestValidatorsWithContext(aws.Context, *apigateway.GetRequestValidatorsInput, ...request.Option) (*apigateway.GetRequestValidatorsOutput, error)
	GetRequestValidatorsRequest(*apigateway.GetRequestValidatorsInput) (*request.Request, *apigateway.GetRequestValidatorsOutput)

	GetResource(*apigateway.GetResourceInput) (*apigateway.Resource, error)
	GetResourceWithContext(aws.Context, *apigateway.GetResourceInput, ...request.Option) (*apigateway.Resource, error)
	GetResourceRequest(*apigateway.GetResourceInput) (*request.Request, *apigateway.Resource)

	GetResources(*apigateway.GetResourcesInput) (*apigateway.GetResourcesOutput, error)
	GetResourcesWithContext(aws.Context, *apigateway.GetResourcesInput, ...request.Option) (*apigateway.GetResourcesOutput, error)
	GetResourcesRequest(*apigateway.GetResourcesInput) (*request.Request, *apigateway.GetResourcesOutput)

	GetResourcesPages(*apigateway.GetResourcesInput, func(*apigateway.GetResourcesOutput, bool) bool) error
	GetResourcesPagesWithContext(aws.Context, *apigateway.GetResourcesInput, func(*apigateway.GetResourcesOutput, bool) bool, ...request.Option) error

	GetRestApi(*apigateway.GetRestApiInput) (*apigateway.RestApi, error)
	GetRestApiWithContext(aws.Context, *apigateway.GetRestApiInput, ...request.Option) (*apigateway.RestApi, error)
	GetRestApiRequest(*apigateway.GetRestApiInput) (*request.Request, *apigateway.RestApi)

	GetRestApis(*apigateway.GetRestApisInput) (*apigateway.GetRestApisOutput, error)
	GetRestApisWithContext(aws.Context, *apigateway.GetRestApisInput, ...request.Option) (*apigateway.GetRestApisOutput, error)
	GetRestApisRequest(*apigateway.GetRestApisInput) (*request.Request, *apigateway.GetRestApisOutput)

	GetRestApisPages(*apigateway.GetRestApisInput, func(*apigateway.GetRestApisOutput, bool) bool) error
	GetRestApisPagesWithContext(aws.Context, *apigateway.GetRestApisInput, func(*apigateway.GetRestApisOutput, bool) bool, ...request.Option) error

	GetSdk(*apigateway.GetSdkInput) (*apigateway.GetSdkOutput, error)
	GetSdkWithContext(aws.Context, *apigateway.GetSdkInput, ...request.Option) (*apigateway.GetSdkOutput, error)
	GetSdkRequest(*apigateway.GetSdkInput) (*request.Request, *apigateway.GetSdkOutput)

	GetSdkType(*apigateway.GetSdkTypeInput) (*apigateway.SdkType, error)
	GetSdkTypeWithContext(aws.Context, *apigateway.GetSdkTypeInput, ...request.Option) (*apigateway.SdkType, error)
	GetSdkTypeRequest(*apigateway.GetSdkTypeInput) (*request.Request, *apigateway.SdkType)

	GetSdkTypes(*apigateway.GetSdkTypesInput) (*apigateway.GetSdkTypesOutput, error)
	GetSdkTypesWithContext(aws.Context, *apigateway.GetSdkTypesInput, ...request.Option) (*apigateway.GetSdkTypesOutput, error)
	GetSdkTypesRequest(*apigateway.GetSdkTypesInput) (*request.Request, *apigateway.GetSdkTypesOutput)

	GetStage(*apigateway.GetStageInput) (*apigateway.Stage, error)
	GetStageWithContext(aws.Context, *apigateway.GetStageInput, ...request.Option) (*apigateway.Stage, error)
	GetStageRequest(*apigateway.GetStageInput) (*request.Request, *apigateway.Stage)

	GetStages(*apigateway.GetStagesInput) (*apigateway.GetStagesOutput, error)
	GetStagesWithContext(aws.Context, *apigateway.GetStagesInput, ...request.Option) (*apigateway.GetStagesOutput, error)
	GetStagesRequest(*apigateway.GetStagesInput) (*request.Request, *apigateway.GetStagesOutput)

	GetUsage(*apigateway.GetUsageInput) (*apigateway.Usage, error)
	GetUsageWithContext(aws.Context, *apigateway.GetUsageInput, ...request.Option) (*apigateway.Usage, error)
	GetUsageRequest(*apigateway.GetUsageInput) (*request.Request, *apigateway.Usage)

	GetUsagePages(*apigateway.GetUsageInput, func(*apigateway.Usage, bool) bool) error
	GetUsagePagesWithContext(aws.Context, *apigateway.GetUsageInput, func(*apigateway.Usage, bool) bool, ...request.Option) error

	GetUsagePlan(*apigateway.GetUsagePlanInput) (*apigateway.UsagePlan, error)
	GetUsagePlanWithContext(aws.Context, *apigateway.GetUsagePlanInput, ...request.Option) (*apigateway.UsagePlan, error)
	GetUsagePlanRequest(*apigateway.GetUsagePlanInput) (*request.Request, *apigateway.UsagePlan)

	GetUsagePlanKey(*apigateway.GetUsagePlanKeyInput) (*apigateway.UsagePlanKey, error)
	GetUsagePlanKeyWithContext(aws.Context, *apigateway.GetUsagePlanKeyInput, ...request.Option) (*apigateway.UsagePlanKey, error)
	GetUsagePlanKeyRequest(*apigateway.GetUsagePlanKeyInput) (*request.Request, *apigateway.UsagePlanKey)

	GetUsagePlanKeys(*apigateway.GetUsagePlanKeysInput) (*apigateway.GetUsagePlanKeysOutput, error)
	GetUsagePlanKeysWithContext(aws.Context, *apigateway.GetUsagePlanKeysInput, ...request.Option) (*apigateway.GetUsagePlanKeysOutput, error)
	GetUsagePlanKeysRequest(*apigateway.GetUsagePlanKeysInput) (*request.Request, *apigateway.GetUsagePlanKeysOutput)

	GetUsagePlanKeysPages(*apigateway.GetUsagePlanKeysInput, func(*apigateway.GetUsagePlanKeysOutput, bool) bool) error
	GetUsagePlanKeysPagesWithContext(aws.Context, *apigateway.GetUsagePlanKeysInput, func(*apigateway.GetUsagePlanKeysOutput, bool) bool, ...request.Option) error

	GetUsagePlans(*apigateway.GetUsagePlansInput) (*apigateway.GetUsagePlansOutput, error)
	GetUsagePlansWithContext(aws.Context, *apigateway.GetUsagePlansInput, ...request.Option) (*apigateway.GetUsagePlansOutput, error)
	GetUsagePlansRequest(*apigateway.GetUsagePlansInput) (*request.Request, *apigateway.GetUsagePlansOutput)

	GetUsagePlansPages(*apigateway.GetUsagePlansInput, func(*apigateway.GetUsagePlansOutput, bool) bool) error
	GetUsagePlansPagesWithContext(aws.Context, *apigateway.GetUsagePlansInput, func(*apigateway.GetUsagePlansOutput, bool) bool, ...request.Option) error

	ImportApiKeys(*apigateway.ImportApiKeysInput) (*apigateway.ImportApiKeysOutput, error)
	ImportApiKeysWithContext(aws.Context, *apigateway.ImportApiKeysInput, ...request.Option) (*apigateway.ImportApiKeysOutput, error)
	ImportApiKeysRequest(*apigateway.ImportApiKeysInput) (*request.Request, *apigateway.ImportApiKeysOutput)

	ImportDocumentationParts(*apigateway.ImportDocumentationPartsInput) (*apigateway.ImportDocumentationPartsOutput, error)
	ImportDocumentationPartsWithContext(aws.Context, *apigateway.ImportDocumentationPartsInput, ...request.Option) (*apigateway.ImportDocumentationPartsOutput, error)
	ImportDocumentationPartsRequest(*apigateway.ImportDocumentationPartsInput) (*request.Request, *apigateway.ImportDocumentationPartsOutput)

	ImportRestApi(*apigateway.ImportRestApiInput) (*apigateway.RestApi, error)
	ImportRestApiWithContext(aws.Context, *apigateway.ImportRestApiInput, ...request.Option) (*apigateway.RestApi, error)
	ImportRestApiRequest(*apigateway.ImportRestApiInput) (*request.Request, *apigateway.RestApi)

	PutGatewayResponse(*apigateway.PutGatewayResponseInput) (*apigateway.UpdateGatewayResponseOutput, error)
	PutGatewayResponseWithContext(aws.Context, *apigateway.PutGatewayResponseInput, ...request.Option) (*apigateway.UpdateGatewayResponseOutput, error)
	PutGatewayResponseRequest(*apigateway.PutGatewayResponseInput) (*request.Request, *apigateway.UpdateGatewayResponseOutput)

	PutIntegration(*apigateway.PutIntegrationInput) (*apigateway.Integration, error)
	PutIntegrationWithContext(aws.Context, *apigateway.PutIntegrationInput, ...request.Option) (*apigateway.Integration, error)
	PutIntegrationRequest(*apigateway.PutIntegrationInput) (*request.Request, *apigateway.Integration)

	PutIntegrationResponse(*apigateway.PutIntegrationResponseInput) (*apigateway.IntegrationResponse, error)
	PutIntegrationResponseWithContext(aws.Context, *apigateway.PutIntegrationResponseInput, ...request.Option) (*apigateway.IntegrationResponse, error)
	PutIntegrationResponseRequest(*apigateway.PutIntegrationResponseInput) (*request.Request, *apigateway.IntegrationResponse)

	PutMethod(*apigateway.PutMethodInput) (*apigateway.Method, error)
	PutMethodWithContext(aws.Context, *apigateway.PutMethodInput, ...request.Option) (*apigateway.Method, error)
	PutMethodRequest(*apigateway.PutMethodInput) (*request.Request, *apigateway.Method)

	PutMethodResponse(*apigateway.PutMethodResponseInput) (*apigateway.MethodResponse, error)
	PutMethodResponseWithContext(aws.Context, *apigateway.PutMethodResponseInput, ...request.Option) (*apigateway.MethodResponse, error)
	PutMethodResponseRequest(*apigateway.PutMethodResponseInput) (*request.Request, *apigateway.MethodResponse)

	PutRestApi(*apigateway.PutRestApiInput) (*apigateway.RestApi, error)
	PutRestApiWithContext(aws.Context, *apigateway.PutRestApiInput, ...request.Option) (*apigateway.RestApi, error)
	PutRestApiRequest(*apigateway.PutRestApiInput) (*request.Request, *apigateway.RestApi)

	TestInvokeAuthorizer(*apigateway.TestInvokeAuthorizerInput) (*apigateway.TestInvokeAuthorizerOutput, error)
	TestInvokeAuthorizerWithContext(aws.Context, *apigateway.TestInvokeAuthorizerInput, ...request.Option) (*apigateway.TestInvokeAuthorizerOutput, error)
	TestInvokeAuthorizerRequest(*apigateway.TestInvokeAuthorizerInput) (*request.Request, *apigateway.TestInvokeAuthorizerOutput)

	TestInvokeMethod(*apigateway.TestInvokeMethodInput) (*apigateway.TestInvokeMethodOutput, error)
	TestInvokeMethodWithContext(aws.Context, *apigateway.TestInvokeMethodInput, ...request.Option) (*apigateway.TestInvokeMethodOutput, error)
	TestInvokeMethodRequest(*apigateway.TestInvokeMethodInput) (*request.Request, *apigateway.TestInvokeMethodOutput)

	UpdateAccount(*apigateway.UpdateAccountInput) (*apigateway.Account, error)
	UpdateAccountWithContext(aws.Context, *apigateway.UpdateAccountInput, ...request.Option) (*apigateway.Account, error)
	UpdateAccountRequest(*apigateway.UpdateAccountInput) (*request.Request, *apigateway.Account)

	UpdateApiKey(*apigateway.UpdateApiKeyInput) (*apigateway.ApiKey, error)
	UpdateApiKeyWithContext(aws.Context, *apigateway.UpdateApiKeyInput, ...request.Option) (*apigateway.ApiKey, error)
	UpdateApiKeyRequest(*apigateway.UpdateApiKeyInput) (*request.Request, *apigateway.ApiKey)

	UpdateAuthorizer(*apigateway.UpdateAuthorizerInput) (*apigateway.Authorizer, error)
	UpdateAuthorizerWithContext(aws.Context, *apigateway.UpdateAuthorizerInput, ...request.Option) (*apigateway.Authorizer, error)
	UpdateAuthorizerRequest(*apigateway.UpdateAuthorizerInput) (*request.Request, *apigateway.Authorizer)

	UpdateBasePathMapping(*apigateway.UpdateBasePathMappingInput) (*apigateway.BasePathMapping, error)
	UpdateBasePathMappingWithContext(aws.Context, *apigateway.UpdateBasePathMappingInput, ...request.Option) (*apigateway.BasePathMapping, error)
	UpdateBasePathMappingRequest(*apigateway.UpdateBasePathMappingInput) (*request.Request, *apigateway.BasePathMapping)

	UpdateClientCertificate(*apigateway.UpdateClientCertificateInput) (*apigateway.ClientCertificate, error)
	UpdateClientCertificateWithContext(aws.Context, *apigateway.UpdateClientCertificateInput, ...request.Option) (*apigateway.ClientCertificate, error)
	UpdateClientCertificateRequest(*apigateway.UpdateClientCertificateInput) (*request.Request, *apigateway.ClientCertificate)

	UpdateDeployment(*apigateway.UpdateDeploymentInput) (*apigateway.Deployment, error)
	UpdateDeploymentWithContext(aws.Context, *apigateway.UpdateDeploymentInput, ...request.Option) (*apigateway.Deployment, error)
	UpdateDeploymentRequest(*apigateway.UpdateDeploymentInput) (*request.Request, *apigateway.Deployment)

	UpdateDocumentationPart(*apigateway.UpdateDocumentationPartInput) (*apigateway.DocumentationPart, error)
	UpdateDocumentationPartWithContext(aws.Context, *apigateway.UpdateDocumentationPartInput, ...request.Option) (*apigateway.DocumentationPart, error)
	UpdateDocumentationPartRequest(*apigateway.UpdateDocumentationPartInput) (*request.Request, *apigateway.DocumentationPart)

	UpdateDocumentationVersion(*apigateway.UpdateDocumentationVersionInput) (*apigateway.DocumentationVersion, error)
	UpdateDocumentationVersionWithContext(aws.Context, *apigateway.UpdateDocumentationVersionInput, ...request.Option) (*apigateway.DocumentationVersion, error)
	UpdateDocumentationVersionRequest(*apigateway.UpdateDocumentationVersionInput) (*request.Request, *apigateway.DocumentationVersion)

	UpdateDomainName(*apigateway.UpdateDomainNameInput) (*apigateway.DomainName, error)
	UpdateDomainNameWithContext(aws.Context, *apigateway.UpdateDomainNameInput, ...request.Option) (*apigateway.DomainName, error)
	UpdateDomainNameRequest(*apigateway.UpdateDomainNameInput) (*request.Request, *apigateway.DomainName)

	UpdateGatewayResponse(*apigateway.UpdateGatewayResponseInput) (*apigateway.UpdateGatewayResponseOutput, error)
	UpdateGatewayResponseWithContext(aws.Context, *apigateway.UpdateGatewayResponseInput, ...request.Option) (*apigateway.UpdateGatewayResponseOutput, error)
	UpdateGatewayResponseRequest(*apigateway.UpdateGatewayResponseInput) (*request.Request, *apigateway.UpdateGatewayResponseOutput)

	UpdateIntegration(*apigateway.UpdateIntegrationInput) (*apigateway.Integration, error)
	UpdateIntegrationWithContext(aws.Context, *apigateway.UpdateIntegrationInput, ...request.Option) (*apigateway.Integration, error)
	UpdateIntegrationRequest(*apigateway.UpdateIntegrationInput) (*request.Request, *apigateway.Integration)

	UpdateIntegrationResponse(*apigateway.UpdateIntegrationResponseInput) (*apigateway.IntegrationResponse, error)
	UpdateIntegrationResponseWithContext(aws.Context, *apigateway.UpdateIntegrationResponseInput, ...request.Option) (*apigateway.IntegrationResponse, error)
	UpdateIntegrationResponseRequest(*apigateway.UpdateIntegrationResponseInput) (*request.Request, *apigateway.IntegrationResponse)

	UpdateMethod(*apigateway.UpdateMethodInput) (*apigateway.Method, error)
	UpdateMethodWithContext(aws.Context, *apigateway.UpdateMethodInput, ...request.Option) (*apigateway.Method, error)
	UpdateMethodRequest(*apigateway.UpdateMethodInput) (*request.Request, *apigateway.Method)

	UpdateMethodResponse(*apigateway.UpdateMethodResponseInput) (*apigateway.MethodResponse, error)
	UpdateMethodResponseWithContext(aws.Context, *apigateway.UpdateMethodResponseInput, ...request.Option) (*apigateway.MethodResponse, error)
	UpdateMethodResponseRequest(*apigateway.UpdateMethodResponseInput) (*request.Request, *apigateway.MethodResponse)

	UpdateModel(*apigateway.UpdateModelInput) (*apigateway.Model, error)
	UpdateModelWithContext(aws.Context, *apigateway.UpdateModelInput, ...request.Option) (*apigateway.Model, error)
	UpdateModelRequest(*apigateway.UpdateModelInput) (*request.Request, *apigateway.Model)

	UpdateRequestValidator(*apigateway.UpdateRequestValidatorInput) (*apigateway.UpdateRequestValidatorOutput, error)
	UpdateRequestValidatorWithContext(aws.Context, *apigateway.UpdateRequestValidatorInput, ...request.Option) (*apigateway.UpdateRequestValidatorOutput, error)
	UpdateRequestValidatorRequest(*apigateway.UpdateRequestValidatorInput) (*request.Request, *apigateway.UpdateRequestValidatorOutput)

	UpdateResource(*apigateway.UpdateResourceInput) (*apigateway.Resource, error)
	UpdateResourceWithContext(aws.Context, *apigateway.UpdateResourceInput, ...request.Option) (*apigateway.Resource, error)
	UpdateResourceRequest(*apigateway.UpdateResourceInput) (*request.Request, *apigateway.Resource)

	UpdateRestApi(*apigateway.UpdateRestApiInput) (*apigateway.RestApi, error)
	UpdateRestApiWithContext(aws.Context, *apigateway.UpdateRestApiInput, ...request.Option) (*apigateway.RestApi, error)
	UpdateRestApiRequest(*apigateway.UpdateRestApiInput) (*request.Request, *apigateway.RestApi)

	UpdateStage(*apigateway.UpdateStageInput) (*apigateway.Stage, error)
	UpdateStageWithContext(aws.Context, *apigateway.UpdateStageInput, ...request.Option) (*apigateway.Stage, error)
	UpdateStageRequest(*apigateway.UpdateStageInput) (*request.Request, *apigateway.Stage)

	UpdateUsage(*apigateway.UpdateUsageInput) (*apigateway.Usage, error)
	UpdateUsageWithContext(aws.Context, *apigateway.UpdateUsageInput, ...request.Option) (*apigateway.Usage, error)
	UpdateUsageRequest(*apigateway.UpdateUsageInput) (*request.Request, *apigateway.Usage)

	UpdateUsagePlan(*apigateway.UpdateUsagePlanInput) (*apigateway.UsagePlan, error)
	UpdateUsagePlanWithContext(aws.Context, *apigateway.UpdateUsagePlanInput, ...request.Option) (*apigateway.UsagePlan, error)
	UpdateUsagePlanRequest(*apigateway.UpdateUsagePlanInput) (*request.Request, *apigateway.UsagePlan)
}

var _ APIGatewayAPI = (*apigateway.APIGateway)(nil)
