/* rburls2.c
 *
 * The url utility routines that require libxml or libwww to work.
 */
/* This software is copyrighted as detailed in the LICENSE file. */

#include <config.h>
#include <libxml/uri.h>
#include <ctype.h>
#include <rbmake/rbmake.h>
#include "rbmake.h"

char *
rbBuildURL(const char *url, const char *base)
{
    char *cp;
#ifdef DOS_FILENAMES
    MBuf *tmp;

    if (ISALPHA(*url) && url[1] == ':')  {
	tmp = MBuf_new(128, 0);
	MBuf_vwrite(tmp, "/mnt_",5, url,1, url+2,-1, NULL);
    }
    else if (strchr(url, '\\') != NULL) {
	tmp = MBuf_new(128, 0);
	MBuf_puts(tmp, url);
    }
    else
	tmp = NULL;
    if (tmp) {
	cp = MBuf_dataPtr(tmp, NULL);
	for (url = cp; *cp; cp++) {
	    if (*cp == '\\')
		*cp = '/';
	}
    }
#endif

    if (!base)
	base = rbGetCwdURL();
    cp = (char*)xmlBuildURI((const xmlChar*)url, (const xmlChar*)base);
#ifdef DOS_FILENAMES
    if (tmp)
	MBuf_delete(tmp);
#endif
    return cp;
}

void
rbFreeURL(char *url)
{
    xmlFree(url);
}
