/* rbmake.h
 *
 * Internal info for rbmake.c.
 */
/* This software is copyrighted as detailed in the LICENSE file. */

#ifndef RBMAKE_H
#define RBMAKE_H

#include <libxml/xmlmemory.h>

struct NameWithType {
    int type;
    char name[1];
};

struct RbMake {
    RbMakeAllowUrlFunc shouldAllowURL;
    RbMakeScheduleUrlFunc scheduleURL;
    RbMakeFinishInfoFunc finishInfoPage;
    RbFile *file;
    struct JoinGroup *joinGroupsHead, *joinGroupsTail;
    HashTable *tocNameHash, *tocUrlHash, *dropUrlHash;
    RbInfoHash *infoHash;
    MArray *substRules, *menuItems;
    const char *coverImage, *rootURL, *generator;
    int htmlCnt, binaryCnt, doneCnt, joinCnt, htmlDropCnt, binaryDropCnt;
    int joinNamesCnt, joinedHtmlCnt, pageJoiningMode, textConversionMode;
    int followLinks, enhancePunctuation, bookParagraphDepth;
    char includeImages, includeAudio;
    bool foundMenumark, createHkeyFile;
    bool allowHRSize0PageBreaks, verboseOutput;
};

#endif
