
/* rbinfohash2.c
 *
 * See the rbinfohash.c file for a description of what this is all about.
 * This function was separated from the rest to ease linking requirements.
 */
/* This software is copyrighted as detailed in the LICENSE file. */

#include <config.h>
#include <rbmake/rbmake.h>

void
RbInfoHash_mergeFromFile(RbInfoHash *me, const char *fn)
{
    MBuf *mb = GrabUrl_read(fn, NULL);

    if (!mb) {
	if (strEQ(fn, "-"))
	    fn = "stdin";
	RbError_exit("Unable to grab %s\n", fn);
    }

    RbInfoHash_mergeFromMBuf(me, mb);
    MBuf_delete(mb);
}
