/* rbfile.h
 *
 * Internal info for rbfile.c.
 */
/* This software is copyrighted as detailed in the LICENSE file. */

#ifndef RBFILE_H
#define RBFILE_H

struct RbMarkup {
    RbMarkup *next;
    char *text;
    unsigned int start, end;
    char type;
};

struct ToC {
    ToC *next;
    RbMarkup *markupHead;
    char name[RB_TOC_NAMELEN];
    int32 length, pos, flags;
    int type;
    unsigned short ord, underlineCnt, noteCnt, bookmarkCnt;
};

struct RbFile {
    FILE *fp;
    char *fileName, *newFileName;
    ToC *tocHead, *tocTail, *tocUnjoin;
    int32 tocOffset, tocCnt, maxTocCnt, fileSize;
    unsigned short joinOrd, underlineCnt, noteCnt, bookmarkCnt;
};

#endif
