/* rberror.c
 *
 * These simple functions can be overridden by the user for more flexible
 * error reporting.
 */
/* This software is copyrighted as detailed in the LICENSE file. */

#include <config.h>
#include <rbmake/rbfile.h>

static RbErrorFunc fatalErrorFunc = NULL;
static RbErrorFunc warningFunc = NULL;

void
RbError_init(RbErrorFunc fatalFunc, RbErrorFunc warnFunc)
{
    fatalErrorFunc = fatalFunc;
    warningFunc = warnFunc;
}

void
RbError_exit(const char *msg, ...)
{
    va_list ap;
    va_start(ap, msg);
    if (fatalErrorFunc)
	fatalErrorFunc(msg, ap);
    else
	vfprintf(stderr, msg, ap);
    va_end(ap);
    exit(1);
}

void
RbError_warn(const char *msg, ...)
{
    va_list ap;
    va_start(ap, msg);
    if (warningFunc)
	warningFunc(msg, ap);
    else
	vfprintf(stderr, msg, ap);
    va_end(ap);
}
