/* mem.c
 *
 * A simple set of routines to allocate memory and die if we run out.
 */
/* This software is copyrighted as detailed in the LICENSE file. */

#include <config.h>
#include <rbmake/rbfile.h>

static char out_of_memory[] = "Out of memory\n";

void *
Mem_alloc(int len)
{
    void *mem = malloc(len);
    if (!mem)
	RbError_exit(out_of_memory);
    return mem;
}

void *
Mem_realloc(void *mem, int len)
{
    mem = realloc(mem, len);
    if (!mem)
	RbError_exit(out_of_memory);
    return mem;
}

void *
Mem_calloc(int num, int objsize)
{
    void *mem = calloc(num, objsize);
    if (!mem)
	RbError_exit(out_of_memory);
    return mem;
}

char *
Mem_strdup(const char *str)
{
#ifdef HAVE_STRDUP
    char *s = strdup(str);
    if (!str)
	RbError_exit(out_of_memory);
#else
    int len = strlen(str);
    char *s = Mem_alloc(len + 1);
    strcpy(s, str);
#endif
    return s;
}

void
Mem_free(void *mem)
{
    free(mem);
}
