/* jpgimage.c
 */

#include <config.h>
#if defined(HAVE_LIBJPEG) && defined(HAVE_LIBPNG)
#include <jpeglib.h>
#include <png.h>
#include <rbmake/rbmake.h>
#include "rbimage.h"

#if BITS_IN_JSAMPLE != 8
#error We do not support BITS_IN_JSAMPLE != 8!
#endif

static void mbuf_src(j_decompress_ptr cinfo, MBuf *mbuf);

bool
jpgCheckSig(char *bp)
{
    return strnEQ(bp, "\377\330\377", 3);
}

RbImage *
jpgToImage(MBuf *mb)
{
    struct jpeg_decompress_struct cinfo;
    struct jpeg_error_mgr jerr;
    JDIMENSION buffer_width;
    JSAMPARRAY cpp;
    int todo, cnt;
    RbImage *img;

    /* Initialize the JPEG decompression object with default error handling. */
    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_decompress(&cinfo);
    mbuf_src(&cinfo, mb);

    /* Read file header, set default decompression parameters */
    jpeg_read_header(&cinfo, true);
    cinfo.out_color_space = JCS_GRAYSCALE;

    jpeg_calc_output_dimensions(&cinfo);
    buffer_width = cinfo.output_width * cinfo.out_color_components;

    /* Start decompressor */
    jpeg_start_decompress(&cinfo);

    img = Mem_alloc(sizeof *img);
    img->width = cinfo.output_width;
    img->height = cinfo.output_height;
    img->row_pointers = Mem_alloc(cinfo.output_height * sizeof (char*));
    img->bit_depth = 8;
    img->color_type = PNG_COLOR_TYPE_GRAY;

    for (todo = cinfo.output_height; todo--; )
	img->row_pointers[todo] = Mem_alloc(buffer_width);

    /* Process data */
    cpp = (JSAMPARRAY)img->row_pointers;
    for (todo = cinfo.output_height; todo > 0; todo -= cnt, cpp += cnt)
	cnt = jpeg_read_scanlines(&cinfo, cpp, todo);

    jpeg_finish_decompress(&cinfo);
    jpeg_destroy_decompress(&cinfo);

    return img;
}

typedef struct {
    struct jpeg_source_mgr pub;	/* public fields */
       
    MBuf *mbuf;
    bool start_of_file;
} my_source_mgr;

typedef my_source_mgr *my_source_ptr;

static void
init_source(j_decompress_ptr cinfo)
{
    my_source_ptr src = (my_source_ptr)cinfo->src;
    src->start_of_file = true;
}

static boolean
fill_input_buffer(j_decompress_ptr cinfo)
{
    my_source_ptr src = (my_source_ptr)cinfo->src;
    int nbytes;
    JOCTET *bp = (JOCTET*)MBuf_dataPtr(src->mbuf, &nbytes);

    if (!bp) {
	static JOCTET eoi[] = { (JOCTET) 0xFF, (JOCTET) JPEG_EOI };
#if 0
	if (src->start_of_file)     /* Treat empty input file as fatal error */
	    ERREXIT(cinfo, JERR_INPUT_EMPTY);
	WARNMS(cinfo, JWRN_JPEG_EOF);
#endif
	/* Insert a fake EOI marker */
	bp = eoi;
	nbytes = 2;
    }
    src->pub.next_input_byte = bp;
    src->pub.bytes_in_buffer = nbytes;
    src->start_of_file = false;

    return true;
}

static void
skip_input_data(j_decompress_ptr cinfo, long num_bytes)
{
    my_source_ptr src = (my_source_ptr)cinfo->src;

    if (num_bytes > 0) {
	MBuf_setReadPos(src->mbuf, num_bytes - src->pub.bytes_in_buffer, 1);
	fill_input_buffer(cinfo);
    }
}

static void
term_source(j_decompress_ptr cinfo)
{
    /* no work necessary here */
}

static void
mbuf_src(j_decompress_ptr cinfo, MBuf *mbuf)
{
    my_source_ptr src;

    if (cinfo->src == NULL) {	/* first time for this JPEG object? */
	cinfo->src = (struct jpeg_source_mgr*)
	  (*cinfo->mem->alloc_small)((j_common_ptr) cinfo, JPOOL_PERMANENT,
				     sizeof (my_source_mgr));
    }

    src = (my_source_ptr)cinfo->src;
    src->pub.init_source = init_source;
    src->pub.fill_input_buffer = fill_input_buffer;
    src->pub.skip_input_data = skip_input_data;
    src->pub.resync_to_restart = jpeg_resync_to_restart; /* use default method */
    src->pub.term_source = term_source;
    src->mbuf = mbuf;
    src->pub.bytes_in_buffer = 0; /* forces fill_input_buffer on first read */
    src->pub.next_input_byte = NULL; /* until buffer loaded */
}

#endif
