Race Into Space Game Manual
===========================

by Leon Baradat

Based on
Buzz Aldrin’s Race Into Space!  Rules of Play
by Fritz Bronner

![Relive the 1960s race to the Moon](image_0.jpg)

### Introduction

Race Into Space is a simulation of the US-Soviet Space Race.  In it, you take charge of your country’s space program as Director (US) or Designer (USSR).  You will purchase and develop space hardware, recruit and manage astronauts/cosmonauts, and plan and send missions into space.  The ultimate goal is to be the first to complete a Moon landing and return your people safely to Earth.

Race Into Space (RIS) is a port to modern operating systems of Buzz Aldrin’s Race Into Space (BARIS), a DOS game originally released in 1993 on floppy disk, and a year later in an expanded CD version.  BARIS was developed by Fritz Bronner based on his 1989 board game *Liftoff!*.  Dr. Aldrin’s name and imagery have been dropped because permission to use them was limited to the old DOS game.  RIS is available for Windows, Linux, and Mac, and includes some improvements over the original game—which we feel have justified a rewrite of the game manual.  Those involved in RIS are volunteer enthusiasts, and we hope you enjoy this simulation.  You might even find it educational.

This is a serious strategy game that requires planning ahead.  There are different paths to victory; any of these can be used, and each has its own advantages: 

* Gemini/Voskhod – a two-person capsule with one-person lander.  Easiest to get started, but tricky, and riskier than other approaches—especially Voskhod.

* Apollo/Soyuz – the historic approach.  Fairly straightforward, but some of the components can be challenging to afford early on.

* XMS-2/Lapot – a three-person minishuttle.  Tough to get started, but reusable spacecraft are a boon later in the game.

* Jupiter/LK-700 (formerly Kvartet) – a four-person direct ascent capsule.  The simplest way to get to the Moon, but startup costs can be prohibitive.

One rule of thumb is that the latter two are so expensive to prototype and research that they are usually impractical options if your prestige is low when you’re ready to choose your approach to the Moon (that is, about the time you’re flying Orbital missions with Mercury/Vostok).  Conversely, if you happen to receive a newscast just then saying all hardware will be 50% off that turn, direct ascent and the minishuttles suddenly become very feasible.

One question to consider is whether to maintain a backup strategy.  Some players prefer a traditional path, flying the one-person capsule, then the two, then moving on to the three-person spacecraft for lunar missions.  They then often maintain Gemini/Voskhod as a backup program, and switch over to it if their primary should suffer a catastrophic failure.  This can be a very handy strategy, though it’s only practical if you are planning to go to the Moon with Apollo/Soyuz or XMS-2/Lapot.  It is also more costly than going straight from Mercury/Vostok to what you plan to fly to the Moon.

The game can be played entirely with the keyboard or entirely with the mouse, though usually it’s easiest to play with both.

Although RIS includes a number of improvements over the original BARIS, the look and feel and the gameplay should be almost identical.  For the most part, the changes in RIS should simply make it easier to play and administer, as the original game had some rough edges.  Also a few of the names (of rockets, capsules, and cosmonauts) have been changed to improve the game’s educational potential, as a historical simulation of the 1960s Space Race.  Information about the Soviet lunar program was limited when BARIS was developed, which required the game’s designers to take educated guesses at names for some of the Soviet hardware and cosmonauts.  RIS has been able to take advantage of what’s known today to use more historical names, which will be mentioned below as they occur.

Race Into Space, like BARIS, uses its own flight profile for the historically considered approaches to the Moon.  So the terms in RIS don’t correspond to those used during the Space Race, but they work well in-game and their meaning is more straightforward.  You will see these terms mentioned in newscasts; just bear in mind that the newscast is referring to the historic proposal, and has no bearing on your space program.

**Direct Ascent** is the same as the historic proposal.

**Lunar-Orbital Rendezvous (LOR)** is called the Historical Manned Lunar Landing in the game.  It’s what happened on the Apollo landings and what the Soviets were planning, where the capsule and LM would launch together on a single rocket, go to the Moon together, then rendezvous in lunar orbit when the LM left the lunar surface.  In the game, LOR is a Joint mission where the capsule and LM are launched on separate rockets, fly separately to the Moon, and rendezvous in lunar orbit.

**Earth-Orbital Rendezvous (EOR)** was a proposal by Wernher von Braun to use multiple smaller rockets to launch the components for a direct-ascent type capsule in Earth orbit.  The Soyuz Lunar Landing is based on a similar concept proposed early on by the Soviets, but it was converted to a type of LOR mission for game balance purposes.  In RIS, EOR is a Joint mission where the capsule and LM are launched on separate rockets, rendezvous in Earth orbit, and fly together to the Moon.

## Designer's Notes

by Fritz Bronner

The actual space race between the U.S. and USSR was extremely close.  All of the major space hardware, including alternative proposals, are available.  This gives you the same flexibility as your real-life counterparts had.

Some modifications obviously had to be made for simplification of monetary units and budgets.  A megabuck or MB was designed as the universal monetary standard.  This creates a quicker analysis of costs and budgets between countries.

As in the game, real life programs were man-rated after an extensive R&D phase and a flight testing program.  After several successful launches/flights a vehicle was given approval to carry humans.  Percentages were incorporated into the game as [an] aid to help the player evaluate this choice.  The dilemma of when a rocket or capsule is ready to carry humans is the player’s decision.  Short cuts may be necessary as they were in real life.

Most of the major rocket boosters are available for game play.  For play balance some minor programs were deleted.  The lift capability of the various rockets were greatly simplified as a common unit weight.  The Soviets had more powerful rockets but their payloads were generally heavier, so any lift advantage was lost [ed. note: not quite—rocketry is still one of the Soviet player’s advantages].  Determining which rocket boosters are to be used for various payloads is the important factor.

Capsule design features were also simplified.  The Soviets brought the Soyuz capsule through three major design phases.  There were also many minor variants.  The Gemini capsule was more advanced than the Voskhod, which had limited maneuverability and couldn’t dock.  The weight ratios of all the spacecraft were altered for game play.  Most of the basic historical design features of spacecraft are included in the game.

All events are based on historical events that occurred in some fashion.

Most of the astronauts and cosmonauts of that time period in history are included for game play.  Their skills are strictly subjective with an historical flavor for game play.  They are not meant to reflect any real life individual’s strengths and weaknesses.  [There was some attempt, however, at highlighting certain people’s extraordinary abilities, such as Aldrin in docking and Leonov in EVA.]

All of the lunar approaches were seriously considered by the U.S. and USSR and they all are included in this game.  Some steps in these and other space missions were deleted or greatly simplified.  For all of the space missions, most of the major hurdles and challenges were retained in spirit if not accuracy.

Certain animated sequences and still images were altered and models were constructed to portray mission events more dramatically and were not meant for historical interpretation.  Some American space footage was used to reflect certain Soviet sequences.

A great emphasis is given to the magnitude of this Cold War space race.  The consequences were of national importance.  The end game was included to give the player the spirit of dramatically changing history.  It was never intended for accuracy.

## Lift Off!

![image alt text](image_1.png)

This is the Preferences screen.  On either side you can set the basic preferences for that side.

* Player Name: maximum 12 characters long.
* Country: either the US or USSR.
* Game Level: game difficulty level for that side (missions receive more penalties at levels 2 & 3).
* Astronaut/Cosmonaut Selection: difficulty level for that side in administration of ’nauts.</td>

In the center are some preferences that affect both sides:

1. Music: on or off
2. Astronaut Roster: edit the custom roster
3. Sound: on or off
4. Animation: movies or still photos
5. Model and Roster Type: Basic or Historical model, Historical or Custom roster

Select the country(ies) you wish to play and the features you desire.  The game defaults to single player, with the human playing the US.  Selecting a side to be played by a human defaults it to Game Level 1, and selecting a side to be played by computer defaults it to Level 3.  You can change these values to suit you, of course.  Selecting both sides to be played by humans creates a two-player Hotseat game, the only multiplayer option that is currently working in RIS.

**Game Level**

There are 3 levels of difficulty: level 1 is easiest for that side, and 3 the hardest.  Setting your opponent at a higher level handicaps them, which is why the game now defaults computer opponents to level 3.  One thing to be aware of is that a human playing at level 2 or 3 can be fired if they do poorly enough.

**Astronaut/Cosmonaut Selection**

There are 3 levels of difficulty.  Most of the difference is that at lower levels you see more information about your people. 

**Astronaut Roster**

This lets you edit the custom roster; it can be changed at the start of every new game.  You can change names and/or skills; however, you can’t exceed your total number of skill points—in order to add points to a skill, you must subtract some from another.  Note that you can only save one custom roster.

**Model and Roster Type**

The Basic Model gives each side the same hardware costs, Max R&D, Max Safety, etc.  The Historical Model gives different values for these, meant to help simulate the historical difference between the two space programs.  In general, US hardware costs more but is more reliable, while Soviet hardware tends to be cheaper but less safe.

### Advanced Preferences

New to RIS is Advanced Preferences.  The game doesn’t offer a fancy graphical screen for it, just a plain text file.  The file can be in different locations, but is usually found in a user’s Documents folder (Windows) or Home folder (Linux).  Windows 7 and 8 users may find it in an exotic location such as C:\Users\*username*\AppData\Local\VirtualStore\Program Files (x86)\raceintospace.  Alternatively, it may be located in the folder where the game resides on your hard drive (e.g., Program Files on XP, Program Files (x86) on Windows 7, /usr/games on Ubuntu).  Wherever you find it, it will be named simply "`config`" (with no extension).  Open the config file with a plain text editor such as Notepad or gedit.

Advanced Preferences is a mixed bag.  Inside you’ll find a whole list of settings you can change.  Warning: some are technical or meant for developers; others are experimental or upsetting to game balance: in particular, `nofail`, `short_training`, `random_eq`, `eq_name_change`, and `atlasLunar`.  Each setting is preceded by an explanation; for example:

    # Set to non-zero to enable randomization of nauts.
    # random_nauts

If you should wish to randomize the skills of your astronauts/cosmonauts in the game, change the second line from `# random_nauts` to `random_nauts 1` (or higher).  Be sure to remove the hash tag (`#`) before `random_nauts`; the hash tag makes that line a remark, so your setting will be ignored if you don’t take out the `#`.

The Advanced Preferences that will be of most interest to the average user (and which shouldn’t break the game) are as follows.

* `random_nauts` – Randomizes the skills of your astro/cosmonauts
    
    Randomizing skills might provide more variety and replayability for some players.
* `compt_nauts` – Makes your ’nauts more compatible; the lower the number, the less often they dislike one another (makes crew assignment less challenging)
    
    This option was created because some users complained about the difficulty of assigning compatible crews.
* `no_c_training` – Requires that a crew be assembled for one full turn before being assigned to a mission (the way BARIS worked)
    
    The requirement was dropped because it seemed unnecessary and made ’naut administration cumbersome.
* `no_backup` – Forces you to assign a Backup as well as a Primary crew to missions (the way BARIS worked)
    
    The requirement was dropped because it’s your space program after all; surely you should be able to forgo assigning a backup crew if you want, though it’s still recommended, since backup crews reduce the risk of a canceled flight.
* `succesRDMax` – Max R&D will increase 1 pt/mission only if the component was already at Max R&D (the way BARIS worked).
    
    The change made in RIS does two things.  One is that dummy tests on equipment not yet at Max R&D still count toward reaching Max Safety; if you fly a Vostok at, say, 70% its Safety will go up to 71% *and* the Max R&D will go up a percent; this encourages flying dummy tests by not making a player wait until Max R&D to fly them.  The other thing this does is allow you to research back to where you left off if your component was downgraded due to a newscast.  Of course, Max R&D is reset to its starting point if you suffer a catastrophic failure.  Setting succesRDMax to zero will require the usual dummy tests to return your hardware to its previous Safety rating after a newscast, and will reintroduce "wasted" dummy tests.
* `boosterSafety` – The safety of a boosted rocket will be the average of rocket and booster safety (the way BARIS worked), rather than the two multiplied by one another (e.g., rocket at 85% and booster at 50% would work out to 85+45÷2=65%, rather than .85x.45=.38 or 38%)
    
    This change was made for two reasons.  Basically, it makes more sense when you think about it: the rocket and booster *both* have to work right, or the launch step will fail.  In fact, during the Space Race, strap-on boosters weren’t considered safe enough for manned flights.  In statistics, the odds of two things both succeeding are calculated by multiplying the two probabilities together.  The other reason for the change was that the old system allowed an unfair exploit: it let players squeak by with a booster that really wasn’t ready: in the example above, for instance, in BARIS a player would be tempted to try launching his less-than-half-safe booster.  This new system also introduces a new dynamic, offering a significant tradeoff, and a real advantage to non-boosted rockets: so for instance, there is now some real motivation to consider flying Gemini on Titans like we did historically, rather than using boosted Atlases.

### Turn Announcement

This lets you know which country’s turn is about to begin.  Each turn is 6 months long and is assigned to a season, either Spring or Fall.  Each player receives an annual budget: which means that in the Spring you must be sure to leave enough MBs to get you through the Fall turn.  The game starts in Spring 1957; if neither side has accomplished a successful Moon landing by Spring 1977, the game will end with a defeat for both sides.

![image alt text](image_2.png)

### Network News

Your turn will begin with a news broadcast, which is composed of (up to) three sections: Space news, World events, and Astronaut/Cosmonaut news.  Space news is at the top and has a direct bearing on your space program: sometimes it helps or hurts you; other times it’s informational or fluff.  World events is a top news item from the time period, but doesn’t affect your space effort.  Astronaut/Cosmonaut news consists of announcements about your spacepeople: when they graduate from basic training, when one of them has announced retirement, etc.

There are several newscasts which sound like they will affect your space program but which you can safely ignore.  These are carryovers from *Liftoff!*  which were never fully implemented in BARIS.  Examples include: the next mission has a 50% chance of exploding on liftoff; you must fly Duration E before attempting a Moon landing; and any special task required, such as flying a spy satellite on your next launch.  Also, Eisenhower’s announcement that the space program will be canceled after a couple manned flights reflects his historical lack of enthusiasm for space; it will not affect you.

### Spaceports

After the news report you will be taken to an overhead view of your country’s space facility: The Cape (Cape Canaveral) for the US, and Baikonur for the USSR.  Early in the game, your spaceport will have a fairly sparse look to it, with just a few buildings (see right).  As your lunar program advances you will begin various space projects and will hire people to man them, so new buildings will appear and others will be expanded.

To administer your space program, you will need to visit the buildings in your spaceport, to do everything from buying and researching hardware to planning missions and assembling them for launch.  You visit a building by clicking on it, or pressing the appropriate key on the keyboard.  As in most parts of the game, pressing F1 here will give you information on what’s available on this screen: in this case, a general idea of what the various buildings are for.

At the bottom of the screen, the name of the currently highlighted building is displayed, along with the current turn and, on the far right, how much money you have available for the remainder of the year.

![image alt text](image_3.png)

### Administration Building

Five offices are located in this building:

#### Budget Office

On the left you see a graph displaying your and your opponent’s prestige over the past two years, and another showing selectable information on your expenditures in the four different classifications of space hardware.  On the right you see your budget over the past two years, next to an estimate of your opponent’s, courtesy of the CIA/KGB.

#### Hardware Purchase

This is where you start new programs or buy additional hardware.  All of the hardware here is potentially useful, but not all of it is needed.  For instance, lunar landers will be unnecessary if you have chosen direct ascent or the Kicker-C.  Note that you can never have more than 6 of any component at any given time.

There is a built-in advantage for developing programs in progressive order, called technology transfer.  If, for instance, you have developed your Mercury capsule to a high level and then begin the Gemini program, your Gemini capsules will start off with a higher Safety than if you had skipped Mercury.  The same would happen for Apollo if your Gemini was highly reliable; however, Apollo would get very little technology transfer from Mercury if you skipped Gemini.  Jupiter would get even less from Mercury, and XMS-2 would get none at all since it’s an altogether different sort of spacecraft.

In BARIS, technology transfer was all-or-nothing.  If a component was at or above 75%, it would give tech transfer; if it wasn’t all the way to 75%, it would give nothing.  RIS (as of v.1.1) now gives partial credit when your hardware has been partially researched.

Technology transfer is a good and useful thing, but it’s certainly not necessary to take advantage of it.  It will sometimes be in your interest to skip programs or take alternate paths to your objective.  You will get a feel for this over time.

The "Visit  R&D Facility" button is a shortcut to your Research building.  You can’t just purchase a given piece of hardware and then put it to use; you have to invest time and money to make it spaceworthy.

There are four categories of space hardware:

* Satellites:
    * Explorer/Sputnik
    * Ranger/Cosmos
    * Surveyor/Luna</td>
* Launch Vehicles:
    * Atlas/R-7
    * Titan/Proton
    * Saturn V / N1
    * Nova / UR-700
    * Boosters</td>
* Manned Spacecraft:
    * Mercury/Vostok
    * Gemini/Voskhod
    * Apollo/Soyuz
    * XMS-2/Lapot
    * Jupiter/LK-700
    * Eagle/LKM
    * Cricket/LK</td>
* Miscellaneous:
    * Kicker-A
    * Kicker-B
    * Kicker-C (USSR only)
    * EVA Suit
    * Docking Module

![image alt text](image_4.png)  ![image alt text](image_5.png)

##### Satellites

* Explorer/Sputnik: A simple satellite, which can only be used for the Orbital Satellite mission.  However, the Safety rating of this device is what’s rolled against on the Hardware Power-On step of Docking missions, so a high Explorer/Sputnik Safety is desirable unless you’re flying direct ascent.
* Ranger/Cosmos:  A flyby probe, which can be sent past the Moon or any of the planets out to Saturn.  So Voyager isn’t an option in this game, but with two probes you can recreate Pioneer 10 and 11.
* Surveyor/Luna:  A lunar landing probe.  Unlike Ranger/Cosmos it can’t be sent to other planets, just the Moon; it will, however, act as a lunar flyby probe if it should miss the Moon, giving you a little photo recon.

![image alt text](image_6.png)  ![image alt text](image_7.png)

##### Launch Vehicles

* Atlas/R-7: Light-duty rocket; can’t send anything beyond Earth orbit, even with boosters (unless you have `atlasLunar` turned on in Advanced Preferences).  The R-7 was known as the A-Series in BARIS.
* Titan/Proton: Medium-duty rocket; the minimum for sending anything to the Moon or beyond.  Can be used to launch Joint lunar landings.
* Saturn V / N1: Heavy-duty rocket, known historically as "Moon rockets".  The minimum for launching Single lunar landings.  The N1 was called the N-1 in BARIS.
* Nova/UR-700: "Mega"-duty rocket, required for direct ascent capsules.  The UR-700 was called the Vulkon in BARIS (historically, it would have been an expanded version of the Proton, whose designation is UR-500).
* Boosters: Added to rockets (except Nova/UR-700) to let them lift heavier payloads.  They make missions a bit riskier, but less expensive. 

![image alt text](image_8.png) ![image alt text](image_9.png)

##### Manned Spacecraft

* Mercury/Vostok: One-person capsule; very simple, limited to orbital, EVA, and Duration B.
* Gemini/Voskhod: Two-person capsule; most basic lunar-capable craft.
* Apollo/Soyuz: Three-person capsule, very lunar-capable.  Includes built-in kicker and docking module.
* XMS-2/Lapot: Three-person reusable minishuttle; lunar-capable.
* Jupiter/LK-700: Four-person direct ascent capsule.** ** The LK-700 was called Kvartet in BARIS.
* Eagle/LKM: Two-person lunar lander.  Can be used with Apollo/Soyuz or XMS-2/Lapot.  The LKM was called Duet in BARIS.
* Cricket/LK: One-person lunar lander; required for (and mainly used by) Gemini/Voskhod.  The LK was called L-3 in BARIS.

![image alt text](image_10.png) ![image alt text](image_11.png)

##### Miscellaneous

* Kicker-A:  Used to push a Gemini/Voskhod or XMS-2/Lapot, or an LM, out of orbit toward the Moon.  Can push only one major component (capsule/shuttle or lunar lander), so can be used only on LOR missions.
* Kicker-B: Used to push a Gemini/Voskhod or XMS-2/Lapot, and/or an LM, out of orbit toward the Moon.  Can push two major components (capsule/shuttle and lunar lander), so can be used on LOR, EOR, or Historical missions.
* Kicker-C: Soviet-only technology.  Used to land a Soyuz capsule on the Moon and lift it off for return to Earth.
* EVA Suit: Required for spacewalks and lunar EVA.
* Docking Module: Required for missions involving docking, except Apollo/Soyuz lunar landings and LM tests.

![image alt text](image_12.png)

#### Future Missions

To send hardware into space, you have to schedule a mission one turn in advance; in Spring you would schedule a launch for next Fall, and in Fall you would schedule one for the following Spring.  This is done in the Future Missions Office.  Here you will see your launch pad(s) and any missions currently scheduled for next turn.  You start the game with one pad and can purchase up to two more as needed.  

To schedule a mission, select the pad you want to use.  If you have at least two launch pads, you have the option of scheduling a Joint mission, which involves two launches.  Joint missions complicate things a bit, but can be very useful when you want to do something that involves two or more components but don’t have the rocketry to lift them all at once: usually docking tests, LM tests, and lunar landing missions.  To schedule a Joint mission you would select the first of the two pads you want to use.  Joint missions are always assigned to adjoining pads: either A and B, or B and C—not A and C.

![image alt text](image_13.png)

In the top left in the gray area you will see the selected pad, and the mission’s name, number, and duration.  Below that are five buttons you can use to narrow your options to help find the mission you want to schedule.  The first restricts your selection to unmanned vs. manned; if you’ve selected manned, it will include a pie chart representing the duration level of the mission, from A to F.  Next is a toggle for missions that include docking, then EVA, then LM, then Single vs. Joint.  In the bottom right of each box is a smaller box which, when selected, locks that button in its current position.  The RESET button will clear everything.

To the right of this area are the milestone risk and the safety risk indicators.  If you’ve skipped a milestone (say, if you’re scheduling an Orbital without having first flown a Suborbital), each step of that mission will suffer a -3 safety penalty; these are cumulative, of course, as in the very premature lunar landing scheduled above.  If you haven’t flown this type of mission before, even if you haven’t skipped anything, you’ll suffer a -1 penalty because there’s always a little extra risk the first time you do something.  The milestone risk bar simply classifies the safety risk as A-OK, CAUTION, or DANGER.

The bottom area shows the Earth, Moon, Mercury, and Venus.  It will also display Mars, Jupiter, and Saturn when those planets are available for flyby probes.  On the left are up and down arrows that you can use to scroll through the available missions.  Between them is a button which will show the steps involved in the currently selected mission.

Once you have selected the mission you want, click Continue or press Enter.

![image alt text](image_14.png)  ![image alt text](image_15.png)

If the mission you’ve chosen involves a spacecraft that can be manned, you’ll be prompted to select the capsule or shuttle you want to send on it.  If this is a manned mission, you will then select crews for it.  In BARIS, crews currently in Training (meaning they had been assembled that turn) could not be assigned to a mission; they had to wait a turn first.  In RIS this is no longer necessary, unless you set `no_c_training` to zero in Advanced Preferences.  Similarly, BARIS required you to assign both a primary and backup crew to each mission.  RIS allows you to set only a primary if you wish, though you can make backup crews required again by setting `no_backup` to zero in Advanced Preferences.

##### Dummy Tests

Once your hardware reaches Max R&D, it’s impossible to further improve its reliability through research, yet you may not consider it safe enough yet to risk lives with.  So it’s often advisable to fly it on real, but unmanned, missions.  This puts the hardware through its paces and increases its Safety by 1% per mission, so long as it performs successfully on at least one step of the mission.  Dummy tests don’t gain or lose you prestige, but they let you improve your hardware without risking lives.

In BARIS, dummy tests flown below Max R&D would give the player no advantage beyond a simple 1% Safety, effectively discouraging aggressive testing.  RIS avoids this phenomenon of "wasted dummy tests" by raising the Max R&D by 1% on each flight (again, so long as the hardware succeeds on at least one step), which can make it helpful to fly dummy tests before research is complete.  (Catastrophic failures will reset the Max R&D to its original level, to prevent disrupting game balance.)  This behavior can be reset to the way BARIS worked by turning on `succesRDMax` in Advanced Preferences.

![image alt text](image_16.png)

#### Astronaut/Cosmonaut Recruiting

If human figures appear in the box next to the name of this office in the Administration menu, then you are able to recruit people this turn.  You may recruit up to five groups of astro/cosmonauts over the course of the game.  Random events may give you three additional spacemen from the military, or make female candidates available (and required).

In the recruitment screen, you will see the number of available positions, with each featured candidate’s name and skills.  LM, EVA, and Docking won’t be known until individuals begin their training, so those skills won’t show here.  Candidate skills are the following:

<table>
  <tr>
    <td>Capsule Pilot – This is added to all Capsule steps of a mission—generally, anything involving piloting, navigation, or shipboard operations.  Easily the most important skill, as it is rolled against multiple times during most missions.
L.M. Pilot – This is added to LM steps of a mission—the actual testing of a lander, or flying it on lunar landings.
E.V.A. – This is added to spacewalks and lunar EVA.
Docking – This is added to attempts at docking.
Endurance – Officially, this is added to safety during duration and lunar missions, and/or reduces milestone penalties.  However, there is some question whether any of this was implemented in the game’s coding.</td>
  </tr>
</table>


There is also a field for Service (where a candidate came from, e.g. which branch of the military), which was planned but never implemented—but may be in future versions of the game.  

**Preferences**

Once the game has started, you can change only music, sound, and animation.

**Time Capsule**

Here you can save or load a game, or exit to the main menu.

![image alt text](image_17.png)

**Museum of Space History**

The Museum offers various information on your space program and its accomplishments thus far.

**Director Ranking**

This shows your prestige compared to your opponent’s, and how it has progressed over time.  This graph can give you some idea of how things are faring with your opponent—in particular, sudden sharp drops usually indicate a catastrophic failure, which can take pressure off you for a bit.

**Space History**

This shows a history of your space missions, one turn per screen.  Each mission you’ve flown is displayed with its name, an icon showing the type of spacecraft, and its mission patch.  Clicking on it will show its Mission History screen which gives more information on what it was about and who, if anyone, was aboard.  You can also replay the mission here if you wish.

**Mission Records**

This gives the best and worst performances on various types of missions which are stored in previous completed games: first man in space, first spacewalk, etc.—in other words, who set the record for such-and-such.  Pressing the CLEAR RECORD button will reset the records for that category.

**Prestige Summary**

This shows who has gained how much prestige from performing various firsts, seconds, and so on in the current game.  This screen can help give you some idea where you are in the game, and tip you off to types of missions you have already completed or which you may still need to accomplish but which may have slipped your mind.

**Hardware Efficiency**

This will open to the Efficiency screen, which gives the success ratios of your various hardware programs.  If you click on the flag in the top left you will be taken to the Prestige Points screen, which shows the prestige points gained by each hardware program.  In practice, these screens aren’t used much because they offer little information that would affect a player’s decisions, though they do make an impressive-looking display.

**Astronaut/Cosmonaut History**

This shows detailed information about each of your spacepeople.  You can see their name and picture, what Group they were recruited in, how long they’ve been with you, their skills and location, and their mission history.

Someone who has flown at least one mission will show a pair of astronaut wings under their picture.  If they have completed a milestone mission or flown at least four space flights, you will also see a medal displayed.

**The Pentagon / KGB Headquarters**

Here you can get secret intelligence on your opponent, starting in Fall 1958.  Of course, not all intelligence is accurate—in fact, it’s wrong about half the time, give or take.  Still, this can be of some use to you in guessing what your opponent is doing, especially if you’re considering whether to play it safe or take a big chance on a particular prestige first.

**Library**

This is where to go for intelligence briefings.  Each turn you’ll receive a report that your opponent is developing a given component or is preparing a given mission.  Again, this may not be accurate.

**CIA/KGB Statistics**

This shows the Safety ratings of your hardware, compared to your opponent’s known hardware.

**Capitol / Politburo**

Once a year, your country’s leader reviews your performance.  If you’re doing very well indeed, you’re likely to be praised; otherwise, you’ll be sullenly urged to do better or even actively chastised.  If you’re doing very poorly at level 1, it will be suggested you retire.  At higher levels you’ll be summarily fired, if you’re playing against the computer; if it’s a multiplayer game retirement will remain just a suggestion.

![image alt text](image_18.png)

**Vehicle Assembly/Integration Building**

If you scheduled a mission last turn, you’ll now need to assemble it for launch.  In the top left you’ll see the mission name and type, and an Autopurchase button to make it easy to buy the equipment for it.  On the right you see the hardware as currently assembled—when you change the configuration, this display will update to match it.  To change rockets or add/remove boosters, click on the Rocket button near the bottom left.  This button defaults to the smallest rocket that can lift the payload without boosters; if you want to use a boosted smaller rocket instead (e.g., B/Atlas), click the button a few times.  Whatever the mission, you will need rocketry with a high enough Maximum Payload to launch the current payload (above the Autopurchase button).  To change the payload (generally, to switch kickers or lunar landers), click on the larger button above the Rocket button.  Once you’re ready, click the Assign button or press Enter—or, the Scrub button to cancel this flight.

It is often a good idea to make this your first stop when you begin your turn, so you don’t accidentally spend all your money on research when you also need to buy components for a scheduled launch.

![image alt text](image_19.png)

**Launch Pads A, B, and C**

You begin the game with one launch pad (Pad A) and can purchase more as you need.  If you click on one that has a launch going up this turn, you’ll see the mission name, crew if any, and duration level.  Here too you can repair the pad or Scrub the mission if you so desire.  Note that in the example above, the second member of the backup crew shows in black, as he has announced retirement and will soon be departing your space program.

![image alt text](image_20.png)

**Research & Development**

This is the counterpart to the Purchasing building, where you can assign engineers to improve the reliability of your hardware, except docking modules, anything you have not yet purchased, or anything which has already reached Max R&D.  The "VISIT PURCHASING FACILITY" button is, of course, a shortcut to the Purchasing building.

When a piece of hardware is prototyped, it begins with a low Safety factor, often five or six percent.  If it starts out a bit higher, you’ve just seen the effect of technology transfer—the component is a bit safer from the get-go because some of its technology is reused from other components (Gemini will receive technology from Mercury, for example).

To increase the Safety of your hardware, decide how many engineers you want to assign to work on it this turn, and click the appropriate button above "RESEARCH PROGRAM", which shows what this amount of research will cost you.  This amount is, of course, the number of engineer teams you selected multiplied by the R&D Cost per team figure above.  When you press the button to research this program, the computer will roll a six-sided die for each team you’ve assigned to the program, and add all those rolls to the current Safety factor.

As you might expect, once you reach Max R&D, you cannot improve the Safety of a component by researching it.  From this point, the only way to make it more reliable is to use it on an actual space mission.  It will gain 1% Safety on each mission it flies, provided it works successfully at least once on the mission.  Once it reaches Max Safety, of course, its Safety will never increase.

**Moon / Luna**

The Moon is shown up there to remind you of your objective.  Clicking on it will show your current level of lunar reconnaissance.  You begin the game at 55%, a rather simplified figure which reflects that a total of 55% of the Moon’s surface is visible to Earth telescopes over the course of its orbit (so this is how much of the Moon we had seen before the first probe, Luna 4, took pictures of the far side).  Lunar recon will go up as you launch probe flybys and landings, and manned lunar passes and orbitals.

**Viewing Stand**

The Viewing Stand shows some basic information on your previous missions, plus your newscasts.  If you missed the newscast by hitting a wrong key, or want to have a second look at it—or would like to see some of your prior newscasts—this is where to go.

![image alt text](image_21.png)

**Mission Control**

If you have missions scheduled for this season, you need to come here to confirm the launch schedule.  Here you can do two things to a given mission; one is to **rush** the launch by one or two months.  Rushing it by one month will cost 3MB and give a 3% milestone penalty; rushing it two months will cost 6MB and give a 6% penalty.  This isn’t something you would do routinely, but it can be useful in beating your opponent to a prestige first.

If one of your missions is riskier than you were prepared for, you also have the option to **downgrade** it to a simpler mission type.  This can be handy if, say, you had a Suborbital planned for last turn but the mission never flew—the Orbital you have on the pad now would suffer a milestone penalty from having skipped the Suborbital.  So instead you can downgrade it to a Suborbital and avoid the milestone penalty.  There may be several options for a downgrade; for instance, an Orbital Duration EVA mission could be downgraded to Orbital Duration, Orbital EVA, Orbital, or Suborbital.  Once you choose a mission type and press the Assign button, however, you cannot change your mind.  You could go back and downgrade some more (say you downgraded from Orbital Duration EVA to Orbital EVA—now you could downgrade again to an Orbital), but you cannot go back to the original mission without scrubbing and rescheduling, thereby putting it off for a turn.

![image alt text](image_22.png)

When your missions launch, following your turn, you will watch them unfold, either as movies or still photos (as you selected in Preferences).  Dummy tests will display only the launch, but probes and manned missions show the whole thing (except Mars, Jupiter, and Saturn probes, since they take several turns to arrive).  On either side of the movie mission you will see still images of space hardware and other things space-related; at the bottom you will see the mission’s status box, which displays the die rolls for each step of the mission.  The colored bars represent your chances for success on that step; note that in the above example, the first step (Launch) has a taller bar, which means the rocket is more reliable than the capsule.  The green represents the number the computer rolled against your hardware; the dotted lines are markers for 25%, 50%, and 75%.  The yellow caps at the top of the second and third bars are safety added by crew skill, in this case Capsule Pilot.  

![image alt text](image_23.png)

A red bar means a failed roll, which would be followed by a Step Failure screen.  Sometimes the problem is repaired by the crew, especially if your hardware was pretty safe to begin with.  But sometimes, especially if it is under-researched, crew status will not be OK and you’ll suffer a catastrophic failure of some kind.

You will see your opponent’s missions only when they represent successful prestige firsts.  Prestige seconds, failures, and dummy tests will not be displayed.

**Arlington Cemetery / Kremlin Wall**

Your brave heroes who die while in your space program (whether in the line of duty or in a random accident) will be laid to rest here.

**The Flagpole**

Click on the flag to end your turn.  If you have missions scheduled for launch this season, you will be given one last chance to review each mission and give a final go-ahead, or instead scrub the flight.  This final confirmation screen can be especially important when you have two missions scheduled and the first suffers a catastrophic failure: you will get a final confirmation screen for the second flight, along with current Safety figures, and can cancel a mission that’s suddenly become unacceptably dangerous.

  

<table>
  <tr>
    <td>Basic Training

Once you recruit your first group of astro/cosmonauts, a host of new buildings will appear relating to your spacepeople.  The first place they will go is Basic Training; you can withdraw them early at any time, but withdrawal is a one-way trip.  If you don’t need people right away, it’s recommended to leave them in Basic Training for the duration, as that will improve their skills somewhat.  This is especially helpful for Capsule pilot, which is easily the most important skill—if you need to pull someone out early, anyone with a CA4 is a good candidate for withdrawal, and anyone CA3 is best left in Basic if possible, as their skill might rise to CA4 if they’re left alone.

When they leave Basic Training, astronauts go to the Astronaut Complex and cosmonauts to the Cosmonaut Center.

</td>
    <td>


</td>
  </tr>
</table>


**Astronaut Complex / Cosmonaut Center**

<table>
  <tr>
    <td>
This is the distribution point for your spacepeople.  From here you can send them to a capsule or shuttle program, or to Advanced Training.  Leaving the Transfer Astronaut/Cosmonaut button selected, press the button for where you want the highlighted person to go.  To follow your people there, or go somewhere else, select the Facility Transfer button and click on your destination.  Note that here and many other places, your veterans will show the number of missions they’ve flown.  This can help you keep track of your veteran versus unflown spacepeople.
</td>
    <td>
</td>
  </tr>
  <tr>
    <td>
</td>
    <td></td>
  </tr>
</table>


![image alt text](image_24.png)

**Capsule/Shuttle Program**

You can reach this screen from the Astronaut Complex / Cosmonaut Center, or by clicking on the Mercury/Vostok, Gemini/Voskhod, Apollo/Soyuz, XMS-2/Lapot, or Jupiter/LK-700 building in the spaceport.  Here you can assign people to crews, once you’ve sent them here.  You can also break and reassign crews as needed.

When assembling crews, pay special attention to how they get along.  Click on each member of a newly assigned crew to see how he/she gets along with the other members; as you might expect, green is good; red is bad.  People who don’t get along with their crewmates will suffer morale degradation and retire sooner than their colleagues.  Check all crew members, since compatibility isn’t always mutual.

Also pay attention to each person’s role—the skills in yellow are those that will be used by that member of the team.  However, regardless of other considerations, you should always put your highest Capsule skill in the first seat, since that skill is most important to keeping the crew out of danger.  Also, anyone whose name shows in black or dark purple has announced retirement and should not be assigned to a crew (they’ll just leave soon and break the crew anyway).

Anyone who is not assigned to a crew (for instance, Walker in the example above, who has flown a mission) will return to the Astronaut Complex / Cosmonaut Center when you leave this screen.

Your spacepeople prefer being assigned to a crew (so long as it’s a compatible one) to languishing back at the Center / Complex.  Space successes, especially firsts, improve the morale of all your people.  Failures and mission cancelations do the opposite; mission deaths are especially damaging to morale.  Your people also enjoy being assigned to the primary crew of a mission and are especially pleased by actually flying the mission.

<table>
  <tr>
    <td>Color
Green
Yellow
Red
Black</td>
    <td>Mood
Happy
Ok, could be better
Frustrated
Burned out, planning retirement</td>
  </tr>
</table>


**Medical Center / Infirmary**

When someone is injured, either during a mission or in some other accident, they will go here and do their best to recover so they can return to active duty.  If so, they return to the Astronaut Center / Cosmonaut Complex; otherwise they will retire from your space program.

**Advanced Training**

You may send some of your people to Advanced Training to improve their skills for missions.  There is one Advanced Training building for each skill: Capsule, LM, EVA, Docking, and Endurance.  Advanced Training takes 2 full years (4 turns), and will award 2 points in the relevant skill.  It puts trainees out of commission for that time and costs 3MB apiece, so it’s not used very often.

RIS 1.1 makes several improvements to Advanced Training.  It automatically prevents someone from being sent to Advanced for anything they have a 4 in.  Anyone with a 3 in that skill will go directly to Advanced Training III, so they serve half the usual time since they can only gain half the usual amount of skill.  For everyone else, half of the gain in skill (1 point) is awarded after 2 turns, so someone withdrawn from Advanced III or IV will still get half credit for their time spent there.  Anyone withdrawn from Advanced I or II will be eligible to go back to Advanced later on (anyone who has gained some skill is still prohibited from returning), and withdrawing someone from Advanced I, II, or III can gain the player a partial refund of the money originally spent to send them there.

![image alt text](image_25.png)

**L.M. Program**

The LM Facility gives you some important information about your lunar module(s).  Current Safety is displayed here, and the number you have in your inventory.  New to RIS, it also shows whether your lander holds a failure avoidance card.  (Note that the figures shown for attempts are buggy; hopefully this will be corrected in the future.)  Last and most important, it displays your current number of LM points.  Each successful Earth orbital LM test is worth one LM point; each lunar LM test is worth two.  If you don’t have at least three points, the LM steps of your lunar landing mission will suffer a -3 penalty for each point you are missing.

LM Points are not specific to the lander they were earned with.  That is, if for some reason you have purchased both landers (as above) and gained 3 LM tests with one lander, you could use the other for the lunar landing with no LM penalty.

Direct ascent landings (Jupiter/LK-700) and Soyuz Lunar Landing (using the C-Kicker) do not require LM points, and in fact it is not possible to gain them using direct ascent or C-Kicker hardware.

![image alt text](image_26.png)

**Satellite Programs**

The Satellite building shows information on several programs, mainly unmanned.  For lack of a better place to put it, RIS has shoehorned in an indicator of your highest currently achieved Duration level in the top left.  Just below that is information on your docking attempts to date, both manned and unmanned.  Next is information on your Orbital Satellite missions.  The third column shows your lunar flyby data, but also offers plus and minus buttons that let you scroll through the various planetary flybys.  Finally, the right column shows information on your lunar probe landings.

![image alt text](image_27.png)

![image alt text](image_28.png)

**PRESTIGE**

<table>
  <tr>
    <td>Name</td>
    <td>First</td>
    <td>Second</td>
    <td>Other</td>
    <td>Failure</td>
  </tr>
  <tr>
    <td>Orbital Satellite</td>
    <td>12</td>
    <td>5</td>
    <td>1</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Lunar Flyby</td>
    <td>5</td>
    <td>3</td>
    <td>2</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Mercury Flyby</td>
    <td>5</td>
    <td>2</td>
    <td>2</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Venus Flyby</td>
    <td>7</td>
    <td>4</td>
    <td>2</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Mars Flyby</td>
    <td>7</td>
    <td>4</td>
    <td>2</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Jupiter Flyby</td>
    <td>8</td>
    <td>4</td>
    <td>2</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Saturn Flyby</td>
    <td>9</td>
    <td>4</td>
    <td>2</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Lunar Probe Landing</td>
    <td>16</td>
    <td>9</td>
    <td>2</td>
    <td>-5</td>
  </tr>
  <tr>
    <td>One-Person Craft</td>
    <td>3</td>
    <td>1</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Two-Person Craft</td>
    <td>7</td>
    <td>2</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Three-Person Craft</td>
    <td>15</td>
    <td>5</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Minishuttle</td>
    <td>20</td>
    <td>8</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Four-Person Craft</td>
    <td>20</td>
    <td>8</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Duration Level B </td>
    <td>3</td>
    <td>3</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Duration Level C</td>
    <td>5</td>
    <td>5</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Duration Level D</td>
    <td>1</td>
    <td>1</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Duration Level E</td>
    <td>5</td>
    <td>5</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Duration Level F</td>
    <td>7</td>
    <td>7</td>
    <td>0</td>
    <td>0</td>
  </tr>
  <tr>
    <td>Manned Orbital</td>
    <td>12</td>
    <td>5</td>
    <td>1</td>
    <td> -10*</td>
  </tr>
  <tr>
    <td>Manned Lunar Pass</td>
    <td>12</td>
    <td>5</td>
    <td>2</td>
    <td> -10*</td>
  </tr>
  <tr>
    <td>Manned Lunar Orbit</td>
    <td>20</td>
    <td>7</td>
    <td>1</td>
    <td> -10*</td>
  </tr>
  <tr>
    <td>Manned Lunar Landing</td>
    <td>40</td>
    <td>15</td>
    <td>8</td>
    <td> -10*</td>
  </tr>
  <tr>
    <td>Experimental Orbiting Lab</td>
    <td>6</td>
    <td>4</td>
    <td>0</td>
    <td> -10*</td>
  </tr>
  <tr>
    <td>Manned Docking</td>
    <td>8</td>
    <td>4</td>
    <td>1</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Woman in Space</td>
    <td>8</td>
    <td>0</td>
    <td>0</td>
    <td>-4</td>
  </tr>
  <tr>
    <td>Spacewalk</td>
    <td>8</td>
    <td>4</td>
    <td>1</td>
    <td>-3</td>
  </tr>
  <tr>
    <td>Manned Space Mission</td>
    <td>15</td>
    <td>5</td>
    <td>0</td>
    <td> -10*</td>
  </tr>
</table>


* *Missions with a -10 for failure will instead suffer -7 to -10 if no crew deaths occur.*

**SPACE HARDWARE**

Each side has a variety of space equipment that can be developed.  Some may seem fairly obvious, but others will need some explanation.

**Explorer / Sputnik**

This is a basic Earth-orbital satellite, and can be used only on the Orbital Satellite mission.  It is necessary to develop this unless you will be flying direct ascent, since Explorer/Sputnik Safety is rolled against when a docking module powers on.

**Ranger / Cosmos**

These are interplanetary flyby probes.  They can be sent past the Moon or any of the planets as far out as Saturn.  They will need at least a Titan to push them out of Earth’s gravity well; a boosted Atlas/R-7 cannot do the job.  Sending them to the Moon is an excellent way to increase your lunar reconnaissance.

**Surveyor / Luna**

This is an unmanned probe designed to be soft-landed on the Moon.  A probe landing will gain you a lot of prestige and lunar recon, but costs a lot of time and money to develop.  In practice, the lunar landing probe is more trouble than it’s worth, and can usually be skipped. 

**Atlas / R-7 Rocket**

These have the smallest lift capability of all your rockets.  They can put things into orbit, but cannot send them to the Moon or beyond, even with boosters.  The R-7 was known as the A-Series in BARIS and early versions of RIS.

**Titan / Proton Rocket**

These rockets can lift more than the Atlas/R-7, and can send spacecraft beyond Earth orbit.

**Saturn V / N1 Rocket**

These are the US and Soviet Moon rockets.  They have the same capabilities as Titan/Proton, but can lift much more.  The N1 was known as the N-1 in BARIS and early versions of RIS.

**Nova / UR-700**

These rockets are designed to launch direct ascent capsules.  While they can lift other payloads into space, they’re seldom used for that purpose because they’re so expensive.  They are so enormous, in fact, that they will never need to be boosted, and are the only rockets in the game that cannot be boosted.  The UR-700 was known as the Vulkon in BARIS and early versions of RIS.

**Strap-on Boosters / Booster Stage**

Boosters are added to rockets to let them lift heavier cargoes; they cannot be used by themselves.  They can be added to any rocket type except Nova/UR-700.

**Mercury / Vostok Capsule**

This is a one-person capsule which can be used for very basic space missions: suborbital, orbital, EVA, and Duration B only.  It cannot perform docking or lunar missions.

**Gemini / Voskhod Capsule**

This is a two-person capsule, capable of everything the Mercury/Vostok can do plus docking and lunar missions, and Duration E.  In order to go to the Moon, Gemini/Voskhod will require a kicker.

**Apollo / Soyuz Capsule**

This is a three-person capsule, capable of all docking and lunar missions, and can accomplish Duration F.  It does not need a kicker to go to the Moon, and does not require docking modules to dock with LMs.

**XMS-2 / Lapot Minishuttle**

This is a three-person reusable spaceplane which is also docking- and lunar-capable, though it is limited to Duration D.  Like Gemini/Voskhod, it requires a kicker to go to the Moon.

**Jupiter / LK-700 Capsule**

This is a four-person direct ascent spacecraft, which will require a Nova/UR-700 to launch.  This capsule is capable of orbital, Duration F, and lunar missions; it can accomplish the lunar landing on its own with no other components (except EVA suits).  A player who wishes to fly direct ascent does not need kickers, docking modules, or lunar modules.  The LK-700 was known as Kvartet in BARIS and early versions of RIS.

**Eagle / LKM Module**

This is a two-person lunar module capable of landing on the Moon and returning to an orbiting spacecraft.  It can be used with either Apollo/Soyuz or XMS-2/Lapot.  The LKM was known as Duet in BARIS and early versions of RIS.

**Cricket / LK Module**

This is a one-person lunar module capable of landing on the Moon and returning to an orbiting spacecraft.  This module is required for Gemini/Voskhod, but can also be used with Apollo/Soyuz or XMS-2/Lapot.  The LK was known as L-3 in BARIS and early versions of RIS.  It may seem counterintuitive that a smaller module would cost more, but the one-person module requires more automated systems and backups to compensate for the lack of a second pilot. 

**A-Kicker**

This is a final rocket stage to send a spacecraft out of Earth orbit and toward the Moon.  This, or the Kicker-B, is required by Gemini/Voskhod and XMS-2/Lapot for lunar missions, but not by Apollo/Soyuz or Jupiter/LK-700.  Apollo/Soyuz LOR LM tests and lunar landings will need this or the B-Kicker to send the LM to the Moon.  The A-Kicker can send one spacecraft to the Moon, so it can be used for LOR, but not EOR or Historical landings.

**B-Kicker **

This is a final rocket stage to send spacecraft out of Earth orbit and toward the Moon.  This, or the Kicker-A, is required by Gemini/Voskhod and XMS-2/Lapot for lunar missions, but not by Apollo/Soyuz or Jupiter/LK-700.  Apollo/Soyuz LOR LM tests and lunar landings will need this or the A-Kicker to send the LM to the Moon.  The B-Kicker can send one or two spacecraft to the Moon, so it can be used on EOR, LOR, or Historical landings.

**C-Kicker**

This is a Soviet-only technology that docks with a Soyuz capsule and lands it on the Moon, then lifts it off again.  It can only be used with a Soyuz capsule and is needed for the Soyuz Lunar Landing, which is always a Joint mission.  A player intending to use the Soyuz Lunar Landing does not need to develop a lunar lander, or Kicker-A or -B, and does not need to perform LM tests.

**EVA Suits**

These suits are required for extravehicular activities, either on spacewalks or moonwalks.  They are different from pressure suits and are not needed on simple orbitals or other missions where the crew stays inside the spacecraft.

**Docking Module**

These are used on missions that involve docking: docking and LM tests, and lunar landings.  In order to test them you will have to first develop the Explorer/Sputnik, whose Safety factor is rolled against for the docking module’s Hardware Power-On step.  Docking modules are the only component whose Safety you cannot improve with research; your docking modules must be tested in space in order to get better: a successful test will yield 10% Safety, a failure 5%.  A docking module will remain functional in space for a year, so a module may be used in the season after its launch: to take advantage of this option, select a Manned Orbital Docking (Orbit) mission.

**MISSION MILESTONES**

Space exploration was something completely new in the 1950s and early 60s.  Space could be filled with a host of dangers to human beings and living things generally—and some of those dangers turned out to be real.  Rushing ahead heedless of those possibilities would have been foolhardy, possibly even catastrophic.  We sent probes up above the atmosphere to see what was there (and discovered the Van Allen Belt).  Then we sent animals into space: generally, the US used primates and the Soviets used dogs.  Finally we sent humans up, briefly at first, and for longer periods as we learned more about how the human body reacts to weightlessness for extended periods.  We learned, for instance, that early fears of an astronaut losing control of their reasoning in space were unfounded; however we also discovered unexpected effects such as space sickness and gradual loss of bone and muscle mass, which had to be taken into account on longer voyages.

On a larger scale, before the US sent anyone into orbit it tossed a couple astronauts into space on suborbital missions (of course the Soviets were more impatient and skipped that one, as you can in the game).  And both sides performed a number of simple orbital missions before attempting long durations or spacewalks.  Duration, EVA, and docking were all well under our belt before the US ventured beyond Earth orbit, and the Soviets never did (though they did send animals around the Moon).  Race Into Space tries to model the importance of incremental progress by assigning extra risk to missions which skip steps.  Skipping steps is still a valid strategy in some cases, but is not something to be done routinely.  Each milestone you skip carries a -3% penalty on each step of the mission, so if you skip two milestones for a given mission, each step of that mission will suffer -6%.  Of course if it succeeds, you will get credit for having accomplished those milestone steps and won’t be penalized for them again.

Similarly, the game assigned a -5% penalty for each *duration* level skipped: for instance, if you had just completed a manned Orbital (Duration A) and planned a Duration D for next turn (skipping Durations B & C), that mission would suffer -10% per step.  Duration penalties would be cumulative with any milestone penalties, of course.  However, duration penalties never worked quite right; BARIS suffered from a "Duration B Bug" which assigned a duration penalty to your first Duration mission, whether you had skipped a level or not (typically this would be Duration B, hence the name).  The problem worsened in RIS, often assigning a duration penalty to *every* Duration mission attempted.  Since the developers had trouble tracking down this bug, the duration penalty system has been disabled until it can be fixed.

**ORBITAL SATELLITE**

Humanity’s first step in space exploration would likely be putting a simple satellite into orbit around the Earth.  Historically this was an accomplishment of enormous importance, and in the game it makes an ideal first step on the way to the Moon.  (Remember that strategically, Sputnik put the US on notice that the Soviets could drop a bomb anywhere in the world, which was new and shocking at the time.)

**MANNED SUBORBITAL**

Typically a country’s first manned space mission will be a suborbital flight, which tests out the spacecraft to see how it and its pilot perform in the harsh environment of outer space—while avoiding some of the risks of a full orbital mission.  There is no chance of failure to deorbit, for instance, and the heat of reentry is much less than for an orbital mission (though this difference doesn’t apply in-game).  Putting a human being into space for the first time, even if only for a few minutes, is still a big deal, and counts as a Man/Woman In Space prestige first.

**MANNED ORBITAL**

Putting a person into orbit is also a major achievement.  The spacecraft’s systems are put to more thorough tests and the effects of microgravity on the human body are studied in more detail than can be done in a suborbital.  It is possible, though riskier, to skip the suborbital and go straight to an orbital mission, combining the two prestige firsts, as the Soviets did with Yuri Gagarin on Vostok 1.  The manned orbital also paves the way for more demanding and complex missions, such as longer duration, spacewalks, and docking tests. 

**LUNAR FLYBY**

Sending a probe past the Moon is an important step toward sending people out that way.  It allows your program to study the surface features and gives humanity’s first look at the Moon’s far side, plus this will be the first man-made object to permanently leave Earth.

**LUNAR PROBE LANDING**

Before landing people on the Moon, it is helpful to first put down a robotic probe.  This tests the concept of soft-landing a spacecraft, and allows testing of the firmness and composition of the lunar soil (technically, regolith).  It also helps greatly with lunar reconnaissance.  (It is not so important in the game as it was in real life; in RIS this is no more than a milestone step, and is easily skipped.)

**MANNED LUNAR PASS**

Sending people around the Moon and back to Earth is a big step for mankind, as it is our first visit of any kind to another world.  Earthrise can be viewed from another world for the first time, and photo recon will be gathered.

**MANNED LUNAR ORBITAL**

More involved than a pass, a lunar orbital gives ample opportunity to test out spacecraft systems in lunar gravity, and even lunar lander tests above the Moon, as was done on Apollo 10.  One can even skip the lunar pass and go straight to the orbital, as was done on Apollo 8, though that’s awful risky in the game if you’ve skipped the lunar landing probe.  The orbital also provides some opportunity for the gathering of reconnaissance.

**MANNED LUNAR LANDING**

Here it is, the end goal—to land a person on the Moon and return them safely to the Earth.  This is arguably humanity’s greatest technological triumph!  New challenges await, but mankind’s first footsteps on an alien world are an achievement to remember.

**Milestone Steps and Necessary Tasks for the Moon Landing**

**PHOTO RECONNAISSANCE**

Lunar recon represents your space program’s ability to find a safe landing spot once your astro/cosmonauts approach the lunar surface; what looks smooth from a distance could turn out to be a very rough landing site.  A failed photo recon step can result in a last-minute abort to your lunar landing, or worse.  Lunar recon starts at 55%.  It increases 5% with every probe flyby, manned lunar pass or orbital, or failed probe landing (so long as the probe manages a lunar de-orbit burn).  Successful probe landings raise your reconnaissance by 15%.

**SPACEWALK**

Before you can even consider walking on the Moon, it’s important to establish that human beings can perform outside a spacecraft at all.  EVA is an important achievement in its own right, and is a (near literal) first step for mankind.

**(MANNED) DOCKING**

Docking is a capability that will be required for any lunar landing, except direct ascent.  Rendezvous and docking are much more complicated in space than they are on the ground, and there was a great deal of skepticism that it could be mastered in time for a Moon landing in the 1960s.  It wasn’t easy for either side, and the game models that by requiring multiple tests of the docking module, many of which fail, especially early on.  Docking modules begin with a 40% Safety which increases only with testing: 5% for failed dockings, 10% for successes.

**DURATION**

Once your space program has performed a simple Earth orbital, it’s time to consider longer flights, to see how people perform in space over long periods.  Certainly they’ll have to be able to go for 8-12 days, as lunar orbitals and landings are Duration D missions.  Longer duration isn’t necessary (good news for those flying the minishuttles!), but earns the player extra prestige.  Duration levels are as follows:

<table>
  <tr>
    <td>Days</td>
    <td>Duration</td>
    <td>Prestige</td>
    <td>Comments</td>
  </tr>
  <tr>
    <td>1-2</td>
    <td>A</td>
    <td>--</td>
    <td>Any space mission will be at least Duration A</td>
  </tr>
  <tr>
    <td>3-5</td>
    <td>B</td>
    <td>3</td>
    <td>Maximum for Mercury/Vostok</td>
  </tr>
  <tr>
    <td>6-7</td>
    <td>C</td>
    <td>5</td>
    <td>Duration level for manned lunar pass</td>
  </tr>
  <tr>
    <td>8-12</td>
    <td>D</td>
    <td>1</td>
    <td>Maximum for XMS-2/Lapot; Duration level for lunar orbitals and landings</td>
  </tr>
  <tr>
    <td>13-16</td>
    <td>E</td>
    <td>5</td>
    <td>Maximum for Gemini/Voskhod</td>
  </tr>
  <tr>
    <td>17-20</td>
    <td>F</td>
    <td>7</td>
    <td>Maximum for Apollo/Soyuz and Jupiter/LK-700</td>
  </tr>
</table>


**LUNAR MODULE TESTS**

Lunar Modules should ideally be tested before they’re used for the actual landing.  RIS uses a system of LM Points to model this.  To avoid penalties on your landing, you will need at least 3 LM Points, which are acquired on LM tests.  Tests in Earth orbit are worth 1 point; those in lunar orbit are worth 2 points.  You could run three Earth-orbital tests to get your three points, or one Earth-orbital and one lunar-orbital (as happened with Apollos 9 and 10).  You could do two lunar-orbital tests if you wished, though there’s no advantage in accumulating more than 3 LM Points.

If you have fewer than 3 LM Points, your lunar landings will face a penalty on the LM portions of the mission.  Each LM step will be penalized 3% per missing LM Point, so if you performed no tests, you would face a 9% penalty; if you performed one Earth-orbital test, you’d be docked 6% on those steps.  Direct ascent capsules do not require LM tests; neither do Soyuz Lunar Landings (which use a Kicker-C in place of an LM).  In fact you cannot perform LM tests with direct ascent capsules, or with C-Kickers.

**STRATEGY**

by Fritz Bronner

**How I Won and Lost the Moon Race**

Kennedy’s challenge of landing men on the Moon and returning safely to the Earth is the ultimate goal of winning the space race.  It is especially challenging, when starting with a meager budget and…fledgling space program.

As Director or Designer you need to make decisions on short term goals in order to achieve the long terms and only then should lunar missions be attempted.  Possible short term goals could be, an orbital satellite or sending a man in space.  You must decide whether the risks of skipping milestone steps are worthwhile in order to complete your goals.  There are a lot of different directions to choose from, [so] just keep the overall picture in mind.

Success breeds confidence and more support, meaning funding and growth.  Failure can only mean setbacks and should be avoided.  Loss of life should be avoided at all costs!

**Space Hardware and R&D**

Determine which types of hardware you are going to develop in your space program.  Program and R&D costs must be evaluated carefully.  A program’s payload weight should be compared to various rocket program lift capabilities.  Compare the safety factors of various programs.  Programs that are inexpensive are generally not as reliable.  The advantage is a quick way into space.  The disadvantage is without numerous dummy tests, a catastrophe isn’t far away.  Buying expensive programs too early can trap you into a long R&D phase and your opponent ends up further ahead with more funds and better high-tech hardware.

The trick is to buy only the programs that you currently need in order to complete your current objective.  Streamline your short term goals so that some of the hardware you’re using now can be used in the later stages.  Even if some hardware is not designed for certain missions, use that hardware for other important tasks.  Timing is crucial when determining to purchase new programs.  If you purchase expensive high tech programs too early, a depleted budget limits the number of space missions with your inventory.

**To the Moon**

There are twenty [ed. note: actually, 21] different ways to send ’nauts to the moon.  It’s worthwhile to decide early on which of these approaches you prefer.  If obstacles arise that are too difficult or could delay a mission or become too costly, be flexible and adapt.  Always have contingency plans for short term goals and going to the moon.  If one program fails, there are alternative ways of completing the same goal.

Each of the…approaches to the moon can be successful.  Depending on your planning mission success and available funding, at certain times some approaches become more advantageous.  With proper wits, and a little luck, forging your own path can be just as successful.  Immediately jumping into the more advanced manned programs, such as the three-man capsule, mini-shuttle, or the four-man module, will take several years to develop with very little space flight activity in the interim.  Balancing these programs with [some successful minor prestige] programs (planetary satellites, EVAs and space duration with smaller capsules) can assist reaching victory.  Otherwise your budget can remain static and leave you behind in the race.

Sometimes, you’re going to have some tough choices when it involves cutting safety in order to beat your opponent.  Caution is always recommended.  Let the other country take the risks.  Even if they get ahead early on, it is likely that they will trip-up at some point.  If they are remarkably lucky for eight or ten years (this would be rare), only at the very end should you resort to last gap measures.  Take big risks on unmanned missions, [which] can garner some prestige points.

Be sure to build up your space endurance and docking skills in Earth orbit before attempting any ambitious lunar missions.  With careful planning, docking, LM tests and duration can all [be] achieved within several years.  But only on a good foundation of proper R&D and numerous dummy tests.

History is a good example of what to follow.  Target the easy prestige milestones first.  Try for first satellite or a manned sub-orbital or orbital.  Notice how many times the Americans and Soviets performed dummy tests on their programs before launching men into space.  It’s not necessary to follow every step through; be creative.

**REALISM**

by Fritz Bronner

As designer, I have debated the issue of realism for several years.  In this game there are images of rocket explosions, funerals, and other unpleasant events.  This footage is real and the flesh and blood of people were involved.  It includes not only national heroes, but families and friends who have lost their loved ones.  Death is indiscriminate toward nationality as the Americans and Soviets mourned their losses equally.  This simulation is meant to be historical.  It is not about war, its glorification, or nameless statistics.

My whole intention with this game is to educate children and adults about man’s early exploration of space.  The public in general is unaware of who participated in this adventure as a generation has separated current times from the Apollo decade.  Very few can name the first two men who walked on the moon and even fewer know how many Soviets and women have walked on her.  It is amazing that the public has such little knowledge of man’s greatest technological achievement: landing men on the moon.  So many names of those involved are forgotten.  Even those who tragically lost their lives are nothing but a void.

The space program is a high risk business.  A great emphasis is made on minimizing those risks, but catastrophic accidents can happen.  For the near future, going into space will never be routine like riding in an airliner.  In this simulation, the player is held responsible and accountable for the loss of life.  Safety is strongly encouraged and the player who ignores this is punished.  If this is to be a realistic simulation, the possibility of catastrophic failure must be included without sugar-coating the issue.

There are too many slick graphic games that display death with no consequences.  In this simulation, film footage of catastrophic events is not meant to take advantage of or harm the relatives and survivors of these events.  The intention is to educate [about] the sacrifices that these individuals made.  This footage exists, and is part of history.  If in any way it can inform and teach people what really happened, then I feel it is worth it.  The other choice is to let the film collect dust and history be forgotten by all.

Many speak of the trauma for the children and adults who viewed the Challenger disaster.  Yes, it was very disturbing, but they recovered and moved on as did NASA.  They had to.  If they did not, then there was no purpose in the lives that were lost.  Out of the ashes of death, a new life will emerge.

On Jan. 27, 1967, a ten-year old Cub Scout toured NASA and saw America’s proud new spacecraft, Apollo 1.  Within the hour, Grissom, Chaffe[e] and White were dead.  The boy cried, the nation mourned, and an investigation found the cause.  Out of the ashes a new standard emerged[:] a resolve for even greater safety.  Within eighteen months the Apollo spacecraft flew and shortly after, men walked on another world.  The boy also found a purpose.  Life goes on and mankind learns from its mistakes.

**MISSION DESCRIPTIONS**

<table>
  <tr>
    <td>#</td>
    <td>Mission Name</td>
    <td>Comments</td>
  </tr>
  <tr>
    <td>0</td>
    <td>None                           </td>
    <td></td>
  </tr>
  <tr>
    <td>1</td>
    <td>Orbital Satellite</td>
    <td>Typically your first space mission</td>
  </tr>
  <tr>
    <td>2</td>
    <td>Manned Suborbital</td>
    <td></td>
  </tr>
  <tr>
    <td>3</td>
    <td>Unmanned Suborbital</td>
    <td></td>
  </tr>
  <tr>
    <td>4</td>
    <td>Manned Earth Orbital</td>
    <td></td>
  </tr>
  <tr>
    <td>5</td>
    <td>Unmanned Earth Orbital</td>
    <td></td>
  </tr>
  <tr>
    <td>6</td>
    <td>Manned Orbital EVA</td>
    <td></td>
  </tr>
  <tr>
    <td>7</td>
    <td>Lunar Flyby</td>
    <td>Worth 5% lunar recon</td>
  </tr>
  <tr>
    <td>8</td>
    <td>Lunar Probe Landing</td>
    <td>Worth 15% lunar recon, 5% on failures</td>
  </tr>
  <tr>
    <td>9</td>
    <td>Venus Flyby</td>
    <td>The most worthwhile planetary flyby</td>
  </tr>
  <tr>
    <td>10</td>
    <td>Mars Flyby</td>
    <td>Takes 3 turns to arrive</td>
  </tr>
  <tr>
    <td>11</td>
    <td>Mercury Flyby</td>
    <td></td>
  </tr>
  <tr>
    <td>12</td>
    <td>Jupiter Flyby</td>
    <td>Takes 7 turns to arrive</td>
  </tr>
  <tr>
    <td>13</td>
    <td>Saturn Flyby</td>
    <td>Takes 7 turns to arrive</td>
  </tr>
  <tr>
    <td>14</td>
    <td>Manned Orbital Docking</td>
    <td></td>
  </tr>
  <tr>
    <td>15</td>
    <td>Unmanned Orbital Docking</td>
    <td></td>
  </tr>
  <tr>
    <td>16</td>
    <td>Joint Manned Orbital Docking</td>
    <td></td>
  </tr>
  <tr>
    <td>17</td>
    <td>Manned Orbital Docking (Orbit)</td>
    <td>Requires a DM already in orbit</td>
  </tr>
  <tr>
    <td>18</td>
    <td>Joint Unmanned Orbital Docking</td>
    <td></td>
  </tr>
  <tr>
    <td>19</td>
    <td>Joint Manned Orbitals Docking</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>20</td>
    <td>Manned Orbital Docking EVA</td>
    <td></td>
  </tr>
  <tr>
    <td>21</td>
    <td>Joint Manned Orbital Docking EVA</td>
    <td></td>
  </tr>
  <tr>
    <td>22</td>
    <td>Joint Manned Orbitals Docking EVA</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>23</td>
    <td>Joint Manned Orbitals Docking Joint EVA</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>24</td>
    <td>Manned Orbital Docking (Orbit) </td>
    <td>Requires a DM already in orbit</td>
  </tr>
  <tr>
    <td>25</td>
    <td>Manned Orbital Duration</td>
    <td></td>
  </tr>
  <tr>
    <td>26</td>
    <td>Manned Orbital EVA Duration</td>
    <td></td>
  </tr>
  <tr>
    <td>27</td>
    <td>Manned Orbital Docking Duration</td>
    <td></td>
  </tr>
  <tr>
    <td>28</td>
    <td>Manned Orbital Docking (Orbit) Duration</td>
    <td>Requires a DM already in orbit</td>
  </tr>
  <tr>
    <td>29</td>
    <td>Manned Orbital Docking (Orbit) EVA Duration</td>
    <td>Requires a DM already in orbit</td>
  </tr>
  <tr>
    <td>30</td>
    <td>Joint Manned Orbitals Docking EVA Duration</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>31</td>
    <td>Joint Manned Orbital Docking Duration</td>
    <td></td>
  </tr>
  <tr>
    <td>32</td>
    <td>Joint Manned Orbiting Lab</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>33</td>
    <td>Manned Orbital Docking EVA Duration</td>
    <td></td>
  </tr>
  <tr>
    <td>34</td>
    <td>Joint Manned Orbital Docking EVA Duration</td>
    <td></td>
  </tr>
  <tr>
    <td>35</td>
    <td>Joint Manned Orbitals Docking EVA Duration</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>36</td>
    <td>Joint Manned Orbiting Lab EVA</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>37</td>
    <td>Joint Manned Orbitals Docking Duration</td>
    <td>Requires two spacecraft</td>
  </tr>
  <tr>
    <td>38</td>
    <td>Manned Earth Orbital LM Test</td>
    <td>Worth 1 LM Point</td>
  </tr>
  <tr>
    <td>39</td>
    <td>Joint Manned Earth Orbital LM Test</td>
    <td>Worth 1 LM Point</td>
  </tr>
  <tr>
    <td>40</td>
    <td>Manned Earth Orbital LM Test EVA Duration</td>
    <td>Worth 1 LM Point</td>
  </tr>
  <tr>
    <td>41</td>
    <td>Joint Manned Earth Orbital LM Test EVA Duration</td>
    <td>Worth 1 LM Point</td>
  </tr>
  <tr>
    <td>42</td>
    <td>Unmanned Lunar Pass</td>
    <td>With capsule/shuttle, not probe</td>
  </tr>
  <tr>
    <td>43</td>
    <td>Manned Lunar Pass</td>
    <td>Duration C mission</td>
  </tr>
  <tr>
    <td>44</td>
    <td>Joint Manned Lunar Pass: EOR</td>
    <td></td>
  </tr>
  <tr>
    <td>45</td>
    <td>Unmanned Lunar Orbital</td>
    <td>With capsule/shuttle, not probe</td>
  </tr>
  <tr>
    <td>46</td>
    <td>Manned Lunar Orbital</td>
    <td>Duration D mission</td>
  </tr>
  <tr>
    <td>47</td>
    <td>Joint Manned Lunar Orbital: LOR</td>
    <td>Duration D mission</td>
  </tr>
  <tr>
    <td>48</td>
    <td>Manned Lunar Orbital LM Test</td>
    <td>Worth 2 LM Points</td>
  </tr>
  <tr>
    <td>49</td>
    <td>Joint Manned Lunar Orbital LM Test: LOR</td>
    <td>Worth 2 LM Points</td>
  </tr>
  <tr>
    <td>50</td>
    <td>Manned Lunar Orbital LM Test EVA</td>
    <td>Worth 2 LM Points</td>
  </tr>
  <tr>
    <td>51</td>
    <td>Joint Manned Lunar Orbital LM Test: LOR EVA</td>
    <td>Worth 2 LM Points</td>
  </tr>
  <tr>
    <td>52</td>
    <td>Joint Manned Lunar Orbital LM Test: EOR</td>
    <td>Worth 2 LM Points</td>
  </tr>
  <tr>
    <td>53</td>
    <td>Historical Manned Lunar Landing</td>
    <td>As seen on Apollos 11, 12, 14, 15, 16, & 17</td>
  </tr>
  <tr>
    <td>54</td>
    <td>Direct Ascent Lunar Landing</td>
    <td>As seen in science fiction, but bigger</td>
  </tr>
  <tr>
    <td>55</td>
    <td>Joint Lunar Landing: EOR</td>
    <td>Capsule/shuttle & LM fly to the Moon together</td>
  </tr>
  <tr>
    <td>56</td>
    <td>Joint Lunar Landing: LOR</td>
    <td>Capsule/shuttle & LM fly to the Moon separately</td>
  </tr>
  <tr>
    <td>57</td>
    <td>Soyuz Lunar Landing</td>
    <td>Soviet only; Joint mission using Soyuz with a C-Kicker</td>
  </tr>
</table>


**APPENDIX A**

**Getting Started**

Here follows a quick and dirty getting-started guide to RIS.  If you would like something more thorough, you can download the step-by-step RIS Tutorial from the Files section of Race Into Space’s Sourceforge site.

When you start the game, leave it at human player for the US and computer for the USSR.  You can change the player names if you like.  Leave yourself at difficulty level 1 and the computer at game level 3.  You might want to handicap it a bit further by also setting it to cosmonaut level 3.

**First turn:**  Go to Research & Development.  Visit the Purchasing Facility, and purchase the Atlas rocket and Explorer satellite.  Visit the R&D building and have each researched by 5 teams.  End turn.

**Second turn:**  Go to Research & Development.  Research the Atlas with 5 teams, then go to Unmanned and put as many teams as you can on the Explorer.  Now go back to the main screen and open the Administration building, then select Future Missions.  Click on Assign Future Mission next to Pad A.  Press the up arrow once, which will select the Orbital Satellite mission, and press Continue.  End turn.

**Third turn:**  You have money again!  Go to Vehicle Assembly and Assign the mission.  Go to Research & Development and research Explorer and Atlas as much as you can.  Go to Purchasing and buy the Mercury capsule, and research it as much as you can.  Schedule another Orbital Satellite mission.  End turn.

**Fourth turn:**  Assemble the satellite.  Research Explorer and Atlas until they’re at Max R&D.  Research Mercury as much as you can.  End turn.

**Fifth turn:**  Research Mercury as much as you can.  Go to the Administration building, and click on Astronaut Recruiting.  Select all the candidates with Capsule skills of 2 or higher.  Go to Administration, Future Missions, and open Pad A.  Press the up arrow three times to select Unmanned Suborbital.  Select the Mercury capsule.  End turn.

**Sixth turn:**  Assemble the Unmanned Suborbital.  Research Mercury as much as you can.  Go to the Basic Training building and withdraw two people early.  Go to the Astronaut Complex and send them to the Mercury program.  Click the Facility Transfer button, then hit the Mercury button, which will take you to that program.  Assign each of your astronauts to a crew.  Now go back to Future Missions and schedule a Manned Suborbital mission.  Select the Mercury capsule, and assign a Primary and a Backup crew.  End turn.

**Seventh turn:**  Assemble the Manned Suborbital.  Finish researching Mercury.  Click on Misc and purchase EVA Suits, and research the suits.  End turn.

Now watch your first manned mission take flight, and hope all goes well.  This should give you a basic idea of how the game works.  Remember that Mercury can only fly Orbital, EVA, and Duration B missions, so you’ll need something more sophisticated soon—so you’ll want to begin your next program in the next turn or two.  Good luck!

**APPENDIX B**

**Hardware Artwork**

*Note: The Intelligence screens move some hardware around (e.g., LMs show under Unmanned) to avoid crowding the displays.*

<table>
  <tr>
    <td>Unmanned (Satellites & Probes)

Cricket
LK
Eagle
LKM
Explorer
Sputnik
Ranger
Cosmos
Surveyor
Luna</td>
    <td></td>
  </tr>
</table>


<table>
  <tr>
    <td>Rockets

Atlas
R-7
Titan
Proton
Saturn V
N1
Nova
UR-700</td>
    <td></td>
  </tr>
</table>


<table>
  <tr>
    <td>Capsule (and Minishuttle)

Mercury
Vostok
Gemini
Voskhod
Apollo
Soyuz
XMS-2
Lapot
Jupiter
LK-700</td>
    <td></td>
  </tr>
</table>


<table>
  <tr>
    <td>Miscellaneous

US EVA suit
Soviet EVA suit
US Docking Module
Soviet Docking Module
US Strap-on Booster
Soviet Booster Stage
US Kicker-A
Soviet Kicker-A
US Kicker-B
Soviet Kicker-B
Soviet Kicker-C</td>
    <td></td>
  </tr>
</table>


**APPENDIX C**

**Quick Reference**

**Mission Abbreviations**

**D** = Docking			**E** = EVA		**L** = LM Test

**O** = Docking (Orbit)		**X** = Duration

**Minimum rocketry for common missions, **Historical Model

<table>
  <tr>
    <td>Spacecraft</td>
    <td>Orbital</td>
    <td>Docking Test</td>
    <td>LM Test</td>
  </tr>
  <tr>
    <td>Gemini</td>
    <td>B/Atlas</td>
    <td>B/Titan</td>
    <td>Saturn V</td>
  </tr>
  <tr>
    <td>Apollo</td>
    <td>B/Titan</td>
    <td>B/Titan</td>
    <td>Saturn V</td>
  </tr>
  <tr>
    <td>XMS-2</td>
    <td>B/Titan</td>
    <td>B/Titan</td>
    <td>Saturn V</td>
  </tr>
  <tr>
    <td>Voskhod</td>
    <td>B/R-7</td>
    <td>B/R-7</td>
    <td>N1</td>
  </tr>
  <tr>
    <td>Soyuz</td>
    <td>B/R-7</td>
    <td>B/Proton</td>
    <td>N1</td>
  </tr>
  <tr>
    <td>Lapot</td>
    <td>B/R-7</td>
    <td>B/Proton</td>
    <td>N1</td>
  </tr>
</table>


NOTE: The above is for Single missions; Joint missions can often use smaller rockets.

### **LIFT CAPABILITIES AND PAYLOAD WEIGHTS**

**US HARDWARE** (Historical Model)

<table>
  <tr>
    <td>Atlas</td>
    <td>500</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>Eagle</td>
    <td>1500</td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>1300</td>
    <td></td>
    <td>Mercury</td>
    <td>500</td>
    <td></td>
    <td>Cricket</td>
    <td>1100</td>
  </tr>
  <tr>
    <td>Titan</td>
    <td>1200</td>
    <td></td>
    <td>Gemini</td>
    <td>1200</td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>2000</td>
    <td></td>
    <td>Apollo</td>
    <td>1700</td>
    <td></td>
    <td>Kicker-A</td>
    <td>300</td>
  </tr>
  <tr>
    <td>Saturn V</td>
    <td>3500</td>
    <td></td>
    <td>XMS-2</td>
    <td>1400</td>
    <td></td>
    <td>Kicker-B</td>
    <td>700</td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>4300</td>
    <td></td>
    <td>Jupiter</td>
    <td>4600</td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>Nova</td>
    <td>4800</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>DM</td>
    <td>300</td>
  </tr>
</table>


**SOVIET HARDWARE** (Historical Model)

<table>
  <tr>
    <td>R-7</td>
    <td>800</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>LKM</td>
    <td>1700</td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>2000</td>
    <td></td>
    <td>Vostok</td>
    <td>700</td>
    <td></td>
    <td>LK</td>
    <td>1500</td>
  </tr>
  <tr>
    <td>Proton</td>
    <td>1900</td>
    <td></td>
    <td>Voskhod</td>
    <td>1400</td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>3100</td>
    <td></td>
    <td>Soyuz</td>
    <td>1900</td>
    <td></td>
    <td>Kicker-A</td>
    <td>500</td>
  </tr>
  <tr>
    <td>N1</td>
    <td>3900</td>
    <td></td>
    <td>Lapot</td>
    <td>1800</td>
    <td></td>
    <td>Kicker-B</td>
    <td>700</td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>5100</td>
    <td></td>
    <td>LK-700</td>
    <td>5300</td>
    <td></td>
    <td>Kicker-C</td>
    <td>3000</td>
  </tr>
  <tr>
    <td>UR-700</td>
    <td>5500</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>DM</td>
    <td>300</td>
  </tr>
</table>


**US & SOVIET HARDWARE** (Basic Model)

<table>
  <tr>
    <td>Atlas/R-7</td>
    <td>600</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>Eagle/LKM</td>
    <td>1500</td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>1600</td>
    <td></td>
    <td>Mercury/Vostok</td>
    <td>500</td>
    <td></td>
    <td>Cricket/LK</td>
    <td>1000</td>
  </tr>
  <tr>
    <td>Titan/Proton</td>
    <td>1500</td>
    <td></td>
    <td>Gemini/Voskhod</td>
    <td>1200</td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>2500</td>
    <td></td>
    <td>Apollo/Soyuz</td>
    <td>1600</td>
    <td></td>
    <td>Kicker-A</td>
    <td>300</td>
  </tr>
  <tr>
    <td>Saturn V / N1</td>
    <td>3200</td>
    <td></td>
    <td>XMS-2/Lapot</td>
    <td>4300</td>
    <td></td>
    <td>Kicker-B</td>
    <td>600</td>
  </tr>
  <tr>
    <td>  boosted</td>
    <td>4200</td>
    <td></td>
    <td>Jupiter/LK-700</td>
    <td>4300</td>
    <td></td>
    <td>Kicker-C</td>
    <td>2500</td>
  </tr>
  <tr>
    <td>Nova/UR-700</td>
    <td>4800</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>DM</td>
    <td>300</td>
  </tr>
</table>


**Peripheral Hardware Required **for various approaches to the Moon landing

<table>
  <tr>
    <td>Spacecraft</td>
    <td>Boosters</td>
    <td>Kicker-A/B</td>
    <td>Kicker-C</td>
    <td>LM</td>
    <td>DM</td>
  </tr>
  <tr>
    <td>Gemini/Voskhod</td>
    <td>Probably</td>
    <td>Yes</td>
    <td>No</td>
    <td>Cricket/LK</td>
    <td>Yes</td>
  </tr>
  <tr>
    <td>Apollo/Soyuz</td>
    <td>Probably</td>
    <td>(LOR only)</td>
    <td>No</td>
    <td>Any</td>
    <td>Yes</td>
  </tr>
  <tr>
    <td>  Soyuz Lunar Landing</td>
    <td>Yes</td>
    <td>No</td>
    <td>Yes</td>
    <td>No</td>
    <td>Yes</td>
  </tr>
  <tr>
    <td>XMS-2/Lapot</td>
    <td>Probably</td>
    <td>Yes</td>
    <td>No</td>
    <td>Any</td>
    <td>Yes</td>
  </tr>
  <tr>
    <td>Jupiter/LK-700</td>
    <td>No</td>
    <td>No</td>
    <td>No</td>
    <td>No</td>
    <td>No</td>
  </tr>
</table>


**Hardware and R&D Costs**

**Basic Model**

<table>
  <tr>
    <td>Program</td>
    <td>Cost</td>
    <td>Unit</td>
    <td>R&D</td>
    <td>Weight</td>
    <td>Payload Lift</td>
    <td>Max R&D</td>
    <td>Max Safety</td>
  </tr>
  <tr>
    <td>Explorer
Sputnik</td>
    <td>6
6</td>
    <td>1
1</td>
    <td>1
1</td>
    <td>300
300</td>
    <td>n/a
n/a</td>
    <td>95%
95%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Ranger
Cosmos</td>
    <td>24
24</td>
    <td>4
4</td>
    <td>3
3</td>
    <td>700
700</td>
    <td>n/a
n/a</td>
    <td>90%
90%</td>
    <td>93%
93%</td>
  </tr>
  <tr>
    <td>Surveyor
Luna</td>
    <td>30
30</td>
    <td>6
6</td>
    <td>4
4</td>
    <td>1200
1200</td>
    <td>n/a
n/a</td>
    <td>85%
85%</td>
    <td>88%
88%</td>
  </tr>
  <tr>
    <td>Atlas
R-7</td>
    <td>24
24</td>
    <td>3
3</td>
    <td>2
2</td>
    <td>n/a
n/a</td>
    <td>600
600</td>
    <td>84%
84%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Titan
Proton</td>
    <td>60
60</td>
    <td>12
12</td>
    <td>4
4</td>
    <td>n/a
n/a</td>
    <td>1500
1500</td>
    <td>90%
90%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Saturn V
N1</td>
    <td>84
84</td>
    <td>18
18</td>
    <td>6
6</td>
    <td>n/a
n/a</td>
    <td>3200
3200</td>
    <td>95%
95%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Nova
UR-700</td>
    <td>150
150</td>
    <td>30
30</td>
    <td>8
8</td>
    <td>n/a
n/a</td>
    <td>4800
4800</td>
    <td>95%
95%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>B. Strap-On
B. Stage</td>
    <td>12
12</td>
    <td>3
3</td>
    <td>2
2</td>
    <td>n/a
n/a</td>
    <td>1000
1000</td>
    <td>85%
85%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Mercury
Vostok</td>
    <td>18
18</td>
    <td>2
2</td>
    <td>1
1</td>
    <td>500
500</td>
    <td>n/a
n/a</td>
    <td>80%
80%</td>
    <td>90%
90%</td>
  </tr>
  <tr>
    <td>Gemini
Voskhod</td>
    <td>24
24</td>
    <td>6
6</td>
    <td>2
2</td>
    <td>1200
1200</td>
    <td>n/a
n/a</td>
    <td>84%
84%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>Apollo
Soyuz</td>
    <td>36
36</td>
    <td>12
12</td>
    <td>5
5</td>
    <td>1600
1600</td>
    <td>n/a
n/a</td>
    <td>87%
87%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>XMS-2
Lapot</td>
    <td>60
60</td>
    <td>30
30</td>
    <td>7
7</td>
    <td>1500
1500</td>
    <td>n/a
n/a</td>
    <td>91%
91%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>Jupiter
LK-700</td>
    <td>60
60</td>
    <td>30
30</td>
    <td>8
8</td>
    <td>4300
4300</td>
    <td>n/a
n/a</td>
    <td>89%
89%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>Eagle
LKM</td>
    <td>30
30</td>
    <td>8
8</td>
    <td>2
2</td>
    <td>1500
1500</td>
    <td>n/a
n/a</td>
    <td>90%
90%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>Cricket
LK</td>
    <td>42
42</td>
    <td>8
8</td>
    <td>4
4</td>
    <td>1000
1000</td>
    <td>n/a
n/a</td>
    <td>90%
90%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>US Kicker-A
Sov Kicker-A</td>
    <td>12
12</td>
    <td>3
3</td>
    <td>1
1</td>
    <td>300
300</td>
    <td>n/a
n/a</td>
    <td>94%
94%</td>
    <td>97%
97%</td>
  </tr>
  <tr>
    <td>US Kicker-B
Sov Kicker-B</td>
    <td>18
18</td>
    <td>6
6</td>
    <td>2
2</td>
    <td>600
600</td>
    <td>n/a
n/a</td>
    <td>94%
94%</td>
    <td>96%
96%</td>
  </tr>
  <tr>
    <td>Sov Kicker-C</td>
    <td>40</td>
    <td>20</td>
    <td>4</td>
    <td>2500</td>
    <td>n/a</td>
    <td>90%</td>
    <td>95%</td>
  </tr>
  <tr>
    <td>US EVA Suit
Sov EVA Suit</td>
    <td>18
18</td>
    <td>--
--</td>
    <td>1
1</td>
    <td>n/a
n/a</td>
    <td>n/a
n/a</td>
    <td>91%
91%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>US DM
Sov DM</td>
    <td>18
18</td>
    <td>2
2</td>
    <td>n/a
n/a</td>
    <td>300
300</td>
    <td>n/a
n/a</td>
    <td>n/a
n/a</td>
    <td>93%
93%</td>
  </tr>
</table>


**Historical Model**

<table>
  <tr>
    <td>Program</td>
    <td>Cost</td>
    <td>Unit</td>
    <td>R&D</td>
    <td>Weight</td>
    <td>Payload Lift</td>
    <td>Max R&D</td>
    <td>Max Safety</td>
  </tr>
  <tr>
    <td>Explorer
Sputnik</td>
    <td>6
6</td>
    <td>1
1</td>
    <td>1
1</td>
    <td>200
400</td>
    <td>n/a
n/a</td>
    <td>95%
95%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Ranger
Cosmos</td>
    <td>24
20</td>
    <td>5
3</td>
    <td>3
3</td>
    <td>700
1000</td>
    <td>n/a
n/a</td>
    <td>90%
88%</td>
    <td>93%
93%</td>
  </tr>
  <tr>
    <td>Surveyor
Luna</td>
    <td>30
26</td>
    <td>7
6</td>
    <td>4
4</td>
    <td>1200
1500</td>
    <td>n/a
n/a</td>
    <td>85%
85%</td>
    <td>88%
88%</td>
  </tr>
  <tr>
    <td>Atlas
R-7</td>
    <td>26
20</td>
    <td>3
3</td>
    <td>2
2</td>
    <td>n/a
n/a</td>
    <td>500
800</td>
    <td>87%
85%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Titan
Proton</td>
    <td>60
60</td>
    <td>12
12</td>
    <td>4
4</td>
    <td>n/a
n/a</td>
    <td>1200
1900</td>
    <td>91%
90%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Saturn V
N1</td>
    <td>90
84</td>
    <td>18
18</td>
    <td>6
7</td>
    <td>n/a
n/a</td>
    <td>3500
3900</td>
    <td>95%
93%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Nova
UR-700</td>
    <td>150
150</td>
    <td>30
30</td>
    <td>8
8</td>
    <td>n/a
n/a</td>
    <td>4800
5500</td>
    <td>94%
94%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>B. Strap-On
B. Stage</td>
    <td>18
15</td>
    <td>4
4</td>
    <td>2
2</td>
    <td>n/a
n/a</td>
    <td>800
1200</td>
    <td>85%
87%</td>
    <td>98%
98%</td>
  </tr>
  <tr>
    <td>Mercury
Vostok</td>
    <td>20
18</td>
    <td>3
3</td>
    <td>1
1</td>
    <td>500
700</td>
    <td>n/a
n/a</td>
    <td>82%
76%</td>
    <td>92%
92%</td>
  </tr>
  <tr>
    <td>Gemini
Voskhod</td>
    <td>30
24</td>
    <td>7
6</td>
    <td>2
2</td>
    <td>1200
1400</td>
    <td>n/a
n/a</td>
    <td>86%
80%</td>
    <td>94%
92%</td>
  </tr>
  <tr>
    <td>Apollo
Soyuz</td>
    <td>40
36</td>
    <td>14
12</td>
    <td>5
5</td>
    <td>1700
1900</td>
    <td>n/a
n/a</td>
    <td>89%
85%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>XMS-2
Lapot</td>
    <td>55
65</td>
    <td>30
30</td>
    <td>7
7</td>
    <td>1400
1800</td>
    <td>n/a
n/a</td>
    <td>91%
87%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>Jupiter
LK-700</td>
    <td>65
60</td>
    <td>30
30</td>
    <td>8
9</td>
    <td>4600
5300</td>
    <td>n/a
n/a</td>
    <td>89%
89%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>Eagle
LKM</td>
    <td>30
35</td>
    <td>8
8</td>
    <td>2
2</td>
    <td>1500
1700</td>
    <td>n/a
n/a</td>
    <td>90%
91%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>Cricket
LK</td>
    <td>42
48</td>
    <td>9
9</td>
    <td>4
4</td>
    <td>1100
1500</td>
    <td>n/a
n/a</td>
    <td>89%
90%</td>
    <td>94%
93%</td>
  </tr>
  <tr>
    <td>US Kicker-A
Sov Kicker-A</td>
    <td>12
12</td>
    <td>3
3</td>
    <td>1
1</td>
    <td>300
500</td>
    <td>n/a
n/a</td>
    <td>92%
91%</td>
    <td>97%
95%</td>
  </tr>
  <tr>
    <td>US Kicker-B
Sov Kicker-B</td>
    <td>18
18</td>
    <td>6
6</td>
    <td>2
2</td>
    <td>700
700</td>
    <td>n/a
n/a</td>
    <td>94%
91%</td>
    <td>97%
95%</td>
  </tr>
  <tr>
    <td>Sov Kicker-C</td>
    <td>40</td>
    <td>20</td>
    <td>4</td>
    <td>3000</td>
    <td>n/a</td>
    <td>90%</td>
    <td>94%</td>
  </tr>
  <tr>
    <td>US EVA Suit
Sov EVA Suit</td>
    <td>18
18</td>
    <td>--
--</td>
    <td>1
1</td>
    <td>n/a
n/a</td>
    <td>n/a
n/a</td>
    <td>91%
91%</td>
    <td>94%
94%</td>
  </tr>
  <tr>
    <td>US DM
Sov DM</td>
    <td>18
15</td>
    <td>3
2</td>
    <td>n/a
n/a</td>
    <td>300
300</td>
    <td>n/a
n/a</td>
    <td>n/a
n/a</td>
    <td>93%
94%</td>
  </tr>
</table>


