/*
 * Copyright (C) 2009 Google Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GOOGLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL GOOGLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "web/StorageClientImpl.h"

#include "modules/storage/StorageNamespace.h"
#include "public/platform/WebStorageNamespace.h"
#include "public/web/WebContentSettingsClient.h"
#include "public/web/WebViewClient.h"
#include "web/WebLocalFrameImpl.h"
#include "web/WebViewImpl.h"
#include "wtf/PtrUtil.h"
#include <memory>

namespace blink {

StorageClientImpl::StorageClientImpl(WebViewImpl* webView)
    : m_webView(webView) {}

std::unique_ptr<StorageNamespace>
StorageClientImpl::createSessionStorageNamespace() {
  if (!m_webView->client())
    return nullptr;
  return wrapUnique(new StorageNamespace(
      wrapUnique(m_webView->client()->createSessionStorageNamespace())));
}

bool StorageClientImpl::canAccessStorage(LocalFrame* frame,
                                         StorageType type) const {
  WebLocalFrameImpl* webFrame = WebLocalFrameImpl::fromFrame(frame);
  return !webFrame->contentSettingsClient() ||
         webFrame->contentSettingsClient()->allowStorage(type == LocalStorage);
}

}  // namespace blink
